/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.io.IOException;
import java.io.Writer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCContentValueHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;

public class OracleCLOBValueHandler
extends JDBCContentValueHandler {
    public static final OracleCLOBValueHandler INSTANCE = new OracleCLOBValueHandler();
    public static final int MAX_PART_SIZE = 2000;

    public void writeStreamValue(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DBSTypedObject type, @NotNull DBDContent object, @NotNull Writer writer) throws DBCException, IOException {
        DBDContentStorage contents = object.getContents(monitor);
        if (DBUtils.isNullValue((Object)contents)) {
            writer.write("NULL");
            return;
        }
        String strValue = ContentUtils.getContentStringValue((DBRProgressMonitor)monitor, (DBDContent)object);
        if (strValue != null) {
            String[] parts = OracleCLOBValueHandler.splitString(strValue);
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (i > 0) {
                    writer.write("||");
                }
                writer.write("TO_CLOB('");
                writer.write(part.replace("'", "''"));
                writer.write("')");
            }
        }
    }

    private static String[] splitString(String strValue) {
        int partCount = strValue.length() / 2000;
        if (strValue.length() % 2000 > 0) {
            ++partCount;
        }
        String[] parts = new String[partCount];
        for (int i = 0; i < partCount; ++i) {
            int startOffset = i * 2000;
            int endOffset = Math.min(strValue.length(), startOffset + 2000);
            parts[i] = strValue.substring(startOffset, endOffset);
        }
        return parts;
    }
}

