/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLVariable;

public class SQLContext
extends DocumentTemplateContext
implements DBPContextProvider {
    private SQLEditorBase editor;
    private Map<String, SQLVariable> variables = new HashMap<String, SQLVariable>();

    public SQLContext(TemplateContextType type, IDocument document, Position position, SQLEditorBase editor) {
        super(type, document, position);
        this.editor = editor;
    }

    public SQLEditorBase getEditor() {
        return this.editor;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.editor.getExecutionContext();
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(TemplateVariableType type, String name, int[] offsets) {
                SQLVariable variable = new SQLVariable(SQLContext.this, type, name, offsets);
                SQLContext.this.variables.put(name, variable);
                return variable;
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.formatTemplate(buffer);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    private void formatTemplate(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        String indentation = this.getIndentation();
        String content = buffer.getString();
        if (!indentation.isEmpty() && content.indexOf(10) != -1) {
            void var10_19;
            void var10_17;
            StringBuilder result = new StringBuilder();
            int nCountPlace = 0;
            for (TemplateVariable templateVariable : variables) {
                nCountPlace += templateVariable.getOffsets().length;
            }
            int[][] aVarOffset = new int[nCountPlace][3];
            nCountPlace = 0;
            for (int i2 = 0; i2 < variables.length; ++i2) {
                int[] aOffsets;
                int[] nArray = aOffsets = variables[i2].getOffsets();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int aOffset;
                    aVarOffset[nCountPlace][0] = aOffset = nArray[i];
                    aVarOffset[nCountPlace][1] = i2;
                    aVarOffset[nCountPlace][2] = aOffset;
                    ++nCountPlace;
                }
            }
            for (int i = 0; i < nCountPlace - 1; ++i) {
                for (int j = i + 1; j < nCountPlace; ++j) {
                    if (aVarOffset[i][0] <= aVarOffset[j][0]) continue;
                    int[] nArray = aVarOffset[i];
                    aVarOffset[i] = aVarOffset[j];
                    aVarOffset[j] = nArray;
                }
            }
            int iPlace = 0;
            int iSpaceLen = indentation.length();
            boolean bl = false;
            while (var10_17 < content.length()) {
                char c = content.charAt((int)var10_17);
                result.append(c);
                if (c == '\n') {
                    while (iPlace < nCountPlace && var10_17 > aVarOffset[iPlace][0]) {
                        ++iPlace;
                    }
                    for (int j = iPlace; j < nCountPlace; ++j) {
                        aVarOffset[j][2] = aVarOffset[j][2] + iSpaceLen;
                    }
                    result.append(indentation);
                }
                ++var10_17;
            }
            boolean bl2 = false;
            while (var10_19 < variables.length) {
                int[] aOffsets = variables[var10_19].getOffsets();
                int iInd = 0;
                for (int j = 0; j < nCountPlace; ++j) {
                    if (aVarOffset[j][1] != var10_19) continue;
                    aOffsets[iInd] = aVarOffset[j][2];
                    ++iInd;
                }
                ++var10_19;
            }
            buffer.setContent(result.toString(), variables);
        }
    }

    SQLVariable getTemplateVariable(String name) {
        SQLVariable variable = this.variables.get(name);
        if (variable != null && !variable.isResolved()) {
            this.getContextType().resolve((TemplateVariable)variable, (TemplateContext)this);
        }
        return variable;
    }

    Collection<SQLVariable> getVariables() {
        return this.variables.values();
    }

    private String getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            int lineIndent = start - region.getOffset();
            if (lineIndent <= 0) {
                return "";
            }
            char[] buf = new char[lineIndent];
            for (int i = 0; i < lineIndent; ++i) {
                buf[i] = 32;
            }
            return String.valueOf(buf);
        }
        catch (Exception var6) {
            return "";
        }
    }
}

