/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridHint;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridItem;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridRow;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridStatusColumn;

public interface IGridContentProvider
extends IContentProvider {
    public static final int STATE_NONE = 0;
    public static final int STATE_LINK = 1;
    public static final int STATE_HYPER_LINK = 2;
    public static final int STATE_TRANSFORMED = 4;
    public static final int STATE_TOGGLE = 8;
    public static final int STATE_DECORATED = 16;
    public static final int STATE_EXPANDED = 32;
    public static final int STATE_COLLAPSED = 64;
    public static final int STATE_BOOLEAN = 128;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;

    @NotNull
    public Object[] getElements(boolean var1);

    public boolean hasChildren(@NotNull IGridItem var1);

    @Nullable
    public Object[] getChildren(@NotNull IGridItem var1);

    public int getCollectionSize(@NotNull IGridColumn var1, @NotNull IGridRow var2);

    public int getSortOrder(@Nullable IGridColumn var1);

    public ElementState getDefaultState(@NotNull IGridColumn var1);

    public IGridStatusColumn[] getStatusColumns();

    public int getColumnPinIndex(@NotNull IGridColumn var1);

    public boolean isElementSupportsFilter(@Nullable IGridColumn var1);

    public boolean isElementSupportsSort(@Nullable IGridColumn var1);

    public boolean isElementReadOnly(@NotNull IGridColumn var1);

    public boolean isElementExpandable(@NotNull IGridItem var1);

    public boolean isGridReadOnly();

    public void validateDataPresence(IGridColumn var1, IGridRow var2);

    @NotNull
    public CellInformation getCellInfo(IGridColumn var1, IGridRow var2, boolean var3);

    public boolean isVoidCell(IGridColumn var1, IGridRow var2);

    public Object getCellValue(IGridColumn var1, IGridRow var2, boolean var3);

    @NotNull
    public String getCellLinkText(IGridColumn var1, IGridRow var2);

    public String getCellToolTip(IGridColumn var1, IGridRow var2);

    public List<IGridHint> getCellHints(IGridColumn var1, IGridRow var2, Object var3, int var4);

    public List<IGridHint> getColumnHints(IGridItem var1, int var2);

    public int getColumnHintsWidth(IGridColumn var1);

    public void resetColors();

    public static class CellInformation {
        public int state;
        public int align;
        public Font font;
        public DBPImage image;
        public Color foreground;
        public Color background;
        public Object value;
        public Object text;
    }

    public static enum ElementState {
        NONE,
        EXPANDED,
        COLLAPSED;

    }
}

