<!--- This file is autogenerated. Do not edit manually! -->
# <code>[pixi](../pixi.md) install</code>

## About
Install an environment, both updating the lockfile and installing the environment

--8<-- "docs/reference/cli/pixi/install_extender:description"

## Usage
```
pixi install [OPTIONS]
```

## Options
- <a id="arg---environment" href="#arg---environment">`--environment (-e) <ENVIRONMENT>`</a>
:  The environment to install
<br>May be provided more than once.
- <a id="arg---all" href="#arg---all">`--all (-a)`</a>
:  Install all environments
- <a id="arg---skip" href="#arg---skip">`--skip <SKIP>`</a>
:  Skip installation of specific packages present in the lockfile. This uses a soft exclusion: the package will be skipped but its dependencies are installed
<br>May be provided more than once.
- <a id="arg---skip-with-deps" href="#arg---skip-with-deps">`--skip-with-deps <SKIP_WITH_DEPS>`</a>
:  Skip a package and its entire dependency subtree. This performs a hard exclusion: the package and its dependencies are not installed unless reachable from another non-skipped root
<br>May be provided more than once.
- <a id="arg---only" href="#arg---only">`--only <ONLY>`</a>
:  Install and build only these package(s) and their dependencies. Can be passed multiple times
<br>May be provided more than once.

## Config Options
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---pinning-strategy" href="#arg---pinning-strategy">`--pinning-strategy <PINNING_STRATEGY>`</a>
:  Set pinning strategy
<br>**options**: `semver`, `minor`, `major`, `latest-up`, `exact-version`, `no-pin`
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---run-post-link-scripts" href="#arg---run-post-link-scripts">`--run-post-link-scripts`</a>
:  Run post-link scripts (insecure)
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---use-environment-activation-cache" href="#arg---use-environment-activation-cache">`--use-environment-activation-cache`</a>
:  Use environment activation cache (experimental)

## Update Options
- <a id="arg---frozen" href="#arg---frozen">`--frozen`</a>
:  Install the environment as defined in the lockfile, doesn't update lockfile if it isn't up-to-date with the manifest file
<br>**env**: `PIXI_FROZEN`
- <a id="arg---locked" href="#arg---locked">`--locked`</a>
:  Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn't up-to-date with the manifest file
<br>**env**: `PIXI_LOCKED`

## Global Options
- <a id="arg---manifest-path" href="#arg---manifest-path">`--manifest-path <MANIFEST_PATH>`</a>
:  The path to `pixi.toml`, `pyproject.toml`, or the workspace directory

## Description
Install an environment, both updating the lockfile and installing the environment.

This command installs an environment, if the lockfile is not up-to-date it will be updated.

`pixi install` only installs one environment at a time, if you have multiple environments you can select the right one with the `--environment` flag. If you don't provide an environment, the `default` environment will be installed.

If you want to install all environments, you can use the `--all` flag.

Running `pixi install` is not required before running other commands like `pixi run` or `pixi shell`. These commands will automatically install the environment if it is not already installed.

You can use `pixi reinstall` to reinstall all environments, one environment or just some packages of an environment.


--8<-- "docs/reference/cli/pixi/install_extender:example"
