
// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id: c7ea7ea7594ac56bef6aa2ca0813de99b17e8bd9 $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Copyright (C) 2006-2025 by The Odamex Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// DESCRIPTION:
//	Thing frame/state LUT,
//	generated by multigen utilitiy.
//	This one is the original DOOM version, preserved.
//
//-----------------------------------------------------------------------------


#include "odamex.h"

// Data.
#include "m_fixed.h"
#include "info.h"
#include "actor.h"

const char* doom_sprnames[::NUMSPRITES] = {
	"TROO","SHTG","PUNG","PISG","PISF","SHTF","SHT2","CHGG","CHGF","MISG",
	"MISF","SAWG","PLSG","PLSF","BFGG","BFGF","BLUD","PUFF","BAL1","BAL2",
	"PLSS","PLSE","MISL","BFS1","BFE1","BFE2","TFOG","IFOG","PLAY","POSS",
	"SPOS","VILE","FIRE","FATB","FBXP","SKEL","MANF","FATT","CPOS","SARG",
	"HEAD","BAL7","BOSS","BOS2","SKUL","SPID","BSPI","APLS","APBX","CYBR",
	"PAIN","SSWV","KEEN","BBRN","BOSF","ARM1","ARM2","BAR1","BEXP","FCAN",
	"BON1","BON2","BKEY","RKEY","YKEY","BSKU","RSKU","YSKU","STIM","MEDI",
	"SOUL","PINV","PSTR","PINS","MEGA","SUIT","PMAP","PVIS","CLIP","AMMO",
	"ROCK","BROK","CELL","CELP","SHEL","SBOX","BPAK","BFUG","MGUN","CSAW",
	"LAUN","PLAS","SHOT","SGN2","COLU","SMT2","GOR1","POL2","POL5","POL4",
	"POL3","POL1","POL6","GOR2","GOR3","GOR4","GOR5","SMIT","COL1","COL2",
	"COL3","COL4","CAND","CBRA","COL6","TRE1","TRE2","ELEC","CEYE","FSKU",
	"COL5","TBLU","TGRN","TRED","SMBT","SMGT","SMRT","HDB1","HDB2","HDB3",
	"HDB4","HDB5","HDB6","POB1","POB2","BRS1","TLMP","TLP2",

	"TNT1", // invisible sprite                                 phares 3/9/98

	"DOGS", // killough 7/19/98: Marine's best friend :)

	"PLS1", // killough 7/19/98: first  of two plasma fireballs in the beta
	"PLS2", // killough 7/19/98: second of two plasma fireballs in the beta
	"BON3", // killough 7/11/98: evil sceptre in the beta version
	"BON4", // killough 7/11/98: unholy bible in the beta version

    // [BH] blood splats, [crispy] unused
    "BLD2",
    // [BH] 100 extra sprite names to use in dehacked patches
    "SP00", "SP01", "SP02", "SP03", "SP04", "SP05", "SP06", "SP07", "SP08", "SP09",
    "SP10", "SP11", "SP12", "SP13", "SP14", "SP15", "SP16", "SP17", "SP18", "SP19",
    "SP20", "SP21", "SP22", "SP23", "SP24", "SP25", "SP26", "SP27", "SP28", "SP29",
    "SP30", "SP31", "SP32", "SP33", "SP34", "SP35", "SP36", "SP37", "SP38", "SP39",
    "SP40", "SP41", "SP42", "SP43", "SP44", "SP45", "SP46", "SP47", "SP48", "SP49",
    "SP50", "SP51", "SP52", "SP53", "SP54", "SP55", "SP56", "SP57", "SP58", "SP59",
    "SP60", "SP61", "SP62", "SP63", "SP64", "SP65", "SP66", "SP67", "SP68", "SP69",
    "SP70", "SP71", "SP72", "SP73", "SP74", "SP75", "SP76", "SP77", "SP78", "SP79",
    "SP80", "SP81", "SP82", "SP83", "SP84", "SP85", "SP86", "SP87", "SP88", "SP89",
    "SP90", "SP91", "SP92", "SP93", "SP94", "SP95", "SP96", "SP97", "SP98", "SP99"
};

class player_s;
struct pspdef_s;

// Doesn't work with g++, needs actionf_p1
void A_Light0(AActor *);
void A_WeaponReady(AActor *);
void A_Lower(AActor *);
void A_Raise(AActor *);
void A_Punch(AActor *);
void A_ReFire(AActor *);
void A_FirePistol(AActor *);
void A_Light1(AActor *);
void A_FireShotgun(AActor *);
void A_Light2(AActor *);
void A_FireShotgun2(AActor *);
void A_CheckReload(AActor *);
void A_OpenShotgun2(AActor *);
void A_LoadShotgun2(AActor *);
void A_CloseShotgun2(AActor *);
void A_FireCGun(AActor *);
void A_GunFlash(AActor *);
void A_FireMissile(AActor *);
void A_Saw(AActor *);
void A_FirePlasma(AActor *);
void A_FireRailgun(AActor *);
void A_RailWait(AActor *);
void A_BFGsound(AActor *);
void A_FireBFG(AActor *);
void A_BFGSpray(AActor*);
void A_Explode(AActor*);
void A_Pain(AActor*);
void A_PlayerScream(AActor*);
void A_Fall(AActor*);
void A_Stop(AActor*);
void A_XScream(AActor*);
void A_Look(AActor*);
void A_Chase(AActor*);
void A_FaceTarget(AActor*);
void A_PosAttack(AActor*);
void A_Scream(AActor*);
void A_Die(AActor*);
void A_SPosAttack(AActor*);
void A_VileChase(AActor*);
void A_VileStart(AActor*);
void A_VileTarget(AActor*);
void A_VileAttack(AActor*);
void A_StartFire(AActor*);
void A_Fire(AActor*);
void A_FireCrackle(AActor*);
void A_Tracer(AActor*);
void A_SkelWhoosh(AActor*);
void A_SkelFist(AActor*);
void A_SkelMissile(AActor*);
void A_FatRaise(AActor*);
void A_FatAttack1(AActor*);
void A_FatAttack2(AActor*);
void A_FatAttack3(AActor*);
void A_BossDeath(AActor*);
void A_CPosAttack(AActor*);
void A_CPosRefire(AActor*);
void A_TroopAttack(AActor*);
void A_SargAttack(AActor*);
void A_HeadAttack(AActor*);
void A_BruisAttack(AActor*);
void A_SkullAttack(AActor*);
void A_Metal(AActor*);
void A_SpidRefire(AActor*);
void A_BabyMetal(AActor*);
void A_BspiAttack(AActor*);
void A_Hoof(AActor*);
void A_CyberAttack(AActor*);
void A_PainAttack(AActor*);
void A_PainDie(AActor*);
void A_KeenDie(AActor*);
void A_BrainPain(AActor*);
void A_BrainScream(AActor*);
void A_BrainDie(AActor*);
void A_BrainAwake(AActor*);
void A_BrainSpit(AActor*);
void A_SpawnSound(AActor*);
void A_SpawnFly(AActor*);
void A_BrainExplode(AActor*);
void A_FireOldBFG(AActor*);      // killough 7/19/98: classic BFG firing function
void A_Detonate(AActor*);        // killough 8/9/98: detonate a bomb or other device
void A_Mushroom(AActor*);        // killough 10/98: mushroom effect
void A_BetaSkullAttack(AActor*); // killough 10/98: beta lost souls attacked different
void A_Ambient(AActor*);		// [RH] Play ambient sound
void A_Gibify(AActor*); // denis - squash thing

state_t	boomstates[S_MUSHROOM + 1] = {
	{ S_NULL, SPR_TROO, 0, -1, NULL, S_NULL, 0, 0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},               // S_NULL
	{ S_LIGHTDONE, SPR_SHTG,4,0,A_Light0,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_LIGHTDONE
	{ S_PUNCH, SPR_PUNG,0,1,A_WeaponReady,S_PUNCH,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PUNCH
	{ S_PUNCHDOWN, SPR_PUNG,0,1,A_Lower,S_PUNCHDOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PUNCHDOWN
	{ S_PUNCHUP, SPR_PUNG,0,1,A_Raise,S_PUNCHUP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PUNCHUP
	{ S_PUNCH1, SPR_PUNG,1,4,NULL,S_PUNCH2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},		// S_PUNCH1
	{ S_PUNCH2, SPR_PUNG,2,4,A_Punch,S_PUNCH3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PUNCH2
	{ S_PUNCH3, SPR_PUNG,3,5,NULL,S_PUNCH4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},		// S_PUNCH3
	{ S_PUNCH4, SPR_PUNG,2,4,NULL,S_PUNCH5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},		// S_PUNCH4
	{ S_PUNCH5, SPR_PUNG,1,5,A_ReFire,S_PUNCH,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PUNCH5
	{ S_PISTOL, SPR_PISG,0,1,A_WeaponReady,S_PISTOL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},// S_PISTOL
	{ S_PISTOLDOWN, SPR_PISG,0,1,A_Lower,S_PISTOLDOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PISTOLDOWN
	{ S_PISTOLUP, SPR_PISG,0,1,A_Raise,S_PISTOLUP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PISTOLUP
	{ S_PISTOL1, SPR_PISG,0,4,NULL,S_PISTOL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PISTOL1
	{ S_PISTOL2, SPR_PISG,1,6,A_FirePistol,S_PISTOL3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},// S_PISTOL2
	{ S_PISTOL3, SPR_PISG,2,4,NULL,S_PISTOL4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PISTOL3
	{ S_PISTOL4, SPR_PISG,1,5,A_ReFire,S_PISTOL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PISTOL4
	{ S_PISTOLFLASH, SPR_PISF,32768,7,A_Light1,S_LIGHTDONE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PISTOLFLASH
	{ S_SGUN, SPR_SHTG,0,1,A_WeaponReady,S_SGUN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN
	{ S_SGUNDOWN, SPR_SHTG,0,1,A_Lower,S_SGUNDOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUNDOWN
	{ S_SGUNUP, SPR_SHTG,0,1,A_Raise,S_SGUNUP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUNUP
	{ S_SGUN1, SPR_SHTG,0,3,NULL,S_SGUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN1
	{ S_SGUN2, SPR_SHTG,0,7,A_FireShotgun,S_SGUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN2
	{ S_SGUN3, SPR_SHTG,1,5,NULL,S_SGUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN3
	{ S_SGUN4, SPR_SHTG,2,5,NULL,S_SGUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN4
	{ S_SGUN5, SPR_SHTG,3,4,NULL,S_SGUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN5
	{ S_SGUN6, SPR_SHTG,2,5,NULL,S_SGUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN6
	{ S_SGUN7, SPR_SHTG,1,5,NULL,S_SGUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN7
	{ S_SGUN8, SPR_SHTG,0,3,NULL,S_SGUN9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN8
	{ S_SGUN9, SPR_SHTG,0,7,A_ReFire,S_SGUN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUN9
	{ S_SGUNFLASH1, SPR_SHTF,32768,4,A_Light1,S_SGUNFLASH2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUNFLASH1
	{ S_SGUNFLASH2, SPR_SHTF,32769,3,A_Light2,S_LIGHTDONE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SGUNFLASH2
	{ S_DSGUN, SPR_SHT2,0,1,A_WeaponReady,S_DSGUN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN
	{ S_DSGUNDOWN, SPR_SHT2,0,1,A_Lower,S_DSGUNDOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUNDOWN
	{ S_DSGUNUP, SPR_SHT2,0,1,A_Raise,S_DSGUNUP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUNUP
	{ S_DSGUN1, SPR_SHT2,0,3,NULL,S_DSGUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN1
	{ S_DSGUN2, SPR_SHT2,0,7,A_FireShotgun2,S_DSGUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN2
	{ S_DSGUN3, SPR_SHT2,1,7,NULL,S_DSGUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN3
	{ S_DSGUN4, SPR_SHT2,2,7,A_CheckReload,S_DSGUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN4
	{ S_DSGUN5, SPR_SHT2,3,7,A_OpenShotgun2,S_DSGUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN5
	{ S_DSGUN6, SPR_SHT2,4,7,NULL,S_DSGUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN6
	{ S_DSGUN7, SPR_SHT2,5,7,A_LoadShotgun2,S_DSGUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN7
	{ S_DSGUN8, SPR_SHT2,6,6,NULL,S_DSGUN9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN8
	{ S_DSGUN9, SPR_SHT2,7,6,A_CloseShotgun2,S_DSGUN10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN9
	{ S_DSGUN10, SPR_SHT2,0,5,A_ReFire,S_DSGUN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUN10
	{ S_DSNR1, SPR_SHT2,1,7,NULL,S_DSNR2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSNR1
	{ S_DSNR2, SPR_SHT2,0,3,NULL,S_DSGUNDOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSNR2
	{ S_DSGUNFLASH1, SPR_SHT2,32776,5,A_Light1,S_DSGUNFLASH2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUNFLASH1
	{ S_DSGUNFLASH2, SPR_SHT2,32777,3,A_Light2,S_LIGHTDONE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DSGUNFLASH2
	{ S_CHAIN, SPR_CHGG,0,1,A_WeaponReady,S_CHAIN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CHAIN
	{ S_CHAINDOWN, SPR_CHGG,0,1,A_Lower,S_CHAINDOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CHAINDOWN
	{ S_CHAINUP, SPR_CHGG,0,1,A_Raise,S_CHAINUP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CHAINUP
	{ S_CHAIN1, SPR_CHGG,0,4,A_FireCGun,S_CHAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CHAIN1
	{ S_CHAIN2, SPR_CHGG,1,4,A_FireCGun,S_CHAIN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CHAIN2
	{ S_CHAIN3, SPR_CHGG,1,0,A_ReFire,S_CHAIN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CHAIN3
	{ S_CHAINFLASH1, SPR_CHGF,32768,5,A_Light1,S_LIGHTDONE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CHAINFLASH1
	{ S_CHAINFLASH2, SPR_CHGF,32769,5,A_Light2,S_LIGHTDONE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CHAINFLASH2
	{ S_MISSILE, SPR_MISG,0,1,A_WeaponReady,S_MISSILE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILE
	{ S_MISSILEDOWN, SPR_MISG,0,1,A_Lower,S_MISSILEDOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILEDOWN
	{ S_MISSILEUP, SPR_MISG,0,1,A_Raise,S_MISSILEUP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILEUP
	{ S_MISSILE1, SPR_MISG,1,8,A_GunFlash,S_MISSILE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILE1
	{ S_MISSILE2, SPR_MISG,1,12,A_FireMissile,S_MISSILE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILE2
	{ S_MISSILE3, SPR_MISG,1,0,A_ReFire,S_MISSILE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILE3
	{ S_MISSILEFLASH1, SPR_MISF,32768,3,A_Light1,S_MISSILEFLASH2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILEFLASH1
	{ S_MISSILEFLASH2, SPR_MISF,32769,4,NULL,S_MISSILEFLASH3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILEFLASH2
	{ S_MISSILEFLASH3, SPR_MISF,32770,4,A_Light2,S_MISSILEFLASH4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILEFLASH3
	{ S_MISSILEFLASH4, SPR_MISF,32771,4,A_Light2,S_LIGHTDONE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MISSILEFLASH4
	{ S_SAW, SPR_SAWG,2,4,A_WeaponReady,S_SAWB,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SAW
	{ S_SAWB, SPR_SAWG,3,4,A_WeaponReady,S_SAW,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SAWB
	{ S_SAWDOWN, SPR_SAWG,2,1,A_Lower,S_SAWDOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SAWDOWN
	{ S_SAWUP, SPR_SAWG,2,1,A_Raise,S_SAWUP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SAWUP
	{ S_SAW1, SPR_SAWG,0,4,A_Saw,S_SAW2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SAW1
	{ S_SAW2, SPR_SAWG,1,4,A_Saw,S_SAW3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SAW2
	{ S_SAW3, SPR_SAWG,1,0,A_ReFire,S_SAW,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SAW3
	{ S_PLASMA, SPR_PLSG,0,1,A_WeaponReady,S_PLASMA,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASMA
	{ S_PLASMADOWN, SPR_PLSG,0,1,A_Lower,S_PLASMADOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASMADOWN
	{ S_PLASMAUP, SPR_PLSG,0,1,A_Raise,S_PLASMAUP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASMAUP
	{ S_PLASMA1, SPR_PLSG,0,3,A_FirePlasma,S_PLASMA2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASMA1
	{ S_PLASMA2, SPR_PLSG,1,20,A_ReFire,S_PLASMA,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASMA2
	{ S_PLASMAFLASH1, SPR_PLSF,32768,4,A_Light1,S_LIGHTDONE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASMAFLASH1
	{ S_PLASMAFLASH2, SPR_PLSF,32769,4,A_Light1,S_LIGHTDONE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASMAFLASH2
	{ S_BFG, SPR_BFGG,0,1,A_WeaponReady,S_BFG,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFG
	{ S_BFGDOWN, SPR_BFGG,0,1,A_Lower,S_BFGDOWN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGDOWN
	{ S_BFGUP, SPR_BFGG,0,1,A_Raise,S_BFGUP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGUP
	{ S_BFG1, SPR_BFGG,0,20,A_BFGsound,S_BFG2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFG1
	{ S_BFG2, SPR_BFGG,1,10,A_GunFlash,S_BFG3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFG2
	{ S_BFG3, SPR_BFGG,1,10,A_FireBFG,S_BFG4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFG3
	{ S_BFG4, SPR_BFGG,1,20,A_ReFire,S_BFG,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFG4
	{ S_BFGFLASH1, SPR_BFGF,32768,11,A_Light1,S_BFGFLASH2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGFLASH1
	{ S_BFGFLASH2, SPR_BFGF,32769,6,A_Light2,S_LIGHTDONE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGFLASH2
	{ S_BLOOD1, SPR_BLUD,2,8,NULL,S_BLOOD2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLOOD1
	{ S_BLOOD2, SPR_BLUD,1,8,NULL,S_BLOOD3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLOOD2
	{ S_BLOOD3, SPR_BLUD,0,8,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLOOD3
	{ S_PUFF1, SPR_PUFF,32768,4,NULL,S_PUFF2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PUFF1
	{ S_PUFF2, SPR_PUFF,1,4,NULL,S_PUFF3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PUFF2
	{ S_PUFF3, SPR_PUFF,2,4,NULL,S_PUFF4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PUFF3
	{ S_PUFF4, SPR_PUFF,3,4,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PUFF4
	{ S_TBALL1, SPR_BAL1,32768,4,NULL,S_TBALL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TBALL1
	{ S_TBALL2, SPR_BAL1,32769,4,NULL,S_TBALL1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TBALL2
	{ S_TBALLX1, SPR_BAL1,32770,6,NULL,S_TBALLX2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TBALLX1
	{ S_TBALLX2, SPR_BAL1,32771,6,NULL,S_TBALLX3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TBALLX2
	{ S_TBALLX3, SPR_BAL1,32772,6,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TBALLX3
	{ S_RBALL1, SPR_BAL2,32768,4,NULL,S_RBALL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RBALL1
	{ S_RBALL2, SPR_BAL2,32769,4,NULL,S_RBALL1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RBALL2
	{ S_RBALLX1, SPR_BAL2,32770,6,NULL,S_RBALLX2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RBALLX1
	{ S_RBALLX2, SPR_BAL2,32771,6,NULL,S_RBALLX3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RBALLX2
	{ S_RBALLX3, SPR_BAL2,32772,6,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RBALLX3
	{ S_PLASBALL, SPR_PLSS,32768,6,NULL,S_PLASBALL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASBALL
	{ S_PLASBALL2, SPR_PLSS,32769,6,NULL,S_PLASBALL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASBALL2
	{ S_PLASEXP, SPR_PLSE,32768,4,NULL,S_PLASEXP2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASEXP
	{ S_PLASEXP2, SPR_PLSE,32769,4,NULL,S_PLASEXP3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASEXP2
	{ S_PLASEXP3, SPR_PLSE,32770,4,NULL,S_PLASEXP4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASEXP3
	{ S_PLASEXP4, SPR_PLSE,32771,4,NULL,S_PLASEXP5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASEXP4
	{ S_PLASEXP5, SPR_PLSE,32772,4,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLASEXP5
	{ S_ROCKET, SPR_MISL,32768,1,NULL,S_ROCKET,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ROCKET
	{ S_BFGSHOT, SPR_BFS1,32768,4,NULL,S_BFGSHOT2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGSHOT
	{ S_BFGSHOT2, SPR_BFS1,32769,4,NULL,S_BFGSHOT,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGSHOT2
	{ S_BFGLAND, SPR_BFE1,32768,8,NULL,S_BFGLAND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGLAND
	{ S_BFGLAND2, SPR_BFE1,32769,8,NULL,S_BFGLAND3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGLAND2
	{ S_BFGLAND3, SPR_BFE1,32770,8,A_BFGSpray,S_BFGLAND4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGLAND3
	{ S_BFGLAND4, SPR_BFE1,32771,8,NULL,S_BFGLAND5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGLAND4
	{ S_BFGLAND5, SPR_BFE1,32772,8,NULL,S_BFGLAND6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGLAND5
	{ S_BFGLAND6, SPR_BFE1,32773,8,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGLAND6
	{ S_BFGEXP, SPR_BFE2,32768,8,NULL,S_BFGEXP2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGEXP
	{ S_BFGEXP2, SPR_BFE2,32769,8,NULL,S_BFGEXP3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGEXP2
	{ S_BFGEXP3, SPR_BFE2,32770,8,NULL,S_BFGEXP4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGEXP3
	{ S_BFGEXP4, SPR_BFE2,32771,8,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFGEXP4
	{ S_EXPLODE1, SPR_MISL,32769,8,A_Explode,S_EXPLODE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_EXPLODE1
	{ S_EXPLODE2, SPR_MISL,32770,6,NULL,S_EXPLODE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_EXPLODE2
	{ S_EXPLODE3, SPR_MISL,32771,4,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_EXPLODE3
	{ S_TFOG, SPR_TFOG,32768,6,NULL,S_TFOG01,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG
	{ S_TFOG01, SPR_TFOG,32769,6,NULL,S_TFOG02,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG01
	{ S_TFOG02, SPR_TFOG,32768,6,NULL,S_TFOG2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG02
	{ S_TFOG2, SPR_TFOG,32769,6,NULL,S_TFOG3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG2
	{ S_TFOG3, SPR_TFOG,32770,6,NULL,S_TFOG4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG3
	{ S_TFOG4, SPR_TFOG,32771,6,NULL,S_TFOG5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG4
	{ S_TFOG5, SPR_TFOG,32772,6,NULL,S_TFOG6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG5
	{ S_TFOG6, SPR_TFOG,32773,6,NULL,S_TFOG7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG6
	{ S_TFOG7, SPR_TFOG,32774,6,NULL,S_TFOG8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG7
	{ S_TFOG8, SPR_TFOG,32775,6,NULL,S_TFOG9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG8
	{ S_TFOG9, SPR_TFOG,32776,6,NULL,S_TFOG10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG9
	{ S_TFOG10, SPR_TFOG,32777,6,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TFOG10
	{ S_IFOG, SPR_IFOG,32768,6,NULL,S_IFOG01,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_IFOG
	{ S_IFOG01, SPR_IFOG,32769,6,NULL,S_IFOG02,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_IFOG01
	{ S_IFOG02, SPR_IFOG,32768,6,NULL,S_IFOG2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_IFOG02
	{ S_IFOG2, SPR_IFOG,32769,6,NULL,S_IFOG3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_IFOG2
	{ S_IFOG3, SPR_IFOG,32770,6,NULL,S_IFOG4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_IFOG3
	{ S_IFOG4, SPR_IFOG,32771,6,NULL,S_IFOG5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_IFOG4
	{ S_IFOG5, SPR_IFOG,32772,6,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_IFOG5
	{ S_PLAY, SPR_PLAY,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY
	{ S_PLAY_RUN1, SPR_PLAY,0,4,NULL,S_PLAY_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_RUN1
	{ S_PLAY_RUN2, SPR_PLAY,1,4,NULL,S_PLAY_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_RUN2
	{ S_PLAY_RUN3, SPR_PLAY,2,4,NULL,S_PLAY_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_RUN3
	{ S_PLAY_RUN4, SPR_PLAY,3,4,NULL,S_PLAY_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_RUN4
	{ S_PLAY_ATK1, SPR_PLAY,4,12,NULL,S_PLAY,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_ATK1
	{ S_PLAY_ATK2, SPR_PLAY,32773,6,NULL,S_PLAY_ATK1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_ATK2
	{ S_PLAY_PAIN, SPR_PLAY,6,4,NULL,S_PLAY_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_PAIN
	{ S_PLAY_PAIN2, SPR_PLAY,6,4,A_Pain,S_PLAY,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_PAIN2
	{ S_PLAY_DIE1, SPR_PLAY,7,10,NULL,S_PLAY_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_DIE1
	{ S_PLAY_DIE2, SPR_PLAY,8,10,A_PlayerScream,S_PLAY_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_DIE2
	{ S_PLAY_DIE3, SPR_PLAY,9,10,A_Fall,S_PLAY_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_DIE3
	{ S_PLAY_DIE4, SPR_PLAY,10,10,NULL,S_PLAY_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_DIE4
	{ S_PLAY_DIE5, SPR_PLAY,11,10,NULL,S_PLAY_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_DIE5
	{ S_PLAY_DIE6, SPR_PLAY,12,10,NULL,S_PLAY_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_DIE6
	{ S_PLAY_DIE7, SPR_PLAY,13,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_DIE7
	{ S_PLAY_XDIE1, SPR_PLAY,14,5,NULL,S_PLAY_XDIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_XDIE1
	{ S_PLAY_XDIE2, SPR_PLAY,15,5,A_XScream,S_PLAY_XDIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_XDIE2
	{ S_PLAY_XDIE3, SPR_PLAY,16,5,A_Fall,S_PLAY_XDIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_XDIE3
	{ S_PLAY_XDIE4, SPR_PLAY,17,5,NULL,S_PLAY_XDIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_XDIE4
	{ S_PLAY_XDIE5, SPR_PLAY,18,5,NULL,S_PLAY_XDIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_XDIE5
	{ S_PLAY_XDIE6, SPR_PLAY,19,5,NULL,S_PLAY_XDIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_XDIE6
	{ S_PLAY_XDIE7, SPR_PLAY,20,5,NULL,S_PLAY_XDIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_XDIE7
	{ S_PLAY_XDIE8, SPR_PLAY,21,5,NULL,S_PLAY_XDIE9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_XDIE8
	{ S_PLAY_XDIE9, SPR_PLAY,22,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAY_XDIE9
	{ S_POSS_STND, SPR_POSS,0,10,A_Look,S_POSS_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_STND
	{ S_POSS_STND2, SPR_POSS,1,10,A_Look,S_POSS_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_STND2
	{ S_POSS_RUN1, SPR_POSS,0,4,A_Chase,S_POSS_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RUN1
	{ S_POSS_RUN2, SPR_POSS,0,4,A_Chase,S_POSS_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RUN2
	{ S_POSS_RUN3, SPR_POSS,1,4,A_Chase,S_POSS_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RUN3
	{ S_POSS_RUN4, SPR_POSS,1,4,A_Chase,S_POSS_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RUN4
	{ S_POSS_RUN5, SPR_POSS,2,4,A_Chase,S_POSS_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RUN5
	{ S_POSS_RUN6, SPR_POSS,2,4,A_Chase,S_POSS_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RUN6
	{ S_POSS_RUN7, SPR_POSS,3,4,A_Chase,S_POSS_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RUN7
	{ S_POSS_RUN8, SPR_POSS,3,4,A_Chase,S_POSS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RUN8
	{ S_POSS_ATK1, SPR_POSS,4,10,A_FaceTarget,S_POSS_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_ATK1
	{ S_POSS_ATK2, SPR_POSS,5,8,A_PosAttack,S_POSS_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_ATK2
	{ S_POSS_ATK3, SPR_POSS,4,8,NULL,S_POSS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_ATK3
	{ S_POSS_PAIN, SPR_POSS,6,3,NULL,S_POSS_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_PAIN
	{ S_POSS_PAIN2, SPR_POSS,6,3,A_Pain,S_POSS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_PAIN2
	{ S_POSS_DIE1, SPR_POSS,7,5,NULL,S_POSS_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_DIE1
	{ S_POSS_DIE2, SPR_POSS,8,5,A_Scream,S_POSS_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_DIE2
	{ S_POSS_DIE3, SPR_POSS,9,5,A_Fall,S_POSS_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_DIE3
	{ S_POSS_DIE4, SPR_POSS,10,5,NULL,S_POSS_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_DIE4
	{ S_POSS_DIE5, SPR_POSS,11,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_DIE5
	{ S_POSS_XDIE1, SPR_POSS,12,5,NULL,S_POSS_XDIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_XDIE1
	{ S_POSS_XDIE2, SPR_POSS,13,5,A_XScream,S_POSS_XDIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_XDIE2
	{ S_POSS_XDIE3, SPR_POSS,14,5,A_Fall,S_POSS_XDIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_XDIE3
	{ S_POSS_XDIE4, SPR_POSS,15,5,NULL,S_POSS_XDIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_XDIE4
	{ S_POSS_XDIE5, SPR_POSS,16,5,NULL,S_POSS_XDIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_XDIE5
	{ S_POSS_XDIE6, SPR_POSS,17,5,NULL,S_POSS_XDIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_XDIE6
	{ S_POSS_XDIE7, SPR_POSS,18,5,NULL,S_POSS_XDIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_XDIE7
	{ S_POSS_XDIE8, SPR_POSS,19,5,NULL,S_POSS_XDIE9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_XDIE8
	{ S_POSS_XDIE9, SPR_POSS,20,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_XDIE9
	{ S_POSS_RAISE1, SPR_POSS,10,5,NULL,S_POSS_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RAISE1
	{ S_POSS_RAISE2, SPR_POSS,9,5,NULL,S_POSS_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RAISE2
	{ S_POSS_RAISE3, SPR_POSS,8,5,NULL,S_POSS_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RAISE3
	{ S_POSS_RAISE4, SPR_POSS,7,5,NULL,S_POSS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_POSS_RAISE4
	{ S_SPOS_STND, SPR_SPOS,0,10,A_Look,S_SPOS_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_STND
	{ S_SPOS_STND2, SPR_SPOS,1,10,A_Look,S_SPOS_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_STND2
	{ S_SPOS_RUN1, SPR_SPOS,0,3,A_Chase,S_SPOS_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RUN1
	{ S_SPOS_RUN2, SPR_SPOS,0,3,A_Chase,S_SPOS_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RUN2
	{ S_SPOS_RUN3, SPR_SPOS,1,3,A_Chase,S_SPOS_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RUN3
	{ S_SPOS_RUN4, SPR_SPOS,1,3,A_Chase,S_SPOS_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RUN4
	{ S_SPOS_RUN5, SPR_SPOS,2,3,A_Chase,S_SPOS_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RUN5
	{ S_SPOS_RUN6, SPR_SPOS,2,3,A_Chase,S_SPOS_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RUN6
	{ S_SPOS_RUN7, SPR_SPOS,3,3,A_Chase,S_SPOS_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RUN7
	{ S_SPOS_RUN8, SPR_SPOS,3,3,A_Chase,S_SPOS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RUN8
	{ S_SPOS_ATK1, SPR_SPOS,4,10,A_FaceTarget,S_SPOS_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_ATK1
	{ S_SPOS_ATK2, SPR_SPOS,32773,10,A_SPosAttack,S_SPOS_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_ATK2
	{ S_SPOS_ATK3, SPR_SPOS,4,10,NULL,S_SPOS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_ATK3
	{ S_SPOS_PAIN, SPR_SPOS,6,3,NULL,S_SPOS_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_PAIN
	{ S_SPOS_PAIN2, SPR_SPOS,6,3,A_Pain,S_SPOS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_PAIN2
	{ S_SPOS_DIE1, SPR_SPOS,7,5,NULL,S_SPOS_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_DIE1
	{ S_SPOS_DIE2, SPR_SPOS,8,5,A_Scream,S_SPOS_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_DIE2
	{ S_SPOS_DIE3, SPR_SPOS,9,5,A_Fall,S_SPOS_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_DIE3
	{ S_SPOS_DIE4, SPR_SPOS,10,5,NULL,S_SPOS_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_DIE4
	{ S_SPOS_DIE5, SPR_SPOS,11,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_DIE5
	{ S_SPOS_XDIE1, SPR_SPOS,12,5,NULL,S_SPOS_XDIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_XDIE1
	{ S_SPOS_XDIE2, SPR_SPOS,13,5,A_XScream,S_SPOS_XDIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_XDIE2
	{ S_SPOS_XDIE3, SPR_SPOS,14,5,A_Fall,S_SPOS_XDIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_XDIE3
	{ S_SPOS_XDIE4, SPR_SPOS,15,5,NULL,S_SPOS_XDIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_XDIE4
	{ S_SPOS_XDIE5, SPR_SPOS,16,5,NULL,S_SPOS_XDIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_XDIE5
	{ S_SPOS_XDIE6, SPR_SPOS,17,5,NULL,S_SPOS_XDIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_XDIE6
	{ S_SPOS_XDIE7, SPR_SPOS,18,5,NULL,S_SPOS_XDIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_XDIE7
	{ S_SPOS_XDIE8, SPR_SPOS,19,5,NULL,S_SPOS_XDIE9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_XDIE8
	{ S_SPOS_XDIE9, SPR_SPOS,20,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_XDIE9
	{ S_SPOS_RAISE1, SPR_SPOS,11,5,NULL,S_SPOS_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RAISE1
	{ S_SPOS_RAISE2, SPR_SPOS,10,5,NULL,S_SPOS_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RAISE2
	{ S_SPOS_RAISE3, SPR_SPOS,9,5,NULL,S_SPOS_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RAISE3
	{ S_SPOS_RAISE4, SPR_SPOS,8,5,NULL,S_SPOS_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RAISE4
	{ S_SPOS_RAISE5, SPR_SPOS,7,5,NULL,S_SPOS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPOS_RAISE5
	{ S_VILE_STND, SPR_VILE,0,10,A_Look,S_VILE_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_STND
	{ S_VILE_STND2, SPR_VILE,1,10,A_Look,S_VILE_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_STND2
	{ S_VILE_RUN1, SPR_VILE,0,2,A_VileChase,S_VILE_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN1
	{ S_VILE_RUN2, SPR_VILE,0,2,A_VileChase,S_VILE_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN2
	{ S_VILE_RUN3, SPR_VILE,1,2,A_VileChase,S_VILE_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN3
	{ S_VILE_RUN4, SPR_VILE,1,2,A_VileChase,S_VILE_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN4
	{ S_VILE_RUN5, SPR_VILE,2,2,A_VileChase,S_VILE_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN5
	{ S_VILE_RUN6, SPR_VILE,2,2,A_VileChase,S_VILE_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN6
	{ S_VILE_RUN7, SPR_VILE,3,2,A_VileChase,S_VILE_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN7
	{ S_VILE_RUN8, SPR_VILE,3,2,A_VileChase,S_VILE_RUN9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN8
	{ S_VILE_RUN9, SPR_VILE,4,2,A_VileChase,S_VILE_RUN10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN9
	{ S_VILE_RUN10, SPR_VILE,4,2,A_VileChase,S_VILE_RUN11,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN10
	{ S_VILE_RUN11, SPR_VILE,5,2,A_VileChase,S_VILE_RUN12,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN11
	{ S_VILE_RUN12, SPR_VILE,5,2,A_VileChase,S_VILE_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_RUN12
	{ S_VILE_ATK1, SPR_VILE,32774,0,A_VileStart,S_VILE_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK1
	{ S_VILE_ATK2, SPR_VILE,32774,10,A_FaceTarget,S_VILE_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK2
	{ S_VILE_ATK3, SPR_VILE,32775,8,A_VileTarget,S_VILE_ATK4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK3
	{ S_VILE_ATK4, SPR_VILE,32776,8,A_FaceTarget,S_VILE_ATK5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK4
	{ S_VILE_ATK5, SPR_VILE,32777,8,A_FaceTarget,S_VILE_ATK6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK5
	{ S_VILE_ATK6, SPR_VILE,32778,8,A_FaceTarget,S_VILE_ATK7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK6
	{ S_VILE_ATK7, SPR_VILE,32779,8,A_FaceTarget,S_VILE_ATK8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK7
	{ S_VILE_ATK8, SPR_VILE,32780,8,A_FaceTarget,S_VILE_ATK9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK8
	{ S_VILE_ATK9, SPR_VILE,32781,8,A_FaceTarget,S_VILE_ATK10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK9
	{ S_VILE_ATK10, SPR_VILE,32782,8,A_VileAttack,S_VILE_ATK11,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK10
	{ S_VILE_ATK11, SPR_VILE,32783,20,NULL,S_VILE_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_ATK11
	{ S_VILE_HEAL1, SPR_VILE,32794,10,NULL,S_VILE_HEAL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_HEAL1
	{ S_VILE_HEAL2, SPR_VILE,32795,10,NULL,S_VILE_HEAL3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_HEAL2
	{ S_VILE_HEAL3, SPR_VILE,32796,10,NULL,S_VILE_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_HEAL3
	{ S_VILE_PAIN, SPR_VILE,16,5,NULL,S_VILE_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_PAIN
	{ S_VILE_PAIN2, SPR_VILE,16,5,A_Pain,S_VILE_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_PAIN2
	{ S_VILE_DIE1, SPR_VILE,16,7,NULL,S_VILE_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE1
	{ S_VILE_DIE2, SPR_VILE,17,7,A_Scream,S_VILE_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE2
	{ S_VILE_DIE3, SPR_VILE,18,7,A_Fall,S_VILE_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE3
	{ S_VILE_DIE4, SPR_VILE,19,7,NULL,S_VILE_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE4
	{ S_VILE_DIE5, SPR_VILE,20,7,NULL,S_VILE_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE5
	{ S_VILE_DIE6, SPR_VILE,21,7,NULL,S_VILE_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE6
	{ S_VILE_DIE7, SPR_VILE,22,7,NULL,S_VILE_DIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE7
	{ S_VILE_DIE8, SPR_VILE,23,5,NULL,S_VILE_DIE9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE8
	{ S_VILE_DIE9, SPR_VILE,24,5,NULL,S_VILE_DIE10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE9
	{ S_VILE_DIE10, SPR_VILE,25,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_VILE_DIE10
	{ S_FIRE1, SPR_FIRE,32768,2,A_StartFire,S_FIRE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE1
	{ S_FIRE2, SPR_FIRE,32769,2,A_Fire,S_FIRE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE2
	{ S_FIRE3, SPR_FIRE,32768,2,A_Fire,S_FIRE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE3
	{ S_FIRE4, SPR_FIRE,32769,2,A_Fire,S_FIRE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE4
	{ S_FIRE5, SPR_FIRE,32770,2,A_FireCrackle,S_FIRE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE5
	{ S_FIRE6, SPR_FIRE,32769,2,A_Fire,S_FIRE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE6
	{ S_FIRE7, SPR_FIRE,32770,2,A_Fire,S_FIRE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE7
	{ S_FIRE8, SPR_FIRE,32769,2,A_Fire,S_FIRE9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE8
	{ S_FIRE9, SPR_FIRE,32770,2,A_Fire,S_FIRE10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE9
	{ S_FIRE10, SPR_FIRE,32771,2,A_Fire,S_FIRE11,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE10
	{ S_FIRE11, SPR_FIRE,32770,2,A_Fire,S_FIRE12,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE11
	{ S_FIRE12, SPR_FIRE,32771,2,A_Fire,S_FIRE13,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE12
	{ S_FIRE13, SPR_FIRE,32770,2,A_Fire,S_FIRE14,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE13
	{ S_FIRE14, SPR_FIRE,32771,2,A_Fire,S_FIRE15,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE14
	{ S_FIRE15, SPR_FIRE,32772,2,A_Fire,S_FIRE16,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE15
	{ S_FIRE16, SPR_FIRE,32771,2,A_Fire,S_FIRE17,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE16
	{ S_FIRE17, SPR_FIRE,32772,2,A_Fire,S_FIRE18,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE17
	{ S_FIRE18, SPR_FIRE,32771,2,A_Fire,S_FIRE19,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE18
	{ S_FIRE19, SPR_FIRE,32772,2,A_FireCrackle,S_FIRE20,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE19
	{ S_FIRE20, SPR_FIRE,32773,2,A_Fire,S_FIRE21,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE20
	{ S_FIRE21, SPR_FIRE,32772,2,A_Fire,S_FIRE22,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE21
	{ S_FIRE22, SPR_FIRE,32773,2,A_Fire,S_FIRE23,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE22
	{ S_FIRE23, SPR_FIRE,32772,2,A_Fire,S_FIRE24,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE23
	{ S_FIRE24, SPR_FIRE,32773,2,A_Fire,S_FIRE25,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE24
	{ S_FIRE25, SPR_FIRE,32774,2,A_Fire,S_FIRE26,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE25
	{ S_FIRE26, SPR_FIRE,32775,2,A_Fire,S_FIRE27,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE26
	{ S_FIRE27, SPR_FIRE,32774,2,A_Fire,S_FIRE28,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE27
	{ S_FIRE28, SPR_FIRE,32775,2,A_Fire,S_FIRE29,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE28
	{ S_FIRE29, SPR_FIRE,32774,2,A_Fire,S_FIRE30,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE29
	{ S_FIRE30, SPR_FIRE,32775,2,A_Fire,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FIRE30
	{ S_SMOKE1, SPR_PUFF,1,4,NULL,S_SMOKE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SMOKE1
	{ S_SMOKE2, SPR_PUFF,2,4,NULL,S_SMOKE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SMOKE2
	{ S_SMOKE3, SPR_PUFF,1,4,NULL,S_SMOKE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SMOKE3
	{ S_SMOKE4, SPR_PUFF,2,4,NULL,S_SMOKE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SMOKE4
	{ S_SMOKE5, SPR_PUFF,3,4,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SMOKE5
	{ S_TRACER, SPR_FATB,32768,2,A_Tracer,S_TRACER2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TRACER
	{ S_TRACER2, SPR_FATB,32769,2,A_Tracer,S_TRACER,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TRACER2
	{ S_TRACEEXP1, SPR_FBXP,32768,8,NULL,S_TRACEEXP2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TRACEEXP1
	{ S_TRACEEXP2, SPR_FBXP,32769,6,NULL,S_TRACEEXP3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TRACEEXP2
	{ S_TRACEEXP3, SPR_FBXP,32770,4,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TRACEEXP3
	{ S_SKEL_STND, SPR_SKEL,0,10,A_Look,S_SKEL_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_STND
	{ S_SKEL_STND2, SPR_SKEL,1,10,A_Look,S_SKEL_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_STND2
	{ S_SKEL_RUN1, SPR_SKEL,0,2,A_Chase,S_SKEL_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN1
	{ S_SKEL_RUN2, SPR_SKEL,0,2,A_Chase,S_SKEL_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN2
	{ S_SKEL_RUN3, SPR_SKEL,1,2,A_Chase,S_SKEL_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN3
	{ S_SKEL_RUN4, SPR_SKEL,1,2,A_Chase,S_SKEL_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN4
	{ S_SKEL_RUN5, SPR_SKEL,2,2,A_Chase,S_SKEL_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN5
	{ S_SKEL_RUN6, SPR_SKEL,2,2,A_Chase,S_SKEL_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN6
	{ S_SKEL_RUN7, SPR_SKEL,3,2,A_Chase,S_SKEL_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN7
	{ S_SKEL_RUN8, SPR_SKEL,3,2,A_Chase,S_SKEL_RUN9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN8
	{ S_SKEL_RUN9, SPR_SKEL,4,2,A_Chase,S_SKEL_RUN10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN9
	{ S_SKEL_RUN10, SPR_SKEL,4,2,A_Chase,S_SKEL_RUN11,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN10
	{ S_SKEL_RUN11, SPR_SKEL,5,2,A_Chase,S_SKEL_RUN12,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN11
	{ S_SKEL_RUN12, SPR_SKEL,5,2,A_Chase,S_SKEL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RUN12
	{ S_SKEL_FIST1, SPR_SKEL,6,0,A_FaceTarget,S_SKEL_FIST2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_FIST1
	{ S_SKEL_FIST2, SPR_SKEL,6,6,A_SkelWhoosh,S_SKEL_FIST3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_FIST2
	{ S_SKEL_FIST3, SPR_SKEL,7,6,A_FaceTarget,S_SKEL_FIST4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_FIST3
	{ S_SKEL_FIST4, SPR_SKEL,8,6,A_SkelFist,S_SKEL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_FIST4
	{ S_SKEL_MISS1, SPR_SKEL,32777,0,A_FaceTarget,S_SKEL_MISS2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_MISS1
	{ S_SKEL_MISS2, SPR_SKEL,32777,10,A_FaceTarget,S_SKEL_MISS3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_MISS2
	{ S_SKEL_MISS3, SPR_SKEL,10,10,A_SkelMissile,S_SKEL_MISS4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_MISS3
	{ S_SKEL_MISS4, SPR_SKEL,10,10,A_FaceTarget,S_SKEL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_MISS4
	{ S_SKEL_PAIN, SPR_SKEL,11,5,NULL,S_SKEL_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_PAIN
	{ S_SKEL_PAIN2, SPR_SKEL,11,5,A_Pain,S_SKEL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_PAIN2
	{ S_SKEL_DIE1, SPR_SKEL,11,7,NULL,S_SKEL_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_DIE1
	{ S_SKEL_DIE2, SPR_SKEL,12,7,NULL,S_SKEL_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_DIE2
	{ S_SKEL_DIE3, SPR_SKEL,13,7,A_Scream,S_SKEL_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_DIE3
	{ S_SKEL_DIE4, SPR_SKEL,14,7,A_Fall,S_SKEL_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_DIE4
	{ S_SKEL_DIE5, SPR_SKEL,15,7,NULL,S_SKEL_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_DIE5
	{ S_SKEL_DIE6, SPR_SKEL,16,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_DIE6
	{ S_SKEL_RAISE1, SPR_SKEL,16,5,NULL,S_SKEL_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RAISE1
	{ S_SKEL_RAISE2, SPR_SKEL,15,5,NULL,S_SKEL_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RAISE2
	{ S_SKEL_RAISE3, SPR_SKEL,14,5,NULL,S_SKEL_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RAISE3
	{ S_SKEL_RAISE4, SPR_SKEL,13,5,NULL,S_SKEL_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RAISE4
	{ S_SKEL_RAISE5, SPR_SKEL,12,5,NULL,S_SKEL_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RAISE5
	{ S_SKEL_RAISE6, SPR_SKEL,11,5,NULL,S_SKEL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKEL_RAISE6
	{ S_FATSHOT1, SPR_MANF,32768,4,NULL,S_FATSHOT2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATSHOT1
	{ S_FATSHOT2, SPR_MANF,32769,4,NULL,S_FATSHOT1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATSHOT2
	{ S_FATSHOTX1, SPR_MISL,32769,8,NULL,S_FATSHOTX2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATSHOTX1
	{ S_FATSHOTX2, SPR_MISL,32770,6,NULL,S_FATSHOTX3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATSHOTX2
	{ S_FATSHOTX3, SPR_MISL,32771,4,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATSHOTX3
	{ S_FATT_STND, SPR_FATT,0,15,A_Look,S_FATT_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_STND
	{ S_FATT_STND2, SPR_FATT,1,15,A_Look,S_FATT_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_STND2
	{ S_FATT_RUN1, SPR_FATT,0,4,A_Chase,S_FATT_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN1
	{ S_FATT_RUN2, SPR_FATT,0,4,A_Chase,S_FATT_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN2
	{ S_FATT_RUN3, SPR_FATT,1,4,A_Chase,S_FATT_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN3
	{ S_FATT_RUN4, SPR_FATT,1,4,A_Chase,S_FATT_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN4
	{ S_FATT_RUN5, SPR_FATT,2,4,A_Chase,S_FATT_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN5
	{ S_FATT_RUN6, SPR_FATT,2,4,A_Chase,S_FATT_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN6
	{ S_FATT_RUN7, SPR_FATT,3,4,A_Chase,S_FATT_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN7
	{ S_FATT_RUN8, SPR_FATT,3,4,A_Chase,S_FATT_RUN9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN8
	{ S_FATT_RUN9, SPR_FATT,4,4,A_Chase,S_FATT_RUN10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN9
	{ S_FATT_RUN10, SPR_FATT,4,4,A_Chase,S_FATT_RUN11,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN10
	{ S_FATT_RUN11, SPR_FATT,5,4,A_Chase,S_FATT_RUN12,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN11
	{ S_FATT_RUN12, SPR_FATT,5,4,A_Chase,S_FATT_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RUN12
	{ S_FATT_ATK1, SPR_FATT,6,20,A_FatRaise,S_FATT_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK1
	{ S_FATT_ATK2, SPR_FATT,32775,10,A_FatAttack1,S_FATT_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK2
	{ S_FATT_ATK3, SPR_FATT,8,5,A_FaceTarget,S_FATT_ATK4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK3
	{ S_FATT_ATK4, SPR_FATT,6,5,A_FaceTarget,S_FATT_ATK5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK4
	{ S_FATT_ATK5, SPR_FATT,32775,10,A_FatAttack2,S_FATT_ATK6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK5
	{ S_FATT_ATK6, SPR_FATT,8,5,A_FaceTarget,S_FATT_ATK7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK6
	{ S_FATT_ATK7, SPR_FATT,6,5,A_FaceTarget,S_FATT_ATK8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK7
	{ S_FATT_ATK8, SPR_FATT,32775,10,A_FatAttack3,S_FATT_ATK9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK8
	{ S_FATT_ATK9, SPR_FATT,8,5,A_FaceTarget,S_FATT_ATK10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK9
	{ S_FATT_ATK10, SPR_FATT,6,5,A_FaceTarget,S_FATT_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_ATK10
	{ S_FATT_PAIN, SPR_FATT,9,3,NULL,S_FATT_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_PAIN
	{ S_FATT_PAIN2, SPR_FATT,9,3,A_Pain,S_FATT_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_PAIN2
	{ S_FATT_DIE1, SPR_FATT,10,6,NULL,S_FATT_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE1
	{ S_FATT_DIE2, SPR_FATT,11,6,A_Scream,S_FATT_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE2
	{ S_FATT_DIE3, SPR_FATT,12,6,A_Fall,S_FATT_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE3
	{ S_FATT_DIE4, SPR_FATT,13,6,NULL,S_FATT_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE4
	{ S_FATT_DIE5, SPR_FATT,14,6,NULL,S_FATT_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE5
	{ S_FATT_DIE6, SPR_FATT,15,6,NULL,S_FATT_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE6
	{ S_FATT_DIE7, SPR_FATT,16,6,NULL,S_FATT_DIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE7
	{ S_FATT_DIE8, SPR_FATT,17,6,NULL,S_FATT_DIE9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE8
	{ S_FATT_DIE9, SPR_FATT,18,6,NULL,S_FATT_DIE10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE9
	{ S_FATT_DIE10, SPR_FATT,19,-1,A_BossDeath,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_DIE10
	{ S_FATT_RAISE1, SPR_FATT,17,5,NULL,S_FATT_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RAISE1
	{ S_FATT_RAISE2, SPR_FATT,16,5,NULL,S_FATT_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RAISE2
	{ S_FATT_RAISE3, SPR_FATT,15,5,NULL,S_FATT_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RAISE3
	{ S_FATT_RAISE4, SPR_FATT,14,5,NULL,S_FATT_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RAISE4
	{ S_FATT_RAISE5, SPR_FATT,13,5,NULL,S_FATT_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RAISE5
	{ S_FATT_RAISE6, SPR_FATT,12,5,NULL,S_FATT_RAISE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RAISE6
	{ S_FATT_RAISE7, SPR_FATT,11,5,NULL,S_FATT_RAISE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RAISE7
	{ S_FATT_RAISE8, SPR_FATT,10,5,NULL,S_FATT_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FATT_RAISE8
	{ S_CPOS_STND, SPR_CPOS,0,10,A_Look,S_CPOS_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_STND
	{ S_CPOS_STND2, SPR_CPOS,1,10,A_Look,S_CPOS_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_STND2
	{ S_CPOS_RUN1, SPR_CPOS,0,3,A_Chase,S_CPOS_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RUN1
	{ S_CPOS_RUN2, SPR_CPOS,0,3,A_Chase,S_CPOS_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RUN2
	{ S_CPOS_RUN3, SPR_CPOS,1,3,A_Chase,S_CPOS_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RUN3
	{ S_CPOS_RUN4, SPR_CPOS,1,3,A_Chase,S_CPOS_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RUN4
	{ S_CPOS_RUN5, SPR_CPOS,2,3,A_Chase,S_CPOS_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RUN5
	{ S_CPOS_RUN6, SPR_CPOS,2,3,A_Chase,S_CPOS_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RUN6
	{ S_CPOS_RUN7, SPR_CPOS,3,3,A_Chase,S_CPOS_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RUN7
	{ S_CPOS_RUN8, SPR_CPOS,3,3,A_Chase,S_CPOS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RUN8
	{ S_CPOS_ATK1, SPR_CPOS,4,10,A_FaceTarget,S_CPOS_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_ATK1
	{ S_CPOS_ATK2, SPR_CPOS,32773,4,A_CPosAttack,S_CPOS_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_ATK2
	{ S_CPOS_ATK3, SPR_CPOS,32772,4,A_CPosAttack,S_CPOS_ATK4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_ATK3
	{ S_CPOS_ATK4, SPR_CPOS,5,1,A_CPosRefire,S_CPOS_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_ATK4
	{ S_CPOS_PAIN, SPR_CPOS,6,3,NULL,S_CPOS_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_PAIN
	{ S_CPOS_PAIN2, SPR_CPOS,6,3,A_Pain,S_CPOS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_PAIN2
	{ S_CPOS_DIE1, SPR_CPOS,7,5,NULL,S_CPOS_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_DIE1
	{ S_CPOS_DIE2, SPR_CPOS,8,5,A_Scream,S_CPOS_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_DIE2
	{ S_CPOS_DIE3, SPR_CPOS,9,5,A_Fall,S_CPOS_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_DIE3
	{ S_CPOS_DIE4, SPR_CPOS,10,5,NULL,S_CPOS_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_DIE4
	{ S_CPOS_DIE5, SPR_CPOS,11,5,NULL,S_CPOS_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_DIE5
	{ S_CPOS_DIE6, SPR_CPOS,12,5,NULL,S_CPOS_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_DIE6
	{ S_CPOS_DIE7, SPR_CPOS,13,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_DIE7
	{ S_CPOS_XDIE1, SPR_CPOS,14,5,NULL,S_CPOS_XDIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_XDIE1
	{ S_CPOS_XDIE2, SPR_CPOS,15,5,A_XScream,S_CPOS_XDIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_XDIE2
	{ S_CPOS_XDIE3, SPR_CPOS,16,5,A_Fall,S_CPOS_XDIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_XDIE3
	{ S_CPOS_XDIE4, SPR_CPOS,17,5,NULL,S_CPOS_XDIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_XDIE4
	{ S_CPOS_XDIE5, SPR_CPOS,18,5,NULL,S_CPOS_XDIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_XDIE5
	{ S_CPOS_XDIE6, SPR_CPOS,19,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_XDIE6
	{ S_CPOS_RAISE1, SPR_CPOS,13,5,NULL,S_CPOS_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RAISE1
	{ S_CPOS_RAISE2, SPR_CPOS,12,5,NULL,S_CPOS_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RAISE2
	{ S_CPOS_RAISE3, SPR_CPOS,11,5,NULL,S_CPOS_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RAISE3
	{ S_CPOS_RAISE4, SPR_CPOS,10,5,NULL,S_CPOS_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RAISE4
	{ S_CPOS_RAISE5, SPR_CPOS,9,5,NULL,S_CPOS_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RAISE5
	{ S_CPOS_RAISE6, SPR_CPOS,8,5,NULL,S_CPOS_RAISE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RAISE6
	{ S_CPOS_RAISE7, SPR_CPOS,7,5,NULL,S_CPOS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CPOS_RAISE7
	{ S_TROO_STND, SPR_TROO,0,10,A_Look,S_TROO_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_STND
	{ S_TROO_STND2, SPR_TROO,1,10,A_Look,S_TROO_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_STND2
	{ S_TROO_RUN1, SPR_TROO,0,3,A_Chase,S_TROO_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RUN1
	{ S_TROO_RUN2, SPR_TROO,0,3,A_Chase,S_TROO_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RUN2
	{ S_TROO_RUN3, SPR_TROO,1,3,A_Chase,S_TROO_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RUN3
	{ S_TROO_RUN4, SPR_TROO,1,3,A_Chase,S_TROO_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RUN4
	{ S_TROO_RUN5, SPR_TROO,2,3,A_Chase,S_TROO_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RUN5
	{ S_TROO_RUN6, SPR_TROO,2,3,A_Chase,S_TROO_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RUN6
	{ S_TROO_RUN7, SPR_TROO,3,3,A_Chase,S_TROO_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RUN7
	{ S_TROO_RUN8, SPR_TROO,3,3,A_Chase,S_TROO_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RUN8
	{ S_TROO_ATK1, SPR_TROO,4,8,A_FaceTarget,S_TROO_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_ATK1
	{ S_TROO_ATK2, SPR_TROO,5,8,A_FaceTarget,S_TROO_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_ATK2
	{ S_TROO_ATK3, SPR_TROO,6,6,A_TroopAttack,S_TROO_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_ATK3
	{ S_TROO_PAIN, SPR_TROO,7,2,NULL,S_TROO_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_PAIN
	{ S_TROO_PAIN2, SPR_TROO,7,2,A_Pain,S_TROO_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_PAIN2
	{ S_TROO_DIE1, SPR_TROO,8,8,NULL,S_TROO_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_DIE1
	{ S_TROO_DIE2, SPR_TROO,9,8,A_Scream,S_TROO_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_DIE2
	{ S_TROO_DIE3, SPR_TROO,10,6,NULL,S_TROO_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_DIE3
	{ S_TROO_DIE4, SPR_TROO,11,6,A_Fall,S_TROO_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_DIE4
	{ S_TROO_DIE5, SPR_TROO,12,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_DIE5
	{ S_TROO_XDIE1, SPR_TROO,13,5,NULL,S_TROO_XDIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_XDIE1
	{ S_TROO_XDIE2, SPR_TROO,14,5,A_XScream,S_TROO_XDIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_XDIE2
	{ S_TROO_XDIE3, SPR_TROO,15,5,NULL,S_TROO_XDIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_XDIE3
	{ S_TROO_XDIE4, SPR_TROO,16,5,A_Fall,S_TROO_XDIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_XDIE4
	{ S_TROO_XDIE5, SPR_TROO,17,5,NULL,S_TROO_XDIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_XDIE5
	{ S_TROO_XDIE6, SPR_TROO,18,5,NULL,S_TROO_XDIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_XDIE6
	{ S_TROO_XDIE7, SPR_TROO,19,5,NULL,S_TROO_XDIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_XDIE7
	{ S_TROO_XDIE8, SPR_TROO,20,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_XDIE8
	{ S_TROO_RAISE1, SPR_TROO,12,8,NULL,S_TROO_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RAISE1
	{ S_TROO_RAISE2, SPR_TROO,11,8,NULL,S_TROO_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RAISE2
	{ S_TROO_RAISE3, SPR_TROO,10,6,NULL,S_TROO_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RAISE3
	{ S_TROO_RAISE4, SPR_TROO,9,6,NULL,S_TROO_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RAISE4
	{ S_TROO_RAISE5, SPR_TROO,8,6,NULL,S_TROO_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TROO_RAISE5
	{ S_SARG_STND, SPR_SARG,0,10,A_Look,S_SARG_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_STND
	{ S_SARG_STND2, SPR_SARG,1,10,A_Look,S_SARG_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_STND2
	{ S_SARG_RUN1, SPR_SARG,0,2,A_Chase,S_SARG_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_RUN1
	{ S_SARG_RUN2, SPR_SARG,0,2,A_Chase,S_SARG_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_RUN2
	{ S_SARG_RUN3, SPR_SARG,1,2,A_Chase,S_SARG_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_RUN3
	{ S_SARG_RUN4, SPR_SARG,1,2,A_Chase,S_SARG_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_RUN4
	{ S_SARG_RUN5, SPR_SARG,2,2,A_Chase,S_SARG_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_RUN5
	{ S_SARG_RUN6, SPR_SARG,2,2,A_Chase,S_SARG_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_RUN6
	{ S_SARG_RUN7, SPR_SARG,3,2,A_Chase,S_SARG_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_RUN7
	{ S_SARG_RUN8, SPR_SARG,3,2,A_Chase,S_SARG_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_RUN8
	{ S_SARG_ATK1, SPR_SARG,4,8,A_FaceTarget,S_SARG_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_ATK1
	{ S_SARG_ATK2, SPR_SARG,5,8,A_FaceTarget,S_SARG_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_ATK2
	{ S_SARG_ATK3, SPR_SARG,6,8,A_SargAttack,S_SARG_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_ATK3
	{ S_SARG_PAIN, SPR_SARG,7,2,NULL,S_SARG_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_PAIN
	{ S_SARG_PAIN2, SPR_SARG,7,2,A_Pain,S_SARG_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_PAIN2
	{ S_SARG_DIE1, SPR_SARG,8,8,NULL,S_SARG_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_DIE1
	{ S_SARG_DIE2, SPR_SARG,9,8,A_Scream,S_SARG_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_DIE2
	{ S_SARG_DIE3, SPR_SARG,10,4,NULL,S_SARG_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_DIE3
	{ S_SARG_DIE4, SPR_SARG,11,4,A_Fall,S_SARG_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_DIE4
	{ S_SARG_DIE5, SPR_SARG,12,4,NULL,S_SARG_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_DIE5
	{ S_SARG_DIE6, SPR_SARG,13,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_DIE6
	{ S_SARG_RAISE1, SPR_SARG,13,5,NULL,S_SARG_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_RAISE1
	{ S_SARG_RAISE2, SPR_SARG,12,5,NULL,S_SARG_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_RAISE2
	{ S_SARG_RAISE3, SPR_SARG,11,5,NULL,S_SARG_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_RAISE3
	{ S_SARG_RAISE4, SPR_SARG,10,5,NULL,S_SARG_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_RAISE4
	{ S_SARG_RAISE5, SPR_SARG,9,5,NULL,S_SARG_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SARG_RAISE5
	{ S_SARG_RAISE6, SPR_SARG,8,5,NULL,S_SARG_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_SKILL5FAST},	// S_SARG_RAISE6
	{ S_HEAD_STND, SPR_HEAD,0,10,A_Look,S_HEAD_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_STND
	{ S_HEAD_RUN1, SPR_HEAD,0,3,A_Chase,S_HEAD_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_RUN1
	{ S_HEAD_ATK1, SPR_HEAD,1,5,A_FaceTarget,S_HEAD_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_ATK1
	{ S_HEAD_ATK2, SPR_HEAD,2,5,A_FaceTarget,S_HEAD_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_ATK2
	{ S_HEAD_ATK3, SPR_HEAD,32771,5,A_HeadAttack,S_HEAD_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_ATK3
	{ S_HEAD_PAIN, SPR_HEAD,4,3,NULL,S_HEAD_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_PAIN
	{ S_HEAD_PAIN2, SPR_HEAD,4,3,A_Pain,S_HEAD_PAIN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_PAIN2
	{ S_HEAD_PAIN3, SPR_HEAD,5,6,NULL,S_HEAD_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_PAIN3
	{ S_HEAD_DIE1, SPR_HEAD,6,8,NULL,S_HEAD_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_DIE1
	{ S_HEAD_DIE2, SPR_HEAD,7,8,A_Scream,S_HEAD_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_DIE2
	{ S_HEAD_DIE3, SPR_HEAD,8,8,NULL,S_HEAD_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_DIE3
	{ S_HEAD_DIE4, SPR_HEAD,9,8,NULL,S_HEAD_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_DIE4
	{ S_HEAD_DIE5, SPR_HEAD,10,8,A_Fall,S_HEAD_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_DIE5
	{ S_HEAD_DIE6, SPR_HEAD,11,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_DIE6
	{ S_HEAD_RAISE1, SPR_HEAD,11,8,NULL,S_HEAD_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_RAISE1
	{ S_HEAD_RAISE2, SPR_HEAD,10,8,NULL,S_HEAD_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_RAISE2
	{ S_HEAD_RAISE3, SPR_HEAD,9,8,NULL,S_HEAD_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_RAISE3
	{ S_HEAD_RAISE4, SPR_HEAD,8,8,NULL,S_HEAD_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_RAISE4
	{ S_HEAD_RAISE5, SPR_HEAD,7,8,NULL,S_HEAD_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_RAISE5
	{ S_HEAD_RAISE6, SPR_HEAD,6,8,NULL,S_HEAD_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEAD_RAISE6
	{ S_BRBALL1, SPR_BAL7,32768,4,NULL,S_BRBALL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRBALL1
	{ S_BRBALL2, SPR_BAL7,32769,4,NULL,S_BRBALL1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRBALL2
	{ S_BRBALLX1, SPR_BAL7,32770,6,NULL,S_BRBALLX2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRBALLX1
	{ S_BRBALLX2, SPR_BAL7,32771,6,NULL,S_BRBALLX3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRBALLX2
	{ S_BRBALLX3, SPR_BAL7,32772,6,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRBALLX3
	{ S_BOSS_STND, SPR_BOSS,0,10,A_Look,S_BOSS_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_STND
	{ S_BOSS_STND2, SPR_BOSS,1,10,A_Look,S_BOSS_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_STND2
	{ S_BOSS_RUN1, SPR_BOSS,0,3,A_Chase,S_BOSS_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RUN1
	{ S_BOSS_RUN2, SPR_BOSS,0,3,A_Chase,S_BOSS_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RUN2
	{ S_BOSS_RUN3, SPR_BOSS,1,3,A_Chase,S_BOSS_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RUN3
	{ S_BOSS_RUN4, SPR_BOSS,1,3,A_Chase,S_BOSS_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RUN4
	{ S_BOSS_RUN5, SPR_BOSS,2,3,A_Chase,S_BOSS_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RUN5
	{ S_BOSS_RUN6, SPR_BOSS,2,3,A_Chase,S_BOSS_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RUN6
	{ S_BOSS_RUN7, SPR_BOSS,3,3,A_Chase,S_BOSS_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RUN7
	{ S_BOSS_RUN8, SPR_BOSS,3,3,A_Chase,S_BOSS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RUN8
	{ S_BOSS_ATK1, SPR_BOSS,4,8,A_FaceTarget,S_BOSS_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_ATK1
	{ S_BOSS_ATK2, SPR_BOSS,5,8,A_FaceTarget,S_BOSS_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_ATK2
	{ S_BOSS_ATK3, SPR_BOSS,6,8,A_BruisAttack,S_BOSS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_ATK3
	{ S_BOSS_PAIN, SPR_BOSS,7,2,NULL,S_BOSS_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_PAIN
	{ S_BOSS_PAIN2, SPR_BOSS,7,2,A_Pain,S_BOSS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_PAIN2
	{ S_BOSS_DIE1, SPR_BOSS,8,8,NULL,S_BOSS_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_DIE1
	{ S_BOSS_DIE2, SPR_BOSS,9,8,A_Scream,S_BOSS_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_DIE2
	{ S_BOSS_DIE3, SPR_BOSS,10,8,NULL,S_BOSS_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_DIE3
	{ S_BOSS_DIE4, SPR_BOSS,11,8,A_Fall,S_BOSS_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_DIE4
	{ S_BOSS_DIE5, SPR_BOSS,12,8,NULL,S_BOSS_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_DIE5
	{ S_BOSS_DIE6, SPR_BOSS,13,8,NULL,S_BOSS_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_DIE6
	{ S_BOSS_DIE7, SPR_BOSS,14,-1,A_BossDeath,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_DIE7
	{ S_BOSS_RAISE1, SPR_BOSS,14,8,NULL,S_BOSS_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RAISE1
	{ S_BOSS_RAISE2, SPR_BOSS,13,8,NULL,S_BOSS_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RAISE2
	{ S_BOSS_RAISE3, SPR_BOSS,12,8,NULL,S_BOSS_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RAISE3
	{ S_BOSS_RAISE4, SPR_BOSS,11,8,NULL,S_BOSS_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RAISE4
	{ S_BOSS_RAISE5, SPR_BOSS,10,8,NULL,S_BOSS_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RAISE5
	{ S_BOSS_RAISE6, SPR_BOSS,9,8,NULL,S_BOSS_RAISE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RAISE6
	{ S_BOSS_RAISE7, SPR_BOSS,8,8,NULL,S_BOSS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOSS_RAISE7
	{ S_BOS2_STND, SPR_BOS2,0,10,A_Look,S_BOS2_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_STND
	{ S_BOS2_STND2, SPR_BOS2,1,10,A_Look,S_BOS2_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_STND2
	{ S_BOS2_RUN1, SPR_BOS2,0,3,A_Chase,S_BOS2_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RUN1
	{ S_BOS2_RUN2, SPR_BOS2,0,3,A_Chase,S_BOS2_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RUN2
	{ S_BOS2_RUN3, SPR_BOS2,1,3,A_Chase,S_BOS2_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RUN3
	{ S_BOS2_RUN4, SPR_BOS2,1,3,A_Chase,S_BOS2_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RUN4
	{ S_BOS2_RUN5, SPR_BOS2,2,3,A_Chase,S_BOS2_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RUN5
	{ S_BOS2_RUN6, SPR_BOS2,2,3,A_Chase,S_BOS2_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RUN6
	{ S_BOS2_RUN7, SPR_BOS2,3,3,A_Chase,S_BOS2_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RUN7
	{ S_BOS2_RUN8, SPR_BOS2,3,3,A_Chase,S_BOS2_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RUN8
	{ S_BOS2_ATK1, SPR_BOS2,4,8,A_FaceTarget,S_BOS2_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_ATK1
	{ S_BOS2_ATK2, SPR_BOS2,5,8,A_FaceTarget,S_BOS2_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_ATK2
	{ S_BOS2_ATK3, SPR_BOS2,6,8,A_BruisAttack,S_BOS2_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_ATK3
	{ S_BOS2_PAIN, SPR_BOS2,7,2,NULL,S_BOS2_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_PAIN
	{ S_BOS2_PAIN2, SPR_BOS2,7,2,A_Pain,S_BOS2_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_PAIN2
	{ S_BOS2_DIE1, SPR_BOS2,8,8,NULL,S_BOS2_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_DIE1
	{ S_BOS2_DIE2, SPR_BOS2,9,8,A_Scream,S_BOS2_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_DIE2
	{ S_BOS2_DIE3, SPR_BOS2,10,8,NULL,S_BOS2_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_DIE3
	{ S_BOS2_DIE4, SPR_BOS2,11,8,A_Fall,S_BOS2_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_DIE4
	{ S_BOS2_DIE5, SPR_BOS2,12,8,NULL,S_BOS2_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_DIE5
	{ S_BOS2_DIE6, SPR_BOS2,13,8,NULL,S_BOS2_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_DIE6
	{ S_BOS2_DIE7, SPR_BOS2,14,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_DIE7
	{ S_BOS2_RAISE1, SPR_BOS2,14,8,NULL,S_BOS2_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RAISE1
	{ S_BOS2_RAISE2, SPR_BOS2,13,8,NULL,S_BOS2_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RAISE2
	{ S_BOS2_RAISE3, SPR_BOS2,12,8,NULL,S_BOS2_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RAISE3
	{ S_BOS2_RAISE4, SPR_BOS2,11,8,NULL,S_BOS2_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RAISE4
	{ S_BOS2_RAISE5, SPR_BOS2,10,8,NULL,S_BOS2_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RAISE5
	{ S_BOS2_RAISE6, SPR_BOS2,9,8,NULL,S_BOS2_RAISE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RAISE6
	{ S_BOS2_RAISE7, SPR_BOS2,8,8,NULL,S_BOS2_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BOS2_RAISE7
	{ S_SKULL_STND, SPR_SKUL,32768,10,A_Look,S_SKULL_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_STND
	{ S_SKULL_STND2, SPR_SKUL,32769,10,A_Look,S_SKULL_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_STND2
	{ S_SKULL_RUN1, SPR_SKUL,32768,6,A_Chase,S_SKULL_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_RUN1
	{ S_SKULL_RUN2, SPR_SKUL,32769,6,A_Chase,S_SKULL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_RUN2
	{ S_SKULL_ATK1, SPR_SKUL,32770,10,A_FaceTarget,S_SKULL_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_ATK1
	{ S_SKULL_ATK2, SPR_SKUL,32771,4,A_SkullAttack,S_SKULL_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_ATK2
	{ S_SKULL_ATK3, SPR_SKUL,32770,4,NULL,S_SKULL_ATK4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_ATK3
	{ S_SKULL_ATK4, SPR_SKUL,32771,4,NULL,S_SKULL_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_ATK4
	{ S_SKULL_PAIN, SPR_SKUL,32772,3,NULL,S_SKULL_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_PAIN
	{ S_SKULL_PAIN2, SPR_SKUL,32772,3,A_Pain,S_SKULL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_PAIN2
	{ S_SKULL_DIE1, SPR_SKUL,32773,6,NULL,S_SKULL_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_DIE1
	{ S_SKULL_DIE2, SPR_SKUL,32774,6,A_Scream,S_SKULL_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_DIE2
	{ S_SKULL_DIE3, SPR_SKUL,32775,6,NULL,S_SKULL_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_DIE3
	{ S_SKULL_DIE4, SPR_SKUL,32776,6,A_Fall,S_SKULL_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_DIE4
	{ S_SKULL_DIE5, SPR_SKUL,9,6,NULL,S_SKULL_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_DIE5
	{ S_SKULL_DIE6, SPR_SKUL,10,6,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULL_DIE6
	{ S_SPID_STND, SPR_SPID,0,10,A_Look,S_SPID_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_STND
	{ S_SPID_STND2, SPR_SPID,1,10,A_Look,S_SPID_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_STND2
	{ S_SPID_RUN1, SPR_SPID,0,3,A_Metal,S_SPID_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN1
	{ S_SPID_RUN2, SPR_SPID,0,3,A_Chase,S_SPID_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN2
	{ S_SPID_RUN3, SPR_SPID,1,3,A_Chase,S_SPID_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN3
	{ S_SPID_RUN4, SPR_SPID,1,3,A_Chase,S_SPID_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN4
	{ S_SPID_RUN5, SPR_SPID,2,3,A_Metal,S_SPID_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN5
	{ S_SPID_RUN6, SPR_SPID,2,3,A_Chase,S_SPID_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN6
	{ S_SPID_RUN7, SPR_SPID,3,3,A_Chase,S_SPID_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN7
	{ S_SPID_RUN8, SPR_SPID,3,3,A_Chase,S_SPID_RUN9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN8
	{ S_SPID_RUN9, SPR_SPID,4,3,A_Metal,S_SPID_RUN10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN9
	{ S_SPID_RUN10, SPR_SPID,4,3,A_Chase,S_SPID_RUN11,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN10
	{ S_SPID_RUN11, SPR_SPID,5,3,A_Chase,S_SPID_RUN12,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN11
	{ S_SPID_RUN12, SPR_SPID,5,3,A_Chase,S_SPID_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_RUN12
	{ S_SPID_ATK1, SPR_SPID,32768,20,A_FaceTarget,S_SPID_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_ATK1
	{ S_SPID_ATK2, SPR_SPID,32774,4,A_SPosAttack,S_SPID_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_ATK2
	{ S_SPID_ATK3, SPR_SPID,32775,4,A_SPosAttack,S_SPID_ATK4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_ATK3
	{ S_SPID_ATK4, SPR_SPID,32775,1,A_SpidRefire,S_SPID_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_ATK4
	{ S_SPID_PAIN, SPR_SPID,8,3,NULL,S_SPID_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_PAIN
	{ S_SPID_PAIN2, SPR_SPID,8,3,A_Pain,S_SPID_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_PAIN2
	{ S_SPID_DIE1, SPR_SPID,9,20,A_Scream,S_SPID_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE1
	{ S_SPID_DIE2, SPR_SPID,10,10,A_Fall,S_SPID_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE2
	{ S_SPID_DIE3, SPR_SPID,11,10,NULL,S_SPID_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE3
	{ S_SPID_DIE4, SPR_SPID,12,10,NULL,S_SPID_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE4
	{ S_SPID_DIE5, SPR_SPID,13,10,NULL,S_SPID_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE5
	{ S_SPID_DIE6, SPR_SPID,14,10,NULL,S_SPID_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE6
	{ S_SPID_DIE7, SPR_SPID,15,10,NULL,S_SPID_DIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE7
	{ S_SPID_DIE8, SPR_SPID,16,10,NULL,S_SPID_DIE9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE8
	{ S_SPID_DIE9, SPR_SPID,17,10,NULL,S_SPID_DIE10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE9
	{ S_SPID_DIE10, SPR_SPID,18,30,NULL,S_SPID_DIE11,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE10
	{ S_SPID_DIE11, SPR_SPID,18,-1,A_BossDeath,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPID_DIE11
	{ S_BSPI_STND, SPR_BSPI,0,10,A_Look,S_BSPI_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_STND
	{ S_BSPI_STND2, SPR_BSPI,1,10,A_Look,S_BSPI_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_STND2
	{ S_BSPI_SIGHT, SPR_BSPI,0,20,NULL,S_BSPI_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_SIGHT
	{ S_BSPI_RUN1, SPR_BSPI,0,3,A_BabyMetal,S_BSPI_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN1
	{ S_BSPI_RUN2, SPR_BSPI,0,3,A_Chase,S_BSPI_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN2
	{ S_BSPI_RUN3, SPR_BSPI,1,3,A_Chase,S_BSPI_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN3
	{ S_BSPI_RUN4, SPR_BSPI,1,3,A_Chase,S_BSPI_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN4
	{ S_BSPI_RUN5, SPR_BSPI,2,3,A_Chase,S_BSPI_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN5
	{ S_BSPI_RUN6, SPR_BSPI,2,3,A_Chase,S_BSPI_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN6
	{ S_BSPI_RUN7, SPR_BSPI,3,3,A_BabyMetal,S_BSPI_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN7
	{ S_BSPI_RUN8, SPR_BSPI,3,3,A_Chase,S_BSPI_RUN9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN8
	{ S_BSPI_RUN9, SPR_BSPI,4,3,A_Chase,S_BSPI_RUN10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN9
	{ S_BSPI_RUN10, SPR_BSPI,4,3,A_Chase,S_BSPI_RUN11,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN10
	{ S_BSPI_RUN11, SPR_BSPI,5,3,A_Chase,S_BSPI_RUN12,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN11
	{ S_BSPI_RUN12, SPR_BSPI,5,3,A_Chase,S_BSPI_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RUN12
	{ S_BSPI_ATK1, SPR_BSPI,32768,20,A_FaceTarget,S_BSPI_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_ATK1
	{ S_BSPI_ATK2, SPR_BSPI,32774,4,A_BspiAttack,S_BSPI_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_ATK2
	{ S_BSPI_ATK3, SPR_BSPI,32775,4,NULL,S_BSPI_ATK4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_ATK3
	{ S_BSPI_ATK4, SPR_BSPI,32775,1,A_SpidRefire,S_BSPI_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_ATK4
	{ S_BSPI_PAIN, SPR_BSPI,8,3,NULL,S_BSPI_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_PAIN
	{ S_BSPI_PAIN2, SPR_BSPI,8,3,A_Pain,S_BSPI_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_PAIN2
	{ S_BSPI_DIE1, SPR_BSPI,9,20,A_Scream,S_BSPI_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_DIE1
	{ S_BSPI_DIE2, SPR_BSPI,10,7,A_Fall,S_BSPI_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_DIE2
	{ S_BSPI_DIE3, SPR_BSPI,11,7,NULL,S_BSPI_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_DIE3
	{ S_BSPI_DIE4, SPR_BSPI,12,7,NULL,S_BSPI_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_DIE4
	{ S_BSPI_DIE5, SPR_BSPI,13,7,NULL,S_BSPI_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_DIE5
	{ S_BSPI_DIE6, SPR_BSPI,14,7,NULL,S_BSPI_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_DIE6
	{ S_BSPI_DIE7, SPR_BSPI,15,-1,A_BossDeath,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_DIE7
	{ S_BSPI_RAISE1, SPR_BSPI,15,5,NULL,S_BSPI_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RAISE1
	{ S_BSPI_RAISE2, SPR_BSPI,14,5,NULL,S_BSPI_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RAISE2
	{ S_BSPI_RAISE3, SPR_BSPI,13,5,NULL,S_BSPI_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RAISE3
	{ S_BSPI_RAISE4, SPR_BSPI,12,5,NULL,S_BSPI_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RAISE4
	{ S_BSPI_RAISE5, SPR_BSPI,11,5,NULL,S_BSPI_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RAISE5
	{ S_BSPI_RAISE6, SPR_BSPI,10,5,NULL,S_BSPI_RAISE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RAISE6
	{ S_BSPI_RAISE7, SPR_BSPI,9,5,NULL,S_BSPI_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSPI_RAISE7
	{ S_ARACH_PLAZ, SPR_APLS,32768,5,NULL,S_ARACH_PLAZ2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARACH_PLAZ
	{ S_ARACH_PLAZ2, SPR_APLS,32769,5,NULL,S_ARACH_PLAZ,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARACH_PLAZ2
	{ S_ARACH_PLEX, SPR_APBX,32768,5,NULL,S_ARACH_PLEX2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARACH_PLEX
	{ S_ARACH_PLEX2, SPR_APBX,32769,5,NULL,S_ARACH_PLEX3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARACH_PLEX2
	{ S_ARACH_PLEX3, SPR_APBX,32770,5,NULL,S_ARACH_PLEX4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARACH_PLEX3
	{ S_ARACH_PLEX4, SPR_APBX,32771,5,NULL,S_ARACH_PLEX5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARACH_PLEX4
	{ S_ARACH_PLEX5, SPR_APBX,32772,5,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARACH_PLEX5
	{ S_CYBER_STND, SPR_CYBR,0,10,A_Look,S_CYBER_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_STND
	{ S_CYBER_STND2, SPR_CYBR,1,10,A_Look,S_CYBER_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_STND2
	{ S_CYBER_RUN1, SPR_CYBR,0,3,A_Hoof,S_CYBER_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_RUN1
	{ S_CYBER_RUN2, SPR_CYBR,0,3,A_Chase,S_CYBER_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_RUN2
	{ S_CYBER_RUN3, SPR_CYBR,1,3,A_Chase,S_CYBER_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_RUN3
	{ S_CYBER_RUN4, SPR_CYBR,1,3,A_Chase,S_CYBER_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_RUN4
	{ S_CYBER_RUN5, SPR_CYBR,2,3,A_Chase,S_CYBER_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_RUN5
	{ S_CYBER_RUN6, SPR_CYBR,2,3,A_Chase,S_CYBER_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_RUN6
	{ S_CYBER_RUN7, SPR_CYBR,3,3,A_Metal,S_CYBER_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_RUN7
	{ S_CYBER_RUN8, SPR_CYBR,3,3,A_Chase,S_CYBER_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_RUN8
	{ S_CYBER_ATK1, SPR_CYBR,4,6,A_FaceTarget,S_CYBER_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_ATK1
	{ S_CYBER_ATK2, SPR_CYBR,5,12,A_CyberAttack,S_CYBER_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_ATK2
	{ S_CYBER_ATK3, SPR_CYBR,4,12,A_FaceTarget,S_CYBER_ATK4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_ATK3
	{ S_CYBER_ATK4, SPR_CYBR,5,12,A_CyberAttack,S_CYBER_ATK5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_ATK4
	{ S_CYBER_ATK5, SPR_CYBR,4,12,A_FaceTarget,S_CYBER_ATK6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_ATK5
	{ S_CYBER_ATK6, SPR_CYBR,5,12,A_CyberAttack,S_CYBER_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_ATK6
	{ S_CYBER_PAIN, SPR_CYBR,6,10,A_Pain,S_CYBER_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_PAIN
	{ S_CYBER_DIE1, SPR_CYBR,7,10,NULL,S_CYBER_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE1
	{ S_CYBER_DIE2, SPR_CYBR,8,10,A_Scream,S_CYBER_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE2
	{ S_CYBER_DIE3, SPR_CYBR,9,10,NULL,S_CYBER_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE3
	{ S_CYBER_DIE4, SPR_CYBR,10,10,NULL,S_CYBER_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE4
	{ S_CYBER_DIE5, SPR_CYBR,11,10,NULL,S_CYBER_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE5
	{ S_CYBER_DIE6, SPR_CYBR,12,10,A_Fall,S_CYBER_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE6
	{ S_CYBER_DIE7, SPR_CYBR,13,10,NULL,S_CYBER_DIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE7
	{ S_CYBER_DIE8, SPR_CYBR,14,10,NULL,S_CYBER_DIE9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE8
	{ S_CYBER_DIE9, SPR_CYBR,15,30,NULL,S_CYBER_DIE10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE9
	{ S_CYBER_DIE10, SPR_CYBR,15,-1,A_BossDeath,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CYBER_DIE10
	{ S_PAIN_STND, SPR_PAIN,0,10,A_Look,S_PAIN_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_STND
	{ S_PAIN_RUN1, SPR_PAIN,0,3,A_Chase,S_PAIN_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RUN1
	{ S_PAIN_RUN2, SPR_PAIN,0,3,A_Chase,S_PAIN_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RUN2
	{ S_PAIN_RUN3, SPR_PAIN,1,3,A_Chase,S_PAIN_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RUN3
	{ S_PAIN_RUN4, SPR_PAIN,1,3,A_Chase,S_PAIN_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RUN4
	{ S_PAIN_RUN5, SPR_PAIN,2,3,A_Chase,S_PAIN_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RUN5
	{ S_PAIN_RUN6, SPR_PAIN,2,3,A_Chase,S_PAIN_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RUN6
	{ S_PAIN_ATK1, SPR_PAIN,3,5,A_FaceTarget,S_PAIN_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_ATK1
	{ S_PAIN_ATK2, SPR_PAIN,4,5,A_FaceTarget,S_PAIN_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_ATK2
	{ S_PAIN_ATK3, SPR_PAIN,32773,5,A_FaceTarget,S_PAIN_ATK4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_ATK3
	{ S_PAIN_ATK4, SPR_PAIN,32773,0,A_PainAttack,S_PAIN_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_ATK4
	{ S_PAIN_PAIN, SPR_PAIN,6,6,NULL,S_PAIN_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_PAIN
	{ S_PAIN_PAIN2, SPR_PAIN,6,6,A_Pain,S_PAIN_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_PAIN2
	{ S_PAIN_DIE1, SPR_PAIN,32775,8,NULL,S_PAIN_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_DIE1
	{ S_PAIN_DIE2, SPR_PAIN,32776,8,A_Scream,S_PAIN_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_DIE2
	{ S_PAIN_DIE3, SPR_PAIN,32777,8,NULL,S_PAIN_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_DIE3
	{ S_PAIN_DIE4, SPR_PAIN,32778,8,NULL,S_PAIN_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_DIE4
	{ S_PAIN_DIE5, SPR_PAIN,32779,8,A_PainDie,S_PAIN_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_DIE5
	{ S_PAIN_DIE6, SPR_PAIN,32780,8,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_DIE6
	{ S_PAIN_RAISE1, SPR_PAIN,12,8,NULL,S_PAIN_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RAISE1
	{ S_PAIN_RAISE2, SPR_PAIN,11,8,NULL,S_PAIN_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RAISE2
	{ S_PAIN_RAISE3, SPR_PAIN,10,8,NULL,S_PAIN_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RAISE3
	{ S_PAIN_RAISE4, SPR_PAIN,9,8,NULL,S_PAIN_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RAISE4
	{ S_PAIN_RAISE5, SPR_PAIN,8,8,NULL,S_PAIN_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RAISE5
	{ S_PAIN_RAISE6, SPR_PAIN,7,8,NULL,S_PAIN_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PAIN_RAISE6
	{ S_SSWV_STND, SPR_SSWV,0,10,A_Look,S_SSWV_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_STND
	{ S_SSWV_STND2, SPR_SSWV,1,10,A_Look,S_SSWV_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_STND2
	{ S_SSWV_RUN1, SPR_SSWV,0,3,A_Chase,S_SSWV_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RUN1
	{ S_SSWV_RUN2, SPR_SSWV,0,3,A_Chase,S_SSWV_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RUN2
	{ S_SSWV_RUN3, SPR_SSWV,1,3,A_Chase,S_SSWV_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RUN3
	{ S_SSWV_RUN4, SPR_SSWV,1,3,A_Chase,S_SSWV_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RUN4
	{ S_SSWV_RUN5, SPR_SSWV,2,3,A_Chase,S_SSWV_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RUN5
	{ S_SSWV_RUN6, SPR_SSWV,2,3,A_Chase,S_SSWV_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RUN6
	{ S_SSWV_RUN7, SPR_SSWV,3,3,A_Chase,S_SSWV_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RUN7
	{ S_SSWV_RUN8, SPR_SSWV,3,3,A_Chase,S_SSWV_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RUN8
	{ S_SSWV_ATK1, SPR_SSWV,4,10,A_FaceTarget,S_SSWV_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_ATK1
	{ S_SSWV_ATK2, SPR_SSWV,5,10,A_FaceTarget,S_SSWV_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_ATK2
	{ S_SSWV_ATK3, SPR_SSWV,32774,4,A_CPosAttack,S_SSWV_ATK4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_ATK3
	{ S_SSWV_ATK4, SPR_SSWV,5,6,A_FaceTarget,S_SSWV_ATK5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_ATK4
	{ S_SSWV_ATK5, SPR_SSWV,32774,4,A_CPosAttack,S_SSWV_ATK6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_ATK5
	{ S_SSWV_ATK6, SPR_SSWV,5,1,A_CPosRefire,S_SSWV_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_ATK6
	{ S_SSWV_PAIN, SPR_SSWV,7,3,NULL,S_SSWV_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_PAIN
	{ S_SSWV_PAIN2, SPR_SSWV,7,3,A_Pain,S_SSWV_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_PAIN2
	{ S_SSWV_DIE1, SPR_SSWV,8,5,NULL,S_SSWV_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_DIE1
	{ S_SSWV_DIE2, SPR_SSWV,9,5,A_Scream,S_SSWV_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_DIE2
	{ S_SSWV_DIE3, SPR_SSWV,10,5,A_Fall,S_SSWV_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_DIE3
	{ S_SSWV_DIE4, SPR_SSWV,11,5,NULL,S_SSWV_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_DIE4
	{ S_SSWV_DIE5, SPR_SSWV,12,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_DIE5
	{ S_SSWV_XDIE1, SPR_SSWV,13,5,NULL,S_SSWV_XDIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_XDIE1
	{ S_SSWV_XDIE2, SPR_SSWV,14,5,A_XScream,S_SSWV_XDIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_XDIE2
	{ S_SSWV_XDIE3, SPR_SSWV,15,5,A_Fall,S_SSWV_XDIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_XDIE3
	{ S_SSWV_XDIE4, SPR_SSWV,16,5,NULL,S_SSWV_XDIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_XDIE4
	{ S_SSWV_XDIE5, SPR_SSWV,17,5,NULL,S_SSWV_XDIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_XDIE5
	{ S_SSWV_XDIE6, SPR_SSWV,18,5,NULL,S_SSWV_XDIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_XDIE6
	{ S_SSWV_XDIE7, SPR_SSWV,19,5,NULL,S_SSWV_XDIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_XDIE7
	{ S_SSWV_XDIE8, SPR_SSWV,20,5,NULL,S_SSWV_XDIE9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_XDIE8
	{ S_SSWV_XDIE9, SPR_SSWV,21,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_XDIE9
	{ S_SSWV_RAISE1, SPR_SSWV,12,5,NULL,S_SSWV_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RAISE1
	{ S_SSWV_RAISE2, SPR_SSWV,11,5,NULL,S_SSWV_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RAISE2
	{ S_SSWV_RAISE3, SPR_SSWV,10,5,NULL,S_SSWV_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RAISE3
	{ S_SSWV_RAISE4, SPR_SSWV,9,5,NULL,S_SSWV_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RAISE4
	{ S_SSWV_RAISE5, SPR_SSWV,8,5,NULL,S_SSWV_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SSWV_RAISE5
	{ S_KEENSTND, SPR_KEEN,0,-1,NULL,S_KEENSTND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_KEENSTND
	{ S_COMMKEEN, SPR_KEEN,0,6,NULL,S_COMMKEEN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN
	{ S_COMMKEEN2, SPR_KEEN,1,6,NULL,S_COMMKEEN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN2
	{ S_COMMKEEN3, SPR_KEEN,2,6,A_Scream,S_COMMKEEN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN3
	{ S_COMMKEEN4, SPR_KEEN,3,6,NULL,S_COMMKEEN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN4
	{ S_COMMKEEN5, SPR_KEEN,4,6,NULL,S_COMMKEEN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN5
	{ S_COMMKEEN6, SPR_KEEN,5,6,NULL,S_COMMKEEN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN6
	{ S_COMMKEEN7, SPR_KEEN,6,6,NULL,S_COMMKEEN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN7
	{ S_COMMKEEN8, SPR_KEEN,7,6,NULL,S_COMMKEEN9,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN8
	{ S_COMMKEEN9, SPR_KEEN,8,6,NULL,S_COMMKEEN10,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN9
	{ S_COMMKEEN10, SPR_KEEN,9,6,NULL,S_COMMKEEN11,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COMMKEEN10
	{ S_COMMKEEN11, SPR_KEEN,10,6,A_KeenDie,S_COMMKEEN12,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},// S_COMMKEEN11
	{ S_COMMKEEN12, SPR_KEEN,11,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},		// S_COMMKEEN12
	{ S_KEENPAIN, SPR_KEEN,12,4,NULL,S_KEENPAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_KEENPAIN
	{ S_KEENPAIN2, SPR_KEEN,12,8,A_Pain,S_KEENSTND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_KEENPAIN2
	{ S_BRAIN, SPR_BBRN,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},		// S_BRAIN
	{ S_BRAIN_PAIN, SPR_BBRN,1,36,A_BrainPain,S_BRAIN,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAIN_PAIN
	{ S_BRAIN_DIE1, SPR_BBRN,0,100,A_BrainScream,S_BRAIN_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAIN_DIE1
	{ S_BRAIN_DIE2, SPR_BBRN,0,10,NULL,S_BRAIN_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAIN_DIE2
	{ S_BRAIN_DIE3, SPR_BBRN,0,10,NULL,S_BRAIN_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAIN_DIE3
	{ S_BRAIN_DIE4, SPR_BBRN,0,-1,A_BrainDie,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAIN_DIE4
	{ S_BRAINEYE, SPR_SSWV,0,10,A_Look,S_BRAINEYE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAINEYE
	{ S_BRAINEYESEE, SPR_SSWV,0,181,A_BrainAwake,S_BRAINEYE1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAINEYESEE
	{ S_BRAINEYE1, SPR_SSWV,0,150,A_BrainSpit,S_BRAINEYE1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAINEYE1
	{ S_SPAWN1, SPR_BOSF,32768,3,A_SpawnSound,S_SPAWN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWN1
	{ S_SPAWN2, SPR_BOSF,32769,3,A_SpawnFly,S_SPAWN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWN2
	{ S_SPAWN3, SPR_BOSF,32770,3,A_SpawnFly,S_SPAWN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWN3
	{ S_SPAWN4, SPR_BOSF,32771,3,A_SpawnFly,S_SPAWN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWN4
	{ S_SPAWNFIRE1, SPR_FIRE,32768,4,A_Fire,S_SPAWNFIRE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWNFIRE1
	{ S_SPAWNFIRE2, SPR_FIRE,32769,4,A_Fire,S_SPAWNFIRE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWNFIRE2
	{ S_SPAWNFIRE3, SPR_FIRE,32770,4,A_Fire,S_SPAWNFIRE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWNFIRE3
	{ S_SPAWNFIRE4, SPR_FIRE,32771,4,A_Fire,S_SPAWNFIRE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWNFIRE4
	{ S_SPAWNFIRE5, SPR_FIRE,32772,4,A_Fire,S_SPAWNFIRE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWNFIRE5
	{ S_SPAWNFIRE6, SPR_FIRE,32773,4,A_Fire,S_SPAWNFIRE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWNFIRE6
	{ S_SPAWNFIRE7, SPR_FIRE,32774,4,A_Fire,S_SPAWNFIRE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SPAWNFIRE7
	{ S_SPAWNFIRE8, SPR_FIRE,32775,4,A_Fire,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},		// S_SPAWNFIRE8
	{ S_BRAINEXPLODE1, SPR_MISL,32769,10,NULL,S_BRAINEXPLODE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAINEXPLODE1
	{ S_BRAINEXPLODE2, SPR_MISL,32770,10,NULL,S_BRAINEXPLODE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAINEXPLODE2
	{ S_BRAINEXPLODE3, SPR_MISL,32771,10,A_BrainExplode,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BRAINEXPLODE3
	{ S_ARM1, SPR_ARM1,0,6,NULL,S_ARM1A,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARM1
	{ S_ARM1A, SPR_ARM1,32769,7,NULL,S_ARM1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARM1A
	{ S_ARM2, SPR_ARM2,0,6,NULL,S_ARM2A,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARM2
	{ S_ARM2A, SPR_ARM2,32769,6,NULL,S_ARM2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ARM2A
	{ S_BAR1, SPR_BAR1,0,6,NULL,S_BAR2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BAR1
	{ S_BAR2, SPR_BAR1,1,6,NULL,S_BAR1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BAR2
	{ S_BEXP, SPR_BEXP,32768,5,NULL,S_BEXP2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BEXP
	{ S_BEXP2, SPR_BEXP,32769,5,A_Scream,S_BEXP3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BEXP2
	{ S_BEXP3, SPR_BEXP,32770,5,NULL,S_BEXP4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BEXP3
	{ S_BEXP4, SPR_BEXP,32771,10,A_Explode,S_BEXP5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BEXP4
	{ S_BEXP5, SPR_BEXP,32772,10,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BEXP5
	{ S_BBAR1, SPR_FCAN,32768,4,NULL,S_BBAR2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BBAR1
	{ S_BBAR2, SPR_FCAN,32769,4,NULL,S_BBAR3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BBAR2
	{ S_BBAR3, SPR_FCAN,32770,4,NULL,S_BBAR1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BBAR3
	{ S_BON1, SPR_BON1,0,6,NULL,S_BON1A,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON1
	{ S_BON1A, SPR_BON1,1,6,NULL,S_BON1B,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON1A
	{ S_BON1B, SPR_BON1,2,6,NULL,S_BON1C,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON1B
	{ S_BON1C, SPR_BON1,3,6,NULL,S_BON1D,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON1C
	{ S_BON1D, SPR_BON1,2,6,NULL,S_BON1E,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON1D
	{ S_BON1E, SPR_BON1,1,6,NULL,S_BON1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON1E
	{ S_BON2, SPR_BON2,0,6,NULL,S_BON2A,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON2
	{ S_BON2A, SPR_BON2,1,6,NULL,S_BON2B,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON2A
	{ S_BON2B, SPR_BON2,2,6,NULL,S_BON2C,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON2B
	{ S_BON2C, SPR_BON2,3,6,NULL,S_BON2D,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON2C
	{ S_BON2D, SPR_BON2,2,6,NULL,S_BON2E,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON2D
	{ S_BON2E, SPR_BON2,1,6,NULL,S_BON2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BON2E
	{ S_BKEY, SPR_BKEY,0,10,NULL,S_BKEY2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BKEY
	{ S_BKEY2, SPR_BKEY,32769,10,NULL,S_BKEY,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BKEY2
	{ S_RKEY, SPR_RKEY,0,10,NULL,S_RKEY2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RKEY
	{ S_RKEY2, SPR_RKEY,32769,10,NULL,S_RKEY,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RKEY2
	{ S_YKEY, SPR_YKEY,0,10,NULL,S_YKEY2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_YKEY
	{ S_YKEY2, SPR_YKEY,32769,10,NULL,S_YKEY,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_YKEY2
	{ S_BSKULL, SPR_BSKU,0,10,NULL,S_BSKULL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSKULL
	{ S_BSKULL2, SPR_BSKU,32769,10,NULL,S_BSKULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BSKULL2
	{ S_RSKULL, SPR_RSKU,0,10,NULL,S_RSKULL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RSKULL
	{ S_RSKULL2, SPR_RSKU,32769,10,NULL,S_RSKULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RSKULL2
	{ S_YSKULL, SPR_YSKU,0,10,NULL,S_YSKULL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_YSKULL
	{ S_YSKULL2, SPR_YSKU,32769,10,NULL,S_YSKULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_YSKULL2
	{ S_STIM, SPR_STIM,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_STIM
	{ S_MEDI, SPR_MEDI,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MEDI
	{ S_SOUL, SPR_SOUL,32768,6,NULL,S_SOUL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SOUL
	{ S_SOUL2, SPR_SOUL,32769,6,NULL,S_SOUL3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SOUL2
	{ S_SOUL3, SPR_SOUL,32770,6,NULL,S_SOUL4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SOUL3
	{ S_SOUL4, SPR_SOUL,32771,6,NULL,S_SOUL5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SOUL4
	{ S_SOUL5, SPR_SOUL,32770,6,NULL,S_SOUL6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SOUL5
	{ S_SOUL6, SPR_SOUL,32769,6,NULL,S_SOUL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SOUL6
	{ S_PINV, SPR_PINV,32768,6,NULL,S_PINV2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PINV
	{ S_PINV2, SPR_PINV,32769,6,NULL,S_PINV3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PINV2
	{ S_PINV3, SPR_PINV,32770,6,NULL,S_PINV4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PINV3
	{ S_PINV4, SPR_PINV,32771,6,NULL,S_PINV,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PINV4
	{ S_PSTR, SPR_PSTR,32768,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PSTR
	{ S_PINS, SPR_PINS,32768,6,NULL,S_PINS2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PINS
	{ S_PINS2, SPR_PINS,32769,6,NULL,S_PINS3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PINS2
	{ S_PINS3, SPR_PINS,32770,6,NULL,S_PINS4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PINS3
	{ S_PINS4, SPR_PINS,32771,6,NULL,S_PINS,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PINS4
	{ S_MEGA, SPR_MEGA,32768,6,NULL,S_MEGA2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MEGA
	{ S_MEGA2, SPR_MEGA,32769,6,NULL,S_MEGA3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MEGA2
	{ S_MEGA3, SPR_MEGA,32770,6,NULL,S_MEGA4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MEGA3
	{ S_MEGA4, SPR_MEGA,32771,6,NULL,S_MEGA,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MEGA4
	{ S_SUIT, SPR_SUIT,32768,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SUIT
	{ S_PMAP, SPR_PMAP,32768,6,NULL,S_PMAP2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PMAP
	{ S_PMAP2, SPR_PMAP,32769,6,NULL,S_PMAP3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PMAP2
	{ S_PMAP3, SPR_PMAP,32770,6,NULL,S_PMAP4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PMAP3
	{ S_PMAP4, SPR_PMAP,32771,6,NULL,S_PMAP5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PMAP4
	{ S_PMAP5, SPR_PMAP,32770,6,NULL,S_PMAP6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PMAP5
	{ S_PMAP6, SPR_PMAP,32769,6,NULL,S_PMAP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PMAP6
	{ S_PVIS, SPR_PVIS,32768,6,NULL,S_PVIS2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PVIS
	{ S_PVIS2, SPR_PVIS,1,6,NULL,S_PVIS,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PVIS2
	{ S_CLIP, SPR_CLIP,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CLIP
	{ S_AMMO, SPR_AMMO,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_AMMO
	{ S_ROCK, SPR_ROCK,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_ROCK
	{ S_BROK, SPR_BROK,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BROK
	{ S_CELL, SPR_CELL,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CELL
	{ S_CELP, SPR_CELP,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CELP
	{ S_SHEL, SPR_SHEL,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SHEL
	{ S_SBOX, SPR_SBOX,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SBOX
	{ S_BPAK, SPR_BPAK,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BPAK
	{ S_BFUG, SPR_BFUG,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BFUG
	{ S_MGUN, SPR_MGUN,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MGUN
	{ S_CSAW, SPR_CSAW,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CSAW
	{ S_LAUN, SPR_LAUN,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_LAUN
	{ S_PLAS, SPR_PLAS,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_PLAS
	{ S_SHOT, SPR_SHOT,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SHOT
	{ S_SHOT2, SPR_SGN2,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SHOT2
	{ S_COLU, SPR_COLU,32768,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COLU
	{ S_STALAG, SPR_SMT2,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_STALAG
	{ S_BLOODYTWITCH, SPR_GOR1,0,10,NULL,S_BLOODYTWITCH2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLOODYTWITCH
	{ S_BLOODYTWITCH2, SPR_GOR1,1,15,NULL,S_BLOODYTWITCH3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLOODYTWITCH2
	{ S_BLOODYTWITCH3, SPR_GOR1,2,8,NULL,S_BLOODYTWITCH4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLOODYTWITCH3
	{ S_BLOODYTWITCH4, SPR_GOR1,1,6,NULL,S_BLOODYTWITCH,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLOODYTWITCH4
	{ S_DEADTORSO, SPR_PLAY,13,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DEADTORSO
	{ S_DEADBOTTOM, SPR_PLAY,18,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DEADBOTTOM
	{ S_HEADSONSTICK, SPR_POL2,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEADSONSTICK
	{ S_GIBS, SPR_POL5,0,-1,A_Gibify,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_GIBS
	{ S_HEADONASTICK, SPR_POL4,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEADONASTICK
	{ S_HEADCANDLES, SPR_POL3,32768,6,NULL,S_HEADCANDLES2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEADCANDLES
	{ S_HEADCANDLES2, SPR_POL3,32769,6,NULL,S_HEADCANDLES,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEADCANDLES2
	{ S_DEADSTICK, SPR_POL1,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_DEADSTICK
	{ S_LIVESTICK, SPR_POL6,0,6,NULL,S_LIVESTICK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_LIVESTICK
	{ S_LIVESTICK2, SPR_POL6,1,8,NULL,S_LIVESTICK,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_LIVESTICK2
	{ S_MEAT2, SPR_GOR2,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MEAT2
	{ S_MEAT3, SPR_GOR3,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MEAT3
	{ S_MEAT4, SPR_GOR4,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MEAT4
	{ S_MEAT5, SPR_GOR5,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_MEAT5
	{ S_STALAGTITE, SPR_SMIT,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_STALAGTITE
	{ S_TALLGRNCOL, SPR_COL1,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TALLGRNCOL
	{ S_SHRTGRNCOL, SPR_COL2,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SHRTGRNCOL
	{ S_TALLREDCOL, SPR_COL3,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TALLREDCOL
	{ S_SHRTREDCOL, SPR_COL4,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SHRTREDCOL
	{ S_CANDLESTIK, SPR_CAND,32768,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CANDLESTIK
	{ S_CANDELABRA, SPR_CBRA,32768,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_CANDELABRA
	{ S_SKULLCOL, SPR_COL6,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SKULLCOL
	{ S_TORCHTREE, SPR_TRE1,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TORCHTREE
	{ S_BIGTREE, SPR_TRE2,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BIGTREE
	{ S_TECHPILLAR, SPR_ELEC,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TECHPILLAR
	{ S_EVILEYE, SPR_CEYE,32768,6,NULL,S_EVILEYE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_EVILEYE
	{ S_EVILEYE2, SPR_CEYE,32769,6,NULL,S_EVILEYE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_EVILEYE2
	{ S_EVILEYE3, SPR_CEYE,32770,6,NULL,S_EVILEYE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_EVILEYE3
	{ S_EVILEYE4, SPR_CEYE,32769,6,NULL,S_EVILEYE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_EVILEYE4
	{ S_FLOATSKULL, SPR_FSKU,32768,6,NULL,S_FLOATSKULL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FLOATSKULL
	{ S_FLOATSKULL2, SPR_FSKU,32769,6,NULL,S_FLOATSKULL3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FLOATSKULL2
	{ S_FLOATSKULL3, SPR_FSKU,32770,6,NULL,S_FLOATSKULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_FLOATSKULL3
	{ S_HEARTCOL, SPR_COL5,0,14,NULL,S_HEARTCOL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEARTCOL
	{ S_HEARTCOL2, SPR_COL5,1,14,NULL,S_HEARTCOL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HEARTCOL2
	{ S_BLUETORCH, SPR_TBLU,32768,4,NULL,S_BLUETORCH2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLUETORCH
	{ S_BLUETORCH2, SPR_TBLU,32769,4,NULL,S_BLUETORCH3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLUETORCH2
	{ S_BLUETORCH3, SPR_TBLU,32770,4,NULL,S_BLUETORCH4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLUETORCH3
	{ S_BLUETORCH4, SPR_TBLU,32771,4,NULL,S_BLUETORCH,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BLUETORCH4
	{ S_GREENTORCH, SPR_TGRN,32768,4,NULL,S_GREENTORCH2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_GREENTORCH
	{ S_GREENTORCH2, SPR_TGRN,32769,4,NULL,S_GREENTORCH3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_GREENTORCH2
	{ S_GREENTORCH3, SPR_TGRN,32770,4,NULL,S_GREENTORCH4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_GREENTORCH3
	{ S_GREENTORCH4, SPR_TGRN,32771,4,NULL,S_GREENTORCH,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_GREENTORCH4
	{ S_REDTORCH, SPR_TRED,32768,4,NULL,S_REDTORCH2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_REDTORCH
	{ S_REDTORCH2, SPR_TRED,32769,4,NULL,S_REDTORCH3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_REDTORCH2
	{ S_REDTORCH3, SPR_TRED,32770,4,NULL,S_REDTORCH4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_REDTORCH3
	{ S_REDTORCH4, SPR_TRED,32771,4,NULL,S_REDTORCH,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_REDTORCH4
	{ S_BTORCHSHRT, SPR_SMBT,32768,4,NULL,S_BTORCHSHRT2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BTORCHSHRT
	{ S_BTORCHSHRT2, SPR_SMBT,32769,4,NULL,S_BTORCHSHRT3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BTORCHSHRT2
	{ S_BTORCHSHRT3, SPR_SMBT,32770,4,NULL,S_BTORCHSHRT4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BTORCHSHRT3
	{ S_BTORCHSHRT4, SPR_SMBT,32771,4,NULL,S_BTORCHSHRT,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_BTORCHSHRT4
	{ S_GTORCHSHRT, SPR_SMGT,32768,4,NULL,S_GTORCHSHRT2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_GTORCHSHRT
	{ S_GTORCHSHRT2, SPR_SMGT,32769,4,NULL,S_GTORCHSHRT3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_GTORCHSHRT2
	{ S_GTORCHSHRT3, SPR_SMGT,32770,4,NULL,S_GTORCHSHRT4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_GTORCHSHRT3
	{ S_GTORCHSHRT4, SPR_SMGT,32771,4,NULL,S_GTORCHSHRT,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_GTORCHSHRT4
	{ S_RTORCHSHRT, SPR_SMRT,32768,4,NULL,S_RTORCHSHRT2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RTORCHSHRT
	{ S_RTORCHSHRT2, SPR_SMRT,32769,4,NULL,S_RTORCHSHRT3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RTORCHSHRT2
	{ S_RTORCHSHRT3, SPR_SMRT,32770,4,NULL,S_RTORCHSHRT4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RTORCHSHRT3
	{ S_RTORCHSHRT4, SPR_SMRT,32771,4,NULL,S_RTORCHSHRT,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_RTORCHSHRT4
	{ S_HANGNOGUTS, SPR_HDB1,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HANGNOGUTS
	{ S_HANGBNOBRAIN, SPR_HDB2,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HANGBNOBRAIN
	{ S_HANGTLOOKDN, SPR_HDB3,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HANGTLOOKDN
	{ S_HANGTSKULL, SPR_HDB4,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HANGTSKULL
	{ S_HANGTLOOKUP, SPR_HDB5,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HANGTLOOKUP
	{ S_HANGTNOBRAIN, SPR_HDB6,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_HANGTNOBRAIN
	{ S_COLONGIBS, SPR_POB1,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_COLONGIBS
	{ S_SMALLPOOL, SPR_POB2,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_SMALLPOOL
	{ S_BRAINSTEM, SPR_BRS1,0,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},		// S_BRAINSTEM
	{ S_TECHLAMP, SPR_TLMP,32768,4,NULL,S_TECHLAMP2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TECHLAMP
	{ S_TECHLAMP2, SPR_TLMP,32769,4,NULL,S_TECHLAMP3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TECHLAMP2
	{ S_TECHLAMP3, SPR_TLMP,32770,4,NULL,S_TECHLAMP4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TECHLAMP3
	{ S_TECHLAMP4, SPR_TLMP,32771,4,NULL,S_TECHLAMP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TECHLAMP4
	{ S_TECH2LAMP, SPR_TLP2,32768,4,NULL,S_TECH2LAMP2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TECH2LAMP
	{ S_TECH2LAMP2, SPR_TLP2,32769,4,NULL,S_TECH2LAMP3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TECH2LAMP2
	{ S_TECH2LAMP3, SPR_TLP2,32770,4,NULL,S_TECH2LAMP4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TECH2LAMP3
	{ S_TECH2LAMP4, SPR_TLP2,32771,4,NULL,S_TECH2LAMP,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},	// S_TECH2LAMP4

	// Boom/MBF stuff starts here

	{S_TNT1, SPR_TNT1,0,-1,NULL,S_TNT1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},          // S_TNT1    // phares 3/8/98

	// killough 8/9/98: grenade
	{ S_GRENADE, SPR_MISL,32768,1000,A_Die,S_GRENADE,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},      // S_GRENADE

	// killough 8/10/98: variable damage explosion
	{ S_DETONATE, SPR_MISL,32769,4,A_Scream,S_DETONATE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},    // S_DETONATE
	{ S_DETONATE2, SPR_MISL,32770,6,A_Detonate,S_DETONATE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DETONATE2
	{ S_DETONATE3, SPR_MISL,32771,10,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},            // S_DETONATE3

	// killough 7/19/98: Marine's best friend :)
	{ S_DOGS_STND, SPR_DOGS,0,10,A_Look,S_DOGS_STND2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DOGS_STND
	{ S_DOGS_STND2, SPR_DOGS,1,10,A_Look,S_DOGS_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_STND2
	{ S_DOGS_RUN1, SPR_DOGS,0,2,A_Chase,S_DOGS_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RUN1
	{ S_DOGS_RUN2, SPR_DOGS,0,2,A_Chase,S_DOGS_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RUN2
	{ S_DOGS_RUN3, SPR_DOGS,1,2,A_Chase,S_DOGS_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RUN3
	{ S_DOGS_RUN4, SPR_DOGS,1,2,A_Chase,S_DOGS_RUN5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RUN4
	{ S_DOGS_RUN5, SPR_DOGS,2,2,A_Chase,S_DOGS_RUN6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RUN5
	{ S_DOGS_RUN6, SPR_DOGS,2,2,A_Chase,S_DOGS_RUN7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RUN6
	{ S_DOGS_RUN7, SPR_DOGS,3,2,A_Chase,S_DOGS_RUN8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RUN7
	{ S_DOGS_RUN8, SPR_DOGS,3,2,A_Chase,S_DOGS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RUN8
	{ S_DOGS_ATK1, SPR_DOGS,4,8,A_FaceTarget,S_DOGS_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DOGS_ATK1
	{ S_DOGS_ATK2, SPR_DOGS,5,8,A_FaceTarget,S_DOGS_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DOGS_ATK2
	{ S_DOGS_ATK3, SPR_DOGS,6,8,A_SargAttack,S_DOGS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DOGS_ATK3
	{ S_DOGS_PAIN, SPR_DOGS,7,2,NULL,S_DOGS_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_PAIN
	{ S_DOGS_PAIN2, SPR_DOGS,7,2,A_Pain,S_DOGS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DOGS_PAIN2
	{ S_DOGS_DIE1, SPR_DOGS,8,8,NULL,S_DOGS_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DOGS_DIE1
	{ S_DOGS_DIE2, SPR_DOGS,9,8,A_Scream,S_DOGS_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DOGS_DIE2
	{ S_DOGS_DIE3, SPR_DOGS,10,4,NULL,S_DOGS_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_DIE3
	{ S_DOGS_DIE4, SPR_DOGS,11,4,A_Fall,S_DOGS_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_DIE4
	{ S_DOGS_DIE5, SPR_DOGS,12,4,NULL,S_DOGS_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_DIE5
	{ S_DOGS_DIE6, SPR_DOGS,13,-1,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_DIE6
	{ S_DOGS_RAISE1, SPR_DOGS,13,5,NULL,S_DOGS_RAISE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RAISE1
	{ S_DOGS_RAISE2, SPR_DOGS,12,5,NULL,S_DOGS_RAISE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RAISE2
	{ S_DOGS_RAISE3, SPR_DOGS,11,5,NULL,S_DOGS_RAISE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RAISE3
	{ S_DOGS_RAISE4, SPR_DOGS,10,5,NULL,S_DOGS_RAISE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_DOGS_RAISE4
	{ S_DOGS_RAISE5, SPR_DOGS,9,5,NULL,S_DOGS_RAISE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DOGS_RAISE5
	{ S_DOGS_RAISE6, SPR_DOGS,8,5,NULL,S_DOGS_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_DOGS_RAISE6

	// killough 7/11/98: beta BFG begins here
	// S_OLDBFG1

#define BFGDELAY 1
#define OLDBFG_1FRAMES(x) {x+S_OLDBFG1+1, SPR_BFGG,1,BFGDELAY,A_FireOldBFG,static_cast<statenum_t>(x+S_OLDBFG1+2),0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},
#define OLDBFG_2FRAMES(x) OLDBFG_1FRAMES(x) OLDBFG_1FRAMES(x+1)
#define OLDBFG_4FRAMES(x) OLDBFG_2FRAMES(x) OLDBFG_2FRAMES(x+2)
#define OLDBFG_8FRAMES(x) OLDBFG_4FRAMES(x) OLDBFG_4FRAMES(x+4)
	{ S_OLDBFG1, SPR_BFGG,0,10,A_BFGsound,static_cast<statenum_t>(S_OLDBFG1+1),0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_OLDBFG1

	OLDBFG_8FRAMES(0)
	OLDBFG_8FRAMES(8)
	OLDBFG_8FRAMES(16)
	OLDBFG_8FRAMES(24)
	OLDBFG_8FRAMES(32)

	{ S_OLDBFG42, SPR_BFGG,1,0,A_Light0,S_OLDBFG43,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_OLDBFG42
	{ S_OLDBFG43, SPR_BFGG,1,20,A_ReFire,S_BFG,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},   // S_OLDBFG43

	// killough 7/11/98: end of beta BFG

	// killough 7/19/98: First plasma fireball in the beta:
	{ S_PLS1BALL, SPR_PLS1,32768,6,NULL,S_PLS1BALL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_PLS1BALL
	{ S_PLS1BALL2, SPR_PLS1,32769,6,NULL,S_PLS1BALL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_PLS1BALL2
	{ S_PLS1EXP, SPR_PLS1,32770,4,NULL,S_PLS1EXP2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_PLS1EXP
	{ S_PLS1EXP2, SPR_PLS1,32771,4,NULL,S_PLS1EXP3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_PLS1EXP2
	{ S_PLS1EXP3, SPR_PLS1,32772,4,NULL,S_PLS1EXP4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_PLS1EXP3
	{ S_PLS1EXP4, SPR_PLS1,32773,4,NULL,S_PLS1EXP5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_PLS1EXP4
	{ S_PLS1EXP5, SPR_PLS1,32774,4,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_PLS1EXP5

	// killough 7/19/98: Second plasma fireball in the beta:
	{ S_PLS2BALL, SPR_PLS2,32768,4,NULL,S_PLS2BALL2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_PLS2BALL
	{ S_PLS2BALL2, SPR_PLS2,32769,4,NULL,S_PLS2BALL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_PLS2BALL2
	{ S_PLS2BALLX1, SPR_PLS2,32770,6,NULL,S_PLS2BALLX2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_PLS2BALLX1
	{ S_PLS2BALLX2, SPR_PLS2,32771,6,NULL,S_PLS2BALLX3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_PLS2BALLX2
	{ S_PLS2BALLX3, SPR_PLS2,32772,6,NULL,S_NULL,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_PLS2BALLX3

	{S_BON3, SPR_BON3,0,6,NULL,S_BON3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},           // S_BON3  // killough 7/11/98:
	{S_BON4, SPR_BON4,0,6,NULL,S_BON4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},           // S_BON4  // beta bonus items

	// killough 10/98: beta lost souls attacked from a distance,
	// animated with colors, and stayed in the air when killed.
	// This is an approximation, but I'm sure it can be improved.

	// spawnstate
	{ S_BSKUL_STND, SPR_SKUL,0,10,A_Look,S_BSKUL_STND,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_BSKUL_STND

	// chasestate
	{ S_BSKUL_RUN1, SPR_SKUL,1,5,A_Chase,S_BSKUL_RUN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_BSKUL_RUN1
	{ S_BSKUL_RUN2, SPR_SKUL,2,5,A_Chase,S_BSKUL_RUN3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_BSKUL_RUN2
	{ S_BSKUL_RUN3, SPR_SKUL,3,5,A_Chase,S_BSKUL_RUN4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_BSKUL_RUN3
	{ S_BSKUL_RUN4, SPR_SKUL,0,5,A_Chase,S_BSKUL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_BSKUL_RUN4

	// missilestate
	{ S_BSKUL_ATK1, SPR_SKUL,4,4,A_FaceTarget,S_BSKUL_ATK2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},     // S_BSKUL_ATK1
	{ S_BSKUL_ATK2, SPR_SKUL,5,5,A_BetaSkullAttack,S_BSKUL_ATK3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_BSKUL_ATK2
	{ S_BSKUL_ATK3, SPR_SKUL,5,4,NULL,S_BSKUL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},              // S_BSKUL_ATK3

	// painstate
	{ S_BSKUL_PAIN1, SPR_SKUL,6,4,NULL,S_BSKUL_PAIN2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},     // S_BSKUL_PAIN1
	{ S_BSKUL_PAIN2, SPR_SKUL,7,2,A_Pain,S_BSKUL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},   // S_BSKUL_PAIN2
	{ S_BSKUL_PAIN3, SPR_SKUL,8,4,NULL,S_BSKUL_RUN1,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},      // S_BSKUL_PAIN3

	// deathstate
	{ S_BSKUL_DIE1, SPR_SKUL, 9,5,NULL,S_BSKUL_DIE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},     // S_BSKUL_DIE1
	{ S_BSKUL_DIE2, SPR_SKUL,10,5,NULL,S_BSKUL_DIE3,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},     // S_BSKUL_DIE2
	{ S_BSKUL_DIE3, SPR_SKUL,11,5,NULL,S_BSKUL_DIE4,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},     // S_BSKUL_DIE3
	{ S_BSKUL_DIE4, SPR_SKUL,12,5,NULL,S_BSKUL_DIE5,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},     // S_BSKUL_DIE4
	{ S_BSKUL_DIE5, SPR_SKUL,13,5,A_Scream,S_BSKUL_DIE6,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE}, // S_BSKUL_DIE5
	{ S_BSKUL_DIE6, SPR_SKUL,14,5,NULL,S_BSKUL_DIE7,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},     // S_BSKUL_DIE6
	{ S_BSKUL_DIE7, SPR_SKUL,15,5,A_Fall,S_BSKUL_DIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},   // S_BSKUL_DIE7
	{ S_BSKUL_DIE8, SPR_SKUL,16,5,A_Stop,S_BSKUL_DIE8,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},   // S_BSKUL_DIE8

	// killough 10/98: mushroom effect
	{ S_MUSHROOM, SPR_MISL,32769,8,A_Mushroom,S_EXPLODE2,0,0, {0, 0, 0, 0, 0, 0, 0, 0}, STATEF_NONE},  // S_MUSHROOM
};

// [Blair] Since Odamex has more out-of-the-box states,
// the new DEHExtra state spec starts at 1100, while we have around
// 1130.
// [CMB] odamex objects are now handled separately

mobjinfo_t doom_mobjinfo[::NUMMOBJTYPES] = {

	{		// MT_PLAYER
	MT_PLAYER,
	-1,		// doomednum
	S_PLAY,		// spawnstate
	100,		// spawnhealth
	-100,		// gibhealth
	S_PLAY_RUN1,		// seestate
	NULL,		// seesound
	0,		// reactiontime
	NULL,		// attacksound
	S_PLAY_PAIN,		// painstate
	255,		// painchance
	"*pain100_1",		// painsound
	S_NULL,		// meleestate
	S_PLAY_ATK1,		// missilestate
	S_PLAY_DIE1,		// deathstate
	S_PLAY_XDIE1,		// xdeathstate
	"*death1",		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_DROPOFF|MF_PICKUP|MF_NOTDMATCH|MF_FRIEND,		// flags
	MF2_SLIDE|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_PLAYER",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT, // meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_POSSESSED
	MT_POSSESSED,
	3004,		// doomednum
	S_POSS_STND,		// spawnstate
	20,		// spawnhealth
    -20,	// gibhealth
	S_POSS_RUN1,		// seestate
	"grunt/sight1",		// seesound
	8,		// reactiontime
	"grunt/attack",		// attacksound
	S_POSS_PAIN,		// painstate
	200,		// painchance
	"grunt/pain",		// painsound
	S_NULL,		// meleestate
	S_POSS_ATK1,		// missilestate
	S_POSS_DIE1,		// deathstate
	S_POSS_XDIE1,		// xdeathstate
	"grunt/death1",		// deathsound
	8,		// speed
	20*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	"grunt/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_POSS_RAISE1,		// raisestate
	0x10000,
	"MT_POSSESSED",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_CLIP		// droppeditem
  },

	{		// MT_SHOTGUY
	MT_SHOTGUY,
	9,		// doomednum
	S_SPOS_STND,		// spawnstate
	30,		// spawnhealth
	-30,	// gibhealth
	S_SPOS_RUN1,		// seestate
	"shotguy/sight1",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_SPOS_PAIN,		// painstate
	170,		// painchance
	"shotguy/pain",		// painsound
	S_NULL,		// meleestate
	S_SPOS_ATK1,		// missilestate
	S_SPOS_DIE1,		// deathstate
	S_SPOS_XDIE1,		// xdeathstate
	"shotguy/death1",		// deathsound
	8,		// speed
	20*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	"shotguy/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_SPOS_RAISE1,		// raisestate
	0x10000,
	"MT_SHOTGUY",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_SHOTGUN		// droppeditem
  },

	{		// MT_VILE
	MT_VILE,
	64,		// doomednum
	S_VILE_STND,		// spawnstate
	700,		// spawnhealth
	0,                                      // gibhealth
	S_VILE_RUN1,		// seestate
	"vile/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_VILE_PAIN,		// painstate
	10,		// painchance
	"vile/pain",		// painsound
	S_NULL,		// meleestate
	S_VILE_ATK1,		// missilestate
	S_VILE_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"vile/death",		// deathsound
	15,		// speed
	20*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	500,		// mass
	0,		// damage
	"vile/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
     MF2_MCROSS | MF2_PASSMOBJ | MF2_PUSHWALL, // flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_VILE",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	MF3_SHORTMRANGE | MF3_DMGIGNORED | MF3_NOTHRESHOLD,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_FIRE
	MT_FIRE,
	-1,		// doomednum
	S_FIRE1,		// spawnstate
	1000,		// spawnhealth
	0,			// gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOGRAVITY,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_FIRE",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_UNDEAD
	MT_UNDEAD,
	66,		// doomednum
	S_SKEL_STND,		// spawnstate
	300,		// spawnhealth
	0,			// gibhealth
	S_SKEL_RUN1,		// seestate
	"skeleton/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_SKEL_PAIN,		// painstate
	100,		// painchance
	"skeleton/pain",		// painsound
	S_SKEL_FIST1,		// meleestate
	S_SKEL_MISS1,		// missilestate
	S_SKEL_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"skeleton/death",		// deathsound
	10,		// speed
	20*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	500,		// mass
	0,		// damage
	"skeleton/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_SKEL_RAISE1,		// raisestate
	0x10000,
	"MT_UNDEAD",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	MF3_LONGMELEE | MF3_RANGEHALF,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_TRACER
	MT_TRACER,
	-1,		// doomednum
	S_TRACER,		// spawnstate
	1000,		// spawnhealth
	0,			// gibhealth
	S_NULL,		// seestate
	"skeleton/attack",		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_TRACEEXP1,		// deathstate
	S_NULL,		// xdeathstate
	"skeleton/tracex",		// deathsound
	10*FRACUNIT,		// speed
	11*FRACUNIT,		// radius
	8*FRACUNIT,		// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	10,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,		// flags
	MF2_PCROSS|MF2_IMPACT|MF2_SEEKERMISSILE,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_TRACER",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_SMOKE
	MT_SMOKE,
	-1,		// doomednum
	S_SMOKE1,		// spawnstate
	1000,		// spawnhealth
	0,			// gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_SMOKE",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_FATSO
	MT_FATSO,
	67,		// doomednum
	S_FATT_STND,		// spawnstate
	600,		// spawnhealth
	0,			// gibhealth
	S_FATT_RUN1,		// seestate
	"fatso/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_FATT_PAIN,		// painstate
	80,		// painchance
	"fatso/pain",		// painsound
	S_NULL,		// meleestate
	S_FATT_ATK1,		// missilestate
	S_FATT_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"fatso/death",		// deathsound
	8,		// speed
	48*FRACUNIT,		// radius
	64*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	1000,		// mass
	0,		// damage
	"fatso/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_FATT_RAISE1,		// raisestate
	0x10000,
	"MT_FATSO",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	MF3_MAP07BOSS1,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_FATSHOT
	MT_FATSHOT,
	-1,		// doomednum
	S_FATSHOT1,		// spawnstate
	1000,		// spawnhealth
	0,			// gibhealth
	S_NULL,		// seestate
	"fatso/attack",		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_FATSHOTX1,		// deathstate
	S_NULL,		// xdeathstate
	"fatso/shotx",		// deathsound
	20*FRACUNIT,		// speed
	6*FRACUNIT,		// radius
	8*FRACUNIT,		// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	8,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,		// flags
	MF2_PCROSS|MF2_IMPACT,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_FATSHOT",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_CHAINGUY
	MT_CHAINGUY,
	65,		// doomednum
	S_CPOS_STND,		// spawnstate
	70,		// spawnhealth
	-70,	// gibhealth
	S_CPOS_RUN1,		// seestate
	"chainguy/sight1",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_CPOS_PAIN,		// painstate
	170,		// painchance
	"chainguy/pain",		// painsound
	S_NULL,		// meleestate
	S_CPOS_ATK1,		// missilestate
	S_CPOS_DIE1,		// deathstate
	S_CPOS_XDIE1,		// xdeathstate
	"chainguy/death1",		// deathsound
	8,		// speed
	20*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	"chainguy/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_CPOS_RAISE1,		// raisestate
	0x10000,
	"MT_CHAINGUY",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_CHAINGUN		// droppeditem
	},

	{		// MT_TROOP
	MT_TROOP,
	3001,		// doomednum
	S_TROO_STND,		// spawnstate
	60,		// spawnhealth
	-60,	// gibhealth
	S_TROO_RUN1,		// seestate
	"imp/sight1",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_TROO_PAIN,		// painstate
	200,		// painchance
	"imp/pain",		// painsound
	S_TROO_ATK1,		// meleestate
	S_TROO_ATK1,		// missilestate
	S_TROO_DIE1,		// deathstate
	S_TROO_XDIE1,		// xdeathstate
	"imp/death1",		// deathsound
	8,		// speed
	20*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	"imp/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_TROO_RAISE1,		// raisestate
	0x10000,
	"MT_TROOP",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_SERGEANT
	MT_SERGEANT,
	3002,		// doomednum
	S_SARG_STND,		// spawnstate
	150,		// spawnhealth
    0,	// gibhealth
	S_SARG_RUN1,		// seestate
	"demon/sight",		// seesound
	8,		// reactiontime
	"demon/melee",		// attacksound
	S_SARG_PAIN,		// painstate
	180,		// painchance
	"demon/pain",		// painsound
	S_SARG_ATK1,		// meleestate
	S_NULL,		// missilestate
	S_SARG_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"demon/death",		// deathsound
	10,		// speed
	30*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	400,		// mass
	0,		// damage
	"demon/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_SARG_RAISE1,		// raisestate
	0x10000,
	"MT_SERGEANT",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_SHADOWS
	MT_SHADOWS,
	58,		// doomednum
	S_SARG_STND,		// spawnstate
	150,		// spawnhealth
	0,			// gibhealth
	S_SARG_RUN1,		// seestate
	"spectre/sight",		// seesound
	8,		// reactiontime
	"spectre/attack",		// attacksound
	S_SARG_PAIN,		// painstate
	180,		// painchance
	"spectre/pain",		// painsound
	S_SARG_ATK1,		// meleestate
	S_NULL,		// missilestate
	S_SARG_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"spectre/death",		// deathsound
	10,		// speed
	30*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	400,		// mass
	0,		// damage
	"spectre/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_SHADOW|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_SARG_RAISE1,		// raisestate
	0x10000,
	"MT_SHADOWS",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_HEAD
	MT_HEAD,
	3005,		// doomednum
	S_HEAD_STND,		// spawnstate
	400,		// spawnhealth
	0,			// gibhealth
	S_HEAD_RUN1,		// seestate
	"caco/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_HEAD_PAIN,		// painstate
	128,		// painchance
	"caco/pain",		// painsound
	S_NULL,		// meleestate
	S_HEAD_ATK1,		// missilestate
	S_HEAD_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"caco/death",		// deathsound
	8,		// speed
	31*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	400,		// mass
	0,		// damage
	"caco/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_HEAD_RAISE1,		// raisestate
	0x10000,
	"MT_HEAD",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_BRUISER
	MT_BRUISER,
	3003,		// doomednum
	S_BOSS_STND,		// spawnstate
	1000,		// spawnhealth
	0,			// gibhealth
	S_BOSS_RUN1,		// seestate
	"baron/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_BOSS_PAIN,		// painstate
	50,		// painchance
	"baron/pain",		// painsound
	S_BOSS_ATK1,		// meleestate
	S_BOSS_ATK1,		// missilestate
	S_BOSS_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"baron/death",		// deathsound
	8,		// speed
	24*FRACUNIT,		// radius
	64*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	1000,		// mass
	0,		// damage
	"baron/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_BOSS_RAISE1,		// raisestate
	0x10000,
	"MT_BRUISER",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_BARON,		// projectile group
	SG_DEFAULT,		// splash group
	MF3_E1M8BOSS,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_BRUISERSHOT
	MT_BRUISERSHOT,
	-1,		// doomednum
	S_BRBALL1,		// spawnstate
	1000,		// spawnhealth
	0,	// gibhealth
	S_NULL,		// seestate
	"baron/attack",		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_BRBALLX1,		// deathstate
	S_NULL,		// xdeathstate
	"baron/shotx",		// deathsound
	15*FRACUNIT,		// speed
	6*FRACUNIT,		// radius
	8*FRACUNIT,		// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	8,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,		// flags
	MF2_PCROSS|MF2_IMPACT,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_BRUISERSHOT",
	20 * FRACUNIT,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_KNIGHT
	MT_KNIGHT,
	69,		// doomednum
	S_BOS2_STND,		// spawnstate
	500,		// spawnhealth
	0, // gibhealth
	S_BOS2_RUN1,		// seestate
	"knight/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_BOS2_PAIN,		// painstate
	50,		// painchance
	"knight/pain",		// painsound
	S_BOS2_ATK1,		// meleestate
	S_BOS2_ATK1,		// missilestate
	S_BOS2_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"knight/death",		// deathsound
	8,		// speed
	24*FRACUNIT,		// radius
	64*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	1000,		// mass
	0,		// damage
	"knight/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_BOS2_RAISE1,		// raisestate
	0x10000,
	"MT_KNIGHT",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_BARON,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_SKULL
	MT_SKULL,
	3006,		// doomednum
	S_SKULL_STND,		// spawnstate
	100,		// spawnhealth
    0, // gibhealth
	S_SKULL_RUN1,		// seestate
	0,		// seesound
	8,		// reactiontime
	"skull/melee",		// attacksound
	S_SKULL_PAIN,		// painstate
	256,		// painchance
	"skull/pain",		// painsound
	S_NULL,		// meleestate
	S_SKULL_ATK1,		// missilestate
	S_SKULL_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"skull/death",		// deathsound
	8,		// speed
	16*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	50,		// mass
	3,		// damage
	"skull/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_SKULL",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	MF3_RANGEHALF,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_SPIDER
	MT_SPIDER,
	7,		// doomednum
	S_SPID_STND,		// spawnstate
	3000,		// spawnhealth
	0,	// gibhealth
	S_SPID_RUN1,		// seestate
	"spider/sight",		// seesound
	8,		// reactiontime
	"spider/attack",		// attacksound
	S_SPID_PAIN,		// painstate
	40,		// painchance
	"spider/pain",		// painsound
	S_NULL,		// meleestate
	S_SPID_ATK1,		// missilestate
	S_SPID_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"spider/death",		// deathsound
	12,		// speed
	128*FRACUNIT,		// radius
	100*FRACUNIT,		// height
	100*FRACUNIT,	// cdheight
	1000,		// mass
	0,		// damage
	"spider/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL|MF2_BOSS,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_SPIDER",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	MF3_NORADIUSDMG | MF3_RANGEHALF | MF3_FULLVOLSOUNDS | MF3_E3M8BOSS | MF3_E4M8BOSS,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_BABY
	MT_BABY,
	68,		// doomednum
	S_BSPI_STND,		// spawnstate
	500,		// spawnhealth
	0,		// gibhealth
	S_BSPI_SIGHT,		// seestate
	"baby/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_BSPI_PAIN,		// painstate
	128,		// painchance
	"baby/pain",		// painsound
	S_NULL,		// meleestate
	S_BSPI_ATK1,		// missilestate
	S_BSPI_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"baby/death",		// deathsound
	12,		// speed
	64*FRACUNIT,		// radius
	64*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	600,		// mass
	0,		// damage
	"baby/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_BSPI_RAISE1,		// raisestate
	0x10000,
	"MT_BABY",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	MF3_MAP07BOSS2,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_CYBORG
	MT_CYBORG,
	16,		// doomednum
	S_CYBER_STND,		// spawnstate
	4000,		// spawnhealth
	0, // gibhealth
	S_CYBER_RUN1,		// seestate
	"cyber/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_CYBER_PAIN,		// painstate
	20,		// painchance
	"cyber/pain",		// painsound
	S_NULL,		// meleestate
	S_CYBER_ATK1,		// missilestate
	S_CYBER_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"cyber/death",		// deathsound
	16,		// speed
	40*FRACUNIT,		// radius
	110*FRACUNIT,		// height
	110*FRACUNIT,	// cdheight
	1000,		// mass
	0,		// damage
	"cyber/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL|MF2_BOSS,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_CYBORG",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	MF3_NORADIUSDMG | MF3_HIGHERMPROB | MF3_RANGEHALF | MF3_FULLVOLSOUNDS | MF3_E2M8BOSS | MF3_E4M6BOSS,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_PAIN
	MT_PAIN,
	71,		// doomednum
	S_PAIN_STND,		// spawnstate
	400,		// spawnhealth
    0, // gibhealth
	S_PAIN_RUN1,		// seestate
	"pain/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_PAIN_PAIN,		// painstate
	128,		// painchance
	"pain/pain",		// painsound
	S_NULL,		// meleestate
	S_PAIN_ATK1,		// missilestate
	S_PAIN_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"pain/death",		// deathsound
	8,		// speed
	31*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	400,		// mass
	0,		// damage
	"pain/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_PAIN_RAISE1,		// raisestate
	0x10000,
	"MT_PAIN",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_WOLFSS
	MT_WOLFSS,
	84,		// doomednum
	S_SSWV_STND,		// spawnstate
	50,		// spawnhealth
	-50,	// gibhealth
	S_SSWV_RUN1,		// seestate
	"wolfss/sight",		// seesound
	8,		// reactiontime
	0,		// attacksound
	S_SSWV_PAIN,		// painstate
	170,		// painchance
	"wolfss/pain",		// painsound
	S_NULL,		// meleestate
	S_SSWV_ATK1,		// missilestate
	S_SSWV_DIE1,		// deathstate
	S_SSWV_XDIE1,		// xdeathstate
	"wolfss/death",		// deathsound
	8,		// speed
	20*FRACUNIT,		// radius
	56*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	"wolfss/active",		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL,		// flags2
	S_SSWV_RAISE1,		// raisestate
	0x10000,
	"MT_WOLFSS",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_CLIP		// droppeditem
	},

	{		// MT_KEEN
	MT_KEEN,
	72,		// doomednum
	S_KEENSTND,		// spawnstate
	100,		// spawnhealth
	0,			// gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_KEENPAIN,		// painstate
	256,		// painchance
	"keen/pain",		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_COMMKEEN,		// deathstate
	S_NULL,		// xdeathstate
	"keen/death",		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	72*FRACUNIT,		// height
	51*FRACUNIT,	// cdheight
	10000000,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY|MF_SHOOTABLE|MF_COUNTKILL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_KEEN",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_BOSSBRAIN
	MT_BOSSBRAIN,
	88,		// doomednum
	S_BRAIN,		// spawnstate
	250,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_BRAIN_PAIN,		// painstate
	255,		// painchance
	"brain/pain",		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_BRAIN_DIE1,		// deathstate
	S_NULL,		// xdeathstate
	"brain/death",		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight (actually 86; don't stack these)
	10000000,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SHOOTABLE,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_BOSSBRAIN",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_BOSSSPIT
	MT_BOSSSPIT,
	89,		// doomednum
	S_BRAINEYE,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_BRAINEYESEE,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	32*FRACUNIT,		// height
	32*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOSECTOR,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_BOSSSPIT",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_BOSSTARGET
	MT_BOSSTARGET,
	87,		// doomednum
	S_NULL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	32*FRACUNIT,		// height
	32*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOSECTOR,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_BOSSTARGET",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_SPAWNSHOT
	MT_SPAWNSHOT,
	-1,		// doomednum
	S_SPAWN1,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	"brain/spit",		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	"brain/spawn",		// deathsound
	10*FRACUNIT,		// speed
	6*FRACUNIT,		// radius
	32*FRACUNIT,		// height
	32*FRACUNIT,	// cdheight
	100,		// mass
	3,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_NOCLIP,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_SPAWNSHOT",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_SPAWNFIRE
	MT_SPAWNFIRE,
	-1,		// doomednum
	S_SPAWNFIRE1,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_SPAWNFIRE",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_BARREL
	MT_BARREL,
	2035,		// doomednum
	S_BAR1,		// spawnstate
	20,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_BEXP,		// deathstate
	S_NULL,		// xdeathstate
	"world/barrelx",		// deathsound
	0,		// speed
	10*FRACUNIT,		// radius
	42*FRACUNIT,		// height
	34*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_BARREL",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_TROOPSHOT
	MT_TROOPSHOT,
	-1,		// doomednum
	S_TBALL1,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	"imp/attack",		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_TBALLX1,		// deathstate
	S_NULL,		// xdeathstate
	"imp/shotx",		// deathsound
	10*FRACUNIT,		// speed
	6*FRACUNIT,		// radius
	8*FRACUNIT,		// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	3,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,		// flags
	MF2_PCROSS|MF2_IMPACT,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_TROOPSHOT",
	20 * FRACUNIT,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_HEADSHOT
	MT_HEADSHOT,
	-1,		// doomednum
	S_RBALL1,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	"caco/attack",		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_RBALLX1,		// deathstate
	S_NULL,		// xdeathstate
	"caco/shotx",		// deathsound
	10*FRACUNIT,		// speed
	6*FRACUNIT,		// radius
	8*FRACUNIT,		// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	5,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,		// flags
	MF2_PCROSS|MF2_IMPACT,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_HEADSHOT",
	20 * FRACUNIT,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_ROCKET
	MT_ROCKET,
	-1,		// doomednum
	S_ROCKET,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	"weapons/rocklf",		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_EXPLODE1,		// deathstate
	S_NULL,		// xdeathstate
	"weapons/rocklx",		// deathsound
	20*FRACUNIT,		// speed
	11*FRACUNIT,		// radius
	8*FRACUNIT,		// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	20,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,		// flags
	MF2_PCROSS|MF2_IMPACT,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_ROCKET",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_PLASMA
	MT_PLASMA,
	-1,		// doomednum
	S_PLASBALL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	"weapons/plasmaf",		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_PLASEXP,		// deathstate
	S_NULL,		// xdeathstate
	"weapons/plasmax",		// deathsound
	25*FRACUNIT,		// speed
	13*FRACUNIT,		// radius
	8*FRACUNIT,		// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	5,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,		// flags
	MF2_PCROSS|MF2_IMPACT,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_PLASMA",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_BFG
	MT_BFG,
	-1,		// doomednum
	S_BFGSHOT,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	0,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_BFGLAND,		// deathstate
	S_NULL,		// xdeathstate
	"weapons/bfgx",		// deathsound
	25*FRACUNIT,		// speed
	13*FRACUNIT,		// radius
	8*FRACUNIT,		// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	100,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,		// flags
	MF2_PCROSS|MF2_IMPACT,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_BFG",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_ARACHPLAZ
	MT_ARACHPLAZ,
	-1,		// doomednum
	S_ARACH_PLAZ,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	"baby/attack",		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_ARACH_PLEX,		// deathstate
	S_NULL,		// xdeathstate
	"baby/shotx",		// deathsound
	25*FRACUNIT,		// speed
	13*FRACUNIT,		// radius
	8*FRACUNIT,		// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	5,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,		// flags
	MF2_PCROSS|MF2_IMPACT,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_ARACHPLAZ",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_PUFF
	MT_PUFF,
	-1,		// doomednum
	S_PUFF1,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_PUFF",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_BLOOD
	MT_BLOOD,
	-1,		// doomednum
	S_BLOOD1,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_BLOOD",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_TFOG
	MT_TFOG,
	-1,		// doomednum
	S_TFOG,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_TFOG",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_IFOG
	MT_IFOG,
	-1,		// doomednum
	S_IFOG,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_IFOG",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_TELEPORTMAN
	MT_TELEPORTMAN,
	14,		// doomednum
	S_NULL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOSECTOR,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_TELEPORTMAN",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_EXTRABFG
	MT_EXTRABFG,
	-1,		// doomednum
	S_BFGEXP,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	FRACUNIT,
	"MT_EXTRABFG",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC0
	MT_MISC0,
	2018,		// doomednum
	S_ARM1,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC0",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC1
	MT_MISC1,
	2019,		// doomednum
	S_ARM2,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC1",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC2
	MT_MISC2,
	2014,		// doomednum
	S_BON1,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC2",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC3
	MT_MISC3,
	2015,		// doomednum
	S_BON2,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC3",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC4
	MT_MISC4,
	5,		// doomednum
	S_BKEY,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_NOTDMATCH,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC4",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC5
	MT_MISC5,
	13,		// doomednum
	S_RKEY,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_NOTDMATCH,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC5",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC6
	MT_MISC6,
	6,		// doomednum
	S_YKEY,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_NOTDMATCH,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC6",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC7
	MT_MISC7,
	39,		// doomednum
	S_YSKULL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_NOTDMATCH,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC7",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC8
	MT_MISC8,
	38,		// doomednum
	S_RSKULL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_NOTDMATCH,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC8",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC9
	MT_MISC9,
	40,		// doomednum
	S_BSKULL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_NOTDMATCH,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC9",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC10
	MT_MISC10,
	2011,		// doomednum
	S_STIM,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC10",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC11
	MT_MISC11,
	2012,		// doomednum
	S_MEDI,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC11",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC12
	MT_MISC12,
	2013,		// doomednum
	S_SOUL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC12",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_INV
	MT_INV,
	2022,		// doomednum
	S_PINV,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_INV",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC13
	MT_MISC13,
	2023,		// doomednum
	S_PSTR,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC13",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_INS
	MT_INS,
	2024,		// doomednum
	S_PINS,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_INS",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC14
	MT_MISC14,
	2025,		// doomednum
	S_SUIT,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC14",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC15
	MT_MISC15,
	2026,		// doomednum
	S_PMAP,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC15",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC16
	MT_MISC16,
	2045,		// doomednum
	S_PVIS,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC16",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MEGA
	MT_MEGA,
	83,		// doomednum
	S_MEGA,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MEGA",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_CLIP
	MT_CLIP,
	2007,		// doomednum
	S_CLIP,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_CLIP",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC17
	MT_MISC17,
	2048,		// doomednum
	S_AMMO,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC17",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC18
	MT_MISC18,
	2010,		// doomednum
	S_ROCK,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC18",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC19
	MT_MISC19,
	2046,		// doomednum
	S_BROK,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC19",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC20
	MT_MISC20,
	2047,		// doomednum
	S_CELL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC20",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC21
	MT_MISC21,
	17,		// doomednum
	S_CELP,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC21",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC22
	MT_MISC22,
	2008,		// doomednum
	S_SHEL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC22",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC23
	MT_MISC23,
	2049,		// doomednum
	S_SBOX,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC23",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC24
	MT_MISC24,
	8,		// doomednum
	S_BPAK,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC24",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC25
	MT_MISC25,
	2006,		// doomednum
	S_BFUG,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC25",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_CHAINGUN
	MT_CHAINGUN,
	2002,		// doomednum
	S_MGUN,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_CHAINGUN",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC26
	MT_MISC26,
	2005,		// doomednum
	S_CSAW,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC26",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC27
	MT_MISC27,
	2003,		// doomednum
	S_LAUN,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC27",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC28
	MT_MISC28,
	2004,		// doomednum
	S_PLAS,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC28",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_SHOTGUN
	MT_SHOTGUN,
	2001,		// doomednum
	S_SHOT,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_SHOTGUN",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_SUPERSHOTGUN
	MT_SUPERSHOTGUN,
	82,		// doomednum
	S_SHOT2,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_SUPERSHOTGUN",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC29
	MT_MISC29,
	85,		// doomednum
	S_TECHLAMP,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	74*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC29",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC30
	MT_MISC30,
	86,		// doomednum
	S_TECH2LAMP,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	54*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC30",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC31
	MT_MISC31,
	2028,		// doomednum
	S_COLU,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	44*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC31",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC32
	MT_MISC32,
	30,		// doomednum
	S_TALLGRNCOL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	48*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC32",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC33
	MT_MISC33,
	31,		// doomednum
	S_SHRTGRNCOL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	34*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC33",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC34
	MT_MISC34,
	32,		// doomednum
	S_TALLREDCOL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	48*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC34",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC35
	MT_MISC35,
	33,		// doomednum
	S_SHRTREDCOL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	34*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC35",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC36
	MT_MISC36,
	37,		// doomednum
	S_SKULLCOL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	44*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC36",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC37
	MT_MISC37,
	36,		// doomednum
	S_HEARTCOL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	40*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC37",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC38
	MT_MISC38,
	41,		// doomednum
	S_EVILEYE,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	50*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC38",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC39
	MT_MISC39,
	42,		// doomednum
	S_FLOATSKULL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	48*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC39",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC40
	MT_MISC40,
	43,		// doomednum
	S_TORCHTREE,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	56*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC40",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC41
	MT_MISC41,
	44,		// doomednum
	S_BLUETORCH,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	68*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC41",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC42
	MT_MISC42,
	45,		// doomednum
	S_GREENTORCH,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	68*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC42",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC43
	MT_MISC43,
	46,		// doomednum
	S_REDTORCH,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	68*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC43",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC44
	MT_MISC44,
	55,		// doomednum
	S_BTORCHSHRT,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	37*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC44",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC45
	MT_MISC45,
	56,		// doomednum
	S_GTORCHSHRT,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	37*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC45",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC46
	MT_MISC46,
	57,		// doomednum
	S_RTORCHSHRT,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	37*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC46",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC47
	MT_MISC47,
	47,		// doomednum
	S_STALAGTITE,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	47*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC47",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC48
	MT_MISC48,
	48,		// doomednum
	S_TECHPILLAR,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	120*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC48",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC49
	MT_MISC49,
	34,		// doomednum
	S_CANDLESTIK,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC49",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC50
	MT_MISC50,
	35,		// doomednum
	S_CANDELABRA,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	54*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC50",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC51
	MT_MISC51,
	49,		// doomednum
	S_BLOODYTWITCH,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	68*FRACUNIT,		// height
	68*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC51",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC52
	MT_MISC52,
	50,		// doomednum
	S_MEAT2,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	84*FRACUNIT,		// height
	84*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC52",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC53
	MT_MISC53,
	51,		// doomednum
	S_MEAT3,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	84*FRACUNIT,		// height
	79*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC53",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC54
	MT_MISC54,
	52,		// doomednum
	S_MEAT4,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	68*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC54",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC55
	MT_MISC55,
	53,		// doomednum
	S_MEAT5,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	52*FRACUNIT,		// height
	52*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC55",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC56
	MT_MISC56,
	59,		// doomednum
	S_MEAT2,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	84*FRACUNIT,		// height
	84*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC56",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC57
	MT_MISC57,
	60,		// doomednum
	S_MEAT4,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	68*FRACUNIT,		// height
	68*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC57",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC58
	MT_MISC58,
	61,		// doomednum
	S_MEAT3,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	52*FRACUNIT,		// height
	52*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC58",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC59
	MT_MISC59,
	62,		// doomednum
	S_MEAT5,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	52*FRACUNIT,		// height
	52*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC59",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC60
	MT_MISC60,
	63,		// doomednum
	S_BLOODYTWITCH,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	68*FRACUNIT,		// height
	68*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC60",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC61
	MT_MISC61,
	22,		// doomednum
	S_HEAD_DIE6,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC61",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC62
	MT_MISC62,
	15,		// doomednum
	S_PLAY_DIE7,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC62",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC63
	MT_MISC63,
	18,		// doomednum
	S_POSS_DIE5,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC63",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC64
	MT_MISC64,
	21,		// doomednum
	S_SARG_DIE6,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC64",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC65
	MT_MISC65,
	23,		// doomednum
	S_SKULL_DIE6,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC65",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC66
	MT_MISC66,
	20,		// doomednum
	S_TROO_DIE5,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC66",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC67
	MT_MISC67,
	19,		// doomednum
	S_SPOS_DIE5,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC67",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC68
	MT_MISC68,
	10,		// doomednum
	S_PLAY_XDIE9,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC68",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC69
	MT_MISC69,
	12,		// doomednum
	S_PLAY_XDIE9,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC69",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC70
	MT_MISC70,
	28,		// doomednum
	S_HEADSONSTICK,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	60*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC70",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC71
	MT_MISC71,
	24,		// doomednum
	S_GIBS,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	0,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC71",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC72
	MT_MISC72,
	27,		// doomednum
	S_HEADONASTICK,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	54*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC72",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC73
	MT_MISC73,
	29,		// doomednum
	S_HEADCANDLES,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	40*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC73",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC74
	MT_MISC74,
	25,		// doomednum
	S_DEADSTICK,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC74",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC75
	MT_MISC75,
	26,		// doomednum
	S_LIVESTICK,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC75",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC76
	MT_MISC76,
	54,		// doomednum
	S_BIGTREE,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	32*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	124*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC76",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC77
	MT_MISC77,
	70,		// doomednum
	S_BBAR1,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	46*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC77",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC78
	MT_MISC78,
	73,		// doomednum
	S_HANGNOGUTS,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	88*FRACUNIT,		// height
	88*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC78",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC79
	MT_MISC79,
	74,		// doomednum
	S_HANGBNOBRAIN,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	88*FRACUNIT,		// height
	88*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC79",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC80
	MT_MISC80,
	75,		// doomednum
	S_HANGTLOOKDN,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	64*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC80",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC81
	MT_MISC81,
	76,		// doomednum
	S_HANGTSKULL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	64*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC81",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC82
	MT_MISC82,
	77,		// doomednum
	S_HANGTLOOKUP,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	64*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC82",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC83
	MT_MISC83,
	78,		// doomednum
	S_HANGTNOBRAIN,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	16*FRACUNIT,		// radius
	64*FRACUNIT,		// height
	64*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC83",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC84
	MT_MISC84,
	79,		// doomednum
	S_COLONGIBS,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC84",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC85
	MT_MISC85,
	80,		// doomednum
	S_SMALLPOOL,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC85",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	{		// MT_MISC86
	MT_MISC86,
	81,		// doomednum
	S_BRAINSTEM,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,		// radius
	16*FRACUNIT,		// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP,		// flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,
	"MT_MISC86",
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	// For use with wind and current effects
	{		// MT_PUSH	// phares
	MT_PUSH,	// phares
	5001,		// doomednum	//   |    //jff 5/11/98 deconflict
	S_TNT1,		// spawnstate	//   V    // with DOSDoom
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	8,		// radius
	8,		// height
	8,		// cdheight
	10,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP,	// flags
	MF2_DONTDRAW,	// flags2
	S_NULL,		// raisestate
	0x10000,	// translucency
	"MT_PUSH",	// name
	NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	// For use with wind and current effects
	{		// MT_PULL
	MT_PULL,
	5002,		// doomednum                   //jff 5/11/98 deconflict
	S_TNT1,		// spawnstate                  // with DOSDoom
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	8,		// radius
	8,		// height
	8,		// cdheight
	10,		// mass
	0,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP,	// flags
	MF2_DONTDRAW,	// flags2
	S_NULL,		// raisestate
	0x10000,	// translucency
	"MT_PULL",	// name
    NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	// Marine's best friend :)      // killough 7/19/98
	{		// MT_DOGS
	MT_DOGS,
	888,		// doomednum
	S_DOGS_STND,	// spawnstate
	500,		// spawnhealth
	0, // gibhealth
	S_DOGS_RUN1,	// seestate
	"dog/sight",	// seesound
	8,		// reactiontime
	"dog/attack",	// attacksound
	S_DOGS_PAIN,	// painstate
	180,		// painchance
	"dog/pain",	// painsound
	S_DOGS_ATK1,	// meleestate
	S_NULL,		// missilestate
	S_DOGS_DIE1,	// deathstate
	S_NULL,		// xdeathstate
	"dog/death",	// deathsound
	10,		// speed
	12*FRACUNIT,	// radius
	28*FRACUNIT,	// height
	28*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	"dog/active",	// activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
	MF2_MCROSS|MF2_PASSMOBJ|MF2_PUSHWALL, // flags2
	S_DOGS_RAISE1,	// raisestate
	0x10000,	// translucency
	"MT_DOGS",	// name
    NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	// killough 7/11/98: this is the first of two plasma fireballs in the beta
	{		// MT_PLASMA1
	MT_PLASMA1,
	-1,		// doomednum
	S_PLS1BALL,	// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	"weapons/plasmaf", // seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_PLS1EXP,	// deathstate
	S_NULL,		// xdeathstate
	"weapons/plasmax", // deathsound
	25*FRACUNIT,	// speed
	13*FRACUNIT,	// radius
	8*FRACUNIT,	// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	4,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
	MF2_PCROSS|MF2_IMPACT, // flags2
	S_NULL,		// raisestate
	FRACUNIT,	// translucency
	"MT_PLASMA1",	// name
    NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	// killough 7/11/98: this is the second of two plasma fireballs in the beta
	{		// MT_PLASMA2
	MT_PLASMA2,
	-1,		// doomednum
	S_PLS2BALL,	// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	"weapons/plasmaf", // seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_PLS2BALLX1,	// deathstate
	S_NULL,		// xdeathstate
	"weapons/plasmax", // deathsound
	25*FRACUNIT,	// speed
	6*FRACUNIT,	// radius
	8*FRACUNIT,	// height
	8*FRACUNIT,	// cdheight
	100,		// mass
	4,		// damage
	NULL,		// activesound
	MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,
	MF2_PCROSS|MF2_IMPACT, // flags2
	S_NULL,		// raisestate
	FRACUNIT,	// translucency
	"MT_PLASMA2",	// name
    NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	// killough 7/11/98: this is the evil sceptre in the beta version
	{		// MT_SCEPTRE
	MT_SCEPTRE,
	2016,		// doomednum
	S_BON3,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	10*FRACUNIT,	// radius
	16*FRACUNIT,	// height
	16*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM, // flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,	// translucency
	"MT_SCEPTRE",	// name
    NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

	// killough 7/11/98: this is the unholy bible in the beta version
	{		// MT_BIBLE
	MT_BIBLE,
	2017,		// doomednum
	S_BON4,		// spawnstate
	1000,		// spawnhealth
	0, // gibhealth
	S_NULL,		// seestate
	NULL,		// seesound
	8,		// reactiontime
	NULL,		// attacksound
	S_NULL,		// painstate
	0,		// painchance
	NULL,		// painsound
	S_NULL,		// meleestate
	S_NULL,		// missilestate
	S_NULL,		// deathstate
	S_NULL,		// xdeathstate
	NULL,		// deathsound
	0,		// speed
	20*FRACUNIT,	// radius
	10*FRACUNIT,	// height
	10*FRACUNIT,	// cdheight
	100,		// mass
	0,		// damage
	NULL,		// activesound
	MF_SPECIAL|MF_COUNTITEM, // flags
	0,		// flags2
	S_NULL,		// raisestate
	0x10000,	// translucency
	"MT_BIBLE",	// name
    NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
	},

    // [crispy] support MUSINFO lump (dynamic music changing)
    {
    // MT_MUSICSOURCE
    MT_MUSICSOURCE,
    14165,         // doomednum
    S_TNT1,        // spawnstate
    1000,          // spawnhealth
	0, // gibhealth
    S_NULL,        // seestate
    NULL,          // seesound
    8,             // reactiontime
    NULL,          // attacksound
    S_NULL,        // painstate
    0,             // painchance
    NULL,          // painsound
    S_NULL,        // meleestate
    S_NULL,        // missilestate
    S_NULL,        // deathstate
    S_NULL,        // xdeathstate
    NULL,          // deathsound
    0,             // speed
    16*FRACUNIT,            // radius
    16*FRACUNIT,            // height
	16*FRACUNIT,			// cdheight
    100,           // mass
    0,             // damage
    NULL,          // activesound
    MF_NOBLOCKMAP, // flags
	0,
    S_NULL,         // raisestate
    0x10000,   // translucency
	"MT_MUSICSOURCE", // name
    NO_ALTSPEED,	// altspeed
	64 * FRACUNIT,	// meleerange
	IG_DEFAULT,		// infighting group
	PG_DEFAULT,		// projectile group
	SG_DEFAULT,		// splash group
	0,		// flags3
	NULL, // ripsound
	MT_NULL		// droppeditem
    },

    // 145-149 - UNUSED THINGS, HERE'S A PLACEHOLDER
    {145, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"UNUSED"},
    {146, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"UNUSED"},
	{147, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"UNUSED"},
    {148, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"UNUSED"},
    {149, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"UNUSED"},

	// DEHEXTRA THINGS
    {MT_EXTRA00, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA00",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA01, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA01",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA02, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA02",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA03, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA03",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA04, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA04",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA05, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA05",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA06, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA06",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA07, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA07",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA08, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA08",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA09, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA09",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA10, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA10",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA11, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA11",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA12, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA12",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA13, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA13",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA14, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA14",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA15, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA15",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA16, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA16",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA17, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA17",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA18, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA18",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA19, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA19",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA20, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA20",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA21, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA21",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA22, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA22",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA23, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA23",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA24, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA24",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA25, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA25",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA26, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA26",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA27, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA27",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA28, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA28",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA29, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA29",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA30, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA30",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA31, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA31",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA32, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA32",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA33, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA33",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA34, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA34",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA35, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA35",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA36, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA36",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA37, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA37",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA38, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA38",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA39, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA39",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA40, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA40",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA41, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA41",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA42, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA42",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA43, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA43",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA44, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA44",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA45, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA45",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA46, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA46",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA47, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA47",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA48, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA48",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA49, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA49",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA50, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA50",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA51, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA51",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA52, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA52",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA53, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA53",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA54, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA54",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA55, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA55",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA56, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA56",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA57, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA57",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA58, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA58",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA59, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA59",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA60, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA60",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA61, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA61",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA62, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA62",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA63, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA63",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA64, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA64",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA65, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA65",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA66, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA66",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA67, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA67",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA68, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA68",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA69, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA69",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA70, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA70",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA71, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA71",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA72, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA72",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA73, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA73",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA74, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA74",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA75, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA75",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA76, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA76",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA77, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA77",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA78, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA78",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA79, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA79",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA80, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA80",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA81, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA81",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA82, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA82",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA83, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA83",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA84, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA84",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA85, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA85",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA86, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA86",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA87, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA87",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA88, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA88",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA89, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA89",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA90, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA90",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA91, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA91",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA92, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA92",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA93, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA93",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA94, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA94",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA95, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA95",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA96, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA96",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA97, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA97",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
    {MT_EXTRA98, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA98",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
	{MT_EXTRA99, -1, S_TNT1,0,0,S_NULL,NULL,0,NULL,S_NULL,0,NULL,S_NULL,S_NULL,S_NULL,S_NULL,NULL,0,0,0,0,0,0,NULL,0,0,S_NULL,0x10000,"MT_EXTRA99",NO_ALTSPEED,64*FRACUNIT,IG_DEFAULT,PG_DEFAULT,SG_DEFAULT,0,NULL,MT_NULL},
};

void D_BuildSpawnMap() {
	spawn_map.clear();
	for (auto& [_, mobj] : mobjinfo)
	{
		if (mobj.doomednum != -1)
			spawn_map.insert(&mobj, mobj.type == MT_CAREPACK ? mobj.type : mobj.doomednum);
	}
	spawn_map.rebuildMap(
		[](const mobjinfo_t *const& lhs, const mobjinfo_t *const& rhs){
			return lhs->doomednum < rhs->doomednum;
		},
		[](const mobjinfo_t *const& m){ return m->type == MT_HORDESPAWN ? m->type : m->doomednum; }
	);
}

VERSION_CONTROL (info_cpp, "$Id: c7ea7ea7594ac56bef6aa2ca0813de99b17e8bd9 $")
