// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutObjectTagging`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name containing the object.</p> <p><b>Access points</b> - When you use this action with an access point for general purpose buckets, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When you use this action with an access point for directory buckets, you must provide the access point name in place of the bucket name. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>S3 on Outposts</b> - When you use this action with S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts, the destination bucket must be the Outposts access point ARN or the access point alias. For more information about S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::set_key):<br>required: **true**<br><p>Name of the object key.</p><br>
    ///   - [`version_id(impl Into<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::version_id) / [`set_version_id(Option<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::set_version_id):<br>required: **false**<br><p>The versionId of the object that the tag-set will be added to.</p><br>
    ///   - [`content_md5(impl Into<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::content_md5) / [`set_content_md5(Option<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::set_content_md5):<br>required: **false**<br><p>The MD5 hash for the request body.</p> <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p><br>
    ///   - [`tagging(Tagging)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::tagging) / [`set_tagging(Option<Tagging>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::set_tagging):<br>required: **true**<br><p>Container for the <code>TagSet</code> and <code>Tag</code> elements</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    /// - On success, responds with [`PutObjectTaggingOutput`](crate::operation::put_object_tagging::PutObjectTaggingOutput) with field(s):
    ///   - [`version_id(Option<String>)`](crate::operation::put_object_tagging::PutObjectTaggingOutput::version_id): <p>The versionId of the object the tag-set was added to.</p>
    /// - On failure, responds with [`SdkError<PutObjectTaggingError>`](crate::operation::put_object_tagging::PutObjectTaggingError)
    pub fn put_object_tagging(&self) -> crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder {
        crate::operation::put_object_tagging::builders::PutObjectTaggingFluentBuilder::new(self.handle.clone())
    }
}
