'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetKeyboard __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetKeyboard \-   Retrieves one or more components of a keyboard device
description
.SH SYNOPSIS
.HP
.B XkbDescPtr XkbGetKeyboard
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "unsigned int " "device_spec" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to the X server
.TP
.I device_spec
device ID, or XkbUseCoreKbd
.TP
.I bits_to_change
determines events to be selected / deselected
.TP
.I values_for_bits
1=>select, 0->deselect; for events in bits_to_change
.SH DESCRIPTION
.LP
.B XkbGetKeyboard
allocates and returns a pointer to a keyboard description. It queries the server for those
components specified in the
.I which
parameter for device
.I device_spec
and copies the results to the XkbDescRec it allocated. The remaining fields in the keyboard
description are set to NULL. The valid masks for
.I which
are those listed in Table 1.

.TS
c s s
l l l
l l l.
Table 1 Mask Bits for XkbDescRec
_
Mask Bit	XkbDescRec Field	Value
_
XkbControlsMask	ctrls	(1L<<0)
XkbServerMapMask	server	(1L<<1)
XkbIClientMapMask	map	(1L<<2)
XkbIndicatorMapMask	indicators	(1L<<3)
XkbNamesMask	names	(1L<<4)
XkbCompatMapMask	compat	(1L<<5)
XkbGeometryMask	geom	(1L<<6)
XkbAllComponentsMask	All Fields	(1L<<7)
.TE

.B XkbGetKeyboard
is used to read the current description for one or more components of a keyboard device. It calls
.BR XkbGetKeyboardByName (__libmansuffix__)
as follows:

.I XkbGetKeyboardByName(dpy, device_spec,
NULL,
.I which, which,
False).
.LP
If successful,
.B XkbGetKeyboard
returns a pointer to a newly allocated
.B XkbDescRec
structure,
which is described in
.BR XkbGetKeyboardByName (__libmansuffix__),
and which should be freed with
.BR XkbFreeKeyboard (__libmansuffix__).
If
.B XkbGetKeyboard
does not succeed, it returns
.BR NULL .
.SH DIAGNOSTICS
.TP 15
.SM BadAlloc
Unable to allocate storage
.SH "SEE ALSO"
.BR XkbGetKeyboardByName (__libmansuffix__)
