include(ExternalData)
set(ExternalData_LINK_CONTENT MD5)
set(ExternalData_SOURCE_ROOT ${CMAKE_CURRENT_BINARY_DIR})
set(ExternalData_BINARY_ROOT ${CMAKE_CURRENT_BINARY_DIR}/ExternalData)
set(input ${CMAKE_CURRENT_BINARY_DIR}/ToLink.txt)
set(output ${CMAKE_CURRENT_BINARY_DIR}/ExternalData/ToLink.txt)
set(staged "${CMAKE_CURRENT_BINARY_DIR}/.ExternalData_MD5_c18ff9804c8deec9eaeb17063cda8b7b")
file(REMOVE ${staged})
file(REMOVE ${input}.md5)
file(WRITE ${input} "To be transformed into a content link.")
ExternalData_Expand_Arguments(Data args DATA{${input}})
if("x${args}" STREQUAL "x${output}")
  message(STATUS "Raw data correctly transformed to content link!")
else()
  message(FATAL_ERROR "Data reference transformed to:\n  ${args}\n"
    "but we expected:\n  ${output}")
endif()
if(EXISTS "${staged}")
  message(STATUS "Staged content exists!")
else()
  message(FATAL_ERROR "Staged content missing!")
endif()
