/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import morfologik.speller.Speller;
import morfologik.stemming.Dictionary;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.HunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;

public class VagueSpellChecker {
    private static final Map<Language, Rule> langToRule = new HashMap<Language, Rule>();
    private static final Map<Language, Dictionary> langToDict = new HashMap<Language, Dictionary>();

    public boolean isValidWord(String word, Language lang) {
        Rule rule = langToRule.get(lang);
        if (rule == null) {
            SpellingCheckRule tempRule = this.getSpellingCheckRule(lang);
            if (tempRule instanceof HunspellRule) {
                rule = tempRule;
            } else if (tempRule instanceof MorfologikSpellerRule) {
                rule = new NonThreadSafeSpellRule(JLanguageTool.getMessageBundle(), lang, null);
            }
            langToRule.put(lang, rule);
        }
        if (rule instanceof NonThreadSafeSpellRule) {
            return ((NonThreadSafeSpellRule)rule).isMisspelled(word);
        }
        if (rule instanceof HunspellRule) {
            return !((HunspellRule)rule).isMisspelled(word);
        }
        throw new RuntimeException("Unknown rule type for language " + lang.getShortCodeWithCountryAndVariant() + ": " + rule);
    }

    private SpellingCheckRule getSpellingCheckRule(Language lang) {
        JLanguageTool lt = new JLanguageTool(lang);
        SpellingCheckRule spellRule = null;
        for (Rule r : lt.getAllActiveRules()) {
            if (!(r instanceof HunspellRule) && !(r instanceof MorfologikSpellerRule)) continue;
            spellRule = (SpellingCheckRule)r;
            break;
        }
        if (spellRule == null) {
            throw new RuntimeException("No spelling rule found for language " + lang.getShortCodeWithCountryAndVariant() + " - make sure to set 'preferredVariants' so a variant with a spell checker can be selected");
        }
        return spellRule;
    }

    private class NonThreadSafeSpellRule
    extends SpellingCheckRule {
        private NonThreadSafeSpellRule(ResourceBundle messages, Language language, UserConfig userConfig) {
            super(messages, language, userConfig);
        }

        @Override
        public String getId() {
            return "FAKE_FOR_VAGUE_SPELL_CHECKER";
        }

        @Override
        public String getDescription() {
            return "internal";
        }

        @Override
        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean isMisspelled(String word) {
            try {
                Speller speller;
                Dictionary dict = (Dictionary)langToDict.get(this.language);
                if (dict == null) {
                    SpellingCheckRule spellingRule = VagueSpellChecker.this.getSpellingCheckRule(this.language);
                    dict = Dictionary.read((URL)JLanguageTool.getDataBroker().getFromResourceDirAsUrl(((MorfologikSpellerRule)spellingRule).getFileName()));
                    langToDict.put(this.language, dict);
                }
                return !(speller = new Speller(dict, 1)).isMisspelled(word);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

