/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ka extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "ფიჯი";
        final String metaValue_CA = "კანადა";
        final String metaValue_NR = "ნაურუ";
        final String metaValue_WS = "სამოა";
        final String metaValue_NU = "ნიუე";
        final String metaValue_TV = "ტუვალუ";
        final String metaValue_ar = "არაბული";
        final String metaValue_hy = "სომხური";
        final String metaValue_ae = "ავესტური";
        final String metaValue_bn = "ბენგალური";
        final String metaValue_zbl = "ბლისსიმბოლოები";
        final String metaValue_ccp = "ჩაკმა";
        final String metaValue_chr = "ჩეროკი";
        final String metaValue_cop = "კოპტური";
        final String metaValue_ka = "ქართული";
        final String metaValue_got = "გოთური";
        final String metaValue_el = "ბერძნული";
        final String metaValue_he = "ებრაული";
        final String metaValue_jv = "იავური";
        final String metaValue_ja = "იაპონური";
        final String metaValue_km = "ქმერული";
        final String metaValue_ko = "კორეული";
        final String metaValue_kpe = "კპელე";
        final String metaValue_lo = "ლაოსური";
        final String metaValue_la = "ლათინური";
        final String metaValue_men = "მენდე";
        final String metaValue_ml = "მალაიალამური";
        final String metaValue_mn = "მონღოლური";
        final String metaValue_mni = "მანიპური";
        final String metaValue_nqo = "ნკო";
        final String metaValue_or = "ორია";
        final String metaValue_phn = "ფინიკიური";
        final String metaValue_si = "სინჰალური";
        final String metaValue_syr = "სირიული";
        final String metaValue_ta = "ტამილური";
        final String metaValue_te = "ტელუგუ";
        final String metaValue_th = "ტაილანდური";
        final String metaValue_bo = "ტიბეტური";
        final String metaValue_uga = "უგარითული";
        final String metaValue_vai = "ვაი";
        final String metaValue_peo = "ძველი სპარსული";
        final String metaValue_Hant = "ტრადიციული";
        final Object[][] data = new Object[][] {
            { "001", "მსოფლიო" },
            { "002", "აფრიკა" },
            { "003", "ჩრდილოეთ ამერიკა" },
            { "005", "სამხრეთ ამერიკა" },
            { "009", "ოკეანეთი" },
            { "011", "დასავლეთ აფრიკა" },
            { "013", "ცენტრალური ამერიკა" },
            { "014", "აღმოსავლეთ აფრიკა" },
            { "015", "ჩრდილოეთ აფრიკა" },
            { "017", "შუა აფრიკა" },
            { "018", "სამხრეთ აფრიკა" },
            { "019", "ამერიკები" },
            { "021", "ამერიკის ჩრდილოეთი" },
            { "029", "კარიბის ზღვა" },
            { "030", "აღმოსავლეთ აზია" },
            { "034", "სამხრეთ აზია" },
            { "035", "სამხრეთ-აღმოსავლეთ აზია" },
            { "039", "სამხრეთ ევროპა" },
            { "053", "ავსტრალაზია" },
            { "054", "მელანეზია" },
            { "057", "მიკრონეზიის რეგიონი" },
            { "061", "პოლინეზია" },
            { "142", "აზია" },
            { "143", "ცენტრალური აზია" },
            { "145", "დასავლეთ აზია" },
            { "150", "ევროპა" },
            { "151", "აღმოსავლეთ ევროპა" },
            { "154", "ჩრდილოეთ ევროპა" },
            { "155", "დასავლეთ ევროპა" },
            { "202", "სუბსაჰარული აფრიკა" },
            { "419", "ლათინური ამერიკა" },
            { "AC", "ამაღლების კუნძული" },
            { "AD", "ანდორა" },
            { "AE", "არაბთა გაერთიანებული საამიროები" },
            { "AF", "ავღანეთი" },
            { "AG", "ანტიგუა და ბარბუდა" },
            { "AI", "ანგილია" },
            { "AL", "ალბანეთი" },
            { "AM", "სომხეთი" },
            { "AO", "ანგოლა" },
            { "AQ", "ანტარქტიკა" },
            { "AR", "არგენტინა" },
            { "AS", "ამერიკის სამოა" },
            { "AT", "ავსტრია" },
            { "AU", "ავსტრალია" },
            { "AW", "არუბა" },
            { "AX", "ალანდის კუნძულები" },
            { "AZ", "აზერბაიჯანი" },
            { "BA", "ბოსნია და ჰერცეგოვინა" },
            { "BB", "ბარბადოსი" },
            { "BD", "ბანგლადეში" },
            { "BE", "ბელგია" },
            { "BF", "ბურკინა-ფასო" },
            { "BG", "ბულგარეთი" },
            { "BH", "ბაჰრეინი" },
            { "BI", "ბურუნდი" },
            { "BJ", "ბენინი" },
            { "BL", "სენ-ბართელმი" },
            { "BM", "ბერმუდა" },
            { "BN", "ბრუნეი" },
            { "BO", "ბოლივია" },
            { "BQ", "კარიბის ნიდერლანდები" },
            { "BR", "ბრაზილია" },
            { "BS", "ბაჰამის კუნძულები" },
            { "BT", "ბუტანი" },
            { "BV", "ბუვე" },
            { "BW", "ბოტსვანა" },
            { "BY", "ბელარუსი" },
            { "BZ", "ბელიზი" },
            { "CA", metaValue_CA },
            { "CC", "ქოქოსის (კილინგის) კუნძულები" },
            { "CD", "კონგო - კინშასა" },
            { "CF", "ცენტრალური აფრიკის რესპუბლიკა" },
            { "CG", "კონგო - ბრაზავილი" },
            { "CH", "შვეიცარია" },
            { "CI", "კოტ-დივუარი" },
            { "CK", "კუკის კუნძულები" },
            { "CL", "ჩილე" },
            { "CM", "კამერუნი" },
            { "CN", "ჩინეთი" },
            { "CO", "კოლუმბია" },
            { "CP", "კლიპერტონის კუნძული" },
            { "CQ", "სარკი" },
            { "CR", "კოსტა-რიკა" },
            { "CU", "კუბა" },
            { "CV", "კაბო-ვერდე" },
            { "CW", "კიურასაო" },
            { "CX", "შობის კუნძული" },
            { "CY", "კვიპროსი" },
            { "CZ", "ჩეხეთი" },
            { "DE", "გერმანია" },
            { "DG", "დიეგო-გარსია" },
            { "DJ", "ჯიბუტი" },
            { "DK", "დანია" },
            { "DM", "დომინიკა" },
            { "DO", "დომინიკელთა რესპუბლიკა" },
            { "DZ", "ალჟირი" },
            { "EA", "სეუტა და მელილა" },
            { "EC", "ეკვადორი" },
            { "EE", "ესტონეთი" },
            { "EG", "ეგვიპტე" },
            { "EH", "დასავლეთ საჰარა" },
            { "ER", "ერიტრეა" },
            { "ES", "ესპანეთი" },
            { "ET", "ეთიოპია" },
            { "EU", "ევროკავშირი" },
            { "EZ", "ევროზონა" },
            { "FI", "ფინეთი" },
            { "FJ", metaValue_FJ },
            { "FK", "ფოლკლენდის კუნძულები" },
            { "FM", "მიკრონეზია" },
            { "FO", "ფარერის კუნძულები" },
            { "FR", "საფრანგეთი" },
            { "GA", "გაბონი" },
            { "GB", "გაერთიანებული სამეფო" },
            { "GD", "გრენადა" },
            { "GE", "საქართველო" },
            { "GF", "საფრანგეთის გვიანა" },
            { "GG", "გერნსი" },
            { "GH", "განა" },
            { "GI", "გიბრალტარი" },
            { "GL", "გრენლანდია" },
            { "GM", "გამბია" },
            { "GN", "გვინეა" },
            { "GP", "გვადელუპა" },
            { "GQ", "ეკვატორული გვინეა" },
            { "GR", "საბერძნეთი" },
            { "GS", "სამხრეთ ჯორჯია და სამხრეთ სენდვიჩის კუნძულები" },
            { "GT", "გვატემალა" },
            { "GU", "გუამი" },
            { "GW", "გვინეა-ბისაუ" },
            { "GY", "გაიანა" },
            { "HK", "ჰონკონგის სპეციალური ადმინისტრაციული რეგიონი, ჩინეთი" },
            { "HM", "ჰერდი და მაკდონალდის კუნძულები" },
            { "HN", "ჰონდურასი" },
            { "HR", "ხორვატია" },
            { "HT", "ჰაიტი" },
            { "HU", "უნგრეთი" },
            { "IC", "კანარის კუნძულები" },
            { "ID", "ინდონეზია" },
            { "IE", "ირლანდია" },
            { "IL", "ისრაელი" },
            { "IM", "მენის კუნძული" },
            { "IN", "ინდოეთი" },
            { "IO", "ბრიტანეთის ტერიტორია ინდოეთის ოკეანეში" },
            { "IQ", "ერაყი" },
            { "IR", "ირანი" },
            { "IS", "ისლანდია" },
            { "IT", "იტალია" },
            { "JE", "ჯერსი" },
            { "JM", "იამაიკა" },
            { "JO", "იორდანია" },
            { "JP", "იაპონია" },
            { "KE", "კენია" },
            { "KG", "ყირგიზეთი" },
            { "KH", "კამბოჯა" },
            { "KI", "კირიბატი" },
            { "KM", "კომორის კუნძულები" },
            { "KN", "სენტ-კიტსი და ნევისი" },
            { "KP", "ჩრდილოეთ კორეა" },
            { "KR", "სამხრეთ კორეა" },
            { "KW", "ქუვეითი" },
            { "KY", "კაიმანის კუნძულები" },
            { "KZ", "ყაზახეთი" },
            { "LA", "ლაოსი" },
            { "LB", "ლიბანი" },
            { "LC", "სენტ-ლუსია" },
            { "LI", "ლიხტენშტაინი" },
            { "LK", "შრი-ლანკა" },
            { "LR", "ლიბერია" },
            { "LS", "ლესოთო" },
            { "LT", "ლიეტუვა" },
            { "LU", "ლუქსემბურგი" },
            { "LV", "ლატვია" },
            { "LY", "ლიბია" },
            { "MA", "მაროკო" },
            { "MC", "მონაკო" },
            { "MD", "მოლდოვა" },
            { "ME", "მონტენეგრო" },
            { "MF", "სენ-მარტენი" },
            { "MG", "მადაგასკარი" },
            { "MH", "მარშალის კუნძულები" },
            { "MK", "ჩრდილოეთ მაკედონია" },
            { "ML", "მალი" },
            { "MM", "მიანმარი (ბირმა)" },
            { "MN", "მონღოლეთი" },
            { "MO", "მაკაოს სპეციალური ადმინისტრაციული რეგიონი, ჩინეთი" },
            { "MP", "ჩრდილოეთ მარიანას კუნძულები" },
            { "MQ", "მარტინიკა" },
            { "MR", "მავრიტანია" },
            { "MS", "მონსერატი" },
            { "MT", "მალტა" },
            { "MU", "მავრიკი" },
            { "MV", "მალდივები" },
            { "MW", "მალავი" },
            { "MX", "მექსიკა" },
            { "MY", "მალაიზია" },
            { "MZ", "მოზამბიკი" },
            { "NA", "ნამიბია" },
            { "NC", "ახალი კალედონია" },
            { "NE", "ნიგერი" },
            { "NF", "ნორფოლკის კუნძული" },
            { "NG", "ნიგერია" },
            { "NI", "ნიკარაგუა" },
            { "NL", "ნიდერლანდები" },
            { "NO", "ნორვეგია" },
            { "NP", "ნეპალი" },
            { "NR", metaValue_NR },
            { "NU", metaValue_NU },
            { "NZ", "ახალი ზელანდია" },
            { "OM", "ომანი" },
            { "PA", "პანამა" },
            { "PE", "პერუ" },
            { "PF", "საფრანგეთის პოლინეზია" },
            { "PG", "პაპუა-ახალი გვინეა" },
            { "PH", "ფილიპინები" },
            { "PK", "პაკისტანი" },
            { "PL", "პოლონეთი" },
            { "PM", "სენ-პიერი და მიკელონი" },
            { "PN", "პიტკერნის კუნძულები" },
            { "PR", "პუერტო-რიკო" },
            { "PS", "პალესტინის ტერიტორიები" },
            { "PT", "პორტუგალია" },
            { "PW", "პალაუ" },
            { "PY", "პარაგვაი" },
            { "QA", "კატარი" },
            { "QO", "შორეული ოკეანეთი" },
            { "RE", "რეუნიონი" },
            { "RO", "რუმინეთი" },
            { "RS", "სერბეთი" },
            { "RU", "რუსეთი" },
            { "RW", "რუანდა" },
            { "SA", "საუდის არაბეთი" },
            { "SB", "სოლომონის კუნძულები" },
            { "SC", "სეიშელის კუნძულები" },
            { "SD", "სუდანი" },
            { "SE", "შვედეთი" },
            { "SG", "სინგაპური" },
            { "SH", "წმინდა ელენეს კუნძული" },
            { "SI", "სლოვენია" },
            { "SJ", "შპიცბერგენი და იან-მაიენი" },
            { "SK", "სლოვაკეთი" },
            { "SL", "სიერა-ლეონე" },
            { "SM", "სან-მარინო" },
            { "SN", "სენეგალი" },
            { "SO", "სომალი" },
            { "SR", "სურინამი" },
            { "SS", "სამხრეთ სუდანი" },
            { "ST", "სან-ტომე და პრინსიპი" },
            { "SV", "სალვადორი" },
            { "SX", "სინტ-მარტენი" },
            { "SY", "სირია" },
            { "SZ", "სვაზილენდი" },
            { "TA", "ტრისტან-და-კუნია" },
            { "TC", "თერქს-ქაიქოსის კუნძულები" },
            { "TD", "ჩადი" },
            { "TF", "ფრანგული სამხრეთის ტერიტორიები" },
            { "TG", "ტოგო" },
            { "TH", "ტაილანდი" },
            { "TJ", "ტაჯიკეთი" },
            { "TK", "ტოკელაუ" },
            { "TL", "ტიმორ-ლესტე" },
            { "TM", "თურქმენეთი" },
            { "TN", "ტუნისი" },
            { "TO", "ტონგა" },
            { "TR", "თურქეთი" },
            { "TT", "ტრინიდადი და ტობაგო" },
            { "TV", metaValue_TV },
            { "TW", "ტაივანი" },
            { "TZ", "ტანზანია" },
            { "UA", "უკრაინა" },
            { "UG", "უგანდა" },
            { "UM", "აშშ-ის შორეული კუნძულები" },
            { "UN", "გაერო" },
            { "US", "ამერიკის შეერთებული შტატები" },
            { "UY", "ურუგვაი" },
            { "UZ", "უზბეკეთი" },
            { "VA", "ქალაქი ვატიკანი" },
            { "VC", "სენტ-ვინსენტი და გრენადინები" },
            { "VE", "ვენესუელა" },
            { "VG", "ბრიტანეთის ვირჯინის კუნძულები" },
            { "VI", "აშშ-ის ვირჯინის კუნძულები" },
            { "VN", "ვიეტნამი" },
            { "VU", "ვანუატუ" },
            { "WF", "უოლისი და ფუტუნა" },
            { "WS", metaValue_WS },
            { "XA", "ფსევდო-აქცენტები" },
            { "XB", "ფსევდო-ორმიმართულებიანი" },
            { "XK", "კოსოვო" },
            { "YE", "იემენი" },
            { "YT", "მაიოტა" },
            { "ZA", "სამხრეთ აფრიკის რესპუბლიკა" },
            { "ZM", "ზამბია" },
            { "ZW", "ზიმბაბვე" },
            { "ZZ", "უცნობი რეგიონი" },
            { "aa", "აფარი" },
            { "ab", "აფხაზური" },
            { "ae", metaValue_ae },
            { "af", "აფრიკაანსი" },
            { "ak", "აკანი" },
            { "am", "ამჰარული" },
            { "an", "არაგონული" },
            { "ar", metaValue_ar },
            { "as", "ასამური" },
            { "av", "ხუნძური" },
            { "ay", "აიმარა" },
            { "az", "აზერბაიჯანული" },
            { "ba", "ბაშკირული" },
            { "be", "ბელარუსული" },
            { "bg", "ბულგარული" },
            { "bi", "ბისლამა" },
            { "bm", "ბამბარა" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "ბრეტონული" },
            { "bs", "ბოსნიური" },
            { "ca", "კატალანური" },
            { "ce", "ჩეჩნური" },
            { "ch", "ჩამორო" },
            { "co", "კორსიკული" },
            { "cr", "კრი" },
            { "cs", "ჩეხური" },
            { "cu", "საეკლესიო სლავური" },
            { "cv", "ჩუვაშური" },
            { "cy", "უელსური" },
            { "da", "დანიური" },
            { "de", "გერმანული" },
            { "dv", "დივეჰი" },
            { "dz", "ძონგკხა" },
            { "ee", "ევე" },
            { "el", metaValue_el },
            { "en", "ინგლისური" },
            { "eo", "ესპერანტო" },
            { "es", "ესპანური" },
            { "et", "ესტონური" },
            { "eu", "ბასკური" },
            { "fa", "სპარსული" },
            { "ff", "ფულა" },
            { "fi", "ფინური" },
            { "fj", metaValue_FJ },
            { "fo", "ფარერული" },
            { "fr", "ფრანგული" },
            { "fy", "დასავლეთფრიზიული" },
            { "ga", "ირლანდიური" },
            { "gd", "შოტლანდიური გელური" },
            { "gl", "გალისიური" },
            { "gn", "გუარანი" },
            { "gu", "გუჯარათი" },
            { "gv", "მენური" },
            { "ha", "ჰაუსა" },
            { "he", metaValue_he },
            { "hi", "ჰინდი" },
            { "hr", "ხორვატული" },
            { "ht", "ჰაიტიური კრეოლი" },
            { "hu", "უნგრული" },
            { "hy", metaValue_hy },
            { "hz", "ჰერერო" },
            { "ia", "ინტერლინგუალური" },
            { "id", "ინდონეზიური" },
            { "ie", "ინტერლინგი" },
            { "ig", "იგბო" },
            { "ii", "სიჩუანის ი" },
            { "io", "იდო" },
            { "is", "ისლანდიური" },
            { "it", "იტალიური" },
            { "iu", "ინუკტიტუტი" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "კონგო" },
            { "ki", "კიკუიუ" },
            { "kj", "კუნამა" },
            { "kk", "ყაზახური" },
            { "kl", "დასავლეთ გრენლანდიური" },
            { "km", metaValue_km },
            { "kn", metaValue_CA },
            { "ko", metaValue_ko },
            { "kr", "კანური" },
            { "ks", "ქაშმირული" },
            { "ku", "კურმანჯი" },
            { "kv", "კომი" },
            { "kw", "კორნული" },
            { "ky", "ყირგიზული" },
            { "la", metaValue_la },
            { "lb", "ლუქსემბურგული" },
            { "lg", "განდა" },
            { "li", "ლიმბურგული" },
            { "ln", "ლინგალა" },
            { "lo", metaValue_lo },
            { "lt", "ლიეტუვური" },
            { "lu", "ლუბა-კატანგა" },
            { "lv", "ლატვიური" },
            { "mg", "მალაგასიური" },
            { "mh", "მარშალური" },
            { "mi", "მაორი" },
            { "mk", "მაკედონური" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "მარათჰი" },
            { "ms", "მალაიური" },
            { "mt", "მალტური" },
            { "my", "ბირმული" },
            { "na", metaValue_NR },
            { "nb", "ნორვეგიული ბუკმოლი" },
            { "nd", "ჩრდილოეთ ნდებელე" },
            { "ne", "ნეპალური" },
            { "ng", "ნდონგა" },
            { "nl", "ნიდერლანდური" },
            { "nn", "ნორვეგიული ნიუნორსკი" },
            { "no", "ნორვეგიული" },
            { "nr", "სამხრეთ ნდებელური" },
            { "nv", "ნავახო" },
            { "ny", "ნიანჯა" },
            { "oc", "ოქსიტანური" },
            { "oj", "ოჯიბვე" },
            { "om", "ორომო" },
            { "or", metaValue_or },
            { "os", "ოსური" },
            { "pa", "პენჯაბური" },
            { "pi", "პალი" },
            { "pl", "პოლონური" },
            { "ps", "პუშტუ" },
            { "pt", "პორტუგალიური" },
            { "qu", "კეჩუა" },
            { "rm", "რეტორომანული" },
            { "rn", "რუნდი" },
            { "ro", "რუმინული" },
            { "ru", "რუსული" },
            { "rw", "კინიარუანდა" },
            { "sa", "სანსკრიტი" },
            { "sc", "სარდინიული" },
            { "sd", "სინდჰური" },
            { "se", "ჩრდილოეთ საამური" },
            { "sg", "სანგო" },
            { "sh", "სერბულ-ხორვატული" },
            { "si", metaValue_si },
            { "sk", "სლოვაკური" },
            { "sl", "სლოვენური" },
            { "sm", metaValue_WS },
            { "sn", "შონა" },
            { "so", "სომალიური" },
            { "sq", "ალბანური" },
            { "sr", "სერბული" },
            { "ss", "სუატი" },
            { "st", "სამხრეთ სოთოს ენა" },
            { "su", "სუნდური" },
            { "sv", "შვედური" },
            { "sw", "სუაჰილი" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ტაჯიკური" },
            { "th", metaValue_th },
            { "ti", "ტიგრინია" },
            { "tk", "თურქმენული" },
            { "tn", "ტსვანა" },
            { "to", "ტონგანური" },
            { "tr", "თურქული" },
            { "ts", "ტსონგა" },
            { "tt", "თათრული" },
            { "tw", "თუი" },
            { "ty", "ტაიტური" },
            { "ug", "უიღურული" },
            { "uk", "უკრაინული" },
            { "ur", "ურდუ" },
            { "uz", "უზბეკური" },
            { "ve", "ვენდა" },
            { "vi", "ვიეტნამური" },
            { "vo", "ვოლაპუკი" },
            { "wa", "ვალონური" },
            { "wo", "ვოლოფური" },
            { "xh", "ქჰოსა" },
            { "yi", "იდიში" },
            { "yo", "იორუბა" },
            { "za", "ზჰუანგი" },
            { "zh", "ჩინური" },
            { "zu", "ზულუ" },
            { "ace", "აჩეხური" },
            { "ach", "აჩოლი" },
            { "ada", "ადანგმე" },
            { "ady", "ადიღეური" },
            { "agq", "აღემი" },
            { "ain", "აინუური" },
            { "akk", "აქადური" },
            { "ale", "ალეუტური" },
            { "alt", "სამხრეთ ალთაური" },
            { "ang", "ძველი ინგლისური" },
            { "ann", "ობოლო" },
            { "anp", "ანგიკა" },
            { "arc", "არამეული" },
            { "arn", "მაპუდუნგუნი" },
            { "arp", "არაპაჰო" },
            { "ars", "ნაჯის არაბული" },
            { "arw", "არავაკი" },
            { "asa", "ასუ" },
            { "ast", "ასტურიული" },
            { "atj", "ატიკამეკი" },
            { "awa", "ავადი" },
            { "bal", "ბელუჯი" },
            { "ban", "ბალინური" },
            { "bas", "ბასა" },
            { "bax", "ბამუნი" },
            { "bej", "ბეჯა" },
            { "bem", "ბემბა" },
            { "bez", "ბენა" },
            { "bgc", "ჰარიანვი" },
            { "bgn", "დასავლეთ ბელუჯი" },
            { "bho", "ბოჯპური" },
            { "bin", "ბინი" },
            { "bla", "სიკსიკა" },
            { "blo", "ანიი" },
            { "bra", "ბრაჯი" },
            { "brx", "ბოდო" },
            { "bua", "ბურიატული" },
            { "bug", "ბუგინური" },
            { "byn", "ბილინი" },
            { "cay", "კაიუგა" },
            { "ccp", metaValue_ccp },
            { "ceb", "სებუანო" },
            { "cgg", "ჩიგა" },
            { "chb", "ჩიბჩა" },
            { "chk", "ჩუკოტკური" },
            { "chm", "მარიული" },
            { "chn", "ჩინუკის ჟარგონი" },
            { "cho", "ჩოკტო" },
            { "chp", "ჩიპევიანი" },
            { "chr", metaValue_chr },
            { "chy", "ჩეიენი" },
            { "ckb", "ცენტრალური ქურთული" },
            { "clc", "ჩილკოტინი" },
            { "cop", metaValue_cop },
            { "crg", "მიჩიფი" },
            { "crh", "ყირიმულ-თურქული" },
            { "crj", "სამხრეთ-აღმოსავლეთის კრი" },
            { "crk", "დაბლობის კრი" },
            { "crl", "ჩრდილო-აღმოსავლეთის კრი" },
            { "crm", "მუსური კრი" },
            { "crr", "კაროლინური ალგონკინი" },
            { "crs", "სესელვა-კრეოლური ფრანგული" },
            { "csb", "კაშუბური" },
            { "csw", "ჭაობის კრი" },
            { "dak", "დაკოტური" },
            { "dar", "დარგუული" },
            { "dav", "ტაიტა" },
            { "del", "დელავერული" },
            { "den", "სლეივი" },
            { "dgr", "დოგრიბი" },
            { "din", "დინკა" },
            { "dje", "ზარმა" },
            { "doi", "დოგრი" },
            { "dsb", "ქვემოსორბული" },
            { "dua", "დუალა" },
            { "dum", "საშუალო ჰოლანდიური" },
            { "dyo", "დიოლა" },
            { "dyu", "დიულა" },
            { "dzg", "დაზაგა" },
            { "ebu", "ემბუ" },
            { "efi", "ეფიკი" },
            { "egy", "ძველეგვიპტური" },
            { "eka", "ეკაჯუკი" },
            { "enm", "საშუალო ინგლისური" },
            { "ewo", "ევონდო" },
            { "fil", "ფილიპინური" },
            { "fon", "ფონი" },
            { "frc", "კაჟუნური ფრანგული" },
            { "frm", "საშუალო ფრანგული" },
            { "fro", "ძველი ფრანგული" },
            { "frr", "ჩრდილოფრიზიული" },
            { "frs", "აღმოსავლეთფრიზიული" },
            { "fur", "ფრიულური" },
            { "gaa", "გა" },
            { "gag", "გაგაუზური" },
            { "gba", "გბაია" },
            { "gez", "გეეზი" },
            { "gil", "გილბერტული" },
            { "gmh", "საშუალო ზემოგერმანული" },
            { "goh", "ძველი ზემოგერმანული" },
            { "gon", "გონდი" },
            { "gor", "გორონტალო" },
            { "got", metaValue_got },
            { "grc", "ძველი ბერძნული" },
            { "gsw", "შვეიცარიული გერმანული" },
            { "guz", "გუსიი" },
            { "gwi", "გვიჩინი" },
            { "hai", "ჰაიდა" },
            { "haw", "ჰავაიური" },
            { "hax", "სამხრეთული ჰაიდა" },
            { "hil", "ჰილიგაინონი" },
            { "hit", "ხეთური" },
            { "hmn", "ჰმონგი" },
            { "hsb", "ზემოსორბული" },
            { "hup", "ჰუპა" },
            { "hur", "ჰალკომელემი" },
            { "iba", "იბანი" },
            { "ibb", "იბიბიო" },
            { "ikt", "დასავლეთ-კანადური ინუკტიტუტი" },
            { "ilo", "ილოკო" },
            { "inh", "ინგუშური" },
            { "jbo", "ლოჟბანი" },
            { "jgo", "ნგომბა" },
            { "jmc", "კიმაშამი" },
            { "jpr", "იუდეო-სპარსული" },
            { "jrb", "იუდეო-არაბული" },
            { "kaa", "ყარაყალფახური" },
            { "kab", "კაბილური" },
            { "kac", "კაჩინი" },
            { "kaj", "კაჯი" },
            { "kam", "კამბა" },
            { "kbd", "ყაბარდოული" },
            { "kcg", "ტიაპი" },
            { "kde", "მაკონდე" },
            { "kea", "კაბუვერდიანუ" },
            { "kfo", "კორო" },
            { "kgp", "კაინგანგი" },
            { "kha", "ხასი" },
            { "khq", "კოირა-ჩიინი" },
            { "kkj", "კაკო" },
            { "kln", "კალენჯინი" },
            { "kmb", "კიმბუნდუ" },
            { "koi", "კომი-პერმიაკული" },
            { "kok", "კონკანი" },
            { "kos", "კუსაიე" },
            { "kpe", metaValue_kpe },
            { "krc", "ყარაჩაულ-ბალყარული" },
            { "krl", "კარელიური" },
            { "kru", "კურუქი" },
            { "ksb", "შამბალა" },
            { "ksf", "ბაფია" },
            { "ksh", "კიოლში" },
            { "kum", "ყუმუხური" },
            { "kut", "კუტენაი" },
            { "kwk", "კვაკვალა" },
            { "kxv", "კუვი" },
            { "lad", "ლადინო" },
            { "lag", "ლანგი" },
            { "lah", "ლანდა" },
            { "lam", "ლამბა" },
            { "lez", "ლეზგიური" },
            { "lij", "ლიგურიული" },
            { "lil", "ლილიეტი" },
            { "lkt", "ლაკოტა" },
            { "lmo", "ლომბარდიული" },
            { "lol", "მონგო" },
            { "lou", "ლუიზიანას კრეოლური" },
            { "loz", "ლოზი" },
            { "lrc", "ჩრდილოეთ ლური" },
            { "lsm", "სამია" },
            { "lua", "ლუბა-ლულუა" },
            { "lui", "ლუისენიო" },
            { "lun", "ლუნდა" },
            { "luo", "ლუო" },
            { "lus", "მიზო" },
            { "luy", "ლუჰია" },
            { "mad", "მადურული" },
            { "maf", "მაფა" },
            { "mag", "მაგაჰი" },
            { "mai", "მაითილი" },
            { "mak", "მაკასარი" },
            { "mas", "მასაი" },
            { "mde", "მაბა" },
            { "mdf", "მოქშა" },
            { "men", metaValue_men },
            { "mer", "მერუ" },
            { "mfe", "მორისიენი" },
            { "mga", "საშუალო ირლანდიური" },
            { "mgh", "მაქუვა-მეეტო" },
            { "mgo", "მეტა-ენა" },
            { "mic", "მიკმაკი" },
            { "min", "მინანგკაბაუ" },
            { "mnc", "მანჯურიული" },
            { "mni", metaValue_mni },
            { "moe", "ინუ-აიმუნი" },
            { "moh", "მოჰაუკური" },
            { "mos", "მოსი" },
            { "mua", "მუნდანგი" },
            { "mul", "სხვადასხვა ენა" },
            { "mus", "კრიკი" },
            { "mwl", "მირანდული" },
            { "mwr", "მარვარი" },
            { "mye", "მიენე" },
            { "myv", "ერზია" },
            { "mzn", "მაზანდერანული" },
            { "nap", "ნეაპოლიტანური" },
            { "naq", "ნამა" },
            { "nds", "ქვემოგერმანული" },
            { "new", "ნევარი" },
            { "nia", "ნიასი" },
            { "niu", metaValue_NU },
            { "nmg", "კვასიო" },
            { "nnh", "ნგიმბუნი" },
            { "nog", "ნოღაური" },
            { "non", "ძველსკანდინავიური" },
            { "nqo", metaValue_nqo },
            { "nso", "ჩრდილოეთ სოთო" },
            { "nus", "ნუერი" },
            { "nwc", "კლასიკური ნევარული" },
            { "nym", "ნიამვეზი" },
            { "nyn", "ნიანკოლე" },
            { "nyo", "ნიორო" },
            { "nzi", "ნზიმა" },
            { "ojb", "ჩრდილო-დასავლეთის ოჯიბვა" },
            { "ojc", "ცენტრალური ოჯიბვე" },
            { "ojs", "ოჯი-კრი" },
            { "ojw", "დასავლეთის ოჯიბვა" },
            { "oka", "ოკანაგანი" },
            { "pag", "პანგასინანი" },
            { "pal", "ფალაური" },
            { "pam", "პამპანგა" },
            { "pap", "პაპიამენტო" },
            { "pau", "ფალაუანი" },
            { "pcm", "ნიგერიული კრეოლური" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "პიჯინი" },
            { "pqm", "მალისეტ-პასამაკვოდი" },
            { "prg", "პრუსიული" },
            { "pro", "ძველი პროვანსული" },
            { "quc", "კიჩე" },
            { "raj", "რაჯასთანი" },
            { "rap", "რაპანუი" },
            { "rar", "რაროტონგული" },
            { "rhg", "როჰინგა" },
            { "rof", "რომბო" },
            { "rom", "ბოშური" },
            { "rup", "არომანული" },
            { "rwk", "რუა" },
            { "sad", "სანდავე" },
            { "sah", "იაკუტური" },
            { "sam", "სამარიულ-არამეული" },
            { "saq", "სამბურუ" },
            { "sat", "სანტალი" },
            { "sba", "ნგამბაი" },
            { "sbp", "სანგუ" },
            { "scn", "სიცილიური" },
            { "sco", "შოტლანდიური" },
            { "sdh", "სამხრეთქურთული" },
            { "see", "სენეკა" },
            { "seh", "სენა" },
            { "sel", "სელკუპური" },
            { "ses", "კოირაბორო-სენი" },
            { "sga", "ძველი ირლანდიური" },
            { "shi", "შილჰა" },
            { "shn", "შანი" },
            { "shu", "ჩადური არაბული" },
            { "slh", "სამხრეთული ლუშუციდი" },
            { "sma", "სამხრეთსამური" },
            { "smj", "ლულე-საამური" },
            { "smn", "ინარი-საამური" },
            { "sms", "სკოლტ-საამური" },
            { "snk", "სონინკე" },
            { "srn", "სრანან ტონგო" },
            { "ssy", "საჰო" },
            { "str", "სტრეიტს სალიში" },
            { "suk", "სუკუმა" },
            { "sux", "შუმერული" },
            { "swb", "კომორული" },
            { "syc", "კლასიკური სირიული" },
            { "syr", metaValue_syr },
            { "szl", "სილესიური" },
            { "tce", "სამხრეთ ტუჩონი" },
            { "tem", "ტინმე" },
            { "teo", "ტესო" },
            { "tet", "ტეტუმი" },
            { "tgx", "ტაგიში" },
            { "tht", "ტალტანი" },
            { "tig", "თიგრე" },
            { "tlh", "კლინგონი" },
            { "tli", "ტლინგიტი" },
            { "tok", "ტოკი-პონა" },
            { "tpi", "ტოკ-პისინი" },
            { "trv", "ტაროკო" },
            { "ttm", "ჩრდილოეთ ტუჩონი" },
            { "tum", "ტუმბუკა" },
            { "tvl", metaValue_TV },
            { "twq", "ტასავაქი" },
            { "tyv", "ტუვა" },
            { "tzm", "ცენტრალური მოროკოს ტამაზიგხტი" },
            { "udm", "უდმურტული" },
            { "uga", metaValue_uga },
            { "umb", "უმბუნდუ" },
            { "und", "უცნობი ენა" },
            { "vai", metaValue_vai },
            { "vec", "ვენეციური" },
            { "vmw", "მაკჰუვა" },
            { "vun", "ვუნჯო" },
            { "wae", "ვალსერი" },
            { "wal", "ველაითა" },
            { "war", "ვარაი" },
            { "wbp", "ვალპირი" },
            { "wuu", "ვუ" },
            { "xal", "ყალმუხური" },
            { "xnr", "კანგრი" },
            { "xog", "სოგა" },
            { "yav", "იანგბენი" },
            { "ybb", "იემბა" },
            { "yrl", "ნენგატუ" },
            { "yue", "კანტონური" },
            { "zbl", metaValue_zbl },
            { "zen", "ზენაგა" },
            { "zgh", "სტანდარტული მაროკოული ტამაზიგხტი" },
            { "zun", "ზუნი" },
            { "zxx", "ლინგვისტური შიგთავსი არ არის" },
            { "zza", "ზაზაკი" },
            { "Adlm", "ადლამი" },
            { "Afak", "აფაკა" },
            { "Arab", metaValue_ar },
            { "Aran", "ნასტალიქი" },
            { "Armi", "იმპერიული არამეული" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", "ბალიური" },
            { "Bamu", "ბამუმი" },
            { "Bass", "ბასა ვაჰი" },
            { "Batk", "ბატაკი" },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "ბოპომოფო" },
            { "Brah", "ბრაჰმი" },
            { "Brai", "ბრაილი" },
            { "Buhd", "ბუჰიდი" },
            { "Cakm", metaValue_ccp },
            { "Cans", "გაერთიანებული კანადური სილაბური" },
            { "Cari", "კარიული" },
            { "Cham", "ჩამი" },
            { "Cher", metaValue_chr },
            { "Cirt", "კირთი" },
            { "Copt", metaValue_cop },
            { "Cprt", "კვიპროსული" },
            { "Cyrl", "კირილიცა" },
            { "Cyrs", "ძველი სლავური კირილიცა" },
            { "Deva", "დევანაგარი" },
            { "Dsrt", "დეზერეტის" },
            { "Dupl", "დუპლოის სტენოგრაფია" },
            { "Egyd", "ეგვიპტური დემოტიკური" },
            { "Egyh", "ეგვიპტური იერატიკული" },
            { "Egyp", "ეგვიპტური იეროგლიფური" },
            { "Ethi", "ეთიოპიური" },
            { "Geok", "ხუცური" },
            { "Geor", metaValue_ka },
            { "Glag", "გლაგოლიცა" },
            { "Goth", metaValue_got },
            { "Gran", "გრანთა" },
            { "Grek", metaValue_el },
            { "Gujr", "გუჯარათული" },
            { "Guru", "გურმუხი" },
            { "Hanb", "ჰანბი" },
            { "Hang", "ჰანგული" },
            { "Hani", "ჰანი" },
            { "Hano", "ჰანუნოო" },
            { "Hans", "გამარტივებული" },
            { "Hant", metaValue_Hant },
            { "Hebr", metaValue_he },
            { "Hira", "ჰირაგანა" },
            { "Hluw", "ანატოლიური იეროგლიფური" },
            { "Hmng", "ფაჰაუ-მონი" },
            { "Hrkt", "იაპონური კანა" },
            { "Hung", "ძველი უნგრული" },
            { "Jamo", "ჯამო" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "ჯურჯენული" },
            { "Kali", "კაიაჰ-ლი" },
            { "Kana", "კატაკანა" },
            { "Khar", "ქაროშთი" },
            { "Khmr", metaValue_km },
            { "Khoj", "ქოჯკი" },
            { "Knda", metaValue_CA },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "კაითი" },
            { "Laoo", metaValue_lo },
            { "Latg", "გელური ლათინური" },
            { "Latn", metaValue_la },
            { "Limb", "ლიმბუ" },
            { "Lina", "A-ხაზოვანი" },
            { "Linb", "B-ხაზოვანი" },
            { "Loma", "ლომა" },
            { "Lyci", "ლიკიური" },
            { "Lydi", "ლიდიური" },
            { "Mand", "მანდეური" },
            { "Mani", "მანიქეური" },
            { "Maya", "მაიას იეროგლიფები" },
            { "Mend", metaValue_men },
            { "Merc", "მეროიტული კურსივი" },
            { "Mero", "მეროიტული" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mroo", "მრო" },
            { "Mtei", metaValue_mni },
            { "Mymr", "მიანმური" },
            { "Narb", "ძველი ჩრდილოეთ-არაბული" },
            { "Nbat", "ნაბატეური" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "ნუშუ" },
            { "Ogam", "ოღამი" },
            { "Olck", "ოლ-ჩიკი" },
            { "Orkh", "ორხონული" },
            { "Orya", metaValue_or },
            { "Osma", "ოსმანია" },
            { "Palm", "პალმირული" },
            { "Perm", "ძველი პერმული" },
            { "Phag", "ფაგსპა" },
            { "Phli", "მონუმენტური ფალაური" },
            { "Phlp", "ფსალმუნური ფალაური" },
            { "Phlv", "წიგნური ფალაური" },
            { "Phnx", metaValue_phn },
            { "Prti", "მონუმენტური პართული" },
            { "Rjng", "რეჯანგი" },
            { "Rohg", "ჰანიფი" },
            { "Roro", "რონგორონგო" },
            { "Runr", "რუნული" },
            { "Samr", "სამარიული" },
            { "Sara", "სარატი" },
            { "Sarb", "ძველი სამხრეთ-არაბული" },
            { "Saur", "საურაშტრა" },
            { "Sgnw", "ჟესტთა" },
            { "Shrd", "შარადა" },
            { "Sind", "ქუდავადი" },
            { "Sinh", metaValue_si },
            { "Sora", "სორან-სომპენი" },
            { "Sund", "სუნდანური" },
            { "Sylo", "სილოტი ნაგრი" },
            { "Syrc", metaValue_syr },
            { "Syre", "სირიული ესტრანგელო" },
            { "Syrj", "დასავლეთი სირიული" },
            { "Syrn", "აღმოსავლეთი სირიული" },
            { "Tagb", "ტაგბანვა" },
            { "Takr", "ტაკრი" },
            { "Tale", "ტაი ლე" },
            { "Talu", "ახალი ტაი ლიუ" },
            { "Taml", metaValue_ta },
            { "Tang", "ტანღუტური" },
            { "Tavt", "ტაი-ვიეტი" },
            { "Telu", metaValue_te },
            { "Teng", "ტენგვარი" },
            { "Tfng", "ტიფინაღი" },
            { "Thaa", "თაანა" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "ტირჰუტა" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "ხილული მეტყველება" },
            { "Wara", "ვარანგ-კშიტი" },
            { "Wole", "ვოლეაი" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "შუმერულ-აქადური ლურსმნული" },
            { "Yiii", "ი" },
            { "Zinh", "გადაღებული" },
            { "Zmth", "მათემატიკური ნოტაცია" },
            { "Zsye", "Emoji" },
            { "Zsym", "სიმბოლოები" },
            { "Zxxx", "უმწერლობო" },
            { "Zyyy", "ზოგადი" },
            { "Zzzz", "უცნობი დამწერლობა" },
            { "de_AT", "ავსტრიული გერმანული" },
            { "de_CH", "შვეიცარიული ზემოგერმანული" },
            { "en_AU", "ავსტრალიური ინგლისური" },
            { "en_CA", "კანადური ინგლისური" },
            { "en_GB", "ბრიტანული ინგლისური" },
            { "en_US", "ამერიკული ინგლისური" },
            { "es_ES", "ევროპული ესპანური" },
            { "es_MX", "მექსიკური ესპანური" },
            { "fa_AF", "დარი" },
            { "fr_CA", "კანადური ფრანგული" },
            { "fr_CH", "შვეიცარიული ფრანგული" },
            { "nl_BE", "ფლამანდიური" },
            { "pt_BR", "ბრაზილიური პორტუგალიური" },
            { "pt_PT", "ევროპული პორტუგალიური" },
            { "ro_MD", "მოლდავური" },
            { "sw_CD", "კონგოს სუაჰილი" },
            { "ar_001", "თანამედროვე სტანდარტული არაბული" },
            { "es_419", "ლათინურ ამერიკული ესპანური" },
            { "key.ca", "კალენდარი" },
            { "key.cf", "ვალუტის ფორმატი" },
            { "key.co", "დახარისხების თანმიმდევრობა" },
            { "key.cu", "ვალუტა" },
            { "key.em", "სიცილაკების პრეზენტაცია" },
            { "key.hc", "დროის სისტემა (12 ან 24)" },
            { "key.lb", "სტრიქონის წყვეტის სტილი" },
            { "key.lw", "სტრიქონზე გადასვლა სიტყვებს შორის" },
            { "key.ms", "საზომი სისტემა" },
            { "key.nu", "რიცხვები" },
            { "key.ss", "წინადადების წყვეტა შემოკლ. შემდეგ" },
            { "nds_NL", "ქვემოსაქსონური" },
            { "zh_Hans", "გამარტივებული ჩინური" },
            { "zh_Hant", "ტრადიციული ჩინური" },
            { "type.ca.roc", "ჩინეთის რესპუბლიკის კალენდარი" },
            { "type.hc.h11", "12-საათიანი სისტემა (0-11)" },
            { "type.hc.h12", "12-საათიანი სისტემა (1-12)" },
            { "type.hc.h23", "24-საათიანი სისტემა (0-23)" },
            { "type.hc.h24", "24-საათიანი სისტემა (1-24)" },
            { "type.nu.arab", "არაბულ-ინდური ციფრები" },
            { "type.nu.armn", "სომხური რიცხვები" },
            { "type.nu.beng", "ბენგალური ციფრები" },
            { "type.nu.cakm", "ჩაკმა ციფრები" },
            { "type.nu.deva", "დევანაგარის ციფრები" },
            { "type.nu.ethi", "ეთიოპიური რიცხვები" },
            { "type.nu.geor", "ქართული რიცხვები" },
            { "type.nu.grek", "ბერძნული რიცხვები" },
            { "type.nu.gujr", "გუჯარათული ციფრები" },
            { "type.nu.guru", "გურმუხული ციფრები" },
            { "type.nu.hans", "გამარტივებული ჩინური რიცხვები" },
            { "type.nu.hant", "ტრადიციული ჩინური რიცხვები" },
            { "type.nu.hebr", "ებრაული რიცხვები" },
            { "type.nu.java", "იავური ციფრები" },
            { "type.nu.jpan", "იაპონური რიცხვები" },
            { "type.nu.khmr", "ქხმერული ციფრები" },
            { "type.nu.knda", "კანადური რიცხვები" },
            { "type.nu.laoo", "ლაოსური ციფრები" },
            { "type.nu.latn", "დასავლური ციფრები" },
            { "type.nu.limb", "ლიმბური ციფრები" },
            { "type.nu.mlym", "მალაიალამური ციფრები" },
            { "type.nu.mong", "მონღოლური ციფრები" },
            { "type.nu.mtei", "მანიპური ციფრები" },
            { "type.nu.mymr", "მიანმური ციფრები" },
            { "type.nu.olck", "ოლ-ჩიკის ციფრები" },
            { "type.nu.orya", "ორიული ციფრები" },
            { "type.nu.saur", "საურაშტრული ციფრები" },
            { "type.nu.sund", "სუნდანური ციფრები" },
            { "type.nu.talu", "ახალი ტაი ლიუსი ციფრები" },
            { "type.nu.taml", "ტრადიციული ტამილური რიცხვები" },
            { "type.nu.telu", "ტელუგუს ციფრები" },
            { "type.nu.thai", "ტაილანდური ციფრები" },
            { "type.nu.tibt", "ტიბეტური ციფრები" },
            { "type.nu.vaii", "ვაიური ციფრები" },
            { "type.ca.dangi", "კალენდარი დანგი" },
            { "type.co.ducet", "უნიკოდის ნაგულისხმევი დახარისხების თანმიმდევრობა" },
            { "type.lb.loose", "სტრიქონის რბილი წყვეტის სტილი" },
            { "type.nu.roman", "რომაული ციფრები" },
            { "type.ca.coptic", "კოპტური კალენდარი" },
            { "type.ca.hebrew", "ებრაული კალენდარი" },
            { "type.ca.indian", "ინდოეთის ეროვნული კალენდარი" },
            { "type.co.search", "ზოგადი დანიშნულების ძიება" },
            { "type.lb.normal", "სტრიქონის ჩვეულებრივი წყვეტის სტილი" },
            { "type.lb.strict", "სტრიქონის ზედმიწევნითი წყვეტის სტილი" },
            { "type.ms.metric", "მეტრული სისტემა" },
            { "type.ca.chinese", "ჩინური კალენდარი" },
            { "type.ca.islamic", "ჰიჯრის კალენდარი" },
            { "type.ca.iso8601", "ISO-8601 კალენდარი" },
            { "type.ca.persian", "სპარსული კალენდარი" },
            { "type.cf.account", "ვალუტის საბუღალტრო ფორმატი" },
            { "type.nu.arabext", "გაფართოებული არაბულ-ინდური ციფრები" },
            { "type.nu.armnlow", "სომხური ქვედა რეგისტრის რიცხვები" },
            { "type.nu.greklow", "ბერძნული ქვედა რეგისტრის რიცხვები" },
            { "type.nu.hanidec", "ჩინური ათობითი რიცხვები" },
            { "type.nu.hansfin", "გამარტივებული ჩინური ფინანსური რიცხვები" },
            { "type.nu.hantfin", "ტრადიციული ჩინური ფინანსური რიცხვები" },
            { "type.nu.jpanfin", "იაპონური ფინანსური რიცხვები" },
            { "type.nu.tamldec", "ტამილური ციფრები" },
            { "type.ca.buddhist", "ბუდისტური კალენდარი" },
            { "type.ca.ethiopic", "ეთიოპიური კალენდარი" },
            { "type.ca.japanese", "იაპონური კალენდარი" },
            { "type.cf.standard", "ვალუტის სტანდარტული ფორმატი" },
            { "type.co.standard", "სტანდარტული დახარისხების თანმიმდევრობა" },
            { "type.ms.uksystem", "ბრიტანული საზომი სისტემა" },
            { "type.ms.ussystem", "ამერიკული საზომი სისტემა" },
            { "type.nu.fullwide", "სრულსიგანიანი ციფრები" },
            { "type.nu.romanlow", "რომაული ქვედა რეგისტრის რიცხვები" },
            { "type.ca.gregorian", "გრიგორიანული კალენდარი" },
            { "type.co.traditional", metaValue_Hant },
            { "type.ca.islamic-civil", "ჰიჯრის სამოქალაქო კალენდარი (ტაბულარული)" },
            { "type.ca.islamic-umalqura", "ჰიჯრის კალენდარი (უმ-ალ-ქურა)" },
            { "type.ca.ethiopic-amete-alem", "ეთიოპიური ამეთე ალემი კალენდარი" },
        };
        return data;
    }
}
