/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.data;

import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.io.Positioned;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class V8HeapEdge
implements Positioned {
    private static final byte BACK_MASK = 1;
    private static final byte RESOLVED_MASK = 16;
    private final V8HeapGraphEdgeType myType;
    private final long myNameId;
    private final long myToIndex;
    private long myFromIndex;
    private final long myFileOffset;
    private final byte myIsBack;
    public static final long ourRecordSize = 37L;

    private V8HeapEdge(V8HeapGraphEdgeType type, long nameId, long fromIndex, long toIndex, long offset, byte isBack) {
        this.myType = type;
        this.myNameId = nameId;
        this.myFromIndex = fromIndex;
        this.myToIndex = toIndex;
        this.myFileOffset = offset;
        this.myIsBack = isBack;
    }

    public static V8HeapEdge createFromJson(int typeCode, long nameId, long toIndex, long seqNumber) {
        return new V8HeapEdge(V8HeapGraphEdgeType.getByNumber(typeCode), nameId, -1L, toIndex / 7L, seqNumber * 37L, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static V8HeapEdge createFromJson(int typeCode, long nameId, long toIndex, long l, @NotNull List<String> list) {
        void seqNumber;
        void nodeFieldTypes;
        if (list == null) {
            V8HeapEdge.$$$reportNull$$$0(0);
        }
        return new V8HeapEdge(V8HeapGraphEdgeType.getByNumber(typeCode), nameId, -1L, toIndex / (long)nodeFieldTypes.size(), (long)(seqNumber * 37L), 0);
    }

    public void setFromIndex(long fromIndex) {
        this.myFromIndex = fromIndex;
    }

    public boolean hasStringName() {
        return !V8HeapGraphEdgeType.kElement.equals((Object)this.myType) && !V8HeapGraphEdgeType.kHidden.equals((Object)this.myType) && !V8HeapGraphEdgeType.kWeak.equals((Object)this.myType);
    }

    @Nls
    private String _name(@NotNull V8CachingReader objectsProxyReader) {
        if (objectsProxyReader == null) {
            V8HeapEdge.$$$reportNull$$$0(1);
        }
        return this.hasStringName() ? objectsProxyReader.getString(this.myNameId) : String.valueOf(this.myNameId);
    }

    public Integer nameAsInt(@NotNull V8CachingReader objectsProxyReader) {
        if (objectsProxyReader == null) {
            V8HeapEdge.$$$reportNull$$$0(2);
        }
        String name = this._name(objectsProxyReader);
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nls
    public String getPresentation(@NotNull V8CachingReader objectsProxyReader) {
        if (objectsProxyReader == null) {
            V8HeapEdge.$$$reportNull$$$0(3);
        }
        String name = this._name(objectsProxyReader);
        Integer isNumber = null;
        if (V8HeapGraphEdgeType.kShortcut.equals((Object)this.getType())) {
            try {
                isNumber = Integer.parseInt(name);
            }
            catch (NumberFormatException e) {
                isNumber = null;
            }
        }
        return switch (this.getType()) {
            default -> throw new MatchException(null, null);
            case V8HeapGraphEdgeType.kContextVariable -> "->" + name;
            case V8HeapGraphEdgeType.kElement -> "[" + name + "]";
            case V8HeapGraphEdgeType.kWeak -> "[[" + name + "]]";
            case V8HeapGraphEdgeType.kProperty -> {
                if (!name.contains(" ")) {
                    yield "." + name;
                }
                yield "[\"" + name + "\"]";
            }
            case V8HeapGraphEdgeType.kShortcut -> {
                if (isNumber != null) {
                    yield "[" + name + "]";
                }
                if (!name.contains(" ")) {
                    yield "." + name;
                }
                yield "[\"" + name + "\"]";
            }
            case V8HeapGraphEdgeType.kInternal, V8HeapGraphEdgeType.kHidden, V8HeapGraphEdgeType.kInvisible -> "{" + name + "}";
        };
    }

    public V8HeapGraphEdgeType getType() {
        return this.myType;
    }

    public long getNameId() {
        return this.myNameId;
    }

    public long getToIndex() {
        return this.myToIndex;
    }

    public long getFileOffset() {
        return this.myFileOffset;
    }

    public long getId() {
        return this.getFileOffset() / 37L;
    }

    public long getFromIndex() {
        return this.myFromIndex;
    }

    @Override
    public long getOffset() {
        return this.getFileOffset();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V8HeapEdge edge = (V8HeapEdge)o;
        return this.myFileOffset == edge.myFileOffset;
    }

    public int hashCode() {
        return Long.hashCode(this.myFileOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeFieldTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectsProxyReader";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/data/V8HeapEdge";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromJson";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "_name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "nameAsInt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyRawSerializer
    implements RawSerializer<V8HeapEdge> {
        private static final MyRawSerializer ourInstance = new MyRawSerializer();

        public static MyRawSerializer getInstance() {
            return ourInstance;
        }

        @Override
        public long getRecordSize() {
            return 37L;
        }

        @Override
        public void write(@NotNull DataOutput dout, @NotNull V8HeapEdge edge) throws IOException {
            if (dout == null) {
                MyRawSerializer.$$$reportNull$$$0(0);
            }
            if (edge == null) {
                MyRawSerializer.$$$reportNull$$$0(1);
            }
            RawSerializer.Helper.serializeInt(edge.getType().getNumber(), dout);
            RawSerializer.Helper.serializeLong(edge.getNameId(), dout);
            RawSerializer.Helper.serializeLong(edge.getFromIndex(), dout);
            RawSerializer.Helper.serializeLong(edge.getToIndex(), dout);
            RawSerializer.Helper.serializeLong(edge.getFileOffset(), dout);
            dout.writeByte(edge.myIsBack);
        }

        @Override
        public V8HeapEdge read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyRawSerializer.$$$reportNull$$$0(2);
            }
            int typeId = RawSerializer.Helper.deserializeInt(in);
            long nameId = RawSerializer.Helper.deserializeLong(in);
            long fromIndex = RawSerializer.Helper.deserializeLong(in);
            long toIndex = RawSerializer.Helper.deserializeLong(in);
            long fileOffset = RawSerializer.Helper.deserializeLong(in);
            byte isBack = in.readByte();
            return new V8HeapEdge(V8HeapGraphEdgeType.getByNumber(typeId), nameId, fromIndex, toIndex, fileOffset, isBack);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dout";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edge";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/data/V8HeapEdge$MyRawSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

