/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff.postprorcess;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import liquibase.diff.DiffResult;
import liquibase.ext.intellij.diff.postprorcess.DiffResultPostProcessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0014"}, d2={"Lliquibase/ext/intellij/diff/postprorcess/MysqlIndexesPostprocessor;", "Lliquibase/ext/intellij/diff/postprorcess/DiffResultPostProcessor;", "diffResult", "Lliquibase/diff/DiffResult;", "referenceSnapshot", "Lliquibase/snapshot/DatabaseSnapshot;", "comparisonSnapshot", "<init>", "(Lliquibase/diff/DiffResult;Lliquibase/snapshot/DatabaseSnapshot;Lliquibase/snapshot/DatabaseSnapshot;)V", "getDiffResult", "()Lliquibase/diff/DiffResult;", "getReferenceSnapshot", "()Lliquibase/snapshot/DatabaseSnapshot;", "getComparisonSnapshot", "postProcessDiffResult", "", "hasForeignKeyOn", "", "unexpectedIndex", "Lliquibase/structure/core/Index;", "intellij.liquibase.common"})
public final class MysqlIndexesPostprocessor
implements DiffResultPostProcessor {
    @NotNull
    private final DiffResult diffResult;
    @NotNull
    private final DatabaseSnapshot referenceSnapshot;
    @NotNull
    private final DatabaseSnapshot comparisonSnapshot;

    public MysqlIndexesPostprocessor(@NotNull DiffResult diffResult, @NotNull DatabaseSnapshot referenceSnapshot, @NotNull DatabaseSnapshot comparisonSnapshot) {
        Intrinsics.checkNotNullParameter((Object)diffResult, (String)"diffResult");
        Intrinsics.checkNotNullParameter((Object)referenceSnapshot, (String)"referenceSnapshot");
        Intrinsics.checkNotNullParameter((Object)comparisonSnapshot, (String)"comparisonSnapshot");
        this.diffResult = diffResult;
        this.referenceSnapshot = referenceSnapshot;
        this.comparisonSnapshot = comparisonSnapshot;
    }

    @NotNull
    public final DiffResult getDiffResult() {
        return this.diffResult;
    }

    @NotNull
    public final DatabaseSnapshot getReferenceSnapshot() {
        return this.referenceSnapshot;
    }

    @NotNull
    public final DatabaseSnapshot getComparisonSnapshot() {
        return this.comparisonSnapshot;
    }

    @Override
    public void postProcessDiffResult() {
        Set unexpectedIndexes = this.diffResult.getUnexpectedObjects(Index.class);
        for (Index unexpectedIndex : unexpectedIndexes) {
            Intrinsics.checkNotNull((Object)unexpectedIndex);
            if (!this.hasForeignKeyOn(unexpectedIndex)) continue;
            Set set = this.diffResult.getUnexpectedObjects();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getUnexpectedObjects(...)");
            TypeIntrinsics.asMutableCollection((Object)set).remove(unexpectedIndex);
        }
    }

    private final boolean hasForeignKeyOn(Index unexpectedIndex) {
        Set foreignKeys = this.referenceSnapshot.get(ForeignKey.class);
        for (ForeignKey foreignKey : foreignKeys) {
            if (!Intrinsics.areEqual((Object)foreignKey.getForeignKeyTable().getName(), (Object)unexpectedIndex.getRelation().getName())) continue;
            return true;
        }
        return false;
    }
}

