/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.FlowJSElementTypesImpl;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSEmbeddedContentElementType;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.javascript.types.TypeScriptModuleElementType;
import com.intellij.lang.typescript.BasicTypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class JSNodeVisitor {
    public final void visit(ASTNode node) {
        IElementType type = node.getElementType();
        BiConsumer<JSNodeVisitor, ASTNode> consumer = Holder.ELEMENT_TYPES.get(type);
        if (consumer != null) {
            consumer.accept(this, node);
            return;
        }
        for (Pair<Condition<IElementType>, BiConsumer<JSNodeVisitor, ASTNode>> condition : Holder.CONDITIONS) {
            if (!((Condition)condition.first).value((Object)type)) continue;
            ((BiConsumer)condition.second).accept(this, node);
            return;
        }
        this.visitElement(node);
    }

    protected void visitDebuggerStatement(ASTNode node) {
        this.visitStatement(node);
    }

    protected void visitStringTemplateLiteralExpression(ASTNode node) {
        this.visitLiteralExpression(node);
    }

    protected void visitTaggedTemplate(ASTNode node) {
        this.visitExpression(node);
    }

    protected void visitImportExportAlias(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitEs6ImportExportSpecifier(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitJSBindExpression(ASTNode node) {
        this.visitExpression(node);
    }

    protected void visitMappedTypeParameter(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitComputedName(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitEmbeddedExpression(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptEnum(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTupleMember(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitES6FromClause(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTypeParameter(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitES6NamedImports(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTypeParameterList(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTypeArgumentList(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitDestructuringElement(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitDestructuringProperty(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitDestructuringParameter(ASTNode node) {
        this.visitParameter(node);
    }

    protected void visitFlowJSTypeCast(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypescriptTypeCast(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypescriptAsExpression(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeAlias(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptType(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTemplateLiteralType(ASTNode node) {
        this.visitTypeScriptType(node);
    }

    protected void visitYieldExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitXmlLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitImportStatement(ASTNode node) {
        this.visitElement(node);
    }

    public void visitAttributeList(ASTNode node) {
        this.visitElement(node);
    }

    public void visitPackageStatement(ASTNode node) {
        this.visitElement(node);
    }

    public void visitClass(ASTNode node) {
        this.visitElement(node);
    }

    public void visitFile(ASTNode node) {
        this.visitElement(node);
    }

    public void visitCallExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitIndexedPropertyAccessExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitNewExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitFunctionExpression(ASTNode node) {
        if (!this.visitAsFunction(node)) {
            this.visitExpression(node);
        }
    }

    public void visitGlobalModuleExport(ASTNode node) {
        this.visitElement(node);
    }

    public void visitFunctionProperty(ASTNode node) {
        if (!this.visitAsFunction(node)) {
            this.visitProperty(node);
        }
    }

    public void visitPrefixExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitThrowExpression(ASTNode node) {
        this.visitPrefixExpression(node);
    }

    public void visitPostfixExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitConditionalExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitCommaExpression(ASTNode node) {
        this.visitBinaryExpression(node);
    }

    public void visitTypeMember(ASTNode node) {
        this.visitElement(node);
    }

    public void visitAssignmentExpression(ASTNode node) {
        this.visitBinaryExpression(node);
    }

    public void visitBinaryExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitProperty(ASTNode node) {
        this.visitElement(node);
    }

    public void visitObjectLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitArrayLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitParenthesizedExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitReferenceExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitThisExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitForInStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitForStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitDoWhileStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitWhileStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitCaseClause(ASTNode node) {
        this.visitElement(node);
    }

    public void visitSwitchStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitCatchBlock(ASTNode node) {
        this.visitElement(node);
    }

    public void visitTryStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitThrowStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitReturnStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitWithStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitBreakStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitContinueStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitIfStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitDestructuringObject(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitDestructuringArray(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitEmptyStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitVarStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitES6ImportDeclaration(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitES6ImportedBinding(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitES6ExportDeclaration(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitExportDefaultAssignment(ASTNode node) {
        this.visitStatement(node);
    }

    protected void visitTypeScriptImportStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitES6DoExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitExpressionStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitLabeledStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitBlockStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitArgumentList(ASTNode node) {
        this.visitElement(node);
    }

    public void visitParameter(ASTNode node) {
        this.visitVariable(node);
    }

    public void visitVariable(ASTNode node) {
        this.visitElement(node);
    }

    public void visitParameterList(ASTNode node) {
        this.visitElement(node);
    }

    public void visitEmbeddedContent(ASTNode node) {
        this.visitElement(node);
    }

    public void visitElement(ASTNode node) {
        ProgressManager.checkCanceled();
    }

    public void visitSourceElement(ASTNode node) {
        this.visitElement(node);
    }

    public void visitFunctionDeclaration(ASTNode node) {
        if (!this.visitAsFunction(node)) {
            this.visitSourceElement(node);
        }
    }

    public boolean visitAsFunction(ASTNode function) {
        return false;
    }

    public void visitStatement(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitExpression(ASTNode node) {
        this.visitElement(node);
    }

    public void visitDocComment(ASTNode node) {
        this.visitElement(node);
    }

    public void visitComment(ASTNode node) {
        this.visitElement(node);
    }

    public void visitTypeScriptModule(ASTNode node) {
        this.visitElement(node);
    }

    public void visitTypeScriptInterface(ASTNode node) {
        this.visitElement(node);
    }

    public void visitObjectType(ASTNode node) {
        this.visitTypeScriptType(node);
    }

    public void visitStaticBlock(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitWithClause(ASTNode node) {
        this.visitElement(node);
    }

    public void visitWithEntry(ASTNode node) {
        this.visitElement(node);
    }

    private static final class Holder {
        private static final Map<IElementType, BiConsumer<JSNodeVisitor, ASTNode>> ELEMENT_TYPES = Map.ofEntries(Map.entry(JSElementTypes.LABELED_STATEMENT, JSNodeVisitor::visitLabeledStatement), Map.entry(JSElementTypes.EMPTY_STATEMENT, JSNodeVisitor::visitEmptyStatement), Map.entry(JSElementTypes.IF_STATEMENT, JSNodeVisitor::visitIfStatement), Map.entry(JSElementTypes.CONTINUE_STATEMENT, JSNodeVisitor::visitContinueStatement), Map.entry(JSElementTypes.THROW_STATEMENT, JSNodeVisitor::visitThrowExpression), Map.entry(JSElementTypes.DESTRUCTURING_PARAMETER, JSNodeVisitor::visitDestructuringParameter), Map.entry(JSElementTypes.EXPRESSION_STATEMENT, JSNodeVisitor::visitExpressionStatement), Map.entry(JSElementTypes.BREAK_STATEMENT, JSNodeVisitor::visitBreakStatement), Map.entry(JSElementTypes.WITH_STATEMENT, JSNodeVisitor::visitWithStatement), Map.entry(JSElementTypes.DEBUGGER_STATEMENT, JSNodeVisitor::visitDebuggerStatement), Map.entry(JSElementTypes.RETURN_STATEMENT, JSNodeVisitor::visitReturnStatement), Map.entry(JSElementTypes.YIELD_EXPRESSION, JSNodeVisitor::visitYieldExpression), Map.entry(JSElementTypes.TRY_STATEMENT, JSNodeVisitor::visitTryStatement), Map.entry(JSElementTypes.CATCH_BLOCK, JSNodeVisitor::visitCatchBlock), Map.entry(JSElementTypes.SWITCH_STATEMENT, JSNodeVisitor::visitSwitchStatement), Map.entry(JSElementTypes.WHILE_STATEMENT, JSNodeVisitor::visitWhileStatement), Map.entry(JSElementTypes.DOWHILE_STATEMENT, JSNodeVisitor::visitDoWhileStatement), Map.entry(JSElementTypes.FOR_STATEMENT, JSNodeVisitor::visitForStatement), Map.entry(JSElementTypes.FOR_IN_STATEMENT, JSNodeVisitor::visitForInStatement), Map.entry(JSElementTypes.STRING_TEMPLATE_EXPRESSION, JSNodeVisitor::visitStringTemplateLiteralExpression), Map.entry(JSElementTypes.LITERAL_EXPRESSION, JSNodeVisitor::visitLiteralExpression), Map.entry(JSElementTypes.REFERENCE_EXPRESSION, JSNodeVisitor::visitReferenceExpression), Map.entry(JSElementTypes.PARENTHESIZED_EXPRESSION, JSNodeVisitor::visitParenthesizedExpression), Map.entry(TypeScriptElementTypes.TUPLE_MEMBER_ELEMENT, JSNodeVisitor::visitTypeScriptTupleMember), Map.entry(JSElementTypes.NAMED_IMPORTS, JSNodeVisitor::visitES6NamedImports), Map.entry(JSElementTypes.FROM_CLAUSE, JSNodeVisitor::visitES6FromClause), Map.entry(TypeScriptElementTypes.TYPESCRIPT_IMPORT_STATEMENT, JSNodeVisitor::visitTypeScriptImportStatement), Map.entry(JSElementTypes.EXPORT_DEFAULT_ASSIGNMENT, JSNodeVisitor::visitExportDefaultAssignment), Map.entry(TypeScriptElementTypes.EXPORT_ASSIGNMENT, JSNodeVisitor::visitExportDefaultAssignment), Map.entry(TypeScriptElementTypes.TYPE_ARGUMENT_LIST, JSNodeVisitor::visitTypeScriptTypeArgumentList), Map.entry(TypeScriptElementTypes.TSX_TAG_TYPE_ARGUMENT_LIST, JSNodeVisitor::visitTypeScriptTypeArgumentList), Map.entry(TypeScriptElementTypes.TYPE_PARAMETER_LIST, JSNodeVisitor::visitTypeScriptTypeParameterList), Map.entry(TypeScriptElementTypes.TYPE_PARAMETER, JSNodeVisitor::visitTypeScriptTypeParameter), Map.entry(JSElementTypes.TYPESCRIPT_TYPE_ALIAS, JSNodeVisitor::visitTypeAlias), Map.entry(JSElementTypes.TYPESCRIPT_ENUM, JSNodeVisitor::visitTypeScriptEnum), Map.entry(TypeScriptElementTypes.MAPPED_TYPE_PARAMETER, JSNodeVisitor::visitMappedTypeParameter), Map.entry(TypeScriptElementTypes.OBJECT_TYPE, JSNodeVisitor::visitObjectType), Map.entry(JSElementTypes.DO_EXPRESSION, JSNodeVisitor::visitES6DoExpression), Map.entry(JSElementTypes.EXPORT_DECLARATION, JSNodeVisitor::visitES6ExportDeclaration), Map.entry(TypeScriptElementTypes.TYPESCRIPT_GLOBAL_MODULE_EXPORT, JSNodeVisitor::visitGlobalModuleExport), Map.entry(JSElementTypes.DESTRUCTURING_PROPERTY, JSNodeVisitor::visitDestructuringProperty), Map.entry(JSElementTypes.DESTRUCTURING_ARRAY, JSNodeVisitor::visitDestructuringArray), Map.entry(JSElementTypes.DESTRUCTURING_OBJECT, JSNodeVisitor::visitDestructuringObject), Map.entry(JSElementTypes.IMPORT_DECLARATION, JSNodeVisitor::visitES6ImportDeclaration), Map.entry(JSElementTypes.IMPORTED_BINDING, JSNodeVisitor::visitES6ImportedBinding), Map.entry(JSElementTypes.TYPESCRIPT_INTERFACE, JSNodeVisitor::visitTypeScriptInterface), Map.entry(JSElementTypes.IMPORT_STATEMENT, JSNodeVisitor::visitImportStatement), Map.entry(JSElementTypes.EXPORT_SPECIFIER, JSNodeVisitor::visitEs6ImportExportSpecifier), Map.entry(JSElementTypes.IMPORT_SPECIFIER, JSNodeVisitor::visitEs6ImportExportSpecifier), Map.entry(JSElementTypes.IMPORT_SPECIFIER_ALIAS, JSNodeVisitor::visitImportExportAlias), Map.entry(JSElementTypes.EXPORT_SPECIFIER_ALIAS, JSNodeVisitor::visitImportExportAlias), Map.entry(JSElementTypes.PACKAGE_STATEMENT, JSNodeVisitor::visitPackageStatement), Map.entry(JSElementTypes.EMBEDDED_EXPRESSION, JSNodeVisitor::visitEmbeddedExpression), Map.entry(JSElementTypes.DOC_COMMENT, JSNodeVisitor::visitDocComment), Map.entry(JSTokenTypes.C_STYLE_COMMENT, JSNodeVisitor::visitComment), Map.entry(JSElementTypes.CALL_EXPRESSION, JSNodeVisitor::visitCallExpression), Map.entry(JSElementTypes.BIND_EXPRESSION, JSNodeVisitor::visitJSBindExpression), Map.entry(JSElementTypes.ATTRIBUTE_LIST, JSNodeVisitor::visitAttributeList), Map.entry(ActionScriptElementTypes.ACTIONSCRIPT_ATTRIBUTE_LIST, JSNodeVisitor::visitAttributeList), Map.entry(JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION, JSNodeVisitor::visitIndexedPropertyAccessExpression), Map.entry(JSElementTypes.TAGGED_TEMPLATE_EXPRESSION, JSNodeVisitor::visitTaggedTemplate), Map.entry(JSElementTypes.TYPE_ASSERTION, JSNodeVisitor::visitTypescriptTypeCast), Map.entry(JSElementTypes.TYPE_AS_EXPRESSION, JSNodeVisitor::visitTypescriptAsExpression), Map.entry(FlowJSElementTypesImpl.TYPE_CAST, JSNodeVisitor::visitFlowJSTypeCast), Map.entry(JSElementTypes.COMPUTED_NAME, JSNodeVisitor::visitComputedName), Map.entry(JSElementTypes.PREFIX_EXPRESSION, JSNodeVisitor::visitPrefixExpression), Map.entry(JSElementTypes.POSTFIX_EXPRESSION, JSNodeVisitor::visitPostfixExpression), Map.entry(JSElementTypes.CONDITIONAL_EXPRESSION, JSNodeVisitor::visitConditionalExpression), Map.entry(JSElementTypes.COMMA_EXPRESSION, JSNodeVisitor::visitCommaExpression), Map.entry(JSElementTypes.ASSIGNMENT_EXPRESSION, JSNodeVisitor::visitAssignmentExpression), Map.entry(JSElementTypes.BINARY_EXPRESSION, JSNodeVisitor::visitBinaryExpression), Map.entry(JSElementTypes.OBJECT_LITERAL_EXPRESSION, JSNodeVisitor::visitObjectLiteralExpression), Map.entry(JSElementTypes.ARRAY_LITERAL_EXPRESSION, JSNodeVisitor::visitArrayLiteralExpression), Map.entry(JSElementTypes.THIS_EXPRESSION, JSNodeVisitor::visitThisExpression), Map.entry(TypeScriptElementTypes.TEMPLATE_LITERAL_TYPE, JSNodeVisitor::visitTypeScriptTemplateLiteralType), Map.entry(JSElementTypes.STATIC_BLOCK, JSNodeVisitor::visitStaticBlock), Map.entry(JSElementTypes.WITH_CLAUSE, JSNodeVisitor::visitWithClause), Map.entry(JSElementTypes.WITH_ENTRY, JSNodeVisitor::visitWithEntry));
        private static final List<Pair<Condition<IElementType>, BiConsumer<JSNodeVisitor, ASTNode>>> CONDITIONS;

        private Holder() {
        }

        static {
            Pair[] pairArray = new Pair[20];
            pairArray[0] = Pair.create(JSFileElementType.class::isInstance, JSNodeVisitor::visitFile);
            pairArray[1] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.FUNCTION_DECLARATIONS).contains(arg_0), JSNodeVisitor::visitFunctionDeclaration);
            pairArray[2] = Pair.create(arg_0 -> ((TokenSet)BasicTypeScriptElementTypes.PARAMETER_LISTS).contains(arg_0), JSNodeVisitor::visitParameterList);
            pairArray[3] = Pair.create(arg_0 -> ((TokenSet)JSExtendedLanguagesTokenSetProvider.PARAMETERS).contains(arg_0), JSNodeVisitor::visitParameter);
            pairArray[4] = Pair.create(arg_0 -> ((TokenSet)JSExtendedLanguagesTokenSetProvider.BODY_VARIABLES).contains(arg_0), JSNodeVisitor::visitVariable);
            pairArray[5] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.BLOCK_STATEMENTS).contains(arg_0), JSNodeVisitor::visitBlockStatement);
            pairArray[6] = Pair.create(arg_0 -> ((TokenSet)BasicTypeScriptElementTypes.VAR_STATEMENTS).contains(arg_0), JSNodeVisitor::visitVarStatement);
            pairArray[7] = Pair.create(arg_0 -> ((TokenSet)JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES).contains(arg_0), JSNodeVisitor::visitCaseClause);
            pairArray[8] = Pair.create(JSPropertyElementType.class::isInstance, JSNodeVisitor::visitProperty);
            pairArray[9] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.FUNCTION_EXPRESSIONS).contains(arg_0), JSNodeVisitor::visitFunctionExpression);
            pairArray[10] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.FUNCTION_PROPERTIES).contains(arg_0), JSNodeVisitor::visitFunctionProperty);
            pairArray[11] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.NEW_EXPRESSIONS).contains(arg_0), JSNodeVisitor::visitNewExpression);
            pairArray[12] = Pair.create(JSEmbeddedContentElementType.class::isInstance, JSNodeVisitor::visitEmbeddedContent);
            pairArray[13] = Pair.create(JSClassElementTypeBase.class::isInstance, JSNodeVisitor::visitClass);
            pairArray[14] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.XML_LITERALS).contains(arg_0), JSNodeVisitor::visitXmlLiteralExpression);
            pairArray[15] = Pair.create(TypeScriptModuleElementType.class::isInstance, JSNodeVisitor::visitTypeScriptModule);
            pairArray[16] = Pair.create(arg_0 -> ((TokenSet)JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS).contains(arg_0), JSNodeVisitor::visitDestructuringElement);
            pairArray[17] = Pair.create(arg_0 -> ((TokenSet)TypeScriptElementTypes.TYPE_MEMBERS).contains(arg_0), JSNodeVisitor::visitTypeMember);
            pairArray[18] = Pair.create(arg_0 -> ((TokenSet)TypeScriptElementTypes.TYPESCRIPT_TYPES).contains(arg_0), JSNodeVisitor::visitTypeScriptType);
            pairArray[19] = Pair.create(arg_0 -> ((TokenSet)JSExtendedLanguagesTokenSetProvider.ARGUMENT_LISTS).contains(arg_0), JSNodeVisitor::visitArgumentList);
            CONDITIONS = List.of(pairArray);
        }
    }
}

