/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.batik.mapping.svg;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableList;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.event.Button;
import org.jetbrains.letsPlot.commons.event.KeyModifiers;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgCircleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgClipPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgDefsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgEllipseElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgImageElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgStyleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTSpanElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextNode;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMAElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMCircleElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMClipPathElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMDefsElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMEllipseElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMGElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMImageElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMLineElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMPathElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMRectElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMSVGElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMStyleElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMTSpanElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMTextElement;
import org.jetbrains.relocated.apache.batik.dom.AbstractDocument;
import org.jetbrains.relocated.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/batik/mapping/svg/Utils;", "", "()V", "W3C_BUTTON_LEFT", "", "W3C_BUTTON_MIDDLE", "W3C_BUTTON_RIGHT", "elementChildren", "", "Lorg/w3c/dom/Node;", "e", "getButton", "Lorg/jetbrains/letsPlot/commons/event/Button;", "evt", "Lorg/jetbrains/relocated/apache/batik/dom/events/DOMMouseEvent;", "getModifiers", "Lorg/jetbrains/letsPlot/commons/event/KeyModifiers;", "newBatikElement", "Lorg/w3c/dom/Element;", "source", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "myDoc", "Lorg/jetbrains/relocated/apache/batik/dom/AbstractDocument;", "newBatikNode", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "newBatikText", "Lorg/w3c/dom/Text;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextNode;", "platf-batik"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    private static final int W3C_BUTTON_LEFT = 0;
    private static final int W3C_BUTTON_MIDDLE = 1;
    private static final int W3C_BUTTON_RIGHT = 2;

    private Utils() {
    }

    @NotNull
    public final List<Node> elementChildren(@NotNull Node e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return (List)new AbstractMutableList<Node>(e){
            final /* synthetic */ Node $e;
            {
                this.$e = $e;
            }

            public int getSize() {
                return this.$e.getChildNodes().getLength();
            }

            @NotNull
            public Node get(int index) {
                Node node = this.$e.getChildNodes().item(index);
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"item(...)");
                return node;
            }

            @NotNull
            public Node set(int index, @NotNull Node element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element.getParentNode() != null) {
                    throw new IllegalStateException();
                }
                Node child = this.get(index);
                this.$e.replaceChild(element, child);
                return child;
            }

            public void add(int index, @NotNull Node element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element.getParentNode() != null) {
                    throw new IllegalStateException();
                }
                if (index == this.size()) {
                    this.$e.insertBefore(element, null);
                } else {
                    this.$e.insertBefore(element, this.get(index));
                }
            }

            @NotNull
            public Node removeAt(int index) {
                Node child = this.get(index);
                this.$e.removeChild(child);
                return child;
            }
        };
    }

    @NotNull
    public final Element newBatikElement(@NotNull SvgElement source, @NotNull AbstractDocument myDoc) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)myDoc, (String)"myDoc");
        Node node = this.newBatikNode(source, myDoc);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
        return (Element)node;
    }

    @NotNull
    public final Text newBatikText(@NotNull SvgTextNode source, @NotNull AbstractDocument myDoc) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)myDoc, (String)"myDoc");
        Node node = this.newBatikNode(source, myDoc);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Text");
        return (Text)node;
    }

    @NotNull
    public final Node newBatikNode(@NotNull SvgNode source, @NotNull AbstractDocument myDoc) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)myDoc, (String)"myDoc");
        SvgNode svgNode = source;
        if (svgNode instanceof SvgEllipseElement) {
            node = new SVGOMEllipseElement(null, myDoc);
        } else if (svgNode instanceof SvgCircleElement) {
            node = new SVGOMCircleElement(null, myDoc);
        } else if (svgNode instanceof SvgRectElement) {
            node = new SVGOMRectElement(null, myDoc);
        } else if (svgNode instanceof SvgTextElement) {
            node = new SVGOMTextElement(null, myDoc);
        } else if (svgNode instanceof SvgPathElement) {
            node = new SVGOMPathElement(null, myDoc);
        } else if (svgNode instanceof SvgLineElement) {
            node = new SVGOMLineElement(null, myDoc);
        } else if (svgNode instanceof SvgSvgElement) {
            node = new SVGOMSVGElement(null, myDoc);
        } else if (svgNode instanceof SvgGElement) {
            node = new SVGOMGElement(null, myDoc);
        } else if (svgNode instanceof SvgStyleElement) {
            node = new SVGOMStyleElement(null, myDoc);
        } else if (svgNode instanceof SvgTextNode) {
            Text text2 = myDoc.createTextNode(null);
            Intrinsics.checkNotNullExpressionValue((Object)text2, (String)"createTextNode(...)");
            node = text2;
        } else if (svgNode instanceof SvgTSpanElement) {
            node = new SVGOMTSpanElement(null, myDoc);
        } else if (svgNode instanceof SvgDefsElement) {
            node = new SVGOMDefsElement(null, myDoc);
        } else if (svgNode instanceof SvgClipPathElement) {
            node = new SVGOMClipPathElement(null, myDoc);
        } else if (svgNode instanceof SvgImageElement) {
            node = new SVGOMImageElement(null, myDoc);
        } else if (svgNode instanceof SvgAElement) {
            node = new SVGOMAElement(null, myDoc);
        } else {
            throw new IllegalStateException("Unsupported SvgElement " + source);
        }
        return node;
    }

    @NotNull
    public final Button getButton(@NotNull DOMMouseEvent evt) {
        Button button2;
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        switch (evt.getButton()) {
            case 0: {
                button2 = Button.LEFT;
                break;
            }
            case 1: {
                button2 = Button.MIDDLE;
                break;
            }
            case 2: {
                button2 = Button.RIGHT;
                break;
            }
            default: {
                button2 = Button.NONE;
            }
        }
        return button2;
    }

    @NotNull
    public final KeyModifiers getModifiers(@NotNull DOMMouseEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        boolean ctrlKey = evt.getCtrlKey();
        boolean altKey = evt.getAltKey();
        boolean shiftKey = evt.getShiftKey();
        boolean metaKey = evt.getMetaKey();
        return new KeyModifiers(ctrlKey, altKey, shiftKey, metaKey);
    }
}

