/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.json.completion.cloud.utils;

import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.ProposalTransformer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/json/completion/cloud/utils/JsonTrimVersionTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/ProposalTransformer;", "<init>", "()V", "QUOTED_STRING_REGEX", "Lkotlin/text/Regex;", "VERSION_REGEX", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "isLookLikeVersionValue", "", "value", "", "intellij.ml.llm.json.completion"})
public final class JsonTrimVersionTransformer
implements ProposalTransformer {
    @NotNull
    public static final JsonTrimVersionTransformer INSTANCE = new JsonTrimVersionTransformer();
    @NotNull
    private static final Regex QUOTED_STRING_REGEX = new Regex("([^\"]+)\"");
    @NotNull
    private static final Regex VERSION_REGEX = new Regex("^[~^<>=]*v?(\\d+\\.)?(\\d+\\.)?(\\d+)([-+a-zA-Z0-9.]*)?$");

    private JsonTrimVersionTransformer() {
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal2) {
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        String suggestionWithoutVersions = QUOTED_STRING_REGEX.replace((CharSequence)proposal2.getSuggestion(), JsonTrimVersionTransformer::transformRaw$lambda$0);
        return proposal2.withSuggestion(suggestionWithoutVersions);
    }

    private final boolean isLookLikeVersionValue(String value) {
        String trimmed = ((Object)StringsKt.trim((CharSequence)value)).toString();
        int n = trimmed.length();
        if (!(3 <= n ? n < 21 : false)) {
            return false;
        }
        return VERSION_REGEX.matches((CharSequence)trimmed);
    }

    private static final CharSequence transformRaw$lambda$0(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        String content2 = (String)matchResult.getGroupValues().get(1);
        return INSTANCE.isLookLikeVersionValue(content2) ? (CharSequence)"\"" : (CharSequence)matchResult.getValue();
    }
}

