/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.properties.completion;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionSkipLocationSupporter;
import com.intellij.ml.inline.completion.impl.kit.SkipLocationReason;
import com.intellij.ml.llm.properties.completion.util.PropertiesSecretKeyDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/properties/completion/PropertiesSkipLocationSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionSkipLocationSupporter;", "<init>", "()V", "getReasonOrNull", "Lcom/intellij/ml/inline/completion/impl/kit/SkipLocationReason;", "parameters", "Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "getPropertyForCaret", "Lcom/intellij/lang/properties/IProperty;", "file", "Lcom/intellij/lang/properties/psi/PropertiesFile;", "caretOffset", "", "isCurrentElementEndOfLineWhiteSpace", "", "element", "Lcom/intellij/psi/PsiElement;", "isUserTypingNonTemplateValue", "value", "", "isUserTypingNonTemplateValue$intellij_ml_llm_properties_completion", "isUserTypingDefaultValueInTemplate", "isUserTypingDefaultValueInTemplate$intellij_ml_llm_properties_completion", "VALUE_ENDING_WITH_PARTIAL_TEMPLATE_PATTERN", "Lkotlin/text/Regex;", "VALUE_ENDING_WITH_TEMPLATE_DEFAULT_VALUE_PATTERN", "intellij.ml.llm.properties.completion"})
@SourceDebugExtension(value={"SMAP\nPropertiesSkipLocationSupporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertiesSkipLocationSupporter.kt\ncom/intellij/ml/llm/properties/completion/PropertiesSkipLocationSupporter\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,76:1\n67#2:77\n*S KotlinDebug\n*F\n+ 1 PropertiesSkipLocationSupporter.kt\ncom/intellij/ml/llm/properties/completion/PropertiesSkipLocationSupporter\n*L\n58#1:77\n*E\n"})
public final class PropertiesSkipLocationSupporter
implements MLCompletionSkipLocationSupporter {
    @NotNull
    private final Regex VALUE_ENDING_WITH_PARTIAL_TEMPLATE_PATTERN = new Regex("\\$\\{[^}]*$");
    @NotNull
    private final Regex VALUE_ENDING_WITH_TEMPLATE_DEFAULT_VALUE_PATTERN = new Regex("\\$\\{[^}:]+:[^}]*$");

    @Override
    @Nullable
    public SkipLocationReason getReasonOrNull(@NotNull MLCompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        PsiFile psiFile2 = parameters.getFile();
        PropertiesFile propertiesFile = psiFile2 instanceof PropertiesFile ? (PropertiesFile)psiFile2 : null;
        if (propertiesFile == null) {
            return null;
        }
        PropertiesFile file = propertiesFile;
        IProperty iProperty = this.getPropertyForCaret(file, parameters.getOffset());
        if (iProperty == null) {
            return null;
        }
        IProperty caretProperty = iProperty;
        String string = caretProperty.getKey();
        if (string == null) {
            return null;
        }
        String caretPropertyKey = string;
        if (!PropertiesSecretKeyDetector.INSTANCE.isSecretKey(caretPropertyKey)) {
            return null;
        }
        String string2 = caretProperty.getValue();
        if (string2 == null) {
            return null;
        }
        String caretPropertyValue = string2;
        if (this.isUserTypingNonTemplateValue$intellij_ml_llm_properties_completion(caretPropertyValue)) {
            return SkipLocationReason.PROPERTIES_SECRET_PLAIN_VALUE_COMPLETION_DISABLED;
        }
        if (this.isUserTypingDefaultValueInTemplate$intellij_ml_llm_properties_completion(caretPropertyValue)) {
            return SkipLocationReason.PROPERTIES_SECRET_TEMPLATE_WITH_DEFAULT_VALUE_COMPLETION_DISABLED;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final IProperty getPropertyForCaret(PropertiesFile file, int caretOffset) {
        void $this$parentOfType$iv;
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file.getContainingFile(), (int)caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        PsiElement currentElement = psiElement;
        if (this.isCurrentElementEndOfLineWhiteSpace(currentElement, caretOffset)) {
            PsiElement psiElement2 = PsiUtilCore.getElementAtOffset((PsiFile)file.getContainingFile(), (int)(caretOffset - 1));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElementAtOffset(...)");
            currentElement = psiElement2;
        }
        PsiElement psiElement3 = currentElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (IProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, Property.class, (boolean)false);
    }

    private final boolean isCurrentElementEndOfLineWhiteSpace(PsiElement element, int caretOffset) {
        return element instanceof PsiWhiteSpace && PsiTreeUtilKt.getStartOffset((PsiElement)element) == caretOffset && caretOffset > 0;
    }

    @VisibleForTesting
    public final boolean isUserTypingNonTemplateValue$intellij_ml_llm_properties_completion(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return !this.VALUE_ENDING_WITH_PARTIAL_TEMPLATE_PATTERN.containsMatchIn((CharSequence)value);
    }

    @VisibleForTesting
    public final boolean isUserTypingDefaultValueInTemplate$intellij_ml_llm_properties_completion(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.VALUE_ENDING_WITH_TEMPLATE_DEFAULT_VALUE_PATTERN.containsMatchIn((CharSequence)value);
    }
}

