/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.javaee.ui.JavaeeCodeStyleSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class NewAbstractDataHolder {
    private String myName;
    private String myClassName;
    private PsiDirectory myClassDirectory;
    protected final JavaeeCodeStyleSettings myCodeStyleSettings;
    protected final Module myModule;
    private final List<?> myExistings;
    private final String myOldName;

    protected NewAbstractDataHolder(@NotNull Module module, List<?> existings, String oldName) {
        if (module == null) {
            NewAbstractDataHolder.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myExistings = existings;
        this.myOldName = oldName;
        this.myCodeStyleSettings = (JavaeeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)module.getProject()).getCustomSettings(JavaeeCodeStyleSettings.class);
    }

    public Module getModule() {
        return this.myModule;
    }

    @NonNls
    protected abstract String getDefaultName();

    protected abstract String getObjectName(Object var1);

    protected String getUniqueName() {
        String defaultName;
        Set existingNames = ContainerUtil.map2Set(this.myExistings, s -> this.getObjectName(s));
        if (!existingNames.contains(this.getFullName(defaultName = this.getDefaultName()))) {
            return defaultName;
        }
        int i = 2;
        String name;
        while (existingNames.contains(this.getFullName(name = defaultName + i))) {
            ++i;
        }
        return name;
    }

    private String getFullName(String defaultName) {
        return this.getNamePrefix(this.myCodeStyleSettings) + defaultName + this.getNameSuffix(this.myCodeStyleSettings);
    }

    public abstract String getNamePrefix(JavaeeCodeStyleSettings var1);

    public abstract String getNameSuffix(JavaeeCodeStyleSettings var1);

    public String getName() {
        return this.myName;
    }

    public void setName(@NonNls String name) {
        this.myName = name;
    }

    @NlsSafe
    public String getClassName() {
        return this.myClassName;
    }

    public void setClassName(@NonNls String className) {
        this.myClassName = className;
    }

    public PsiDirectory getClassDirectory() {
        return this.myClassDirectory;
    }

    public void setClassDirectory(PsiDirectory classDirectory) {
        this.myClassDirectory = ClassUtil.sourceRoot((PsiDirectory)classDirectory);
    }

    public void setPackage(String packageName) {
        this.myClassName = ClassUtil.createNewClassQualifiedName((String)packageName, (String)this.myClassName);
    }

    @NlsSafe
    public String getPackage() {
        return ClassUtil.extractPackageName((String)this.getClassName());
    }

    public String getPureName() {
        String result = this.getName();
        String namePrefix = this.getNamePrefix(this.myCodeStyleSettings);
        result = StringUtil.trimStart((String)result, (String)namePrefix);
        String nameSuffix = this.getNameSuffix(this.myCodeStyleSettings);
        result = StringUtil.trimEnd((String)result, (String)nameSuffix);
        return result;
    }

    public boolean checkNameIsUnique() {
        String name = this.getName();
        if (Objects.equals(this.myOldName, name)) {
            return true;
        }
        for (Object existing : this.myExistings) {
            String anotherName = this.getObjectName(existing);
            if (Objects.equals(anotherName, this.myOldName) || !Objects.equals(anotherName, name)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/ui/NewAbstractDataHolder", "<init>"));
    }
}

