/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.module.JavaeeLibrariesUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public final class JavaeeUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        boolean addFix;
        Module module;
        if (ref == null) {
            JavaeeUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            JavaeeUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)ref)) == null) {
            return;
        }
        if (ExternalProjectSystemRegistry.getInstance().getExternalSource(module) != null) {
            return;
        }
        String text = ref.getCanonicalText();
        if (JavaeeUnresolvedReferenceQuickFixProvider.isJavaeeQName(text)) {
            addFix = true;
        } else if (text.indexOf(46) < 0) {
            PsiFile containingFile = ref.getContainingFile();
            PsiImportList importList = containingFile instanceof PsiJavaFile ? ((PsiJavaFile)containingFile).getImportList() : null;
            addFix = importList != null && null != ContainerUtil.find((Object[])importList.getImportStatements(), statement -> {
                String qname = statement.getQualifiedName();
                if (qname == null || !JavaeeUnresolvedReferenceQuickFixProvider.isJavaeeQName(qname)) {
                    return false;
                }
                return qname.endsWith(text) || statement.resolve() == null;
            });
        } else {
            addFix = false;
        }
        if (addFix) {
            registrar.register((IntentionAction)JavaeeLibrariesUtil.createAddJavaeeLibraryQuickFix(module, J2EEBundle.message((String)"java.ee.libraries", (Object[])new Object[0])));
        }
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        return PsiJavaCodeReferenceElement.class;
    }

    private static boolean isJavaeeQName(String text) {
        if (text.startsWith("javax.")) {
            Object[] packageList = new String[]{"activation", "annotation", "ejb", "el", "enterprise", "interceptor", "jms", "jws", "mail", "persistence", "resource", "security", "servlet", "transaction", "xml"};
            return null != ContainerUtil.find((Object[])packageList, pkg -> {
                String packageName = "javax." + pkg;
                return text.startsWith(packageName) && (text.length() == packageName.length() || text.charAt(packageName.length()) == '.');
            });
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ref";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "registrar";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/module/JavaeeUnresolvedReferenceQuickFixProvider";
        objectArray[2] = "registerFixes";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

