/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldConsumers;
import org.apache.lucene.index.DocFieldConsumersPerField;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;

final class DocFieldConsumersPerThread
extends DocFieldConsumerPerThread {
    final DocFieldConsumerPerThread one;
    final DocFieldConsumerPerThread two;
    final DocFieldConsumers parent;
    final DocumentsWriter.DocState docState;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DocFieldConsumersPerThread(DocFieldProcessorPerThread docFieldProcessorPerThread, DocFieldConsumers parent, DocFieldConsumerPerThread one, DocFieldConsumerPerThread two) {
        this.parent = parent;
        this.one = one;
        this.two = two;
        this.docState = docFieldProcessorPerThread.docState;
    }

    public void startDocument() throws IOException {
        this.one.startDocument();
        this.two.startDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        try {
            this.one.abort();
        }
        finally {
            this.two.abort();
        }
    }

    public DocumentsWriter.DocWriter finishDocument() throws IOException {
        DocumentsWriter.DocWriter oneDoc = this.one.finishDocument();
        DocumentsWriter.DocWriter twoDoc = this.two.finishDocument();
        if (oneDoc == null) {
            return twoDoc;
        }
        if (twoDoc == null) {
            return oneDoc;
        }
        DocFieldConsumers.PerDoc both = this.parent.getPerDoc();
        both.docID = this.docState.docID;
        if (!$assertionsDisabled && oneDoc.docID != this.docState.docID) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && twoDoc.docID != this.docState.docID) {
            throw new AssertionError();
        }
        both.one = oneDoc;
        both.two = twoDoc;
        return both;
    }

    public DocFieldConsumerPerField addField(FieldInfo fi) {
        return new DocFieldConsumersPerField(this, this.one.addField(fi), this.two.addField(fi));
    }

    static {
        $assertionsDisabled = !DocFieldConsumersPerThread.class.desiredAssertionStatus();
    }
}

