/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cron;

import com.intellij.cron.CronExpressionProvider;
import com.intellij.cron.CronUtilsKt;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J+\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/cron/CronFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "psiElement", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "getPlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "isCollapsedByDefault", "intellij.cron"})
public final class CronFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement psiElement, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        CronExpressionProvider cronExpressionProvider = CronUtilsKt.getCronExpressionProvider(psiElement);
        if (project2.isDisposed() || cronExpressionProvider == null || !cronExpressionProvider.getSettings().isFoldingEnabled() || CronUtilsKt.getCronExplanation(psiElement) == null || psiElement.getTextRange().isEmpty()) {
            return new FoldingDescriptor[0];
        }
        FoldingDescriptor[] foldingDescriptorArray = new FoldingDescriptor[]{new FoldingDescriptor(psiElement, psiElement.getTextRange())};
        return foldingDescriptorArray;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        return CronUtilsKt.getCronExplanation(psiElement);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement $this$isCollapsedByDefault_u24lambda_u240 = node.getPsi();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$isCollapsedByDefault_u24lambda_u240);
        Object object = CronUtilsKt.getCronExpressionProvider($this$isCollapsedByDefault_u24lambda_u240);
        return object != null && (object = object.getSettings()) != null ? object.isFoldingCollapsed() : false;
    }
}

