/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.raster.mapping.svg;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.CanvasProvider;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.core.canvas.TextMetrics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/TextMeasurer;", "", "canvas", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "(Lorg/jetbrains/letsPlot/core/canvas/Canvas;)V", "measureText", "Lorg/jetbrains/letsPlot/core/canvas/TextMetrics;", "text", "", "font", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "measureTextWidth", "", "Companion", "plot-raster"})
public final class TextMeasurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Canvas canvas;

    private TextMeasurer(Canvas canvas) {
        this.canvas = canvas;
    }

    public final float measureTextWidth(@NotNull String text, @NotNull Font font2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)font2, (String)"font");
        Context2d ctx = this.canvas.getContext2d();
        ctx.save();
        ctx.setFont(font2);
        double width = ctx.measureTextWidth(text);
        ctx.restore();
        return (float)width;
    }

    @NotNull
    public final TextMetrics measureText(@NotNull String text, @NotNull Font font2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)font2, (String)"font");
        Context2d ctx = this.canvas.getContext2d();
        ctx.save();
        ctx.setFont(font2);
        TextMetrics textMetrics = ctx.measureText(text);
        ctx.restore();
        return textMetrics;
    }

    public /* synthetic */ TextMeasurer(Canvas canvas, DefaultConstructorMarker $constructor_marker) {
        this(canvas);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/TextMeasurer$Companion;", "", "()V", "create", "Lorg/jetbrains/letsPlot/raster/mapping/svg/TextMeasurer;", "canvas", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "canvasProvider", "Lorg/jetbrains/letsPlot/core/canvas/CanvasProvider;", "plot-raster"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextMeasurer create(@NotNull CanvasProvider canvasProvider) {
            Intrinsics.checkNotNullParameter((Object)canvasProvider, (String)"canvasProvider");
            return new TextMeasurer(canvasProvider.createCanvas(new Vector(0, 0)), null);
        }

        @NotNull
        public final TextMeasurer create(@NotNull Canvas canvas) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            return new TextMeasurer(canvas, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

