/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.ui;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.DrawModifierKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.DisabledAppearanceValues;
import org.jetbrains.jewel.foundation.DisabledAppearanceValuesKt;
import org.jetbrains.skia.ImageFilter;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.RuntimeEffect;
import org.jetbrains.skia.RuntimeShaderBuilder;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a/\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\u0006\"\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"disabledAppearance", "Landroidx/compose/ui/Modifier;", "brightness", "", "contrast", "alpha", "(Landroidx/compose/ui/Modifier;IIILandroidx/compose/runtime/Composer;II)Landroidx/compose/ui/Modifier;", "GRAY_FILTER_SKSL_FOR_IMAGEFILTER", "", "intellij.platform.jewel.ui"})
@SourceDebugExtension(value={"SMAP\nDisabledAppearance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisabledAppearance.kt\norg/jetbrains/jewel/ui/DisabledAppearanceKt\n+ 2 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 4 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 5 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 6 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 7 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,133:1\n75#2:134\n75#2:135\n75#2:136\n1136#3,6:137\n1136#3,6:143\n1136#3,6:149\n233#4:155\n57#5:156\n61#5:159\n60#6:157\n70#6:160\n22#7:158\n*S KotlinDebug\n*F\n+ 1 DisabledAppearance.kt\norg/jetbrains/jewel/ui/DisabledAppearanceKt\n*L\n57#1:134\n58#1:135\n59#1:136\n61#1:137,6\n62#1:143,6\n64#1:149,6\n65#1:155\n82#1:156\n82#1:159\n82#1:157\n82#1:160\n82#1:158\n*E\n"})
public final class DisabledAppearanceKt {
    @Language(value="GLSL")
    @NotNull
    private static final String GRAY_FILTER_SKSL_FOR_IMAGEFILTER = "\n    uniform shader content;\n    uniform float brightness;\n    uniform float contrast;\n    uniform float alphaScale;\n\n    vec4 main(vec2 fragCoord) {\n        vec4 color = content.eval(fragCoord);\n        if (color.a > 0) {\n            color.rgb /= color.a;\n        }\n\n        float gray = dot(color.rgb, vec3(0.30, 0.59, 0.11));\n\n        if (brightness >= 0) {\n            gray = (gray + brightness) / (1.0 + brightness);\n        } else {\n            gray = gray / (1.0 - brightness);\n        }\n\n        float midGray = 0.5;\n        if (contrast >= 0) {\n            if (gray >= midGray) {\n                gray = gray + (1.0 - gray) * contrast;\n            } else {\n                gray = gray - gray * contrast;\n            }\n        } else {\n            gray = midGray + (gray - midGray) * (contrast + 1.0);\n        }\n\n        gray = clamp(gray, 0.0, 1.0);\n\n        float newAlpha = color.a * alphaScale;\n        return vec4(vec3(gray) * newAlpha, newAlpha);\n    }\n";

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public static final Modifier disabledAppearance(@NotNull Modifier $this$disabledAppearance, int brightness, int contrast, int alpha, @Nullable Composer $composer, int $changed, int n) {
        Object object;
        void $this$cache$iv;
        Object object2;
        void $this$cache$iv2;
        Object object3;
        void $this$cache$iv3;
        Object object4;
        CompositionLocal this_$iv;
        Composer $composer$iv;
        boolean $i$f$getCurrent;
        boolean $changed$iv;
        Intrinsics.checkNotNullParameter((Object)$this$disabledAppearance, (String)"<this>");
        if ((n & 1) != 0) {
            CompositionLocal compositionLocal = (CompositionLocal)DisabledAppearanceValuesKt.getLocalDisabledAppearanceValues();
            Composer composer = $composer;
            $changed$iv = false;
            $i$f$getCurrent = false;
            ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
            object4 = $composer$iv.consume(this_$iv);
            ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
            brightness = ((DisabledAppearanceValues)object4).getBrightness();
        }
        if ((n & 2) != 0) {
            this_$iv = (CompositionLocal)DisabledAppearanceValuesKt.getLocalDisabledAppearanceValues();
            $composer$iv = $composer;
            $changed$iv = false;
            $i$f$getCurrent = false;
            ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
            object4 = $composer$iv.consume(this_$iv);
            ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
            contrast = ((DisabledAppearanceValues)object4).getContrast();
        }
        if ((n & 4) != 0) {
            this_$iv = (CompositionLocal)DisabledAppearanceValuesKt.getLocalDisabledAppearanceValues();
            $composer$iv = $composer;
            $changed$iv = false;
            $i$f$getCurrent = false;
            ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
            object4 = $composer$iv.consume(this_$iv);
            ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
            alpha = ((DisabledAppearanceValues)object4).getAlpha();
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)1659728846, (int)$changed, (int)-1, (String)"org.jetbrains.jewel.ui.disabledAppearance (DisabledAppearance.kt:59)");
        }
        $composer$iv = $composer;
        $changed$iv = false;
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv3.rememberedValue();
        boolean bl = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            boolean bl2 = false;
            RuntimeEffect value$iv = RuntimeEffect.Companion.makeForShader(GRAY_FILTER_SKSL_FOR_IMAGEFILTER);
            $this$cache$iv3.updateRememberedValue((Object)value$iv);
            object3 = value$iv;
        } else {
            object3 = it$iv;
        }
        RuntimeEffect effect = (RuntimeEffect)object3;
        Composer invalid$iv = $composer;
        $i$f$cache = false;
        boolean $i$f$cache2 = false;
        Object it$iv2 = $this$cache$iv2.rememberedValue();
        $i$a$-let-ComposerKt$cache$1$iv = false;
        if (it$iv2 == Composer.Companion.getEmpty()) {
            boolean bl3 = false;
            Paint value$iv = new Paint();
            $this$cache$iv2.updateRememberedValue((Object)value$iv);
            object2 = value$iv;
        } else {
            object2 = it$iv2;
        }
        Paint paint = (Paint)object2;
        Modifier modifier = $this$disabledAppearance;
        Composer invalid$iv2 = $composer;
        boolean invalid$iv3 = $composer.changedInstance((Object)effect) | (($changed & 0x70 ^ 0x30) > 32 && $composer.changed(brightness) || ($changed & 0x30) == 32) | (($changed & 0x380 ^ 0x180) > 256 && $composer.changed(contrast) || ($changed & 0x180) == 256) | (($changed & 0x1C00 ^ 0xC00) > 2048 && $composer.changed(alpha) || ($changed & 0xC00) == 2048) | $composer.changedInstance((Object)paint);
        boolean $i$f$cache3 = false;
        Object it$iv3 = $this$cache$iv.rememberedValue();
        $i$a$-let-ComposerKt$cache$1$iv = false;
        if (invalid$iv3 || it$iv3 == Composer.Companion.getEmpty()) {
            Modifier modifier2 = modifier;
            boolean bl4 = false;
            modifier = modifier2;
            Function1 value$iv = arg_0 -> DisabledAppearanceKt.disabledAppearance$lambda$2$0(effect, paint, brightness, contrast, alpha, arg_0);
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv3;
        }
        Modifier modifier3 = DrawModifierKt.drawWithContent((Modifier)modifier, (Function1)((Function1)object));
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        return modifier3;
    }

    private static final Unit disabledAppearance$lambda$2$0(RuntimeEffect $effect, Paint $paint, int $brightness, int $contrast, int $alpha, ContentDrawScope $this$drawWithContent) {
        RuntimeShaderBuilder runtimeShaderBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$drawWithContent, (String)"$this$drawWithContent");
        DrawScope $this$drawIntoCanvas$iv = (DrawScope)$this$drawWithContent;
        boolean $i$f$drawIntoCanvas = false;
        Canvas canvas = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
        boolean bl = false;
        RuntimeShaderBuilder $this$disabledAppearance_u24lambda_u242_u240_u240_u240 = runtimeShaderBuilder = new RuntimeShaderBuilder($effect);
        boolean bl2 = false;
        float brightnessFloat = (float)(Math.pow($brightness, 3) / 10000.0);
        float contrastFloat = (float)$contrast / 100.0f;
        float alphaScale = (float)$alpha / 100.0f;
        $this$disabledAppearance_u24lambda_u242_u240_u240_u240.uniform("brightness", brightnessFloat);
        $this$disabledAppearance_u24lambda_u242_u240_u240_u240.uniform("contrast", contrastFloat);
        $this$disabledAppearance_u24lambda_u242_u240_u240_u240.uniform("alphaScale", alphaScale);
        RuntimeShaderBuilder builder = runtimeShaderBuilder;
        $paint.setImageFilter(ImageFilter.Companion.makeRuntimeShader(builder, "content", null));
        long l = $this$drawWithContent.getSize-NH-jbRc();
        boolean bl3 = false;
        long value$iv$iv = l;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv);
        l = $this$drawWithContent.getSize-NH-jbRc();
        boolean bl4 = false;
        value$iv$iv = l;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        Rect skiaRect = Rect.Companion.makeWH(f, Float.intBitsToFloat(bits$iv$iv$iv));
        SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas).saveLayer(skiaRect, $paint);
        $this$drawWithContent.drawContent();
        SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas).restore();
        return Unit.INSTANCE;
    }
}

