/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.reference.provider;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jpa.jpb.model.complition.ClassPropertyCompletionHelper;
import com.intellij.jpa.jpb.model.complition.JpbLookupElements;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.NamingUtil;
import com.intellij.jpa.jpb.model.util.SearchHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityPropertyPathReference
extends PsiReferenceBase<XmlAttributeValue>
implements EmptyResolveMessageProvider {
    public static final EntityPropertyPathReference[] EMPTY_ARRAY = new EntityPropertyPathReference[0];
    private final String entityClassName;
    private final String propertyPath;
    private final int propertyIndex;
    private final CollectionStrategy collectionProperty;

    public EntityPropertyPathReference(String entityClassName, @Nullable String propertyPath, int index, TextRange textRange, XmlAttributeValue element, boolean soft, CollectionStrategy collectionStrategy) {
        super((PsiElement)element, textRange, soft);
        this.entityClassName = entityClassName;
        this.propertyPath = propertyPath;
        this.propertyIndex = index;
        this.collectionProperty = collectionStrategy;
    }

    public static EntityPropertyPathReference[] createArray(PsiClass entityClass, String propertyPath, XmlAttributeValue element, boolean soft, CollectionStrategy collectionStrategy) {
        return EntityPropertyPathReference.createArray(entityClass.getQualifiedName(), propertyPath, element, soft, collectionStrategy);
    }

    public static EntityPropertyPathReference[] createArray(String entityQname, String propertyPath, XmlAttributeValue element, boolean soft, CollectionStrategy collectionStrategy) {
        int newPos;
        ArrayList<EntityPropertyPathReference> references = new ArrayList<EntityPropertyPathReference>();
        if (StringUtils.isEmpty((CharSequence)propertyPath)) {
            references.add(new EntityPropertyPathReference(entityQname, propertyPath, 0, new TextRange(0, 0), element, soft, collectionStrategy));
            return references.toArray(EMPTY_ARRAY);
        }
        int pos = -1;
        int level = 0;
        do {
            newPos = propertyPath.indexOf(46, pos + 1);
            TextRange textRange = null;
            if (newPos - 1 >= pos + 1) {
                textRange = new TextRange(pos + 2, newPos + 1);
            } else if (newPos == -1) {
                textRange = new TextRange(pos + 2, propertyPath.length() + 1);
            }
            if (textRange != null) {
                EntityPropertyPathReference ref = new EntityPropertyPathReference(entityQname, propertyPath, level, textRange, element, soft, collectionStrategy);
                references.add(ref);
            }
            ++level;
        } while ((pos = newPos) >= 0);
        return references.toArray(EMPTY_ARRAY);
    }

    @Nullable
    public PsiElement resolve() {
        if (StringUtils.isEmpty((CharSequence)this.propertyPath)) {
            return null;
        }
        return this.resolveMember(this.propertyPath, this.entityClassName, this.propertyIndex);
    }

    private PsiMember resolveMember(String path, String entity, @Nullable Integer indexToStop) {
        Project project = ((XmlAttributeValue)this.myElement).getProject();
        SearchHelper searchHelper = SearchHelper.getInstance(project);
        String[] properties = path.split("\\.");
        if (properties.length == 0) {
            return null;
        }
        PsiClass currentClass = searchHelper.findClass(entity);
        PsiMember member = null;
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            if (currentClass == null) {
                return null;
            }
            member = EntityUtil.getProperty(currentClass, property);
            if (indexToStop != null && i == indexToStop) {
                return member;
            }
            String className = EntityUtil.getPropertyTypeName(currentClass, property);
            if (className == null) {
                return null;
            }
            if (i >= properties.length - 1) continue;
            PsiClass _class = searchHelper.findClass(className);
            if (_class == null) {
                return null;
            }
            currentClass = _class;
        }
        return indexToStop != null ? null : member;
    }

    @NotNull
    public @NotNull Object @NotNull [] getVariants() {
        SearchHelper searchHelper;
        PsiClass psiClass;
        String resolvedClassName;
        PsiMember member;
        String prefix = ((XmlAttributeValue)this.myElement).getValue();
        String pathStart = EntityPropertyPathReference.extractPathStart(prefix);
        String entityForVariants = this.entityClassName;
        if (pathStart != null && (member = this.resolveMember(pathStart, this.entityClassName, null)) != null && (resolvedClassName = EntityUtil.getPropertyTypeName(member)) != null) {
            entityForVariants = resolvedClassName;
        }
        if ((psiClass = (searchHelper = SearchHelper.getInstance(((XmlAttributeValue)this.myElement).getProject())).findClass(entityForVariants)) != null) {
            Object[] objectArray = ArrayUtil.toObjectArray(this.collectVariants(psiClass));
            if (objectArray == null) {
                EntityPropertyPathReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            EntityPropertyPathReference.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String shortClassName = NamingUtil.getShortClassName(this.entityClassName);
        String string = JpaModelBundle.message("EntityPropertyPathReference.inspection.unresolvedMessagePattern", this.propertyPath, shortClassName);
        if (string == null) {
            EntityPropertyPathReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    private List<Object> collectVariants(PsiClass resolvedClass) {
        ArrayList<Object> variants = new ArrayList<Object>();
        List<PsiField> fields = this.collectFields(resolvedClass);
        for (PsiField field : fields) {
            String typeText = ClassPropertyCompletionHelper.getFieldType((PsiMember)field);
            LookupElementBuilder element = JpbLookupElements.element(field.getName(), typeText);
            variants.add(element);
        }
        return variants;
    }

    @Nullable
    private static String extractPathStart(String prefix) {
        int pos = prefix.lastIndexOf(46);
        return pos < 0 ? null : prefix.substring(0, pos);
    }

    private List<PsiField> collectFields(PsiClass _class) {
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        PsiClass parentClass = _class.getSuperClass();
        if (parentClass != null) {
            result.addAll(this.collectFields(parentClass));
        }
        if (this.collectionProperty == CollectionStrategy.NO || this.collectionProperty == CollectionStrategy.ALL) {
            result.addAll(EntityUtil.getAnnotatedSingleFields(_class));
        }
        if (this.collectionProperty == CollectionStrategy.ONLY || this.collectionProperty == CollectionStrategy.ALL) {
            result.addAll(EntityUtil.getAnnotatedMultiFields(_class));
            result.addAll(EntityUtil.collectAllReferenceFields(_class));
        }
        return result;
    }

    public boolean isSoft() {
        return super.isSoft() || this.propertyPath.startsWith("+");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jpa/jpb/model/reference/provider/EntityPropertyPathReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum CollectionStrategy {
        NO,
        ONLY,
        ALL;

    }
}

