/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.TypeNullability;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.EmptySubstitutor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.UnmodifiableHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiSubstitutorImpl
implements PsiSubstitutor {
    private static final Logger LOG = Logger.getInstance(PsiSubstitutorImpl.class);
    static final HashingStrategy<PsiTypeParameter> PSI_EQUIVALENCE = new HashingStrategy<PsiTypeParameter>(){

        public int hashCode(PsiTypeParameter parameter) {
            return Comparing.hashcode((Object)parameter.getName());
        }

        public boolean equals(PsiTypeParameter element1, PsiTypeParameter element2) {
            if (element1 == element2) {
                return true;
            }
            if (element1 == null || element2 == null || element1 instanceof InferenceVariable || element2 instanceof InferenceVariable) {
                return false;
            }
            if (!Objects.equals(element1.getName(), element2.getName())) {
                return false;
            }
            if (element1.getIndex() != element2.getIndex()) {
                return false;
            }
            if (TypeConversionUtil.areSameFreshVariables(element1, element2)) {
                return true;
            }
            return element1.getManager().areElementsEquivalent((PsiElement)element1.getOwner(), (PsiElement)element2.getOwner());
        }
    };
    private static final UnmodifiableHashMap<PsiTypeParameter, PsiType> EMPTY_MAP = UnmodifiableHashMap.empty(PSI_EQUIVALENCE);
    @NotNull
    private final UnmodifiableHashMap<PsiTypeParameter, PsiType> mySubstitutionMap;

    PsiSubstitutorImpl(@NotNull Map<? extends PsiTypeParameter, ? extends PsiType> map2) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(0);
        }
        this.mySubstitutionMap = UnmodifiableHashMap.fromMap(PSI_EQUIVALENCE, map2);
    }

    private PsiSubstitutorImpl(@NotNull UnmodifiableHashMap<PsiTypeParameter, PsiType> map2, @NotNull PsiTypeParameter additionalKey, @Nullable PsiType additionalValue) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(1);
        }
        if (additionalKey == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(2);
        }
        this.mySubstitutionMap = map2.with((Object)additionalKey, (Object)additionalValue);
    }

    PsiSubstitutorImpl(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(3);
        }
        this.mySubstitutionMap = EMPTY_MAP.with((Object)typeParameter, (Object)mapping);
    }

    PsiSubstitutorImpl(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(4);
        }
        this((Map<? extends PsiTypeParameter, ? extends PsiType>)PsiSubstitutorImpl.putAllInternal(EMPTY_MAP, parentClass, mappings));
    }

    @Override
    public PsiType substitute(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(5);
        }
        PsiType type = this.getFromMap(typeParameter);
        return PsiTypes.voidType().equals(type) ? JavaPsiFacade.getElementFactory(typeParameter.getProject()).createType(typeParameter) : type;
    }

    @Override
    public boolean hasRawSubstitution() {
        return this.mySubstitutionMap.containsValue(null);
    }

    private PsiType getFromMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(6);
        }
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return (PsiType)this.mySubstitutionMap.getOrDefault((Object)typeParameter, (Object)PsiTypes.voidType());
    }

    @Override
    public PsiType substitute(@Nullable PsiType type) {
        return this.doSubstitute(type, false);
    }

    @Override
    public PsiType substituteIgnoringNullability(@Nullable PsiType type) {
        return this.doSubstitute(type, true);
    }

    @Nullable
    private PsiType doSubstitute(@Nullable PsiType type, boolean ignoreNullity) {
        if (type == null) {
            return null;
        }
        PsiUtil.ensureValidType(type);
        PsiType substituted = type.accept(new SubstitutionVisitor(ignoreNullity));
        return this.correctExternalSubstitution(substituted, type);
    }

    @Override
    public PsiType substituteWithBoundsPromotion(@NotNull PsiTypeParameter typeParameter) {
        PsiType substituted;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(7);
        }
        if ((substituted = this.substitute(typeParameter)) instanceof PsiWildcardType && !((PsiWildcardType)substituted).isSuper()) {
            PsiWildcardType wildcard;
            PsiWildcardType wildcardType = (PsiWildcardType)substituted;
            PsiType glb = PsiCapturedWildcardType.captureUpperBound(typeParameter, wildcardType, this);
            if (glb instanceof PsiWildcardType) {
                return glb;
            }
            if (glb instanceof PsiCapturedWildcardType && !(wildcard = ((PsiCapturedWildcardType)glb).getWildcard()).isSuper()) {
                return wildcard;
            }
            if (glb != null) {
                return PsiWildcardType.createExtends(typeParameter.getManager(), glb);
            }
        }
        return substituted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof PsiSubstitutorImpl && this.mySubstitutionMap.equals(((PsiSubstitutorImpl)o).mySubstitutionMap);
    }

    public int hashCode() {
        return this.mySubstitutionMap.hashCode();
    }

    private PsiType rawTypeForTypeParameter(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType[] extendsTypes;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(8);
        }
        if ((extendsTypes = typeParameter.getExtendsListTypes()).length > 0) {
            return (PsiType)RecursionManager.doPreventingRecursion((Object)extendsTypes[0], (boolean)true, () -> this.substitute(extendsTypes[0]));
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    private PsiType correctExternalSubstitution(PsiType substituted, @NotNull PsiType original) {
        if (original == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(9);
        }
        if (substituted != null) {
            return substituted;
        }
        return original.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new PsiArrayType(arrayType.getComponentType().accept(this));
            }

            @Override
            public PsiType visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
                if (ellipsisType == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new PsiEllipsisType(ellipsisType.getComponentType().accept(this));
            }

            @Override
            public PsiType visitClassType(@NotNull PsiClassType classType) {
                PsiClass aClass;
                if (classType == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((aClass = classType.resolve()) == null) {
                    return classType;
                }
                if (aClass instanceof PsiTypeParameter) {
                    return PsiSubstitutorImpl.this.rawTypeForTypeParameter((PsiTypeParameter)aClass);
                }
                return JavaPsiFacade.getElementFactory(aClass.getProject()).createType(aClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ellipsisType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/PsiSubstitutorImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitEllipsisType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected PsiSubstitutorImpl clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiSubstitutor put(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(10);
        }
        if (mapping != null && !mapping.isValid()) {
            LOG.error("Invalid type in substitutor: " + mapping + "; " + mapping.getClass());
        }
        return new PsiSubstitutorImpl(this.mySubstitutionMap, typeParameter, mapping);
    }

    @NotNull
    private static UnmodifiableHashMap<PsiTypeParameter, PsiType> putAllInternal(@NotNull UnmodifiableHashMap<PsiTypeParameter, PsiType> originalMap, @NotNull PsiClass parentClass, PsiType[] mappings) {
        PsiTypeParameter[] params;
        if (originalMap == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(11);
        }
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(12);
        }
        if ((params = parentClass.getTypeParameters()).length == 0) {
            UnmodifiableHashMap unmodifiableHashMap = originalMap;
            if (unmodifiableHashMap == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(13);
            }
            return unmodifiableHashMap;
        }
        UnmodifiableHashMap newMap = originalMap;
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            assert (param != null);
            if (mappings != null && mappings.length > i) {
                PsiType mapping = mappings[i];
                newMap = newMap.with((Object)param, (Object)mapping);
                if (mapping == null || mapping.isValid()) continue;
                LOG.error("Invalid type in substitutor: " + mapping);
                continue;
            }
            newMap = newMap.with((Object)param, null);
        }
        UnmodifiableHashMap unmodifiableHashMap = newMap;
        if (unmodifiableHashMap == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(14);
        }
        return unmodifiableHashMap;
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(15);
        }
        return new PsiSubstitutorImpl((Map<? extends PsiTypeParameter, ? extends PsiType>)PsiSubstitutorImpl.putAllInternal(this.mySubstitutionMap, parentClass, mappings));
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiSubstitutor another) {
        if (another == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(16);
        }
        if (another instanceof EmptySubstitutor) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(17);
            }
            return psiSubstitutorImpl;
        }
        PsiSubstitutorImpl anotherImpl = (PsiSubstitutorImpl)another;
        PsiSubstitutor psiSubstitutor = this.putAll((Map<? extends PsiTypeParameter, ? extends PsiType>)anotherImpl.mySubstitutionMap);
        if (psiSubstitutor == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(18);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull Map<? extends PsiTypeParameter, ? extends PsiType> map2) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(19);
        }
        if (map2.isEmpty()) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(20);
            }
            return psiSubstitutorImpl;
        }
        return new PsiSubstitutorImpl((Map<? extends PsiTypeParameter, ? extends PsiType>)this.mySubstitutionMap.withAll(map2));
    }

    public String toString() {
        @NonNls StringBuilder buffer = new StringBuilder();
        Set set = this.mySubstitutionMap.entrySet();
        for (Map.Entry entry : set) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)entry.getKey();
            buffer.append(typeParameter.getName());
            PsiTypeParameterListOwner owner = typeParameter.getOwner();
            if (owner instanceof PsiClass) {
                buffer.append(" of ");
                buffer.append(((PsiClass)owner).getQualifiedName());
            } else if (owner instanceof PsiMethod) {
                buffer.append(" of ");
                buffer.append(((PsiMethod)owner).getName());
                buffer.append(" in ");
                PsiClass aClass = ((PsiMethod)owner).getContainingClass();
                buffer.append(aClass != null ? aClass.getQualifiedName() : "<no class>");
            }
            buffer.append(" -> ");
            if (entry.getValue() != null) {
                buffer.append(((PsiType)entry.getValue()).getCanonicalText());
            } else {
                buffer.append("null");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    @Override
    public boolean isValid() {
        for (Map.Entry entry : this.mySubstitutionMap.entrySet()) {
            if (!((PsiTypeParameter)entry.getKey()).isValid()) {
                return false;
            }
            PsiType type = (PsiType)entry.getValue();
            if (type == null || type.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureValid() {
        this.mySubstitutionMap.values().forEach(type -> {
            if (type != null) {
                PsiUtil.ensureValidType(type);
            }
        });
    }

    @Override
    @NotNull
    public Map<PsiTypeParameter, PsiType> getSubstitutionMap() {
        UnmodifiableHashMap<PsiTypeParameter, PsiType> unmodifiableHashMap = this.mySubstitutionMap;
        if (unmodifiableHashMap == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(21);
        }
        return unmodifiableHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalKey";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 4: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMap";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "putAllInternal";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "putAll";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFromMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithBoundsPromotion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "rawTypeForTypeParameter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "correctExternalSubstitution";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putAllInternal";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SubstitutionVisitor
    extends PsiTypeMapper {
        private final boolean ignoreNullity;

        private SubstitutionVisitor(boolean ignoreNullity) {
            this.ignoreNullity = ignoreNullity;
        }

        @Override
        public PsiType visitType(@NotNull PsiType type) {
            if (type == null) {
                SubstitutionVisitor.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public PsiType visitWildcardType(@NotNull PsiWildcardType wildcardType) {
            PsiType bound;
            if (wildcardType == null) {
                SubstitutionVisitor.$$$reportNull$$$0(1);
            }
            if ((bound = wildcardType.getBound()) == null) {
                return wildcardType;
            }
            PsiType newBound = bound.accept(this);
            if (newBound == null) {
                return null;
            }
            assert (newBound.isValid()) : newBound.getClass() + "; " + bound.isValid();
            if (newBound instanceof PsiWildcardType) {
                PsiType newBoundBound = ((PsiWildcardType)newBound).getBound();
                return !((PsiWildcardType)newBound).isBounded() ? PsiWildcardType.createUnbounded(wildcardType.getManager()) : this.rebound(wildcardType, newBoundBound);
            }
            return newBound == PsiTypes.nullType() ? newBound : this.rebound(wildcardType, newBound);
        }

        @NotNull
        private PsiWildcardType rebound(@NotNull PsiWildcardType type, @NotNull PsiType newBound) {
            if (type == null) {
                SubstitutionVisitor.$$$reportNull$$$0(2);
            }
            if (newBound == null) {
                SubstitutionVisitor.$$$reportNull$$$0(3);
            }
            LOG.assertTrue(type.getBound() != null);
            LOG.assertTrue(newBound.isValid());
            if (type.isExtends()) {
                if (newBound.equalsToText("java.lang.Object")) {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded(type.getManager());
                    if (psiWildcardType == null) {
                        SubstitutionVisitor.$$$reportNull$$$0(4);
                    }
                    return psiWildcardType;
                }
                PsiWildcardType psiWildcardType = PsiWildcardType.createExtends(type.getManager(), newBound);
                if (psiWildcardType == null) {
                    SubstitutionVisitor.$$$reportNull$$$0(5);
                }
                return psiWildcardType;
            }
            PsiWildcardType psiWildcardType = PsiWildcardType.createSuper(type.getManager(), newBound);
            if (psiWildcardType == null) {
                SubstitutionVisitor.$$$reportNull$$$0(6);
            }
            return psiWildcardType;
        }

        @Override
        public PsiType visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (classType == null) {
                SubstitutionVisitor.$$$reportNull$$$0(7);
            }
            if ((aClass = (resolveResult = classType.resolveGenerics()).getElement()) == null) {
                return classType;
            }
            PsiUtilCore.ensureValid((PsiElement)aClass);
            if (aClass instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                PsiType result = PsiSubstitutorImpl.this.getFromMap(typeParameter);
                if (PsiTypes.voidType().equals(result)) {
                    return classType;
                }
                if (result == null || this.ignoreNullity) {
                    return result;
                }
                TypeNullability origNullability = classType.getNullability();
                return origNullability.equals(TypeNullability.UNKNOWN) ? result : result.withNullability(origNullability.instantiatedWith(result.getNullability()));
            }
            PsiSubstitutor resultSubstitutor = this.processClass(aClass, resolveResult.getSubstitutor());
            return new PsiImmediateClassType(aClass, resultSubstitutor, classType.getLanguageLevel(), classType.getAnnotationProvider(), classType.getPsiContext());
        }

        @NotNull
        private PsiSubstitutor processClass(@NotNull PsiClass resolve, @NotNull PsiSubstitutor originalSubstitutor) {
            if (resolve == null) {
                SubstitutionVisitor.$$$reportNull$$$0(8);
            }
            if (originalSubstitutor == null) {
                SubstitutionVisitor.$$$reportNull$$$0(9);
            }
            UnmodifiableHashMap substMap = EMPTY_MAP;
            while (true) {
                PsiClass containingClass;
                PsiTypeParameter[] params;
                for (PsiTypeParameter param : params = resolve.getTypeParameters()) {
                    PsiType original = originalSubstitutor.substitute(param);
                    PsiType mapping = original == null ? null : original.accept(this);
                    substMap = substMap.with((Object)param, (Object)mapping);
                }
                PsiClass psiClass = containingClass = resolve.hasModifierProperty("static") ? null : resolve.getContainingClass();
                if (containingClass == null) break;
                resolve = containingClass;
            }
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.createSubstitutor((Map<? extends PsiTypeParameter, ? extends PsiType>)substMap);
            if (psiSubstitutor == null) {
                SubstitutionVisitor.$$$reportNull$$$0(10);
            }
            return psiSubstitutor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wildcardType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBound";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolve";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalSubstitutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rebound";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitType";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWildcardType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "rebound";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassType";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "processClass";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

