/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSStringUtil;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSLiteralExpression;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class MongoExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @NotNull
    protected String generateSelectStatement(@NotNull String text, @NotNull SqlElement sqlElement) {
        if (text == null) {
            MongoExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        if (sqlElement == null) {
            MongoExecutionEnvironmentHelper.$$$reportNull$$$0(1);
        }
        String string = text;
        if (string == null) {
            MongoExecutionEnvironmentHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public @Unmodifiable List<RowSortOrder<String>> getOrderByElements(@NotNull PsiFile fileWithOrderBy) {
        ASTNode argumentList;
        if (fileWithOrderBy == null) {
            MongoExecutionEnvironmentHelper.$$$reportNull$$$0(3);
        }
        ASTNode object = (argumentList = fileWithOrderBy.getNode().findChildByType(JSElementTypes.ARGUMENT_LIST)) == null ? null : argumentList.findChildByType((IElementType)JSElementTypes.OBJECT_LITERAL_EXPRESSION);
        Object[] properties = object == null ? ASTNode.EMPTY_ARRAY : object.getChildren(TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.PROPERTY}));
        List list = ContainerUtil.mapNotNull((Object[])properties, property -> {
            PsiElement colonPsi;
            ASTNode colon = property.findChildByType(JSElementTypes.COLON);
            PsiElement psiElement = colonPsi = colon == null ? null : colon.getPsi();
            if (colonPsi == null) {
                return null;
            }
            PsiElement nameElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)colonPsi);
            PsiElement value = (PsiElement)JBIterable.generate((Object)colonPsi, el -> el.getNextSibling()).find(el -> el instanceof MongoJSLiteralExpression || el.getNode().getElementType() == JSElementTypes.PREFIX_EXPRESSION);
            if (value == null || nameElement == null) {
                return null;
            }
            String name2 = MongoExecutionEnvironmentHelper.getDecodedText(nameElement);
            return "1".equals(value.getText()) ? RowSortOrder.asc((Object)name2) : ("-1".equals(value.getText()) ? RowSortOrder.desc((Object)name2) : null);
        });
        if (list == null) {
            MongoExecutionEnvironmentHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static String getDecodedText(@NotNull PsiElement o) {
        if (o == null) {
            MongoExecutionEnvironmentHelper.$$$reportNull$$$0(5);
        }
        if (o.getNode().getElementType() != JSElementTypes.LITERAL_EXPRESSION || o.getText().length() < 2) {
            String string = o.getText();
            if (string == null) {
                MongoExecutionEnvironmentHelper.$$$reportNull$$$0(6);
            }
            return string;
        }
        PsiElement firstChild = o.getFirstChild();
        String string = firstChild != null && firstChild.getNode().getElementType() == JSElementTypes.STRING_LITERAL ? MongoJSStringUtil.unescapeSimpleStringChars(o.getText().substring(1, o.getText().length() - 1)) : o.getText();
        if (string == null) {
            MongoExecutionEnvironmentHelper.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getKeepAliveQuery(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            MongoExecutionEnvironmentHelper.$$$reportNull$$$0(8);
        }
        if (dataSource == null) {
            MongoExecutionEnvironmentHelper.$$$reportNull$$$0(9);
        }
        return "db.runCommand({ping: 1});";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlElement";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mongo/MongoExecutionEnvironmentHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithOrderBy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mongo/MongoExecutionEnvironmentHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderByElements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecodedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateSelectStatement";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrderByElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDecodedText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getKeepAliveQuery";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

