/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.util.NlsSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/CloudDataSourceInfo;", "", "connectionDataId", "", "cloudInternalMetadata", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getConnectionDataId", "()Ljava/lang/String;", "getCloudInternalMetadata", "Companion", "intellij.database.core.impl"})
public final class CloudDataSourceInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String connectionDataId;
    @NotNull
    private final String cloudInternalMetadata;

    public CloudDataSourceInfo(@NotNull String connectionDataId, @NlsSafe @NotNull String cloudInternalMetadata) {
        Intrinsics.checkNotNullParameter((Object)connectionDataId, (String)"connectionDataId");
        Intrinsics.checkNotNullParameter((Object)cloudInternalMetadata, (String)"cloudInternalMetadata");
        this.connectionDataId = connectionDataId;
        this.cloudInternalMetadata = cloudInternalMetadata;
    }

    @NotNull
    public final String getConnectionDataId() {
        return this.connectionDataId;
    }

    @NotNull
    public final String getCloudInternalMetadata() {
        return this.cloudInternalMetadata;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/CloudDataSourceInfo$Companion;", "", "<init>", "()V", "saveCloudInfo", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "info", "Lcom/intellij/database/dataSource/CloudDataSourceInfo;", "getCloudInfo", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void saveCloudInfo(@NotNull LocalDataSource dataSource, @NotNull CloudDataSourceInfo info) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            dataSource.setAdditionalProperty("cloud.explorer.connection.data.id", info.getConnectionDataId());
            dataSource.setAdditionalProperty("cloud.explorer.internal.metadata", info.getCloudInternalMetadata());
        }

        @Nullable
        public final CloudDataSourceInfo getCloudInfo(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            String string = dataSource.getAdditionalProperty("cloud.explorer.connection.data.id");
            if (string == null) {
                return null;
            }
            String connectionDataId = string;
            String string2 = dataSource.getAdditionalProperty("cloud.explorer.internal.metadata");
            if (string2 == null) {
                return null;
            }
            String cloudInternalMetadata = string2;
            return new CloudDataSourceInfo(connectionDataId, cloudInternalMetadata);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

