/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.actions.generate.SpringTemplateBuilder;
import com.intellij.spring.model.converters.SpringBeanFactoryMethodConverter;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.highlighting.xml.ResolvedConstructorArgsMessageBuilder;
import com.intellij.spring.model.highlighting.xml.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.actions.generate.AbstractDomGenerateProvider;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringConstructorArgInspection
extends SpringBeanInspectionBase {
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        PsiClass beanClass;
        if (springBean == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(2);
        }
        if ((beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType())) != null) {
            SpringConstructorArgInspection.checkConstructorArgType(springBean, holder);
        }
        SpringConstructorArgInspection.checkConstructorResolve(springBean, holder, beanClass);
        SpringConstructorArgInspection.checkConstructorArgIndexes(springBean, holder);
    }

    private static void checkConstructorResolve(@NotNull SpringBean springBean, DomElementAnnotationHolder holder, @Nullable PsiClass beanClass) {
        if (springBean == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(3);
        }
        if (springBean.isAbstract()) {
            return;
        }
        boolean instantiatedByFactory = SpringConstructorArgInspection.isInstantiatedByFactory(springBean);
        if (!instantiatedByFactory && beanClass == null) {
            return;
        }
        ResolvedConstructorArgs resolvedArgs = springBean.getResolvedConstructorArgs();
        if (!resolvedArgs.isResolved()) {
            String basicMessage = instantiatedByFactory ? SpringBundle.message("cannot.find.factory.method.with.parameters.count", new Object[0]) : SpringBundle.message("cannot.find.bean.constructor.with.parameters.count", beanClass.getName());
            ResolvedConstructorArgsMessageBuilder messageBuilder = new ResolvedConstructorArgsMessageBuilder(basicMessage, SpringConstructorArgInspection.getConstructors(instantiatedByFactory, beanClass, springBean), resolvedArgs);
            @NlsSafe String message = messageBuilder.getMessage();
            Object element = !instantiatedByFactory && DomUtil.hasXml((DomElement)springBean.getClazz()) ? springBean.getClazz() : (instantiatedByFactory && DomUtil.hasXml((DomElement)springBean.getFactoryMethod()) ? springBean.getFactoryMethod() : springBean);
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            SpringBean stableCopy = (SpringBean)springBean.createStableCopy();
            if (!instantiatedByFactory && !(beanClass instanceof PsiCompiledElement)) {
                fixes.addAll(SpringConstructorArgInspection.createConstructorFixes(stableCopy, beanClass));
            }
            fixes.addAll(SpringConstructorArgInspection.getConstructorArgsQuickFixes(stableCopy, springBean.getInstantiationMethods()));
            holder.createProblem((DomElement)element, HighlightSeverity.ERROR, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static PsiMethod @NotNull [] getConstructors(boolean factory, @Nullable PsiClass aClass, @NotNull SpringBean bean) {
        if (bean == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(4);
        }
        if (factory) {
            String factoryMethod = bean.getFactoryMethod().getStringValue();
            if (StringUtil.isNotEmpty((String)factoryMethod) && bean instanceof AbstractDomSpringBean) {
                AbstractDomSpringBean domSpringBean = (AbstractDomSpringBean)bean;
                List methodCandidates = SpringBeanFactoryMethodConverter.getFactoryMethodCandidates((AbstractDomSpringBean)domSpringBean, (String)factoryMethod);
                PsiMethod[] psiMethodArray = methodCandidates.toArray(PsiMethod.EMPTY_ARRAY);
                if (psiMethodArray == null) {
                    SpringConstructorArgInspection.$$$reportNull$$$0(5);
                }
                return psiMethodArray;
            }
        } else if (aClass != null) {
            PsiMethod[] psiMethodArray = aClass.getConstructors();
            if (psiMethodArray == null) {
                SpringConstructorArgInspection.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(7);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    private static boolean isInstantiatedByFactory(SpringBean springBean) {
        return DomUtil.hasXml((DomElement)springBean.getFactoryMethod());
    }

    private static void checkConstructorArgType(SpringBean springBean, DomElementAnnotationHolder holder) {
        List list = springBean.getConstructorArgs();
        if (list.isEmpty()) {
            return;
        }
        List instantiationMethods = springBean.getInstantiationMethods();
        block0: for (ConstructorArg arg : list) {
            PsiType argType = (PsiType)arg.getType().getValue();
            if (argType == null) continue;
            Integer index = (Integer)arg.getIndex().getValue();
            boolean parameterFound = false;
            if (index != null) {
                int i = index;
                if (i < 0) continue;
                for (PsiMethod method : instantiationMethods) {
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (i >= parameters.length) continue;
                    parameterFound = true;
                    if (!parameters[i].getType().isAssignableFrom(argType)) continue;
                    continue block0;
                }
            } else {
                for (PsiMethod method : instantiationMethods) {
                    PsiParameter[] parameters;
                    for (PsiParameter param : parameters = method.getParameterList().getParameters()) {
                        if (param.getType().isAssignableFrom(argType)) continue block0;
                    }
                }
            }
            if (!parameterFound) continue;
            String message = SpringBundle.message("constructor.arg.incorrect.value.type", new Object[0]);
            holder.createProblem((DomElement)arg.getType(), message, new LocalQuickFix[0]);
        }
    }

    private static void checkConstructorArgIndexes(SpringBean springBean, DomElementAnnotationHolder holder) {
        List list = springBean.getConstructorArgs();
        if (list.isEmpty()) {
            return;
        }
        HashMap<Integer, ConstructorArg> argsMap = new HashMap<Integer, ConstructorArg>();
        SmartList firstSeen = new SmartList();
        for (ConstructorArg arg : list) {
            ConstructorArg previous;
            Integer index = (Integer)arg.getIndex().getValue();
            if (index == null || (previous = argsMap.put(index, arg)) == null) continue;
            SpringConstructorArgInspection.reportNotUniqueIndex(holder, arg);
            if (firstSeen.contains(previous)) continue;
            SpringConstructorArgInspection.reportNotUniqueIndex(holder, previous);
            firstSeen.add(previous);
        }
    }

    private static void reportNotUniqueIndex(DomElementAnnotationHolder holder, ConstructorArg arg) {
        String message = SpringBundle.message("incorrect.constructor.arg.index.not.unique", new Object[0]);
        holder.createProblem((DomElement)arg.getIndex(), message, new LocalQuickFix[0]);
    }

    private static List<LocalQuickFix> createConstructorFixes(SpringBean springBean, @NotNull PsiClass beanClass) {
        if (beanClass == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(8);
        }
        return IntentionWrapper.wrapToQuickFixes(SpringConstructorArgInspection.createConstructorActions(springBean, beanClass), (PsiFile)beanClass.getContainingFile());
    }

    private static List<IntentionAction> createConstructorActions(SpringBean springBean, @NotNull PsiClass beanClass) {
        if (beanClass == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(9);
        }
        Project project = springBean.getManager().getProject();
        List<Pair<String, PsiType>> params = SpringConstructorArgResolveUtil.suggestConstructorParamsForBean(springBean);
        CreateConstructorRequest request = MethodRequestsKt.constructorRequest((Project)project, params);
        return JvmElementActionFactories.createConstructorActions((JvmClass)beanClass, (CreateConstructorRequest)request);
    }

    private static List<LocalQuickFix> getConstructorArgsQuickFixes(@NotNull SpringBean springBean, @NotNull List<PsiMethod> ctors) {
        if (springBean == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(10);
        }
        if (ctors == null) {
            SpringConstructorArgInspection.$$$reportNull$$$0(11);
        }
        if (!springBean.getConstructorArgs().isEmpty() || !springBean.getCNamespaceConstructorArgDefinitions().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
        for (PsiMethod ctor : ctors) {
            if (ctor.getParameterList().getParametersCount() <= 0) continue;
            quickFixes.add(new AddConstructorArgQuickFix(ctor, springBean));
        }
        return quickFixes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringConstructorArgInspection";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringConstructorArgInspection";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkBean";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorResolve";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConstructors";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorFixes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorActions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorArgsQuickFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static class AddConstructorArgQuickFix
    implements LocalQuickFix {
        private final SpringBean mySpringBean;
        private final String myMethodName;
        private final SmartPsiElementPointer<PsiMethod> myCtorPointer;

        public AddConstructorArgQuickFix(PsiMethod ctor, SpringBean springBean) {
            this.myCtorPointer = SmartPointerManager.getInstance((Project)ctor.getProject()).createSmartPsiElementPointer((PsiElement)ctor);
            this.mySpringBean = springBean;
            this.myMethodName = PsiFormatUtil.formatMethod((PsiMethod)ctor, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.add.constructor.args.for.method.quickfix.message", this.myMethodName);
            if (string == null) {
                AddConstructorArgQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("model.add.constructor.args.for.method.quickfix.message.family.name", new Object[0]);
            if (string == null) {
                AddConstructorArgQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethod ctor;
            if (project == null) {
                AddConstructorArgQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddConstructorArgQuickFix.$$$reportNull$$$0(3);
            }
            if ((ctor = (PsiMethod)this.myCtorPointer.getElement()) == null || !ctor.isValid()) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(this.mySpringBean.getContainingFile())) {
                return;
            }
            PsiMethod[] myAllCtors = ctor.getContainingClass().getConstructors();
            PsiParameter[] parameters = ctor.getParameterList().getParameters();
            CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)this.mySpringBean);
            SpringTemplateBuilder builder = new SpringTemplateBuilder(project);
            Editor editor = SpringTemplateBuilder.getEditor(descriptor);
            SpringTemplateBuilder.preparePlace(editor, project, (DomElement)this.mySpringBean.addConstructorArg());
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                builder.addTextSegment("<");
                builder.addVariableSegment("NS_PREFIX");
                builder.addTextSegment("constructor-arg");
                if (parameters.length > 1) {
                    builder.addTextSegment(" index=\"" + i + "\"");
                }
                for (PsiMethod allCtor : myAllCtors) {
                    PsiParameter[] params;
                    if (allCtor == ctor || (params = allCtor.getParameterList().getParameters()).length != parameters.length) continue;
                    builder.addTextSegment(" type=\"" + parameters[i].getType().getCanonicalText() + "\"");
                    break;
                }
                builder.createValueAndClose(parameter.getType(), model, "constructor-arg");
            }
            builder.startTemplate(editor, AbstractDomGenerateProvider.createNamespacePrefixMap((DomElement)this.mySpringBean));
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                AddConstructorArgQuickFix.$$$reportNull$$$0(4);
            }
            if (previewDescriptor == null) {
                AddConstructorArgQuickFix.$$$reportNull$$$0(5);
            }
            return new IntentionPreviewInfo.Html(SpringBundle.message("model.add.constructor.args.for.method.quickfix.description", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringConstructorArgInspection$AddConstructorArgQuickFix";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringConstructorArgInspection$AddConstructorArgQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

