/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.retrofit.minimal;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.httpClient.http.request.microservices.OpenInHttpClientLineMarkerBuilder;
import com.intellij.httpClient.retrofit.minimal.RetrofitConstants;
import com.intellij.httpClient.retrofit.minimal.RetrofitCustomizer;
import com.intellij.httpClient.retrofit.minimal.RetrofitLibraryUtilsKt;
import com.intellij.httpClient.retrofit.minimal.RetrofitMinimalBundle;
import com.intellij.httpClient.retrofit.minimal.RetrofitUrlPathSpecification;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\r\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0016J2\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0014J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/retrofit/minimal/RetrofitLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "getName", "", "getId", "Lorg/jetbrains/annotations/NonNls;", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "element", "isAvailable", "method", "Lorg/jetbrains/uast/UMethod;", "intellij.httpClient.retrofit.minimal"})
@SourceDebugExtension(value={"SMAP\nRetrofitLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrofitLineMarkerProvider.kt\ncom/intellij/httpClient/retrofit/minimal/RetrofitLineMarkerProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,52:1\n1761#2,3:53\n267#3,3:56\n*S KotlinDebug\n*F\n+ 1 RetrofitLineMarkerProvider.kt\ncom/intellij/httpClient/retrofit/minimal/RetrofitLineMarkerProvider\n*L\n47#1:53,3\n32#1:56,3\n*E\n"})
public final class RetrofitLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    @NotNull
    public Icon getIcon() {
        return RetrofitCustomizer.Companion.getRetrofitCustomisation().getLineMarkerIcon();
    }

    @NotNull
    public String getName() {
        String string = RetrofitMinimalBundle.message("gutter.name.retrofit.open.in.httpclient", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getId() {
        return "RetrofitOpenInHttpClientLineMarkerProvider";
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        Module module2 = module;
        if (!RetrofitLibraryUtilsKt.isRetrofitAvailable(module2)) {
            return;
        }
        super.collectNavigationMarkers(elements, result2, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        UrlPathContextKt.forbidExpensiveUrlContext(() -> RetrofitLineMarkerProvider.collectNavigationMarkers$lambda$0(element, this, result2));
    }

    private final boolean isAvailable(UMethod method) {
        Object v1;
        block5: {
            Iterable iterable = method.getUAnnotations();
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    UAnnotation annotation = (UAnnotation)t;
                    boolean bl2 = false;
                    Iterable $this$any$iv = RetrofitConstants.INSTANCE.getHTTP_METHOD_ANNOTATIONS();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)it)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        UAnnotation check = v1;
        return check != null;
    }

    private static final Unit collectNavigationMarkers$lambda$0(PsiElement $element, RetrofitLineMarkerProvider this$0, Collection $result) {
        RelatedItemLineMarkerInfo<PsiElement> relatedItemLineMarkerInfo;
        UDeclaration parent$iv;
        PsiElement lineMarkerElement$iv = $element;
        boolean $i$f$getUParentForDeclarationLineMarkerElement = false;
        UElement uElement = UastUtils.getUParentForIdentifier((PsiElement)lineMarkerElement$iv);
        if (!(uElement instanceof UMethod)) {
            uElement = null;
        }
        UDeclaration uDeclaration = (UDeclaration)((UMethod)uElement);
        UMethod uMethod = (UMethod)(uDeclaration == null ? null : (!Intrinsics.areEqual((Object)UElementKt.getSourcePsiElement((UElement)(parent$iv = uDeclaration).getUastAnchor()), (Object)lineMarkerElement$iv) ? null : parent$iv));
        if (uMethod == null) {
            return Unit.INSTANCE;
        }
        UMethod method = uMethod;
        if (!this$0.isAvailable(method)) {
            return Unit.INSTANCE;
        }
        UrlPathContext urlPathContext = RetrofitUrlPathSpecification.INSTANCE.getUrlPathContextForMethod(method);
        Project project = $element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        OpenInHttpClientLineMarkerBuilder openInHttpClientLineMarkerBuilder = OpenInHttpClientLineMarkerBuilder.Companion.fromUrlPathContext(project, urlPathContext, false);
        if (openInHttpClientLineMarkerBuilder == null || (relatedItemLineMarkerInfo = openInHttpClientLineMarkerBuilder.createLineMarkerInfo($element, this$0.getIcon())) == null) {
            return Unit.INSTANCE;
        }
        RelatedItemLineMarkerInfo<PsiElement> lineMarkerInfo = relatedItemLineMarkerInfo;
        $result.add(lineMarkerInfo);
        return Unit.INSTANCE;
    }
}

