/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.field.WitherFieldProcessor;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WitherProcessor
extends AbstractClassProcessor {
    private static final String BUILDER_DEFAULT_ANNOTATION = "lombok.Builder.Default";

    public WitherProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.Wither", "lombok.With");
    }

    private static WitherFieldProcessor getWitherFieldProcessor() {
        return LombokProcessorManager.getInstance().getWitherFieldProcessor();
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (nameHint == null) {
            WitherProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(2);
        }
        if (!nameHint.startsWith("with")) {
            return false;
        }
        Collection<? extends PsiVariable> possibleWithElements = WitherProcessor.getPossibleWithElements(psiClass);
        if (possibleWithElements.isEmpty()) {
            return false;
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiClass).withFluent(false);
        for (PsiVariable psiVariable : possibleWithElements) {
            if (!nameHint.equals(LombokUtils.getWitherName(psiVariable, accessorsInfo))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        Collection<? extends PsiVariable> possibleWithElements = WitherProcessor.getPossibleWithElements(psiClass);
        if (!possibleWithElements.isEmpty()) {
            AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiClass).withFluent(false);
            for (PsiVariable psiVariable : possibleWithElements) {
                result.add(LombokUtils.getWitherName(psiVariable, accessorsInfo));
            }
        }
        return result;
    }

    @NotNull
    private static Collection<? extends PsiVariable> getPossibleWithElements(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(5);
        }
        if (psiClass.isRecord()) {
            List<PsiRecordComponent> list = List.of(psiClass.getRecordComponents());
            if (list == null) {
                WitherProcessor.$$$reportNull$$$0(6);
            }
            return list;
        }
        Collection<PsiField> collection = PsiClassUtil.collectClassFieldsIntern(psiClass);
        if (collection == null) {
            WitherProcessor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(8);
        }
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            WitherProcessor.$$$reportNull$$$0(10);
        }
        WitherProcessor.validateAnnotationOnRightType(psiClass, builder);
        WitherProcessor.validateVisibility(psiAnnotation, builder);
        if (builder.success()) {
            WitherFieldProcessor.validConstructor(psiClass, builder);
        }
        return builder.success();
    }

    private static void validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            WitherProcessor.$$$reportNull$$$0(12);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            builder.addErrorMessage("inspection.message.wither.only.supported.on.class.or.field", new Object[0]);
            builder.markFailed();
        }
    }

    private static void validateVisibility(@NotNull PsiAnnotation psiAnnotation, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            WitherProcessor.$$$reportNull$$$0(14);
        }
        if (null == LombokProcessorUtil.getMethodModifier(psiAnnotation)) {
            builder.markFailed();
        }
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        String methodVisibility;
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(15);
        }
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(16);
        }
        if (target == null) {
            WitherProcessor.$$$reportNull$$$0(17);
        }
        if ((methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null) {
            AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiClass).withFluent(false);
            target.addAll(this.createFieldWithers(psiClass, methodVisibility, accessorsInfo));
        }
    }

    @NotNull
    private Collection<PsiMethod> createFieldWithers(@NotNull PsiClass psiClass, @NotNull String methodModifier, @NotNull AccessorsInfo accessors) {
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(18);
        }
        if (methodModifier == null) {
            WitherProcessor.$$$reportNull$$$0(19);
        }
        if (accessors == null) {
            WitherProcessor.$$$reportNull$$$0(20);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Collection<PsiField> witherFields = this.getWitherFields(psiClass);
        for (PsiField witherField : witherFields) {
            PsiMethod method = WitherProcessor.getWitherFieldProcessor().createWitherMethod(witherField, methodModifier, accessors);
            if (method == null) continue;
            result.add(method);
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            WitherProcessor.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    private Collection<PsiField> getWitherFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(22);
        }
        ArrayList<PsiField> witherFields = new ArrayList<PsiField>();
        AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
        Collection<PsiMethod> existingMethods = WitherProcessor.filterToleratedElements(PsiClassUtil.collectClassMethodsIntern(psiClass));
        for (PsiField psiField : psiClass.getFields()) {
            if (!WitherProcessor.shouldGenerateWither(psiField, classAccessorsValues, existingMethods)) continue;
            witherFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = witherFields;
        if (arrayList == null) {
            WitherProcessor.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static boolean shouldGenerateWither(@NotNull PsiField psiField, @NotNull AccessorsInfo.AccessorsValues classAccessorsValues, @NotNull Collection<PsiMethod> existingMethods) {
        if (psiField == null) {
            WitherProcessor.$$$reportNull$$$0(24);
        }
        if (classAccessorsValues == null) {
            WitherProcessor.$$$reportNull$$$0(25);
        }
        if (existingMethods == null) {
            WitherProcessor.$$$reportNull$$$0(26);
        }
        boolean createWither = true;
        PsiModifierList modifierList = psiField.getModifierList();
        if (null != modifierList) {
            createWither = !modifierList.hasModifierProperty("static");
            createWither &= !modifierList.hasModifierProperty("final") || !psiField.hasInitializer() || PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, BUILDER_DEFAULT_ANNOTATION) != null;
            createWither &= !psiField.getName().startsWith("$");
            createWither &= !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, "lombok.experimental.Wither", "lombok.With");
            AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField, classAccessorsValues).withFluent(false);
            if (createWither &= accessorsInfo.acceptsFieldName(psiField.getName())) {
                createWither = WitherProcessor.isWitherMethodUnique(psiField, accessorsInfo, existingMethods);
            }
        }
        return createWither;
    }

    private static boolean isWitherMethodUnique(@NotNull PsiField psiField, @NotNull AccessorsInfo accessorsInfo, @NotNull Collection<PsiMethod> existingMethods) {
        if (psiField == null) {
            WitherProcessor.$$$reportNull$$$0(27);
        }
        if (accessorsInfo == null) {
            WitherProcessor.$$$reportNull$$$0(28);
        }
        if (existingMethods == null) {
            WitherProcessor.$$$reportNull$$$0(29);
        }
        Collection<String> possibleWitherNames = LombokUtils.toAllWitherNames(accessorsInfo, psiField.getName(), PsiTypes.booleanType().equals((Object)psiField.getType()));
        for (String witherName : possibleWitherNames) {
            if (!PsiMethodUtil.hasSimilarMethod(existingMethods, witherName, 1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        Collection<PsiMethod> existingMethods;
        AccessorsInfo.AccessorsValues classAccessorsValues;
        PsiClass containingClass;
        if (psiField == null) {
            WitherProcessor.$$$reportNull$$$0(30);
        }
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(31);
        }
        if ((containingClass = psiField.getContainingClass()) != null && WitherProcessor.shouldGenerateWither(psiField, classAccessorsValues = AccessorsInfo.getAccessorsValues(containingClass), existingMethods = WitherProcessor.filterToleratedElements(PsiClassUtil.collectClassMethodsIntern(containingClass)))) {
            return LombokPsiElementUsage.READ_WRITE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 13: 
            case 16: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 6: 
            case 7: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/WitherProcessor";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAccessorsValues";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingMethods";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/WitherProcessor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleWithElements";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldWithers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getWitherFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleWithElements";
                break;
            }
            case 6: 
            case 7: 
            case 21: 
            case 23: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFieldWithers";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getWitherFields";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateWither";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isWitherMethodUnique";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 21, 23 -> new IllegalStateException(string);
        };
    }
}

