/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.incremental.relativizer.CommonPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.GradlePathRelativizer;
import org.jetbrains.jps.incremental.relativizer.JavaSdkPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.MavenPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.PathRelativizer;
import org.jetbrains.jps.incremental.storage.PathTypeAwareRelativizer;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.util.JpsPathUtil;

public final class PathRelativizerService {
    private static final Logger LOG = Logger.getInstance(PathRelativizerService.class);
    private static final String PROJECT_DIR_IDENTIFIER = "$PROJECT_DIR$";
    private static final String BUILD_DIR_IDENTIFIER = "$BUILD_DIR$";
    private final PathRelativizer[] relativizers;
    @Nullable
    private final PathTypeAwareRelativizer typeAwareRelativizer;
    private final Set<String> unhandledPaths;

    public PathRelativizerService(@Nullable String projectPath) {
        this.unhandledPaths = Collections.synchronizedSet(new LinkedHashSet());
        this.relativizers = PathRelativizerService.initialize(projectPath, null, null, null);
        this.typeAwareRelativizer = null;
    }

    public PathRelativizerService(@Nullable String projectPath, @Nullable Boolean projectDirIsCaseSensitive) {
        this.unhandledPaths = Collections.synchronizedSet(new LinkedHashSet());
        this.relativizers = PathRelativizerService.initialize(projectPath, null, projectDirIsCaseSensitive, null);
        this.typeAwareRelativizer = null;
    }

    public PathRelativizerService(@NotNull JpsProject project) {
        if (project == null) {
            PathRelativizerService.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public PathRelativizerService(@NotNull JpsProject project, @Nullable Boolean projectDirIsCaseSensitive) {
        if (project == null) {
            PathRelativizerService.$$$reportNull$$$0(1);
        }
        this.unhandledPaths = Collections.synchronizedSet(new LinkedHashSet());
        Set javaSdks = project.getModules().stream().map(module -> module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE)).filter(sdk -> sdk != null && sdk.getVersionString() != null && sdk.getHomePath() != null).collect(Collectors.toSet());
        File projectBaseDirectory = JpsModelSerializationDataService.getBaseDirectory((JpsProject)project);
        this.relativizers = PathRelativizerService.initialize(projectBaseDirectory == null ? null : projectBaseDirectory.getAbsolutePath(), PathRelativizerService.getBuildDirPath(project), projectDirIsCaseSensitive, javaSdks);
        this.typeAwareRelativizer = null;
    }

    @ApiStatus.Internal
    public PathRelativizerService(@NotNull @NotNull PathRelativizer @NotNull [] relativizers, @NotNull PathTypeAwareRelativizer typeAwareRelativizer2) {
        if (typeAwareRelativizer2 == null) {
            PathRelativizerService.$$$reportNull$$$0(2);
        }
        if (relativizers == null) {
            PathRelativizerService.$$$reportNull$$$0(3);
        }
        this.unhandledPaths = Collections.synchronizedSet(new LinkedHashSet());
        this.relativizers = relativizers;
        this.typeAwareRelativizer = typeAwareRelativizer2;
    }

    @TestOnly
    public PathRelativizerService() {
        this.unhandledPaths = Collections.synchronizedSet(new LinkedHashSet());
        this.relativizers = PathRelativizerService.initialize(null, null, null, null);
        this.typeAwareRelativizer = null;
    }

    @ApiStatus.Internal
    @Nullable
    public PathTypeAwareRelativizer getTypeAwareRelativizer() {
        return this.typeAwareRelativizer;
    }

    @NotNull
    public String toRelative(@NotNull Path path) {
        if (path == null) {
            PathRelativizerService.$$$reportNull$$$0(4);
        }
        String string = this.toRelative(path.toString());
        if (string == null) {
            PathRelativizerService.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String toRelative(@NotNull String path) {
        if (path == null) {
            PathRelativizerService.$$$reportNull$$$0(6);
        }
        String systemIndependentPath = FileUtilRt.toSystemIndependentName((String)path);
        for (PathRelativizer relativizer : this.relativizers) {
            String relativePath = relativizer.toRelativePath(systemIndependentPath);
            if (relativePath == null) continue;
            String string = relativePath;
            if (string == null) {
                PathRelativizerService.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (LOG.isDebugEnabled()) {
            this.unhandledPaths.add(path);
        }
        String string = systemIndependentPath;
        if (string == null) {
            PathRelativizerService.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String toFull(@NotNull String path) {
        if (path == null) {
            PathRelativizerService.$$$reportNull$$$0(9);
        }
        String systemIndependentPath = FileUtilRt.toSystemIndependentName((String)path);
        for (PathRelativizer relativizer : this.relativizers) {
            String fullPath = relativizer.toAbsolutePath(systemIndependentPath);
            if (fullPath == null) continue;
            String string = fullPath;
            if (string == null) {
                PathRelativizerService.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = systemIndependentPath;
        if (string == null) {
            PathRelativizerService.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public Path toAbsoluteFile(@NotNull String path) {
        if (path == null) {
            PathRelativizerService.$$$reportNull$$$0(12);
        }
        String systemIndependentPath = FileUtilRt.toSystemIndependentName((String)path);
        for (PathRelativizer relativizer : this.relativizers) {
            String fullPath = relativizer.toAbsolutePath(systemIndependentPath);
            if (fullPath == null) continue;
            Path path2 = Path.of(fullPath, new String[0]);
            if (path2 == null) {
                PathRelativizerService.$$$reportNull$$$0(13);
            }
            return path2;
        }
        Path path3 = Path.of(systemIndependentPath, new String[0]);
        if (path3 == null) {
            PathRelativizerService.$$$reportNull$$$0(14);
        }
        return path3;
    }

    public void reportUnhandledPaths() {
        if (LOG.isDebugEnabled()) {
            StringBuilder logBuilder = new StringBuilder();
            this.unhandledPaths.forEach(it -> logBuilder.append((String)it).append("\n"));
            LOG.debug("Unhandled by relativizer paths:\n" + String.valueOf(logBuilder));
            this.unhandledPaths.clear();
        }
    }

    private static PathRelativizer[] initialize(@Nullable String projectPath, @Nullable String buildDirPath, @Nullable Boolean projectDirIsCaseSensitive, @Nullable Set<? extends JpsSdk<?>> javaSdks) {
        String normalizedProjectPath = projectPath == null ? null : PathRelativizerService.normalizePath(projectPath);
        String normalizedBuildDirPath = buildDirPath == null ? null : PathRelativizerService.normalizePath(buildDirPath);
        ArrayList<PathRelativizer> result = new ArrayList<PathRelativizer>(5);
        if (normalizedBuildDirPath != null) {
            result.add(new CommonPathRelativizer(normalizedBuildDirPath, BUILD_DIR_IDENTIFIER, projectDirIsCaseSensitive == null ? SystemInfoRt.isFileSystemCaseSensitive : projectDirIsCaseSensitive));
        }
        if (normalizedProjectPath != null) {
            result.add(new CommonPathRelativizer(normalizedProjectPath, PROJECT_DIR_IDENTIFIER));
        }
        if (javaSdks != null && !javaSdks.isEmpty()) {
            result.add(new JavaSdkPathRelativizer(javaSdks));
        }
        String mavenRepositoryPath = MavenPathRelativizer.getNormalizedMavenRepositoryPath();
        result.add(new MavenPathRelativizer(mavenRepositoryPath));
        String gradleRepositoryPath = GradlePathRelativizer.initializeGradleRepositoryPath();
        if (gradleRepositoryPath != null) {
            result.add(new GradlePathRelativizer(gradleRepositoryPath));
        }
        return result.toArray(new PathRelativizer[0]);
    }

    @NotNull
    static String normalizePath(@NotNull String path) {
        if (path == null) {
            PathRelativizerService.$$$reportNull$$$0(15);
        }
        String string = StringUtil.trimTrailing((String)FileUtilRt.toSystemIndependentName((String)path), (char)'/');
        if (string == null) {
            PathRelativizerService.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    private static String getBuildDirPath(@NotNull JpsProject project) {
        JpsJavaProjectExtension projectExtension;
        if (project == null) {
            PathRelativizerService.$$$reportNull$$$0(17);
        }
        if ((projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(project)) == null) {
            return null;
        }
        String url = projectExtension.getOutputUrl();
        if (url == null || url.isEmpty()) {
            return null;
        }
        return Path.of(JpsPathUtil.urlToPath((String)url), new String[0]).toAbsolutePath().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAwareRelativizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativizers";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/relativizer/PathRelativizerService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/relativizer/PathRelativizerService";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelative";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toFull";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toAbsoluteFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toRelative";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toFull";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toAbsoluteFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "normalizePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBuildDirPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

