/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.zmq.protocol;

import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.exceptions.ExceptionMerger;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqSocketData;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqSocketDataKt;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018J\u0014\u0010\u001a\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J(\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 H\u0082\b\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0015H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqNetworkSocket;", "Ljava/io/Closeable;", "socketData", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketData;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketData;)V", "address", "", "getAddress", "()Ljava/lang/String;", "socketType", "Lorg/zeromq/SocketType;", "socket", "Lorg/zeromq/ZMQ$Socket;", "getSocket", "()Lorg/zeromq/ZMQ$Socket;", "cancellationToken", "Lorg/zeromq/ZMQ$CancellationToken;", "kotlin.jvm.PlatformType", "socketName", "bind", "", "connect", "receiveMultipart", "", "", "sendMultipart", "frames", "nullOnCancellation", "T", "", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "close", "zmq-protocol"})
@SourceDebugExtension(value={"SMAP\nZmqNetworkSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZmqNetworkSocket.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqNetworkSocket\n+ 2 Util.kt\norg/jetbrains/kotlinx/jupyter/protocol/exceptions/UtilKt\n+ 3 Util.kt\norg/jetbrains/kotlinx/jupyter/protocol/exceptions/ExceptionMerger\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n76#1,9:99\n76#1,9:108\n76#1,9:117\n18#2:126\n10#2,4:127\n19#2,2:143\n14#2,3:145\n21#2:149\n30#3,6:131\n30#3,6:137\n1#4:148\n*S KotlinDebug\n*F\n+ 1 ZmqNetworkSocket.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqNetworkSocket\n*L\n55#1:99,9\n60#1:108,9\n67#1:117,9\n88#1:126\n88#1:127,4\n88#1:143,2\n88#1:145,3\n88#1:149\n89#1:131,6\n94#1:137,6\n88#1:148\n*E\n"})
public final class ZmqNetworkSocket
implements Closeable {
    @NotNull
    private final String address;
    @NotNull
    private final SocketType socketType;
    @NotNull
    private final ZMQ.Socket socket;
    private final ZMQ.CancellationToken cancellationToken;
    @NotNull
    private final String socketName;

    public ZmqNetworkSocket(@NotNull ZmqSocketData socketData) {
        Intrinsics.checkNotNullParameter((Object)socketData, (String)"socketData");
        this.address = socketData.getAddress();
        this.socketType = socketData.getSocketType();
        this.socket = ZmqSocketDataKt.createSocket(socketData);
        this.cancellationToken = this.socket.createCancellationToken();
        this.socketName = socketData.getName();
    }

    @NotNull
    public final String getAddress() {
        return this.address;
    }

    @NotNull
    public final ZMQ.Socket getSocket() {
        return this.socket;
    }

    public final void bind() {
        if (!this.socket.bind(this.address)) {
            throw new ZMQException("Failed to bind (socket: " + this.socketName + ")", this.socket.errno());
        }
        if (this.socketType == SocketType.PUB) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final void connect() {
        if (this.socketType == SocketType.SUB && !this.socket.subscribe(new byte[0])) {
            throw new ZMQException("Failed to subscribe (socket: " + this.socketName + ")", this.socket.errno());
        }
        if (!this.socket.connect(this.address)) {
            throw new ZMQException("Failed to connect (socket: " + this.socketName + ")", this.socket.errno());
        }
    }

    @Nullable
    public final List<byte[]> receiveMultipart() {
        List list;
        Object object;
        ZmqNetworkSocket this_$iv = this;
        boolean $i$f$nullOnCancellation = false;
        try {
            boolean bl = false;
            object = this.socket.recv(0, this.cancellationToken);
        }
        catch (ZMQException e$iv) {
            if (e$iv.getErrorCode() != ZMQ.Error.EINTR.getCode() && e$iv.getErrorCode() != 125) {
                throw e$iv;
            }
            object = null;
        }
        if (object == null) {
            return null;
        }
        byte[] firstFrame = object;
        List $this$receiveMultipart_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$receiveMultipart_u24lambda_u241.add(firstFrame);
        while (this.socket.hasReceiveMore()) {
            byte[] byArray;
            ZmqNetworkSocket e$iv = this;
            object = $this$receiveMultipart_u24lambda_u241;
            boolean $i$f$nullOnCancellation2 = false;
            try {
                boolean bl2 = false;
                byArray = this.socket.recv(0, this.cancellationToken);
            }
            catch (ZMQException e$iv2) {
                if (e$iv2.getErrorCode() != ZMQ.Error.EINTR.getCode() && e$iv2.getErrorCode() != 125) {
                    throw e$iv2;
                }
                byArray = null;
            }
            byte[] byArray2 = byArray;
            if (byArray2 == null) {
                return null;
            }
            object.add(byArray2);
        }
        return CollectionsKt.build((List)list);
    }

    public final void sendMultipart(@NotNull List<byte[]> frames) {
        Intrinsics.checkNotNullParameter(frames, (String)"frames");
        ZmqNetworkSocket this_$iv = this;
        boolean $i$f$nullOnCancellation = false;
        try {
            boolean bl = false;
            Iterator iterator = ((Iterable)frames).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                byte[] frame = (byte[])iterator.next();
                int flags = i < CollectionsKt.getLastIndex(frames) ? 2 : 0;
                this.socket.send(frame, flags, this.cancellationToken);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (ZMQException e$iv) {
            if (e$iv.getErrorCode() != ZMQ.Error.EINTR.getCode() && e$iv.getErrorCode() != 125) {
                throw e$iv;
            }
            Object var10_11 = null;
        }
    }

    private final <T> T nullOnCancellation(Function0<? extends T> block) {
        Object object;
        boolean $i$f$nullOnCancellation = false;
        try {
            object = block.invoke();
        }
        catch (ZMQException e) {
            if (e.getErrorCode() != ZMQ.Error.EINTR.getCode() && e.getErrorCode() != 125) {
                throw e;
            }
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        boolean $i$f$mergeExceptions = false;
        ExceptionMerger exceptionMerger$iv = new ExceptionMerger();
        Throwable throwable$iv = null;
        try {
            ExceptionMerger $this$close_u24lambda_u240 = exceptionMerger$iv;
            boolean bl = false;
            ExceptionMerger this_$iv = $this$close_u24lambda_u240;
            boolean $i$f$catchIndependently = false;
            try {
                boolean bl2 = false;
                if (!this.cancellationToken.isCancellationRequested()) {
                    this.cancellationToken.cancel();
                }
            }
            catch (Throwable e$iv) {
                this_$iv.addError(e$iv);
            }
            this_$iv = $this$close_u24lambda_u240;
            $i$f$catchIndependently = false;
            try {
                boolean bl3 = false;
                this.socket.close();
            }
            catch (Throwable e$iv) {
                this_$iv.addError(e$iv);
            }
            exceptionMerger$iv.finalize();
        }
        catch (Throwable e$iv) {
            try {
                throwable$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable$iv;
                if (throwable2 != null) {
                    Throwable it$iv = throwable2;
                    boolean bl = false;
                    exceptionMerger$iv.addError(it$iv);
                }
                exceptionMerger$iv.finalize();
                throw throwable;
            }
        }
    }
}

