/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.zmq.protocol;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.CallbackHandler;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.protocol.exceptions.UtilKt;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.BlockingSignallingQueue;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqNetworkSocket;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqSocketData;
import org.slf4j.Logger;
import org.zeromq.ZMQ;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0014\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J \u0010\u001f\u001a\u00020\u001b2\u0018\u0010 \u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u001b0!J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u001bH\u0002J\b\u0010$\u001a\u00020\u001bH\u0002J\u0016\u0010%\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010&\u001a\u00020\u001bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketWithCancellationImpl;", "Ljava/io/Closeable;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "socketData", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketData;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketData;)V", "logger", "Lorg/slf4j/Logger;", "networkSocket", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqNetworkSocket;", "poller", "Lorg/zeromq/ZMQ$Poller;", "kotlin.jvm.PlatformType", "sendQueue", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/BlockingSignallingQueue;", "", "", "callbackHandler", "Lorg/jetbrains/kotlinx/jupyter/protocol/CallbackHandler;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "closed", "routerThread", "Ljava/lang/Thread;", "bind", "", "connect", "sendMultipart", "message", "onReceive", "callback", "Lkotlin/Function1;", "close", "start", "messageRouterLoop", "processMessage", "assertNotCancelled", "Companion", "zmq-protocol"})
public final class ZmqSocketWithCancellationImpl
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final ZmqNetworkSocket networkSocket;
    private final ZMQ.Poller poller;
    @NotNull
    private final BlockingSignallingQueue<List<byte[]>> sendQueue;
    @NotNull
    private final CallbackHandler<List<byte[]>> callbackHandler;
    @NotNull
    private final AtomicBoolean started;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final Thread routerThread;
    public static final int MESSAGE_QUEUE_CAPACITY = 1000;

    public ZmqSocketWithCancellationImpl(@NotNull KernelLoggerFactory loggerFactory, @NotNull ZmqSocketData socketData) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)socketData, (String)"socketData");
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory, Reflection.getOrCreateKotlinClass(this.getClass()), socketData.getName());
        this.networkSocket = new ZmqNetworkSocket(socketData);
        this.poller = socketData.getZmqContext().poller(2);
        this.sendQueue = new BlockingSignallingQueue(1000);
        this.callbackHandler = new CallbackHandler(this.logger);
        this.started = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        this.routerThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)(socketData.getName() + " router thread"), (int)0, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ZmqSocketWithCancellationImpl.access$messageRouterLoop((ZmqSocketWithCancellationImpl)this.receiver);
            }
        }), (int)22, null);
    }

    public final synchronized void bind() {
        this.networkSocket.bind();
        this.start();
        this.logger.debug("listening on " + this.networkSocket.getAddress());
    }

    public final synchronized void connect() {
        this.networkSocket.connect();
        this.start();
        this.logger.debug("connected to " + this.networkSocket.getAddress());
    }

    public final void sendMultipart(@NotNull List<byte[]> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.assertNotCancelled();
        this.sendQueue.put(message);
    }

    public final void onReceive(@NotNull Function1<? super List<byte[]>, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbackHandler.addCallback(callback);
    }

    @Override
    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.logger.debug("closing a socket");
        Function0[] function0Array = new Function0[]{() -> ZmqSocketWithCancellationImpl.close$lambda$0(this), () -> ZmqSocketWithCancellationImpl.close$lambda$1(this), () -> ZmqSocketWithCancellationImpl.close$lambda$2(this), () -> ZmqSocketWithCancellationImpl.close$lambda$3(this), () -> ZmqSocketWithCancellationImpl.close$lambda$4(this)};
        UtilKt.catchAllIndependentlyAndMerge(function0Array);
    }

    private final synchronized void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.assertNotCancelled();
        this.routerThread.start();
    }

    private final void messageRouterLoop() {
        block5: {
            this.poller.register(this.networkSocket.getSocket(), 1);
            this.poller.register(this.sendQueue.getSignaller(), 1);
            try {
                while (!Thread.currentThread().isInterrupted() && !this.closed.get()) {
                    Object frames;
                    this.poller.poll(-1L);
                    if (this.poller.pollin(0) && (frames = this.networkSocket.receiveMultipart()) != null) {
                        this.processMessage((List<byte[]>)frames);
                    }
                    if (!this.poller.pollin(1)) continue;
                    frames = this.sendQueue.drainAll().iterator();
                    while (frames.hasNext()) {
                        List frames2 = (List)frames.next();
                        this.networkSocket.sendMultipart(frames2);
                    }
                }
            }
            catch (Throwable t) {
                if (this.closed.get()) break block5;
                this.logger.error("routerThread crashed", t);
            }
        }
    }

    private final void processMessage(List<byte[]> message) {
        this.callbackHandler.runCallbacks(message);
    }

    private final void assertNotCancelled() {
        if (this.closed.get()) {
            throw new CancellationException();
        }
    }

    private static final Unit close$lambda$0(ZmqSocketWithCancellationImpl this$0) {
        this$0.networkSocket.close();
        return Unit.INSTANCE;
    }

    private static final Unit close$lambda$1(ZmqSocketWithCancellationImpl this$0) {
        this$0.sendQueue.close();
        return Unit.INSTANCE;
    }

    private static final Unit close$lambda$2(ZmqSocketWithCancellationImpl this$0) {
        this$0.poller.close();
        return Unit.INSTANCE;
    }

    private static final Unit close$lambda$3(ZmqSocketWithCancellationImpl this$0) {
        this$0.routerThread.interrupt();
        return Unit.INSTANCE;
    }

    private static final Unit close$lambda$4(ZmqSocketWithCancellationImpl this$0) {
        this$0.callbackHandler.close();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$messageRouterLoop(ZmqSocketWithCancellationImpl $this) {
        $this.messageRouterLoop();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketWithCancellationImpl$Companion;", "", "<init>", "()V", "MESSAGE_QUEUE_CAPACITY", "", "zmq-protocol"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

