# Release (2025-09-26)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.50.0](service/bedrockagentruntime/CHANGELOG.md#v1500-2025-09-26)
  * **Feature**: This release enhances the information provided through Flow Traces. New information includes source/next node tracking, execution chains for complex nodes, dependency action (operation) details, and dependency traces.
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation`: [v1.10.0](service/bedrockdataautomation/CHANGELOG.md#v1100-2025-09-26)
  * **Feature**: Added support for configurable Speaker Labeling and Channel Labeling features for Audio modality.
* `github.com/aws/aws-sdk-go-v2/service/billing`: [v1.8.0](service/billing/CHANGELOG.md#v180-2025-09-26)
  * **Feature**: Add ability to combine custom billing views to create new consolidated views.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.141.0](service/connect/CHANGELOG.md#v11410-2025-09-26)
  * **Feature**: Adds supports for manual contact picking (WorkList) operations on Routing Profiles, Agent Management and SearchContacts APIs.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.57.0](service/costexplorer/CHANGELOG.md#v1570-2025-09-26)
  * **Feature**: Support for payer account dimension and billing view health status.
* `github.com/aws/aws-sdk-go-v2/service/dynamodbstreams`: [v1.31.0](service/dynamodbstreams/CHANGELOG.md#v1310-2025-09-26)
  * **Feature**: Added support for IPv6 compatible endpoints for DynamoDB Streams.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.254.1](service/ec2/CHANGELOG.md#v12541-2025-09-26)
  * **Documentation**: This release includes documentation updates for Amazon EBS General Purpose SSD (gp3) volumes with larger size and higher IOPS and throughput.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.59.0](service/redshift/CHANGELOG.md#v1590-2025-09-26)
  * **Feature**: Support tagging and tag propagation to IAM Identity Center for Redshift Idc Applications

# Release (2025-09-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.129.0](service/glue/CHANGELOG.md#v11290-2025-09-25)
  * **Feature**: Update GetConnection(s) API to return KmsKeyArn & Add 63 missing connection types
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.49.0](service/lightsail/CHANGELOG.md#v1490-2025-09-25)
  * **Feature**: Attribute HTTP binding update for Get/Delete operations
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.57.0](service/networkfirewall/CHANGELOG.md#v1570-2025-09-25)
  * **Feature**: Network Firewall now introduces Reject and Alert action support for stateful domain list rule groups, providing customers with more granular control over their network traffic.

# Release (2025-09-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.49.6](service/appstream/CHANGELOG.md#v1496-2025-09-24)
  * **Documentation**: G6f instance support for AppStream 2.0
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.51.0](service/cloudwatch/CHANGELOG.md#v1510-2025-09-24)
  * **Feature**: Fix default dualstack FIPS endpoints in AWS GovCloud(US) regions
* `github.com/aws/aws-sdk-go-v2/service/dax`: [v1.29.0](service/dax/CHANGELOG.md#v1290-2025-09-24)
  * **Feature**: This release adds support for IPv6-only, DUAL_STACK DAX instances
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.45.5](service/kms/CHANGELOG.md#v1455-2025-09-24)
  * **Documentation**: Documentation only updates for KMS.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.42.4](service/neptune/CHANGELOG.md#v1424-2025-09-24)
  * **Documentation**: Doc-only update to address customer use.

# Release (2025-09-23)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.34.0](service/cleanrooms/CHANGELOG.md#v1340-2025-09-23)
  * **Feature**: Added support for running incremental ID mapping for rule-based workflows.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.254.0](service/ec2/CHANGELOG.md#v12540-2025-09-23)
  * **Feature**: Add Amazon EC2 R8gn instance types
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.25.0](service/entityresolution/CHANGELOG.md#v1250-2025-09-23)
  * **Feature**: Support incremental id mapping workflow for AWS Entity Resolution
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.65.0](service/ssm/CHANGELOG.md#v1650-2025-09-23)
  * **Feature**: Added Dualstack support to GetDeployablePatchSnapshotForInstance
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.36.0](service/ssoadmin/CHANGELOG.md#v1360-2025-09-23)
  * **Feature**: Add support for encryption at rest with Customer Managed KMS Key in AWS IAM Identity Center
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.35.0](service/ssooidc/CHANGELOG.md#v1350-2025-09-23)
  * **Feature**: This release includes exception definition and documentation updates.

# Release (2025-09-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.57.8](service/batch/CHANGELOG.md#v1578-2025-09-22)
  * **Documentation**: Starting in JAN 2026, AWS Batch will change the default AMI for new Amazon ECS compute environments from Amazon Linux 2 to Amazon Linux 2023. We recommend migrating AWS Batch Amazon ECS compute environments to Amazon Linux 2023 to maintain optimal performance and security.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.74.0](service/eks/CHANGELOG.md#v1740-2025-09-22)
  * **Feature**: Adds support for RepairConfig overrides and configurations in EKS Managed Node Groups.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.47.0](service/imagebuilder/CHANGELOG.md#v1470-2025-09-22)
  * **Feature**: Version ARNs are no longer required for the EC2 Image Builder list-image-build-version, list-component-build-version, and list-workflow-build-version APIs. Calling these APIs without the ARN returns all build versions for the given resource type in the requesting account.

# Release (2025-09-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol`: [v1.5.0](service/bedrockagentcorecontrol/CHANGELOG.md#v150-2025-09-19)
  * **Feature**: Add tagging and VPC support to AgentCore Runtime, Code Interpreter, and Browser resources. Add support for configuring request headers in Runtime. Fix AgentCore Runtime shape names.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.58.0](service/configservice/CHANGELOG.md#v1580-2025-09-19)
  * **Feature**: Add UNKNOWN state to RemediationExecutionState and add IN_PROGRESS/EXITED/UNKNOWN states to RemediationExecutionStepState.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.140.0](service/connect/CHANGELOG.md#v11400-2025-09-19)
  * **Feature**: This release adds a persistent connection field to UserPhoneConfig that maintains agent's softphone media connection for faster call connections.
* `github.com/aws/aws-sdk-go-v2/service/kendraranking`: [v1.15.7](service/kendraranking/CHANGELOG.md#v1157-2025-09-19)
  * **Documentation**: Model whitespace change - no client difference
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.20.0](service/licensemanagerusersubscriptions/CHANGELOG.md#v1200-2025-09-19)
  * **Feature**: Added support for cross-account Active Directories.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.83.0](service/medialive/CHANGELOG.md#v1830-2025-09-19)
  * **Feature**: Add MinBitrate for QVBR mode under H264/H265/AV1 output codec. Add GopBReference, GopNumBFrames, SubGopLength fields under H265 output codec.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.42.6](service/sqs/CHANGELOG.md#v1426-2025-09-19)
  * **Documentation**: Update invalid character handling documentation for SQS SendMessage API

# Release (2025-09-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.47.0](service/bedrock/CHANGELOG.md#v1470-2025-09-18)
  * **Feature**: Release includes an increase to the maximum policy build document size, an update to DeleteAutomatedReasoningPolicyBuildWorkflow to add ResourceInUseException, and corrections to UpdateAutomatedReasoningPolicyTestCaseRequest.
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.39.0](service/budgets/CHANGELOG.md#v1390-2025-09-18)
  * **Feature**: Added BillingViewHealthStatus Exception which is thrown when a Budget is created or updated with a Billing View that is not in the HEALTHY status
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging`: [v1.32.0](service/chimesdkmessaging/CHANGELOG.md#v1320-2025-09-18)
  * **Feature**: Amazon Chime SDK Messaging GetMessagingSessionEndpoint API now returns dual-stack WebSocket endpoints supporting IPv4/IPv6.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.253.0](service/ec2/CHANGELOG.md#v12530-2025-09-18)
  * **Feature**: Allowed AMIs adds support for four new parameters - marketplaceProductCodes, deprecationTimeCondition, creationDateCondition and imageNames

# Release (2025-09-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.252.0](service/ec2/CHANGELOG.md#v12520-2025-09-17)
  * **Feature**: Add mac-m4.metal and mac-m4pro.metal instance types.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.56.0](service/networkfirewall/CHANGELOG.md#v1560-2025-09-17)
  * **Feature**: Network Firewall now prevents TLS handshakes with the target server until after the Server Name Indication (SNI) has been seen and verified. The monitoring dashboard now provides deeper insights into PrivateLink endpoint candidates and offers filters based on IP addresses and protocol.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.13.0](service/pcs/CHANGELOG.md#v1130-2025-09-17)
  * **Feature**: Add support for Amazon EC2 Capacity Blocks for ML

# Release (2025-09-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.38.0](service/budgets/CHANGELOG.md#v1380-2025-09-16)
  * **Feature**: Add support for custom time periods in budget configuration
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.58.0](service/cloudwatchlogs/CHANGELOG.md#v1580-2025-09-16)
  * **Feature**: Cloudwatch Logs added support for 2 new API parameters in metric and subscription filter APIs to filter log events based on system field values and emit system field values as dimensions and send them to customer destination as additional metadata.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.30.0](service/ivsrealtime/CHANGELOG.md#v1300-2025-09-16)
  * **Feature**: IVS now offers customers the ability to control the positioning of participants in both grid and PiP layouts based on custom attribute values in participant tokens.
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.20.0](service/osis/CHANGELOG.md#v1200-2025-09-16)
  * **Feature**: Adds support for cross-account ingestion for push-based sources. This includes resource policies for sharing pipelines across accounts and features for managing pipeline endpoints which enable accessing pipelines across different VPCs, including VPCs in other accounts.

# Release (2025-09-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.56.0](service/costexplorer/CHANGELOG.md#v1560-2025-09-15)
  * **Feature**: Added endpoint support for eusc-de-east-1 region.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.21.0](service/medicalimaging/CHANGELOG.md#v1210-2025-09-15)
  * **Feature**: Added support for OpenID Connect (OIDC) custom authorizer
* `github.com/aws/aws-sdk-go-v2/service/observabilityadmin`: [v1.7.0](service/observabilityadmin/CHANGELOG.md#v170-2025-09-15)
  * **Feature**: CloudWatch Observability Admin adds the ability to enable telemetry centralization in customers' Organizations. The release introduces new APIs to manage centralization rules, which define settings to replicate telemetry data to a central destination in the customers' Organization.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.66.0](service/s3control/CHANGELOG.md#v1660-2025-09-15)
  * **Feature**: Introduce three new encryption filters: EncryptionType (SSE-S3, SSE-KMS, DSSE-KMS, SSE-C, NOT-SSE), KmsKeyArn (for SSE-KMS and DSSE-KMS), and BucketKeyEnabled (for SSE-KMS).

# Release (2025-09-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.25.0](service/paymentcryptography/CHANGELOG.md#v1250-2025-09-12)
  * **Feature**: Add support for certificates to be signed by 3rd party certificate authorities.  New API GetCertificateSigningRequest API and support for providing certificates at run-time for tr-34 import/export

# Release (2025-09-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.40.0](service/amp/CHANGELOG.md#v1400-2025-09-11)
  * **Feature**: Add Vended Logs APIs for Amazon Prometheus Managed Collector
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.41.0](service/datazone/CHANGELOG.md#v1410-2025-09-11)
  * **Feature**: adding IAM principal id to IAM user profile details
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.64.0](service/ecs/CHANGELOG.md#v1640-2025-09-11)
  * **Feature**: This release supports hook details for Amazon ECS lifecycle hooks.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.40.0](service/emrcontainers/CHANGELOG.md#v1400-2025-09-11)
  * **Feature**: Added nodeLabel support in container provider to aid hardware isolation support for virtual cluster and security configuration.
* `github.com/aws/aws-sdk-go-v2/service/evs`: [v1.5.0](service/evs/CHANGELOG.md#v150-2025-09-11)
  * **Feature**: CreateEnvironment API now supports parameters (isHcxPublic & hcxNetworkAclId) for HCX migration via public internet, adding flexibility for migration scenarios. New APIs have been added for associating (AssociateEipToVlan) & disassociating (DisassociateEipFromVlan) Elastic IP (EIP) addresses.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.64.0](service/guardduty/CHANGELOG.md#v1640-2025-09-11)
  * **Feature**: Updated Java SDK implementation of entity set status in GuardDuty API.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.82.0](service/medialive/CHANGELOG.md#v1820-2025-09-11)
  * **Feature**: AWS Elemental MediaLive adds a new feature in MediaPackage output group that enables MediaPackage V2 users to control HLS-related parameters directly in MediaLive. These parameter settings are then reflected in MediaPackage outputs, providing more streamlined control over HLS configurations.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.94.0](service/quicksight/CHANGELOG.md#v1940-2025-09-11)
  * **Feature**: This release adds support for Account level custom permissions, additional Dashboard Options, and Null support for Q&A.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.107.0](service/rds/CHANGELOG.md#v11070-2025-09-11)
  * **Feature**: Adds support for end-to-end IAM authentication in RDS Proxy for MySQL, MariaDB, and PostgreSQL engines.

# Release (2025-09-10)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/networkflowmonitor`: [v1.9.0](service/networkflowmonitor/CHANGELOG.md#v190-2025-09-10)
  * **Feature**: Added new enum value (AWS::Region) for type field under MonitorLocalResource and MonitorRemoteResource. Workload Insights and Monitor top contributors queries now support a new DestinationCategory (INTER_REGION).
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.24.0](service/paymentcryptography/CHANGELOG.md#v1240-2025-09-10)
  * **Feature**: AWS Payment Cryptography Service now supports Multi-Region key replication. Customers can choose to automatically distribute keys across AWS Regions.

# Release (2025-09-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.59.0](service/autoscaling/CHANGELOG.md#v1590-2025-09-09)
  * **Feature**: Added WaitForTransitioningInstances parameter to the CancelInstanceRefresh API, allowing the caller to cancel an instance refresh without waiting for on-going launches and terminations.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.50.0](service/cloudwatch/CHANGELOG.md#v1500-2025-09-09)
  * **Feature**: Added a new API - DescribeAlarmContributors API, to retrieve alarm contributors in ALARM state. Added support in DescribeAlarmHistory API to query alarm contributor history
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.139.0](service/connect/CHANGELOG.md#v11390-2025-09-09)
  * **Feature**: SDK release for user defined predefined attributes.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.40.0](service/datazone/CHANGELOG.md#v1400-2025-09-09)
  * **Feature**: Adds support for custom blueprints
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.31.0](service/mediapackagev2/CHANGELOG.md#v1310-2025-09-09)
  * **Feature**: Added CUE tag SCTE output to MediaPackageV2 HLS and LL-HLS manifests.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.45.0](service/organizations/CHANGELOG.md#v1450-2025-09-09)
  * **Feature**: Documentation updates for AWS Organizations APIs.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.215.0](service/sagemaker/CHANGELOG.md#v12150-2025-09-09)
  * **Feature**: Released IPv6 support with dual-stack domain options on SageMaker Studio and introduced support for p6-b200.48xlarge instance type on SageMaker Studio for JupyterLab and CodeEditor applications.

# Release (2025-09-08)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.39.0
  * **Feature**: Emit user-agent business metrics for use of env-based bearer tokens.
  * **Bug Fix**: Statically define s3 expires shape as timestamp, this patch should guarantee s3 operations backwards compatibility after s3 team removes the expires reshape.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.46.0](service/bedrock/CHANGELOG.md#v1460-2025-09-08)
  * **Feature**: Emit user-agent business metrics for use of env-based bearer tokens.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.40.0](service/bedrockruntime/CHANGELOG.md#v1400-2025-09-08)
  * **Feature**: Emit user-agent business metrics for use of env-based bearer tokens.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.52.0](service/iotsitewise/CHANGELOG.md#v1520-2025-09-08)
  * **Feature**: Add ComputationModelVersion support in IoT SiteWise APIs
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.88.0](service/s3/CHANGELOG.md#v1880-2025-09-08)
  * **Feature**: This release includes backward compatibility work on the "Expires" parameter.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.64.0](service/securityhub/CHANGELOG.md#v1640-2025-09-08)
  * **Feature**: This release adds the RESOURCE_NOT_FOUND error code as a possible value in responses to the following operations: BatchGetStandardsControlAssociations, BatchUpdateStandardsControlAssociations, and BatchGetSecurityControls.

# Release (2025-09-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.63.5](service/ecs/CHANGELOG.md#v1635-2025-09-05)
  * **Documentation**: This is a documentation only release that adds additional information for Amazon ECS Availability Zone rebalancing.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.12.2](service/pcs/CHANGELOG.md#v1122-2025-09-05)
  * **Documentation**: Documentation-only update to add AccountingStorageEnforce to SlurmCustomSetting.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.214.0](service/sagemaker/CHANGELOG.md#v12140-2025-09-05)
  * **Feature**: Release IPv6 support with dualstack in SageMaker Notebooks, Tiered Storage Checkpointing Support in SageMaker HyperPod and P5.4xlarge instance type for SageMaker Hosting.

# Release (2025-09-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.33.0](service/cleanrooms/CHANGELOG.md#v1330-2025-09-04)
  * **Feature**: Add support for configurable compute sizes for PySpark jobs.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.66.0](service/cloudformation/CHANGELOG.md#v1660-2025-09-04)
  * **Feature**: ListHookResults API now supports retrieving invocation results for all CloudFormation Hooks (previously limited to create change set and Cloud Control operations) with new optional parameters for filtering by Hook status and ARN.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.251.0](service/ec2/CHANGELOG.md#v12510-2025-09-04)
  * **Feature**: Add m8i, m8i-flex and i8ge instance types.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.26.0](service/opensearchserverless/CHANGELOG.md#v1260-2025-09-04)
  * **Feature**: Add support for Federal Information Processing Standards (FIPS) and Federal Risk and Authorization Management Program (FedRAMP) compliance
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.106.0](service/rds/CHANGELOG.md#v11060-2025-09-04)
  * **Feature**: Added new EndpointNetworkType and TargetConnectionNetworkType fields in Proxy APIs to support IPv6
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.29.0](service/verifiedpermissions/CHANGELOG.md#v1290-2025-09-04)
  * **Feature**: Amazon Verified Permissions / Features : Adds support for datetime and duration attribute values.

# Release (2025-09-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.32.0](service/cleanrooms/CHANGELOG.md#v1320-2025-09-03)
  * **Feature**: Added support for adding new data provider members to an existing collaboration.
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.19.0](service/cleanroomsml/CHANGELOG.md#v1190-2025-09-03)
  * **Feature**: AWS Clean Rooms ML adds log sanitization for privacy-enhanced error summaries, supports new instance types for custom models providing better performance and lower costs, and deprecates P3-series instances.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.54.0](service/cloudfront/CHANGELOG.md#v1540-2025-09-03)
  * **Feature**: Adding an optional field IpAddressType in CustomOriginConfig
* `github.com/aws/aws-sdk-go-v2/service/mq`: [v1.34.0](service/mq/CHANGELOG.md#v1340-2025-09-03)
  * **Feature**: Add CONFIG_MANAGED as a supported AuthenticationStrategy for Amazon MQ for RabbitMQ brokers. Make username and password optional on broker creation for CONFIG_MANAGED brokers.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.105.0](service/rds/CHANGELOG.md#v11050-2025-09-03)
  * **Feature**: This release adds support for MasterUserAuthenticationType parameter on CreateDBInstance, ModifyDBInstance, CreateDBCluster, and ModifyDBCluster operations.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.58.0](service/route53/CHANGELOG.md#v1580-2025-09-03)
  * **Feature**: Amazon Route 53 now supports the Asia Pacific (New Zealand) Region (ap-southeast-6) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.34.0](service/route53domains/CHANGELOG.md#v1340-2025-09-03)
  * **Feature**: Added new ExtraParams AU_ELIGIBILITY_TYPE, AU_POLICY_REASON, and AU_REGISTRANT_NAME
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.32.0](service/transcribestreaming/CHANGELOG.md#v1320-2025-09-03)
  * **Feature**: This release adds support for automatic language identification in AWS Transcribe Call Analytics

# Release (2025-09-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.250.0](service/ec2/CHANGELOG.md#v12500-2025-09-02)
  * **Feature**: MaximumEbsAttachments and AttachmentLimitType fields added to DescribeInstanceTypesResponse. G6f, Gr6f, R8i, R8i-flex and p5.4xlarge instance types added to InstanceTypes enum.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.42.0](service/neptune/CHANGELOG.md#v1420-2025-09-02)
  * **Feature**: Removed the deprecated marker from publiclyAccessible parameter from DbInstance, CreateDbInstance and ModifyDbInstance and added relevant usage information for the parameter.
* `github.com/aws/aws-sdk-go-v2/service/notifications`: [v1.7.0](service/notifications/CHANGELOG.md#v170-2025-09-02)
  * **Feature**: Added Org support for notifications:  - `ListMemberAccounts` gets member accounts list, `AssociateOrganizationalUnit` links OU to notification configuration, `DisassociateOrganizationalUnit` removes OU from notification configuration, `ListOrganizationalUnits` shows OUs configured for notifications.
* `github.com/aws/aws-sdk-go-v2/service/workmail`: [v1.36.0](service/workmail/CHANGELOG.md#v1360-2025-09-02)
  * **Feature**: Make RoleArn an optional parameter for the PutEmailMonitoringConfiguration API, and add UnsupportedOperationException to RegisterToWorkMail.

# Release (2025-08-29)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.39.0](service/bedrockruntime/CHANGELOG.md#v1390-2025-08-29)
  * **Feature**: Fixed stop sequence limit for converse API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.249.0](service/ec2/CHANGELOG.md#v12490-2025-08-29)
  * **Feature**: Release shows new route types such as filtered and advertisement.
* `github.com/aws/aws-sdk-go-v2/service/sms`: [v1.29.0](service/sms/CHANGELOG.md#v1290-2025-08-29)
  * **Feature**: Mark service/sms as deprecated. This service is no longer available for use.
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.36.0](service/xray/CHANGELOG.md#v1360-2025-08-29)
  * **Feature**: AWS X-Ray Features: Support Sampling Rate Boost On Anomaly

# Release (2025-08-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.37.0](service/amplify/CHANGELOG.md#v1370-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.40.0](service/applicationautoscaling/CHANGELOG.md#v1400-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/applicationcostprofiler`: [v1.26.0](service/applicationcostprofiler/CHANGELOG.md#v1260-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.38.2](service/apprunner/CHANGELOG.md#v1382-2025-08-28)
  * **Documentation**: Doc only updates for APIs and and datatypes related to IPAddressType and Subnets for IPv6 dualstack support.
* `github.com/aws/aws-sdk-go-v2/service/autoscalingplans`: [v1.29.0](service/autoscalingplans/CHANGELOG.md#v1290-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.38.0](service/bedrockruntime/CHANGELOG.md#v1380-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.33.0](service/cloud9/CHANGELOG.md#v1330-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.34.0](service/cloudhsmv2/CHANGELOG.md#v1340-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudsearchdomain`: [v1.28.0](service/cloudsearchdomain/CHANGELOG.md#v1280-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.34.0](service/codedeploy/CHANGELOG.md#v1340-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codegurureviewer`: [v1.34.0](service/codegurureviewer/CHANGELOG.md#v1340-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.138.0](service/connect/CHANGELOG.md#v11380-2025-08-28)
  * **Feature**: AgentStatusDrillDown feature in GetCurrentMetricData API. Adding AGENT_STATUS as filter and grouping in GetCurrentMetricData API
* `github.com/aws/aws-sdk-go-v2/service/connectcampaigns`: [v1.20.0](service/connectcampaigns/CHANGELOG.md#v1200-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/databrew`: [v1.38.0](service/databrew/CHANGELOG.md#v1380-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.50.0](service/dynamodb/CHANGELOG.md#v1500-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.248.0](service/ec2/CHANGELOG.md#v12480-2025-08-28)
  * **Feature**: This release adds support for copying Amazon EBS snapshot and AMIs to and from Local Zones.
* `github.com/aws/aws-sdk-go-v2/service/ec2instanceconnect`: [v1.32.0](service/ec2instanceconnect/CHANGELOG.md#v1320-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.50.0](service/ecr/CHANGELOG.md#v1500-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.54.0](service/emr/CHANGELOG.md#v1540-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.24.0](service/entityresolution/CHANGELOG.md#v1240-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.45.0](service/eventbridge/CHANGELOG.md#v1450-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.37.0](service/fis/CHANGELOG.md#v1370-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.44.0](service/fms/CHANGELOG.md#v1440-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/geomaps`: [v1.6.0](service/geomaps/CHANGELOG.md#v160-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/geoplaces`: [v1.6.0](service/geoplaces/CHANGELOG.md#v160-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.128.0](service/glue/CHANGELOG.md#v11280-2025-08-28)
  * **Feature**: Adding support to fetch TargetDatabase field during GetDatabases with AttributesToGet
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.35.0](service/healthlake/CHANGELOG.md#v1350-2025-08-28)
  * **Feature**: Add ValidationLevel parameter to StartFHIRImportJob API, allowing users to specify a FHIR validation level for their asynchronous import jobs.
* `github.com/aws/aws-sdk-go-v2/service/inspectorscan`: [v1.12.0](service/inspectorscan/CHANGELOG.md#v1120-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.25.0](service/internetmonitor/CHANGELOG.md#v1250-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.40.0](service/kinesis/CHANGELOG.md#v1400-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.19.0](service/licensemanagerusersubscriptions/CHANGELOG.md#v1190-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/machinelearning`: [v1.33.0](service/machinelearning/CHANGELOG.md#v1330-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.21.0](service/managedblockchainquery/CHANGELOG.md#v1210-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/marketplacedeployment`: [v1.11.0](service/marketplacedeployment/CHANGELOG.md#v1110-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mediastoredata`: [v1.29.0](service/mediastoredata/CHANGELOG.md#v1290-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mturk`: [v1.30.0](service/mturk/CHANGELOG.md#v1300-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.55.0](service/networkfirewall/CHANGELOG.md#v1550-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.22.0](service/oam/CHANGELOG.md#v1220-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.36.0](service/omics/CHANGELOG.md#v1360-2025-08-28)
  * **Feature**: Adds Amazon ECR pull through cache support to AWS HealthOmics, so you can more easily use container images from external sources.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.52.0](service/opensearch/CHANGELOG.md#v1520-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.19.0](service/osis/CHANGELOG.md#v1190-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.12.0](service/pcs/CHANGELOG.md#v1120-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoice`: [v1.28.0](service/pinpointsmsvoice/CHANGELOG.md#v1280-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.25.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1250-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.23.0](service/pipes/CHANGELOG.md#v1230-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.93.0](service/quicksight/CHANGELOG.md#v1930-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.104.0](service/rds/CHANGELOG.md#v11040-2025-08-28)
  * **Feature**: Added RDS HTTP Endpoint feature support flag to DescribeOrderableDBInstanceOptions API
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.51.0](service/rekognition/CHANGELOG.md#v1510-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.33.0](service/route53domains/CHANGELOG.md#v1330-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/savingsplans`: [v1.28.0](service/savingsplans/CHANGELOG.md#v1280-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/scheduler`: [v1.17.0](service/scheduler/CHANGELOG.md#v1170-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/servicequotas`: [v1.32.0](service/servicequotas/CHANGELOG.md#v1320-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ses`: [v1.34.0](service/ses/CHANGELOG.md#v1340-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.53.0](service/sesv2/CHANGELOG.md#v1530-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ssmguiconnect`: [v1.4.0](service/ssmguiconnect/CHANGELOG.md#v140-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.39.0](service/ssmincidents/CHANGELOG.md#v1390-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.25.0](service/ssmsap/CHANGELOG.md#v1250-2025-08-28)
  * **Feature**: Added support for Configuration Checks on SAP HANA Applications.
* `github.com/aws/aws-sdk-go-v2/service/sso`: [v1.29.0](service/sso/CHANGELOG.md#v1290-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/swf`: [v1.32.0](service/swf/CHANGELOG.md#v1320-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.35.0](service/timestreamquery/CHANGELOG.md#v1350-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/waf`: [v1.30.0](service/waf/CHANGELOG.md#v1300-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/workmailmessageflow`: [v1.28.0](service/workmailmessageflow/CHANGELOG.md#v1280-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.35.0](service/xray/CHANGELOG.md#v1350-2025-08-28)
  * **Feature**: Remove incorrect endpoint tests

# Release (2025-08-27)

## General Highlights
* **Dependency Update**: Update to smithy-go v1.23.0.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.44.0](service/acmpca/CHANGELOG.md#v1440-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/amplifybackend`: [v1.32.0](service/amplifybackend/CHANGELOG.md#v1320-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.28.0](service/amplifyuibuilder/CHANGELOG.md#v1280-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/appconfigdata`: [v1.23.0](service/appconfigdata/CHANGELOG.md#v1230-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.34.0](service/applicationdiscoveryservice/CHANGELOG.md#v1340-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/applicationinsights`: [v1.34.0](service/applicationinsights/CHANGELOG.md#v1340-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/apptest`: [v1.9.0](service/apptest/CHANGELOG.md#v190-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.57.4](service/batch/CHANGELOG.md#v1574-2025-08-27)
  * **Documentation**: Added ECS_AL2023_NVIDIA as an option for Ec2Configuration.imageType.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentcore`: [v1.4.0](service/bedrockagentcore/CHANGELOG.md#v140-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.37.2](service/bedrockruntime/CHANGELOG.md#v1372-2025-08-27)
  * **Bug Fix**: Ensure document.Interface values with maps serialize keys in a stable order. This should improve prompt cache hit rates with various inputs.
* `github.com/aws/aws-sdk-go-v2/service/chime`: [v1.40.0](service/chime/CHANGELOG.md#v1400-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/chimesdkidentity`: [v1.27.0](service/chimesdkidentity/CHANGELOG.md#v1270-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmeetings`: [v1.32.0](service/chimesdkmeetings/CHANGELOG.md#v1320-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.26.0](service/chimesdkvoice/CHANGELOG.md#v1260-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.18.0](service/cleanroomsml/CHANGELOG.md#v1180-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.67.0](service/codebuild/CHANGELOG.md#v1670-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codeconnections`: [v1.10.0](service/codeconnections/CHANGELOG.md#v1100-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codeguruprofiler`: [v1.29.0](service/codeguruprofiler/CHANGELOG.md#v1290-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.47.0](service/computeoptimizer/CHANGELOG.md#v1470-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/datapipeline`: [v1.30.0](service/datapipeline/CHANGELOG.md#v1300-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.37.0](service/directoryservice/CHANGELOG.md#v1370-2025-08-27)
  * **Feature**: Add APIs for CA AutoEnrollment support: DescribeCAEnrollmentPolicy, EnableCAEnrollmentPolicy and DisableCAEnrollmentPolicy.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.73.0](service/eks/CHANGELOG.md#v1730-2025-08-27)
  * **Feature**: Add support for on-demand refresh of EKS cluster insights
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.50.0](service/elasticache/CHANGELOG.md#v1500-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/evidently`: [v1.28.0](service/evidently/CHANGELOG.md#v1280-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/frauddetector`: [v1.40.0](service/frauddetector/CHANGELOG.md#v1400-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/inspector`: [v1.30.0](service/inspector/CHANGELOG.md#v1300-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.69.0](service/iot/CHANGELOG.md#v1690-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.31.0](service/iotfleetwise/CHANGELOG.md#v1310-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.53.0](service/iotwireless/CHANGELOG.md#v1530-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.21.0](service/ivschat/CHANGELOG.md#v1210-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.29.0](service/ivsrealtime/CHANGELOG.md#v1290-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kafkaconnect`: [v1.27.0](service/kafkaconnect/CHANGELOG.md#v1270-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.32.0](service/kinesisvideo/CHANGELOG.md#v1320-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideomedia`: [v1.27.0](service/kinesisvideomedia/CHANGELOG.md#v1270-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.45.0](service/kms/CHANGELOG.md#v1450-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.45.0](service/lakeformation/CHANGELOG.md#v1450-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lexmodelbuildingservice`: [v1.33.0](service/lexmodelbuildingservice/CHANGELOG.md#v1330-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/marketplacereporting`: [v1.6.0](service/marketplacereporting/CHANGELOG.md#v160-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.20.0](service/medicalimaging/CHANGELOG.md#v1200-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.37.0](service/mgn/CHANGELOG.md#v1370-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/migrationhubconfig`: [v1.30.0](service/migrationhubconfig/CHANGELOG.md#v1300-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.41.0](service/neptune/CHANGELOG.md#v1410-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.21.0](service/neptunegraph/CHANGELOG.md#v1210-2025-08-27)
  * **Feature**: Add StartGraph and StopGraph operations to Neptune Analytics
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.35.0](service/omics/CHANGELOG.md#v1350-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.23.0](service/paymentcryptographydata/CHANGELOG.md#v1230-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.45.0](service/personalize/CHANGELOG.md#v1450-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.35.0](service/pi/CHANGELOG.md#v1350-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.11.0](service/qapps/CHANGELOG.md#v1110-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/qldbsession`: [v1.30.0](service/qldbsession/CHANGELOG.md#v1300-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.58.0](service/redshift/CHANGELOG.md#v1580-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/robomaker`: [v1.35.0](service/robomaker/CHANGELOG.md#v1350-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/s3tables`: [v1.10.0](service/s3tables/CHANGELOG.md#v1100-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.213.0](service/sagemaker/CHANGELOG.md#v12130-2025-08-27)
  * **Feature**: This release adds support for AutoScaling on SageMaker HyperPod.
* `github.com/aws/aws-sdk-go-v2/service/schemas`: [v1.33.0](service/schemas/CHANGELOG.md#v1330-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/snowdevicemanagement`: [v1.25.0](service/snowdevicemanagement/CHANGELOG.md#v1250-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.38.0](service/sns/CHANGELOG.md#v1380-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.17.0](service/supplychain/CHANGELOG.md#v1170-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.40.0](service/textract/CHANGELOG.md#v1400-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.35.0](service/timestreamwrite/CHANGELOG.md#v1350-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/voiceid`: [v1.29.0](service/voiceid/CHANGELOG.md#v1290-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/vpclattice`: [v1.18.0](service/vpclattice/CHANGELOG.md#v1180-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/workdocs`: [v1.30.0](service/workdocs/CHANGELOG.md#v1300-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/workmail`: [v1.35.0](service/workmail/CHANGELOG.md#v1350-2025-08-27)
  * **Feature**: Remove incorrect endpoint tests

# Release (2025-08-26)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.42.0](service/appconfig/CHANGELOG.md#v1420-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/appmesh`: [v1.34.0](service/appmesh/CHANGELOG.md#v1340-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.38.0](service/apprunner/CHANGELOG.md#v1380-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.22.0](service/arczonalshift/CHANGELOG.md#v1220-2025-08-26)
  * **Feature**: This release adds new API options to enable allowed windows and multiple alarms for practice runs.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol`: [v1.4.0](service/bedrockagentcorecontrol/CHANGELOG.md#v140-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.31.0](service/cleanrooms/CHANGELOG.md#v1310-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.49.0](service/cloudwatch/CHANGELOG.md#v1490-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codecommit`: [v1.32.0](service/codecommit/CHANGELOG.md#v1320-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.34.0](service/codestarconnections/CHANGELOG.md#v1340-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/comprehendmedical`: [v1.31.0](service/comprehendmedical/CHANGELOG.md#v1310-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/connectcontactlens`: [v1.32.0](service/connectcontactlens/CHANGELOG.md#v1320-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.35.0](service/connectparticipant/CHANGELOG.md#v1350-2025-08-26)
  * **Feature**: Amazon Connect Participant Service: Remove unused fields from WebRTCConnection
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.13.0](service/controlcatalog/CHANGELOG.md#v1130-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.54.0](service/datasync/CHANGELOG.md#v1540-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.34.0](service/dlm/CHANGELOG.md#v1340-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.35.0](service/drs/CHANGELOG.md#v1350-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.247.0](service/ec2/CHANGELOG.md#v12470-2025-08-26)
  * **Feature**: Add new APIs for viewing how your shared AMIs are used by other accounts, and identify resources in your account that are dependent on particular AMIs
* `github.com/aws/aws-sdk-go-v2/service/elastictranscoder`: [v1.32.0](service/elastictranscoder/CHANGELOG.md#v1320-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/evs`: [v1.4.0](service/evs/CHANGELOG.md#v140-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.33.0](service/finspace/CHANGELOG.md#v1330-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.46.0](service/gamelift/CHANGELOG.md#v1460-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/georoutes`: [v1.6.0](service/georoutes/CHANGELOG.md#v160-2025-08-26)
  * **Feature**: Added RouteFerryNotice PotentialViolatedVehicleRestrictionUsage value for CalculateRoutes. This value indicates when the Route is potentially forbidden for the given vehicle profile.
* `github.com/aws/aws-sdk-go-v2/service/glacier`: [v1.31.0](service/glacier/CHANGELOG.md#v1310-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.34.0](service/globalaccelerator/CHANGELOG.md#v1340-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/greengrass`: [v1.32.0](service/greengrass/CHANGELOG.md#v1320-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/identitystore`: [v1.32.0](service/identitystore/CHANGELOG.md#v1320-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.46.0](service/imagebuilder/CHANGELOG.md#v1460-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotjobsdataplane`: [v1.29.0](service/iotjobsdataplane/CHANGELOG.md#v1290-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotsecuretunneling`: [v1.33.0](service/iotsecuretunneling/CHANGELOG.md#v1330-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.29.0](service/iottwinmaker/CHANGELOG.md#v1290-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.43.0](service/kafka/CHANGELOG.md#v1430-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.19.0](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v1190-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lookoutvision`: [v1.32.0](service/lookoutvision/CHANGELOG.md#v1320-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.25.0](service/m2/CHANGELOG.md#v1250-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/migrationhub`: [v1.30.0](service/migrationhub/CHANGELOG.md#v1300-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/migrationhubrefactorspaces`: [v1.25.0](service/migrationhubrefactorspaces/CHANGELOG.md#v1250-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mq`: [v1.33.0](service/mq/CHANGELOG.md#v1330-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/neptunedata`: [v1.15.0](service/neptunedata/CHANGELOG.md#v1150-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorscep`: [v1.9.0](service/pcaconnectorscep/CHANGELOG.md#v190-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/personalizeevents`: [v1.30.0](service/personalizeevents/CHANGELOG.md#v1300-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.39.0](service/pinpoint/CHANGELOG.md#v1390-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.53.0](service/polly/CHANGELOG.md#v1530-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ram`: [v1.34.0](service/ram/CHANGELOG.md#v1340-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.26.0](service/rbin/CHANGELOG.md#v1260-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.32.0](service/rdsdata/CHANGELOG.md#v1320-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.21.0](service/resourceexplorer2/CHANGELOG.md#v1210-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.57.0](service/route53/CHANGELOG.md#v1570-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycluster`: [v1.28.0](service/route53recoverycluster/CHANGELOG.md#v1280-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial`: [v1.19.0](service/sagemakergeospatial/CHANGELOG.md#v1190-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.39.0](service/secretsmanager/CHANGELOG.md#v1390-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.63.0](service/securityhub/CHANGELOG.md#v1630-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.35.0](service/servicecatalogappregistry/CHANGELOG.md#v1350-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/signer`: [v1.31.0](service/signer/CHANGELOG.md#v1310-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/socialmessaging`: [v1.7.0](service/socialmessaging/CHANGELOG.md#v170-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.64.0](service/ssm/CHANGELOG.md#v1640-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.24.0](service/ssmsap/CHANGELOG.md#v1240-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.34.0](service/ssooidc/CHANGELOG.md#v1340-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/tnb`: [v1.18.0](service/tnb/CHANGELOG.md#v1180-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.65.0](service/transfer/CHANGELOG.md#v1650-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/trustedadvisor`: [v1.13.0](service/trustedadvisor/CHANGELOG.md#v1130-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/wafregional`: [v1.30.0](service/wafregional/CHANGELOG.md#v1300-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.63.0](service/workspaces/CHANGELOG.md#v1630-2025-08-26)
  * **Feature**: Remove incorrect endpoint tests

# Release (2025-08-25.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/opsworks`: [v1.31.0](service/opsworks/CHANGELOG.md#v1310-2025-08-252)
  * **Feature**: Mark service/opsworks and service/opsworkscm as deprecated. These services are no longer available for use.
* `github.com/aws/aws-sdk-go-v2/service/opsworkscm`: [v1.33.0](service/opsworkscm/CHANGELOG.md#v1330-2025-08-252)
  * **Feature**: Mark service/opsworks and service/opsworkscm as deprecated. These services are no longer available for use.

# Release (2025-08-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.37.0](service/acm/CHANGELOG.md#v1370-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/aiops`: [v1.6.0](service/aiops/CHANGELOG.md#v160-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.50.0](service/appflow/CHANGELOG.md#v1500-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.51.0](service/appsync/CHANGELOG.md#v1510-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.55.0](service/athena/CHANGELOG.md#v1550-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.58.0](service/autoscaling/CHANGELOG.md#v1580-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.79](service/b2bi/CHANGELOG.md#v100-preview79-2025-08-25)
  * **Feature**: Updated APIs to support custom validation rules.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.45.0](service/bedrock/CHANGELOG.md#v1450-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.50.0](service/bedrockagent/CHANGELOG.md#v1500-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation`: [v1.9.0](service/bedrockdataautomation/CHANGELOG.md#v190-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomationruntime`: [v1.7.0](service/bedrockdataautomationruntime/CHANGELOG.md#v170-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.37.0](service/braket/CHANGELOG.md#v1370-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.14.0](service/chatbot/CHANGELOG.md#v1140-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.26.0](service/chimesdkmediapipelines/CHANGELOG.md#v1260-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging`: [v1.31.0](service/chimesdkmessaging/CHANGELOG.md#v1310-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudcontrol`: [v1.28.0](service/cloudcontrol/CHANGELOG.md#v1280-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.65.0](service/cloudformation/CHANGELOG.md#v1650-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudsearch`: [v1.31.0](service/cloudsearch/CHANGELOG.md#v1310-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudtraildata`: [v1.16.0](service/cloudtraildata/CHANGELOG.md#v1160-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchevents`: [v1.32.0](service/cloudwatchevents/CHANGELOG.md#v1320-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.57.0](service/cloudwatchlogs/CHANGELOG.md#v1570-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.38.0](service/codeartifact/CHANGELOG.md#v1380-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codegurusecurity`: [v1.16.3](service/codegurusecurity/CHANGELOG.md#v1163-2025-08-25)
  * **Documentation**: Documentation update to notify users of the discontinuation of Amazon CodeGuru Security.
* `github.com/aws/aws-sdk-go-v2/service/codestarnotifications`: [v1.31.0](service/codestarnotifications/CHANGELOG.md#v1310-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.34.0](service/connectparticipant/CHANGELOG.md#v1340-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.26.0](service/controltower/CHANGELOG.md#v1260-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/costandusagereportservice`: [v1.33.0](service/costandusagereportservice/CHANGELOG.md#v1330-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.39.0](service/datazone/CHANGELOG.md#v1390-2025-08-25)
  * **Feature**: Releasing the following features - Asset classification that lets users use restricted terms for classifying assets if they have the right permissions. Also adding a new enum value "Moving" to project status.
* `github.com/aws/aws-sdk-go-v2/service/dax`: [v1.28.0](service/dax/CHANGELOG.md#v1280-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.35.0](service/devicefarm/CHANGELOG.md#v1350-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/devopsguru`: [v1.39.0](service/devopsguru/CHANGELOG.md#v1390-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.37.0](service/directconnect/CHANGELOG.md#v1370-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.19.0](service/docdbelastic/CHANGELOG.md#v1190-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.246.0](service/ec2/CHANGELOG.md#v12460-2025-08-25)
  * **Feature**: Added IPv6 support for AWS Client VPN.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.72.0](service/eks/CHANGELOG.md#v1720-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.39.0](service/emrcontainers/CHANGELOG.md#v1390-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.33.0](service/finspacedata/CHANGELOG.md#v1330-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/forecast`: [v1.41.0](service/forecast/CHANGELOG.md#v1410-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.61.0](service/fsx/CHANGELOG.md#v1610-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.37.0](service/groundstation/CHANGELOG.md#v1370-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/health`: [v1.34.0](service/health/CHANGELOG.md#v1340-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotdataplane`: [v1.32.0](service/iotdataplane/CHANGELOG.md#v1320-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotfleethub`: [v1.29.0](service/iotfleethub/CHANGELOG.md#v1290-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.51.0](service/iotsitewise/CHANGELOG.md#v1510-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.60.0](service/kendra/CHANGELOG.md#v1600-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.23.0](service/keyspaces/CHANGELOG.md#v1230-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalytics`: [v1.30.0](service/kinesisanalytics/CHANGELOG.md#v1300-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia`: [v1.32.0](service/kinesisvideoarchivedmedia/CHANGELOG.md#v1320-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.77.0](service/lambda/CHANGELOG.md#v1770-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.56.0](service/lexmodelsv2/CHANGELOG.md#v1560-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lexruntimeservice`: [v1.29.0](service/lexruntimeservice/CHANGELOG.md#v1290-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/licensemanager`: [v1.36.0](service/licensemanager/CHANGELOG.md#v1360-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.35.0](service/lookoutequipment/CHANGELOG.md#v1350-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.17.0](service/mailmanager/CHANGELOG.md#v1170-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.36.0](service/marketplacecatalog/CHANGELOG.md#v1360-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.82.0](service/mediaconvert/CHANGELOG.md#v1820-2025-08-25)
  * **Feature**: This release adds support for input rendition selection for HLS input, adds new Share API to enable sharing jobs with AWS Support for support investigations, and adds INCLUDE_AS_TS to iFrameOnlyManifest setting for HLS outputs.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagevod`: [v1.39.0](service/mediapackagevod/CHANGELOG.md#v1390-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mediastore`: [v1.29.0](service/mediastore/CHANGELOG.md#v1290-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.26.0](service/migrationhubstrategy/CHANGELOG.md#v1260-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/odb`: [v1.4.0](service/odb/CHANGELOG.md#v140-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.25.0](service/opensearchserverless/CHANGELOG.md#v1250-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/opsworkscm`: [v1.32.0](service/opsworkscm/CHANGELOG.md#v1320-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.56.0](service/outposts/CHANGELOG.md#v1560-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorad`: [v1.15.0](service/pcaconnectorad/CHANGELOG.md#v1150-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.32.0](service/personalizeruntime/CHANGELOG.md#v1320-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.33.0](service/qbusiness/CHANGELOG.md#v1330-2025-08-25)
  * **Feature**: The Amazon Q Business GetDocumentContent operation now supports retrieval of the extracted text content in JSON format.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.31.0](service/redshiftserverless/CHANGELOG.md#v1310-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/repostspace`: [v1.14.0](service/repostspace/CHANGELOG.md#v1140-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.34.0](service/resiliencehub/CHANGELOG.md#v1340-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/resourcegroupstaggingapi`: [v1.30.0](service/resourcegroupstaggingapi/CHANGELOG.md#v1300-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sagemakeredge`: [v1.30.0](service/sagemakeredge/CHANGELOG.md#v1300-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.34.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1340-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.37.0](service/sagemakerruntime/CHANGELOG.md#v1370-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/serverlessapplicationrepository`: [v1.29.0](service/serverlessapplicationrepository/CHANGELOG.md#v1290-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.38.0](service/servicecatalog/CHANGELOG.md#v1380-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.39.0](service/sfn/CHANGELOG.md#v1390-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/shield`: [v1.34.0](service/shield/CHANGELOG.md#v1340-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.35.0](service/snowball/CHANGELOG.md#v1350-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.42.1](service/sqs/CHANGELOG.md#v1421-2025-08-25)
  * **Documentation**: Documentation update for Amazon SQS Supports Large Payload Message feature
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.35.0](service/ssoadmin/CHANGELOG.md#v1350-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.42.0](service/storagegateway/CHANGELOG.md#v1420-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.31.0](service/support/CHANGELOG.md#v1310-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/supportapp`: [v1.18.0](service/supportapp/CHANGELOG.md#v1180-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.16.0](service/taxsettings/CHANGELOG.md#v1160-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.16.0](service/timestreaminfluxdb/CHANGELOG.md#v1160-2025-08-25)
  * **Feature**: Add MAINTENANCE status for DbInstance and DbCluster
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.52.0](service/transcribe/CHANGELOG.md#v1520-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.31.0](service/transcribestreaming/CHANGELOG.md#v1310-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/translate`: [v1.33.0](service/translate/CHANGELOG.md#v1330-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.39.0](service/wellarchitected/CHANGELOG.md#v1390-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.20.0](service/workspacesthinclient/CHANGELOG.md#v1200-2025-08-25)
  * **Feature**: Remove incorrect endpoint tests

# Release (2025-08-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.28.0](service/account/CHANGELOG.md#v1280-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.35.0](service/apigateway/CHANGELOG.md#v1350-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/apigatewayv2`: [v1.32.0](service/apigatewayv2/CHANGELOG.md#v1320-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.78](service/b2bi/CHANGELOG.md#v100-preview78-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/clouddirectory`: [v1.29.0](service/clouddirectory/CHANGELOG.md#v1290-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.46.0](service/codepipeline/CHANGELOG.md#v1460-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cognitosync`: [v1.28.0](service/cognitosync/CHANGELOG.md#v1280-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.39.0](service/dataexchange/CHANGELOG.md#v1390-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.46.0](service/docdb/CHANGELOG.md#v1460-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancing`: [v1.33.0](service/elasticloadbalancing/CHANGELOG.md#v1330-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.36.0](service/emrserverless/CHANGELOG.md#v1360-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.41.0](service/firehose/CHANGELOG.md#v1410-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.34.0](service/healthlake/CHANGELOG.md#v1340-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotanalytics`: [v1.31.0](service/iotanalytics/CHANGELOG.md#v1310-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/launchwizard`: [v1.13.0](service/launchwizard/CHANGELOG.md#v1130-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.49.0](service/location/CHANGELOG.md#v1490-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.49.0](service/macie2/CHANGELOG.md#v1490-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/marketplacecommerceanalytics`: [v1.29.0](service/marketplacecommerceanalytics/CHANGELOG.md#v1290-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.81.0](service/medialive/CHANGELOG.md#v1810-2025-08-22)
  * **Feature**: AWS Elemental MediaLive now has a field called "SubtitleRows" for controlling subtitle row count for DVB-Sub and Burn-In captions outputs
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.31.0](service/memorydb/CHANGELOG.md#v1310-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/migrationhuborchestrator`: [v1.18.0](service/migrationhuborchestrator/CHANGELOG.md#v1180-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/networkmonitor`: [v1.12.0](service/networkmonitor/CHANGELOG.md#v1120-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.44.0](service/organizations/CHANGELOG.md#v1440-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.23.0](service/paymentcryptography/CHANGELOG.md#v1230-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.39.0](service/pricing/CHANGELOG.md#v1390-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/proton`: [v1.38.0](service/proton/CHANGELOG.md#v1380-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.22.0](service/qconnect/CHANGELOG.md#v1220-2025-08-22)
  * **Feature**: Releasing model ID support for UpdateAIPrompt
* `github.com/aws/aws-sdk-go-v2/service/qldb`: [v1.30.0](service/qldb/CHANGELOG.md#v1300-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.103.3](service/rds/CHANGELOG.md#v11033-2025-08-22)
  * **Documentation**: Updates Amazon RDS documentation for Db2 read-only replicas.
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.37.0](service/redshiftdata/CHANGELOG.md#v1370-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.21.0](service/rolesanywhere/CHANGELOG.md#v1210-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/route53recoveryreadiness`: [v1.26.0](service/route53recoveryreadiness/CHANGELOG.md#v1260-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.28.0](service/rum/CHANGELOG.md#v1280-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.212.0](service/sagemaker/CHANGELOG.md#v12120-2025-08-22)
  * **Feature**: Launch SageMaker Notebook Instances support for AL2023 along with P6-B200 instance type and Rootless Docker support for SageMaker Studio.
* `github.com/aws/aws-sdk-go-v2/service/sagemakera2iruntime`: [v1.32.0](service/sagemakera2iruntime/CHANGELOG.md#v1320-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sagemakermetrics`: [v1.18.0](service/sagemakermetrics/CHANGELOG.md#v1180-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.39.3](service/servicediscovery/CHANGELOG.md#v1393-2025-08-22)
  * **Documentation**: Updating SDK examples after launch of shared AWS Cloud Map namespaces
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.19.0](service/simspaceweaver/CHANGELOG.md#v1190-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.42.0](service/sqs/CHANGELOG.md#v1420-2025-08-22)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.40.0](service/synthetics/CHANGELOG.md#v1400-2025-08-22)
  * **Feature**: Added multi browser support for synthetics canaries, Increased ephemeral storage limit from 5GB to 10GB
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.67.0](service/wafv2/CHANGELOG.md#v1670-2025-08-22)
  * **Feature**: test and verified, safe to release

# Release (2025-08-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.19.0](feature/s3/manager/CHANGELOG.md#v1190-2025-08-21)
  * **Feature**: Add control for request checksum calculation.
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.44.0](service/accessanalyzer/CHANGELOG.md#v1440-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.39.0](service/amp/CHANGELOG.md#v1390-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/apigatewaymanagementapi`: [v1.28.0](service/apigatewaymanagementapi/CHANGELOG.md#v1280-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/appfabric`: [v1.16.0](service/appfabric/CHANGELOG.md#v1160-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.36.0](service/appintegrations/CHANGELOG.md#v1360-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.49.0](service/appstream/CHANGELOG.md#v1490-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/artifact`: [v1.13.0](service/artifact/CHANGELOG.md#v1130-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.45.0](service/auditmanager/CHANGELOG.md#v1450-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.47.0](service/backup/CHANGELOG.md#v1470-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/backupgateway`: [v1.25.0](service/backupgateway/CHANGELOG.md#v1250-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.49.0](service/bedrockagentruntime/CHANGELOG.md#v1490-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.25.0](service/billingconductor/CHANGELOG.md#v1250-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.53.0](service/cloudfront/CHANGELOG.md#v1530-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudhsm`: [v1.29.0](service/cloudhsm/CHANGELOG.md#v1290-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.53.0](service/cloudtrail/CHANGELOG.md#v1530-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentity`: [v1.33.0](service/cognitoidentity/CHANGELOG.md#v1330-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.40.0](service/comprehend/CHANGELOG.md#v1400-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.57.0](service/configservice/CHANGELOG.md#v1570-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.137.0](service/connect/CHANGELOG.md#v11370-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/connectcampaignsv2`: [v1.7.0](service/connectcampaignsv2/CHANGELOG.md#v170-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.30.0](service/connectcases/CHANGELOG.md#v1300-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.20.0](service/costoptimizationhub/CHANGELOG.md#v1200-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.52.0](service/customerprofiles/CHANGELOG.md#v1520-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.57.0](service/databasemigrationservice/CHANGELOG.md#v1570-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.21.0](service/deadline/CHANGELOG.md#v1210-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.36.0](service/directoryservice/CHANGELOG.md#v1360-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/directoryservicedata`: [v1.7.0](service/directoryservicedata/CHANGELOG.md#v170-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/dynamodbstreams`: [v1.30.0](service/dynamodbstreams/CHANGELOG.md#v1300-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ebs`: [v1.32.0](service/ebs/CHANGELOG.md#v1320-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.37.0](service/ecrpublic/CHANGELOG.md#v1370-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.63.2](service/ecs/CHANGELOG.md#v1632-2025-08-21)
  * **Documentation**: This is a documentation only release that adds additional information for the update-service request parameters.
* `github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk`: [v1.33.0](service/elasticbeanstalk/CHANGELOG.md#v1330-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.50.0](service/elasticloadbalancingv2/CHANGELOG.md#v1500-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/elasticsearchservice`: [v1.37.0](service/elasticsearchservice/CHANGELOG.md#v1370-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/forecastquery`: [v1.29.0](service/forecastquery/CHANGELOG.md#v1290-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/gameliftstreams`: [v1.6.0](service/gameliftstreams/CHANGELOG.md#v160-2025-08-21)
  * **Feature**: The default application in a stream group can now be changed at any time using UpdateStreamGroup to update the DefaultApplicationIdentifier.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.127.0](service/glue/CHANGELOG.md#v11270-2025-08-21)
  * **Feature**: Added support for preprocessing queries in Data Quality operations through new DataQualityGlueTable structure.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.31.0](service/grafana/CHANGELOG.md#v1310-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.41.0](service/greengrassv2/CHANGELOG.md#v1410-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.63.0](service/guardduty/CHANGELOG.md#v1630-2025-08-21)
  * **Feature**: Remove Pattern trait from email field
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.44.0](service/inspector2/CHANGELOG.md#v1440-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor`: [v1.36.0](service/iotdeviceadvisor/CHANGELOG.md#v1360-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotevents`: [v1.32.0](service/iotevents/CHANGELOG.md#v1320-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ioteventsdata`: [v1.29.0](service/ioteventsdata/CHANGELOG.md#v1290-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotthingsgraph`: [v1.30.0](service/iotthingsgraph/CHANGELOG.md#v1300-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.47.0](service/ivs/CHANGELOG.md#v1470-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideosignaling`: [v1.28.0](service/kinesisvideosignaling/CHANGELOG.md#v1280-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.19.0](service/kinesisvideowebrtcstorage/CHANGELOG.md#v1190-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lexruntimev2`: [v1.34.0](service/lexruntimev2/CHANGELOG.md#v1340-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.48.0](service/lightsail/CHANGELOG.md#v1480-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/lookoutmetrics`: [v1.36.0](service/lookoutmetrics/CHANGELOG.md#v1360-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.31.0](service/managedblockchain/CHANGELOG.md#v1310-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/marketplaceagreement`: [v1.11.0](service/marketplaceagreement/CHANGELOG.md#v1110-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.44.0](service/mediaconnect/CHANGELOG.md#v1440-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.81.0](service/mediaconvert/CHANGELOG.md#v1810-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mediapackage`: [v1.39.0](service/mediapackage/CHANGELOG.md#v1390-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.30.0](service/mediapackagev2/CHANGELOG.md#v1300-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.52.0](service/mediatailor/CHANGELOG.md#v1520-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.39.0](service/mwaa/CHANGELOG.md#v1390-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/observabilityadmin`: [v1.6.0](service/observabilityadmin/CHANGELOG.md#v160-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/panorama`: [v1.27.0](service/panorama/CHANGELOG.md#v1270-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pinpointemail`: [v1.28.0](service/pinpointemail/CHANGELOG.md#v1280-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.33.0](service/resourcegroups/CHANGELOG.md#v1330-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/route53profiles`: [v1.9.0](service/route53profiles/CHANGELOG.md#v190-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.40.0](service/route53resolver/CHANGELOG.md#v1400-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.33.0](service/s3outposts/CHANGELOG.md#v1330-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.24.0](service/securitylake/CHANGELOG.md#v1240-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/ssmcontacts`: [v1.30.2](service/ssmcontacts/CHANGELOG.md#v1302-2025-08-21)
  * **Documentation**: Doc-only updates for Incident Manager Contacts August 2025
* `github.com/aws/aws-sdk-go-v2/service/ssmquicksetup`: [v1.8.0](service/ssmquicksetup/CHANGELOG.md#v180-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.38.0](service/sts/CHANGELOG.md#v1380-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.15.0](service/timestreaminfluxdb/CHANGELOG.md#v1150-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.28.0](service/verifiedpermissions/CHANGELOG.md#v1280-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.32.0](service/wisdom/CHANGELOG.md#v1320-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.32.0](service/workspacesweb/CHANGELOG.md#v1320-2025-08-21)
  * **Feature**: Remove incorrect endpoint tests

# Release (2025-08-20)

## General Highlights
* **Bug Fix**: Remove unused deserialization code.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.37.0](service/bedrockruntime/CHANGELOG.md#v1370-2025-08-20)
  * **Feature**: Launch CountTokens API to allow token counting
* `github.com/aws/aws-sdk-go-v2/service/billing`: [v1.7.0](service/billing/CHANGELOG.md#v170-2025-08-20)
  * **Feature**: Clarify IPv4 and IPv6 endpoints
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.37.0](service/budgets/CHANGELOG.md#v1370-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.57.0](service/cognitoidentityprovider/CHANGELOG.md#v1570-2025-08-20)
  * **Feature**: This release adds support for the new Terms APIs which allow displaying Terms of Use and Privacy Policy on the Managed Login user-registration page.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.55.0](service/costexplorer/CHANGELOG.md#v1550-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.38.0](service/datazone/CHANGELOG.md#v1380-2025-08-20)
  * **Feature**: This release supports policy grant identifier for cloud formation integration
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.37.0](service/detective/CHANGELOG.md#v1370-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.49.0](service/dynamodb/CHANGELOG.md#v1490-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.40.0](service/efs/CHANGELOG.md#v1400-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.71.0](service/eks/CHANGELOG.md#v1710-2025-08-20)
  * **Feature**: EKS Add-ons Custom Namespace Support
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.47.0](service/iam/CHANGELOG.md#v1470-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.39.0](service/kinesis/CHANGELOG.md#v1390-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.36.0](service/kinesisanalyticsv2/CHANGELOG.md#v1360-2025-08-20)
  * **Feature**: Adds Key Management Service (KMS) support allowing customer-managed key (CMK) encryption for Flink application data.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.33.0](service/marketplaceentitlementservice/CHANGELOG.md#v1330-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/marketplacemetering`: [v1.33.0](service/marketplacemetering/CHANGELOG.md#v1330-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.39.0](service/networkmanager/CHANGELOG.md#v1390-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.24.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1240-2025-08-20)
  * **Feature**: This change added InternationalSendingEnbaled as part of describe/Update/Request phone number API response, and as part of update/Request phone number API request
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.31.0](service/route53recoverycontrolconfig/CHANGELOG.md#v1310-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.211.0](service/sagemaker/CHANGELOG.md#v12110-2025-08-20)
  * **Feature**: This release adds 1/ Launch ml.p5.4xlarge instance in Processing jobs, Training jobs and Training Plan 2/ Makes S3Uri to be required for S3FileSystem and S3FileSystemConfig.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.52.0](service/sesv2/CHANGELOG.md#v1520-2025-08-20)
  * **Feature**: Remove incorrect endpoint tests

# Release (2025-08-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.30.0](service/cleanrooms/CHANGELOG.md#v1300-2025-08-19)
  * **Feature**: Support error message configuration for analysis templates
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.245.0](service/ec2/CHANGELOG.md#v12450-2025-08-19)
  * **Feature**: Add support for "warning" volume status.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.52.0](service/polly/CHANGELOG.md#v1520-2025-08-19)
  * **Feature**: Added support for new output format - Opus.

# Release (2025-08-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.57.1](service/batch/CHANGELOG.md#v1571-2025-08-18)
  * **Documentation**: Added default_x86_64 and default_arm64 as values to the instanceTypes field.
* `github.com/aws/aws-sdk-go-v2/service/bcmdashboards`: [v1.0.0](service/bcmdashboards/CHANGELOG.md#v100-2025-08-18)
  * **Release**: New AWS service client module
  * **Feature**: Billing and Cost Management Dashboards enables users to create dashboards that combine multiple visualizations of cost and usage data. Users can create, manage, and share dashboards. Tags are also available for dashboards.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.136.0](service/connect/CHANGELOG.md#v11360-2025-08-18)
  * **Feature**: Amazon Connect Service Feature: Add support to enable multi-user in-app, web, and video calling.
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.33.0](service/connectparticipant/CHANGELOG.md#v1330-2025-08-18)
  * **Feature**: Amazon Connect Service Feature: Add support to enable multi-user in-app, web, and video calling.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.65.0](service/s3control/CHANGELOG.md#v1650-2025-08-18)
  * **Feature**: Adds support for Compute checksum functionality in Amazon S3 Batch Operations. You can now calculate checksums for a list of objects using supported algorithms in Amazon S3, without requiring a restore or download
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.210.0](service/sagemaker/CHANGELOG.md#v12100-2025-08-18)
  * **Feature**: Customer managed keys now available for volume encryption of SageMaker HyperPod clusters.

# Release (2025-08-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.38.0](service/amp/CHANGELOG.md#v1380-2025-08-15)
  * **Feature**: Add Resource-based Policy APIs for Amazon Prometheus
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.49.0](service/bedrockagent/CHANGELOG.md#v1490-2025-08-15)
  * **Feature**: This release adds support for saving Bedrock Flows while node configuration is still in progress, even if the Flow is not yet able to be invoked
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.126.0](service/glue/CHANGELOG.md#v11260-2025-08-15)
  * **Feature**: AWS Glue Zero ETL now supports On-demand snapshot load

# Release (2025-08-14)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/arcregionswitch`: [v1.2.0](service/arcregionswitch/CHANGELOG.md#v120-2025-08-14)
  * **Feature**: Endpoint rule test and documentation update.
* `github.com/aws/aws-sdk-go-v2/service/bcmrecommendedactions`: [v1.0.0](service/bcmrecommendedactions/CHANGELOG.md#v100-2025-08-14)
  * **Release**: New AWS service client module
  * **Feature**: Initial SDK release for AWS Billing and Cost Management Recommended Actions.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.36.0](service/directconnect/CHANGELOG.md#v1360-2025-08-14)
  * **Feature**: Added pagination support for DescribeHostedConnections, DescribeVirtualInterfaces, DescribeConnections, DescribeInterconnects, DescribeLags. Added asnLong support for BGP peer operations which supports a large range.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.48.0](service/dynamodb/CHANGELOG.md#v1480-2025-08-14)
  * **Feature**: This release 1/ Adds support for throttled keys mode for CloudWatch Contributor Insights, 2/ Adds throttling reasons to exceptions across dataplane APIs. 3/ Explicitly models ThrottlingException as a class in statically typed languages. Refer to the launch day blog post for more details.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.244.0](service/ec2/CHANGELOG.md#v12440-2025-08-14)
  * **Feature**: This release adds ModifyInstanceConnectEndpoint API to update configurations on existing EC2 Instance Connect Endpoints and improves IPv6 support through dualstack DNS names for EC2 Instance Connect Endpoints.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.60.0](service/fsx/CHANGELOG.md#v1600-2025-08-14)
  * **Feature**: Amazon FSx for NetApp ONTAP 2nd generation file systems now support decreasing SSD storage capacity.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.125.0](service/glue/CHANGELOG.md#v11250-2025-08-14)
  * **Feature**: AWS Glue now supports Trusted Identity Propagation.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.62.0](service/guardduty/CHANGELOG.md#v1620-2025-08-14)
  * **Feature**: Added support for entity lists.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.80.0](service/medialive/CHANGELOG.md#v1800-2025-08-14)
  * **Feature**: CMAF Ingest output groups in MediaLive can now accept one additional destination url for single pipeline channels and up to two additional destination urls for standard channels.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.11.0](service/pcs/CHANGELOG.md#v1110-2025-08-14)
  * **Feature**: Updated the regex pattern and description of iamInstanceProfileArn in the CreateComputeNodeGroup and UpdateComputeNodeGroup API actions. Name and path requirements apply to the ARN of the IAM role associated with the instance profile and not the ARN of the instance profile.
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.10.1](service/qapps/CHANGELOG.md#v1101-2025-08-14)
  * **Documentation**: Documentation update for Amazon Q Apps API Reference
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.39.0](service/servicediscovery/CHANGELOG.md#v1390-2025-08-14)
  * **Feature**: Added support for cross account through Id parameter overloading with ARN and allow owner account for some APIs instead of ARN
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.62.0](service/workspaces/CHANGELOG.md#v1620-2025-08-14)
  * **Feature**: New APIs introduced to import WorkSpaces BYOL image using a new process that leveraged EC2 Image Builder. WorkSpaces tests and fixes your image's compatibility issues and supports customized VM images.

# Release (2025-08-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.36.0](service/braket/CHANGELOG.md#v1360-2025-08-13)
  * **Feature**: Add support for Braket program sets.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.37.0](service/datazone/CHANGELOG.md#v1370-2025-08-13)
  * **Feature**: Adds support for account pools and project profile account decoupling
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.59.0](service/fsx/CHANGELOG.md#v1590-2025-08-13)
  * **Feature**: Add Dual-Stack support for Amazon FSx for OpenZFS file systems
* `github.com/aws/aws-sdk-go-v2/service/partnercentralselling`: [v1.10.0](service/partnercentralselling/CHANGELOG.md#v1100-2025-08-13)
  * **Feature**: Add Tagging Support for Opportunity resources
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.209.0](service/sagemaker/CHANGELOG.md#v12090-2025-08-13)
  * **Feature**: This release introduces compute quota for GPU, Trainium accelerators, vCPU, and vCPU memory utilization across teams in HyperPod clusters
* `github.com/aws/aws-sdk-go-v2/service/securityir`: [v1.8.0](service/securityir/CHANGELOG.md#v180-2025-08-13)
  * **Feature**: Added support for Organizational Unit-level Membership configuration and the ability to resume a cancelled membership.

# Release (2025-08-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backupsearch`: [v1.6.0](service/backupsearch/CHANGELOG.md#v160-2025-08-12)
  * **Feature**: Using recommended smithy trait to generate regional endpoints for Backup Search
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.66.0](service/codebuild/CHANGELOG.md#v1660-2025-08-12)
  * **Feature**: AWS CodeBuild now supports PullRequestBuildPolicy in webhook object.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.243.0](service/ec2/CHANGELOG.md#v12430-2025-08-12)
  * **Feature**: Release to allow route table association with a PublicIpv4Pool.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.43.0](service/organizations/CHANGELOG.md#v1430-2025-08-12)
  * **Feature**: This release introduces 2 new APIs in Organizations: 1. ListAccountsWithInvalidEffectivePolicy 2. ListEffectivePolicyValidationErrors
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.208.0](service/sagemaker/CHANGELOG.md#v12080-2025-08-12)
  * **Feature**: IAM Identity Center trusted identity propagation is now supported in SageMaker Studio.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.51.0](service/transcribe/CHANGELOG.md#v1510-2025-08-12)
  * **Feature**: AWS HealthScribe now supports specifying preferred patient pronouns through the MedicalScribeContext parameter for use in the generated clinical notes.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.30.0](service/transcribestreaming/CHANGELOG.md#v1300-2025-08-12)
  * **Feature**: AWS HealthScribe now supports specifying preferred patient pronouns through the MedicalScribeContext parameter for use in the generated clinical notes.

# Release (2025-08-11)

## General Highlights
* **Feature**: Add support for configuring per-service Options via callback on global config.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.44.0](service/bedrock/CHANGELOG.md#v1440-2025-08-11)
  * **Feature**: This release includes model updates and enhanced SDK documentation for union fields in automated reasoning policy components. Added docs cover policy definitions, mutations (add/update for rules/types/variables), build assets, workflow sources, test results, and tag exception handling.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.56.0](service/cognitoidentityprovider/CHANGELOG.md#v1560-2025-08-11)
  * **Feature**: Remove SigV4 auth requirement for GetTokensFromRefreshToken
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.135.0](service/connect/CHANGELOG.md#v11350-2025-08-11)
  * **Feature**: Updating SearchUserHierarchyGroups API
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.20.0](service/deadline/CHANGELOG.md#v1200-2025-08-11)
  * **Feature**: Adds support for Wait and Save feature in service-managed fleets
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.242.0](service/ec2/CHANGELOG.md#v12420-2025-08-11)
  * **Feature**: This release adds AvailabilityZoneId support for CreateVolume, DescribeVolume, LaunchTemplates, RunInstances, DescribeInstances, CreateDefaultSubnet, SpotInstances, and CreateDefaultSubnet APIs.
* `github.com/aws/aws-sdk-go-v2/service/evs`: [v1.3.0](service/evs/CHANGELOG.md#v130-2025-08-11)
  * **Documentation**: Update for general availability of Amazon Elastic VMware Service (EVS).
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.76.0](service/lambda/CHANGELOG.md#v1760-2025-08-11)
  * **Documentation**: Doc-only update for Lambda that updates the maximum payload size for response streaming invocations to 200 MB.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.92.0](service/quicksight/CHANGELOG.md#v1920-2025-08-11)
  * **Feature**: Add RowAxisDisplayOptions and ColumnAxisDisplayOptions to HeatMapConfiguration, add Actions to PluginVisual, increase limit for CalculatedFields list
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.34.0](service/ssoadmin/CHANGELOG.md#v1340-2025-08-11)
  * **Feature**: Added support for managing user background session for applications

# Release (2025-08-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.14.0](service/applicationsignals/CHANGELOG.md#v1140-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/backupsearch`: [v1.4.0](service/backupsearch/CHANGELOG.md#v140-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator`: [v1.8.0](service/bcmpricingcalculator/CHANGELOG.md#v180-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/billing`: [v1.5.0](service/billing/CHANGELOG.md#v150-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.134.0](service/connect/CHANGELOG.md#v11340-2025-08-08)
  * **Feature**: This release adds a new API GetContactMetrics for Amazon Connect.
* `github.com/aws/aws-sdk-go-v2/service/dsql`: [v1.8.0](service/dsql/CHANGELOG.md#v180-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/gameliftstreams`: [v1.4.0](service/gameliftstreams/CHANGELOG.md#v140-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.42.0](service/inspector2/CHANGELOG.md#v1420-2025-08-08)
  * **Feature**: Add CVSSV4 to Vulnerability Search API and update enable/disable account id list length to 5
* `github.com/aws/aws-sdk-go-v2/service/invoicing`: [v1.5.0](service/invoicing/CHANGELOG.md#v150-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/iotdataplane`: [v1.30.0](service/iotdataplane/CHANGELOG.md#v1300-2025-08-08)
  * **Feature**: Adding DeleteConnection API to IoT Data Plane
* `github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations`: [v1.4.0](service/iotmanagedintegrations/CHANGELOG.md#v140-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/keyspacesstreams`: [v1.3.0](service/keyspacesstreams/CHANGELOG.md#v130-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/mpa`: [v1.3.0](service/mpa/CHANGELOG.md#v130-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/networkflowmonitor`: [v1.7.0](service/networkflowmonitor/CHANGELOG.md#v170-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/notifications`: [v1.5.0](service/notifications/CHANGELOG.md#v150-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/notificationscontacts`: [v1.4.0](service/notificationscontacts/CHANGELOG.md#v140-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/partnercentralselling`: [v1.8.0](service/partnercentralselling/CHANGELOG.md#v180-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/s3vectors`: [v1.3.0](service/s3vectors/CHANGELOG.md#v130-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.206.0](service/sagemaker/CHANGELOG.md#v12060-2025-08-08)
  * **Feature**: Adds support for GB200 UltraServers in Amazon SageMaker training jobs, training plans, and HyperPod clusters
* `github.com/aws/aws-sdk-go-v2/service/securityir`: [v1.6.0](service/securityir/CHANGELOG.md#v160-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.49.1](service/transcribe/CHANGELOG.md#v1491-2025-08-08)
  * **Documentation**: Update documentation to use key ARN only in OutputEncryptionKMSKeyId request parameter
* `github.com/aws/aws-sdk-go-v2/service/workspacesinstances`: [v1.3.0](service/workspacesinstances/CHANGELOG.md#v130-2025-08-08)
  * **Feature**: Removed incorrect endpoint tests

# Release (2025-08-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.56.1](service/batch/CHANGELOG.md#v1561-2025-08-07)
  * **Documentation**: This feature allows customers to use AWS Batch with Linux with ARM64 CPU Architecture with Fargate Spot compute support.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.43.0](service/bedrock/CHANGELOG.md#v1430-2025-08-07)
  * **Feature**: Support configurable bearer token through the environment via AWS_BEARER_TOKEN_BEDROCK.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.35.0](service/bedrockruntime/CHANGELOG.md#v1350-2025-08-07)
  * **Feature**: Support configurable bearer token through the environment via AWS_BEARER_TOKEN_BEDROCK.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.51.0](service/cloudfront/CHANGELOG.md#v1510-2025-08-07)
  * **Feature**: Added new viewer security policy, TLSv1.3_2025, for CloudFront.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.64.0](service/codebuild/CHANGELOG.md#v1640-2025-08-07)
  * **Feature**: AWS CodeBuild now supports comment-based pull request control.
* `github.com/aws/aws-sdk-go-v2/service/gameliftstreams`: [v1.3.1](service/gameliftstreams/CHANGELOG.md#v131-2025-08-07)
  * **Documentation**: Adds Proton 9.0-2 to the list of runtime environment options available when creating an Amazon GameLift Streams application
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.123.0](service/glue/CHANGELOG.md#v11230-2025-08-07)
  * **Feature**: AWS Glue Data Catalog now supports Iceberg Optimization settings at the Catalog level, and supports new options to control the optimization job run rate.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.60.0](service/guardduty/CHANGELOG.md#v1600-2025-08-07)
  * **Feature**: Added support for VPC owner account ID associated with DNS request in the GuardDuty finding.

# Release (2025-08-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.47.1](service/appstream/CHANGELOG.md#v1471-2025-08-06)
  * **Documentation**: Added support for G6 instances
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.35.0](service/budgets/CHANGELOG.md#v1350-2025-08-06)
  * **Feature**: Adds support for billing views. Billing views let you control access to cost and usage data through an AWS resource, streamlining the process of sharing cost and usage data across account boundaries. With this release, you can now create and view budgets based on billing views.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.241.0](service/ec2/CHANGELOG.md#v12410-2025-08-06)
  * **Feature**: Mark Elastic Inference Accelerators and Elastic Graphics Processor parameters as deprecated on the RunInstances and LaunchTemplate APIs.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.37.1](service/networkmanager/CHANGELOG.md#v1371-2025-08-06)
  * **Bug Fix**: **BREAKING CHANGE**: The fields on VpcOptions have been changed from `bool` to `*bool`. Before this change, the fields were incorrectly marked as having default values of false by the service, which made it functionally impossible for users to set them false in an API call.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.23.0](service/opensearchserverless/CHANGELOG.md#v1230-2025-08-06)
  * **Feature**: Features: add Index APIs in OpenSearchServerless to support managed semantic enrichment
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.31.0](service/qbusiness/CHANGELOG.md#v1310-2025-08-06)
  * **Feature**: Amazon Q Business now supports the GetDocumentContent() API that enables customers to securely access the source documents through clickable citation links at query time

# Release (2025-08-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.42.0](service/bedrock/CHANGELOG.md#v1420-2025-08-05)
  * **Feature**: This release introduces Automated Reasoning checks for Amazon Bedrock Guardrails. The feature adds new APIs for policy building, refinement, version management, and testing. Guardrail APIs now support Automated Reasoning policy configuration and validation output.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.34.0](service/bedrockruntime/CHANGELOG.md#v1340-2025-08-05)
  * **Feature**: This release adds support for Automated Reasoning checks output models for the Amazon Bedrock Guardrails ApplyGuardrail API.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.69.0](service/eks/CHANGELOG.md#v1690-2025-08-05)
  * **Feature**: Add support for deletion protection on EKS clusters
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.102.0](service/rds/CHANGELOG.md#v11020-2025-08-05)
  * **Feature**: Adds a new Aurora Serverless v2 attribute to the DBCluster resource to expose the platform version. Also updates the attribute to be part of both the engine version and platform version descriptions.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.205.0](service/sagemaker/CHANGELOG.md#v12050-2025-08-05)
  * **Feature**: Add support for SageMaker Hyperpod continuous scaling and custom AMI; Introduce new APIs: ListClusterEvents, DescribeClusterEvent, BatchAddClusterNodes

# Release (2025-08-04)

## General Highlights
* **Feature**: Support configurable auth scheme preferences in service clients via AWS_AUTH_SCHEME_PREFERENCE in the environment, auth_scheme_preference in the config file, and through in-code settings on LoadDefaultConfig and client constructor methods.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentcore`: [v1.2.0](service/bedrockagentcore/CHANGELOG.md#v120-2025-08-04)
  * **Feature**: Remove superfluous field from API
* `github.com/aws/aws-sdk-go-v2/service/codeconnections`: [v1.8.0](service/codeconnections/CHANGELOG.md#v180-2025-08-04)
  * **Feature**: New integration with Azure DevOps provider type.
* `github.com/aws/aws-sdk-go-v2/service/evs`: [v1.2.0](service/evs/CHANGELOG.md#v120-2025-08-04)
  * **Feature**: TagResource API now throws ServiceQuotaExceededException when the number of tags on the Amazon EVS resource exceeds the maximum allowed. TooManyTagsException is deprecated.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.49.0](service/iotsitewise/CHANGELOG.md#v1490-2025-08-04)
  * **Feature**: Support Interface for IoT SiteWise Asset Modeling
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.204.0](service/sagemaker/CHANGELOG.md#v12040-2025-08-04)
  * **Feature**: This release adds the ability for customers to attach and detach their EBS volumes to EKS-orchestrated HyperPod cluster nodes.

# Release (2025-08-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.41.2](service/acmpca/CHANGELOG.md#v1412-2025-08-01)
  * **Documentation**: Doc-only update to add more information to GetCertificate action.
* `github.com/aws/aws-sdk-go-v2/service/aiops`: [v1.3.0](service/aiops/CHANGELOG.md#v130-2025-08-01)
  * **Feature**: This release includes fix for InvestigationGroup timestamp conversion issue.
* `github.com/aws/aws-sdk-go-v2/service/arcregionswitch`: [v1.0.0](service/arcregionswitch/CHANGELOG.md#v100-2025-08-01)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for Region switch
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.42.0](service/auditmanager/CHANGELOG.md#v1420-2025-08-01)
  * **Feature**: Added a note to Framework APIs (CreateAssessmentFramework, GetAssessmentFramework, UpdateAssessmentFramework) clarifying that the Controls object returns a partial response when called through Framework APIs. Added documentation that the Framework's controlSources parameter is no longer supported.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.45.0](service/lightsail/CHANGELOG.md#v1450-2025-08-01)
  * **Feature**: This release adds support for the Asia Pacific (Jakarta) (ap-southeast-3) Region.
* `github.com/aws/aws-sdk-go-v2/service/observabilityadmin`: [v1.3.0](service/observabilityadmin/CHANGELOG.md#v130-2025-08-01)
  * **Feature**: CloudWatch Observability Admin adds the ability to enable telemetry on AWS resources such as Amazon VPCs (Flow Logs) in customers AWS Accounts and Organizations. The release introduces new APIs to manage telemetry rules, which define telemetry settings to be applied on AWS resources.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.8.0](service/pcs/CHANGELOG.md#v180-2025-08-01)
  * **Feature**: Add support for IPv6 Networking for Clusters.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.60.0](service/securityhub/CHANGELOG.md#v1600-2025-08-01)
  * **Feature**: Release new resource detail type CodeRepository
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.35.2](service/sns/CHANGELOG.md#v1352-2025-08-01)
  * **Documentation**: Amazon SNS support for Amazon SQS fair queues

# Release (2025-07-31)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.49.0](service/customerprofiles/CHANGELOG.md#v1490-2025-07-31)
  * **Feature**: The release updates standard profile with 2 new fields that supports account-level engagement. Updated APIs include CreateProfile, UpdateProfile, MergeProfiles, SearchProfiles, BatchGetProfile, GetSegmentMembership, CreateSegmentDefinition, CreateSegmentEstimate.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.239.0](service/ec2/CHANGELOG.md#v12390-2025-07-31)
  * **Feature**: Added support for the force option for the EC2 instance terminate command. This feature enables customers to recover resources associated with an instance stuck in the shutting-down state as a result of rare issues caused by a frozen operating system or an underlying hardware problem.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.47.2](service/elasticloadbalancingv2/CHANGELOG.md#v1472-2025-07-31)
  * **Documentation**: This release enables secondary IP addresses for Network Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.21.0](service/entityresolution/CHANGELOG.md#v1210-2025-07-31)
  * **Feature**: Add support for creating advanced rule-based matching workflows in AWS Entity Resolution.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.121.0](service/glue/CHANGELOG.md#v11210-2025-07-31)
  * **Feature**: Added support for Route node, S3 Iceberg sources/targets, catalog Iceberg sources, DynamoDB ELT connector, AutoDataQuality evaluation, enhanced PII detection with redaction, Kinesis fan-out support, and new R-series worker types.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.40.0](service/inspector2/CHANGELOG.md#v1400-2025-07-31)
  * **Feature**: Extend usage to include agentless hours and add CODE_REPOSITORY to aggregation resource type
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.66.0](service/iot/CHANGELOG.md#v1660-2025-07-31)
  * **Feature**: This release allows AWS IoT Core users to use their own AWS KMS keys for data protection
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.49.0](service/opensearch/CHANGELOG.md#v1490-2025-07-31)
  * **Feature**: Granular access control support for NEO-SAML with IAMFederation for AOS data source
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.90.0](service/quicksight/CHANGELOG.md#v1900-2025-07-31)
  * **Feature**: Added Impala connector support
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.62.0](service/s3control/CHANGELOG.md#v1620-2025-07-31)
  * **Feature**: Add Tags field to CreateAccessPoint
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.49.0](service/sesv2/CHANGELOG.md#v1490-2025-07-31)
  * **Feature**: This release introduces support for Multi-tenant management
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.29.0](service/workspacesweb/CHANGELOG.md#v1290-2025-07-31)
  * **Feature**: Added ability to log session activity on a portal to an S3 bucket.

# Release (2025-07-30)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.37.1
  * **Bug Fix**: Include underlying error when retry token bucket is exhausted.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.49.0](service/cloudfront/CHANGELOG.md#v1490-2025-07-30)
  * **Feature**: This release adds new origin timeout options: 1) ResponseCompletionTimeout and 2) OriginReadTimeout (for S3 origins)
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.33.0](service/directoryservice/CHANGELOG.md#v1330-2025-07-30)
  * **Feature**: This release adds support for AWS Managed Microsoft AD Hybrid Edition, introducing new operations: StartADAssessment, DescribeADAssessment, ListADAssessments, DeleteADAssessment, CreateHybridAD, UpdateHybridAD, and DescribeHybridADUpdate; and updated existing operation: DescribeDirectories.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.43.0](service/docdb/CHANGELOG.md#v1430-2025-07-30)
  * **Feature**: Add support for setting Serverless Scaling Configuration on clusters.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.238.0](service/ec2/CHANGELOG.md#v12380-2025-07-30)
  * **Feature**: Release to show the next hop IP address for routes propagated by VPC Route Server into VPC route tables.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.50.0](service/iotwireless/CHANGELOG.md#v1500-2025-07-30)
  * **Feature**: Added TxPowerIndexMin, TxPowerIndexMax, NbTransMin and NbTransMax params to ServiceProfile.

# Release (2025-07-29)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/ec2/imds`: [v1.18.0](feature/ec2/imds/CHANGELOG.md#v1180-2025-07-29)
  * **Feature**: Add config switch `DisableDefaultMaxBackoff` that allows you to disable the default maximum backoff (1 second) for IMDS calls retry attempt
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.55.0](service/batch/CHANGELOG.md#v1550-2025-07-29)
  * **Feature**: AWS Batch for SageMaker Training jobs feature support.  Includes new APIs for service job submission (e.g., SubmitServiceJob) and managing service environments (e.g., CreateServiceEnvironment) that enable queueing SageMaker Training jobs.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.27.0](service/cleanrooms/CHANGELOG.md#v1270-2025-07-29)
  * **Feature**: This feature provides the ability to update the table reference and allowed columns on an existing configured table.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.18.0](service/deadline/CHANGELOG.md#v1180-2025-07-29)
  * **Feature**: Adds support for tag management on monitors.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.46.0](service/location/CHANGELOG.md#v1460-2025-07-29)
  * **Feature**: This release 1) adds support for multi-polygon geofences with disconnected territories, and 2) enables polygon exclusion zones within geofences for more accurate representation of real-world boundaries.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.21.0](service/opensearchserverless/CHANGELOG.md#v1210-2025-07-29)
  * **Feature**: This is to support Granular access control support for SAML with IAMFedraton in AOSS

# Release (2025-07-28)

## General Highlights
* **Feature**: Add support for HTTP interceptors.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.33.0](service/directconnect/CHANGELOG.md#v1330-2025-07-28)
  * **Feature**: Enable MACSec support and features on Interconnects.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.48.0](service/iotsitewise/CHANGELOG.md#v1480-2025-07-28)
  * **Feature**: Add support for native anomaly detection in IoT SiteWise using new Computation Model APIs
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.16.0](service/osis/CHANGELOG.md#v1160-2025-07-28)
  * **Feature**: Add Pipeline Role Arn as an optional parameter to the create / update pipeline APIs as an alternative to passing in the pipeline configuration body

# Release (2025-07-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.32.0](service/appintegrations/CHANGELOG.md#v1320-2025-07-25)
  * **Feature**: Amazon AppIntegrations introduces new configuration capabilities to enable customers to manage iframe permissions, control application refresh behavior (per contact or per browser/cross-contact), and run background applications (service).
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.32.0](service/budgets/CHANGELOG.md#v1320-2025-07-25)
  * **Feature**: Adds IPv6 and PrivateLink support for AWS Budgets in IAD.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.53.2](service/configservice/CHANGELOG.md#v1532-2025-07-25)
  * **Documentation**: Documentation improvements have been made to the EvaluationModel and DescribeConfigurationRecorders APIs.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.236.0](service/ec2/CHANGELOG.md#v12360-2025-07-25)
  * **Feature**: Transit Gateway native integration with AWS Network Firewall. Adding new enum value for the new Transit Gateway Attachment type.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.41.4](service/kms/CHANGELOG.md#v1414-2025-07-25)
  * **Documentation**: Doc only update: fixed grammatical errors.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.26.0](service/mediapackagev2/CHANGELOG.md#v1260-2025-07-25)
  * **Feature**: This release adds support for specifying a preferred input for channels using CMAF ingest.
* `github.com/aws/aws-sdk-go-v2/service/socialmessaging`: [v1.3.0](service/socialmessaging/CHANGELOG.md#v130-2025-07-25)
  * **Feature**: This release introduces new WhatsApp template management APIs that enable customers to programmatically create and submit templates for approval, monitor approval status, and manage the complete template lifecycle
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.38.10](service/sqs/CHANGELOG.md#v13810-2025-07-25)
  * **Documentation**: Documentation updates for Amazon SQS fair queues feature.

# Release (2025-07-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.33.0](service/datazone/CHANGELOG.md#v1330-2025-07-24)
  * **Feature**: This release adds support for 1) highlighting relevant text in returned results for Search and SearchListings APIs and 2) returning aggregated counts of values for specified attributes for SearchListings API.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.31.0](service/omics/CHANGELOG.md#v1310-2025-07-24)
  * **Feature**: Add Git integration and README support for HealthOmics workflows

# Release (2025-07-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.235.0](service/ec2/CHANGELOG.md#v12350-2025-07-23)
  * **Feature**: Added support for skip-os-shutdown option for the EC2 instance stop and terminate operations. This feature enables customers to bypass the graceful OS shutdown, supporting faster state transitions when instance data preservation isn't critical.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.119.0](service/glue/CHANGELOG.md#v11190-2025-07-23)
  * **Feature**: AWS Glue now supports dynamic session policies for job executions. This feature allows you to specify custom, fine-grained permissions for each job run without creating multiple IAM roles.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.16.0](service/workspacesthinclient/CHANGELOG.md#v1160-2025-07-23)
  * **Feature**: Added the lastUserId parameter to the ListDevices and GetDevice API.

# Release (2025-07-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.46.0](service/ecr/CHANGELOG.md#v1460-2025-07-22)
  * **Feature**: Add support for Image Tag Mutability Exception feature, allowing repositories to define wildcard-based patterns that override the default image tag mutability settings.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.50.0](service/emr/CHANGELOG.md#v1500-2025-07-22)
  * **Feature**: This release adds new parameter 'ExtendedSupport' in AWS EMR RunJobFlow, ModifyCluster and DescribeCluster API.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.73.0](service/lambda/CHANGELOG.md#v1730-2025-07-22)
  * **Feature**: This release migrated the model to Smithy keeping all features unchanged.
* `github.com/aws/aws-sdk-go-v2/service/neptunedata`: [v1.11.0](service/neptunedata/CHANGELOG.md#v1110-2025-07-22)
  * **Feature**: This release updates the supported regions for Neptune API to include current AWS regions.

# Release (2025-07-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.47.0](service/cloudfront/CHANGELOG.md#v1470-2025-07-21)
  * **Feature**: Add dualstack endpoint support
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.16.0](service/deadline/CHANGELOG.md#v1160-2025-07-21)
  * **Feature**: Add support for VPC resource endpoints in Service Managed Fleets
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.234.0](service/ec2/CHANGELOG.md#v12340-2025-07-21)
  * **Feature**: This release adds support for C8gn, F2 and P6e-GB200 Instance types
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.202.0](service/sagemaker/CHANGELOG.md#v12020-2025-07-21)
  * **Feature**: This release adds 1/ Support for S3FileSystem in CustomFileSystems 2/ The ability for a customer to select their preferred IpAddressType for use with private Workforces 3/ Support for p4de instance type in SageMaker Training Plans
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.11.0](service/timestreaminfluxdb/CHANGELOG.md#v1110-2025-07-21)
  * **Feature**: Timestream for InfluxDB adds support for db.influx.24xlarge instance type. This enhancement enables higher compute capacity for demanding workloads through CreateDbInstance, CreateDbCluster, UpdateDbInstance, and UpdateDbCluster APIs.

# Release (2025-07-19)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.36.6
  * **Bug Fix**: Add partition support for aws-eusc.

# Release (2025-07-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.40.0](service/auditmanager/CHANGELOG.md#v1400-2025-07-18)
  * **Feature**: Updated error handling for RegisterOrganizationAdminAccount API to properly translate TooManyExceptions to HTTP 429 status code. This enhancement improves error handling consistency and provides clearer feedback when request limits are exceeded.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.53.0](service/cloudwatchlogs/CHANGELOG.md#v1530-2025-07-18)
  * **Feature**: CloudWatchLogs launches GetLogObject API with streaming support for efficient log data retrieval. Logs added support for new AccountPolicy type METRIC_EXTRACTION_POLICY. For more information, see CloudWatch Logs API documentation
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.77.0](service/mediaconvert/CHANGELOG.md#v1770-2025-07-18)
  * **Feature**: This release adds support for TAMS server integration with MediaConvert inputs.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.52.0](service/outposts/CHANGELOG.md#v1520-2025-07-18)
  * **Feature**: Add AWS Outposts API to surface customer billing information
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.47.0](service/sesv2/CHANGELOG.md#v1470-2025-07-18)
  * **Feature**: Added IP Visibility support for managed dedicated pools. Enhanced GetDedicatedIp and GetDedicatedIps APIs to return managed IP addresses.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.60.1](service/ssm/CHANGELOG.md#v1601-2025-07-18)
  * **Documentation**: July 2025 doc-only updates for Systems Manager.

# Release (2025-07-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.14.0](service/cleanroomsml/CHANGELOG.md#v1140-2025-07-17)
  * **Feature**: This release introduces Parquet result format support for ML Input Channel models in AWS Clean Rooms ML.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.46.4](service/cloudfront/CHANGELOG.md#v1464-2025-07-17)
  * **Documentation**: Doc only update for CloudFront that fixes some customer-reported issues
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.233.0](service/ec2/CHANGELOG.md#v12330-2025-07-17)
  * **Feature**: AWS Free Tier Version2 Support
* `github.com/aws/aws-sdk-go-v2/service/keyspacesstreams`: [v1.0.1](service/keyspacesstreams/CHANGELOG.md#v101-2025-07-17)
  * **Documentation**: Doc only update for the Amazon Keyspaces Streams API.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.76.0](service/mediaconvert/CHANGELOG.md#v1760-2025-07-17)
  * **Feature**: This release expands the range of supported audio outputs to include xHE, 192khz FLAC and the deprecation of dual mono for AC3.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.35.9](service/sfn/CHANGELOG.md#v1359-2025-07-17)
  * **Documentation**: Align input with style guidelines.
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.36.0](service/synthetics/CHANGELOG.md#v1360-2025-07-17)
  * **Feature**: This feature allows AWS Synthetics customers to provide code dependencies using lambda layer while creating a canary

# Release (2025-07-16.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.39.0](service/bedrock/CHANGELOG.md#v1390-2025-07-162)
  * **Feature**: This release adds support for on-demand custom model inference through CustomModelDeployment APIs for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentcore`: [v1.0.0](service/bedrockagentcore/CHANGELOG.md#v100-2025-07-162)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of Amazon Bedrock AgentCore SDK including Runtime, Built-In Tools, Memory, Gateway and Identity.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol`: [v1.0.0](service/bedrockagentcorecontrol/CHANGELOG.md#v100-2025-07-162)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of Amazon Bedrock AgentCore SDK including Runtime, Built-In Tools, Memory, Gateway and Identity.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.52.0](service/cloudwatchlogs/CHANGELOG.md#v1520-2025-07-162)
  * **Feature**: CloudWatch Logs updates: Added X-Ray tracing for Amazon Bedrock Agent resources. Logs introduced Log Group level resource policies (managed through Put/Delete/Describe Resource Policy APIs). For more information, see CloudWatch Logs API documentation.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.50.0](service/datasync/CHANGELOG.md#v1500-2025-07-162)
  * **Feature**: AWS DataSync now supports IPv6 address inputs and outputs in create, update, and describe operations for NFS, SMB, and Object Storage locations
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.118.0](service/glue/CHANGELOG.md#v11180-2025-07-162)
  * **Feature**: AWS Glue now supports schema, partition and sort management of Apache Iceberg tables using Glue SDK
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.57.0](service/guardduty/CHANGELOG.md#v1570-2025-07-162)
  * **Feature**: Add expectedBucketOwner parameter to ThreatIntel and IPSet APIs.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.48.0](service/iotwireless/CHANGELOG.md#v1480-2025-07-162)
  * **Feature**: FuotaTaskId is not a valid IdentifierType for EventConfiguration and is being removed from possible IdentifierType values.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.25.0](service/mediapackagev2/CHANGELOG.md#v1250-2025-07-162)
  * **Feature**: This release adds support for CDN Authentication using Static Headers in MediaPackage v2.
* `github.com/aws/aws-sdk-go-v2/service/networkflowmonitor`: [v1.4.0](service/networkflowmonitor/CHANGELOG.md#v140-2025-07-162)
  * **Feature**: Introducing 2 new scope status types - DEACTIVATING and DEACTIVATED.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.19.0](service/paymentcryptographydata/CHANGELOG.md#v1190-2025-07-162)
  * **Feature**: Expand length of message data field for Mac generation and validation to 8192 characters.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.35.8](service/sfn/CHANGELOG.md#v1358-2025-07-162)
  * **Documentation**: Doc-only update to introduction, and edits to clarify input parameter and the set of control characters.

# Release (2025-07-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.60.0](service/ecs/CHANGELOG.md#v1600-2025-07-16)
  * **Feature**: This release removes hookDetails for the Amazon ECS native blue/green deployments.

# Release (2025-07-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.45.0](service/bedrockagent/CHANGELOG.md#v1450-2025-07-15)
  * **Feature**: Add support for S3 Vectors as a vector store.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.32.0](service/datazone/CHANGELOG.md#v1320-2025-07-15)
  * **Feature**: Removing restriction of environment profile identifier as required field, S3 feature release
* `github.com/aws/aws-sdk-go-v2/service/dynamodbstreams`: [v1.26.0](service/dynamodbstreams/CHANGELOG.md#v1260-2025-07-15)
  * **Feature**: Added support for optional shard filter parameter in DescribeStream api that allows customers to fetch child shards of a read_only parent shard.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.232.0](service/ec2/CHANGELOG.md#v12320-2025-07-15)
  * **Feature**: This release adds support for volume initialization status, which enables you to monitor when the initialization process for an EBS volume is completed. This release also adds IPv6 support to EC2 Instance Connect Endpoints, allowing you to connect to your EC2 Instance via a private IPv6 address.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.59.0](service/ecs/CHANGELOG.md#v1590-2025-07-15)
  * **Feature**: Amazon ECS supports native blue/green deployments, allowing you to validate new service revisions before directing production traffic to them.
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.41.0](service/eventbridge/CHANGELOG.md#v1410-2025-07-15)
  * **Feature**: Add customer-facing logging for the EventBridge Event Bus, enabling customers to better observe their events and extract insights about their EventBridge usage.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.47.0](service/opensearch/CHANGELOG.md#v1470-2025-07-15)
  * **Feature**: AWS Opensearch adds support for enabling s3 vector engine options. After enabling this option, customers will be able to create indices with s3 vector engine.
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.35.0](service/pricing/CHANGELOG.md#v1350-2025-07-15)
  * **Feature**: This release adds support for new filter types in GetProducts API, including EQUALS, CONTAINS, ANY_OF, and NONE_OF.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.88.0](service/quicksight/CHANGELOG.md#v1880-2025-07-15)
  * **Feature**: Introduced custom instructions for topics.
* `github.com/aws/aws-sdk-go-v2/service/repostspace`: [v1.10.0](service/repostspace/CHANGELOG.md#v1100-2025-07-15)
  * **Feature**: This release introduces Channels functionality with CreateChannel, GetChannel, ListChannels, and UpdateChannel operations. Channels provide dedicated collaboration spaces where teams can organize discussions and knowledge by projects, business units, or areas of responsibility.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.84.0](service/s3/CHANGELOG.md#v1840-2025-07-15)
  * **Feature**: Amazon S3 Metadata live inventory tables provide a queryable inventory of all the objects in your general purpose bucket so that you can determine the latest state of your data. To help minimize your storage costs, use journal table record expiration to set a retention period for your records.
* `github.com/aws/aws-sdk-go-v2/service/s3tables`: [v1.6.0](service/s3tables/CHANGELOG.md#v160-2025-07-15)
  * **Feature**: Adds table bucket type to ListTableBucket and GetTableBucket API operations
* `github.com/aws/aws-sdk-go-v2/service/s3vectors`: [v1.0.0](service/s3vectors/CHANGELOG.md#v100-2025-07-15)
  * **Release**: New AWS service client module
  * **Feature**: Amazon S3 Vectors provides cost-effective, elastic, and durable vector storage for queries based on semantic meaning and similarity.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.201.0](service/sagemaker/CHANGELOG.md#v12010-2025-07-15)
  * **Feature**: This release adds support for a new Restricted instance group type to enable a specialized environment for running Nova customization jobs on SageMaker HyperPod clusters. This release also adds support for SageMaker pipeline versioning.

# Release (2025-07-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.231.0](service/ec2/CHANGELOG.md#v12310-2025-07-09)
  * **Feature**: Adds support to Capacity Blocks for ML for purchasing EC2 P6e-GB200 UltraServers. Customers can now purchase u-p6e-gb200x72 and u-p6e-gb200x36 UltraServers. Adds new DescribeCapacityBlocks andDescribeCapacityBlockStatus APIs. Adds support for CapacityBlockId to DescribeInstanceTopology.
* `github.com/aws/aws-sdk-go-v2/service/freetier`: [v1.9.0](service/freetier/CHANGELOG.md#v190-2025-07-09)
  * **Feature**: This release introduces four new APIs: GetAccountPlanState and UpgradeAccountPlan for AWS account plan management; ListAccountActivities and GetAccountActivity that provide activity tracking capabilities.
* `github.com/aws/aws-sdk-go-v2/service/opsworkscm`: [v1.28.5](service/opsworkscm/CHANGELOG.md#v1285-2025-07-09)
  * **Documentation**: Removing content that refers to an S3 bucket that is no longer in use.

# Release (2025-07-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.47.0](service/customerprofiles/CHANGELOG.md#v1470-2025-07-03)
  * **Feature**: This release introduces capability of create Segments via importing a CSV file directly. This consumes the CSV file and creates/updates corresponding profiles for the particular domain.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.15.0](service/deadline/CHANGELOG.md#v1150-2025-07-03)
  * **Feature**: Added fields for output manifest reporting and task chunking parameters
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.230.0](service/ec2/CHANGELOG.md#v12300-2025-07-03)
  * **Feature**: This release adds GroupOwnerId as a response member to the DescribeSecurityGroupVpcAssociations API and also adds waiters for SecurityGroupVpcAssociations (SecurityGroupVpcAssociationAssociated and SecurityGroupVpcAssociationDisassociated).
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.24.0](service/mediapackagev2/CHANGELOG.md#v1240-2025-07-03)
  * **Feature**: This release adds support for Microsoft Smooth Streaming (MSS) and allows users to exclude DRM segment Metadata in MediaPackage v2 Origin Endpoints
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.53.0](service/route53/CHANGELOG.md#v1530-2025-07-03)
  * **Feature**: Amazon Route 53 now supports the iso-e regions for private DNS Amazon VPCs and cloudwatch healthchecks.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.200.0](service/sagemaker/CHANGELOG.md#v12000-2025-07-03)
  * **Feature**: Changes include new StartSession API for SageMaker Studio spaces and CreateHubContentPresignedUrls API for SageMaker JumpStart.

# Release (2025-07-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.26.0](service/connectcases/CHANGELOG.md#v1260-2025-07-02)
  * **Feature**: This release adds DeleteCase and DeleteRelatedItem APIs, which enable deleting cases and comments, undoing contact association, and removing service level agreements (SLAs) from cases. Contact center admins can use these APIs to delete cases when requested by customers and correct agent errors.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.229.0](service/ec2/CHANGELOG.md#v12290-2025-07-02)
  * **Feature**: AWS Site-to-Site VPN now supports IPv6 addresses on outer tunnel IPs, making it easier for customers to build or transition to IPv6-only networks.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.83.0](service/s3/CHANGELOG.md#v1830-2025-07-02)
  * **Feature**: Added support for directory bucket creation with tags and bucket ARN retrieval in CreateBucket, ListDirectoryBuckets, and HeadBucket operations
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.60.0](service/s3control/CHANGELOG.md#v1600-2025-07-02)
  * **Feature**: Added TagResource, UntagResource, and ListTagsForResource support for directory bucket

# Release (2025-07-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.13.0](service/cleanroomsml/CHANGELOG.md#v1130-2025-07-01)
  * **Feature**: This release introduces support for incremental training and distributed training for custom models in AWS Clean Rooms ML.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.31.0](service/datazone/CHANGELOG.md#v1310-2025-07-01)
  * **Feature**: Add support for the new optional domain-unit-id parameter in the UpdateProject API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.228.0](service/ec2/CHANGELOG.md#v12280-2025-07-01)
  * **Feature**: Add Context to GetInstanceTypesFromInstanceRequirements API
* `github.com/aws/aws-sdk-go-v2/service/odb`: [v1.0.0](service/odb/CHANGELOG.md#v100-2025-07-01)
  * **Release**: New AWS service client module
  * **Feature**: This release adds API operations for Oracle Database@AWS. You can use the APIs to create Exadata infrastructure, ODB networks, and Exadata and Autonomous VM clusters inside AWS data centers. The infrastructure is managed by OCI. You can integrate these resources with AWS services.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.28.0](service/qbusiness/CHANGELOG.md#v1280-2025-07-01)
  * **Feature**: New ChatResponseConfiguration to Customize Q Business chat responses for specific use cases and communication needs. Updated Boosting capability allowing admins to provide preference on date attributes for recency and/or provide a preferred data source.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.99.1](service/rds/CHANGELOG.md#v1991-2025-07-01)
  * **Documentation**: Amazon RDS Custom for Oracle now supports multi-AZ database instances.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.199.0](service/sagemaker/CHANGELOG.md#v11990-2025-07-01)
  * **Feature**: Updated field validation requirements for InstanceGroups.

# Release (2025-06-30)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.18.0](service/arczonalshift/CHANGELOG.md#v1180-2025-06-30)
  * **Feature**: Added support for on-demand practice runs and balanced capacity checks in ARC autoshift practice.
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.70](service/b2bi/CHANGELOG.md#v100-preview70-2025-06-30)
  * **Feature**: Updated APIs to support inbound EDI split capabilities and additional Partnership-level configurations of generated EDI files' contents and format.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.38.0](service/bedrock/CHANGELOG.md#v1380-2025-06-30)
  * **Feature**: Add support for API Keys, Re-Ranker, implicit filter for RAG / KB evaluation for Bedrock APIs.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.31.0](service/bedrockruntime/CHANGELOG.md#v1310-2025-06-30)
  * **Feature**: Add API Key and document citations support for Bedrock Runtime APIs
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.61.0](service/cloudformation/CHANGELOG.md#v1610-2025-06-30)
  * **Feature**: Added support for UNKNOWN drift status.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.53.0](service/configservice/CHANGELOG.md#v1530-2025-06-30)
  * **Feature**: Updated ResourceType enum with new resource types onboarded by AWS Config as of June 2025
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.131.0](service/connect/CHANGELOG.md#v11310-2025-06-30)
  * **Feature**: This release introduces ChatMetrics to the model, providing comprehensive analytics insights for Amazon Connect chat conversations. Users can access these detailed metrics through the AWS Connect API by using the DescribeContact operation with their specific instance and contact IDs
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.44.0](service/dynamodb/CHANGELOG.md#v1440-2025-06-30)
  * **Feature**: This change adds support for witnesses in global tables. It also adds a new table status, REPLICATION_NOT_AUTHORIZED. This status will indicate scenarios where global replicas table can't be utilized for data plane operations.
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.40.0](service/eventbridge/CHANGELOG.md#v1400-2025-06-30)
  * **Feature**: Added support for EventBridge Dualstack endpoints in AWS GovCloud (US) regions (us-gov-east-1 and us-gov-west-1). The dualstack endpoints are identical for both FIPS and non-FIPS configurations, following the format: events.{region}.api.aws
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.117.0](service/glue/CHANGELOG.md#v11170-2025-06-30)
  * **Feature**: releasing source processing properties to support source properties for ODB integrations
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.43.0](service/iam/CHANGELOG.md#v1430-2025-06-30)
  * **Feature**: Updated IAM ServiceSpecificCredential support to include expiration, API Key output format instead of username and password for services that will support API keys, and the ability to list credentials for all users in the account for a given service configuration.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.16.0](service/medicalimaging/CHANGELOG.md#v1160-2025-06-30)
  * **Feature**: Added new fields to support the concept of primary image sets within the storage hierarchy.
* `github.com/aws/aws-sdk-go-v2/service/networkflowmonitor`: [v1.3.0](service/networkflowmonitor/CHANGELOG.md#v130-2025-06-30)
  * **Feature**: Add ConflictExceptions to UpdateScope and DeleteScope operations for scopes being mutated.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.51.0](service/outposts/CHANGELOG.md#v1510-2025-06-30)
  * **Feature**: Make ContactName and ContactPhoneNumber required fields when creating and updating Outpost Site Addresses.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.87.0](service/quicksight/CHANGELOG.md#v1870-2025-06-30)
  * **Feature**: Introduced custom permission capabilities for reporting content. Added menu option in exploration to preserve configuration data when textbox menu option is used. Added support for Athena trusted identity propagation.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.60.0](service/ssm/CHANGELOG.md#v1600-2025-06-30)
  * **Feature**: Introduces AccessType, a new filter value for the DescribeSessions API.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.61.0](service/transfer/CHANGELOG.md#v1610-2025-06-30)
  * **Feature**: Added support for dual-stack (IPv4 and IPv6) endpoints for SFTP public endpoints and VPC-internal endpoints (SFTP, FTPS, FTP, and AS2), enabling customers to configure new servers with IPv4 or dual-stack mode, convert existing servers to dual-stack, and use IPv6 with service APIs.

# Release (2025-06-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.52.7](service/configservice/CHANGELOG.md#v1527-2025-06-27)
  * **Documentation**: Added important considerations to the PutConformancePack and PutOrganizationConformancPack APIs.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.130.0](service/connect/CHANGELOG.md#v11300-2025-06-27)
  * **Feature**: This release adds the following value to an InitiateAs enum: COMPLETED
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.116.0](service/glue/CHANGELOG.md#v11160-2025-06-27)
  * **Feature**: AWS Glue now supports schema, partition and sort management of Apache Iceberg tables using Glue SDK
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.56.0](service/guardduty/CHANGELOG.md#v1560-2025-06-27)
  * **Feature**: Update JSON target for Kubernetes workload resource type.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.18.0](service/qconnect/CHANGELOG.md#v1180-2025-06-27)
  * **Feature**: Adding UnauthorizedException to public SDK
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.99.0](service/rds/CHANGELOG.md#v1990-2025-06-27)
  * **Feature**: StartDBCluster and StopDBCluster can now throw InvalidDBShardGroupStateFault.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.46.0](service/sesv2/CHANGELOG.md#v1460-2025-06-27)
  * **Feature**: Added support for new SES regions

# Release (2025-06-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.14.0](service/deadline/CHANGELOG.md#v1140-2025-06-26)
  * **Feature**: Added fields to track cumulative task retry attempts for steps and jobs
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.227.0](service/ec2/CHANGELOG.md#v12270-2025-06-26)
  * **Feature**: This release adds support for OdbNetworkArn as a target in VPC Route Tables
* `github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations`: [v1.1.0](service/iotmanagedintegrations/CHANGELOG.md#v110-2025-06-26)
  * **Feature**: Adding managed integrations APIs for IoT Device Management to onboard and control devices across different manufacturers, connectivity protocols and third party vendor clouds. APIs include managed thing operations, provisioning profile management, and cloud connector operations.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.19.0](service/keyspaces/CHANGELOG.md#v1190-2025-06-26)
  * **Feature**: This release provides change data capture (CDC) streams support through updates to the Amazon Keyspaces API.
* `github.com/aws/aws-sdk-go-v2/service/keyspacesstreams`: [v1.0.0](service/keyspacesstreams/CHANGELOG.md#v100-2025-06-26)
  * **Release**: New AWS service client module
  * **Feature**: This release adds change data capture (CDC) streams support through the new Amazon Keyspaces Streams API.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.41.2](service/kms/CHANGELOG.md#v1412-2025-06-26)
  * **Documentation**: This release updates AWS CLI examples for KMS APIs.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.27.0](service/qbusiness/CHANGELOG.md#v1270-2025-06-26)
  * **Feature**: Added support for App level authentication for QBusiness DataAccessor using AWS IAM Identity center Trusted Token issuer
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.58.0](service/workspaces/CHANGELOG.md#v1580-2025-06-26)
  * **Feature**: Updated modifyStreamingProperties to support PrivateLink VPC endpoints for directories

# Release (2025-06-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.58.1](service/ecs/CHANGELOG.md#v1581-2025-06-25)
  * **Documentation**: Updates for change to Amazon ECS default log driver mode from blocking to non-blocking
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.55.0](service/fsx/CHANGELOG.md#v1550-2025-06-25)
  * **Feature**: Add support for the ability to create Amazon S3 Access Points for Amazon FSx for OpenZFS file systems.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.82.0](service/s3/CHANGELOG.md#v1820-2025-06-25)
  * **Feature**: Adds support for additional server-side encryption mode and storage class values for accessing Amazon FSx data from Amazon S3 using S3 Access Points
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.59.0](service/s3control/CHANGELOG.md#v1590-2025-06-25)
  * **Feature**: Add support for the ability to use Amazon S3 Access Points with Amazon FSx for OpenZFS file systems.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.38.0](service/storagegateway/CHANGELOG.md#v1380-2025-06-25)
  * **Feature**: This release adds IPv6 support to the Storage Gateway APIs. APIs that previously only accept or return IPv4 address will now accept or return both IPv4 and IPv6 addresses.
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.36.0](service/textract/CHANGELOG.md#v1360-2025-06-25)
  * **Feature**: Add RotationAngle field to Geometry of WORD blocks for Textract AnalyzeDocument API
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.15.0](service/workspacesthinclient/CHANGELOG.md#v1150-2025-06-25)
  * **Feature**: Remove Tags field from Get API responses

# Release (2025-06-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/aiops`: [v1.1.0](service/aiops/CHANGELOG.md#v110-2025-06-24)
  * **Feature**: Adds support for cross account investigations for CloudWatch investigations AI Operations (AIOps).
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.53.0](service/batch/CHANGELOG.md#v1530-2025-06-24)
  * **Feature**: Add userdataType to LaunchTemplateSpecification and LaunchTemplateSpecificationOverride.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.37.0](service/bedrock/CHANGELOG.md#v1370-2025-06-24)
  * **Feature**: We are making ListFoundationModelAgreementOffers, DeleteFoundationModelAgreement, CreateFoundationModelAgreement, GetFoundationModelAvailability, PutUseCaseForModelAccess and GetUseCaseForModelAccess APIs public, previously they were console.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.226.0](service/ec2/CHANGELOG.md#v12260-2025-06-24)
  * **Feature**: This release allows you to create and register AMIs while maintaining their underlying EBS snapshots within Local Zones.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.46.0](service/elasticloadbalancingv2/CHANGELOG.md#v1460-2025-06-24)
  * **Feature**: Add Paginator for DescribeAccountLimits, and fix Paginators for DescribeTrustStoreAssociations, DescribeTrustStoreRevocations, and DescribeTrustStores
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.42.0](service/gamelift/CHANGELOG.md#v1420-2025-06-24)
  * **Feature**: Add support for UDP ping beacons to ListLocations API, including new PingBeacon and UDPEndpoint data types within its Locations return value. Use UDP ping beacon endpoints to help measure real-time network latency for multiplayer games.
* `github.com/aws/aws-sdk-go-v2/service/licensemanager`: [v1.32.0](service/licensemanager/CHANGELOG.md#v1320-2025-06-24)
  * **Feature**: AWS License Manager now supports license type conversions for AWS Marketplace products. Customers can provide Marketplace codes in the source license context or destination license context in the CreateLicenseConversionTaskForResource requests.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.98.0](service/rds/CHANGELOG.md#v1980-2025-06-24)
  * **Feature**: Adding support for RDS on Dedicated Local Zones, including local backup target, snapshot availability zone and snapshot target
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.36.0](service/route53resolver/CHANGELOG.md#v1360-2025-06-24)
  * **Feature**: Add support for iterative DNS queries through the new INBOUND_DELEGATION endpoint. Add delegation support through the Outbound Endpoints with DELEGATE rules.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.47.0](service/transcribe/CHANGELOG.md#v1470-2025-06-24)
  * **Feature**: This Feature Adds Support for the "et-EE" Locale for Batch Operations

# Release (2025-06-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.115.0](service/glue/CHANGELOG.md#v11150-2025-06-23)
  * **Feature**: AWS Glue now supports sort and z-order strategy for managed automated compaction for Iceberg tables in addition to binpack.
* `github.com/aws/aws-sdk-go-v2/service/s3tables`: [v1.5.0](service/s3tables/CHANGELOG.md#v150-2025-06-23)
  * **Feature**: S3 Tables now supports sort and z-order compaction strategies for Iceberg tables in addition to binpack.
* `github.com/aws/aws-sdk-go-v2/service/workspacesinstances`: [v1.0.0](service/workspacesinstances/CHANGELOG.md#v100-2025-06-23)
  * **Release**: New AWS service client module
  * **Feature**: Added support for Amazon WorkSpaces Instances API

# Release (2025-06-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.36.0](service/bedrock/CHANGELOG.md#v1360-2025-06-20)
  * **Feature**: Add support for tiers in Content Filters and Denied Topics for Amazon Bedrock Guardrails.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.58.0](service/ecs/CHANGELOG.md#v1580-2025-06-20)
  * **Feature**: Add ECS support for Windows Server 2025
* `github.com/aws/aws-sdk-go-v2/service/geoplaces`: [v1.2.0](service/geoplaces/CHANGELOG.md#v120-2025-06-20)
  * **Feature**: Geocode, ReverseGeocode, and GetPlace APIs added Intersections and SecondaryAddresses. To use, add to the AdditionalFeatures list in your request. This provides info about nearby intersections and secondary addresses that are associated with a main address. Also added MainAddress and ParsedQuery.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.114.0](service/glue/CHANGELOG.md#v11140-2025-06-20)
  * **Feature**: AWS Glue Data Quality now provides aggregated metrics in evaluation results when publishAggregatedMetrics with row-level results are enabled. These metrics include summary statistics showing total counts of processed, passed, and failed rows and rules in a single view.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.75.0](service/mediaconvert/CHANGELOG.md#v1750-2025-06-20)
  * **Feature**: This release adds a new SPECIFIED_OPTIMAL option for handling DDS when using DVB-Sub with high resolution video.

# Release (2025-06-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.32.0](service/emrserverless/CHANGELOG.md#v1320-2025-06-19)
  * **Feature**: This release adds the capability to enable IAM IdentityCenter Trusted Identity Propagation for users running Interactive Sessions on EMR Serverless Applications.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.72.0](service/lambda/CHANGELOG.md#v1720-2025-06-19)
  * **Feature**: Support Schema Registry feature for Kafka Event Source Mapping. Customers can now configure a Schema Registry to enable schema validation and filtering for Avro, Protobuf, and JSON-formatted events in Lambda for Kafka Event Source.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.19.0](service/paymentcryptography/CHANGELOG.md#v1190-2025-06-19)
  * **Feature**: Additional support for managing HMAC keys that adheres to changes documented in X9.143-2021 and provides better interoperability for key import/export
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.18.0](service/paymentcryptographydata/CHANGELOG.md#v1180-2025-06-19)
  * **Feature**: Additional support for managing HMAC keys that adheres to changes documented in X9.143-2021 and provides better interoperability for key import/export
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.198.0](service/sagemaker/CHANGELOG.md#v11980-2025-06-19)
  * **Feature**: This release introduces alternative support for utilizing CFN templates from S3 for SageMaker Projects.

# Release (2025-06-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/aiops`: [v1.0.0](service/aiops/CHANGELOG.md#v100-2025-06-18)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for Amazon AI Operations (AIOps). AIOps is a generative AI-powered assistant that helps you respond to incidents in your system by scanning your system's telemetry and quickly surface suggestions that might be related to your issue.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.54.0](service/autoscaling/CHANGELOG.md#v1540-2025-06-18)
  * **Feature**: Add IncludeInstances parameter to DescribeAutoScalingGroups API
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.51.0](service/cloudwatchlogs/CHANGELOG.md#v1510-2025-06-18)
  * **Feature**: Added CloudWatch Logs Transformer support for converting CloudTrail, VPC Flow, EKS Audit, AWS WAF and Route53 Resolver logs to OCSF v1.1 format.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.81.0](service/s3/CHANGELOG.md#v1810-2025-06-18)
  * **Feature**: Added support for renaming objects within the same bucket using the new RenameObject API.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.197.0](service/sagemaker/CHANGELOG.md#v11970-2025-06-18)
  * **Feature**: Add support for p6-b200 instance type for SageMaker Hyperpod

# Release (2025-06-17)

## General Highlights
* **Dependency Update**: Update to smithy-go v1.22.4.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.40.0](service/accessanalyzer/CHANGELOG.md#v1400-2025-06-17)
  * **Feature**: We are launching a new analyzer type, internal access analyzer. The new analyzer will generate internal access findings, which help customers understand who within their AWS organization or AWS Account has access to their critical AWS resources.
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.33.0](service/acm/CHANGELOG.md#v1330-2025-06-17)
  * **Feature**: Adds support for Exportable Public Certificates
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.43.0](service/backup/CHANGELOG.md#v1430-2025-06-17)
  * **Feature**: AWS Backup is adding support for integration of its logically air-gapped vaults with the AWS Organizations Multi-party approval capability.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.35.1](service/bedrock/CHANGELOG.md#v1351-2025-06-17)
  * **Documentation**: This release of the SDK has the API and documentation for the createcustommodel API. This feature lets you copy a trained model into Amazon Bedrock for inference.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.53.0](service/databasemigrationservice/CHANGELOG.md#v1530-2025-06-17)
  * **Feature**: Add "Virtual" field to Data Provider as well as "S3Path" and "S3AccessRoleArn" fields to DataProvider settings
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.55.0](service/guardduty/CHANGELOG.md#v1550-2025-06-17)
  * **Feature**: Adding support for extended threat detection for EKS Audit Logs and EKS Runtime Monitoring.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.38.0](service/inspector2/CHANGELOG.md#v1380-2025-06-17)
  * **Feature**: Add Code Repository Scanning as part of AWS InspectorV2
* `github.com/aws/aws-sdk-go-v2/service/mpa`: [v1.0.0](service/mpa/CHANGELOG.md#v100-2025-06-17)
  * **Release**: New AWS service client module
  * **Feature**: This release enables customers to create Multi-party approval teams and approval requests to protect supported operations.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.51.0](service/networkfirewall/CHANGELOG.md#v1510-2025-06-17)
  * **Feature**: Release of Active Threat Defense in Network Firewall
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.39.0](service/organizations/CHANGELOG.md#v1390-2025-06-17)
  * **Feature**: Add support for policy operations on the SECURITYHUB_POLICY policy type.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.58.0](service/securityhub/CHANGELOG.md#v1580-2025-06-17)
  * **Feature**: Adds operations, structures, and exceptions required for public preview release of Security Hub V2.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.34.0](service/sts/CHANGELOG.md#v1340-2025-06-17)
  * **Feature**: The AWS Security Token Service APIs AssumeRoleWithSAML and AssumeRoleWithWebIdentity can now be invoked without pre-configured AWS credentials in the SDK configuration.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.63.0](service/wafv2/CHANGELOG.md#v1630-2025-06-17)
  * **Feature**: AWS WAF can now suggest protection packs for you based on the application information you provide when you create a webACL.

# Release (2025-06-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.35.0](service/bedrock/CHANGELOG.md#v1350-2025-06-16)
  * **Feature**: This release of the SDK has the API and documentation for the createcustommodel API. This feature lets you copy a Amazon SageMaker trained Amazon Nova model into Amazon Bedrock for inference.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.45.0](service/ecr/CHANGELOG.md#v1450-2025-06-16)
  * **Feature**: The `DescribeImageScanning` API now includes `lastInUseAt` and `InUseCount` fields that can be used to prioritize vulnerability remediation for images that are actively being used.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.50.0](service/networkfirewall/CHANGELOG.md#v1500-2025-06-16)
  * **Feature**: You can now create firewalls using a Transit Gateway instead of a VPC, resulting in a TGW attachment.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.196.0](service/sagemaker/CHANGELOG.md#v11960-2025-06-16)
  * **Feature**: This release 1) adds a new S3DataType Converse for SageMaker training 2)adds C8g R7gd M8g C6in P6 P6e instance type for SageMaker endpoint 3) adds m7i, r7i, c7i instance type for SageMaker Training and Processing.

# Release (2025-06-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.31.3](service/apigateway/CHANGELOG.md#v1313-2025-06-12)
  * **Documentation**: Documentation updates for Amazon API Gateway
* `github.com/aws/aws-sdk-go-v2/service/apigatewayv2`: [v1.28.3](service/apigatewayv2/CHANGELOG.md#v1283-2025-06-12)
  * **Documentation**: Documentation updates for Amazon API Gateway
* `github.com/aws/aws-sdk-go-v2/service/connectcampaignsv2`: [v1.3.0](service/connectcampaignsv2/CHANGELOG.md#v130-2025-06-12)
  * **Feature**: Added PutInstanceCommunicationLimits and GetInstanceCommunicationLimits APIs
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.57.5](service/ecs/CHANGELOG.md#v1575-2025-06-12)
  * **Documentation**: This Amazon ECS  release supports updating the capacityProviderStrategy parameter in update-service.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.31.0](service/emrserverless/CHANGELOG.md#v1310-2025-06-12)
  * **Feature**: This release adds support for retrieval of the optional executionIamPolicy field in the GetJobRun API response.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.27.0](service/iotfleetwise/CHANGELOG.md#v1270-2025-06-12)
  * **Feature**: Add new status READY_FOR_CHECKIN used for vehicle synchronisation
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.41.0](service/kms/CHANGELOG.md#v1410-2025-06-12)
  * **Feature**: AWS KMS announces the support of ML-DSA key pairs that creates post-quantum safe digital signatures.

# Release (2025-06-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.9.0](service/controlcatalog/CHANGELOG.md#v190-2025-06-11)
  * **Feature**: Introduced ListControlMappings API that retrieves control mappings. Added control aliases and governed resources fields in GetControl and ListControls APIs. New filtering capability in ListControls API, with implementation identifiers and implementation types.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.66.0](service/eks/CHANGELOG.md#v1660-2025-06-11)
  * **Feature**: Release for EKS Pod Identity Cross Account feature and disableSessionTags flag.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.52.0](service/lexmodelsv2/CHANGELOG.md#v1520-2025-06-11)
  * **Feature**: Add support for the Assisted NLU feature to improve bot performance
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.35.0](service/networkmanager/CHANGELOG.md#v1350-2025-06-11)
  * **Feature**: Add support for public DNS hostname resolution to private IP addresses across Cloud WAN-managed VPCs. Add support for security group referencing across Cloud WAN-managed VPCs.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.97.2](service/rds/CHANGELOG.md#v1972-2025-06-11)
  * **Documentation**: Updates Amazon RDS documentation for Amazon RDS for Db2 cross-Region replicas in standby mode.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.62.0](service/wafv2/CHANGELOG.md#v1620-2025-06-11)
  * **Feature**: WAF now provides two DDoS protection options: resource-level monitoring for Application Load Balancers and the AWSManagedRulesAntiDDoSRuleSet managed rule group for CloudFront distributions.

# Release (2025-06-10)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.36.4
  * **Bug Fix**: Use UTC() in v4 event stream signer to prevent date mismatch on direct use.
* `github.com/aws/aws-sdk-go-v2/service/gameliftstreams`: [v1.1.3](service/gameliftstreams/CHANGELOG.md#v113-2025-06-10)
  * **Documentation**: Documentation updates for Amazon GameLift Streams to address formatting errors, correct resource ID examples, and update links to other guides

# Release (2025-06-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.47.0](service/appsync/CHANGELOG.md#v1470-2025-06-09)
  * **Feature**: Deprecate `atRestEncryptionEnabled` and `transitEncryptionEnabled` attributes in `CreateApiCache` action. Encryption is always enabled for new caches.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.51.0](service/costexplorer/CHANGELOG.md#v1510-2025-06-09)
  * **Feature**: Support dual-stack endpoints for ce api
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.46.0](service/customerprofiles/CHANGELOG.md#v1460-2025-06-09)
  * **Feature**: This release introduces capability of Profile Explorer, using correct ingestion timestamp & using historical data for computing calculated attributes, and new standard objects for T&H as part of Amazon Connect Customer Profiles service.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.225.0](service/ec2/CHANGELOG.md#v12250-2025-06-09)
  * **Feature**: Release to support Elastic VMware Service (Amazon EVS) Subnet and Amazon EVS Network Interface Types.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.36.0](service/efs/CHANGELOG.md#v1360-2025-06-09)
  * **Feature**: Added support for Internet Protocol Version 6 (IPv6) on EFS Service APIs and mount targets.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.32.0](service/marketplacecatalog/CHANGELOG.md#v1320-2025-06-09)
  * **Feature**: The ListEntities API now supports the EntityID, LastModifiedDate, ProductTitle, and Visibility filters for machine learning products. You can also sort using all of those filters.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.14.0](service/workspacesthinclient/CHANGELOG.md#v1140-2025-06-09)
  * **Feature**: Add ConflictException to UpdateEnvironment API

# Release (2025-06-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.45.0](service/bedrockagentruntime/CHANGELOG.md#v1450-2025-06-06)
  * **Feature**: This release introduces the `PromptCreationConfigurations` input parameter, which includes fields to control prompt population for `InvokeAgent` or `InvokeInlineAgent` requests.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.40.0](service/kms/CHANGELOG.md#v1400-2025-06-06)
  * **Feature**: Remove unpopulated KeyMaterialId from Encrypt Response
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.97.0](service/rds/CHANGELOG.md#v1970-2025-06-06)
  * **Feature**: Include Global Cluster Identifier in DBCluster if the DBCluster is a Global Cluster Member.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.47.0](service/rekognition/CHANGELOG.md#v1470-2025-06-06)
  * **Feature**: Adds support for defining an ordered preference list of different Rekognition Face Liveness challenge types when calling CreateFaceLivenessSession.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.52.0](service/route53/CHANGELOG.md#v1520-2025-06-06)
  * **Feature**: Amazon Route 53 now supports the Asia Pacific (Taipei) Region (ap-east-2) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `github.com/aws/aws-sdk-go-v2/service/s3tables`: [v1.4.0](service/s3tables/CHANGELOG.md#v140-2025-06-06)
  * **Feature**: S3 Tables now supports getting details about a table via its table ARN.

# Release (2025-06-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.60.0](service/cloudformation/CHANGELOG.md#v1600-2025-06-05)
  * **Feature**: Add new warning type 'EXCLUDED_PROPERTIES'
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.39.0](service/kms/CHANGELOG.md#v1390-2025-06-05)
  * **Feature**: AWS KMS announces the support for on-demand rotation of symmetric-encryption KMS keys with imported key material (EXTERNAL origin).
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.61.0](service/wafv2/CHANGELOG.md#v1610-2025-06-05)
  * **Feature**: AWS WAF adds support for ASN-based traffic filtering and support for ASN-based rate limiting.

# Release (2025-06-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.33.1](service/amplify/CHANGELOG.md#v1331-2025-06-04)
  * **Documentation**: Update documentation for cacheConfig in CreateApp API
* `github.com/aws/aws-sdk-go-v2/service/evs`: [v1.0.0](service/evs/CHANGELOG.md#v100-2025-06-04)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Elastic VMware Service (Amazon EVS) allows you to run VMware Cloud Foundation (VCF) directly within your Amazon VPC including simplified self-managed migration experience with guided workflow in AWS console or via AWS CLI, get full access to their VCF deployment and VCF license portability.
* `github.com/aws/aws-sdk-go-v2/service/invoicing`: [v1.2.0](service/invoicing/CHANGELOG.md#v120-2025-06-04)
  * **Feature**: Added new Invoicing ListInvoiceSummaries API Operation
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.40.0](service/mediaconnect/CHANGELOG.md#v1400-2025-06-04)
  * **Feature**: This release updates the DescribeFlow API to show peer IP addresses. You can now identify the peer IP addresses of devices connected to your sources and outputs. This helps you to verify and troubleshoot your flow's active connections.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.74.0](service/mediaconvert/CHANGELOG.md#v1740-2025-06-04)
  * **Feature**: This release includes support for embedding and signing C2PA content credentials in MP4 outputs.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.49.0](service/networkfirewall/CHANGELOG.md#v1490-2025-06-04)
  * **Feature**: You can now monitor flow and alert log metrics from the Network Firewall console.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.195.0](service/sagemaker/CHANGELOG.md#v11950-2025-06-04)
  * **Feature**: Added support for p6-b200 instance type in SageMaker Training Jobs and Training Plans.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.46.0](service/transcribe/CHANGELOG.md#v1460-2025-06-04)
  * **Feature**: AWS Healthscribe now supports new templates for the clinical note summary: BIRP, SIRP, DAP, BEHAVIORAL_SOAP, and PHYSICAL_SOAP
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.26.0](service/transcribestreaming/CHANGELOG.md#v1260-2025-06-04)
  * **Feature**: AWS Healthscribe now supports new templates for the clinical note summary: BIRP, SIRP, DAP, BEHAVIORAL_SOAP, and PHYSICAL_SOAP

# Release (2025-06-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.31.0](service/apigateway/CHANGELOG.md#v1310-2025-06-03)
  * **Feature**: Adds support to set the routing mode for a custom domain name.
* `github.com/aws/aws-sdk-go-v2/service/apigatewayv2`: [v1.28.0](service/apigatewayv2/CHANGELOG.md#v1280-2025-06-03)
  * **Feature**: Adds support to create routing rules and set the routing mode for a custom domain name.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.30.0](service/emrserverless/CHANGELOG.md#v1300-2025-06-03)
  * **Feature**: AWS EMR Serverless: Adds a new option in the CancelJobRun API in EMR 7.9.0+, to cancel a job with grace period. This feature is enabled by default with a 120-second grace period for streaming jobs and is not enabled by default for batch jobs.

# Release (2025-06-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.51.0](service/athena/CHANGELOG.md#v1510-2025-06-02)
  * **Feature**: Add support for the managed query result in the workgroup APIs. The managed query result configuration enables users to store query results to Athena owned storage.
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.42.0](service/backup/CHANGELOG.md#v1420-2025-06-02)
  * **Feature**: You can now subscribe to Amazon SNS notifications and Amazon EventBridge events for backup indexing. You can now receive notifications when a backup index is created, deleted, or fails to create, enhancing your ability to monitor and track your backup operations.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.44.0](service/bedrockagent/CHANGELOG.md#v1440-2025-06-02)
  * **Feature**: This release adds the Agent Lifecycle Paused State feature to Amazon Bedrock agents. By using an agent's alias, you can temporarily suspend agent operations during maintenance, updates, or other situations.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.43.0](service/computeoptimizer/CHANGELOG.md#v1430-2025-06-02)
  * **Feature**: This release enables AWS Compute Optimizer to analyze Amazon Aurora database clusters and generate Aurora I/O-Optimized recommendations.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.16.0](service/costoptimizationhub/CHANGELOG.md#v1160-2025-06-02)
  * **Feature**: Support recommendations for Aurora instance and Aurora cluster storage.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.57.2](service/ecs/CHANGELOG.md#v1572-2025-06-02)
  * **Documentation**: Updates Amazon ECS documentation to include note for upcoming default log driver mode change.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.65.0](service/eks/CHANGELOG.md#v1650-2025-06-02)
  * **Feature**: Add support for filtering ListInsights API calls on MISCONFIGURATION insight category
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.19.0](service/entityresolution/CHANGELOG.md#v1190-2025-06-02)
  * **Feature**: Add support for generating match IDs in near real-time.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.6.0](service/pcs/CHANGELOG.md#v160-2025-06-02)
  * **Feature**: Introduces SUSPENDING and SUSPENDED states for clusters, compute node groups, and queues.

# Release (2025-05-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.29.0](service/emrserverless/CHANGELOG.md#v1290-2025-05-30)
  * **Feature**: This release adds the capability for users to specify an optional Execution IAM policy in the StartJobRun action. The resulting permissions assumed by the job run is the intersection of the permissions in the Execution Role and the specified Execution IAM Policy.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.194.0](service/sagemaker/CHANGELOG.md#v11940-2025-05-30)
  * **Feature**: Release new parameter CapacityReservationConfig in ProductionVariant

# Release (2025-05-29)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.33.0](service/amplify/CHANGELOG.md#v1330-2025-05-29)
  * **Feature**: Add support for customizable build instance sizes. CreateApp and UpdateApp operations now accept a new JobConfig parameter composed of BuildComputeType.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.53.0](service/autoscaling/CHANGELOG.md#v1530-2025-05-29)
  * **Feature**: Add support for "apple" CpuManufacturer in ABIS
* `github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator`: [v1.5.0](service/bcmpricingcalculator/CHANGELOG.md#v150-2025-05-29)
  * **Feature**: Add AFTER_DISCOUNTS_AND_COMMITMENTS to Workload Estimate Rate Type. Set ListWorkLoadEstimateUsage maxResults range to minimum of 0 and maximum of 300.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.49.0](service/cloudtrail/CHANGELOG.md#v1490-2025-05-29)
  * **Feature**: CloudTrail Feature Release: Support for Enriched Events with Configurable Context for Event Data Store
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.35.0](service/dataexchange/CHANGELOG.md#v1350-2025-05-29)
  * **Feature**: This release adds Tag support for Event Action resource, through which customers can create event actions with Tags and retrieve event actions with Tags.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.49.0](service/datasync/CHANGELOG.md#v1490-2025-05-29)
  * **Feature**: AgentArns field is made optional for Object Storage and Azure Blob location create requests. Location credentials are now managed via Secrets Manager, and may be encrypted with service managed or customer managed keys. Authentication is now optional for Azure Blob locations.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.54.0](service/fsx/CHANGELOG.md#v1540-2025-05-29)
  * **Feature**: FSx API changes to support the public launch of new Intelligent Tiering storage class on Amazon FSx for Lustre
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.25.0](service/ivsrealtime/CHANGELOG.md#v1250-2025-05-29)
  * **Feature**: IVS Real-Time now offers customers the participant replication that allow customers to copy a participant from one stage to another.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.35.0](service/mwaa/CHANGELOG.md#v1350-2025-05-29)
  * **Feature**: Amazon MWAA now lets you choose a worker replacement strategy when updating an environment. This release adds two worker replacement strategies: FORCED (default), which stops workers immediately, and GRACEFUL, which allows workers to finish current tasks before shutting down.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.80.0](service/s3/CHANGELOG.md#v1800-2025-05-29)
  * **Feature**: Adding checksum support for S3 PutBucketOwnershipControls API.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.193.0](service/sagemaker/CHANGELOG.md#v11930-2025-05-29)
  * **Feature**: Add maintenance status field to DescribeMlflowTrackingServer API response

# Release (2025-05-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.15.0](service/costoptimizationhub/CHANGELOG.md#v1150-2025-05-28)
  * **Feature**: This release allows customers to modify their preferred commitment term and payment options.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.224.0](service/ec2/CHANGELOG.md#v12240-2025-05-28)
  * **Feature**: Enable the option to automatically delete underlying Amazon EBS snapshots when deregistering Amazon Machine Images (AMIs)
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.48.0](service/networkfirewall/CHANGELOG.md#v1480-2025-05-28)
  * **Feature**: You can now use VPC endpoint associations to create multiple firewall endpoints for a single firewall.
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.35.0](service/synthetics/CHANGELOG.md#v1350-2025-05-28)
  * **Feature**: Add support to change ephemeral storage. Add a new field "TestResult" under CanaryRunStatus.

# Release (2025-05-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.50.0](service/costexplorer/CHANGELOG.md#v1500-2025-05-27)
  * **Feature**: This release introduces Cost Comparison feature (GetCostAndUsageComparisons, GetCostComparisonDrivers) allowing you find cost variations across multiple dimensions and identify key drivers of spending changes.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.13.0](service/deadline/CHANGELOG.md#v1130-2025-05-27)
  * **Feature**: AWS Deadline Cloud service-managed fleets now support storage profiles. With storage profiles, you can map file paths between a workstation and the worker hosts running the job.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.223.0](service/ec2/CHANGELOG.md#v12230-2025-05-27)
  * **Feature**: This release adds three features - option to store AWS Site-to-Site VPN pre-shared keys in AWS Secrets Manager, GetActiveVpnTunnelStatus API to check the in-use VPN algorithms, and SampleType option in GetVpnConnectionDeviceSampleConfiguration API to get recommended sample configs for VPN devices.

# Release (2025-05-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.222.0](service/ec2/CHANGELOG.md#v12220-2025-05-23)
  * **Feature**: This release adds support for the C7i-flex, M7i-flex, I7i, I7ie, I8g, P6-b200, Trn2, C8gd, M8gd and R8gd instances
* `github.com/aws/aws-sdk-go-v2/service/securityir`: [v1.3.0](service/securityir/CHANGELOG.md#v130-2025-05-23)
  * **Feature**: Update PrincipalId pattern documentation to reflect what user should receive back from the API call

# Release (2025-05-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.34.0](service/amp/CHANGELOG.md#v1340-2025-05-22)
  * **Feature**: Add QueryLoggingConfiguration APIs for Amazon Managed Prometheus
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.39.0](service/auditmanager/CHANGELOG.md#v1390-2025-05-22)
  * **Feature**: With this release, the AssessmentControl description field has been deprecated, as of May 19, 2025. Additionally, the UpdateAssessment API can now return a ServiceQuotaExceededException when applicable service quotas are exceeded.
* `github.com/aws/aws-sdk-go-v2/service/dsql`: [v1.5.0](service/dsql/CHANGELOG.md#v150-2025-05-22)
  * **Feature**: Features: support for customer managed encryption keys
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.113.0](service/glue/CHANGELOG.md#v11130-2025-05-22)
  * **Feature**: This release supports additional ConversionSpec parameter as part of IntegrationPartition Structure in CreateIntegrationTableProperty API. This parameter is referred to apply appropriate column transformation for columns that are used for timestamp based partitioning
* `github.com/aws/aws-sdk-go-v2/service/internal/checksum`: [v1.7.2](service/internal/checksum/CHANGELOG.md#v172-2025-05-22)
  * **Bug Fix**: Handle checksum for unseekable body with 0 content length

# Release (2025-05-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.36.1](service/applicationautoscaling/CHANGELOG.md#v1361-2025-05-21)
  * **Documentation**: Doc only update that addresses a customer reported issue.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.44.0](service/bedrockagentruntime/CHANGELOG.md#v1440-2025-05-21)
  * **Feature**: Amazon Bedrock introduces asynchronous flows (in preview), which let you run flows for longer durations and yield control so that your application can perform other tasks and you don't have to actively monitor the flow's progress.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.45.0](service/cloudwatch/CHANGELOG.md#v1450-2025-05-21)
  * **Feature**: Adds support for setting up Contributor Insight rules on logs transformed via Logs Transformation feature.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.221.0](service/ec2/CHANGELOG.md#v12210-2025-05-21)
  * **Feature**: Release of Dualstack and Ipv6-only EC2 Public DNS hostnames
* `github.com/aws/aws-sdk-go-v2/service/partnercentralselling`: [v1.5.0](service/partnercentralselling/CHANGELOG.md#v150-2025-05-21)
  * **Feature**: Modified validation to allow expectedCustomerSpend array with zero elements in Partner Opportunity operations.

# Release (2025-05-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.48.0](service/datasync/CHANGELOG.md#v1480-2025-05-20)
  * **Feature**: Remove Discovery APIs from the DataSync service
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.220.0](service/ec2/CHANGELOG.md#v12200-2025-05-20)
  * **Feature**: This release expands the ModifyInstanceMaintenanceOptions API to enable or disable instance migration during customer-initiated reboots for EC2 Scheduled Reboot Events.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.112.0](service/glue/CHANGELOG.md#v11120-2025-05-20)
  * **Feature**: Enhanced AWS Glue ListConnectionTypes API Model with additional metadata fields.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.37.0](service/inspector2/CHANGELOG.md#v1370-2025-05-20)
  * **Feature**: This release adds GetClustersForImage API and filter updates as part of the mapping of container images to running containers feature.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.18.0](service/oam/CHANGELOG.md#v1180-2025-05-20)
  * **Feature**: Add IncludeTags field to GetLink, GetSink and UpdateLink API
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.96.0](service/rds/CHANGELOG.md#v1960-2025-05-20)
  * **Feature**: This release introduces the new DescribeDBMajorEngineVersions API for describing the properties of specific major versions of database engines.

# Release (2025-05-19.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/privatenetworks`: [v1.15.0](service/privatenetworks/CHANGELOG.md#v1150-2025-05-192)
  * **Feature**: Mark service/privatenetworks as deprecated. This service is no longer available for use.

# Release (2025-05-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dsql`: [v1.4.0](service/dsql/CHANGELOG.md#v140-2025-05-19)
  * **Feature**: CreateMultiRegionCluster and DeleteMultiRegionCluster APIs removed
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.219.0](service/ec2/CHANGELOG.md#v12190-2025-05-19)
  * **Feature**: This release includes new APIs for System Integrity Protection (SIP) configuration and automated root volume ownership delegation for EC2 Mac instances.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.23.0](service/mediapackagev2/CHANGELOG.md#v1230-2025-05-19)
  * **Feature**: This release adds support for DVB-DASH, EBU-TT-D subtitle format, and non-compacted manifests for DASH in MediaPackage v2 Origin Endpoints.

# Release (2025-05-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation`: [v1.5.0](service/bedrockdataautomation/CHANGELOG.md#v150-2025-05-16)
  * **Feature**: Add support for VIDEO modality to BlueprintType enum.
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomationruntime`: [v1.3.0](service/bedrockdataautomationruntime/CHANGELOG.md#v130-2025-05-16)
  * **Feature**: Add AssetProcessingConfiguration for video segment to InputConfiguration
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.42.0](service/codepipeline/CHANGELOG.md#v1420-2025-05-16)
  * **Feature**: CodePipeline now supports new API ListDeployActionExecutionTargets that lists the deployment target details for deploy action executions.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.57.1](service/ecs/CHANGELOG.md#v1571-2025-05-16)
  * **Documentation**: This is an Amazon ECs documentation only release to support the change of the container exit "reason" field from 255 characters to 1024 characters.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.49.0](service/emr/CHANGELOG.md#v1490-2025-05-16)
  * **Feature**: Added APIs for managing Application UIs: Access Persistent (serverless) UIs via CreatePersistentAppUI DescribePersistentAppUI & GetPersistentAppUIPresignedURL, and Cluster-based UIs through GetOnClusterAppUIPresignedURL. Supports Yarn, Spark History, and TEZ interfaces.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.111.0](service/glue/CHANGELOG.md#v11110-2025-05-16)
  * **Feature**: Changes include (1) Excel as S3 Source type and XML and Tableau's Hyper as S3 Sink types, (2) targeted number of partitions parameter in S3 sinks and (3) new compression types in CSV/JSON and Parquet S3 sinks.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.37.0](service/neptune/CHANGELOG.md#v1370-2025-05-16)
  * **Feature**: This release adds Global Cluster Switchover capability which enables you to change your global cluster's primary AWS Region, the region that serves writes, while preserving the replication between all regions in the global cluster.
* `github.com/aws/aws-sdk-go-v2/service/servicequotas`: [v1.28.0](service/servicequotas/CHANGELOG.md#v1280-2025-05-16)
  * **Feature**: This release introduces CreateSupportCase operation to SDK.

# Release (2025-05-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.43.0](service/bedrockagent/CHANGELOG.md#v1430-2025-05-15)
  * **Feature**: Amazon Bedrock Flows introduces DoWhile loops nodes, parallel node executions, and enhancements to knowledge base nodes.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.61.0](service/codebuild/CHANGELOG.md#v1610-2025-05-15)
  * **Feature**: AWS CodeBuild now supports Docker Server capability
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.22.1](service/controltower/CHANGELOG.md#v1221-2025-05-15)
  * **Documentation**: Updated the descriptions for the AWS Control Tower Baseline APIs to make them more intuitive.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.52.0](service/databasemigrationservice/CHANGELOG.md#v1520-2025-05-15)
  * **Feature**: Introduces Data Resync feature to describe-table-statistics and IAM database authentication for MariaDB, MySQL, and PostgreSQL.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.5.0](service/pcs/CHANGELOG.md#v150-2025-05-15)
  * **Feature**: This release adds support for Slurm accounting. For more information, see the Slurm accounting topic in the AWS PCS User Guide. Slurm accounting is supported for Slurm 24.11 and later. This release also adds 24.11 as a valid value for the version parameter of the Scheduler data type.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.57.0](service/workspaces/CHANGELOG.md#v1570-2025-05-15)
  * **Feature**: Added the new AlwaysOn running mode for WorkSpaces Pools. Customers can now choose between AlwaysOn (for instant access, with hourly usage billing regardless of connection status), or AutoStop (to optimize cost, with a brief startup delay) for their pools.

# Release (2025-05-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.50.0](service/cloudwatchlogs/CHANGELOG.md#v1500-2025-05-14)
  * **Feature**: This release adds a new API "ListLogGroups" and an improvement in API "DescribeLogGroups"
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.53.0](service/cognitoidentityprovider/CHANGELOG.md#v1530-2025-05-14)
  * **Feature**: Add exceptions to WebAuthn operations.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.73.0](service/mediaconvert/CHANGELOG.md#v1730-2025-05-14)
  * **Feature**: This update enables cropping for video overlays and adds a new STL to Teletext upconversion toggle to preserve styling.

# Release (2025-05-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.34.0](service/bedrock/CHANGELOG.md#v1340-2025-05-13)
  * **Feature**: Enable cross-Region inference for Amazon Bedrock Guardrails by using the crossRegionConfig parameter when calling the CreateGuardrail or UpdateGuardrail operation.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.43.0](service/bedrockagentruntime/CHANGELOG.md#v1430-2025-05-13)
  * **Feature**: Changes for enhanced metadata in trace
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.22.0](service/controltower/CHANGELOG.md#v1220-2025-05-13)
  * **Feature**: AWS Control Tower now reports the inheritance drift status for EnabledBaselines through the GetEnabledBaseline and ListEnabledBaselines APIs. You can now filter EnabledBaselines by their enablement and drift status using the ListEnabledBaselines API to view accounts and OUs that require attention.
* `github.com/aws/aws-sdk-go-v2/service/dsql`: [v1.3.0](service/dsql/CHANGELOG.md#v130-2025-05-13)
  * **Feature**: CreateMultiRegionClusters and DeleteMultiRegionClusters APIs marked as deprecated. Introduced new multi-Region clusters creation experience through multiRegionProperties parameter in CreateCluster API.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.57.0](service/ecs/CHANGELOG.md#v1570-2025-05-13)
  * **Feature**: This release extends functionality for Amazon EBS volumes attached to Amazon ECS tasks by adding support for the new EBS volumeInitializationRate parameter in ECS RunTask/StartTask/CreateService/UpdateService APIs.
* `github.com/aws/aws-sdk-go-v2/service/licensemanager`: [v1.31.0](service/licensemanager/CHANGELOG.md#v1310-2025-05-13)
  * **Feature**: Add Tagging feature to resources in the Managed Entitlements service. License and Grant resources can now be tagged.

# Release (2025-05-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.12.0](service/deadline/CHANGELOG.md#v1120-2025-05-12)
  * **Feature**: AWS Deadline Cloud service-managed fleets now support configuration scripts. Configuration scripts make it easy to install additional software, like plugins and packages, onto a worker.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.218.0](service/ec2/CHANGELOG.md#v12180-2025-05-12)
  * **Feature**: EC2 - Adding support for AvailabilityZoneId
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.42.0](service/iam/CHANGELOG.md#v1420-2025-05-12)
  * **Feature**: Updating the endpoint list for the Identity and access management (IAM) service
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.76.0](service/medialive/CHANGELOG.md#v1760-2025-05-12)
  * **Feature**: Add support to the AV1 rate control mode
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.48.0](service/mediatailor/CHANGELOG.md#v1480-2025-05-12)
  * **Feature**: Documenting that EnabledLoggingStrategies is always present in responses of PlaybackConfiguration read operations.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.58.0](service/s3control/CHANGELOG.md#v1580-2025-05-12)
  * **Feature**: Updates to support S3 Express zonal endpoints for directory buckets in AWS CLI
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.192.0](service/sagemaker/CHANGELOG.md#v11920-2025-05-12)
  * **Feature**: No API changes from previous release. This release migrated the model to Smithy keeping all features unchanged.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.13.0](service/supplychain/CHANGELOG.md#v1130-2025-05-12)
  * **Feature**: Launch new AWS Supply Chain public APIs for DataIntegrationEvent, DataIntegrationFlowExecution and DatasetNamespace. Also add more capabilities to existing public APIs to support direct dataset event publish, data deduplication in DataIntegrationFlow, partition specification of custom datasets.

# Release (2025-05-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.50.5](service/athena/CHANGELOG.md#v1505-2025-05-09)
  * **Documentation**: Minor API documentation updates
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.49.0](service/cloudwatchlogs/CHANGELOG.md#v1490-2025-05-09)
  * **Feature**: We are pleased to announce limit increases to our grok processor logs transformation feature. Now you can define 20 Grok patterns in their configurations, with an expanded total pattern matching limit of 512 characters.
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.34.0](service/synthetics/CHANGELOG.md#v1340-2025-05-09)
  * **Feature**: Add support to retry a canary automatically after schedule run failures. Users can enable this feature by configuring the RetryConfig field when calling the CreateCanary or UpdateCanary API. Also includes changes in GetCanary and GetCanaryRuns to support retrieving retry configurations.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.56.0](service/workspaces/CHANGELOG.md#v1560-2025-05-09)
  * **Feature**: Remove parameter EnableWorkDocs from WorkSpacesServiceModel due to end of support of Amazon WorkDocs service.

# Release (2025-05-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.46.1](service/cloudfront/CHANGELOG.md#v1461-2025-05-08)
  * **Documentation**: Doc-only update for CloudFront. These changes include customer-reported issues.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.41.0](service/codepipeline/CHANGELOG.md#v1410-2025-05-08)
  * **Feature**: Add support for Secrets Manager and Plaintext environment variable types in Commands action
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.217.0](service/ec2/CHANGELOG.md#v12170-2025-05-08)
  * **Feature**: Launching the feature to support ENA queues offering flexibility to support multiple queues per Enhanced Network Interface (ENI)
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.110.0](service/glue/CHANGELOG.md#v11100-2025-05-08)
  * **Feature**: This new release supports customizable RefreshInterval for all Saas ZETL integrations from 15 minutes to 6 days.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.54.5](service/guardduty/CHANGELOG.md#v1545-2025-05-08)
  * **Documentation**: Updated description of a data structure.
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.31.0](service/ssoadmin/CHANGELOG.md#v1310-2025-05-08)
  * **Feature**: Update PutPermissionBoundaryToPermissionSet API's managedPolicyArn pattern to allow valid ARN only. Update ApplicationName to allow white spaces.

# Release (2025-05-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.216.0](service/ec2/CHANGELOG.md#v12160-2025-05-07)
  * **Feature**: This release adds API support for Path Component Exclusion (Filter Out ARN) for Reachability Analyzer
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.42.1](service/imagebuilder/CHANGELOG.md#v1421-2025-05-07)
  * **Documentation**: Updated the CreateImageRecipeRequest ParentImage description to include all valid values as updated with the SSM Parameters project.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.75.0](service/medialive/CHANGELOG.md#v1750-2025-05-07)
  * **Feature**: Enables Updating Anywhere Settings on a MediaLive Anywhere Channel.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.191.0](service/sagemaker/CHANGELOG.md#v11910-2025-05-07)
  * **Feature**: SageMaker AI Studio users can now migrate to SageMaker Unified Studio, which offers a unified web-based development experience that integrates AWS data, analytics, artificial intelligence (AI), and machine learning (ML) services, as well as additional tools and resource
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.33.0](service/synthetics/CHANGELOG.md#v1330-2025-05-07)
  * **Feature**: Add support to test a canary update by invoking a dry run of a canary. This behavior can be used via the new StartCanaryDryRun API along with new fields in UpdateCanary to apply dry run changes. Also includes changes in GetCanary and GetCanaryRuns to support retrieving dry run configurations.

# Release (2025-05-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.215.0](service/ec2/CHANGELOG.md#v12150-2025-05-06)
  * **Feature**: This release adds support for Amazon EBS Provisioned Rate for Volume Initialization, which lets you specify a volume initialization rate to ensure that your EBS volumes are initialized in a predictable amount of time.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.34.0](service/servicecatalog/CHANGELOG.md#v1340-2025-05-06)
  * **Feature**: ServiceCatalog's APIs (DeleteServiceAction, DisassociateServiceActionFromProvisioningArtifact, AssociateServiceActionWithProvisioningArtifact) now throw InvalidParametersException when IdempotencyToken is invalid.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.31.0](service/timestreamquery/CHANGELOG.md#v1310-2025-05-06)
  * **Feature**: Add dualstack endpoints support and correct us-gov-west-1 FIPS endpoint.
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.31.0](service/timestreamwrite/CHANGELOG.md#v1310-2025-05-06)
  * **Feature**: Add dualstack endpoints support.

# Release (2025-05-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.17.75](feature/s3/manager/CHANGELOG.md#v11775-2025-05-05)
  * **Bug Fix**: Enable user to call GetBucketRegion without credential config
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.30.0](service/datazone/CHANGELOG.md#v1300-2025-05-05)
  * **Feature**: This release adds a new authorization policy to control the usage of custom AssetType when creating an Asset. Customer can now add new grant(s) of policyType USE_ASSET_TYPE for custom AssetTypes to apply authorization policy to projects members and domain unit owners.
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.31.0](service/devicefarm/CHANGELOG.md#v1310-2025-05-05)
  * **Feature**: Add an optional parameter to the GetDevicePoolCompatibility API to pass in project information to check device pool compatibility.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.214.0](service/ec2/CHANGELOG.md#v12140-2025-05-05)
  * **Feature**: This update introduces API operations to manage and create local gateway VIF and VIF groups. It also includes API operations to describe Outpost LAGs and service link VIFs.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.56.3](service/ecs/CHANGELOG.md#v1563-2025-05-05)
  * **Documentation**: Add support to roll back an In_Progress ECS Service Deployment
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.72.0](service/mediaconvert/CHANGELOG.md#v1720-2025-05-05)
  * **Feature**: This release adds an optional sidecar per-frame video quality metrics report and an ALL_PCM option for audio selectors. It also changes the data type for Probe API response fields related to video and audio bitrate from integer to double.

# Release (2025-05-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation`: [v1.4.0](service/bedrockdataautomation/CHANGELOG.md#v140-2025-05-02)
  * **Feature**: Added support for Custom output and blueprints for AUDIO data types.
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.31.5](service/directoryservice/CHANGELOG.md#v1315-2025-05-02)
  * **Documentation**: Doc only update - fixed typos.
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.35.0](service/kinesis/CHANGELOG.md#v1350-2025-05-02)
  * **Feature**: Marking ResourceARN as required for Amazon Kinesis Data Streams APIs TagResource, UntagResource, and ListTagsForResource.

# Release (2025-05-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.38.0](service/appconfig/CHANGELOG.md#v1380-2025-05-01)
  * **Feature**: Adding waiter support for deployments and environments; documentation updates
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.129.0](service/connect/CHANGELOG.md#v11290-2025-05-01)
  * **Feature**: This release adds the following fields to DescribeContact: DisconnectReason, AgentInitiatedHoldDuration, AfterContactWorkStartTimestamp, AfterContactWorkEndTimestamp, AfterContactWorkDuration, StateTransitions, Recordings, ContactDetails, ContactEvaluations, Attributes
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.190.0](service/sagemaker/CHANGELOG.md#v11900-2025-05-01)
  * **Feature**: Feature - Adding support for Scheduled and Rolling Update Software in Sagemaker Hyperpod.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.24.0](service/verifiedpermissions/CHANGELOG.md#v1240-2025-05-01)
  * **Feature**: Amazon Verified Permissions / Features : Adds support for tagging policy stores.

# Release (2025-04-30)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.19.0](feature/dynamodb/attributevalue/CHANGELOG.md#v1190-2025-04-30)
  * **Feature**: added support for json to/from types.AttributeValue for DynamoDB and DynamoDB Streams
* `github.com/aws/aws-sdk-go-v2/feature/dynamodbstreams/attributevalue`: [v1.18.0](feature/dynamodbstreams/attributevalue/CHANGELOG.md#v1180-2025-04-30)
  * **Feature**: added support for json to/from types.AttributeValue for DynamoDB and DynamoDB Streams
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.33.0](service/bedrock/CHANGELOG.md#v1330-2025-04-30)
  * **Feature**: You can now specify a cross region inference profile as a teacher model for the CreateModelCustomizationJob API. Additionally, the GetModelCustomizationJob API has been enhanced to return the sub-task statuses of a customization job within the StatusDetails response field.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.42.0](service/bedrockagent/CHANGELOG.md#v1420-2025-04-30)
  * **Feature**: Features:    Add inline code node to prompt flow
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.42.0](service/bedrockagentruntime/CHANGELOG.md#v1420-2025-04-30)
  * **Feature**: Support for Custom Orchestration within InlineAgents
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.25.0](service/cleanrooms/CHANGELOG.md#v1250-2025-04-30)
  * **Feature**: This release adds support for ProtectedQuery results to be delivered to more than one collaboration member via the new distribute output configuration in StartProtectedQuery.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.48.0](service/cloudwatchlogs/CHANGELOG.md#v1480-2025-04-30)
  * **Feature**: CloudWatch Logs supports "DELIVERY" log class. This log class is used only for delivering AWS Lambda logs to Amazon S3 or Amazon Data Firehose.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.11.0](service/deadline/CHANGELOG.md#v1110-2025-04-30)
  * **Feature**: Adds support for tag management on workers and tag inheritance from fleets to their associated workers.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.213.0](service/ec2/CHANGELOG.md#v12130-2025-04-30)
  * **Feature**: Launch of cost distribution feature for IPAM owners to distribute costs to internal teams.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.44.0](service/ecr/CHANGELOG.md#v1440-2025-04-30)
  * **Feature**: Adds dualstack support for Amazon Elastic Container Registry (Amazon ECR).
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.33.0](service/ecrpublic/CHANGELOG.md#v1330-2025-04-30)
  * **Feature**: Adds dualstack support for Amazon Elastic Container Registry Public (Amazon ECR Public).
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.13.0](service/mailmanager/CHANGELOG.md#v1130-2025-04-30)
  * **Feature**: Introducing new RuleSet rule PublishToSns action, which allows customers to publish email notifications to an Amazon SNS topic. New PublishToSns action enables customers to easily integrate their email workflows via Amazon SNS, allowing them to notify other systems about important email events.

# Release (2025-04-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.25.0](service/connectcases/CHANGELOG.md#v1250-2025-04-29)
  * **Feature**: Introduces CustomEntity as part of the UserUnion data type. This field is used to indicate the entity who is performing the API action.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.34.3](service/dataexchange/CHANGELOG.md#v1343-2025-04-29)
  * **Bug Fix**: **BREAKING CHANGE**: The type of Dataexchange#UpdateRevision$Finalized has been changed from `bool` to `*bool`. efore this change, the field was incorrectly marked as having a default value of false by the service, which made it functionally impossible for users to set this value to false
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.34.0](service/kinesis/CHANGELOG.md#v1340-2025-04-29)
  * **Feature**: Amazon KDS now supports tagging and attribute-based access control (ABAC) for enhanced fan-out consumers.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.20.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1200-2025-04-29)
  * **Feature**: AWS End User Messaging has added MONITOR and FILTER functionality to SMS Protect.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.26.0](service/qbusiness/CHANGELOG.md#v1260-2025-04-29)
  * **Feature**: Add support for anonymous user access for Q Business applications
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.189.0](service/sagemaker/CHANGELOG.md#v11890-2025-04-29)
  * **Feature**: Introduced support for P5en instance types on SageMaker Studio for JupyterLab and CodeEditor applications.
* `github.com/aws/aws-sdk-go-v2/service/sagemakermetrics`: [v1.14.0](service/sagemakermetrics/CHANGELOG.md#v1140-2025-04-29)
  * **Feature**: SageMaker Metrics Service now supports FIPS endpoint in all US and Canada Commercial regions.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.59.0](service/ssm/CHANGELOG.md#v1590-2025-04-29)
  * **Feature**: This release adds support for just-In-time node access in AWS Systems Manager. Just-in-time node access enables customers to move towards zero standing privileges by requiring operators to request access and obtain approval before remotely connecting to nodes managed by the SSM Agent.
* `github.com/aws/aws-sdk-go-v2/service/ssmguiconnect`: [v1.0.0](service/ssmguiconnect/CHANGELOG.md#v100-2025-04-29)
  * **Release**: New AWS service client module
  * **Feature**: This release adds API support for the connection recording GUI Connect feature of AWS Systems Manager

# Release (2025-04-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.32.0](service/acm/CHANGELOG.md#v1320-2025-04-28)
  * **Feature**: Add support for file-based HTTP domain control validation, available through Amazon CloudFront.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.46.0](service/cloudfront/CHANGELOG.md#v1460-2025-04-28)
  * **Feature**: Add distribution tenant, connection group, and multi-tenant distribution APIs to the CloudFront SDK.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.43.1](service/dynamodb/CHANGELOG.md#v1431-2025-04-28)
  * **Documentation**: Doc only update for GSI descriptions.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.42.0](service/imagebuilder/CHANGELOG.md#v1420-2025-04-28)
  * **Feature**: Add integration with SSM Parameter Store to Image Builder.
* `github.com/aws/aws-sdk-go-v2/service/internal/checksum`: [v1.7.1](service/internal/checksum/CHANGELOG.md#v171-2025-04-28)
  * **Bug Fix**: Don't emit warnings about lack of checksum validation for non-200 responses.

# Release (2025-04-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.30.0](service/bedrockruntime/CHANGELOG.md#v1300-2025-04-25)
  * **Feature**: You can now reference images and documents stored in Amazon S3 when using InvokeModel and Converse APIs with Amazon Nova Lite and Nova Pro. This enables direct integration of S3-stored multimedia assets in your model requests without manual downloading or base64 encoding.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.56.2](service/ecs/CHANGELOG.md#v1562-2025-04-25)
  * **Documentation**: Documentation only release for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/marketplacedeployment`: [v1.7.3](service/marketplacedeployment/CHANGELOG.md#v173-2025-04-25)
  * **Documentation**: Doc only update for the AWS Marketplace Deployment Service that fixes several customer-reported issues.

# Release (2025-04-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.34.0](service/apprunner/CHANGELOG.md#v1340-2025-04-24)
  * **Feature**: AWS App Runner adds Node.js 22 runtime.
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.46.0](service/appsync/CHANGELOG.md#v1460-2025-04-24)
  * **Feature**: Add data source support to Event APIs
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation`: [v1.3.0](service/bedrockdataautomation/CHANGELOG.md#v130-2025-04-24)
  * **Feature**: Added support for modality routing and modality enablement on CreateDataAutomationProject and UpdateDataAutomationProject APIs
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.43.0](service/dynamodb/CHANGELOG.md#v1430-2025-04-24)
  * **Feature**: Add support for ARN-sourced account endpoint generation for TransactWriteItems. This will generate account endpoints for DynamoDB TransactWriteItems requests using ARN-sourced account ID when available.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.56.1](service/ecs/CHANGELOG.md#v1561-2025-04-24)
  * **Documentation**: Documentation only release for Amazon ECS
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.4.2](service/pcs/CHANGELOG.md#v142-2025-04-24)
  * **Documentation**: Documentation-only update: added valid values for the version property of the Scheduler and SchedulerRequest data types.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.95.0](service/rds/CHANGELOG.md#v1950-2025-04-24)
  * **Feature**: This Amazon RDS release adds support for managed master user passwords for Oracle CDBs.

# Release (2025-04-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.17.73](feature/s3/manager/CHANGELOG.md#v11773-2025-04-23)
  * **Bug Fix**: Abort multi part download if the object is modified during download
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.60.0](service/codebuild/CHANGELOG.md#v1600-2025-04-23)
  * **Feature**: Add support for custom instance type for reserved capacity fleets
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.56.0](service/ecs/CHANGELOG.md#v1560-2025-04-23)
  * **Feature**: Add support to roll back an In_Progress ECS Service Deployment
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.17.4](service/resourceexplorer2/CHANGELOG.md#v1174-2025-04-23)
  * **Documentation**: Documentation-only update for CreateView option correction

# Release (2025-04-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.24.0](service/account/CHANGELOG.md#v1240-2025-04-22)
  * **Feature**: AWS Account Management now supports account name update via IAM principals.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.52.0](service/cognitoidentityprovider/CHANGELOG.md#v1520-2025-04-22)
  * **Feature**: This release adds refresh token rotation.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.212.0](service/ec2/CHANGELOG.md#v12120-2025-04-22)
  * **Feature**: Added support for  ClientRouteEnforcementOptions flag in CreateClientVpnEndpoint and ModifyClientVpnEndpoint requests and DescribeClientVpnEndpoints responses
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.18.0](service/entityresolution/CHANGELOG.md#v1180-2025-04-22)
  * **Feature**: To expand support for matching records using digital identifiers with TransUnion
* `github.com/aws/aws-sdk-go-v2/service/mq`: [v1.29.0](service/mq/CHANGELOG.md#v1290-2025-04-22)
  * **Feature**: You can now delete Amazon MQ broker configurations using the DeleteConfiguration API. For more information, see Configurations in the Amazon MQ API Reference.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.27.0](service/redshiftserverless/CHANGELOG.md#v1270-2025-04-22)
  * **Feature**: Provides new and updated API members to support the Redshift Serverless reservations feature.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.57.0](service/s3control/CHANGELOG.md#v1570-2025-04-22)
  * **Feature**: Fix endpoint resolution test cases

# Release (2025-04-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.17.0](service/arczonalshift/CHANGELOG.md#v1170-2025-04-21)
  * **Feature**: Updates to documentation and exception types for Zonal Autoshift
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.31.0](service/budgets/CHANGELOG.md#v1310-2025-04-21)
  * **Feature**: Releasing the new Budget FilterExpression and Metrics fields to support more granular filtering options. These new fields are intended to replace CostFilters and CostTypes, which are deprecated as of 2025/18/04.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.37.4](service/firehose/CHANGELOG.md#v1374-2025-04-21)
  * **Documentation**: Documentation update regarding the number of streams you can create using the CreateDeliveryStream API.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.47.0](service/mediatailor/CHANGELOG.md#v1470-2025-04-21)
  * **Feature**: Added support for Recurring Prefetch and Traffic Shaping on both Single and Recurring Prefetch. ListPrefetchSchedules now return single prefetchs by default and can be provided scheduleType of SINGLE, RECURRING, AND ALL.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.25.0](service/qbusiness/CHANGELOG.md#v1250-2025-04-21)
  * **Feature**: The CheckDocumentAccess API for Amazon Q Business is a self-service debugging API that allows administrators to verify document access permissions and review Access Control List (ACL) configurations.

# Release (2025-04-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.17.0](service/qconnect/CHANGELOG.md#v1170-2025-04-18)
  * **Feature**: This release adds support for the following capabilities: Chunking generative answer replies from Amazon Q in Connect. Integration support for the use of additional LLM models with Amazon Q in Connect.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.188.0](service/sagemaker/CHANGELOG.md#v11880-2025-04-18)
  * **Feature**: This release adds a new Neuron driver option in InferenceAmiVersion parameter for ProductionVariant. Additionally, it adds support for fetching model lifecycle status in the ListModelPackages API. Users can now use this API to view the lifecycle stage of models that have been shared with them.
* `github.com/aws/aws-sdk-go-v2/service/servicequotas`: [v1.27.0](service/servicequotas/CHANGELOG.md#v1270-2025-04-18)
  * **Feature**: Add new optional SupportCaseAllowed query parameter to the RequestServiceQuotaIncrease API

# Release (2025-04-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.39.0](service/accessanalyzer/CHANGELOG.md#v1390-2025-04-17)
  * **Feature**: Added new resource types to evaluate for public access in resource policies and added support for S3 directory bucket access points.
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.33.0](service/amp/CHANGELOG.md#v1330-2025-04-17)
  * **Feature**: Add Workspace Configuration APIs for Amazon Prometheus
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.52.4](service/autoscaling/CHANGELOG.md#v1524-2025-04-17)
  * **Documentation**: Doc only update for EC2 Auto Scaling.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.32.0](service/bedrock/CHANGELOG.md#v1320-2025-04-17)
  * **Feature**: With this release, Bedrock Evaluation will now support custom metrics for evaluation.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.128.0](service/connect/CHANGELOG.md#v11280-2025-04-17)
  * **Feature**: This release adds following capabilities to Contact Lens Rules APIs 1/ 'ASSIGN_SLA' action and  '$.Case.TemplateId' comparison value for 'OnCaseCreate' and 'OnCaseUpdate' event sources 2/ 'OnSlaBreach' Cases event source which supports '$.RelatedItem.SlaConfiguration.Name' comparison value
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.55.0](service/ecs/CHANGELOG.md#v1550-2025-04-17)
  * **Feature**: Adds a new AccountSetting - defaultLogDriverMode for ECS.
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.27.0](service/memorydb/CHANGELOG.md#v1270-2025-04-17)
  * **Feature**: Added support for IPv6 and dual stack for Valkey and Redis clusters. Customers can now launch new Valkey and Redis clusters with IPv6 and dual stack networking support.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.30.0](service/omics/CHANGELOG.md#v1300-2025-04-17)
  * **Feature**: Add versioning for HealthOmics workflows

# Release (2025-04-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.24.0](service/connectcases/CHANGELOG.md#v1240-2025-04-16)
  * **Feature**: This feature provides capabilities to help track and meet service level agreements (SLAs) on cases programmatically. It allows configuring a new related item of type `Sla` on a case using CreateRelatedItem API and provides the ability to search for this new related item using SearchRelatedItems API.
* `github.com/aws/aws-sdk-go-v2/service/dsql`: [v1.2.0](service/dsql/CHANGELOG.md#v120-2025-04-16)
  * **Feature**: Added GetClusterEndpointService API. The new API allows retrieving endpoint service name specific to a cluster.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.64.0](service/eks/CHANGELOG.md#v1640-2025-04-16)
  * **Feature**: Added support for new AL2023 ARM64 NVIDIA AMIs to the supported AMITypes.
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.39.0](service/eventbridge/CHANGELOG.md#v1390-2025-04-16)
  * **Feature**: Adding support for KmsKeyIdentifer in CreateConnection, UpdateConnection and DescribeConnection APIs
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.29.0](service/resourcegroups/CHANGELOG.md#v1290-2025-04-16)
  * **Feature**: Resource Groups: TagSyncTasks can be created with ResourceQuery
* `github.com/aws/aws-sdk-go-v2/service/s3tables`: [v1.3.0](service/s3tables/CHANGELOG.md#v130-2025-04-16)
  * **Feature**: S3 Tables now supports setting encryption configurations on table buckets and tables. Encryption configurations can use server side encryption using AES256 or KMS customer-managed keys.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.33.4](service/servicecatalog/CHANGELOG.md#v1334-2025-04-16)
  * **Documentation**: Updated default value for the access-level-filter in SearchProvisionedProducts API to Account. For access to userLevel or roleLevel, the user must provide access-level-filter parameter.

# Release (2025-04-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.17.0](service/entityresolution/CHANGELOG.md#v1170-2025-04-14)
  * **Feature**: This is to add new metrics to our GetIdMappingJob API and also update uniqueId naming for batchDeleteUniqueIds API to be more accurate
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.12.0](service/taxsettings/CHANGELOG.md#v1120-2025-04-14)
  * **Feature**: Indonesia SOR Tax Registration Launch

# Release (2025-04-11)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/expression`: [v1.7.79](feature/dynamodb/expression/CHANGELOG.md#v1779-2025-04-11)
  * **Bug Fix**: allow nested list indices in expressions
* `github.com/aws/aws-sdk-go-v2/service/connectcontactlens`: [v1.28.0](service/connectcontactlens/CHANGELOG.md#v1280-2025-04-11)
  * **Feature**: Making sentiment optional for ListRealtimeContactAnalysisSegments Response depending on conversational analytics configuration
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.33.0](service/detective/CHANGELOG.md#v1330-2025-04-11)
  * **Feature**: Add support for Detective DualStack endpoints
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.42.4](service/dynamodb/CHANGELOG.md#v1424-2025-04-11)
  * **Documentation**: Doc only update for API descriptions.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.29.0](service/marketplaceentitlementservice/CHANGELOG.md#v1290-2025-04-11)
  * **Feature**: Add support for Marketplace Entitlement Service dual-stack endpoints for CN and GOV regions
* `github.com/aws/aws-sdk-go-v2/service/marketplacemetering`: [v1.29.0](service/marketplacemetering/CHANGELOG.md#v1290-2025-04-11)
  * **Feature**: Add support for Marketplace Metering Service dual-stack endpoints for CN regions
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.23.0](service/verifiedpermissions/CHANGELOG.md#v1230-2025-04-11)
  * **Feature**: Adds deletion protection support to policy stores. Deletion protection is disabled by default, can be enabled via the CreatePolicyStore or UpdatePolicyStore APIs, and is visible in GetPolicyStore.

# Release (2025-04-10)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/expression`: [v1.7.78](feature/dynamodb/expression/CHANGELOG.md#v1778-2025-04-10)
  * **Bug Fix**: allow nested list indices in expressions
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.36.0](service/applicationautoscaling/CHANGELOG.md#v1360-2025-04-10)
  * **Feature**: Application Auto Scaling now supports horizontal scaling for Elasticache Memcached self-designed clusters using target tracking scaling policies and scheduled scaling.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.46.0](service/elasticache/CHANGELOG.md#v1460-2025-04-10)
  * **Feature**: AWS ElastiCache SDK now supports using MemcachedUpgradeConfig parameter with ModifyCacheCluster API to enable updating Memcached cache node types. Please refer to updated AWS ElastiCache public documentation for detailed information on API usage and implementation.
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.21.0](service/m2/CHANGELOG.md#v1210-2025-04-10)
  * **Feature**: Introduce three new APIs: CreateDataSetExportTask, GetDataSetExportTask and ListDataSetExportHistory. Add support for batch restart for Blu Age applications.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.74.0](service/medialive/CHANGELOG.md#v1740-2025-04-10)
  * **Feature**: AWS Elemental MediaLive / Features : Add support for CMAF Ingest CaptionLanguageMappings, TimedMetadataId3 settings, and Link InputResolution.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.24.0](service/qbusiness/CHANGELOG.md#v1240-2025-04-10)
  * **Feature**: Adds functionality to enable/disable a new Q Business Hallucination Reduction feature. If enabled, Q Business will detect and attempt to remove Hallucinations from certain Chat requests.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.86.0](service/quicksight/CHANGELOG.md#v1860-2025-04-10)
  * **Feature**: Add support to analysis and sheet level highlighting in QuickSight.

# Release (2025-04-09)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/expression`: [v1.7.77](feature/dynamodb/expression/CHANGELOG.md#v1777-2025-04-09)
  * **Bug Fix**: allow nested list indices in expressions
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.8.0](service/controlcatalog/CHANGELOG.md#v180-2025-04-09)
  * **Feature**: The GetControl API now surfaces a control's Severity, CreateTime, and Identifier for a control's Implementation. The ListControls API now surfaces a control's Behavior, Severity, CreateTime, and Identifier for a control's Implementation.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.42.2](service/dynamodb/CHANGELOG.md#v1422-2025-04-09)
  * **Documentation**: Documentation update for secondary indexes and Create_Table.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.109.0](service/glue/CHANGELOG.md#v11090-2025-04-09)
  * **Feature**: The TableOptimizer APIs in AWS Glue now return the DpuHours field in each TableOptimizerRun, providing clients visibility to the DPU-hours used for billing in managed Apache Iceberg table compaction optimization.
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.33.0](service/groundstation/CHANGELOG.md#v1330-2025-04-09)
  * **Feature**: Support tagging Agents and adjust input field validations
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.60.0](service/transfer/CHANGELOG.md#v1600-2025-04-09)
  * **Feature**: This launch includes 2 enhancements to SFTP connectors user-experience: 1) Customers can self-serve concurrent connections setting for their connectors, and 2) Customers can discover the public host key of remote servers using their SFTP connectors.

# Release (2025-04-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.49.0](service/costexplorer/CHANGELOG.md#v1490-2025-04-08)
  * **Feature**: This release supports Pagination traits on Cost Anomaly Detection APIs.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.14.0](service/costoptimizationhub/CHANGELOG.md#v1140-2025-04-08)
  * **Feature**: This release adds resource type "MemoryDbReservedInstances" and resource type "DynamoDbReservedCapacity" to the GetRecommendation, ListRecommendations, and ListRecommendationSummaries APIs to support new MemoryDB and DynamoDB RI recommendations.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.26.0](service/iotfleetwise/CHANGELOG.md#v1260-2025-04-08)
  * **Feature**: This release adds the option to update the strategy of state templates already associated to a vehicle, without the need to remove and re-add them.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.57.2](service/securityhub/CHANGELOG.md#v1572-2025-04-08)
  * **Documentation**: Documentation updates for AWS Security Hub.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.37.0](service/storagegateway/CHANGELOG.md#v1370-2025-04-08)
  * **Feature**: Added new ActiveDirectoryStatus value, ListCacheReports paginator, and support for longer pagination tokens.
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.11.0](service/taxsettings/CHANGELOG.md#v1110-2025-04-08)
  * **Feature**: Uzbekistan Launch on TaxSettings Page

# Release (2025-04-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.31.0](service/bedrock/CHANGELOG.md#v1310-2025-04-07)
  * **Feature**: New options for how to handle harmful content detected by Amazon Bedrock Guardrails.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.29.0](service/bedrockruntime/CHANGELOG.md#v1290-2025-04-07)
  * **Feature**: New options for how to handle harmful content detected by Amazon Bedrock Guardrails.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.59.0](service/codebuild/CHANGELOG.md#v1590-2025-04-07)
  * **Feature**: AWS CodeBuild now offers an enhanced debugging experience.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.108.0](service/glue/CHANGELOG.md#v11080-2025-04-07)
  * **Feature**: Add input validations for multiple Glue APIs
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.73.0](service/medialive/CHANGELOG.md#v1730-2025-04-07)
  * **Feature**: AWS Elemental MediaLive now supports SDI inputs to MediaLive Anywhere Channels in workflows that use AWS SDKs.
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.41.0](service/personalize/CHANGELOG.md#v1410-2025-04-07)
  * **Feature**: Add support for eventsConfig for CreateSolution, UpdateSolution, DescribeSolution, DescribeSolutionVersion. Add support for GetSolutionMetrics to return weighted NDCG metrics when eventsConfig is enabled for the solution.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.59.0](service/transfer/CHANGELOG.md#v1590-2025-04-07)
  * **Feature**: This launch enables customers to manage contents of their remote directories, by deleting old files or moving files to archive folders in remote servers once they have been retrieved. Customers will be able to automate the process using event-driven architecture.

# Release (2025-04-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/directoryservicedata`: [v1.3.3](service/directoryservicedata/CHANGELOG.md#v133-2025-04-04)
  * **Documentation**: Doc only update - fixed broken links.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.211.2](service/ec2/CHANGELOG.md#v12112-2025-04-04)
  * **Documentation**: Doc-only updates for Amazon EC2
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.38.0](service/eventbridge/CHANGELOG.md#v1380-2025-04-04)
  * **Feature**: Amazon EventBridge adds support for customer-managed keys on Archives and validations for two fields: eventSourceArn and kmsKeyIdentifier.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.56.2](service/s3control/CHANGELOG.md#v1562-2025-04-04)
  * **Documentation**: Updated max size of Prefixes parameter of Scope data type.

# Release (2025-04-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/expression`: [v1.7.76](feature/dynamodb/expression/CHANGELOG.md#v1776-2025-04-03)
  * **Bug Fix**: allow nested list indices in expressions
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.41.0](service/bedrockagent/CHANGELOG.md#v1410-2025-04-03)
  * **Feature**: Added optional "customMetadataField" for Amazon Aurora knowledge bases, allowing single-column metadata. Also added optional "textIndexName" for MongoDB Atlas knowledge bases, enabling hybrid search support.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.22.0](service/chimesdkvoice/CHANGELOG.md#v1220-2025-04-03)
  * **Feature**: Added FOC date as an attribute of PhoneNumberOrder, added AccessDeniedException as a possible return type of ValidateE911Address
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.12.0](service/mailmanager/CHANGELOG.md#v1120-2025-04-03)
  * **Feature**: Add support for Dual_Stack and PrivateLink types of IngressPoint. For configuration requests, SES Mail Manager will now accept both IPv4/IPv6 dual-stack endpoints and AWS PrivateLink VPC endpoints for email receiving.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.46.2](service/opensearch/CHANGELOG.md#v1462-2025-04-03)
  * **Documentation**: Improve descriptions for various API commands and data types.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.51.0](service/route53/CHANGELOG.md#v1510-2025-04-03)
  * **Feature**: Added us-gov-east-1 and us-gov-west-1 as valid Latency Based Routing regions for change-resource-record-sets.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.187.0](service/sagemaker/CHANGELOG.md#v11870-2025-04-03)
  * **Feature**: Adds support for i3en, m7i, r7i instance types for SageMaker Hyperpod
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.45.0](service/sesv2/CHANGELOG.md#v1450-2025-04-03)
  * **Feature**: This release enables customers to provide attachments in the SESv2 SendEmail and SendBulkEmail APIs.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.45.0](service/transcribe/CHANGELOG.md#v1450-2025-04-03)
  * **Feature**: This Feature Adds Support for the "zh-HK" Locale for Batch Operations

# Release (2025-04-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.11.0](service/applicationsignals/CHANGELOG.md#v1110-2025-04-02)
  * **Feature**: Application Signals now supports creating Service Level Objectives on service dependencies. Users can now create or update SLOs on discovered service dependencies to monitor their standard application metrics.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.58.0](service/codebuild/CHANGELOG.md#v1580-2025-04-02)
  * **Feature**: This release adds support for environment type WINDOWS_SERVER_2022_CONTAINER in ProjectEnvironment
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.43.1](service/ecr/CHANGELOG.md#v1431-2025-04-02)
  * **Documentation**: Fix for customer issues related to AWS account ID and size limitation for token.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.54.4](service/ecs/CHANGELOG.md#v1544-2025-04-02)
  * **Documentation**: This is an Amazon ECS documentation only update to address various tickets.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.51.0](service/lexmodelsv2/CHANGELOG.md#v1510-2025-04-02)
  * **Feature**: Release feature of errorlogging for lex bot, customer can config this feature in bot version to generate log for error exception which helps debug
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.72.0](service/medialive/CHANGELOG.md#v1720-2025-04-02)
  * **Feature**: Added support for SMPTE 2110 inputs when running a channel in a MediaLive Anywhere cluster. This feature enables ingestion of SMPTE 2110-compliant video, audio, and ancillary streams by reading SDP files that AWS Elemental MediaLive can retrieve from a network source.

# Release (2025-04-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.24.0](service/cleanrooms/CHANGELOG.md#v1240-2025-04-01)
  * **Feature**: This release adds support for updating the analytics engine of a collaboration.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.186.0](service/sagemaker/CHANGELOG.md#v11860-2025-04-01)
  * **Feature**: Added tagging support for SageMaker notebook instance lifecycle configurations

# Release (2025-03-31)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.28.0](service/bedrockruntime/CHANGELOG.md#v1280-2025-03-31)
  * **Feature**: Add Prompt Caching support to Converse and ConverseStream APIs
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.10.0](service/deadline/CHANGELOG.md#v1100-2025-03-31)
  * **Feature**: With this release you can use a new field to specify the search term match type. Search term match types currently support fuzzy and contains matching.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.211.0](service/ec2/CHANGELOG.md#v12110-2025-03-31)
  * **Feature**: Release VPC Route Server, a new feature allowing dynamic routing in VPCs.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.63.0](service/eks/CHANGELOG.md#v1630-2025-03-31)
  * **Feature**: Add support for updating RemoteNetworkConfig for hybrid nodes on EKS UpdateClusterConfig API
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.28.0](service/marketplaceentitlementservice/CHANGELOG.md#v1280-2025-03-31)
  * **Feature**: Add support for Marketplace Entitlement Service dual-stack endpoints.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.50.0](service/outposts/CHANGELOG.md#v1500-2025-03-31)
  * **Feature**: Enabling Asset Level Capacity Management feature, which allows customers to create a Capacity Task for a single Asset on their active Outpost.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.79.0](service/s3/CHANGELOG.md#v1790-2025-03-31)
  * **Feature**: Amazon S3 adds support for S3 Access Points for directory buckets in AWS Dedicated Local Zones
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.56.0](service/s3control/CHANGELOG.md#v1560-2025-03-31)
  * **Feature**: Amazon S3 adds support for S3 Access Points for directory buckets in AWS Dedicated Local Zones
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.44.0](service/sesv2/CHANGELOG.md#v1440-2025-03-31)
  * **Feature**: Add dual-stack support to global endpoints.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.58.0](service/transfer/CHANGELOG.md#v1580-2025-03-31)
  * **Feature**: Add WebAppEndpointPolicy support for WebApps

# Release (2025-03-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.30.0](service/apigateway/CHANGELOG.md#v1300-2025-03-28)
  * **Feature**: Adds support for setting the IP address type to allow dual-stack or IPv4 address types to invoke your APIs or domain names.
* `github.com/aws/aws-sdk-go-v2/service/apigatewayv2`: [v1.27.0](service/apigatewayv2/CHANGELOG.md#v1270-2025-03-28)
  * **Feature**: Adds support for setting the IP address type to allow dual-stack or IPv4 address types to invoke your APIs or domain names.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.27.0](service/bedrockruntime/CHANGELOG.md#v1270-2025-03-28)
  * **Feature**: Launching Multi-modality Content Filter for Amazon Bedrock Guardrails.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.57.0](service/codebuild/CHANGELOG.md#v1570-2025-03-28)
  * **Feature**: This release adds support for cacheNamespace in ProjectCache
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.54.3](service/ecs/CHANGELOG.md#v1543-2025-03-28)
  * **Documentation**: This is an Amazon ECS documentation only release that addresses tickets.
* `github.com/aws/aws-sdk-go-v2/service/marketplacemetering`: [v1.28.0](service/marketplacemetering/CHANGELOG.md#v1280-2025-03-28)
  * **Feature**: Add support for Marketplace Metering Service dual-stack endpoints.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.34.0](service/networkmanager/CHANGELOG.md#v1340-2025-03-28)
  * **Feature**: Add support for NetworkManager Dualstack endpoints.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.18.0](service/paymentcryptography/CHANGELOG.md#v1180-2025-03-28)
  * **Feature**: The service adds support for transferring AES-256 and other keys between the service and other service providers and HSMs. This feature uses ECDH to derive a one-time key transport key to enable these secure key exchanges.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.85.0](service/quicksight/CHANGELOG.md#v1850-2025-03-28)
  * **Feature**: RLS permission dataset with userAs: RLS_RULES flag, Q in QuickSight/Threshold Alerts/Schedules/Snapshots in QS embedding, toggle dataset refresh email alerts via API, transposed table with options: column width, type and index, toggle Q&A on dashboards, Oracle Service Name when creating data source.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.185.0](service/sagemaker/CHANGELOG.md#v11850-2025-03-28)
  * **Feature**: TransformAmiVersion for Batch Transform and SageMaker Search Service Aggregate Search API Extension

# Release (2025-03-27)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.52.0](service/batch/CHANGELOG.md#v1520-2025-03-27)
  * **Feature**: This release will enable two features: Firelens log driver, and Execute Command on Batch jobs on ECS. Both features will be passed through to ECS.
* `github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator`: [v1.4.0](service/bcmpricingcalculator/CHANGELOG.md#v140-2025-03-27)
  * **Feature**: Added standaloneAccountRateTypeSelections for GetPreferences and UpdatePreferences APIs. Added STALE enum value to status attribute in GetBillScenario and UpdateBillScenario APIs.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.41.0](service/bedrockagentruntime/CHANGELOG.md#v1410-2025-03-27)
  * **Feature**: bedrock flow now support node action trace.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.59.0](service/cloudformation/CHANGELOG.md#v1590-2025-03-27)
  * **Feature**: Adding support for the new parameter "ScanFilters" in the CloudFormation StartResourceScan API. When this parameter is included, the StartResourceScan API will initiate a scan limited to the resource types specified by the parameter.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.29.0](service/datazone/CHANGELOG.md#v1290-2025-03-27)
  * **Feature**: This release adds new action type of Create Listing Changeset for the Metadata Enforcement Rule feature.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.62.0](service/eks/CHANGELOG.md#v1620-2025-03-27)
  * **Feature**: Added support for BOTTLEROCKET FIPS AMIs to AMI types in US regions.
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.41.0](service/gamelift/CHANGELOG.md#v1410-2025-03-27)
  * **Feature**: Amazon GameLift Servers add support for additional instance types.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.41.0](service/iam/CHANGELOG.md#v1410-2025-03-27)
  * **Feature**: Update IAM dual-stack endpoints for BJS, IAD and PDT partitions
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.184.0](service/sagemaker/CHANGELOG.md#v11840-2025-03-27)
  * **Feature**: add: recovery mode for SageMaker Studio apps
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.30.0](service/ssooidc/CHANGELOG.md#v1300-2025-03-27)
  * **Feature**: This release adds AwsAdditionalDetails in the CreateTokenWithIAM API response.

# Release (2025-03-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.16.0](service/arczonalshift/CHANGELOG.md#v1160-2025-03-26)
  * **Feature**: Add new shiftType field for ARC zonal shifts.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.32.0](service/directconnect/CHANGELOG.md#v1320-2025-03-26)
  * **Feature**: With this release, AWS Direct Connect allows you to tag your Direct Connect gateways. Tags are metadata that you can create and use to manage your Direct Connect gateways. For more information about tagging, see AWS Tagging Strategies.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.71.0](service/mediaconvert/CHANGELOG.md#v1710-2025-03-26)
  * **Feature**: This release adds a configurable Quality Level setting for the top rendition of Auto ABR jobs
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.46.0](service/mediatailor/CHANGELOG.md#v1460-2025-03-26)
  * **Feature**: Add support for log filtering which allow customers to filter out selected event types from logs.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.48.0](service/polly/CHANGELOG.md#v1480-2025-03-26)
  * **Feature**: Added support for the new voice - Jihye (ko-KR). Jihye is available as a Neural voice only.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.94.2](service/rds/CHANGELOG.md#v1942-2025-03-26)
  * **Documentation**: Add note about the Availability Zone where RDS restores the DB cluster for the RestoreDBClusterToPointInTime operation.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.60.0](service/wafv2/CHANGELOG.md#v1600-2025-03-26)
  * **Feature**: This release adds the ability to associate an AWS WAF v2 web ACL with an AWS Amplify App.

# Release (2025-03-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.40.0](service/bedrockagent/CHANGELOG.md#v1400-2025-03-25)
  * **Feature**: Adding support for Amazon OpenSearch Managed clusters as a vector database in Knowledge Bases for Amazon Bedrock
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.61.0](service/eks/CHANGELOG.md#v1610-2025-03-25)
  * **Feature**: Added support to override upgrade-blocking readiness checks via force flag when updating a cluster.
* `github.com/aws/aws-sdk-go-v2/service/gameliftstreams`: [v1.1.0](service/gameliftstreams/CHANGELOG.md#v110-2025-03-25)
  * **Feature**: Minor updates to improve developer experience.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.18.0](service/keyspaces/CHANGELOG.md#v1180-2025-03-25)
  * **Feature**: Removing replication region limitation for Amazon Keyspaces Multi-Region Replication APIs.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.27.0](service/marketplaceentitlementservice/CHANGELOG.md#v1270-2025-03-25)
  * **Feature**: This release enhances the GetEntitlements API to support new filter CUSTOMER_AWS_ACCOUNT_ID in request and CustomerAWSAccountId field in response.
* `github.com/aws/aws-sdk-go-v2/service/marketplacemetering`: [v1.27.0](service/marketplacemetering/CHANGELOG.md#v1270-2025-03-25)
  * **Feature**: This release enhances the BatchMeterUsage API to support new field CustomerAWSAccountId in request and response and making CustomerIdentifier optional. CustomerAWSAccountId or CustomerIdentifier must be provided in request but not both.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.183.0](service/sagemaker/CHANGELOG.md#v11830-2025-03-25)
  * **Feature**: This release adds support for customer-managed KMS keys in Amazon SageMaker Partner AI Apps
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.13.0](service/workspacesthinclient/CHANGELOG.md#v1130-2025-03-25)
  * **Feature**: Deprecate tags field in Get API responses

# Release (2025-03-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.47.0](service/iotwireless/CHANGELOG.md#v1470-2025-03-24)
  * **Feature**: Mark EutranCid under LteNmr optional.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.4.0](service/pcs/CHANGELOG.md#v140-2025-03-24)
  * **Feature**: ClusterName/ClusterIdentifier, ComputeNodeGroupName/ComputeNodeGroupIdentifier, and QueueName/QueueIdentifier can now have 10 characters, and a minimum of 3 characters. The TagResource API action can now return ServiceQuotaExceededException.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.16.2](service/qconnect/CHANGELOG.md#v1162-2025-03-24)
  * **Documentation**: Provides the correct value for supported model ID.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.58.0](service/ssm/CHANGELOG.md#v1580-2025-03-24)
  * **Feature**: This release adds the AvailableSecurityUpdatesComplianceStatus field to patch baseline operations, as well as the AvailableSecurityUpdateCount and InstancesWithAvailableSecurityUpdates to patch state operations. Applies to Windows Server managed nodes only.

# Release (2025-03-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.30.0](service/bedrock/CHANGELOG.md#v1300-2025-03-21)
  * **Feature**: A CustomModelUnit(CMU) is an abstract view of the hardware utilization that Bedrock needs to host a a single copy of your custom imported model. Bedrock determines the number of CMUs that a model copy needs when you import the custom model. You can use CMUs to estimate the cost of Inference's.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.28.0](service/datazone/CHANGELOG.md#v1280-2025-03-21)
  * **Feature**: Add support for overriding selection of default AWS IAM Identity Center instance as part of Amazon DataZone domain APIs.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.27.0](service/route53recoverycontrolconfig/CHANGELOG.md#v1270-2025-03-21)
  * **Feature**: Adds dual-stack (IPv4 and IPv6) endpoint support for route53-recovery-control-config operations, opt-in dual-stack addresses for cluster endpoints, and UpdateCluster API to update the network-type of clusters between IPv4 and dual-stack.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.182.0](service/sagemaker/CHANGELOG.md#v11820-2025-03-21)
  * **Feature**: This release does the following: 1.) Adds DurationHours as a required field to the SearchTrainingPlanOfferings action in the SageMaker AI API; 2.) Adds support for G6e instance types for SageMaker AI inference optimization jobs.

# Release (2025-03-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.32.0](service/amplify/CHANGELOG.md#v1320-2025-03-20)
  * **Feature**: Added appId field to Webhook responses
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.29.0](service/bedrock/CHANGELOG.md#v1290-2025-03-20)
  * **Feature**: With this release, Bedrock Evaluation will now support bring your own inference responses.
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.7.2](service/controlcatalog/CHANGELOG.md#v172-2025-03-20)
  * **Documentation**: Add ExemptAssumeRoot parameter to adapt for new AWS AssumeRoot capability.
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.11.0](service/mailmanager/CHANGELOG.md#v1110-2025-03-20)
  * **Feature**: Amazon SES Mail Manager. Extended rule string and boolean expressions to support analysis in condition evaluation. Extended ingress point string expression to support analysis in condition evaluation
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.47.0](service/networkfirewall/CHANGELOG.md#v1470-2025-03-20)
  * **Feature**: You can now use flow operations to either flush or capture traffic monitored in your firewall's flow table.

# Release (2025-03-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.210.1](service/ec2/CHANGELOG.md#v12101-2025-03-19)
  * **Documentation**: Doc-only updates for EC2 for March 2025.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.71.0](service/lambda/CHANGELOG.md#v1710-2025-03-19)
  * **Feature**: Add Ruby 3.4 (ruby3.4) support to AWS Lambda.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.39.0](service/mediaconnect/CHANGELOG.md#v1390-2025-03-19)
  * **Feature**: This release adds support for NDI flow outputs in AWS Elemental MediaConnect. You can now send content from your MediaConnect transport streams directly to your NDI environment using the new NDI output type.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.181.0](service/sagemaker/CHANGELOG.md#v11810-2025-03-19)
  * **Feature**: Added support for g6, g6e, m6i, c6i instance types in SageMaker Processing Jobs.

# Release (2025-03-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.45.0](service/appsync/CHANGELOG.md#v1450-2025-03-18)
  * **Feature**: Providing Tagging support for DomainName in AppSync
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.23.0](service/cleanrooms/CHANGELOG.md#v1230-2025-03-18)
  * **Feature**: This release adds support for PySpark jobs. Customers can now analyze data by running jobs using approved PySpark analysis templates.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.70.0](service/mediaconvert/CHANGELOG.md#v1700-2025-03-18)
  * **Feature**: This release adds support for AVC passthrough, the ability to specify PTS offset without padding, and an A/V segment matching feature.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.50.0](service/route53/CHANGELOG.md#v1500-2025-03-18)
  * **Feature**: Amazon Route 53 now supports the iso-f regions for private DNS Amazon VPCs and cloudwatch healthchecks.

# Release (2025-03-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/expression`: [v1.7.75](feature/dynamodb/expression/CHANGELOG.md#v1775-2025-03-17)
  * **Bug Fix**: allow nested list indices in expressions
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.10.0](service/applicationsignals/CHANGELOG.md#v1100-2025-03-17)
  * **Feature**: This release adds support for adding, removing, and listing SLO time exclusion windows with the BatchUpdateExclusionWindows and ListServiceLevelObjectiveExclusionWindows APIs.
* `github.com/aws/aws-sdk-go-v2/service/geomaps`: [v1.2.0](service/geomaps/CHANGELOG.md#v120-2025-03-17)
  * **Feature**: Provide support for vector map styles in the GetStaticMap operation.
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.24.0](service/rum/CHANGELOG.md#v1240-2025-03-17)
  * **Feature**: CloudWatch RUM now supports unminification of JS error stack traces.
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.10.0](service/taxsettings/CHANGELOG.md#v1100-2025-03-17)
  * **Feature**: Adjust Vietnam PaymentVoucherNumber regex and minor API change.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.59.0](service/wafv2/CHANGELOG.md#v1590-2025-03-17)
  * **Feature**: AWS WAF now lets you inspect fragments of request URIs. You can specify the scope of the URI to inspect and narrow the set of URI fragments.

# Release (2025-03-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentity`: [v1.29.3](service/cognitoidentity/CHANGELOG.md#v1293-2025-03-14)
  * **Documentation**: Updated API model build artifacts for identity pools
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.51.3](service/cognitoidentityprovider/CHANGELOG.md#v1513-2025-03-14)
  * **Documentation**: Minor description updates to API parameters
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.107.0](service/glue/CHANGELOG.md#v11070-2025-03-14)
  * **Feature**: This release added AllowFullTableExternalDataAccess to glue catalog resource.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.41.0](service/lakeformation/CHANGELOG.md#v1410-2025-03-14)
  * **Feature**: This release added "condition" to LakeFormation OptIn APIs, also added WithPrivilegedAccess flag to RegisterResource and DescribeResource.

# Release (2025-03-13)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.40.0](service/acmpca/CHANGELOG.md#v1400-2025-03-13)
  * **Feature**: Private Certificate Authority service now supports P521 and RSA3072 key algorithms.
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.31.0](service/amplify/CHANGELOG.md#v1310-2025-03-13)
  * **Feature**: Introduced support for Skew Protection. Added enableSkewProtection field to createBranch and updateBranch API.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.47.0](service/cloudwatchlogs/CHANGELOG.md#v1470-2025-03-13)
  * **Feature**: Updated CreateLogAnomalyDetector to accept only kms key arn
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.56.0](service/codebuild/CHANGELOG.md#v1560-2025-03-13)
  * **Feature**: AWS CodeBuild now supports webhook filtering by organization name
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.27.0](service/datazone/CHANGELOG.md#v1270-2025-03-13)
  * **Feature**: This release adds support to update projects and environments
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.42.0](service/dynamodb/CHANGELOG.md#v1420-2025-03-13)
  * **Feature**: Generate account endpoints for DynamoDB requests using ARN-sourced account ID when available
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.210.0](service/ec2/CHANGELOG.md#v12100-2025-03-13)
  * **Feature**: This release changes the CreateLaunchTemplate, CreateLaunchTemplateVersion, ModifyLaunchTemplate CLI and SDKs such that if you do not specify a client token, a randomly generated token is used for the request to ensure idempotency.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.24.0](service/ivsrealtime/CHANGELOG.md#v1240-2025-03-13)
  * **Feature**: IVS Real-Time now offers customers the ability to adjust the participant & composition recording segment duration
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.22.0](service/mediapackagev2/CHANGELOG.md#v1220-2025-03-13)
  * **Feature**: This release adds the ResetChannelState and ResetOriginEndpointState operation to reset MediaPackage V2 channel and origin endpoint. This release also adds a new field, UrlEncodeChildManifest, for HLS/LL-HLS to allow URL-encoding child manifest query string based on the requirements of AWS SigV4.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.55.0](service/s3control/CHANGELOG.md#v1550-2025-03-13)
  * **Feature**: Updating GetDataAccess response for S3 Access Grants to include the matched Grantee for the requested prefix

# Release (2025-03-11)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.209.0](service/ec2/CHANGELOG.md#v12090-2025-03-11)
  * **Feature**: This release adds the GroupLongName field to the response of the DescribeAvailabilityZones API.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.43.0](service/ecr/CHANGELOG.md#v1430-2025-03-11)
  * **Feature**: This release adds Amazon ECR to Amazon ECR pull through cache rules support.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.54.2](service/ecs/CHANGELOG.md#v1542-2025-03-11)
  * **Documentation**: This is a documentation only update for Amazon ECS to address various tickets.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.36.0](service/inspector2/CHANGELOG.md#v1360-2025-03-11)
  * **Feature**: Adding componentArn to network reachability details
* `github.com/aws/aws-sdk-go-v2/service/internal/checksum`: [v1.7.0](service/internal/checksum/CHANGELOG.md#v170-2025-03-11)
  * **Feature**: Add extra check during output checksum validation so the validation skip warning would not be logged if object is not fetched from s3
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.71.0](service/medialive/CHANGELOG.md#v1710-2025-03-11)
  * **Feature**: Add an enum option DISABLED for Output Locking Mode under Global Configuration.

# Release (2025-03-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.39.0](service/bedrockagent/CHANGELOG.md#v1390-2025-03-10)
  * **Feature**: Add support for computer use tools
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.40.0](service/bedrockagentruntime/CHANGELOG.md#v1400-2025-03-10)
  * **Feature**: Add support for computer use tools
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.127.0](service/connect/CHANGELOG.md#v11270-2025-03-10)
  * **Feature**: Add support for contact transfers in external voice systems.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.48.0](service/costexplorer/CHANGELOG.md#v1480-2025-03-10)
  * **Feature**: Releasing minor partition endpoint updates.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.70.0](service/medialive/CHANGELOG.md#v1700-2025-03-10)
  * **Feature**: Adds defaultFontSize and defaultLineHeight as options in the EbuTtDDestinationSettings within the caption descriptions for an output stream.
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorad`: [v1.11.0](service/pcaconnectorad/CHANGELOG.md#v1110-2025-03-10)
  * **Feature**: PrivateCA Connector for Active Directory now supports dual stack endpoints. This release adds the IpAddressType option to the VpcInformation on a Connector which determines whether the endpoint supports IPv4 only or IPv4 and IPv6 traffic.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.57.0](service/securityhub/CHANGELOG.md#v1570-2025-03-10)
  * **Feature**: This release adds new StandardsControlsUpdatable field to the StandardsSubscription resource
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.10.2](service/timestreaminfluxdb/CHANGELOG.md#v1102-2025-03-10)
  * **Documentation**: This release updates the default value of pprof-disabled from false to true.

# Release (2025-03-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.38.0](service/bedrockagent/CHANGELOG.md#v1380-2025-03-07)
  * **Feature**: Introduces support for Neptune Analytics as a vector data store and adds Context Enrichment Configurations, enabling use cases such as GraphRAG.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.39.0](service/bedrockagentruntime/CHANGELOG.md#v1390-2025-03-07)
  * **Feature**: Support Multi Agent Collaboration within Inline Agents
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.45.2](service/cloudfront/CHANGELOG.md#v1452-2025-03-07)
  * **Documentation**: Documentation updates for Amazon CloudFront.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.208.0](service/ec2/CHANGELOG.md#v12080-2025-03-07)
  * **Feature**: Add serviceManaged field to DescribeAddresses API response.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.45.0](service/elasticloadbalancingv2/CHANGELOG.md#v1450-2025-03-07)
  * **Feature**: This release adds support for assigning IP addresses to Application Load Balancers from VPC IP Address Manager pools.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.17.2](service/neptunegraph/CHANGELOG.md#v1172-2025-03-07)
  * **Documentation**: Several small updates to resolve customer requests.

# Release (2025-03-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.28.0](service/bedrock/CHANGELOG.md#v1280-2025-03-06)
  * **Feature**: This releases adds support for Custom Prompt Router
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.48.2](service/cloudtrail/CHANGELOG.md#v1482-2025-03-06)
  * **Documentation**: Doc-only update for CloudTrail.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.23.0](service/ivsrealtime/CHANGELOG.md#v1230-2025-03-06)
  * **Feature**: IVS Real-Time now offers customers the ability to merge fragmented recordings in the event of a participant disconnect.
* `github.com/aws/aws-sdk-go-v2/service/networkflowmonitor`: [v1.2.0](service/networkflowmonitor/CHANGELOG.md#v120-2025-03-06)
  * **Feature**: This release contains 2 changes. 1: DeleteScope/GetScope/UpdateScope operations now return 404 instead of 500 when the resource does not exist. 2: Expected string format for clientToken fields of CreateMonitorInput/CreateScopeInput/UpdateMonitorInput have been updated to be an UUID based string.
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.33.0](service/redshiftdata/CHANGELOG.md#v1330-2025-03-06)
  * **Feature**: This release adds support for ListStatements API to filter statements by ClusterIdentifier, WorkgroupName, and Database.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.58.0](service/wafv2/CHANGELOG.md#v1580-2025-03-06)
  * **Feature**: You can now perform an exact match or rate limit aggregation against the web request's JA4 fingerprint.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.55.0](service/workspaces/CHANGELOG.md#v1550-2025-03-06)
  * **Feature**: Added a new ModifyEndpointEncryptionMode API for managing endpoint encryption settings.

# Release (2025-03-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.47.0](service/datasync/CHANGELOG.md#v1470-2025-03-05)
  * **Feature**: AWS DataSync now supports modifying ServerHostname while updating locations SMB, NFS, and ObjectStorage.
* `github.com/aws/aws-sdk-go-v2/service/gameliftstreams`: [v1.0.0](service/gameliftstreams/CHANGELOG.md#v100-2025-03-05)
  * **Release**: New AWS service client module
  * **Feature**: New Service: Amazon GameLift Streams delivers low-latency game streaming from AWS global infrastructure to virtually any device with a browser at up to 1080p resolution and 60 fps.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.25.0](service/iotfleetwise/CHANGELOG.md#v1250-2025-03-05)
  * **Feature**: This release adds floating point support for CAN/OBD signals and adds support for signed OBD signals.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.54.0](service/workspaces/CHANGELOG.md#v1540-2025-03-05)
  * **Feature**: Added DeviceTypeWorkSpacesThinClient type to allow users to access their WorkSpaces through a WorkSpaces Thin Client.

# Release (2025-03-04.2)

## General Highlights
* **Bug Fix**: Add assurance test for operation order.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.45.1](service/elasticache/CHANGELOG.md#v1451-2025-03-042)
  * **Documentation**: Doc only update, listing 'valkey7' and 'valkey8' as engine options for parameter groups.
* `github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations`: [v1.0.0](service/iotmanagedintegrations/CHANGELOG.md#v100-2025-03-042)
  * **Release**: New AWS service client module
  * **Feature**: Adding managed integrations APIs for IoT Device Management to setup and control devices across different manufacturers and connectivity protocols. APIs include managedthing operations, credential and provisioning profile management, notification configuration, and OTA update.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.47.0](service/iotsitewise/CHANGELOG.md#v1470-2025-03-042)
  * **Feature**: AWS IoT SiteWise now supports MQTT-enabled, V3 gateways. Configure data destinations for real-time ingestion into AWS IoT SiteWise or buffered ingestion using Amazon S3 storage. You can also use path filters for precise data collection from specific MQTT topics.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.94.1](service/rds/CHANGELOG.md#v1941-2025-03-042)
  * **Documentation**: Note support for Database Insights for Amazon RDS.

# Release (2025-03-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.51.0](service/cognitoidentityprovider/CHANGELOG.md#v1510-2025-03-04)
  * **Feature**: Added the capacity to return available challenges in admin authentication and to set version 3 of the pre token generation event for M2M ATC.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.207.0](service/ec2/CHANGELOG.md#v12070-2025-03-04)
  * **Feature**: Update the DescribeVpcs response
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.23.0](service/qbusiness/CHANGELOG.md#v1230-2025-03-04)
  * **Feature**: Adds support for the ingestion of audio and video files by Q Business, which can be configured with the mediaExtractionConfiguration parameter.
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.23.0](service/rum/CHANGELOG.md#v1230-2025-03-04)
  * **Feature**: Add support for PutResourcePolicy, GetResourcePolicy and DeleteResourcePolicy to support resource based policies for AWS CloudWatch RUM
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.180.0](service/sagemaker/CHANGELOG.md#v11800-2025-03-04)
  * **Feature**: Add DomainId to CreateDomainResponse
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.44.1](service/transcribe/CHANGELOG.md#v1441-2025-03-04)
  * **Documentation**: Updating documentation for post call analytics job queueing.

# Release (2025-02-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation`: [v1.2.0](service/bedrockdataautomation/CHANGELOG.md#v120-2025-02-28)
  * **Feature**: Renamed and added new StandardConfiguration enums. Added support to update EncryptionConfiguration in UpdateBlueprint and UpdateDataAutomation APIs. Changed HttpStatus code for DeleteBlueprint and DeleteDataAutomationProject APIs to 200 from 204. Added APIs to support tagging.
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomationruntime`: [v1.2.0](service/bedrockdataautomationruntime/CHANGELOG.md#v120-2025-02-28)
  * **Feature**: Added a mandatory parameter DataAutomationProfileArn to support for cross region inference for InvokeDataAutomationAsync API. Renamed DataAutomationArn to DataAutomationProjectArn. Added APIs to support tagging.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.51.0](service/databasemigrationservice/CHANGELOG.md#v1510-2025-02-28)
  * **Feature**: Add skipped status to the Result Statistics of an Assessment Run
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.60.0](service/eks/CHANGELOG.md#v1600-2025-02-28)
  * **Feature**: Adding licenses to EKS Anywhere Subscription operations response.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.69.0](service/mediaconvert/CHANGELOG.md#v1690-2025-02-28)
  * **Feature**: The AWS MediaConvert Probe API allows you to analyze media files and retrieve detailed metadata about their content, format, and structure.
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.34.0](service/pricing/CHANGELOG.md#v1340-2025-02-28)
  * **Feature**: Update GetProducts and DescribeServices API request input validations.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.57.1](service/ssm/CHANGELOG.md#v1571-2025-02-28)
  * **Documentation**: Systems Manager doc-only updates for Feb. 2025.

# Release (2025-02-27)

## General Highlights
* **Feature**: Track credential providers via User-Agent Feature ids
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.38.0](service/bedrockagentruntime/CHANGELOG.md#v1380-2025-02-27)
  * **Feature**: Introduces Sessions (preview) to enable stateful conversations in GenAI applications.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.48.0](service/emr/CHANGELOG.md#v1480-2025-02-27)
  * **Documentation**: Definition update for EbsConfiguration.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.22.0](service/qbusiness/CHANGELOG.md#v1220-2025-02-27)
  * **Feature**: This release supports deleting attachments from conversations.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.26.0](service/redshiftserverless/CHANGELOG.md#v1260-2025-02-27)
  * **Feature**: Add track support for Redshift Serverless workgroup.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.179.0](service/sagemaker/CHANGELOG.md#v11790-2025-02-27)
  * **Feature**: SageMaker HubService is introducing support for creating Training Jobs in Curated Hub (Private Hub). Additionally, it is introducing two new APIs: UpdateHubContent and UpdateHubContentReference.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.36.0](service/storagegateway/CHANGELOG.md#v1360-2025-02-27)
  * **Feature**: This release adds support to invoke a process that cleans the specified file share's cache of file entries that are failing upload to Amazon S3.

# Release (2025-02-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.8.0](service/applicationsignals/CHANGELOG.md#v180-2025-02-26)
  * **Feature**: This release adds API support for reading Service Level Objectives and Services from monitoring accounts, from SLO and Service-scoped operations, including ListServices and ListServiceLevelObjectives.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.50.0](service/batch/CHANGELOG.md#v1500-2025-02-26)
  * **Feature**: AWS Batch: Resource Aware Scheduling feature support
* `github.com/aws/aws-sdk-go-v2/service/chime`: [v1.35.0](service/chime/CHANGELOG.md#v1350-2025-02-26)
  * **Feature**: Removes the Amazon Chime SDK APIs from the "chime" namespace.  Amazon Chime SDK APIs continue to be available in the AWS SDK via the dedicated Amazon Chime SDK namespaces: chime-sdk-identity, chime-sdk-mediapipelines, chime-sdk-meetings, chime-sdk-messaging, and chime-sdk-voice.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.44.12](service/cloudfront/CHANGELOG.md#v14412-2025-02-26)
  * **Documentation**: Documentation update for VPC origin config.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.205.0](service/ec2/CHANGELOG.md#v12050-2025-02-26)
  * **Feature**: Amazon EC2 Fleet customers can now override the Block Device Mapping specified in the Launch Template when creating a new Fleet request, saving the effort of creating and associating new Launch Templates to customize the Block Device Mapping.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.23.0](service/iotfleetwise/CHANGELOG.md#v1230-2025-02-26)
  * **Feature**: This release adds an optional listResponseScope request parameter in certain list API requests to limit the response to metadata only.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.16.0](service/oam/CHANGELOG.md#v1160-2025-02-26)
  * **Feature**: This release adds support for sharing AWS::ApplicationSignals::Service and AWS::ApplicationSignals::ServiceLevelObjective resources.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.178.0](service/sagemaker/CHANGELOG.md#v11780-2025-02-26)
  * **Feature**: AWS SageMaker InferenceComponents now support rolling update deployments for Inference Components.

# Release (2025-02-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.54.0](service/codebuild/CHANGELOG.md#v1540-2025-02-25)
  * **Feature**: Adding "reportArns" field in output of BatchGetBuildBatches API. "reportArns" is an array that contains the ARNs of reports created by merging reports from builds associated with the batch build.
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.29.0](service/devicefarm/CHANGELOG.md#v1290-2025-02-25)
  * **Feature**: Add an optional configuration to the ScheduleRun and CreateRemoteAccessSession API to set a device level http/s proxy.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.204.0](service/ec2/CHANGELOG.md#v12040-2025-02-25)
  * **Feature**: Adds support for time-based EBS-backed AMI copy operations. Time-based copy ensures that EBS-backed AMIs are copied within and across Regions in a specified timeframe.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.63.0](service/iot/CHANGELOG.md#v1630-2025-02-25)
  * **Feature**: AWS IoT - AWS IoT Device Defender adds support for a new Device Defender Audit Check that monitors device certificate age and custom threshold configurations for both the new device certificate age check and existing device certificate expiry check.
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.8.0](service/taxsettings/CHANGELOG.md#v180-2025-02-25)
  * **Feature**: PutTaxRegistration API changes for Egypt, Greece, Vietnam countries

# Release (2025-02-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.37.0](service/bedrockagentruntime/CHANGELOG.md#v1370-2025-02-24)
  * **Feature**: Adding support for ReasoningContent fields in Pre-Processing, Post-Processing and Orchestration Trace outputs.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.25.0](service/bedrockruntime/CHANGELOG.md#v1250-2025-02-24)
  * **Feature**: This release adds Reasoning Content support to Converse and ConverseStream APIs
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.44.14](service/elasticache/CHANGELOG.md#v14414-2025-02-24)
  * **Documentation**: Documentation update, adding clarity and rephrasing.
* `github.com/aws/aws-sdk-go-v2/service/elasticinference`: [v1.24.0](service/elasticinference/CHANGELOG.md#v1240-2025-02-24)
  * **Feature**: Mark service/elasticinference as deprecated. This service is no longer available for use.

# Release (2025-02-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.44.0](service/appstream/CHANGELOG.md#v1440-2025-02-21)
  * **Feature**: Added support for Certificate-Based Authentication on AppStream 2.0 multi-session fleets.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.36.0](service/bedrockagent/CHANGELOG.md#v1360-2025-02-21)
  * **Feature**: Introduce a new parameter which represents the user-agent header value used by the Bedrock Knowledge Base Web Connector.

# Release (2025-02-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.53.0](service/codebuild/CHANGELOG.md#v1530-2025-02-20)
  * **Feature**: Add webhook status and status message to AWS CodeBuild webhooks
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.53.0](service/guardduty/CHANGELOG.md#v1530-2025-02-20)
  * **Feature**: Reduce the minimum number of required attack sequence signals from 2 to 1
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.14.12](service/licensemanagerusersubscriptions/CHANGELOG.md#v11412-2025-02-20)
  * **Documentation**: Updates entity to include Microsoft RDS SAL as a valid type of user subscription.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.93.14](service/rds/CHANGELOG.md#v19314-2025-02-20)
  * **Documentation**: CloudWatch Database Insights now supports Amazon RDS.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.177.0](service/sagemaker/CHANGELOG.md#v11770-2025-02-20)
  * **Feature**: Added new capability in the UpdateCluster operation to remove instance groups from your SageMaker HyperPod cluster.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.26.0](service/workspacesweb/CHANGELOG.md#v1260-2025-02-20)
  * **Feature**: Add support for toolbar configuration under user settings.

# Release (2025-02-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.39.0](service/codepipeline/CHANGELOG.md#v1390-2025-02-19)
  * **Feature**: Add environment variables to codepipeline action declaration.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.53.16](service/ecs/CHANGELOG.md#v15316-2025-02-19)
  * **Documentation**: This is a documentation only release for Amazon ECS that supports the CPU task limit increase.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.42.17](service/lightsail/CHANGELOG.md#v14217-2025-02-19)
  * **Documentation**: Documentation updates for Amazon Lightsail.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.43.0](service/location/CHANGELOG.md#v1430-2025-02-19)
  * **Feature**: Adds support for larger property maps for tracking and geofence positions changes. It increases the maximum number of items from 3 to 4, and the maximum value length from 40 to 150.
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.9.0](service/mailmanager/CHANGELOG.md#v190-2025-02-19)
  * **Feature**: This release adds additional metadata fields in Mail Manager archive searches to show email source and details about emails that were archived when being sent with SES.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.45.0](service/networkfirewall/CHANGELOG.md#v1450-2025-02-19)
  * **Feature**: This release introduces Network Firewall's Automated Domain List feature. New APIs include UpdateFirewallAnalysisSettings, StartAnalysisReport, GetAnalysisReportResults, and ListAnalysisReports. These allow customers to enable analysis on firewalls to identify and report frequently accessed domain.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.176.0](service/sagemaker/CHANGELOG.md#v11760-2025-02-19)
  * **Feature**: Adds r8g instance type support to SageMaker Realtime Endpoints
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.42.0](service/sesv2/CHANGELOG.md#v1420-2025-02-19)
  * **Feature**: This release adds the ability for outbound email sent with SES to preserve emails to a Mail Manager archive.

# Release (2025-02-18)

## General Highlights
* **Bug Fix**: Bump go version to 1.22
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.49.13](service/batch/CHANGELOG.md#v14913-2025-02-18)
  * **Documentation**: This documentation-only update corrects some typos.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.40.2](service/dynamodb/CHANGELOG.md#v1402-2025-02-18)
  * **Bug Fix**: Add missing AccountIDEndpointMode binding to endpoint resolution.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.34.0](service/emrcontainers/CHANGELOG.md#v1340-2025-02-18)
  * **Feature**: EMR on EKS StartJobRun Api will be supporting the configuration of log storage in AWS by using "managedLogs" under "MonitoringConfiguration".
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.68.0](service/medialive/CHANGELOG.md#v1680-2025-02-18)
  * **Feature**: Adds support for creating CloudWatchAlarmTemplates for AWS Elemental MediaTailor Playback Configuration resources.

# Release (2025-02-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.29.0](service/amplify/CHANGELOG.md#v1290-2025-02-17)
  * **Feature**: Add ComputeRoleArn to CreateApp, UpdateApp, CreateBranch, and UpdateBranch, allowing caller to specify a role to be assumed by Amplify Hosting for server-side rendered applications.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.49.0](service/databasemigrationservice/CHANGELOG.md#v1490-2025-02-17)
  * **Feature**: Support replicationConfigArn in DMS DescribeApplicableIndividualAssessments API.
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.9.0](service/timestreaminfluxdb/CHANGELOG.md#v190-2025-02-17)
  * **Feature**: This release introduces APIs to manage DbClusters and adds support for read replicas

# Release (2025-02-14)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream`: [v1.6.9](aws/protocol/eventstream/CHANGELOG.md#v169-2025-02-14)
  * **Bug Fix**: Remove max limit on event stream messages
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.52.0](service/codebuild/CHANGELOG.md#v1520-2025-02-14)
  * **Feature**: Added test suite names to test case metadata
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.125.0](service/connect/CHANGELOG.md#v11250-2025-02-14)
  * **Feature**: Release Notes: 1) Analytics API enhancements: Added new ListAnalyticsDataLakeDataSets API. 2)  Onboarding API Idempotency: Adds ClientToken to instance creation and management APIs to support idempotency.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.48.0](service/databasemigrationservice/CHANGELOG.md#v1480-2025-02-14)
  * **Feature**: Introduces premigration assessment feature to DMS Serverless API for start-replication and describe-replications
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.27.0](service/rdsdata/CHANGELOG.md#v1270-2025-02-14)
  * **Feature**: Add support for Stop DB feature.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.77.0](service/s3/CHANGELOG.md#v1770-2025-02-14)
  * **Feature**: Added support for Content-Range header in HeadObject response.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.56.0](service/wafv2/CHANGELOG.md#v1560-2025-02-14)
  * **Feature**: The WAFv2 API now supports configuring data protection in webACLs.

# Release (2025-02-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.37.0](service/accessanalyzer/CHANGELOG.md#v1370-2025-02-13)
  * **Feature**: This release introduces the getFindingsStatistics API, enabling users to retrieve aggregated finding statistics for IAM Access Analyzer's external access and unused access analysis features. Updated service API and documentation.
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.38.1](service/acmpca/CHANGELOG.md#v1381-2025-02-13)
  * **Documentation**: Private Certificate Authority (PCA) documentation updates
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.53.14](service/ecs/CHANGELOG.md#v15314-2025-02-13)
  * **Documentation**: This is a documentation only release to support migrating Amazon ECS service ARNs to the long ARN format.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.32.0](service/fis/CHANGELOG.md#v1320-2025-02-13)
  * **Feature**: Adds auto-pagination for the following operations: ListActions, ListExperimentTemplates, ListTargetAccountConfigurations, ListExperiments, ListExperimentResolvedTargets, ListTargetResourceTypes. Reduces length constraints of prefixes for logConfiguration and experimentReportConfiguration.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.175.0](service/sagemaker/CHANGELOG.md#v11750-2025-02-13)
  * **Feature**: Adds additional values to the InferenceAmiVersion parameter in the ProductionVariant data type.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.35.0](service/storagegateway/CHANGELOG.md#v1350-2025-02-13)
  * **Feature**: This release adds support for generating cache reports on S3 File Gateways for files that fail to upload.

# Release (2025-02-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.35.0](service/bedrockagent/CHANGELOG.md#v1350-2025-02-12)
  * **Feature**: This releases adds the additionalModelRequestFields field to the CreateAgent and UpdateAgent operations. Use additionalModelRequestFields to specify  additional inference parameters for a model beyond the base inference parameters.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.36.0](service/bedrockagentruntime/CHANGELOG.md#v1360-2025-02-12)
  * **Feature**: This releases adds the additionalModelRequestFields field to the InvokeInlineAgent operation. Use additionalModelRequestFields to specify  additional inference parameters for a model beyond the base inference parameters.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.51.3](service/codebuild/CHANGELOG.md#v1513-2025-02-12)
  * **Documentation**: Add note for the RUNNER_BUILDKITE_BUILD buildType.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.52.0](service/fsx/CHANGELOG.md#v1520-2025-02-12)
  * **Feature**: Support for in-place Lustre version upgrades
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.67.0](service/medialive/CHANGELOG.md#v1670-2025-02-12)
  * **Feature**: Adds a RequestId parameter to all MediaLive Workflow Monitor create operations.  The RequestId parameter allows idempotent operations.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.18.0](service/opensearchserverless/CHANGELOG.md#v1180-2025-02-12)
  * **Feature**: Custom OpenSearchServerless Entity ID for SAML Config.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.46.0](service/polly/CHANGELOG.md#v1460-2025-02-12)
  * **Feature**: Added support for the new voice - Jasmine (en-SG). Jasmine is available as a Neural voice only.

# Release (2025-02-11)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.38.0](service/acmpca/CHANGELOG.md#v1380-2025-02-11)
  * **Feature**: Private Certificate Authority service now supports Partitioned CRL as a revocation configuration option.
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.43.0](service/appsync/CHANGELOG.md#v1430-2025-02-11)
  * **Feature**: Add support for operation level caching
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.203.0](service/ec2/CHANGELOG.md#v12030-2025-02-11)
  * **Feature**: Adding support for the new fullSnapshotSizeInBytes field in the response of the EC2 EBS DescribeSnapshots API. This field represents the size of all the blocks that were written to the source volume at the time the snapshot was created.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.30.1](service/pi/CHANGELOG.md#v1301-2025-02-11)
  * **Documentation**: Documentation only update for RDS Performance Insights dimensions for execution plans and locking analysis.

# Release (2025-02-10)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigatewayv2`: [v1.25.0](service/apigatewayv2/CHANGELOG.md#v1250-2025-02-10)
  * **Feature**: Documentation updates for Amazon API Gateway
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.44.10](service/cloudfront/CHANGELOG.md#v14410-2025-02-10)
  * **Documentation**: Doc-only update that adds defaults for CloudFront VpcOriginEndpointConfig values.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.124.5](service/connect/CHANGELOG.md#v11245-2025-02-10)
  * **Documentation**: Updated the CreateContact API documentation to indicate that it only applies to EMAIL contacts.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.47.0](service/databasemigrationservice/CHANGELOG.md#v1470-2025-02-10)
  * **Feature**: New vendors for DMS Data Providers: DB2 LUW and DB2 for z/OS
* `github.com/aws/aws-sdk-go-v2/service/internal/checksum`: [v1.6.0](service/internal/checksum/CHANGELOG.md#v160-2025-02-10)
  * **Feature**: Support CRC64NVME flex checksums.

# Release (2025-02-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/rds/auth`: [v1.5.9](feature/rds/auth/CHANGELOG.md#v159-2025-02-07)
  * **Bug Fix**: typo in connect.go error message
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.41.0](service/ecr/CHANGELOG.md#v1410-2025-02-07)
  * **Feature**: Adds support to handle the new basic scanning daily quota.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.58.0](service/eks/CHANGELOG.md#v1580-2025-02-07)
  * **Feature**: Introduce versionStatus field to take place of status field in EKS DescribeClusterVersions API
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.67.0](service/mediaconvert/CHANGELOG.md#v1670-2025-02-07)
  * **Feature**: This release adds support for Animated GIF output, forced chroma sample positioning metadata, and Extensible Wave Container format
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.30.0](service/pi/CHANGELOG.md#v1300-2025-02-07)
  * **Feature**: Adds documentation for dimension groups and dimensions to analyze locks for Database Insights.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.43.0](service/transcribe/CHANGELOG.md#v1430-2025-02-07)
  * **Feature**: This release adds support for the Clinical Note Template Customization feature for the AWS HealthScribe APIs within Amazon Transcribe.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.24.0](service/transcribestreaming/CHANGELOG.md#v1240-2025-02-07)
  * **Feature**: This release adds support for the Clinical Note Template Customization feature for the AWS HealthScribe Streaming APIs within Amazon Transcribe.

# Release (2025-02-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.57.0](service/cloudformation/CHANGELOG.md#v1570-2025-02-06)
  * **Feature**: We added 5 new stack refactoring APIs: CreateStackRefactor, ExecuteStackRefactor, ListStackRefactors, DescribeStackRefactor, ListStackRefactorActions.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.22.0](service/connectcases/CHANGELOG.md#v1220-2025-02-06)
  * **Feature**: This release adds the ability to conditionally require fields on a template. Check public documentation for more information.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.12.0](service/costoptimizationhub/CHANGELOG.md#v1120-2025-02-06)
  * **Feature**: This release enables AWS Cost Optimization Hub to show cost optimization recommendations for Amazon Auto Scaling Groups, including those with single and mixed instance types.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.76.0](service/s3/CHANGELOG.md#v1760-2025-02-06)
  * **Feature**: Updated list of the valid AWS Region values for the LocationConstraint parameter for general purpose buckets.

# Release (2025-02-05)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.40.0](service/dynamodb/CHANGELOG.md#v1400-2025-02-05)
  * **Feature**: Track AccountID endpoint mode in user-agent.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.93.12](service/rds/CHANGELOG.md#v19312-2025-02-05)
  * **Documentation**: Documentation updates to clarify the description for the parameter AllocatedStorage for the DB cluster data type, the description for the parameter DeleteAutomatedBackups for the DeleteDBCluster API operation, and removing an outdated note for the CreateDBParameterGroup API operation.

# Release (2025-02-04)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.46.0](service/databasemigrationservice/CHANGELOG.md#v1460-2025-02-04)
  * **Feature**: Introduces TargetDataSettings with the TablePreparationMode option available for data migrations.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.45.3](service/datasync/CHANGELOG.md#v1453-2025-02-04)
  * **Documentation**: Doc-only update to provide more information on using Kerberos authentication with SMB locations.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.39.0](service/iam/CHANGELOG.md#v1390-2025-02-04)
  * **Feature**: This release adds support for accepting encrypted SAML assertions. Customers can now configure their identity provider to encrypt the SAML assertions it sends to IAM.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.16.0](service/neptunegraph/CHANGELOG.md#v1160-2025-02-04)
  * **Feature**: Added argument to `list-export` to filter by graph ID
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.21.0](service/qbusiness/CHANGELOG.md#v1210-2025-02-04)
  * **Feature**: Adds functionality to enable/disable a new Q Business Chat orchestration feature. If enabled, Q Business can orchestrate over datasources and plugins without the need for customers to select specific chat modes.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.174.1](service/sagemaker/CHANGELOG.md#v11741-2025-02-04)
  * **Documentation**: IPv6 support for Hyperpod clusters

# Release (2025-02-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.44.0](service/mediatailor/CHANGELOG.md#v1440-2025-02-03)
  * **Feature**: Add support for CloudWatch Vended Logs which allows for delivery of customer logs to CloudWatch Logs, S3, or Firehose.

# Release (2025-01-31)

## General Highlights
* **Dependency Update**: Switch to code-generated waiter matchers, removing the dependency on go-jmespath.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.36.0
  * **Feature**: Reduce allocations in query encoding.
  * **Dependency Update**: Remove root dependency on go-jmespath, which is no longer used.
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.18.0](feature/dynamodb/attributevalue/CHANGELOG.md#v1180-2025-01-31)
  * **Feature**: Add FixUnmarshalIndividualSetValues option to DecoderOptions to fix unmarshalling of individual values of StringSet, NumberSet, and BinarySet attributes.
* `github.com/aws/aws-sdk-go-v2/feature/dynamodbstreams/attributevalue`: [v1.17.0](feature/dynamodbstreams/attributevalue/CHANGELOG.md#v1170-2025-01-31)
  * **Feature**: Add FixUnmarshalIndividualSetValues option to DecoderOptions to fix unmarshalling of individual values of StringSet, NumberSet, and BinarySet attributes.
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.17.57](feature/s3/manager/CHANGELOG.md#v11757-2025-01-31)
  * **Bug Fix**: Fix incorrect reference to old s3manager in comments.
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.31.0](service/amp/CHANGELOG.md#v1310-2025-01-31)
  * **Feature**: Add support for sending metrics to cross account and CMCK AMP workspaces through RoleConfiguration on Create/Update Scraper.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.35.0](service/bedrockagentruntime/CHANGELOG.md#v1350-2025-01-31)
  * **Feature**: This change is to deprecate the existing citation field under RetrieveAndGenerateStream API response in lieu of GeneratedResponsePart and RetrievedReferences
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.51.0](service/codebuild/CHANGELOG.md#v1510-2025-01-31)
  * **Feature**: Added support for CodeBuild self-hosted Buildkite runner builds
* `github.com/aws/aws-sdk-go-v2/service/georoutes`: [v1.1.0](service/georoutes/CHANGELOG.md#v110-2025-01-31)
  * **Feature**: The OptimizeWaypoints API now supports 50 waypoints per request (20 with constraints like AccessHours or AppointmentTime). It adds waypoint clustering via Clustering and ClusteringIndex for better optimization. Also, total distance validation is removed for greater flexibility.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.93.10](service/rds/CHANGELOG.md#v19310-2025-01-31)
  * **Documentation**: Updates to Aurora MySQL and Aurora PostgreSQL API pages with instance log type in the create and modify DB Cluster.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.174.0](service/sagemaker/CHANGELOG.md#v11740-2025-01-31)
  * **Feature**: This release introduces a new valid value in InstanceType parameter: p5en.48xlarge, in ProductionVariant.

# Release (2025-01-30)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.35.0
  * **Feature**: Reduce allocations in query encoding.
  * **Bug Fix**: Do not sign Transfer-Encoding header in Sigv4[a]. Fixes a signer mismatch issue with S3 Accelerate.
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.17.0](feature/dynamodb/attributevalue/CHANGELOG.md#v1170-2025-01-30)
  * **Feature**: Add FixUnmarshalIndividualSetValues option to DecoderOptions to fix unmarshalling of individual values of StringSet, NumberSet, and BinarySet attributes.
* `github.com/aws/aws-sdk-go-v2/feature/dynamodbstreams/attributevalue`: [v1.16.0](feature/dynamodbstreams/attributevalue/CHANGELOG.md#v1160-2025-01-30)
  * **Feature**: Add FixUnmarshalIndividualSetValues option to DecoderOptions to fix unmarshalling of individual values of StringSet, NumberSet, and BinarySet attributes.
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.17.56](feature/s3/manager/CHANGELOG.md#v11756-2025-01-30)
  * **Bug Fix**: Fix incorrect reference to old s3manager in comments.
* `github.com/aws/aws-sdk-go-v2/internal/v4a`: [v1.3.30](internal/v4a/CHANGELOG.md#v1330-2025-01-30)
  * **Bug Fix**: Do not sign Transfer-Encoding header in Sigv4[a]. Fixes a signer mismatch issue with S3 Accelerate.
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.43.0](service/appstream/CHANGELOG.md#v1430-2025-01-30)
  * **Feature**: Add support for managing admin consent requirement on selected domains for OneDrive Storage Connectors in AppStream2.0.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.34.0](service/bedrockagentruntime/CHANGELOG.md#v1340-2025-01-30)
  * **Feature**: Add a 'reason' field to InternalServerException
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.40.0](service/ecr/CHANGELOG.md#v1400-2025-01-30)
  * **Feature**: Temporarily updating dualstack endpoint support
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.31.0](service/ecrpublic/CHANGELOG.md#v1310-2025-01-30)
  * **Feature**: Temporarily updating dualstack endpoint support
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.43.0](service/mediatailor/CHANGELOG.md#v1430-2025-01-30)
  * **Feature**: Adds options for configuring how MediaTailor conditions ads before inserting them into the content stream. Based on the new settings, MediaTailor will either transcode ads to match the content stream as it has in the past, or it will insert ads without first transcoding them.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.20.0](service/qbusiness/CHANGELOG.md#v1200-2025-01-30)
  * **Feature**: Added APIs to manage QBusiness user subscriptions
* `github.com/aws/aws-sdk-go-v2/service/s3tables`: [v1.1.0](service/s3tables/CHANGELOG.md#v110-2025-01-30)
  * **Feature**: You can now use the CreateTable API operation to create tables with schemas by adding an optional metadata argument.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.21.0](service/verifiedpermissions/CHANGELOG.md#v1210-2025-01-30)
  * **Feature**: Adds Cedar JSON format support for entities and context data in authorization requests

# Release (2025-01-29)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.17.55](feature/s3/manager/CHANGELOG.md#v11755-2025-01-29)
  * **Bug Fix**: Fix incorrect reference to old s3manager in comments.
* `github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator`: [v1.2.0](service/bcmpricingcalculator/CHANGELOG.md#v120-2025-01-29)
  * **Feature**: Added ConflictException error type in DeleteBillScenario, BatchDeleteBillScenarioCommitmentModification, BatchDeleteBillScenarioUsageModification, BatchUpdateBillScenarioUsageModification, and BatchUpdateBillScenarioCommitmentModification API operations.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.39.0](service/ecr/CHANGELOG.md#v1390-2025-01-29)
  * **Feature**: Add support for Dualstack and Dualstack-with-FIPS Endpoints
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.30.0](service/ecrpublic/CHANGELOG.md#v1300-2025-01-29)
  * **Feature**: Add support for Dualstack Endpoints
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.8.0](service/mailmanager/CHANGELOG.md#v180-2025-01-29)
  * **Feature**: This release includes a new feature for Amazon SES Mail Manager which allows customers to specify known addresses and domains and make use of those in traffic policies and rules actions to distinguish between known and unknown entries.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.75.0](service/s3/CHANGELOG.md#v1750-2025-01-29)
  * **Feature**: Change the type of MpuObjectSize in CompleteMultipartUploadRequest from int to long.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.23.0](service/transcribestreaming/CHANGELOG.md#v1230-2025-01-29)
  * **Feature**: This release adds support for AWS HealthScribe Streaming APIs within Amazon Transcribe.

# Release (2025-01-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.42.0](service/appsync/CHANGELOG.md#v1420-2025-01-28)
  * **Feature**: Add stash and outErrors to EvaluateCode/EvaluateMappingTemplate response
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.45.0](service/datasync/CHANGELOG.md#v1450-2025-01-28)
  * **Feature**: AWS DataSync now supports the Kerberos authentication protocol for SMB locations.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.8.0](service/deadline/CHANGELOG.md#v180-2025-01-28)
  * **Feature**: feature: Deadline: Add support for limiting the concurrent usage of external resources, like floating licenses, using limits and the ability to constrain the maximum number of workers that work on a job
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.202.0](service/ec2/CHANGELOG.md#v12020-2025-01-28)
  * **Feature**: This release changes the CreateFleet CLI and SDK's such that if you do not specify a client token, a randomly generated token is used for the request to ensure idempotency.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.36.0](service/firehose/CHANGELOG.md#v1360-2025-01-28)
  * **Feature**: For AppendOnly streams, Firehose will automatically scale to match your throughput.
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.8.0](service/timestreaminfluxdb/CHANGELOG.md#v180-2025-01-28)
  * **Feature**: Adds 'allocatedStorage' parameter to UpdateDbInstance API that allows increasing the database instance storage size and 'dbStorageType' parameter to UpdateDbInstance API that allows changing the storage type of the database instance

# Release (2025-01-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.34.0](service/bedrockagent/CHANGELOG.md#v1340-2025-01-27)
  * **Feature**: Add support for the prompt caching feature for Bedrock Prompt Management
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.66.0](service/mediaconvert/CHANGELOG.md#v1660-2025-01-27)
  * **Feature**: This release adds support for dynamic audio configuration and the ability to disable the deblocking filter for h265 encodes.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.53.0](service/s3control/CHANGELOG.md#v1530-2025-01-27)
  * **Feature**: Minor fix to ARN validation for Lambda functions passed to S3 Batch Operations

# Release (2025-01-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions
* **Dependency Update**: Upgrade to smithy-go v1.22.2.

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.34.0
  * **Feature**: Reduce allocations in query encoding.
* `github.com/aws/aws-sdk-go-v2/config`: [v1.29.2](config/CHANGELOG.md#v1292-2025-01-24)
  * **Bug Fix**: Fix env config naming and usage of deprecated ioutil
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.16.0](feature/dynamodb/attributevalue/CHANGELOG.md#v1160-2025-01-24)
  * **Feature**: Add FixUnmarshalIndividualSetValues option to DecoderOptions to fix unmarshalling of individual values of StringSet, NumberSet, and BinarySet attributes.
* `github.com/aws/aws-sdk-go-v2/feature/dynamodbstreams/attributevalue`: [v1.15.0](feature/dynamodbstreams/attributevalue/CHANGELOG.md#v1150-2025-01-24)
  * **Feature**: Add FixUnmarshalIndividualSetValues option to DecoderOptions to fix unmarshalling of individual values of StringSet, NumberSet, and BinarySet attributes.
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.17.54](feature/s3/manager/CHANGELOG.md#v11754-2025-01-24)
  * **Bug Fix**: Fix incorrect reference to old s3manager in comments.
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.8.2](internal/ini/CHANGELOG.md#v182-2025-01-24)
  * **Bug Fix**: Refactor filepath.Walk to filepath.WalkDir
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.51.8](service/autoscaling/CHANGELOG.md#v1518-2025-01-24)
  * **Bug Fix**: Switch to generated waiters, removing the dependency on go-jmespath and fixing broken waiters that used ordering comparators.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.47.0](service/cloudtrail/CHANGELOG.md#v1470-2025-01-24)
  * **Feature**: This release introduces the SearchSampleQueries API that allows users to search for CloudTrail Lake sample queries.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.43.10](service/cloudwatch/CHANGELOG.md#v14310-2025-01-24)
  * **Bug Fix**: Switch to generated waiters, removing the dependency on go-jmespath and fixing broken waiters that used ordering comparators.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.57.0](service/eks/CHANGELOG.md#v1570-2025-01-24)
  * **Feature**: Adds support for UpdateStrategies in EKS Managed Node Groups.
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.29.0](service/healthlake/CHANGELOG.md#v1290-2025-01-24)
  * **Feature**: Added new authorization strategy value 'SMART_ON_FHIR' for CreateFHIRDatastore API to support Smart App 2.0
* `github.com/aws/aws-sdk-go-v2/service/internal/checksum`: [v1.5.3](service/internal/checksum/CHANGELOG.md#v153-2025-01-24)
  * **Bug Fix**: Enable request checksum validation mode by default
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.74.1](service/s3/CHANGELOG.md#v1741-2025-01-24)
  * **Bug Fix**: Enable request checksum validation mode by default
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.56.8](service/ssm/CHANGELOG.md#v1568-2025-01-24)
  * **Documentation**: Systems Manager doc-only update for January, 2025.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.28.11](service/ssooidc/CHANGELOG.md#v12811-2025-01-24)
  * **Documentation**: Fixed typos in the descriptions.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.56.0](service/transfer/CHANGELOG.md#v1560-2025-01-24)
  * **Feature**: Added CustomDirectories as a new directory option for storing inbound AS2 messages, MDN files and Status files.

# Release (2025-01-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.201.0](service/ec2/CHANGELOG.md#v12010-2025-01-23)
  * **Feature**: Added "future" allocation type for future dated capacity reservation

# Release (2025-01-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.33.0](service/bedrockagentruntime/CHANGELOG.md#v1330-2025-01-22)
  * **Feature**: Adds multi-turn input support for an Agent node in an Amazon Bedrock Flow
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.105.4](service/glue/CHANGELOG.md#v11054-2025-01-22)
  * **Documentation**: Docs Update for timeout changes
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.66.0](service/medialive/CHANGELOG.md#v1660-2025-01-22)
  * **Feature**: AWS Elemental MediaLive adds a new feature, ID3 segment tagging, in CMAF Ingest output groups. It allows customers to insert ID3 tags into every output segment, controlled by a newly added channel schedule action Id3SegmentTagging.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.74.0](service/s3/CHANGELOG.md#v1740-2025-01-22)
  * **Feature**: Add a client config option to disable logging when output checksum validation is skipped due to an unsupported algorithm.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.11.2](service/workspacesthinclient/CHANGELOG.md#v1112-2025-01-22)
  * **Documentation**: Rename WorkSpaces Web to WorkSpaces Secure Browser

# Release (2025-01-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.49.7](service/batch/CHANGELOG.md#v1497-2025-01-21)
  * **Documentation**: Documentation-only update: clarified the description of the shareDecaySeconds parameter of the FairsharePolicy data type, clarified the description of the priority parameter of the JobQueueDetail data type.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.45.7](service/cloudwatchlogs/CHANGELOG.md#v1457-2025-01-21)
  * **Documentation**: Documentation-only update to address doc errors
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.49.0](service/cognitoidentityprovider/CHANGELOG.md#v1490-2025-01-21)
  * **Feature**: corrects the dual-stack endpoint configuration for cognitoidp
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.124.0](service/connect/CHANGELOG.md#v11240-2025-01-21)
  * **Feature**: Added DeleteContactFlowVersion API and the CAMPAIGN flow type
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.45.0](service/iotsitewise/CHANGELOG.md#v1450-2025-01-21)
  * **Feature**: AWS IoT SiteWise now supports ingestion and querying of Null (all data types) and NaN (double type) values of bad or uncertain data quality. New partial error handling prevents data loss during ingestion. Enabled by default for new customers; existing customers can opt-in.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.83.0](service/quicksight/CHANGELOG.md#v1830-2025-01-21)
  * **Feature**: Added `DigitGroupingStyle` in ThousandsSeparator to allow grouping by `LAKH`( Indian Grouping system ) currency. Support LAKH and `CRORE` currency types in Column Formatting.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.33.14](service/sns/CHANGELOG.md#v13314-2025-01-21)
  * **Documentation**: This release adds support for the topic attribute FifoThroughputScope for SNS FIFO topics. For details, see the documentation history in the Amazon Simple Notification Service Developer Guide.

# Release (2025-01-17)

## General Highlights
* **Bug Fix**: Fix bug where credentials weren't refreshed during retry loop.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.24.0](service/bedrockruntime/CHANGELOG.md#v1240-2025-01-17)
  * **Feature**: Allow hyphens in tool name for Converse and ConverseStream APIs
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.31.11](service/detective/CHANGELOG.md#v13111-2025-01-17)
  * **Documentation**: Doc only update for Detective documentation.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.200.0](service/ec2/CHANGELOG.md#v12000-2025-01-17)
  * **Feature**: Release u7i-6tb.112xlarge, u7i-8tb.112xlarge, u7inh-32tb.480xlarge, p5e.48xlarge, p5en.48xlarge, f2.12xlarge, f2.48xlarge, trn2.48xlarge instance types.
* `github.com/aws/aws-sdk-go-v2/service/notifications`: [v1.1.0](service/notifications/CHANGELOG.md#v110-2025-01-17)
  * **Feature**: Added support for Managed Notifications, integration with AWS Organization and added aggregation summaries for Aggregate Notifications
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.173.1](service/sagemaker/CHANGELOG.md#v11731-2025-01-17)
  * **Documentation**: Correction of docs for  "Added support for ml.trn1.32xlarge instance type in Reserved Capacity Offering"

# Release (2025-01-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.53.7](service/ecs/CHANGELOG.md#v1537-2025-01-16)
  * **Documentation**: The release addresses Amazon ECS documentation tickets.
* `github.com/aws/aws-sdk-go-v2/service/internal/checksum`: [v1.5.1](service/internal/checksum/CHANGELOG.md#v151-2025-01-16)
  * **Bug Fix**: Fix nil dereference panic for operations that require checksums, but do not have an input setting for which algorithm to use.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.173.0](service/sagemaker/CHANGELOG.md#v11730-2025-01-16)
  * **Feature**: Added support for ml.trn1.32xlarge instance type in Reserved Capacity Offering

# Release (2025-01-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.33.0
  * **Feature**: S3 client behavior is updated to always calculate a checksum by default for operations that support it (such as PutObject or UploadPart), or require it (such as DeleteObjects). The checksum algorithm used by default now becomes CRC32. Checksum behavior can be configured using `when_supported` and `when_required` options - in code using RequestChecksumCalculation, in shared config using request_checksum_calculation, or as env variable using AWS_REQUEST_CHECKSUM_CALCULATION. The S3 client attempts to validate response checksums for all S3 API operations that support checksums. However, if the SDK has not implemented the specified checksum algorithm then this validation is skipped. Checksum validation behavior can be configured using `when_supported` and `when_required` options - in code using ResponseChecksumValidation, in shared config using response_checksum_validation, or as env variable using AWS_RESPONSE_CHECKSUM_VALIDATION.
* `github.com/aws/aws-sdk-go-v2/config`: [v1.29.0](config/CHANGELOG.md#v1290-2025-01-15)
  * **Feature**: S3 client behavior is updated to always calculate a checksum by default for operations that support it (such as PutObject or UploadPart), or require it (such as DeleteObjects). The checksum algorithm used by default now becomes CRC32. Checksum behavior can be configured using `when_supported` and `when_required` options - in code using RequestChecksumCalculation, in shared config using request_checksum_calculation, or as env variable using AWS_REQUEST_CHECKSUM_CALCULATION. The S3 client attempts to validate response checksums for all S3 API operations that support checksums. However, if the SDK has not implemented the specified checksum algorithm then this validation is skipped. Checksum validation behavior can be configured using `when_supported` and `when_required` options - in code using ResponseChecksumValidation, in shared config using response_checksum_validation, or as env variable using AWS_RESPONSE_CHECKSUM_VALIDATION.
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.28.6](service/apigateway/CHANGELOG.md#v1286-2025-01-15)
  * **Documentation**: Documentation updates for Amazon API Gateway
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.32.0](service/bedrockagentruntime/CHANGELOG.md#v1320-2025-01-15)
  * **Feature**: Now supports streaming for inline agents.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentity`: [v1.28.0](service/cognitoidentity/CHANGELOG.md#v1280-2025-01-15)
  * **Feature**: corrects the dual-stack endpoint configuration
* `github.com/aws/aws-sdk-go-v2/service/internal/checksum`: [v1.5.0](service/internal/checksum/CHANGELOG.md#v150-2025-01-15)
  * **Feature**: S3 client behavior is updated to always calculate a checksum by default for operations that support it (such as PutObject or UploadPart), or require it (such as DeleteObjects). The checksum algorithm used by default now becomes CRC32. Checksum behavior can be configured using `when_supported` and `when_required` options - in code using RequestChecksumCalculation, in shared config using request_checksum_calculation, or as env variable using AWS_REQUEST_CHECKSUM_CALCULATION. The S3 client attempts to validate response checksums for all S3 API operations that support checksums. However, if the SDK has not implemented the specified checksum algorithm then this validation is skipped. Checksum validation behavior can be configured using `when_supported` and `when_required` options - in code using ResponseChecksumValidation, in shared config using response_checksum_validation, or as env variable using AWS_RESPONSE_CHECKSUM_VALIDATION.
* `github.com/aws/aws-sdk-go-v2/service/partnercentralselling`: [v1.3.0](service/partnercentralselling/CHANGELOG.md#v130-2025-01-15)
  * **Feature**: Add Tagging support for ResourceSnapshotJob resources
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.73.0](service/s3/CHANGELOG.md#v1730-2025-01-15)
  * **Feature**: S3 client behavior is updated to always calculate a checksum by default for operations that support it (such as PutObject or UploadPart), or require it (such as DeleteObjects). The checksum algorithm used by default now becomes CRC32. Checksum behavior can be configured using `when_supported` and `when_required` options - in code using RequestChecksumCalculation, in shared config using request_checksum_calculation, or as env variable using AWS_REQUEST_CHECKSUM_CALCULATION. The S3 client attempts to validate response checksums for all S3 API operations that support checksums. However, if the SDK has not implemented the specified checksum algorithm then this validation is skipped. Checksum validation behavior can be configured using `when_supported` and `when_required` options - in code using ResponseChecksumValidation, in shared config using response_checksum_validation, or as env variable using AWS_RESPONSE_CHECKSUM_VALIDATION.
  * **Feature**: This change enhances integrity protections for new SDK requests to S3. S3 SDKs now support the CRC64NVME checksum algorithm, full object checksums for multipart S3 objects, and new default integrity protections for S3 requests.
* `github.com/aws/aws-sdk-go-v2/service/securityir`: [v1.1.0](service/securityir/CHANGELOG.md#v110-2025-01-15)
  * **Feature**: Increase minimum length of Threat Actor IP 'userAgent' to 1.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.41.0](service/sesv2/CHANGELOG.md#v1410-2025-01-15)
  * **Feature**: This release introduces a new recommendation in Virtual Deliverability Manager Advisor, which detects elevated complaint rates for customer sending identities.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.52.0](service/workspaces/CHANGELOG.md#v1520-2025-01-15)
  * **Feature**: Added GeneralPurpose.4xlarge & GeneralPurpose.8xlarge ComputeTypes.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.11.0](service/workspacesthinclient/CHANGELOG.md#v1110-2025-01-15)
  * **Feature**: Mark type in MaintenanceWindow as required.

# Release (2025-01-14)

## General Highlights
* **Bug Fix**: Fix issue where waiters were not failing on unmatched errors as they should. This may have breaking behavioral changes for users in fringe cases. See [this announcement](https://github.com/aws/aws-sdk-go-v2/discussions/2954) for more information.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.199.1](service/ec2/CHANGELOG.md#v11991-2025-01-14)
  * **Bug Fix**: Fix nil dereference panic in certain waiters.
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.39.0](service/gamelift/CHANGELOG.md#v1390-2025-01-14)
  * **Feature**: Amazon GameLift releases a new game session placement feature: PriorityConfigurationOverride. You can now override how a game session queue prioritizes placement locations for a single StartGameSessionPlacement request.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.48.0](service/route53/CHANGELOG.md#v1480-2025-01-14)
  * **Feature**: Amazon Route 53 now supports the Mexico (Central) Region (mx-central-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region

# Release (2025-01-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/artifact`: [v1.8.0](service/artifact/CHANGELOG.md#v180-2025-01-13)
  * **Feature**: Support resolving regional API calls to partition's leader region endpoint.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.26.0](service/bedrock/CHANGELOG.md#v1260-2025-01-13)
  * **Feature**: With this release, Bedrock Evaluation will now support latency-optimized inference for foundation models.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.199.0](service/ec2/CHANGELOG.md#v11990-2025-01-13)
  * **Feature**: Add support for DisconnectOnSessionTimeout flag in CreateClientVpnEndpoint and ModifyClientVpnEndpoint requests and DescribeClientVpnEndpoints responses
* `github.com/aws/aws-sdk-go-v2/service/kafkaconnect`: [v1.22.0](service/kafkaconnect/CHANGELOG.md#v1220-2025-01-13)
  * **Feature**: Support updating connector configuration via UpdateConnector API. Release Operations API to monitor the status of the connector operation.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.42.0](service/transcribe/CHANGELOG.md#v1420-2025-01-13)
  * **Feature**: This update provides tagging support for Transcribe's Call Analytics Jobs and Call Analytics Categories.

# Release (2025-01-10)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.53.4](service/redshift/CHANGELOG.md#v1534-2025-01-10)
  * **Documentation**: Additions to the PubliclyAccessible and Encrypted parameters clarifying what the defaults are.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.19.8](service/securitylake/CHANGELOG.md#v1198-2025-01-10)
  * **Documentation**: Doc only update for ServiceName that fixes several customer-reported issues
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.33.6](service/sts/CHANGELOG.md#v1336-2025-01-10)
  * **Documentation**: Fixed typos in the descriptions.

# Release (2025-01-09)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.32.8
  * **Bug Fix**: Retry transient net.ErrClosed errors by default.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.50.0](service/codebuild/CHANGELOG.md#v1500-2025-01-09)
  * **Feature**: AWS CodeBuild Now Supports BuildBatch in Reserved Capacity and Lambda
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.41.0](service/computeoptimizer/CHANGELOG.md#v1410-2025-01-09)
  * **Feature**: This release expands AWS Compute Optimizer rightsizing recommendation support for Amazon EC2 Auto Scaling groups to include those with scaling policies and multiple instance types.
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.39.0](service/fms/CHANGELOG.md#v1390-2025-01-09)
  * **Feature**: AWS Firewall Manager now lets you combine multiple resource tags using the logical AND operator or the logical OR operator.

# Release (2025-01-08)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.93.3](service/rds/CHANGELOG.md#v1933-2025-01-08)
  * **Documentation**: Updates Amazon RDS documentation to clarify the RestoreDBClusterToPointInTime description.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.47.0](service/route53/CHANGELOG.md#v1470-2025-01-08)
  * **Feature**: Amazon Route 53 now supports the Asia Pacific (Thailand) Region (ap-southeast-7) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.172.0](service/sagemaker/CHANGELOG.md#v11720-2025-01-08)
  * **Feature**: Adds support for IPv6 for SageMaker HyperPod cluster nodes.

# Release (2025-01-07)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.29.0](service/cloudhsmv2/CHANGELOG.md#v1290-2025-01-07)
  * **Feature**: Adds support to ModifyCluster for modifying a Cluster's Hsm Type.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.39.0](service/dynamodb/CHANGELOG.md#v1390-2025-01-07)
  * **Feature**: This release makes Amazon DynamoDB point-in-time-recovery (PITR) to be configurable. You can set PITR recovery period for each table individually to between 1 and 35 days.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.40.0](service/imagebuilder/CHANGELOG.md#v1400-2025-01-07)
  * **Feature**: This release adds support for importing images from ISO disk files. Added new ImportDiskImage API operation.
* `github.com/aws/aws-sdk-go-v2/service/iot1clickdevicesservice`: [v1.24.0](service/iot1clickdevicesservice/CHANGELOG.md#v1240-2025-01-07)
  * **Feature**: Mark service/iot1clickdevicesservice and service/iot1clickprojects as deprecated. Those 2 services are no longer available for use. See https://docs.aws.amazon.com/iot/latest/developerguide/iot-legacy-services.html#faq-1-click-eol
* `github.com/aws/aws-sdk-go-v2/service/iot1clickprojects`: [v1.24.0](service/iot1clickprojects/CHANGELOG.md#v1240-2025-01-07)
  * **Feature**: Mark service/iot1clickdevicesservice and service/iot1clickprojects as deprecated. Those 2 services are no longer available for use. See https://docs.aws.amazon.com/iot/latest/developerguide/iot-legacy-services.html#faq-1-click-eol

# Release (2025-01-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iotsecuretunneling`: [v1.28.0](service/iotsecuretunneling/CHANGELOG.md#v1280-2025-01-06)
  * **Feature**: Adds dualstack endpoint support for IoT Secure Tunneling
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.11.0](service/supplychain/CHANGELOG.md#v1110-2025-01-06)
  * **Feature**: Allow vanity DNS domain when creating a new ASC instance

# Release (2025-01-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.53.2](service/ecs/CHANGELOG.md#v1532-2025-01-03)
  * **Documentation**: Adding SDK reference examples for Amazon ECS operations.
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.28.2](service/route53domains/CHANGELOG.md#v1282-2025-01-03)
  * **Documentation**: Doc only update for Route 53 Domains that fixes several customer-reported issues
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.72.0](service/s3/CHANGELOG.md#v1720-2025-01-03)
  * **Feature**: This change is only for updating the model regexp of CopySource which is not for validation but only for documentation and user guide change.

# Release (2025-01-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.41.0](service/appsync/CHANGELOG.md#v1410-2025-01-02)
  * **Feature**: Modify UpdateGraphQLAPI operation and flag authenticationType as required.
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.38.0](service/gamelift/CHANGELOG.md#v1380-2025-01-02)
  * **Feature**: Amazon GameLift releases a new game session shutdown feature. Use the Amazon GameLift console or AWS CLI to terminate an in-progress game session that's entered a bad state or is no longer needed.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.37.0](service/mediaconnect/CHANGELOG.md#v1370-2025-01-02)
  * **Feature**: AWS Elemental MediaConnect now supports Content Quality Analysis for enhanced source stream monitoring. This enables you to track specific audio and video metrics in transport stream source flows, ensuring your content meets quality standards.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.65.0](service/mediaconvert/CHANGELOG.md#v1650-2025-01-02)
  * **Feature**: This release adds support for the AVC3 codec and fixes an alignment issue with Japanese vertical captions.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.37.0](service/organizations/CHANGELOG.md#v1370-2025-01-02)
  * **Feature**: Added ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED to ConstraintViolationException for the EnableAllFeatures operation.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.171.0](service/sagemaker/CHANGELOG.md#v11710-2025-01-02)
  * **Feature**: Adding ETag information with Model Artifacts for Model Registry
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.37.4](service/sqs/CHANGELOG.md#v1374-2025-01-02)
  * **Documentation**: In-flight message typo fix from 20k to 120k.

# Release (2024-12-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.38.0](service/ecr/CHANGELOG.md#v1380-2024-12-28)
  * **Feature**: Restoring custom endpoint functionality for ECR
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.29.0](service/ecrpublic/CHANGELOG.md#v1290-2024-12-28)
  * **Feature**: Restoring custom endpoint functionality for ECR Public

# Release (2024-12-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.93.2](service/rds/CHANGELOG.md#v1932-2024-12-27)
  * **Documentation**: Updates Amazon RDS documentation to correct various descriptions.

# Release (2024-12-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator`: [v1.1.0](service/bcmpricingcalculator/CHANGELOG.md#v110-2024-12-26)
  * **Feature**: Added ConflictException to DeleteBillEstimate.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.37.0](service/ecr/CHANGELOG.md#v1370-2024-12-26)
  * **Feature**: Add support for Dualstack Endpoints
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.44.7](service/networkfirewall/CHANGELOG.md#v1447-2024-12-26)
  * **Documentation**: Dual-stack endpoints are now supported.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.55.2](service/securityhub/CHANGELOG.md#v1552-2024-12-26)
  * **Documentation**: Documentation updates for AWS Security Hub

# Release (2024-12-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.36.9](service/ecr/CHANGELOG.md#v1369-2024-12-23)
  * **Documentation**: Documentation update for ECR GetAccountSetting and PutAccountSetting APIs.
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.28.0](service/ecrpublic/CHANGELOG.md#v1280-2024-12-23)
  * **Feature**: Add support for Dualstack endpoints
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.56.0](service/eks/CHANGELOG.md#v1560-2024-12-23)
  * **Feature**: This release adds support for DescribeClusterVersions API that provides important information about Kubernetes versions along with end of support dates
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.105.0](service/glue/CHANGELOG.md#v11050-2024-12-23)
  * **Feature**: Add IncludeRoot parameters to GetCatalogs API to return root catalog.

# Release (2024-12-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.33.0](service/bedrockagent/CHANGELOG.md#v1330-2024-12-20)
  * **Feature**: Support for custom user agent and max web pages crawled for web connector. Support app only credentials for SharePoint connector. Increase agents memory duration limit to 365 days. Support to specify max number of session summaries to include in agent invocation context.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.31.0](service/bedrockagentruntime/CHANGELOG.md#v1310-2024-12-20)
  * **Feature**: bedrock agents now supports long term memory and performance configs. Invokeflow supports performance configs. RetrieveAndGenerate performance configs
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation`: [v1.0.2](service/bedrockdataautomation/CHANGELOG.md#v102-2024-12-20)
  * **Documentation**: Documentation update for Amazon Bedrock Data Automation
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomationruntime`: [v1.0.2](service/bedrockdataautomationruntime/CHANGELOG.md#v102-2024-12-20)
  * **Documentation**: Documentation update for Amazon Bedrock Data Automation Runtime
* `github.com/aws/aws-sdk-go-v2/service/billing`: [v1.1.0](service/billing/CHANGELOG.md#v110-2024-12-20)
  * **Feature**: Added new API's for defining and fetching Billing Views.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.123.0](service/connect/CHANGELOG.md#v11230-2024-12-20)
  * **Feature**: This release supports adding NotAttributeCondition and Range to the RoutingCriteria object.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.46.0](service/costexplorer/CHANGELOG.md#v1460-2024-12-20)
  * **Feature**: Support for retrieving cost, usage, and forecast for billing view.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.40.0](service/docdb/CHANGELOG.md#v1400-2024-12-20)
  * **Feature**: Support AWS Secret Manager managed password for AWS DocumentDB instance-based cluster.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.55.0](service/eks/CHANGELOG.md#v1550-2024-12-20)
  * **Feature**: This release expands the catalog of upgrade insight checks
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.44.0](service/macie2/CHANGELOG.md#v1440-2024-12-20)
  * **Feature**: This release adds support for identifying S3 general purpose buckets that exceed the Amazon Macie quota for preventative control monitoring.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.48.0](service/outposts/CHANGELOG.md#v1480-2024-12-20)
  * **Feature**: Add CS8365C as a supported power connector for Outpost sites.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.170.0](service/sagemaker/CHANGELOG.md#v11700-2024-12-20)
  * **Feature**: This release adds support for c6i, m6i and r6i instance on SageMaker Hyperpod and trn1 instances in batch

# Release (2024-12-19)

## General Highlights
* **Bug Fix**: Fix improper use of printf-style functions.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.42.0](service/appstream/CHANGELOG.md#v1420-2024-12-19)
  * **Feature**: Added support for Rocky Linux 8 on Amazon AppStream 2.0
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.64.0](service/mediaconvert/CHANGELOG.md#v1640-2024-12-19)
  * **Feature**: This release adds support for inserting timecode tracks into MP4 container outputs.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.65.0](service/medialive/CHANGELOG.md#v1650-2024-12-19)
  * **Feature**: MediaLive is releasing ListVersions api
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.15.0](service/qconnect/CHANGELOG.md#v1150-2024-12-19)
  * **Feature**: Amazon Q in Connect enables agents to ask Q for assistance in multiple languages and Q will provide answers and recommended step-by-step guides in those languages. Qs default language is English (United States) and you can switch this by setting the locale configuration on the AI Agent.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.19.0](service/ssmsap/CHANGELOG.md#v1190-2024-12-19)
  * **Feature**: AWS Systems Manager for SAP added support for registration and discovery of distributed ABAP applications
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.51.0](service/workspaces/CHANGELOG.md#v1510-2024-12-19)
  * **Feature**: Added AWS Global Accelerator (AGA) support for WorkSpaces Personal.

# Release (2024-12-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.28.0](service/amplify/CHANGELOG.md#v1280-2024-12-18)
  * **Feature**: Added WAF Configuration to Amplify Apps
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.29.0](service/budgets/CHANGELOG.md#v1290-2024-12-18)
  * **Feature**: Releasing minor partition endpoint updates
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.122.0](service/connect/CHANGELOG.md#v11220-2024-12-18)
  * **Feature**: This release adds support for the UpdateParticipantAuthentication API used for customer authentication within Amazon Connect chats.
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.28.0](service/connectparticipant/CHANGELOG.md#v1280-2024-12-18)
  * **Feature**: This release adds support for the GetAuthenticationUrl and CancelParticipantAuthentication APIs used for customer authentication within Amazon Connect chats. There are also minor updates to the GetAttachment API.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.44.0](service/datasync/CHANGELOG.md#v1440-2024-12-18)
  * **Feature**: AWS DataSync introduces the ability to update attributes for in-cloud locations.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.62.0](service/iot/CHANGELOG.md#v1620-2024-12-18)
  * **Feature**: Release connectivity status query API which is a dedicated high throughput(TPS) API to query a specific device's most recent connectivity state and metadata.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.33.2](service/mwaa/CHANGELOG.md#v1332-2024-12-18)
  * **Documentation**: Added support for Apache Airflow version 2.10.3 to MWAA.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.82.0](service/quicksight/CHANGELOG.md#v1820-2024-12-18)
  * **Feature**: Add support for PerformanceConfiguration attribute to Dataset entity. Allow PerformanceConfiguration specification in CreateDataset and UpdateDataset APIs.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.29.0](service/resiliencehub/CHANGELOG.md#v1290-2024-12-18)
  * **Feature**: AWS Resilience Hub now automatically detects already configured CloudWatch alarms and FIS experiments as part of the assessment process and returns the discovered resources in the corresponding list API responses. It also allows you to include or exclude test recommendations for an AppComponent.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.55.0](service/transfer/CHANGELOG.md#v1550-2024-12-18)
  * **Feature**: Added AS2 agreement configurations to control filename preservation and message signing enforcement. Added AS2 connector configuration to preserve content type from S3 objects.

# Release (2024-12-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.22.0](service/account/CHANGELOG.md#v1220-2024-12-17)
  * **Feature**: Update endpoint configuration.
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.40.0](service/backup/CHANGELOG.md#v1400-2024-12-17)
  * **Feature**: Add Support for Backup Indexing
* `github.com/aws/aws-sdk-go-v2/service/backupsearch`: [v1.0.0](service/backupsearch/CHANGELOG.md#v100-2024-12-17)
  * **Release**: New AWS service client module
  * **Feature**: Add support for searching backups
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.49.0](service/batch/CHANGELOG.md#v1490-2024-12-17)
  * **Feature**: This feature allows AWS Batch on Amazon EKS to support configuration of Pod Annotations, overriding Namespace on which the Batch job's Pod runs on, and allows Subpath and Persistent Volume claim to be set for AWS Batch on Amazon EKS jobs.
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.11.0](service/cleanroomsml/CHANGELOG.md#v1110-2024-12-17)
  * **Feature**: Add support for SQL compute configuration for StartAudienceGenerationJob API.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.44.0](service/cloudfront/CHANGELOG.md#v1440-2024-12-17)
  * **Feature**: Adds support for OriginReadTimeout and OriginKeepaliveTimeout to create CloudFront Distributions with VPC Origins.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.38.0](service/codepipeline/CHANGELOG.md#v1380-2024-12-17)
  * **Feature**: AWS CodePipeline V2 type pipelines now support Managed Compute Rule.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.53.0](service/ecs/CHANGELOG.md#v1530-2024-12-17)
  * **Feature**: Added support for enableFaultInjection task definition parameter which can be used to enable Fault Injection feature on ECS tasks.
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.19.0](service/m2/CHANGELOG.md#v1190-2024-12-17)
  * **Feature**: This release adds support for AWS Mainframe Modernization(M2) Service to allow specifying network type(ipv4, dual) for the environment instances. For dual network type, m2 environment applications will serve both IPv4 and IPv6 requests, whereas for ipv4 it will serve only IPv4 requests.
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.31.0](service/synthetics/CHANGELOG.md#v1310-2024-12-17)
  * **Feature**: Add support to toggle outbound IPv6 traffic on canaries connected to dualstack subnets.  This behavior can be controlled via the new Ipv6AllowedForDualStack parameter of the VpcConfig input object in CreateCanary and UpdateCanary APIs.

# Release (2024-12-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dsql/auth`: [v1.0.0](feature/dsql/auth/CHANGELOG.md#v100-2024-12-16)
  * **Release**: Add Aurora DSQL Auth Token Generator
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.28.8](service/cloud9/CHANGELOG.md#v1288-2024-12-16)
  * **Documentation**: Added information about Ubuntu 18.04 will be removed from the available imageIds for Cloud9 because Ubuntu 18.04 has ended standard support on May 31, 2023.
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.29.0](service/dlm/CHANGELOG.md#v1290-2024-12-16)
  * **Feature**: This release adds support for Local Zones in Amazon Data Lifecycle Manager EBS snapshot lifecycle policies.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.198.0](service/ec2/CHANGELOG.md#v11980-2024-12-16)
  * **Feature**: This release adds support for EBS local snapshots in AWS Dedicated Local Zones, which allows you to store snapshots of EBS volumes locally in Dedicated Local Zones.
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.36.0](service/greengrassv2/CHANGELOG.md#v1360-2024-12-16)
  * **Feature**: Add support for runtime in GetCoreDevice and ListCoreDevices APIs.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.64.0](service/medialive/CHANGELOG.md#v1640-2024-12-16)
  * **Feature**: AWS Elemental MediaLive adds three new features: MediaPackage v2 endpoint support for live stream delivery, KLV metadata passthrough in CMAF Ingest output groups, and Metadata Name Modifier in CMAF Ingest output groups for customizing metadata track names in output streams.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.93.0](service/rds/CHANGELOG.md#v1930-2024-12-16)
  * **Feature**: This release adds support for the "MYSQL_CACHING_SHA2_PASSWORD" enum value for RDS Proxy ClientPasswordAuthType.

# Release (2024-12-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.28.0](service/cloudhsmv2/CHANGELOG.md#v1280-2024-12-13)
  * **Feature**: Add support for Dual-Stack hsm2m.medium clusters. The customers will now be able to create hsm2m.medium clusters having both IPv4 and IPv6 connection capabilities by specifying a new param called NetworkType=DUALSTACK during cluster creation.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.197.0](service/ec2/CHANGELOG.md#v11970-2024-12-13)
  * **Feature**: This release adds GroupId to the response for DeleteSecurityGroup.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.54.0](service/eks/CHANGELOG.md#v1540-2024-12-13)
  * **Feature**: Add NodeRepairConfig in CreateNodegroupRequest and UpdateNodegroupConfigRequest
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.36.0](service/mediaconnect/CHANGELOG.md#v1360-2024-12-13)
  * **Feature**: AWS Elemental MediaConnect Gateway now supports Source Specific Multicast (SSM) for ingress bridges. This enables you to specify a source IP address in addition to a multicast IP when creating or updating an ingress bridge source.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.32.2](service/networkmanager/CHANGELOG.md#v1322-2024-12-13)
  * **Documentation**: There was a sentence fragment in UpdateDirectConnectGatewayAttachment that was causing customer confusion as to whether it's an incomplete sentence or if it was a typo. Removed the fragment.
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.34.0](service/servicediscovery/CHANGELOG.md#v1340-2024-12-13)
  * **Feature**: AWS Cloud Map now supports service-level attributes, allowing you to associate custom metadata directly with services. These attributes can be retrieved, updated, and deleted using the new GetServiceAttributes, UpdateServiceAttributes, and DeleteServiceAttributes API calls.

# Release (2024-12-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.121.0](service/connect/CHANGELOG.md#v11210-2024-12-12)
  * **Feature**: Configure holidays and other overrides to hours of operation in advance. During contact handling, Amazon Connect automatically checks for overrides and provides customers with an appropriate flow path. After an override period passes call center automatically reverts to standard hours of operation.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.45.0](service/databasemigrationservice/CHANGELOG.md#v1450-2024-12-12)
  * **Feature**: Add parameters to support for kerberos authentication. Add parameter for disabling the Unicode source filter with PostgreSQL settings. Add parameter to use large integer value with Kinesis/Kafka settings.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.104.0](service/glue/CHANGELOG.md#v11040-2024-12-12)
  * **Feature**: To support customer-managed encryption in Data Quality to allow customers encrypt data with their own KMS key, we will add a DataQualityEncryption field to the SecurityConfiguration API where customers can provide their KMS keys.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.52.1](service/guardduty/CHANGELOG.md#v1521-2024-12-12)
  * **Documentation**: Improved descriptions for certain APIs.
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.28.0](service/route53domains/CHANGELOG.md#v1280-2024-12-12)
  * **Feature**: This release includes the following API updates: added the enumeration type RESTORE_DOMAIN to the OperationType; constrained the Price attribute to non-negative values; updated the LangCode to allow 2 or 3 alphabetical characters.

# Release (2024-12-11)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/artifact`: [v1.7.0](service/artifact/CHANGELOG.md#v170-2024-12-11)
  * **Feature**: Add support for listing active customer agreements for the calling AWS Account.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.46.3](service/cloudtrail/CHANGELOG.md#v1463-2024-12-11)
  * **Documentation**: Doc-only updates for CloudTrail.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.48.1](service/cognitoidentityprovider/CHANGELOG.md#v1481-2024-12-11)
  * **Documentation**: Updated descriptions for some API operations and parameters, corrected some errors in Cognito user pools
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.6.3](service/controlcatalog/CHANGELOG.md#v163-2024-12-11)
  * **Documentation**: Minor documentation updates to the content of ImplementationDetails object part of the Control Catalog GetControl API
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.27.0](service/emrserverless/CHANGELOG.md#v1270-2024-12-11)
  * **Feature**: This release adds support for accessing system profile logs in Lake Formation-enabled jobs.
* `github.com/aws/aws-sdk-go-v2/service/migrationhub`: [v1.25.0](service/migrationhub/CHANGELOG.md#v1250-2024-12-11)
  * **Feature**: API and documentation updates for AWS MigrationHub related to adding support for listing migration task updates and associating, disassociating and listing source resources
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.40.0](service/sesv2/CHANGELOG.md#v1400-2024-12-11)
  * **Feature**: Introduces support for multi-region endpoint.
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.7.0](service/timestreaminfluxdb/CHANGELOG.md#v170-2024-12-11)
  * **Feature**: Adds networkType parameter to CreateDbInstance API which allows IPv6 support to the InfluxDB endpoint

# Release (2024-12-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.34.2](service/applicationautoscaling/CHANGELOG.md#v1342-2024-12-10)
  * **Documentation**: Doc only update for AAS Predictive Scaling policy configuration API.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.120.0](service/connect/CHANGELOG.md#v11200-2024-12-10)
  * **Feature**: Add support for Push Notifications for Amazon Connect chat. With Push Notifications enabled an alert could be sent to customers about new messages even when they aren't actively using the mobile application.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.21.0](service/ivsrealtime/CHANGELOG.md#v1210-2024-12-10)
  * **Feature**: IVS Real-Time now offers customers the ability to customize thumbnails recording mode and interval for both Individual Participant Recording (IPR) and Server-Side Compositions (SSC).
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.39.0](service/sesv2/CHANGELOG.md#v1390-2024-12-10)
  * **Feature**: Introduces support for creating DEED (Deterministic Easy-DKIM) identities.

# Release (2024-12-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.40.2](service/appsync/CHANGELOG.md#v1402-2024-12-09)
  * **Documentation**: Provides description of new Amazon Bedrock runtime datasource.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.48.0](service/cognitoidentityprovider/CHANGELOG.md#v1480-2024-12-09)
  * **Feature**: Change `CustomDomainConfig` from a required to an optional parameter for the `UpdateUserPoolDomain` operation.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.196.0](service/ec2/CHANGELOG.md#v11960-2024-12-09)
  * **Feature**: This release includes a new API for modifying instance network-performance-options after launch.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.52.2](service/ecs/CHANGELOG.md#v1522-2024-12-09)
  * **Documentation**: This is a documentation only update to address various tickets for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.16.2](service/keyspaces/CHANGELOG.md#v1162-2024-12-09)
  * **Documentation**: Amazon Keyspaces: adding the list of IAM actions required by the UpdateKeyspace API.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.63.0](service/medialive/CHANGELOG.md#v1630-2024-12-09)
  * **Feature**: H265 outputs now support disabling the deblocking filter.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.50.3](service/workspaces/CHANGELOG.md#v1503-2024-12-09)
  * **Documentation**: Added text to clarify case-sensitivity

# Release (2024-12-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/rds/auth`: [v1.5.1](feature/rds/auth/CHANGELOG.md#v151-2024-12-06)
  * **Bug Fix**: **BREAKFIX**: Revert bad API release.

# Release (2024-12-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/partnercentralselling`: [v1.2.0](service/partnercentralselling/CHANGELOG.md#v120-2024-12-05)
  * **Feature**: Introducing the preview of new partner central selling APIs designed to transform how AWS partners collaborate and co-sell with multiple partners. This enables multiple partners to seamlessly engage and jointly pursue customer opportunities, fostering a new era of collaborative selling.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.19.0](service/qbusiness/CHANGELOG.md#v1190-2024-12-05)
  * **Feature**: This release removes the deprecated UserId and UserGroups fields from SearchRelevantContent api's request parameters.

# Release (2024-12-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.25.0](service/bedrock/CHANGELOG.md#v1250-2024-12-04)
  * **Feature**: Introduced two APIs ListPromptRouters and GetPromptRouter for Intelligent Prompt Router feature. Add support for Bedrock Guardrails image content filter. New Bedrock Marketplace feature enabling a wider range of bedrock compatible models with self-hosted capability.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.32.0](service/bedrockagent/CHANGELOG.md#v1320-2024-12-04)
  * **Feature**: This release introduces the ability to generate SQL using natural language, through a new GenerateQuery API (with native integration into Knowledge Bases); ability to ingest and retrieve images through Bedrock Data Automation; and ability to create a Knowledge Base backed by Kendra GenAI Index.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.30.0](service/bedrockagentruntime/CHANGELOG.md#v1300-2024-12-04)
  * **Feature**: This release introduces the ability to generate SQL using natural language, through a new GenerateQuery API (with native integration into Knowledge Bases); ability to ingest and retrieve images through Bedrock Data Automation; and ability to create a Knowledge Base backed by Kendra GenAI Index.
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomation`: [v1.0.0](service/bedrockdataautomation/CHANGELOG.md#v100-2024-12-04)
  * **Release**: New AWS service client module
  * **Feature**: Release Bedrock Data Automation SDK
* `github.com/aws/aws-sdk-go-v2/service/bedrockdataautomationruntime`: [v1.0.0](service/bedrockdataautomationruntime/CHANGELOG.md#v100-2024-12-04)
  * **Release**: New AWS service client module
  * **Feature**: Release Bedrock Data Automation Runtime SDK
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.23.0](service/bedrockruntime/CHANGELOG.md#v1230-2024-12-04)
  * **Feature**: Added support for Intelligent Prompt Router in Invoke, InvokeStream, Converse and ConverseStream. Add support for Bedrock Guardrails image content filter. New Bedrock Marketplace feature enabling a wider range of bedrock compatible models with self-hosted capability.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.55.0](service/kendra/CHANGELOG.md#v1550-2024-12-04)
  * **Feature**: This release adds GenAI Index in Amazon Kendra for Retrieval Augmented Generation (RAG) and intelligent search. With the Kendra GenAI Index, customers get high retrieval accuracy powered by the latest information retrieval technologies and semantic models.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.169.0](service/sagemaker/CHANGELOG.md#v11690-2024-12-04)
  * **Feature**: Amazon SageMaker HyperPod launched task governance to help customers maximize accelerator utilization for model development and flexible training plans to meet training timelines and budget while reducing weeks of training time. AI apps from AWS partner is now available in SageMaker.

# Release (2024-12-03.2)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/rds/auth`: [v1.5.0](feature/rds/auth/CHANGELOG.md#v150-2024-12-032)
  * No change notes available for this release.
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.49.0](service/athena/CHANGELOG.md#v1490-2024-12-032)
  * **Feature**: Add FEDERATED type to CreateDataCatalog. This creates Athena Data Catalog, AWS Lambda connector, and AWS Glue connection. Create/DeleteDataCatalog returns DataCatalog. Add Status, ConnectionType, and Error to DataCatalog and DataCatalogSummary. Add DeleteCatalogOnly to delete Athena Catalog only.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.24.0](service/bedrock/CHANGELOG.md#v1240-2024-12-032)
  * **Feature**: Tagging support for Async Invoke resources. Added support for Distillation in CreateModelCustomizationJob API. Support for videoDataDeliveryEnabled flag in invocation logging.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.31.0](service/bedrockagent/CHANGELOG.md#v1310-2024-12-032)
  * **Feature**: Releasing SDK for Multi-Agent Collaboration.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.29.0](service/bedrockagentruntime/CHANGELOG.md#v1290-2024-12-032)
  * **Feature**: Releasing SDK for multi agent collaboration
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.22.0](service/bedrockruntime/CHANGELOG.md#v1220-2024-12-032)
  * **Feature**: Added support for Async Invoke Operations Start, List and Get. Support for invocation logs with `requestMetadata` field in Converse, ConverseStream, Invoke and InvokeStream. Video content blocks in Converse/ConverseStream accept raw bytes or S3 URI.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.43.3](service/cloudwatch/CHANGELOG.md#v1433-2024-12-032)
  * **Documentation**: Support for configuring AiOps investigation as alarm action
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.25.0](service/datazone/CHANGELOG.md#v1250-2024-12-032)
  * **Feature**: Adds support for Connections, ProjectProfiles, and JobRuns APIs. Supports the new Lineage feature at GA. Adjusts optionality of a parameter for DataSource and SubscriptionTarget APIs which may adjust types in some clients.
* `github.com/aws/aws-sdk-go-v2/service/dsql`: [v1.0.0](service/dsql/CHANGELOG.md#v100-2024-12-032)
  * **Release**: New AWS service client module
  * **Feature**: Add new API operations for Amazon Aurora DSQL. Amazon Aurora DSQL is a serverless, distributed SQL database with virtually unlimited scale, highest availability, and zero infrastructure management.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.38.0](service/dynamodb/CHANGELOG.md#v1380-2024-12-032)
  * **Feature**: This change adds support for global tables with multi-Region strong consistency (in preview). The UpdateTable API now supports a new attribute MultiRegionConsistency to set consistency when creating global tables. The DescribeTable output now optionally includes the MultiRegionConsistency attribute.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.103.0](service/glue/CHANGELOG.md#v11030-2024-12-032)
  * **Feature**: This release includes(1)Zero-ETL integration to ingest data from 3P SaaS and DynamoDB to Redshift/Redlake (2)new properties on Connections to enable reuse; new connection APIs for retrieve/preview metadata (3)support of CRUD operations for Multi-catalog (4)support of automatic statistics collections
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.39.0](service/lakeformation/CHANGELOG.md#v1390-2024-12-032)
  * **Feature**: This release added two new LakeFormation Permissions (CREATE_CATALOG, SUPER_USER) and added Id field for CatalogResource. It also added new conditon and expression field.
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.6.0](service/qapps/CHANGELOG.md#v160-2024-12-032)
  * **Feature**: Add support for 11 new plugins as action cards to help automate repetitive tasks and improve productivity.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.18.0](service/qbusiness/CHANGELOG.md#v1180-2024-12-032)
  * **Feature**: Amazon Q Business now supports customization options for your web experience, 11 new Plugins, and QuickSight support. Amazon Q index allows software providers to enrich their native generative AI experiences with their customer's enterprise knowledge and user context spanning multiple applications.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.81.0](service/quicksight/CHANGELOG.md#v1810-2024-12-032)
  * **Feature**: This release includes API needed to support for Unstructured Data in Q in QuickSight Q&A (IDC).
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.53.0](service/redshift/CHANGELOG.md#v1530-2024-12-032)
  * **Feature**: Adds support for Amazon Redshift RegisterNamespace and DeregisterNamespace APIs to share data to AWS Glue Data Catalog.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.25.0](service/redshiftserverless/CHANGELOG.md#v1250-2024-12-032)
  * **Feature**: Adds support for the ListManagedWorkgroups API to get an overview of existing managed workgroups.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.71.0](service/s3/CHANGELOG.md#v1710-2024-12-032)
  * **Feature**: Amazon S3 Metadata stores object metadata in read-only, fully managed Apache Iceberg metadata tables that you can query. You can create metadata table configurations for S3 general purpose buckets.
* `github.com/aws/aws-sdk-go-v2/service/s3tables`: [v1.0.0](service/s3tables/CHANGELOG.md#v100-2024-12-032)
  * **Release**: New AWS service client module
  * **Feature**: Amazon S3 Tables deliver the first cloud object store with built-in open table format support, and the easiest way to store tabular data at scale.

# Release (2024-12-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.21.0](service/bedrockruntime/CHANGELOG.md#v1210-2024-12-03)
  * **Feature**: Add an API parameter that allows customers to set performance configuration for invoking a model.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.52.0](service/s3control/CHANGELOG.md#v1520-2024-12-03)
  * **Feature**: It allows customers to pass CRC64NVME as a header in S3 Batch Operations copy requests
* `github.com/aws/aws-sdk-go-v2/service/socialmessaging`: [v1.1.0](service/socialmessaging/CHANGELOG.md#v110-2024-12-03)
  * **Feature**: Added support for passing role arn corresponding to the supported event destination

# Release (2024-12-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.32.6
  * **Bug Fix**: Fix user agent to add business metrics at the end instead of prepend them
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.23.0](service/bedrock/CHANGELOG.md#v1230-2024-12-02)
  * **Feature**: Add support for Knowledge Base Evaluations & LLM as a judge
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.30.0](service/bedrockagent/CHANGELOG.md#v1300-2024-12-02)
  * **Feature**: This release introduces APIs to upload documents directly into a Knowledge Base
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.28.0](service/bedrockagentruntime/CHANGELOG.md#v1280-2024-12-02)
  * **Feature**: This release introduces a new Rerank API to leverage reranking models (with integration into Knowledge Bases); APIs to upload documents directly into Knowledge Base; RetrieveAndGenerateStream API for streaming response; Guardrails on Retrieve API; and ability to automatically generate filters
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.20.0](service/chimesdkvoice/CHANGELOG.md#v1200-2024-12-02)
  * **Feature**: This release adds supports for enterprises to integrate Amazon Connect with other voice systems. It supports directly transferring voice calls and metadata without using the public telephone network. It also supports real-time and post-call analytics.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.21.0](service/cleanrooms/CHANGELOG.md#v1210-2024-12-02)
  * **Feature**: This release allows customers and their partners to easily collaborate with data stored in Snowflake and Amazon Athena, without having to move or share their underlying data among collaborators.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.45.0](service/cloudwatchlogs/CHANGELOG.md#v1450-2024-12-02)
  * **Feature**: Adds PutIntegration, GetIntegration, ListIntegrations and DeleteIntegration APIs. Adds QueryLanguage support to StartQuery, GetQueryResults, DescribeQueries, DescribeQueryDefinitions, and PutQueryDefinition APIs.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.119.0](service/connect/CHANGELOG.md#v11190-2024-12-02)
  * **Feature**: Adds support for WhatsApp Business messaging, IVR call recording, enabling Contact Lens for existing on-premise contact centers and telephony platforms, and enabling telephony and IVR migration to Amazon Connect independent of their contact center agents.
* `github.com/aws/aws-sdk-go-v2/service/connectcampaignsv2`: [v1.1.0](service/connectcampaignsv2/CHANGELOG.md#v110-2024-12-02)
  * **Feature**: Amazon Connect Outbound Campaigns V2 / Features : Adds support for Event-Triggered Campaigns.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.44.0](service/customerprofiles/CHANGELOG.md#v1440-2024-12-02)
  * **Feature**: This release introduces Event Trigger APIs as part of Amazon Connect Customer Profiles service.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.195.0](service/ec2/CHANGELOG.md#v11950-2024-12-02)
  * **Feature**: Adds support for declarative policies that allow you to enforce desired configuration across an AWS organization through configuring account attributes. Adds support for Allowed AMIs that allows you to limit the use of AMIs in AWS accounts. Adds support for connectivity over non-HTTP protocols.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.52.1](service/ecs/CHANGELOG.md#v1521-2024-12-02)
  * **Documentation**: This release adds support for Container Insights with Enhanced Observability for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.53.0](service/eks/CHANGELOG.md#v1530-2024-12-02)
  * **Feature**: Added support for Auto Mode Clusters, Hybrid Nodes, and specifying computeTypes in the DescribeAddonVersions API.
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.36.0](service/eventbridge/CHANGELOG.md#v1360-2024-12-02)
  * **Feature**: Call private APIs by configuring Connections with VPC connectivity through PrivateLink and VPC Lattice
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.51.0](service/fsx/CHANGELOG.md#v1510-2024-12-02)
  * **Feature**: FSx API changes to support the public launch of the Amazon FSx Intelligent Tiering for OpenZFS storage class.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.52.0](service/guardduty/CHANGELOG.md#v1520-2024-12-02)
  * **Feature**: Add new Multi Domain Correlation findings.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.39.0](service/imagebuilder/CHANGELOG.md#v1390-2024-12-02)
  * **Feature**: Added support for EC2 Image Builder's integration with AWS Marketplace for Marketplace components.
* `github.com/aws/aws-sdk-go-v2/service/invoicing`: [v1.0.0](service/invoicing/CHANGELOG.md#v100-2024-12-02)
  * **Release**: New AWS service client module
  * **Feature**: AWS Invoice Configuration allows you to receive separate AWS invoices based on your organizational needs. You can use the AWS SDKs to manage Invoice Units and programmatically fetch the information of the invoice receiver.
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.25.0](service/memorydb/CHANGELOG.md#v1250-2024-12-02)
  * **Feature**: Amazon MemoryDB SDK now supports all APIs for Multi-Region. Please refer to the updated Amazon MemoryDB public documentation for detailed information on API usage.
* `github.com/aws/aws-sdk-go-v2/service/networkflowmonitor`: [v1.0.0](service/networkflowmonitor/CHANGELOG.md#v100-2024-12-02)
  * **Release**: New AWS service client module
  * **Feature**: This release adds documentation for a new feature in Amazon CloudWatch called Network Flow Monitor. You can use Network Flow Monitor to get near real-time metrics, including retransmissions and data transferred, for your actual workloads.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.45.0](service/opensearch/CHANGELOG.md#v1450-2024-12-02)
  * **Feature**: This feature introduces support for CRUDL APIs, enabling the creation and management of Connected data sources.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.36.0](service/organizations/CHANGELOG.md#v1360-2024-12-02)
  * **Feature**: Add support for policy operations on the DECLARATIVE_POLICY_EC2 policy type.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.17.0](service/qbusiness/CHANGELOG.md#v1170-2024-12-02)
  * **Feature**: Amazon Q Business now supports capabilities to extract insights and answer questions from visual elements embedded within documents, a browser extension for Google Chrome, Mozilla Firefox, and Microsoft Edge, and attachments across conversations.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.14.0](service/qconnect/CHANGELOG.md#v1140-2024-12-02)
  * **Feature**: This release adds following capabilities: Configuring safeguards via AIGuardrails for Q in Connect inferencing, and APIs to support Q&A self-service use cases
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.92.0](service/rds/CHANGELOG.md#v1920-2024-12-02)
  * **Feature**: Amazon RDS supports CloudWatch Database Insights. You can use the SDK to create, modify, and describe the DatabaseInsightsMode for your DB instances and clusters.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.70.0](service/s3/CHANGELOG.md#v1700-2024-12-02)
  * **Feature**: Amazon S3 introduces support for AWS Dedicated Local Zones
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.51.0](service/s3control/CHANGELOG.md#v1510-2024-12-02)
  * **Feature**: Amazon S3 introduces support for AWS Dedicated Local Zones
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.55.0](service/securityhub/CHANGELOG.md#v1550-2024-12-02)
  * **Feature**: Add new Multi Domain Correlation findings.
* `github.com/aws/aws-sdk-go-v2/service/securityir`: [v1.0.0](service/securityir/CHANGELOG.md#v100-2024-12-02)
  * **Release**: New AWS service client module
  * **Feature**: AWS Security Incident Response is a purpose-built security incident solution designed to help customers prepare for, respond to, and recover from security incidents.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.54.0](service/transfer/CHANGELOG.md#v1540-2024-12-02)
  * **Feature**: AWS Transfer Family now offers Web apps that enables simple and secure access to data stored in Amazon S3.
* `github.com/aws/aws-sdk-go-v2/service/vpclattice`: [v1.13.0](service/vpclattice/CHANGELOG.md#v1130-2024-12-02)
  * **Feature**: Lattice APIs that allow sharing and access of VPC resources across accounts.

# Release (2024-11-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.29.0](service/bedrockagent/CHANGELOG.md#v1290-2024-11-27)
  * **Feature**: Add support for specifying embeddingDataType, either FLOAT32 or BINARY
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.51.0](service/configservice/CHANGELOG.md#v1510-2024-11-27)
  * **Feature**: AWS Config adds support for service-linked recorders, a new type of Config recorder managed by AWS services to record specific subsets of resource configuration data and functioning independently from customer managed AWS Config recorders.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.50.0](service/fsx/CHANGELOG.md#v1500-2024-11-27)
  * **Feature**: This release adds EFA support to increase FSx for Lustre file systems' throughput performance to a single client instance. This can be done by specifying EfaEnabled=true at the time of creation of Persistent_2 file systems.
* `github.com/aws/aws-sdk-go-v2/service/observabilityadmin`: [v1.0.0](service/observabilityadmin/CHANGELOG.md#v100-2024-11-27)
  * **Release**: New AWS service client module
  * **Feature**: Amazon CloudWatch Observability Admin adds the ability to audit telemetry configuration for AWS resources in customers AWS Accounts and Organizations. The release introduces new APIs to turn on/off the new experience, which supports discovering supported AWS resources and their state of telemetry.

# Release (2024-11-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.28.0](service/bedrockagent/CHANGELOG.md#v1280-2024-11-26)
  * **Feature**: Custom Orchestration API release for AWSBedrockAgents.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.27.0](service/bedrockagentruntime/CHANGELOG.md#v1270-2024-11-26)
  * **Feature**: Custom Orchestration and Streaming configurations API release for AWSBedrockAgents.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.118.0](service/connect/CHANGELOG.md#v11180-2024-11-26)
  * **Feature**: Enables access to ValueMap and ValueInteger types for SegmentAttributes and fixes deserialization bug for DescribeContactFlow in AmazonConnect Public API
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.194.0](service/ec2/CHANGELOG.md#v11940-2024-11-26)
  * **Feature**: Adds support for Time-based Copy for EBS Snapshots and Cross Region PrivateLink. Time-based Copy ensures that EBS Snapshots are copied within and across AWS Regions in a specified timeframe. Cross Region PrivateLink enables customers to connect to VPC endpoint services hosted in other AWS Regions.
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.5.0](service/qapps/CHANGELOG.md#v150-2024-11-26)
  * **Feature**: Private sharing, file upload and data collection feature support for Q Apps

# Release (2024-11-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.30.0](service/directconnect/CHANGELOG.md#v1300-2024-11-25)
  * **Feature**: Update DescribeDirectConnectGatewayAssociations API to return associated core network information if a Direct Connect gateway is attached to a Cloud WAN core network.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.32.0](service/networkmanager/CHANGELOG.md#v1320-2024-11-25)
  * **Feature**: This release adds native Direct Connect integration on Cloud WAN enabling customers to directly attach their Direct Connect gateways to Cloud WAN without the need for an intermediate Transit Gateway.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.69.0](service/s3/CHANGELOG.md#v1690-2024-11-25)
  * **Feature**: Amazon Simple Storage Service / Features: Add support for ETag based conditional writes in PutObject and CompleteMultiPartUpload APIs to prevent unintended object modifications.

# Release (2024-11-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.51.0](service/autoscaling/CHANGELOG.md#v1510-2024-11-22)
  * **Feature**: Now, Amazon EC2 Auto Scaling customers can enable target tracking policies to take quicker scaling decisions, enhancing their application performance and EC2 utilization. To get started, specify target tracking to monitor a metric that is available on Amazon CloudWatch at seconds-level interval.
* `github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator`: [v1.0.0](service/bcmpricingcalculator/CHANGELOG.md#v100-2024-11-22)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of the AWS Billing and Cost Management Pricing Calculator API.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.26.0](service/bedrockagentruntime/CHANGELOG.md#v1260-2024-11-22)
  * **Feature**: InvokeInlineAgent API release to help invoke runtime agents without any dependency on preconfigured agents.
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.9.0](service/chatbot/CHANGELOG.md#v190-2024-11-22)
  * **Feature**: Adds support for programmatic management of custom actions and aliases which can be associated with channel configurations.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.37.0](service/codepipeline/CHANGELOG.md#v1370-2024-11-22)
  * **Feature**: AWS CodePipeline V2 type pipelines now support ECRBuildAndPublish and InspectorScan actions.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.47.0](service/cognitoidentityprovider/CHANGELOG.md#v1470-2024-11-22)
  * **Feature**: Add support for users to sign up and sign in without passwords, using email and SMS OTPs and Passkeys. Add support for Passkeys based on WebAuthn. Add support for enhanced branding customization for hosted authentication pages with Amazon Cognito Managed Login. Add feature tiers with new pricing.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.117.0](service/connect/CHANGELOG.md#v11170-2024-11-22)
  * **Feature**: Amazon Connect Service Feature: Add APIs for Amazon Connect Email Channel
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.45.0](service/costexplorer/CHANGELOG.md#v1450-2024-11-22)
  * **Feature**: This release adds the Impact field(contains Contribution field) to the GetAnomalies API response under RootCause
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.43.0](service/elasticloadbalancingv2/CHANGELOG.md#v1430-2024-11-22)
  * **Feature**: This release adds support for advertising trusted CA certificate names in associated trust stores.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.47.0](service/emr/CHANGELOG.md#v1470-2024-11-22)
  * **Feature**: Advanced Scaling in Amazon EMR Managed Scaling
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.34.0](service/inspector2/CHANGELOG.md#v1340-2024-11-22)
  * **Feature**: Extend inspector2 service model to include ServiceQuotaExceededException.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.69.0](service/lambda/CHANGELOG.md#v1690-2024-11-22)
  * **Feature**: Add ProvisionedPollerConfig to Lambda event-source-mapping API.
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.7.0](service/mailmanager/CHANGELOG.md#v170-2024-11-22)
  * **Feature**: Added new "DeliverToQBusiness" rule action to MailManager RulesSet for ingesting email data into Amazon Q Business customer applications
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.15.0](service/neptunegraph/CHANGELOG.md#v1150-2024-11-22)
  * **Feature**: Add 4 new APIs to support new Export features, allowing Parquet and CSV formats. Add new arguments in Import APIs to support Parquet import. Add a new query "neptune.read" to run algorithms without loading data into database
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.28.0](service/omics/CHANGELOG.md#v1280-2024-11-22)
  * **Feature**: This release adds support for resource policy based cross account S3 access to sequence store read sets.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.80.0](service/quicksight/CHANGELOG.md#v1800-2024-11-22)
  * **Feature**: This release includes: Update APIs to support Image, Layer Map, font customization, and Plugin Visual. Add Identity center related information in ListNamsespace API. Update API for restrictedFolder support in topics and add API for SearchTopics, Describe/Update DashboardsQA Configration.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.168.0](service/sagemaker/CHANGELOG.md#v11680-2024-11-22)
  * **Feature**: This release adds APIs for new features for SageMaker endpoint to scale down to zero instances, native support for multi-adapter inference, and endpoint scaling improvements.
* `github.com/aws/aws-sdk-go-v2/service/ses`: [v1.29.0](service/ses/CHANGELOG.md#v1290-2024-11-22)
  * **Feature**: This release adds support for starting email contacts in your Amazon Connect instance as an email receiving action.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.34.0](service/sfn/CHANGELOG.md#v1340-2024-11-22)
  * **Feature**: Add support for variables and JSONata in TestState, GetExecutionHistory, DescribeStateMachine, and DescribeStateMachineForExecution
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.33.6](service/sns/CHANGELOG.md#v1336-2024-11-22)
  * **Documentation**: ArchivePolicy attribute added to Archive and Replay feature
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.50.1](service/workspaces/CHANGELOG.md#v1501-2024-11-22)
  * **Documentation**: While integrating WSP-DCV rebrand, a few mentions were erroneously renamed from WSP to DCV. This release reverts those mentions back to WSP.

# Release (2024-11-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.28.0](service/apigateway/CHANGELOG.md#v1280-2024-11-21)
  * **Feature**: Added support for custom domain names for private APIs.
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.34.0](service/applicationautoscaling/CHANGELOG.md#v1340-2024-11-21)
  * **Feature**: Application Auto Scaling now supports Predictive Scaling to proactively increase the desired capacity ahead of predicted demand, ensuring improved availability and responsiveness for customers' applications. This feature is currently only made available for Amazon ECS Service scalable targets.
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.40.0](service/appsync/CHANGELOG.md#v1400-2024-11-21)
  * **Feature**: Add support for the Amazon Bedrock Runtime.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.43.0](service/cloudfront/CHANGELOG.md#v1430-2024-11-21)
  * **Feature**: Adds support for Origin Selection between EMPv2 origins based on media quality score.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.46.0](service/cloudtrail/CHANGELOG.md#v1460-2024-11-21)
  * **Feature**: This release introduces new APIs for creating and managing CloudTrail Lake dashboards. It also adds support for resource-based policies on CloudTrail EventDataStore and Dashboard resource.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.44.0](service/cloudwatchlogs/CHANGELOG.md#v1440-2024-11-21)
  * **Feature**: Adds "Create field indexes to improve query performance and reduce scan volume" and "Transform logs during ingestion". Updates documentation for "PutLogEvents with Entity".
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.44.0](service/costexplorer/CHANGELOG.md#v1440-2024-11-21)
  * **Feature**: This release introduces three new APIs that enable you to estimate the cost, coverage, and utilization impact of Savings Plans you plan to purchase. The three APIs are StartCommitmentPurchaseAnalysis, GetCommitmentPurchaseAnalysis, and ListCommitmentPurchaseAnalyses.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.193.0](service/ec2/CHANGELOG.md#v11930-2024-11-21)
  * **Feature**: Adds support for requesting future-dated Capacity Reservations with a minimum commitment duration, enabling IPAM for organizational units within AWS Organizations, reserving EC2 Capacity Blocks that start in 30 minutes, and extending the end date of existing Capacity Blocks.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.44.0](service/elasticache/CHANGELOG.md#v1440-2024-11-21)
  * **Feature**: Added support to modify the engine type for existing ElastiCache Users and User Groups. Customers can now modify the engine type from redis to valkey.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.42.1](service/elasticloadbalancingv2/CHANGELOG.md#v1421-2024-11-21)
  * **Documentation**: This feature adds support for enabling zonal shift on cross-zone enabled Application Load Balancer, as well as modifying HTTP request and response headers.
* `github.com/aws/aws-sdk-go-v2/service/health`: [v1.29.0](service/health/CHANGELOG.md#v1290-2024-11-21)
  * **Feature**: Adds metadata property to an AffectedEntity.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.61.0](service/iot/CHANGELOG.md#v1610-2024-11-21)
  * **Feature**: General Availability (GA) release of AWS IoT Device Management - Commands, to trigger light-weight remote actions on targeted devices
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.22.0](service/iotfleetwise/CHANGELOG.md#v1220-2024-11-21)
  * **Feature**: AWS IoT FleetWise now includes campaign parameters to store and forward data, configure MQTT topic as a data destination, and collect diagnostic trouble code data. It includes APIs for network agnostic data collection using custom decoding interfaces, and monitoring the last known state of vehicles.
* `github.com/aws/aws-sdk-go-v2/service/iotjobsdataplane`: [v1.24.0](service/iotjobsdataplane/CHANGELOG.md#v1240-2024-11-21)
  * **Feature**: General Availability (GA) release of AWS IoT Device Management - Commands, to trigger light-weight remote actions on targeted devices
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.68.0](service/lambda/CHANGELOG.md#v1680-2024-11-21)
  * **Feature**: Adds support for metrics for event source mappings for AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/notifications`: [v1.0.0](service/notifications/CHANGELOG.md#v100-2024-11-21)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for AWS User Notifications. You can now configure and view notifications from AWS services in a central location using the AWS SDK.
* `github.com/aws/aws-sdk-go-v2/service/notificationscontacts`: [v1.0.0](service/notificationscontacts/CHANGELOG.md#v100-2024-11-21)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for AWS User Notifications Contacts. You can now configure and view email contacts for AWS User Notifications using the AWS SDK.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.28.0](service/resiliencehub/CHANGELOG.md#v1280-2024-11-21)
  * **Feature**: AWS Resilience Hub's new summary view visually represents applications' resilience through charts, enabling efficient resilience management. It provides a consolidated view of the app portfolio's resilience state and allows data export for custom stakeholder reporting.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.68.0](service/s3/CHANGELOG.md#v1680-2024-11-21)
  * **Feature**: Add support for conditional deletes for the S3 DeleteObject and DeleteObjects APIs. Add support for write offset bytes option used to append to objects with the S3 PutObject API.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.56.0](service/ssm/CHANGELOG.md#v1560-2024-11-21)
  * **Feature**: Added support for providing high-level overviews of managed nodes and previewing the potential impact of a runbook execution.
* `github.com/aws/aws-sdk-go-v2/service/ssmquicksetup`: [v1.3.0](service/ssmquicksetup/CHANGELOG.md#v130-2024-11-21)
  * **Feature**: Add methods that retrieve details about deployed configurations: ListConfigurations, GetConfiguration
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.30.0](service/xray/CHANGELOG.md#v1300-2024-11-21)
  * **Feature**: AWS X-Ray introduces Transaction Search APIs, enabling span ingestion into CloudWatch Logs for high-scale trace data indexing. These APIs support span-level queries, trace graph generation, and metric correlation for deeper application insights.

# Release (2024-11-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.29.0](service/applicationdiscoveryservice/CHANGELOG.md#v1290-2024-11-20)
  * **Feature**: Add support to import data from commercially available discovery tools without file manipulation.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.50.0](service/autoscaling/CHANGELOG.md#v1500-2024-11-20)
  * **Feature**: With this release, customers can prioritize launching instances into ODCRs using targets from ASGs or Launch Templates. Customers can express their baseline instances' CPU-performance in attribute-based Instance Requirements configuration by referencing an instance family that meets their needs.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.25.0](service/bedrockagentruntime/CHANGELOG.md#v1250-2024-11-20)
  * **Feature**: Releasing new Prompt Optimization to enhance your prompts for improved performance
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.42.0](service/cloudfront/CHANGELOG.md#v1420-2024-11-20)
  * **Feature**: Add support for gRPC, VPC origins, and Anycast IP Lists. Allow LoggingConfig IncludeCookies to be set regardless of whether the LoggingConfig is enabled.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.40.0](service/computeoptimizer/CHANGELOG.md#v1400-2024-11-20)
  * **Feature**: This release enables AWS Compute Optimizer to analyze and generate optimization recommendations for Amazon Aurora database instances. It also enables Compute Optimizer to identify idle Amazon EC2 instances, Amazon EBS volumes, Amazon ECS services running on Fargate, and Amazon RDS databases.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.20.0](service/controltower/CHANGELOG.md#v1200-2024-11-20)
  * **Feature**: Adds support for child enabled baselines which allow you to see the enabled baseline status for individual accounts.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.11.0](service/costoptimizationhub/CHANGELOG.md#v1110-2024-11-20)
  * **Feature**: This release adds action type "Delete" to the GetRecommendation, ListRecommendations and ListRecommendationSummaries APIs to support new EBS and ECS recommendations with action type "Delete".
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.24.0](service/datazone/CHANGELOG.md#v1240-2024-11-20)
  * **Feature**: This release supports Metadata Enforcement Rule feature for Create Subscription Request action.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.192.0](service/ec2/CHANGELOG.md#v11920-2024-11-20)
  * **Feature**: With this release, customers can express their desire to launch instances only in an ODCR or ODCR group rather than OnDemand capacity. Customers can express their baseline instances' CPU-performance in attribute-based Instance Requirements configuration by referencing an instance family.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.52.0](service/ecs/CHANGELOG.md#v1520-2024-11-20)
  * **Feature**: This release adds support for the Availability Zone rebalancing feature on Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.42.0](service/elasticloadbalancingv2/CHANGELOG.md#v1420-2024-11-20)
  * **Feature**: This release adds support for configuring Load balancer Capacity Unit reservations
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.67.0](service/lambda/CHANGELOG.md#v1670-2024-11-20)
  * **Feature**: Add Node 22.x (node22.x) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.63.0](service/mediaconvert/CHANGELOG.md#v1630-2024-11-20)
  * **Feature**: This release adds the ability to reconfigure concurrent job settings for existing queues and create queues with custom concurrent job settings.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.20.0](service/mediapackagev2/CHANGELOG.md#v1200-2024-11-20)
  * **Feature**: MediaPackage v2 now supports the Media Quality Confidence Score (MQCS) published from MediaLive. Customers can control input switching based on the MQCS and publishing HTTP Headers for the MQCS via the API.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.27.0](service/omics/CHANGELOG.md#v1270-2024-11-20)
  * **Feature**: Enabling call caching feature that allows customers to reuse previously computed results from a set of completed tasks in a new workflow run.
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.21.0](service/rbin/CHANGELOG.md#v1210-2024-11-20)
  * **Feature**: This release adds support for exclusion tags for Recycle Bin, which allows you to identify resources that are to be excluded, or ignored, by a Region-level retention rule.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.91.0](service/rds/CHANGELOG.md#v1910-2024-11-20)
  * **Feature**: This release adds support for scale storage on the DB instance using a Blue/Green Deployment.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.29.0](service/timestreamquery/CHANGELOG.md#v1290-2024-11-20)
  * **Feature**: This release adds support for Provisioning Timestream Compute Units (TCUs), a new feature that allows provisioning dedicated compute resources for your queries, providing predictable and cost-effective query performance.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.50.0](service/workspaces/CHANGELOG.md#v1500-2024-11-20)
  * **Feature**: Added support for Rocky Linux 8 on Amazon WorkSpaces Personal.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.25.0](service/workspacesweb/CHANGELOG.md#v1250-2024-11-20)
  * **Feature**: Added data protection settings with support for inline data redaction.

# Release (2024-11-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.54](service/b2bi/CHANGELOG.md#v100-preview54-2024-11-19)
  * **Feature**: Add new X12 transactions sets and versions
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.191.0](service/ec2/CHANGELOG.md#v11910-2024-11-19)
  * **Feature**: This release adds VPC Block Public Access (VPC BPA), a new declarative control which blocks resources in VPCs and subnets that you own in a Region from reaching or being reached from the internet through internet gateways and egress-only internet gateways.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.51.0](service/ecs/CHANGELOG.md#v1510-2024-11-19)
  * **Feature**: This release introduces support for configuring the version consistency feature for individual containers defined within a task definition. The configuration allows to specify whether ECS should resolve the container image tag specified in the container definition to an image digest.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.34.0](service/efs/CHANGELOG.md#v1340-2024-11-19)
  * **Feature**: Add support for the new parameters in EFS replication APIs
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.102.0](service/glue/CHANGELOG.md#v11020-2024-11-19)
  * **Feature**: AWS Glue Data Catalog now enhances managed table optimizations of Apache Iceberg tables that can be accessed only from a specific Amazon Virtual Private Cloud (VPC) environment.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.16.0](service/keyspaces/CHANGELOG.md#v1160-2024-11-19)
  * **Feature**: Amazon Keyspaces Multi-Region Replication: Adds support to add new regions to multi and single-region keyspaces.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.33.0](service/mwaa/CHANGELOG.md#v1330-2024-11-19)
  * **Feature**: Amazon MWAA now supports a new environment class, mw1.micro, ideal for workloads requiring fewer resources than mw1.small. This class supports a single instance of each Airflow component: Scheduler, Worker, and Webserver.
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.7.0](service/taxsettings/CHANGELOG.md#v170-2024-11-19)
  * **Feature**: Release Tax Inheritance APIs,  Tax Exemption APIs, and functionality update for some existing Tax Registration APIs
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.49.0](service/workspaces/CHANGELOG.md#v1490-2024-11-19)
  * **Feature**: Releasing new ErrorCodes for Image Validation failure during CreateWorkspaceImage process

# Release (2024-11-18)

## General Highlights
* **Dependency Update**: Update to smithy-go v1.22.1.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.36.0](service/appconfig/CHANGELOG.md#v1360-2024-11-18)
  * **Feature**: AWS AppConfig has added a new extension action point, AT_DEPLOYMENT_TICK, to support third-party monitors to trigger an automatic rollback during a deployment.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.49.0](service/autoscaling/CHANGELOG.md#v1490-2024-11-18)
  * **Feature**: Amazon EC2 Auto Scaling now supports Amazon Application Recovery Controller (ARC) zonal shift and zonal autoshift to help you quickly recover an impaired application from failures in an Availability Zone (AZ).
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.56.0](service/cloudformation/CHANGELOG.md#v1560-2024-11-18)
  * **Feature**: This release adds a new API, ListHookResults, that allows retrieving CloudFormation Hooks invocation results for hooks invoked during a create change set operation or Cloud Control API operation
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.116.0](service/connect/CHANGELOG.md#v11160-2024-11-18)
  * **Feature**: Adds CreateContactFlowVersion and ListContactFlowVersions APIs to create and view the versions of a contact flow.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.43.0](service/customerprofiles/CHANGELOG.md#v1430-2024-11-18)
  * **Feature**: This release introduces Segmentation APIs and new Calculated Attribute Event Filters as part of Amazon Connect Customer Profiles service.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.190.0](service/ec2/CHANGELOG.md#v11900-2024-11-18)
  * **Feature**: Adding request and response elements for managed resources.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.50.0](service/ecs/CHANGELOG.md#v1500-2024-11-18)
  * **Feature**: This release adds support for adding VPC Lattice configurations in ECS CreateService/UpdateService APIs. The configuration allows for associating VPC Lattice target groups with ECS Services.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.44.0](service/iotsitewise/CHANGELOG.md#v1440-2024-11-18)
  * **Feature**: The release introduces a generative AI Assistant in AWS IoT SiteWise. It includes: 1) InvokeAssistant API - Invoke the Assistant to get alarm summaries and ask questions. 2) Dataset APIs - Manage knowledge base configuration for the Assistant. 3) Portal APIs enhancement - Manage AI-aware dashboards.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.13.0](service/qconnect/CHANGELOG.md#v1130-2024-11-18)
  * **Feature**: This release introduces MessageTemplate as a resource in Amazon Q in Connect, along with APIs to create, read, search, update, and delete MessageTemplate resources.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.90.0](service/rds/CHANGELOG.md#v1900-2024-11-18)
  * **Feature**: Add support for the automatic pause/resume feature of Aurora Serverless v2.
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.26.0](service/rdsdata/CHANGELOG.md#v1260-2024-11-18)
  * **Feature**: Add support for the automatic pause/resume feature of Aurora Serverless v2.

# Release (2024-11-15.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.43.0](service/cloudwatch/CHANGELOG.md#v1430-2024-11-152)
  * **Feature**: Adds support for adding related Entity information to metrics ingested through PutMetricData.
* `github.com/aws/aws-sdk-go-v2/service/connectcampaignsv2`: [v1.0.0](service/connectcampaignsv2/CHANGELOG.md#v100-2024-11-152)
  * **Release**: New AWS service client module
  * **Feature**: Added Amazon Connect Outbound Campaigns V2 SDK.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.43.3](service/datasync/CHANGELOG.md#v1433-2024-11-152)
  * **Documentation**: Doc-only updates and enhancements related to creating DataSync tasks and describing task executions.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.189.0](service/ec2/CHANGELOG.md#v11890-2024-11-152)
  * **Feature**: Remove non-functional enum variants for FleetCapacityReservationUsageStrategy
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.60.0](service/iot/CHANGELOG.md#v1600-2024-11-152)
  * **Feature**: This release allows AWS IoT Core users to enrich MQTT messages with propagating attributes, to associate a thing to a connection, and to enable Online Certificate Status Protocol (OCSP) stapling for TLS X.509 server certificates through private endpoints.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.47.0](service/outposts/CHANGELOG.md#v1470-2024-11-152)
  * **Feature**: You can now purchase AWS Outposts rack or server capacity for a 5-year term with one of  the following payment options: All Upfront, Partial Upfront, and No Upfront.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.18.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1180-2024-11-152)
  * **Feature**: Use rule overrides to always allow or always block messages to specific phone numbers. Use message feedback to monitor if a customer interacts with your message.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.34.0](service/route53resolver/CHANGELOG.md#v1340-2024-11-152)
  * **Feature**: Route 53 Resolver DNS Firewall Advanced Rules allows you to monitor and block suspicious DNS traffic based on anomalies detected in the queries, such as DNS tunneling and Domain Generation Algorithms (DGAs).

# Release (2024-11-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/partnercentralselling`: [v1.1.0](service/partnercentralselling/CHANGELOG.md#v110-2024-11-15)
  * **Feature**: Announcing AWS Partner Central API for Selling: This service launch Introduces new APIs for co-selling opportunity management and related functions. Key features include notifications, a dynamic sandbox for testing, and streamlined validations.

# Release (2024-11-14)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.36.0](service/accessanalyzer/CHANGELOG.md#v1360-2024-11-14)
  * **Feature**: Expand analyzer configuration capabilities for unused access analyzers. Unused access analyzer configurations now support the ability to exclude accounts and resource tags from analysis providing more granular control over the scope of analysis.
* `github.com/aws/aws-sdk-go-v2/service/cloudcontrol`: [v1.23.0](service/cloudcontrol/CHANGELOG.md#v1230-2024-11-14)
  * **Feature**: Added support for CloudFormation Hooks with Cloud Control API. The GetResourceRequestStatus API response now includes an optional HooksProgressEvent and HooksRequestToken parameter for Hooks Invocation Progress as part of resource operation with Cloud Control.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.7.0](service/deadline/CHANGELOG.md#v170-2024-11-14)
  * **Feature**: Adds support for select GPU accelerated instance types when creating new service-managed fleets.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.38.0](service/iam/CHANGELOG.md#v1380-2024-11-14)
  * **Feature**: This release includes support for five new APIs and changes to existing APIs that give AWS Organizations customers the ability to use temporary root credentials, targeted to member accounts in the organization.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.45.0](service/iotwireless/CHANGELOG.md#v1450-2024-11-14)
  * **Feature**: New FuotaTask resource type to enable logging for your FUOTA tasks. A ParticipatingGatewaysforMulticast parameter to choose the list of gateways to receive the multicast downlink message and the transmission interval between them. Descriptor field which will be sent to devices during FUOTA transfer.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.42.0](service/ivs/CHANGELOG.md#v1420-2024-11-14)
  * **Feature**: IVS now offers customers the ability to stream multitrack video to Channels.
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.14.0](service/licensemanagerusersubscriptions/CHANGELOG.md#v1140-2024-11-14)
  * **Feature**: New and updated API operations to support License Included User-based Subscription of Microsoft Remote Desktop Services (RDS).
* `github.com/aws/aws-sdk-go-v2/service/partnercentralselling`: [v1.0.0](service/partnercentralselling/CHANGELOG.md#v100-2024-11-14)
  * **Release**: New AWS service client module
  * **Feature**: Announcing AWS Partner Central API for Selling: This service launch Introduces new APIs for co-selling opportunity management and related functions. Key features include notifications, a dynamic sandbox for testing, and streamlined validations.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.79.0](service/quicksight/CHANGELOG.md#v1790-2024-11-14)
  * **Feature**: This release adds APIs for Custom Permissions management in QuickSight, and APIs to support QuickSight Branding.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.52.0](service/redshift/CHANGELOG.md#v1520-2024-11-14)
  * **Feature**: Adds support for Amazon Redshift S3AccessGrants
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.67.0](service/s3/CHANGELOG.md#v1670-2024-11-14)
  * **Feature**: This release updates the ListBuckets API Reference documentation in support of the new 10,000 general purpose bucket default quota on all AWS accounts. To increase your bucket quota from 10,000 to up to 1 million buckets, simply request a quota increase via Service Quotas.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.167.0](service/sagemaker/CHANGELOG.md#v11670-2024-11-14)
  * **Feature**: Add support for Neuron instance types [ trn1/trn1n/inf2 ] on SageMaker Notebook Instances Platform.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.33.0](service/sts/CHANGELOG.md#v1330-2024-11-14)
  * **Feature**: This release introduces the new API 'AssumeRoot', which returns short-term credentials that you can use to perform privileged tasks.

# Release (2024-11-13)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.35.0](service/accessanalyzer/CHANGELOG.md#v1350-2024-11-13)
  * **Feature**: This release adds support for policy validation and external access findings for resource control policies (RCP). IAM Access Analyzer helps you author functional and secure RCPs and awareness that a RCP may restrict external access. Updated service API, documentation, and paginators.
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.7.0](service/applicationsignals/CHANGELOG.md#v170-2024-11-13)
  * **Feature**: Amazon CloudWatch Application Signals now supports creating Service Level Objectives with burn rates. Users can now create or update SLOs with burn rate configurations to meet their specific business requirements.
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.52](service/b2bi/CHANGELOG.md#v100-preview52-2024-11-13)
  * **Feature**: This release adds a GenerateMapping API to allow generation of JSONata or XSLT transformer code based on input and output samples.
* `github.com/aws/aws-sdk-go-v2/service/billing`: [v1.0.0](service/billing/CHANGELOG.md#v100-2024-11-13)
  * **Release**: New AWS service client module
  * **Feature**: Today, AWS announces the general availability of ListBillingViews API in the AWS SDKs, to enable AWS Billing Conductor (ABC) users to create proforma Cost and Usage Reports (CUR) programmatically.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.45.0](service/cloudtrail/CHANGELOG.md#v1450-2024-11-13)
  * **Feature**: This release adds a new API GenerateQuery that generates a query from a natural language prompt about the event data in your event data store. This operation uses generative artificial intelligence (generative AI) to produce a ready-to-use SQL query from the prompt.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.37.0](service/dynamodb/CHANGELOG.md#v1370-2024-11-13)
  * **Feature**: This release includes supports the new WarmThroughput feature for DynamoDB. You can now provide an optional WarmThroughput attribute for CreateTable or UpdateTable APIs to pre-warm your table or global secondary index. You can also use DescribeTable to see the latest WarmThroughput value.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.188.0](service/ec2/CHANGELOG.md#v11880-2024-11-13)
  * **Feature**: This release adds the source AMI details in DescribeImages API
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.20.0](service/internetmonitor/CHANGELOG.md#v1200-2024-11-13)
  * **Feature**: Add new query type Routing_Suggestions regarding querying interface
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.62.0](service/mediaconvert/CHANGELOG.md#v1620-2024-11-13)
  * **Feature**: This release adds support for ARN inputs in the Kantar credentials secrets name field and the MSPR field to the manifests for PlayReady DRM protected outputs.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.35.0](service/organizations/CHANGELOG.md#v1350-2024-11-13)
  * **Feature**: Add support for policy operations on the Resource Control Polices.

# Release (2024-11-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.49.0](service/codebuild/CHANGELOG.md#v1490-2024-11-12)
  * **Feature**: AWS CodeBuild now supports non-containerized Linux and Windows builds on Reserved Capacity.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.19.0](service/controltower/CHANGELOG.md#v1190-2024-11-12)
  * **Feature**: Added ResetEnabledControl API.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.31.0](service/fis/CHANGELOG.md#v1310-2024-11-12)
  * **Feature**: This release adds support for generating experiment reports with the experiment report configuration
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.37.0](service/gamelift/CHANGELOG.md#v1370-2024-11-12)
  * **Feature**: Amazon GameLift releases container fleets support for general availability. Deploy Linux-based containerized game server software for hosting on Amazon GameLift.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.16.0](service/paymentcryptography/CHANGELOG.md#v1160-2024-11-12)
  * **Feature**: Updated ListAliases API with KeyArn filter.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.89.2](service/rds/CHANGELOG.md#v1892-2024-11-12)
  * **Documentation**: Updates Amazon RDS documentation for Amazon RDS Extended Support for Amazon Aurora MySQL.

# Release (2024-11-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.41.0](service/cloudfront/CHANGELOG.md#v1410-2024-11-11)
  * **Feature**: No API changes from previous release. This release migrated the model to Smithy keeping all features unchanged.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.33.0](service/inspector2/CHANGELOG.md#v1330-2024-11-11)
  * **Feature**: Adds support for filePath filter.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.66.0](service/lambda/CHANGELOG.md#v1660-2024-11-11)
  * **Feature**: Add Python 3.13 (python3.13) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.44.0](service/opensearch/CHANGELOG.md#v1440-2024-11-11)
  * **Feature**: Adds Support for new AssociatePackages and DissociatePackages API in Amazon OpenSearch Service that allows association and dissociation operations to be carried out on multiple packages at the same time.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.46.0](service/outposts/CHANGELOG.md#v1460-2024-11-11)
  * **Feature**: This release updates StartCapacityTask to allow an active Outpost to be modified. It also adds a new API to list all running EC2 instances on the Outpost.

# Release (2024-11-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.48.0](service/batch/CHANGELOG.md#v1480-2024-11-08)
  * **Feature**: This feature allows override LaunchTemplates to be specified in an AWS Batch Compute Environment.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.24.0](service/bedrockagentruntime/CHANGELOG.md#v1240-2024-11-08)
  * **Feature**: This release adds trace functionality to Bedrock Prompt Flows
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.21.0](service/chimesdkmediapipelines/CHANGELOG.md#v1210-2024-11-08)
  * **Feature**: Added support for Media Capture Pipeline and Media Concatenation Pipeline for customer managed server side encryption. Now Media Capture Pipeline can use IAM sink role to get access to KMS key and encrypt/decrypt recorded artifacts. KMS key ID can also be supplied with encryption context.
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.6.0](service/controlcatalog/CHANGELOG.md#v160-2024-11-08)
  * **Feature**: AWS Control Catalog GetControl public API returns additional data in output, including Implementation and Parameters
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.52.0](service/eks/CHANGELOG.md#v1520-2024-11-08)
  * **Feature**: Adds new error code `Ec2InstanceTypeDoesNotExist` for Amazon EKS managed node groups
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.35.0](service/firehose/CHANGELOG.md#v1350-2024-11-08)
  * **Feature**: Amazon Data Firehose / Features : Adds support for a new DeliveryStreamType, DatabaseAsSource. DatabaseAsSource hoses allow customers to stream CDC events from their RDS and Amazon EC2 hosted databases, running MySQL and PostgreSQL database engines, to Iceberg Table destinations.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.65.0](service/lambda/CHANGELOG.md#v1650-2024-11-08)
  * **Feature**: This release adds support for using AWS KMS customer managed keys to encrypt AWS Lambda .zip deployment packages.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.17.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1170-2024-11-08)
  * **Feature**: Added the RequiresAuthenticationTimestamp field to the RegistrationVersionStatusHistory data type.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.16.0](service/qbusiness/CHANGELOG.md#v1160-2024-11-08)
  * **Feature**: Adds S3 path option to pass group member list for PutGroup API.

# Release (2024-11-07)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.34.5](service/accessanalyzer/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.21.5](service/account/CHANGELOG.md#v1215-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.30.5](service/acm/CHANGELOG.md#v1305-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.37.6](service/acmpca/CHANGELOG.md#v1376-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.30.2](service/amp/CHANGELOG.md#v1302-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.27.3](service/amplify/CHANGELOG.md#v1273-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/amplifybackend`: [v1.27.5](service/amplifybackend/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.23.5](service/amplifyuibuilder/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.27.5](service/apigateway/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/apigatewaymanagementapi`: [v1.23.5](service/apigatewaymanagementapi/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/apigatewayv2`: [v1.24.5](service/apigatewayv2/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.35.3](service/appconfig/CHANGELOG.md#v1353-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/appconfigdata`: [v1.18.5](service/appconfigdata/CHANGELOG.md#v1185-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/appfabric`: [v1.11.5](service/appfabric/CHANGELOG.md#v1115-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.45.6](service/appflow/CHANGELOG.md#v1456-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.30.5](service/appintegrations/CHANGELOG.md#v1305-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.33.5](service/applicationautoscaling/CHANGELOG.md#v1335-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/applicationcostprofiler`: [v1.21.5](service/applicationcostprofiler/CHANGELOG.md#v1215-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.28.5](service/applicationdiscoveryservice/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/applicationinsights`: [v1.29.3](service/applicationinsights/CHANGELOG.md#v1293-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.6.5](service/applicationsignals/CHANGELOG.md#v165-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/appmesh`: [v1.29.5](service/appmesh/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.32.5](service/apprunner/CHANGELOG.md#v1325-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.41.5](service/appstream/CHANGELOG.md#v1415-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.39.2](service/appsync/CHANGELOG.md#v1392-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/apptest`: [v1.4.5](service/apptest/CHANGELOG.md#v145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.14.5](service/arczonalshift/CHANGELOG.md#v1145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/artifact`: [v1.6.5](service/artifact/CHANGELOG.md#v165-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.48.3](service/athena/CHANGELOG.md#v1483-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.37.5](service/auditmanager/CHANGELOG.md#v1375-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.48.0](service/autoscaling/CHANGELOG.md#v1480-2024-11-07)
  * **Feature**: Auto Scaling groups now support the ability to strictly balance instances across Availability Zones by configuring the AvailabilityZoneDistribution parameter. If balanced-only is configured for a group, launches will always be attempted in the under scaled Availability Zone even if it is unhealthy.
* `github.com/aws/aws-sdk-go-v2/service/autoscalingplans`: [v1.24.5](service/autoscalingplans/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.51](service/b2bi/CHANGELOG.md#v100-preview51-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.39.6](service/backup/CHANGELOG.md#v1396-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/backupgateway`: [v1.20.5](service/backupgateway/CHANGELOG.md#v1205-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.47.2](service/batch/CHANGELOG.md#v1472-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/bcmdataexports`: [v1.7.5](service/bcmdataexports/CHANGELOG.md#v175-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.22.2](service/bedrock/CHANGELOG.md#v1222-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.27.0](service/bedrockagent/CHANGELOG.md#v1270-2024-11-07)
  * **Feature**: Add prompt support for chat template configuration and agent generative AI resource. Add support for configuring an optional guardrail in Prompt and Knowledge Base nodes in Prompt Flows. Add API to validate flow definition
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.23.3](service/bedrockagentruntime/CHANGELOG.md#v1233-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.20.0](service/bedrockruntime/CHANGELOG.md#v1200-2024-11-07)
  * **Feature**: Add Prompt management support to Bedrock runtime APIs: Converse, ConverseStream, InvokeModel, InvokeModelWithStreamingResponse
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.20.5](service/billingconductor/CHANGELOG.md#v1205-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.31.5](service/braket/CHANGELOG.md#v1315-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.28.5](service/budgets/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.8.5](service/chatbot/CHANGELOG.md#v185-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/chime`: [v1.34.5](service/chime/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/chimesdkidentity`: [v1.22.5](service/chimesdkidentity/CHANGELOG.md#v1225-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.20.5](service/chimesdkmediapipelines/CHANGELOG.md#v1205-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmeetings`: [v1.27.5](service/chimesdkmeetings/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging`: [v1.26.5](service/chimesdkmessaging/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.19.5](service/chimesdkvoice/CHANGELOG.md#v1195-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.20.0](service/cleanrooms/CHANGELOG.md#v1200-2024-11-07)
  * **Feature**: This release introduces support for Custom Models in AWS Clean Rooms ML.
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.10.0](service/cleanroomsml/CHANGELOG.md#v1100-2024-11-07)
  * **Feature**: This release introduces support for Custom Models in AWS Clean Rooms ML.
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.28.5](service/cloud9/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloudcontrol`: [v1.22.5](service/cloudcontrol/CHANGELOG.md#v1225-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/clouddirectory`: [v1.24.5](service/clouddirectory/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloudfrontkeyvaluestore`: [v1.8.5](service/cloudfrontkeyvaluestore/CHANGELOG.md#v185-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloudhsm`: [v1.24.5](service/cloudhsm/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.27.6](service/cloudhsmv2/CHANGELOG.md#v1276-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloudsearchdomain`: [v1.23.5](service/cloudsearchdomain/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.44.5](service/cloudtrail/CHANGELOG.md#v1445-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloudtraildata`: [v1.11.5](service/cloudtraildata/CHANGELOG.md#v1115-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchevents`: [v1.27.5](service/cloudwatchevents/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.43.2](service/cloudwatchlogs/CHANGELOG.md#v1432-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.33.5](service/codeartifact/CHANGELOG.md#v1335-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.48.1](service/codebuild/CHANGELOG.md#v1481-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.17.5](service/codecatalyst/CHANGELOG.md#v1175-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codecommit`: [v1.27.5](service/codecommit/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codeconnections`: [v1.5.5](service/codeconnections/CHANGELOG.md#v155-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.29.5](service/codedeploy/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codeguruprofiler`: [v1.24.5](service/codeguruprofiler/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codegurureviewer`: [v1.29.5](service/codegurureviewer/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codegurusecurity`: [v1.12.5](service/codegurusecurity/CHANGELOG.md#v1125-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.36.3](service/codepipeline/CHANGELOG.md#v1363-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.29.5](service/codestarconnections/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/codestarnotifications`: [v1.26.5](service/codestarnotifications/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentity`: [v1.27.5](service/cognitoidentity/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.46.5](service/cognitoidentityprovider/CHANGELOG.md#v1465-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/cognitosync`: [v1.23.5](service/cognitosync/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.35.5](service/comprehend/CHANGELOG.md#v1355-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/comprehendmedical`: [v1.26.5](service/comprehendmedical/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.39.5](service/computeoptimizer/CHANGELOG.md#v1395-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.50.5](service/configservice/CHANGELOG.md#v1505-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.115.2](service/connect/CHANGELOG.md#v11152-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/connectcampaigns`: [v1.15.5](service/connectcampaigns/CHANGELOG.md#v1155-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.21.5](service/connectcases/CHANGELOG.md#v1215-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/connectcontactlens`: [v1.26.5](service/connectcontactlens/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.27.5](service/connectparticipant/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.5.5](service/controlcatalog/CHANGELOG.md#v155-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.18.6](service/controltower/CHANGELOG.md#v1186-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/costandusagereportservice`: [v1.28.5](service/costandusagereportservice/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.43.5](service/costexplorer/CHANGELOG.md#v1435-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.10.5](service/costoptimizationhub/CHANGELOG.md#v1105-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.42.5](service/customerprofiles/CHANGELOG.md#v1425-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.44.3](service/databasemigrationservice/CHANGELOG.md#v1443-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/databrew`: [v1.33.5](service/databrew/CHANGELOG.md#v1335-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.33.3](service/dataexchange/CHANGELOG.md#v1333-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/datapipeline`: [v1.25.5](service/datapipeline/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.43.2](service/datasync/CHANGELOG.md#v1432-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.23.3](service/datazone/CHANGELOG.md#v1233-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/dax`: [v1.23.5](service/dax/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.6.4](service/deadline/CHANGELOG.md#v164-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.31.5](service/detective/CHANGELOG.md#v1315-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.28.5](service/devicefarm/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/devopsguru`: [v1.34.5](service/devopsguru/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.29.5](service/directconnect/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.30.5](service/directoryservice/CHANGELOG.md#v1305-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/directoryservicedata`: [v1.2.5](service/directoryservicedata/CHANGELOG.md#v125-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.28.5](service/dlm/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.14.2](service/docdbelastic/CHANGELOG.md#v1142-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.30.5](service/drs/CHANGELOG.md#v1305-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.36.5](service/dynamodb/CHANGELOG.md#v1365-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/dynamodbstreams`: [v1.24.5](service/dynamodbstreams/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ebs`: [v1.27.5](service/ebs/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ec2instanceconnect`: [v1.27.5](service/ec2instanceconnect/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.36.5](service/ecr/CHANGELOG.md#v1365-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.27.5](service/ecrpublic/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.49.2](service/ecs/CHANGELOG.md#v1492-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.33.5](service/efs/CHANGELOG.md#v1335-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.51.3](service/eks/CHANGELOG.md#v1513-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/eksauth`: [v1.7.5](service/eksauth/CHANGELOG.md#v175-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/elasticinference`: [v1.23.6](service/elasticinference/CHANGELOG.md#v1236-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/elasticsearchservice`: [v1.32.5](service/elasticsearchservice/CHANGELOG.md#v1325-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/elastictranscoder`: [v1.27.5](service/elastictranscoder/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.46.3](service/emr/CHANGELOG.md#v1463-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.33.5](service/emrcontainers/CHANGELOG.md#v1335-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.26.5](service/emrserverless/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.15.5](service/entityresolution/CHANGELOG.md#v1155-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.35.5](service/eventbridge/CHANGELOG.md#v1355-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/evidently`: [v1.23.5](service/evidently/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.28.5](service/finspace/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.28.5](service/finspacedata/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.34.5](service/firehose/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.30.5](service/fis/CHANGELOG.md#v1305-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.38.3](service/fms/CHANGELOG.md#v1383-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/forecast`: [v1.36.5](service/forecast/CHANGELOG.md#v1365-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/forecastquery`: [v1.24.5](service/forecastquery/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/frauddetector`: [v1.35.5](service/frauddetector/CHANGELOG.md#v1355-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/freetier`: [v1.7.5](service/freetier/CHANGELOG.md#v175-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.49.5](service/fsx/CHANGELOG.md#v1495-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.36.5](service/gamelift/CHANGELOG.md#v1365-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/geomaps`: [v1.0.2](service/geomaps/CHANGELOG.md#v102-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/geoplaces`: [v1.0.2](service/geoplaces/CHANGELOG.md#v102-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/georoutes`: [v1.0.2](service/georoutes/CHANGELOG.md#v102-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/glacier`: [v1.26.5](service/glacier/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.29.5](service/globalaccelerator/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.101.2](service/glue/CHANGELOG.md#v11012-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.26.5](service/grafana/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/greengrass`: [v1.27.5](service/greengrass/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.35.5](service/greengrassv2/CHANGELOG.md#v1355-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.31.5](service/groundstation/CHANGELOG.md#v1315-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.51.1](service/guardduty/CHANGELOG.md#v1511-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/health`: [v1.28.5](service/health/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.28.5](service/healthlake/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/identitystore`: [v1.27.5](service/identitystore/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.38.3](service/imagebuilder/CHANGELOG.md#v1383-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/inspector`: [v1.25.5](service/inspector/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.32.5](service/inspector2/CHANGELOG.md#v1325-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/inspectorscan`: [v1.7.5](service/inspectorscan/CHANGELOG.md#v175-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.19.5](service/internetmonitor/CHANGELOG.md#v1195-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.59.5](service/iot/CHANGELOG.md#v1595-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iot1clickdevicesservice`: [v1.23.5](service/iot1clickdevicesservice/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iot1clickprojects`: [v1.23.5](service/iot1clickprojects/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotanalytics`: [v1.26.5](service/iotanalytics/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotdataplane`: [v1.26.5](service/iotdataplane/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor`: [v1.31.5](service/iotdeviceadvisor/CHANGELOG.md#v1315-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotevents`: [v1.27.5](service/iotevents/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ioteventsdata`: [v1.24.5](service/ioteventsdata/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotfleethub`: [v1.24.5](service/iotfleethub/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.21.2](service/iotfleetwise/CHANGELOG.md#v1212-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotjobsdataplane`: [v1.23.5](service/iotjobsdataplane/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotsecuretunneling`: [v1.27.5](service/iotsecuretunneling/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.43.5](service/iotsitewise/CHANGELOG.md#v1435-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotthingsgraph`: [v1.25.5](service/iotthingsgraph/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.24.5](service/iottwinmaker/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.44.5](service/iotwireless/CHANGELOG.md#v1445-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.16.5](service/ivschat/CHANGELOG.md#v1165-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.38.5](service/kafka/CHANGELOG.md#v1385-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kafkaconnect`: [v1.21.5](service/kafkaconnect/CHANGELOG.md#v1215-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.54.5](service/kendra/CHANGELOG.md#v1545-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kendraranking`: [v1.11.5](service/kendraranking/CHANGELOG.md#v1115-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.15.2](service/keyspaces/CHANGELOG.md#v1152-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.32.5](service/kinesis/CHANGELOG.md#v1325-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalytics`: [v1.25.5](service/kinesisanalytics/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.31.5](service/kinesisanalyticsv2/CHANGELOG.md#v1315-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.27.5](service/kinesisvideo/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia`: [v1.27.5](service/kinesisvideoarchivedmedia/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideomedia`: [v1.22.5](service/kinesisvideomedia/CHANGELOG.md#v1225-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideosignaling`: [v1.23.5](service/kinesisvideosignaling/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.14.5](service/kinesisvideowebrtcstorage/CHANGELOG.md#v1145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.37.5](service/kms/CHANGELOG.md#v1375-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.38.1](service/lakeformation/CHANGELOG.md#v1381-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.64.3](service/lambda/CHANGELOG.md#v1643-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/launchwizard`: [v1.8.5](service/launchwizard/CHANGELOG.md#v185-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lexmodelbuildingservice`: [v1.28.5](service/lexmodelbuildingservice/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.49.5](service/lexmodelsv2/CHANGELOG.md#v1495-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lexruntimeservice`: [v1.24.5](service/lexruntimeservice/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lexruntimev2`: [v1.29.5](service/lexruntimev2/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/licensemanager`: [v1.29.5](service/licensemanager/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.14.5](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v1145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.13.5](service/licensemanagerusersubscriptions/CHANGELOG.md#v1135-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.42.5](service/lightsail/CHANGELOG.md#v1425-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.42.5](service/location/CHANGELOG.md#v1425-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.30.5](service/lookoutequipment/CHANGELOG.md#v1305-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lookoutmetrics`: [v1.31.5](service/lookoutmetrics/CHANGELOG.md#v1315-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/lookoutvision`: [v1.27.5](service/lookoutvision/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.18.3](service/m2/CHANGELOG.md#v1183-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/machinelearning`: [v1.28.5](service/machinelearning/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.43.5](service/macie2/CHANGELOG.md#v1435-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.6.3](service/mailmanager/CHANGELOG.md#v163-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.26.5](service/managedblockchain/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.16.5](service/managedblockchainquery/CHANGELOG.md#v1165-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/marketplaceagreement`: [v1.6.5](service/marketplaceagreement/CHANGELOG.md#v165-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.30.5](service/marketplacecatalog/CHANGELOG.md#v1305-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/marketplacecommerceanalytics`: [v1.24.5](service/marketplacecommerceanalytics/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/marketplacedeployment`: [v1.6.5](service/marketplacedeployment/CHANGELOG.md#v165-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.25.5](service/marketplaceentitlementservice/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/marketplacemetering`: [v1.25.5](service/marketplacemetering/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/marketplacereporting`: [v1.1.5](service/marketplacereporting/CHANGELOG.md#v115-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.35.5](service/mediaconnect/CHANGELOG.md#v1355-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.61.5](service/mediaconvert/CHANGELOG.md#v1615-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.62.5](service/medialive/CHANGELOG.md#v1625-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mediapackage`: [v1.34.5](service/mediapackage/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.19.2](service/mediapackagev2/CHANGELOG.md#v1192-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mediapackagevod`: [v1.34.6](service/mediapackagevod/CHANGELOG.md#v1346-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mediastore`: [v1.24.5](service/mediastore/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mediastoredata`: [v1.24.5](service/mediastoredata/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.42.5](service/mediatailor/CHANGELOG.md#v1425-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.14.5](service/medicalimaging/CHANGELOG.md#v1145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.24.4](service/memorydb/CHANGELOG.md#v1244-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.32.5](service/mgn/CHANGELOG.md#v1325-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/migrationhub`: [v1.24.5](service/migrationhub/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/migrationhubconfig`: [v1.25.5](service/migrationhubconfig/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/migrationhuborchestrator`: [v1.13.5](service/migrationhuborchestrator/CHANGELOG.md#v1135-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/migrationhubrefactorspaces`: [v1.20.5](service/migrationhubrefactorspaces/CHANGELOG.md#v1205-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.21.5](service/migrationhubstrategy/CHANGELOG.md#v1215-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mq`: [v1.27.5](service/mq/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mturk`: [v1.25.5](service/mturk/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.32.3](service/mwaa/CHANGELOG.md#v1323-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.14.3](service/neptunegraph/CHANGELOG.md#v1143-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.44.2](service/networkfirewall/CHANGELOG.md#v1442-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.31.5](service/networkmanager/CHANGELOG.md#v1315-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/networkmonitor`: [v1.7.5](service/networkmonitor/CHANGELOG.md#v175-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.15.5](service/oam/CHANGELOG.md#v1155-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.26.5](service/omics/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.43.2](service/opensearch/CHANGELOG.md#v1432-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.17.2](service/opensearchserverless/CHANGELOG.md#v1172-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/opsworks`: [v1.26.5](service/opsworks/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/opsworkscm`: [v1.27.5](service/opsworkscm/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.34.5](service/organizations/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.14.5](service/osis/CHANGELOG.md#v1145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.45.3](service/outposts/CHANGELOG.md#v1453-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/panorama`: [v1.22.5](service/panorama/CHANGELOG.md#v1225-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.15.3](service/paymentcryptography/CHANGELOG.md#v1153-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.16.3](service/paymentcryptographydata/CHANGELOG.md#v1163-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorad`: [v1.9.5](service/pcaconnectorad/CHANGELOG.md#v195-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorscep`: [v1.4.5](service/pcaconnectorscep/CHANGELOG.md#v145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.2.6](service/pcs/CHANGELOG.md#v126-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.39.5](service/personalize/CHANGELOG.md#v1395-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/personalizeevents`: [v1.25.5](service/personalizeevents/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.27.5](service/personalizeruntime/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.29.5](service/pi/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.34.5](service/pinpoint/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pinpointemail`: [v1.23.5](service/pinpointemail/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoice`: [v1.23.5](service/pinpointsmsvoice/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.16.3](service/pinpointsmsvoicev2/CHANGELOG.md#v1163-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.18.3](service/pipes/CHANGELOG.md#v1183-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.45.5](service/polly/CHANGELOG.md#v1455-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.32.5](service/pricing/CHANGELOG.md#v1325-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/privatenetworks`: [v1.13.5](service/privatenetworks/CHANGELOG.md#v1135-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/proton`: [v1.33.5](service/proton/CHANGELOG.md#v1335-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.4.1](service/qapps/CHANGELOG.md#v141-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.15.3](service/qbusiness/CHANGELOG.md#v1153-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.12.5](service/qconnect/CHANGELOG.md#v1125-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/qldb`: [v1.25.5](service/qldb/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/qldbsession`: [v1.25.5](service/qldbsession/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.78.0](service/quicksight/CHANGELOG.md#v1780-2024-11-07)
  * **Feature**: Add Client Credentials based OAuth support for Snowflake and Starburst
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ram`: [v1.29.5](service/ram/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.20.5](service/rbin/CHANGELOG.md#v1205-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.25.5](service/rdsdata/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.31.2](service/redshiftdata/CHANGELOG.md#v1312-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.24.2](service/redshiftserverless/CHANGELOG.md#v1242-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.45.6](service/rekognition/CHANGELOG.md#v1456-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/repostspace`: [v1.8.3](service/repostspace/CHANGELOG.md#v183-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.27.3](service/resiliencehub/CHANGELOG.md#v1273-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.16.0](service/resourceexplorer2/CHANGELOG.md#v1160-2024-11-07)
  * **Feature**: Add GetManagedView, ListManagedViews APIs.
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.27.5](service/resourcegroups/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/resourcegroupstaggingapi`: [v1.25.5](service/resourcegroupstaggingapi/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/robomaker`: [v1.30.6](service/robomaker/CHANGELOG.md#v1306-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.16.5](service/rolesanywhere/CHANGELOG.md#v1165-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.27.5](service/route53domains/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/route53profiles`: [v1.4.5](service/route53profiles/CHANGELOG.md#v145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycluster`: [v1.23.5](service/route53recoverycluster/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.25.5](service/route53recoverycontrolconfig/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/route53recoveryreadiness`: [v1.21.5](service/route53recoveryreadiness/CHANGELOG.md#v1215-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.33.3](service/route53resolver/CHANGELOG.md#v1333-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.21.5](service/rum/CHANGELOG.md#v1215-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.28.5](service/s3outposts/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.166.2](service/sagemaker/CHANGELOG.md#v11662-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sagemakera2iruntime`: [v1.27.5](service/sagemakera2iruntime/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sagemakeredge`: [v1.25.5](service/sagemakeredge/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.29.5](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial`: [v1.14.5](service/sagemakergeospatial/CHANGELOG.md#v1145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.32.5](service/sagemakerruntime/CHANGELOG.md#v1325-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/savingsplans`: [v1.23.5](service/savingsplans/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/scheduler`: [v1.12.5](service/scheduler/CHANGELOG.md#v1125-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/schemas`: [v1.28.6](service/schemas/CHANGELOG.md#v1286-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.34.5](service/secretsmanager/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.54.6](service/securityhub/CHANGELOG.md#v1546-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.19.3](service/securitylake/CHANGELOG.md#v1193-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/serverlessapplicationrepository`: [v1.24.5](service/serverlessapplicationrepository/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.32.5](service/servicecatalog/CHANGELOG.md#v1325-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.30.5](service/servicecatalogappregistry/CHANGELOG.md#v1305-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.33.5](service/servicediscovery/CHANGELOG.md#v1335-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/servicequotas`: [v1.25.5](service/servicequotas/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.38.2](service/sesv2/CHANGELOG.md#v1382-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.33.5](service/sfn/CHANGELOG.md#v1335-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/shield`: [v1.29.5](service/shield/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/signer`: [v1.26.5](service/signer/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.14.5](service/simspaceweaver/CHANGELOG.md#v1145-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sms`: [v1.24.5](service/sms/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.30.5](service/snowball/CHANGELOG.md#v1305-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/snowdevicemanagement`: [v1.20.5](service/snowdevicemanagement/CHANGELOG.md#v1205-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/socialmessaging`: [v1.0.3](service/socialmessaging/CHANGELOG.md#v103-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.37.0](service/sqs/CHANGELOG.md#v1370-2024-11-07)
  * **Feature**: Send opt-in query-compatible header for applicable services.
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.55.5](service/ssm/CHANGELOG.md#v1555-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ssmcontacts`: [v1.26.5](service/ssmcontacts/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.34.5](service/ssmincidents/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ssmquicksetup`: [v1.2.6](service/ssmquicksetup/CHANGELOG.md#v126-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.18.5](service/ssmsap/CHANGELOG.md#v1185-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/sso`: [v1.24.5](service/sso/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.29.5](service/ssoadmin/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.34.5](service/storagegateway/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.10.3](service/supplychain/CHANGELOG.md#v1103-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.26.5](service/support/CHANGELOG.md#v1265-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/supportapp`: [v1.13.5](service/supportapp/CHANGELOG.md#v1135-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/swf`: [v1.27.5](service/swf/CHANGELOG.md#v1275-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.30.0](service/synthetics/CHANGELOG.md#v1300-2024-11-07)
  * **Feature**: Add support to toggle if a canary will automatically delete provisioned canary resources such as Lambda functions and layers when a canary is deleted.  This behavior can be controlled via the new ProvisionedResourceCleanup property exposed in the CreateCanary and UpdateCanary APIs.
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.6.2](service/taxsettings/CHANGELOG.md#v162-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.34.7](service/textract/CHANGELOG.md#v1347-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.6.5](service/timestreaminfluxdb/CHANGELOG.md#v165-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.28.3](service/timestreamquery/CHANGELOG.md#v1283-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.29.5](service/timestreamwrite/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/tnb`: [v1.13.5](service/tnb/CHANGELOG.md#v1135-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.41.5](service/transcribe/CHANGELOG.md#v1415-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.22.3](service/transcribestreaming/CHANGELOG.md#v1223-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.53.3](service/transfer/CHANGELOG.md#v1533-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/translate`: [v1.28.5](service/translate/CHANGELOG.md#v1285-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/trustedadvisor`: [v1.8.5](service/trustedadvisor/CHANGELOG.md#v185-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.20.1](service/verifiedpermissions/CHANGELOG.md#v1201-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/voiceid`: [v1.24.5](service/voiceid/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/vpclattice`: [v1.12.5](service/vpclattice/CHANGELOG.md#v1125-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/waf`: [v1.25.5](service/waf/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/wafregional`: [v1.25.5](service/wafregional/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.55.4](service/wafv2/CHANGELOG.md#v1554-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.34.5](service/wellarchitected/CHANGELOG.md#v1345-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.27.6](service/wisdom/CHANGELOG.md#v1276-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/workdocs`: [v1.25.5](service/workdocs/CHANGELOG.md#v1255-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/workmail`: [v1.30.2](service/workmail/CHANGELOG.md#v1302-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/workmailmessageflow`: [v1.23.5](service/workmailmessageflow/CHANGELOG.md#v1235-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.48.5](service/workspaces/CHANGELOG.md#v1485-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.10.5](service/workspacesthinclient/CHANGELOG.md#v1105-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.24.5](service/workspacesweb/CHANGELOG.md#v1245-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.29.5](service/xray/CHANGELOG.md#v1295-2024-11-07)
  * **Bug Fix**: Adds case-insensitive handling of error message fields in service responses

# Release (2024-11-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.32.4
  * **Bug Fix**: Fix potential for user agent language mismatch in tests.
* `github.com/aws/aws-sdk-go-v2/feature/cloudfront/sign`: [v1.8.0](feature/cloudfront/sign/CHANGELOG.md#v180-2024-11-06)
  * **Feature**: Add Expires field to CookieOptions.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.48.0](service/codebuild/CHANGELOG.md#v1480-2024-11-06)
  * **Feature**: AWS CodeBuild now adds additional compute types for reserved capacity fleet.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.51.0](service/guardduty/CHANGELOG.md#v1510-2024-11-06)
  * **Feature**: GuardDuty RDS Protection expands support for Amazon Aurora PostgreSQL Limitless Databases.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.38.0](service/lakeformation/CHANGELOG.md#v1380-2024-11-06)
  * **Feature**: API changes for new named tag expressions feature.
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.4.0](service/qapps/CHANGELOG.md#v140-2024-11-06)
  * **Feature**: Introduces category apis in AmazonQApps. Web experience users use Categories to tag and filter library items.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.50.0](service/s3control/CHANGELOG.md#v1500-2024-11-06)
  * **Feature**: Fix ListStorageLensConfigurations and ListStorageLensGroups deserialization for Smithy SDKs.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.20.0](service/verifiedpermissions/CHANGELOG.md#v1200-2024-11-06)
  * **Feature**: Adding BatchGetPolicy API which supports the retrieval of multiple policies across multiple policy stores within a single request.

# Release (2024-11-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.26.0](service/bedrockagent/CHANGELOG.md#v1260-2024-11-01)
  * **Feature**: Amazon Bedrock Knowledge Bases now supports using application inference profiles to increase throughput and improve resilience.
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.14.0](service/docdbelastic/CHANGELOG.md#v1140-2024-11-01)
  * **Feature**: Amazon DocumentDB Elastic Clusters adds support for pending maintenance actions feature with APIs GetPendingMaintenanceAction, ListPendingMaintenanceActions and ApplyPendingMaintenanceAction
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.6.0](service/taxsettings/CHANGELOG.md#v160-2024-11-01)
  * **Feature**: Add support for supplemental tax registrations via these new APIs: PutSupplementalTaxRegistration, ListSupplementalTaxRegistrations, and DeleteSupplementalTaxRegistration.

# Release (2024-10-31)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.30.0](service/amp/CHANGELOG.md#v1300-2024-10-31)
  * **Feature**: Added support for UpdateScraper API, to enable updating collector configuration in-place
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.47.0](service/autoscaling/CHANGELOG.md#v1470-2024-10-31)
  * **Feature**: Adds bake time for Auto Scaling group Instance Refresh
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.47.0](service/batch/CHANGELOG.md#v1470-2024-10-31)
  * **Feature**: Add `podNamespace` to `EksAttemptDetail` and `containerID` to `EksAttemptContainerDetail`.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.41.0](service/elasticloadbalancingv2/CHANGELOG.md#v1410-2024-10-31)
  * **Feature**: Add UDP support for AWS PrivateLink and dual-stack Network Load Balancers
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.101.0](service/glue/CHANGELOG.md#v11010-2024-10-31)
  * **Feature**: Add schedule support for AWS Glue column statistics
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.166.0](service/sagemaker/CHANGELOG.md#v11660-2024-10-31)
  * **Feature**: SageMaker HyperPod adds scale-down at instance level via BatchDeleteClusterNodes API and group level via UpdateCluster API. SageMaker Training exposes secondary job status in TrainingJobSummary from ListTrainingJobs API. SageMaker now supports G6, G6e, P5e instances for HyperPod and Training.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.38.0](service/sesv2/CHANGELOG.md#v1380-2024-10-31)
  * **Feature**: This release enables customers to provide the email template content in the SESv2 SendEmail and SendBulkEmail APIs instead of the name or the ARN of a stored email template.

# Release (2024-10-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.39.0](service/appsync/CHANGELOG.md#v1390-2024-10-30)
  * **Feature**: This release adds support for AppSync Event APIs.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.115.0](service/connect/CHANGELOG.md#v11150-2024-10-30)
  * **Feature**: Updated the public documentation for the UserIdentityInfo object to accurately reflect the character limits for the FirstName and LastName fields, which were previously listed as 1-100 characters.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.43.0](service/datasync/CHANGELOG.md#v1430-2024-10-30)
  * **Feature**: AWS DataSync now supports Enhanced mode tasks. This task mode supports transfer of virtually unlimited numbers of objects with enhanced metrics, more detailed logs, and higher performance than Basic mode. This mode currently supports transfers between Amazon S3 locations.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.187.0](service/ec2/CHANGELOG.md#v11870-2024-10-30)
  * **Feature**: This release adds two new capabilities to VPC Security Groups: Security Group VPC Associations and Shared Security Groups.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.49.0](service/ecs/CHANGELOG.md#v1490-2024-10-30)
  * **Feature**: This release supports service deployments and service revisions which provide a comprehensive view of your Amazon ECS service history.
* `github.com/aws/aws-sdk-go-v2/service/geomaps`: [v1.0.0](service/geomaps/CHANGELOG.md#v100-2024-10-30)
  * **Release**: New AWS service client module
  * **Feature**: Release of Amazon Location Maps API. Maps enables you to build digital maps that showcase your locations, visualize your data, and unlock insights to drive your business
* `github.com/aws/aws-sdk-go-v2/service/geoplaces`: [v1.0.0](service/geoplaces/CHANGELOG.md#v100-2024-10-30)
  * **Release**: New AWS service client module
  * **Feature**: Release of Amazon Location Places API. Places enables you to quickly search, display, and filter places, businesses, and locations based on proximity, category, and name
* `github.com/aws/aws-sdk-go-v2/service/georoutes`: [v1.0.0](service/georoutes/CHANGELOG.md#v100-2024-10-30)
  * **Release**: New AWS service client module
  * **Feature**: Release of Amazon Location Routes API. Routes enables you to plan efficient routes and streamline deliveries by leveraging real-time traffic, vehicle restrictions, and turn-by-turn directions.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.15.0](service/keyspaces/CHANGELOG.md#v1150-2024-10-30)
  * **Feature**: Adds support for interacting with user-defined types (UDTs) through the following new operations: Create-Type, Delete-Type, List-Types, Get-Type.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.44.0](service/networkfirewall/CHANGELOG.md#v1440-2024-10-30)
  * **Feature**: AWS Network Firewall now supports configuring TCP idle timeout
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.43.0](service/opensearch/CHANGELOG.md#v1430-2024-10-30)
  * **Feature**: This release introduces the new OpenSearch user interface (Dashboards), a new web-based application that can be associated with multiple data sources across OpenSearch managed clusters, serverless collections, and Amazon S3, so that users can gain a comprehensive insights in an unified interface.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.17.0](service/opensearchserverless/CHANGELOG.md#v1170-2024-10-30)
  * **Feature**: Neo Integration via IAM Identity Center (IdC)
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.51.0](service/redshift/CHANGELOG.md#v1510-2024-10-30)
  * **Feature**: This release launches S3 event integrations to create and manage integrations from an Amazon S3 source into an Amazon Redshift database.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.24.0](service/redshiftserverless/CHANGELOG.md#v1240-2024-10-30)
  * **Feature**: Adds and updates API members for the Redshift Serverless AI-driven scaling and optimization feature using the price-performance target setting.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.46.0](service/route53/CHANGELOG.md#v1460-2024-10-30)
  * **Feature**: This release adds support for TLSA, SSHFP, SVCB, and HTTPS record types.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.165.0](service/sagemaker/CHANGELOG.md#v11650-2024-10-30)
  * **Feature**: Added support for Model Registry Staging construct. Users can define series of stages that models can progress through for model workflows and lifecycle. This simplifies tracking and managing models as they transition through development, testing, and production stages.
* `github.com/aws/aws-sdk-go-v2/service/workmail`: [v1.30.0](service/workmail/CHANGELOG.md#v1300-2024-10-30)
  * **Feature**: This release adds support for Multi-Factor Authentication (MFA) and Personal Access Tokens through integration with AWS IAM Identity Center.

# Release (2024-10-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.22.0](service/bedrock/CHANGELOG.md#v1220-2024-10-29)
  * **Feature**: Update Application Inference Profile
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.19.0](service/cleanrooms/CHANGELOG.md#v1190-2024-10-29)
  * **Feature**: This release adds the option for customers to configure analytics engine when creating a collaboration, and introduces the new SPARK analytics engine type in addition to maintaining the legacy CLEAN_ROOMS_SQL engine type.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.43.0](service/cloudwatchlogs/CHANGELOG.md#v1430-2024-10-29)
  * **Feature**: Added support for new optional baseline parameter in the UpdateAnomaly API. For UpdateAnomaly requests with baseline set to True, The anomaly behavior is then treated as baseline behavior. However, more severe occurrences of this behavior will still be reported as anomalies.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.21.0](service/iotfleetwise/CHANGELOG.md#v1210-2024-10-29)
  * **Feature**: Updated BatchCreateVehicle and BatchUpdateVehicle APIs: LimitExceededException has been added and the maximum number of vehicles in a batch has been set to 10 explicitly
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.31.0](service/redshiftdata/CHANGELOG.md#v1310-2024-10-29)
  * **Feature**: Adding a new API GetStatementResultV2 that supports CSV formatted results from ExecuteStatement and BatchExecuteStatement calls.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.164.0](service/sagemaker/CHANGELOG.md#v11640-2024-10-29)
  * **Feature**: Adding `notebook-al2-v3` as allowed value to SageMaker NotebookInstance PlatformIdentifier attribute

# Release (2024-10-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.32.3
  * **Bug Fix**: Improve handling of whitespace (or lack thereof) in sigv4 GetSignedRequestSignature.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.19.0](service/mediapackagev2/CHANGELOG.md#v1190-2024-10-28)
  * **Feature**: MediaPackage V2 Live to VOD Harvester is a MediaPackage V2 feature, which is used to export content from an origin endpoint to a S3 bucket.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.42.0](service/opensearch/CHANGELOG.md#v1420-2024-10-28)
  * **Feature**: Adds support for provisioning dedicated coordinator nodes. Coordinator nodes can be specified using the new NodeOptions parameter in ClusterConfig.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.89.0](service/rds/CHANGELOG.md#v1890-2024-10-28)
  * **Feature**: This release adds support for Enhanced Monitoring and Performance Insights when restoring Aurora Limitless Database DB clusters. It also adds support for the os-upgrade pending maintenance action.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.34.3](service/storagegateway/CHANGELOG.md#v1343-2024-10-28)
  * **Documentation**: Documentation update: Amazon FSx File Gateway will no longer be available to new customers.

# Release (2024-10-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.25.0](service/bedrockagent/CHANGELOG.md#v1250-2024-10-25)
  * **Feature**: Add support of new model types for Bedrock Agents, Adding inference profile support for Flows and Prompt Management, Adding new field to configure additional inference configurations for Flows and Prompt Management
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.42.0](service/cloudwatchlogs/CHANGELOG.md#v1420-2024-10-25)
  * **Feature**: Adding inferred token name for dynamic tokens in Anomalies.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.47.0](service/codebuild/CHANGELOG.md#v1470-2024-10-25)
  * **Feature**: AWS CodeBuild now supports automatically retrying failed builds
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.64.0](service/lambda/CHANGELOG.md#v1640-2024-10-25)
  * **Feature**: Add TagsError field in Lambda GetFunctionResponse. The TagsError field contains details related to errors retrieving tags.
* `github.com/aws/aws-sdk-go-v2/service/nimble`: [v1.29.0](service/nimble/CHANGELOG.md#v1290-2024-10-25)
  * **Feature**: Mark service/nimble as deprecated. This service is no longer available for use. See https://aws.amazon.com/nimble-studio/faqs/.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.66.1](service/s3/CHANGELOG.md#v1661-2024-10-25)
  * **Bug Fix**: Update presign post URL resolution to use the exact result from EndpointResolverV2
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.10.0](service/supplychain/CHANGELOG.md#v1100-2024-10-25)
  * **Feature**: API doc updates, and also support showing error message on a failed instance

# Release (2024-10-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.35.0](service/appconfig/CHANGELOG.md#v1350-2024-10-24)
  * **Feature**: This release improves deployment safety by granting customers the ability to REVERT completed deployments, to the last known good state.In the StopDeployment API revert case the status of a COMPLETE deployment will be REVERTED. AppConfig only allows a revert within 72 hours of deployment completion.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.186.0](service/ec2/CHANGELOG.md#v11860-2024-10-24)
  * **Feature**: This release includes a new API to describe some details of the Amazon Machine Images (AMIs) that were used to launch EC2 instances, even if those AMIs are no longer available for use.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.48.0](service/ecs/CHANGELOG.md#v1480-2024-10-24)
  * **Feature**: This release adds support for EBS volumes attached to Amazon ECS Windows tasks running on EC2 instances.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.2.3](service/pcs/CHANGELOG.md#v123-2024-10-24)
  * **Documentation**: Documentation update: added the default value of the Slurm configuration parameter scaleDownIdleTimeInSeconds to its description.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.15.0](service/qbusiness/CHANGELOG.md#v1150-2024-10-24)
  * **Feature**: Add a new field in chat response. This field can be used to support nested schemas in array fields

# Release (2024-10-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.21.1](service/bedrock/CHANGELOG.md#v1211-2024-10-23)
  * **Documentation**: Doc updates for supporting converse
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.114.0](service/connect/CHANGELOG.md#v11140-2024-10-23)
  * **Feature**: Amazon Connect Service Feature: Add support to start screen sharing for a web calling contact.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.185.0](service/ec2/CHANGELOG.md#v11850-2024-10-23)
  * **Feature**: Amazon EC2 X8g, C8g and M8g instances are powered by AWS Graviton4 processors. X8g provide the lowest cost per GiB of memory among Graviton4 instances. C8g provide the best price performance for compute-intensive workloads. M8g provide the best price performance in for general purpose workloads.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.32.0](service/mwaa/CHANGELOG.md#v1320-2024-10-23)
  * **Feature**: Introducing InvokeRestApi which allows users to invoke the Apache Airflow REST API on the webserver with the specified inputs.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.15.0](service/paymentcryptography/CHANGELOG.md#v1150-2024-10-23)
  * **Feature**: Add support for ECC P-256 and P-384 Keys.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.16.0](service/paymentcryptographydata/CHANGELOG.md#v1160-2024-10-23)
  * **Feature**: Add ECDH support on PIN operations.

# Release (2024-10-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.38.0](service/imagebuilder/CHANGELOG.md#v1380-2024-10-22)
  * **Feature**: Add macOS platform and instance placement options
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.18.0](service/m2/CHANGELOG.md#v1180-2024-10-22)
  * **Feature**: Add AuthSecretsManagerArn optional parameter to batch job APIs, expand batch parameter limits, and introduce clientToken constraints.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.88.0](service/rds/CHANGELOG.md#v1880-2024-10-22)
  * **Feature**: Global clusters now expose the Endpoint attribute as one of its fields. It is a Read/Write endpoint for the global cluster which resolves to the Global Cluster writer instance.
* `github.com/aws/aws-sdk-go-v2/service/repostspace`: [v1.8.0](service/repostspace/CHANGELOG.md#v180-2024-10-22)
  * **Feature**: Adds the BatchAddRole and BatchRemoveRole APIs.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.28.0](service/timestreamquery/CHANGELOG.md#v1280-2024-10-22)
  * **Feature**: This release adds support for Query Insights, a feature that provides details of query execution, enabling users to identify areas for improvement to optimize their queries, resulting in improved query performance and lower query costs.

# Release (2024-10-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationinsights`: [v1.29.0](service/applicationinsights/CHANGELOG.md#v1290-2024-10-21)
  * **Feature**: This feature enables customers to specify SNS Topic ARN. CloudWatch Application Insights (CWAI) will utilize this ARN to send problem notifications.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.46.0](service/autoscaling/CHANGELOG.md#v1460-2024-10-21)
  * **Feature**: Adds support for removing the PlacementGroup setting on an Auto Scaling Group through the UpdateAutoScalingGroup API.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.23.0](service/bedrockagentruntime/CHANGELOG.md#v1230-2024-10-21)
  * **Feature**: Knowledge Bases for Amazon Bedrock now supports custom prompts and model parameters in the orchestrationConfiguration of the RetrieveAndGenerate API. The modelArn field accepts Custom Models and Imported Models ARNs.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.44.0](service/databasemigrationservice/CHANGELOG.md#v1440-2024-10-21)
  * **Feature**: Added support for tagging in StartReplicationTaskAssessmentRun API and introduced IsLatestTaskAssessmentRun and ResultStatistic fields for enhanced tracking and assessment result statistics.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.184.0](service/ec2/CHANGELOG.md#v11840-2024-10-21)
  * **Feature**: Amazon EC2 now allows you to create network interfaces with just the EFA driver and no ENA driver by specifying the network interface type as efa-only.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.51.0](service/eks/CHANGELOG.md#v1510-2024-10-21)
  * **Feature**: This release adds support for Amazon Application Recovery Controller (ARC) zonal shift and zonal autoshift with EKS that enhances the resiliency of multi-AZ cluster environments
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.38.0](service/fms/CHANGELOG.md#v1380-2024-10-21)
  * **Feature**: Update AWS WAF policy - add the option to retrofit existing web ACLs instead of creating all new web ACLs.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.15.0](service/paymentcryptographydata/CHANGELOG.md#v1150-2024-10-21)
  * **Feature**: Adding new API to generate authenticated scripts for EMV pin change use cases.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.55.0](service/wafv2/CHANGELOG.md#v1550-2024-10-21)
  * **Feature**: Add a property to WebACL to indicate whether it's been retrofitted by Firewall Manager.

# Release (2024-10-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.48.0](service/athena/CHANGELOG.md#v1480-2024-10-18)
  * **Feature**: **BREAKING CHANGE**: Remove DataCatalog from Create/DeleteDataCatalog. Remove Status, ConnectionType, and Error from DataCatalog and DataCatalogSummary. These were released inadvertently with no functionality. They were not populated or populated with a default value. Code related to these changes can be safely removed.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.21.0](service/bedrock/CHANGELOG.md#v1210-2024-10-18)
  * **Feature**: Adding converse support to CMI API's
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.23.0](service/datazone/CHANGELOG.md#v1230-2024-10-18)
  * **Feature**: Adding the following project member designations: PROJECT_CATALOG_VIEWER, PROJECT_CATALOG_CONSUMER and PROJECT_CATALOG_STEWARD in the CreateProjectMembership API and PROJECT_CATALOG_STEWARD designation in the AddPolicyGrant API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.183.0](service/ec2/CHANGELOG.md#v11830-2024-10-18)
  * **Feature**: RequestSpotInstances and RequestSpotFleet feature release.

# Release (2024-10-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.24.0](service/bedrockagent/CHANGELOG.md#v1240-2024-10-17)
  * **Feature**: Removing support for topK property in PromptModelInferenceConfiguration object, Making PromptTemplateConfiguration property as required, Limiting the maximum PromptVariant to 1
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.33.0](service/dataexchange/CHANGELOG.md#v1330-2024-10-17)
  * **Feature**: This release adds Data Grant support, through which customers can programmatically create data grants to share with other AWS accounts and accept data grants from other AWS accounts.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.47.4](service/ecs/CHANGELOG.md#v1474-2024-10-17)
  * **Documentation**: This is an Amazon ECS documentation only update to address tickets.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.16.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1160-2024-10-17)
  * **Feature**: Added the registrations status of REQUIRES_AUTHENTICATION
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.18.0](service/pipes/CHANGELOG.md#v1180-2024-10-17)
  * **Feature**: This release adds validation to require specifying a SecurityGroup and Subnets in the Vpc object under PipesSourceSelfManagedKafkaParameters. It also adds support for iso-e, iso-f, and other non-commercial partitions in ARN parameters.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.77.0](service/quicksight/CHANGELOG.md#v1770-2024-10-17)
  * **Feature**: Add StartDashboardSnapshotJobSchedule API. RestoreAnalysis now supports restoring analysis to folders.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.87.3](service/rds/CHANGELOG.md#v1873-2024-10-17)
  * **Documentation**: Updates Amazon RDS documentation for TAZ IAM support

# Release (2024-10-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.28.0](config/CHANGELOG.md#v1280-2024-10-16)
  * **Feature**: Adds the LoadOptions hook `WithBaseEndpoint` for setting global endpoint override in-code.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.37.3](service/imagebuilder/CHANGELOG.md#v1373-2024-10-16)
  * **Bug Fix**: **BREAKING CHANGE**: The type of LaunchTemplateConfiguration.SetDefaultVersion has been changed from `bool` to `*bool`. Before this change, the field was incorrectly marked as having a default value of false by the service, which made it functionally impossible for users to express the full range of values for the field (true, false, and unset/nil), each of which have distinctly different behaviors.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.66.0](service/s3/CHANGELOG.md#v1660-2024-10-16)
  * **Feature**: Add support for the new optional bucket-region and prefix query parameters in the ListBuckets API. For ListBuckets requests that express pagination, Amazon S3 will now return both the bucket names and associated AWS regions in the response.

# Release (2024-10-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.27.0](service/amplify/CHANGELOG.md#v1270-2024-10-15)
  * **Feature**: Added sourceUrlType field to StartDeployment request
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.55.3](service/cloudformation/CHANGELOG.md#v1553-2024-10-15)
  * **Documentation**: Documentation update for AWS CloudFormation API Reference.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.46.0](service/codebuild/CHANGELOG.md#v1460-2024-10-15)
  * **Feature**: Enable proxy for reserved capacity fleet.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.41.0](service/ivs/CHANGELOG.md#v1410-2024-10-15)
  * **Feature**: On a channel that you own, you can now replace an ongoing stream with a new stream by streaming up with the priority parameter appended to the stream key.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.14.0](service/qbusiness/CHANGELOG.md#v1140-2024-10-15)
  * **Feature**: Amazon Q Business now supports embedding the Amazon Q Business web experience on third-party websites.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.50.0](service/redshift/CHANGELOG.md#v1500-2024-10-15)
  * **Feature**: This release launches the CreateIntegration, DeleteIntegration, DescribeIntegrations and ModifyIntegration APIs to create and manage Amazon Redshift Zero-ETL Integrations.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.27.0](service/resiliencehub/CHANGELOG.md#v1270-2024-10-15)
  * **Feature**: AWS Resilience Hub now integrates with the myApplications platform, enabling customers to easily assess the resilience of applications defined in myApplications. The new Resiliency widget provides visibility into application resilience and actionable recommendations for improvement.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.37.0](service/sesv2/CHANGELOG.md#v1370-2024-10-15)
  * **Feature**: This release adds support for email maximum delivery seconds that allows senders to control the time within which their emails are attempted for delivery.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.22.0](service/transcribestreaming/CHANGELOG.md#v1220-2024-10-15)
  * **Feature**: We are expanding support for 40 new locales in AWS Transcribe Streaming.

# Release (2024-10-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.36.0](service/codepipeline/CHANGELOG.md#v1360-2024-10-14)
  * **Feature**: AWS CodePipeline V2 type pipelines now support automatically retrying failed stages and skipping stage for failed entry conditions.
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.6.0](service/mailmanager/CHANGELOG.md#v160-2024-10-14)
  * **Feature**: Mail Manager support for viewing and exporting metadata of archived messages.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.19.0](service/securitylake/CHANGELOG.md#v1190-2024-10-14)
  * **Feature**: This release updates request validation regex for resource ARNs.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.9.0](service/supplychain/CHANGELOG.md#v190-2024-10-14)
  * **Feature**: This release adds AWS Supply Chain instance management functionality. Specifically adding CreateInstance, DeleteInstance, GetInstance, ListInstances, and UpdateInstance APIs.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.53.0](service/transfer/CHANGELOG.md#v1530-2024-10-14)
  * **Feature**: This release enables customers using SFTP connectors to query the transfer status of their files to meet their monitoring needs as well as orchestrate post transfer actions.

# Release (2024-10-11)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.45.3](service/appflow/CHANGELOG.md#v1453-2024-10-11)
  * **Documentation**: Doc only updates for clarification around OAuth2GrantType for Salesforce.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.40.0](service/elasticloadbalancingv2/CHANGELOG.md#v1400-2024-10-11)
  * **Feature**: Add zonal_shift.config.enabled attribute. Add new AdministrativeOverride construct in the describe-target-health API response to include information about the override status applied to a target.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.46.0](service/emr/CHANGELOG.md#v1460-2024-10-11)
  * **Feature**: This release provides new parameter "Context" in instance fleet clusters.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.50.0](service/guardduty/CHANGELOG.md#v1500-2024-10-11)
  * **Feature**: Added a new field for network connection details.
* `github.com/aws/aws-sdk-go-v2/service/robomaker`: [v1.30.3](service/robomaker/CHANGELOG.md#v1303-2024-10-11)
  * **Documentation**: Documentation update: added support notices to each API action.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.65.3](service/s3/CHANGELOG.md#v1653-2024-10-11)
  * **Bug Fix**: **BREAKING CHANGE**: S3 ReplicationRuleFilter and LifecycleRuleFilter shapes are being changed from union to structure types

# Release (2024-10-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.37.3](service/acmpca/CHANGELOG.md#v1373-2024-10-10)
  * **Documentation**: Documentation updates for AWS Private CA.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.43.0](service/databasemigrationservice/CHANGELOG.md#v1430-2024-10-10)
  * **Feature**: Introduces DescribeDataMigrations, CreateDataMigration, ModifyDataMigration, DeleteDataMigration, StartDataMigration, StopDataMigration operations to SDK. Provides FailedDependencyFault error message.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.182.0](service/ec2/CHANGELOG.md#v11820-2024-10-10)
  * **Feature**: This release adds support for assigning the billing of shared Amazon EC2 On-Demand Capacity Reservations.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.47.3](service/ecs/CHANGELOG.md#v1473-2024-10-10)
  * **Documentation**: This is a documentation only release that updates to documentation to let customers know that Amazon Elastic Inference is no longer available.
* `github.com/aws/aws-sdk-go-v2/service/elasticinference`: [v1.23.3](service/elasticinference/CHANGELOG.md#v1233-2024-10-10)
  * **Documentation**: Elastic Inference - Documentation update to add service shutdown notice.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.20.0](service/iotfleetwise/CHANGELOG.md#v1200-2024-10-10)
  * **Feature**: Refine campaign related API validations
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.14.0](service/neptunegraph/CHANGELOG.md#v1140-2024-10-10)
  * **Feature**: Support for 16 m-NCU graphs available through account allowlisting
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.45.0](service/outposts/CHANGELOG.md#v1450-2024-10-10)
  * **Feature**: Adding new "DELIVERED" enum value for Outposts Order status
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.33.0](service/route53resolver/CHANGELOG.md#v1330-2024-10-10)
  * **Feature**: Route 53 Resolver Forwarding Rules can now include a server name indication (SNI) in the target address for rules that use the DNS-over-HTTPS (DoH) protocol. When a DoH-enabled Outbound Resolver Endpoint forwards a request to a DoH server, it will provide the SNI in the TLS handshake.
* `github.com/aws/aws-sdk-go-v2/service/socialmessaging`: [v1.0.0](service/socialmessaging/CHANGELOG.md#v100-2024-10-10)
  * **Release**: New AWS service client module
  * **Feature**: This release for AWS End User Messaging includes a public SDK, providing a suite of APIs that enable sending WhatsApp messages to end users.

# Release (2024-10-09)

## General Highlights
* **Bug Fix**: Fixup some integration tests.

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.35.0](service/codepipeline/CHANGELOG.md#v1350-2024-10-09)
  * **Feature**: AWS CodePipeline introduces a Compute category

# Release (2024-10-08)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chime`: [v1.34.2](service/chime/CHANGELOG.md#v1342-2024-10-08)
  * **Documentation**: Doc-only update to generate deprecated annotation for services that have been marked as deprecated.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.43.0](service/elasticache/CHANGELOG.md#v1430-2024-10-08)
  * **Feature**: AWS ElastiCache SDK now supports using APIs with newly launched Valkey engine. Please refer to updated AWS ElastiCache public documentation for detailed information on API usage.
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.24.0](service/memorydb/CHANGELOG.md#v1240-2024-10-08)
  * **Feature**: Amazon MemoryDB SDK now supports all APIs for newly launched Valkey engine. Please refer to the updated Amazon MemoryDB public documentation for detailed information on API usage.
* `github.com/aws/aws-sdk-go-v2/service/sms`: [v1.24.2](service/sms/CHANGELOG.md#v1242-2024-10-08)
  * **Documentation**: Doc-only update to generate deprecated annotation for services that have been marked as deprecated.

# Release (2024-10-07)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.32.1
  * **Bug Fix**: Remove private metrics collection APIs. These APIs were annotated at the package level that they should not be used by callers and could be removed at any time. With the release of self-instrumented clients for SDK metrics, this internal code is obsolete.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.32.1](service/dataexchange/CHANGELOG.md#v1321-2024-10-07)
  * **Bug Fix**: Allow serialization of headers with empty string for prefix headers
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.6.0](service/deadline/CHANGELOG.md#v160-2024-10-07)
  * **Feature**: Add support for using the template from a previous job during job creation and listing parameter definitions for a job.
* `github.com/aws/aws-sdk-go-v2/service/marketplacereporting`: [v1.1.1](service/marketplacereporting/CHANGELOG.md#v111-2024-10-07)
  * **Documentation**: Documentation-only update for AWS Marketplace Reporting API.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.12.0](service/qconnect/CHANGELOG.md#v1120-2024-10-07)
  * **Feature**: This release adds support for the following capabilities: Configuration of the Gen AI system via AIAgent and AIPrompts. Integration support for Bedrock Knowledge Base.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.49.0](service/redshift/CHANGELOG.md#v1490-2024-10-07)
  * **Feature**: Add validation pattern to S3KeyPrefix on the EnableLogging API
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.65.1](service/s3/CHANGELOG.md#v1651-2024-10-07)
  * **Bug Fix**: **CHANGE IN BEHAVIOR**: Allow serialization of headers with empty string for prefix headers. We are deploying this fix because the behavior is actively preventing users from transmitting keys with empty values to the service. If you were setting metadata keys with empty values before this change, they will now actually be sent to the service.

# Release (2024-10-04)

## General Highlights
* **Feature**: Add support for HTTP client metrics.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.181.0](service/ec2/CHANGELOG.md#v11810-2024-10-04)
  * **Feature**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/iotdataplane`: [v1.26.0](service/iotdataplane/CHANGELOG.md#v1260-2024-10-04)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.

# Release (2024-10-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.33.0](service/codepipeline/CHANGELOG.md#v1330-2024-10-03)
  * **Feature**: AWS CodePipeline introduces Commands action that enables you to easily run shell commands as part of your pipeline execution.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.112.0](service/connect/CHANGELOG.md#v11120-2024-10-03)
  * **Feature**: Public GetMetricDataV2 Grouping increase from 3 to 4
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.180.0](service/ec2/CHANGELOG.md#v11800-2024-10-03)
  * **Feature**: This release includes a new API for modifying instance cpu-options after launch.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.58.0](service/iot/CHANGELOG.md#v1580-2024-10-03)
  * **Feature**: This release adds support for Custom Authentication with X.509 Client Certificates, support for Custom Client Certificate validation, and support for selecting application protocol and authentication type without requiring TLS ALPN for customer's AWS IoT Domain Configurations.
* `github.com/aws/aws-sdk-go-v2/service/marketplacereporting`: [v1.0.0](service/marketplacereporting/CHANGELOG.md#v100-2024-10-03)
  * **Release**: New AWS service client module
  * **Feature**: The AWS Marketplace Reporting service introduces the GetBuyerDashboard API. This API returns a dashboard that provides visibility into your organization's AWS Marketplace agreements and associated spend across the AWS accounts in your organization.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.17.0](service/mediapackagev2/CHANGELOG.md#v1170-2024-10-03)
  * **Feature**: Added support for ClipStartTime on the FilterConfiguration object on OriginEndpoint manifest settings objects. Added support for EXT-X-START tags on produced HLS child playlists.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.75.0](service/quicksight/CHANGELOG.md#v1750-2024-10-03)
  * **Feature**: QuickSight: Add support for exporting and importing folders in AssetBundle APIs

# Release (2024-10-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.40.0](service/appstream/CHANGELOG.md#v1400-2024-10-02)
  * **Feature**: Added support for Automatic Time Zone Redirection on Amazon AppStream 2.0
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.44](service/b2bi/CHANGELOG.md#v100-preview44-2024-10-02)
  * **Feature**: Added and updated APIs to support outbound EDI transformations
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.21.0](service/bedrockagentruntime/CHANGELOG.md#v1210-2024-10-02)
  * **Feature**: Added raw model response and usage metrics to PreProcessing and PostProcessing Trace
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.18.0](service/bedrockruntime/CHANGELOG.md#v1180-2024-10-02)
  * **Feature**: Added new fields to Amazon Bedrock Guardrails trace
* `github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor`: [v1.30.0](service/iotdeviceadvisor/CHANGELOG.md#v1300-2024-10-02)
  * **Feature**: Add clientToken attribute and implement idempotency for CreateSuiteDefinition.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.19.0](service/ivsrealtime/CHANGELOG.md#v1190-2024-10-02)
  * **Feature**: Adds new Stage Health EventErrorCodes applicable to RTMP(S) broadcasts. Bug Fix: Enforces that EncoderConfiguration Video height and width must be even-number values.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.64.0](service/s3/CHANGELOG.md#v1640-2024-10-02)
  * **Feature**: This release introduces a header representing the minimum object size limit for Lifecycle transitions.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.162.0](service/sagemaker/CHANGELOG.md#v11620-2024-10-02)
  * **Feature**: releasing builtinlcc to public
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.47.4](service/workspaces/CHANGELOG.md#v1474-2024-10-02)
  * **Documentation**: WSP is being rebranded to become DCV.

# Release (2024-10-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.22.0](service/bedrockagent/CHANGELOG.md#v1220-2024-10-01)
  * **Feature**: This release adds support to stop an ongoing ingestion job using the StopIngestionJob API in Agents for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.32.0](service/codeartifact/CHANGELOG.md#v1320-2024-10-01)
  * **Feature**: Add support for the dual stack endpoints.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.86.0](service/rds/CHANGELOG.md#v1860-2024-10-01)
  * **Feature**: This release provides additional support for enabling Aurora Limitless Database DB clusters.

# Release (2024-09-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/clouddirectory`: [v1.23.4](service/clouddirectory/CHANGELOG.md#v1234-2024-09-30)
  * **Documentation**: Add examples for API operations in model.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.111.0](service/connect/CHANGELOG.md#v11110-2024-09-30)
  * **Feature**: Amazon Connect introduces StartOutboundChatContact API allowing customers to initiate outbound chat contacts
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.31.4](service/pricing/CHANGELOG.md#v1314-2024-09-30)
  * **Documentation**: Add examples for API operations in model.
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.26.0](service/resourcegroups/CHANGELOG.md#v1260-2024-09-30)
  * **Feature**: This update includes new APIs to support application groups and to allow users to manage resource tag-sync tasks in applications.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.7.0](service/supplychain/CHANGELOG.md#v170-2024-09-30)
  * **Feature**: Release DataLakeDataset, DataIntegrationFlow and ResourceTagging APIs for AWS Supply Chain
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.5.0](service/timestreaminfluxdb/CHANGELOG.md#v150-2024-09-30)
  * **Feature**: Timestream for InfluxDB now supports port configuration and additional customer-modifiable InfluxDB v2 parameters. This release adds Port to the CreateDbInstance and UpdateDbInstance API, and additional InfluxDB v2 parameters to the CreateDbParameterGroup API.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.18.4](service/verifiedpermissions/CHANGELOG.md#v1184-2024-09-30)
  * **Documentation**: Add examples for API operations in model.

# Release (2024-09-27)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.41.0](service/customerprofiles/CHANGELOG.md#v1410-2024-09-27)
  * **Feature**: Introduces optional RoleArn parameter for PutIntegration request and includes RoleArn in the response of PutIntegration, GetIntegration and ListIntegrations
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.74.0](service/quicksight/CHANGELOG.md#v1740-2024-09-27)
  * **Feature**: Adding personalization in QuickSight data stories. Admins can enable or disable personalization through QuickSight settings.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.53.3](service/securityhub/CHANGELOG.md#v1533-2024-09-27)
  * **Documentation**: Documentation updates for AWS Security Hub
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.35.0](service/sesv2/CHANGELOG.md#v1350-2024-09-27)
  * **Feature**: This release adds support for engagement tracking over Https using custom domains.

# Release (2024-09-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.7.0](service/chatbot/CHANGELOG.md#v170-2024-09-26)
  * **Feature**: Return State and StateReason fields for Chatbot Channel Configurations.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.62.0](service/lambda/CHANGELOG.md#v1620-2024-09-26)
  * **Feature**: Reverting Lambda resource-based policy and block public access APIs.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.33.0](service/organizations/CHANGELOG.md#v1330-2024-09-26)
  * **Feature**: Add support for policy operations on the CHATBOT_POLICY policy type.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.1.3](service/pcs/CHANGELOG.md#v113-2024-09-26)
  * **Documentation**: AWS PCS API documentation - Edited the description of the iamInstanceProfileArn parameter of the CreateComputeNodeGroup and UpdateComputeNodeGroup actions; edited the description of the SlurmCustomSetting data type to list the supported parameters for clusters and compute node groups.
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.24.3](service/rdsdata/CHANGELOG.md#v1243-2024-09-26)
  * **Documentation**: Documentation update for RDS Data API to reflect support for Aurora MySQL Serverless v2 and Provisioned DB clusters.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.161.0](service/sagemaker/CHANGELOG.md#v11610-2024-09-26)
  * **Feature**: Adding `TagPropagation` attribute to Sagemaker API

# Release (2024-09-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.43.2](service/cloudtrail/CHANGELOG.md#v1432-2024-09-25)
  * **Documentation**: Doc-only update for CloudTrail network activity events release (in preview)
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.179.1](service/ec2/CHANGELOG.md#v11791-2024-09-25)
  * **Documentation**: Updates to documentation for the transit gateway security group referencing feature.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.48.2](service/fsx/CHANGELOG.md#v1482-2024-09-25)
  * **Documentation**: Doc-only update to address Lustre S3 hard-coded names.

# Release (2024-09-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.19.0](service/bedrock/CHANGELOG.md#v1190-2024-09-24)
  * **Feature**: Add support for Cross Region Inference in Bedrock Model Evaluations.
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.27.0](service/budgets/CHANGELOG.md#v1270-2024-09-24)
  * **Feature**: Releasing minor partitional endpoint updates
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.31.0](service/kinesis/CHANGELOG.md#v1310-2024-09-24)
  * **Feature**: This release includes support to add tags when creating a stream
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.14.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1140-2024-09-24)
  * **Feature**: AWS End User Messaging SMS-Voice V2 has added support for resource policies. Use the three new APIs to create, view, edit, and delete resource policies.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.160.0](service/sagemaker/CHANGELOG.md#v11600-2024-09-24)
  * **Feature**: Adding `HiddenInstanceTypes` and `HiddenSageMakerImageVersionAliases` attribute to SageMaker API

# Release (2024-09-23)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.26.1](service/apigateway/CHANGELOG.md#v1261-2024-09-23)
  * **Documentation**: Documentation updates for Amazon API Gateway
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.46.0](service/athena/CHANGELOG.md#v1460-2024-09-23)
  * **Feature**: List/Get/Update/Delete/CreateDataCatalog now integrate with AWS Glue connections. Users can create a Glue connection through Athena or use a Glue connection to define their Athena federated parameters.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.21.0](service/bedrockagent/CHANGELOG.md#v1210-2024-09-23)
  * **Feature**: Amazon Bedrock Prompt Flows and Prompt Management now supports using inference profiles to increase throughput and improve resilience.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.179.0](service/ec2/CHANGELOG.md#v11790-2024-09-23)
  * **Feature**: Amazon EC2 G6e instances powered by NVIDIA L40S Tensor Core GPUs are the most cost-efficient GPU instances for deploying generative AI models and the highest performance GPU instances for spatial computing workloads.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.25.0](service/emrserverless/CHANGELOG.md#v1250-2024-09-23)
  * **Feature**: This release adds support for job concurrency and queuing configuration at Application level.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.99.0](service/glue/CHANGELOG.md#v1990-2024-09-23)
  * **Feature**: Added AthenaProperties parameter to Glue Connections, allowing Athena to store service specific properties on Glue Connections.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.85.0](service/rds/CHANGELOG.md#v1850-2024-09-23)
  * **Feature**: Support ComputeRedundancy parameter in ModifyDBShardGroup API. Add DBShardGroupArn in DBShardGroup API response. Remove InvalidMaxAcuFault from CreateDBShardGroup and ModifyDBShardGroup API. Both API will throw InvalidParameterValueException for invalid ACU configuration.
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.14.0](service/resourceexplorer2/CHANGELOG.md#v1140-2024-09-23)
  * **Feature**: AWS Resource Explorer released ListResources feature which allows customers to list all indexed AWS resources within a view.

# Release (2024-09-20)

## General Highlights
* **Feature**: Add tracing and metrics support to service clients.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.35.0](service/dynamodb/CHANGELOG.md#v1350-2024-09-20)
  * **Feature**: Generate and use AWS-account-based endpoints for DynamoDB requests when the account ID is available. The new endpoint URL pattern will be https://<account-id>.ddb.<region>.amazonaws.com. See the documentation for details: https://docs.aws.amazon.com/sdkref/latest/guide/feature-account-endpoints.html.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.34.0](service/neptune/CHANGELOG.md#v1340-2024-09-20)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.159.0](service/sagemaker/CHANGELOG.md#v11590-2024-09-20)
  * **Feature**: Amazon SageMaker now supports using manifest files to specify the location of uncompressed model artifacts within Model Packages
* `github.com/aws/aws-sdk-go-v2/service/sagemakermetrics`: [v1.11.0](service/sagemakermetrics/CHANGELOG.md#v1110-2024-09-20)
  * **Feature**: This release introduces support for the SageMaker Metrics BatchGetMetrics API.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.47.0](service/workspaces/CHANGELOG.md#v1470-2024-09-20)
  * **Feature**: Releasing new ErrorCodes for SysPrep failures during ImageImport and CreateImage process

# Release (2024-09-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codeconnections`: [v1.3.0](service/codeconnections/CHANGELOG.md#v130-2024-09-19)
  * **Feature**: This release adds the PullRequestComment field to CreateSyncConfiguration API input, UpdateSyncConfiguration API input, GetSyncConfiguration API output and ListSyncConfiguration API output
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.97.0](service/glue/CHANGELOG.md#v1970-2024-09-19)
  * **Feature**: This change is for releasing TestConnection api SDK model
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.60.0](service/lambda/CHANGELOG.md#v1600-2024-09-19)
  * **Feature**: Tagging support for Lambda event source mapping, and code signing configuration resources.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.59.0](service/mediaconvert/CHANGELOG.md#v1590-2024-09-19)
  * **Feature**: This release provides support for additional DRM configurations per SPEKE Version 2.0.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.60.0](service/medialive/CHANGELOG.md#v1600-2024-09-19)
  * **Feature**: Adds Bandwidth Reduction Filtering for HD AVC and HEVC encodes, multiplex container settings.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.72.0](service/quicksight/CHANGELOG.md#v1720-2024-09-19)
  * **Feature**: QuickSight: 1. Add new API - ListFoldersForResource. 2. Commit mode adds visibility configuration of Apply button on multi-select controls for authors.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.158.0](service/sagemaker/CHANGELOG.md#v11580-2024-09-19)
  * **Feature**: Introduced support for G6e instance types on SageMaker Studio for JupyterLab and CodeEditor applications.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.22.0](service/workspacesweb/CHANGELOG.md#v1220-2024-09-19)
  * **Feature**: WorkSpaces Secure Browser now enables Administrators to view and manage end-user browsing sessions via Session Management APIs.

# Release (2024-09-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.41.0](service/costexplorer/CHANGELOG.md#v1410-2024-09-18)
  * **Feature**: This release extends the GetReservationPurchaseRecommendation API to support recommendations for Amazon DynamoDB reservations.
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.28.0](service/directoryservice/CHANGELOG.md#v1280-2024-09-18)
  * **Feature**: Added new APIs for enabling, disabling, and describing access to the AWS Directory Service Data API
* `github.com/aws/aws-sdk-go-v2/service/directoryservicedata`: [v1.0.0](service/directoryservicedata/CHANGELOG.md#v100-2024-09-18)
  * **Release**: New AWS service client module
  * **Feature**: Added new AWS Directory Service Data API, enabling you to manage data stored in AWS Directory Service directories. This includes APIs for creating, reading, updating, and deleting directory users, groups, and group memberships.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.47.0](service/guardduty/CHANGELOG.md#v1470-2024-09-18)
  * **Feature**: Add `launchType` and `sourceIPs` fields to GuardDuty findings.
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.3.0](service/mailmanager/CHANGELOG.md#v130-2024-09-18)
  * **Feature**: Introduce a new RuleSet condition evaluation, where customers can set up a StringExpression with a MimeHeader condition. This condition will perform the necessary validation based on the X-header provided by customers.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.83.2](service/rds/CHANGELOG.md#v1832-2024-09-18)
  * **Documentation**: Updates Amazon RDS documentation with information upgrading snapshots with unsupported engine versions for RDS for MySQL and RDS for PostgreSQL.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.62.0](service/s3/CHANGELOG.md#v1620-2024-09-18)
  * **Feature**: Added SSE-KMS support for directory buckets.

# Release (2024-09-17)

## General Highlights
* **Bug Fix**: **BREAKFIX**: Only generate AccountIDEndpointMode config for services that use it. This is a compiler break, but removes no actual functionality, as no services currently use the account ID in endpoint resolution.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.43.0](service/codebuild/CHANGELOG.md#v1430-2024-09-17)
  * **Feature**: GitLab Enhancements - Add support for Self-Hosted GitLab runners in CodeBuild. Add group webhooks
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.34.0](service/ecr/CHANGELOG.md#v1340-2024-09-17)
  * **Feature**: The `DescribeImageScanning` API now includes `fixAvailable`, `exploitAvailable`, and `fixedInVersion` fields to provide more detailed information about the availability of fixes, exploits, and fixed versions for identified image vulnerabilities.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.45.5](service/ecs/CHANGELOG.md#v1455-2024-09-17)
  * **Documentation**: This is a documentation only release to address various tickets.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.59.0](service/lambda/CHANGELOG.md#v1590-2024-09-17)
  * **Feature**: Support for JSON resource-based policies and block public access
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.83.1](service/rds/CHANGELOG.md#v1831-2024-09-17)
  * **Documentation**: Updates Amazon RDS documentation with configuration information about the BYOL model for RDS for Db2.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.53.0](service/ssm/CHANGELOG.md#v1530-2024-09-17)
  * **Feature**: Support for additional levels of cross-account, cross-Region organizational units in Automation. Various documentation updates.

# Release (2024-09-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.27.34](config/CHANGELOG.md#v12734-2024-09-16)
  * **Bug Fix**: Read `AWS_CONTAINER_CREDENTIALS_FULL_URI` env variable if set when reading a profile with `credential_source`. Also ensure `AWS_CONTAINER_CREDENTIALS_RELATIVE_URI` is always read before it
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.17.0](service/bedrock/CHANGELOG.md#v1170-2024-09-16)
  * **Feature**: This feature adds cross account s3 bucket and VPC support to ModelInvocation jobs. To use a cross account bucket, pass in the accountId of the bucket to s3BucketOwner in the ModelInvocationJobInputDataConfig or ModelInvocationJobOutputDataConfig.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.56.0](service/iot/CHANGELOG.md#v1560-2024-09-16)
  * **Feature**: This release adds additional enhancements to AWS IoT Device Management Software Package Catalog and Jobs. It also adds SBOM support in Software Package Version.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.59.0](service/medialive/CHANGELOG.md#v1590-2024-09-16)
  * **Feature**: Removing the ON_PREMISE enum from the input settings field.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.31.3](service/organizations/CHANGELOG.md#v1313-2024-09-16)
  * **Documentation**: Doc only update for AWS Organizations that fixes several customer-reported issues
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorscep`: [v1.2.7](service/pcaconnectorscep/CHANGELOG.md#v127-2024-09-16)
  * **Documentation**: This is a general availability (GA) release of Connector for SCEP, a feature of AWS Private CA. Connector for SCEP links your SCEP-enabled and mobile device management systems to AWS Private CA for digital signature installation and certificate management.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.83.0](service/rds/CHANGELOG.md#v1830-2024-09-16)
  * **Feature**: Launching Global Cluster tagging.

# Release (2024-09-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.24.4](service/amplify/CHANGELOG.md#v1244-2024-09-13)
  * **Documentation**: Doc only update to Amplify to explain platform setting for Next.js 14 SSG only applications
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.38.4](service/ivs/CHANGELOG.md#v1384-2024-09-13)
  * **Documentation**: Updates to all tags descriptions.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.14.8](service/ivschat/CHANGELOG.md#v1148-2024-09-13)
  * **Documentation**: Updates to all tags descriptions.

# Release (2024-09-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.44.0](service/cognitoidentityprovider/CHANGELOG.md#v1440-2024-09-12)
  * **Feature**: Added email MFA option to user pools with advanced security features.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.37.0](service/elasticloadbalancingv2/CHANGELOG.md#v1370-2024-09-12)
  * **Feature**: Correct incorrectly mapped error in ELBv2 waiters
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.43.0](service/emr/CHANGELOG.md#v1430-2024-09-12)
  * **Feature**: Update APIs to allow modification of ODCR options, allocation strategy, and InstanceTypeConfigs on running InstanceFleet clusters.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.96.0](service/glue/CHANGELOG.md#v1960-2024-09-12)
  * **Feature**: AWS Glue is introducing two new optimizers for Apache Iceberg tables: snapshot retention and orphan file deletion. Customers can enable these optimizers and customize their configurations to perform daily maintenance tasks on their Iceberg tables based on their specific requirements.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.58.0](service/mediaconvert/CHANGELOG.md#v1580-2024-09-12)
  * **Feature**: This release includes support for dynamic video overlay workflows, including picture-in-picture and squeezeback
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.82.5](service/rds/CHANGELOG.md#v1825-2024-09-12)
  * **Documentation**: This release adds support for the os-upgrade pending maintenance action for Amazon Aurora DB clusters.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.32.0](service/storagegateway/CHANGELOG.md#v1320-2024-09-12)
  * **Feature**: The S3 File Gateway now supports DSSE-KMS encryption. A new parameter EncryptionType is added to these APIs: CreateSmbFileShare, CreateNfsFileShare, UpdateSmbFileShare, UpdateNfsFileShare, DescribeSmbFileShares, DescribeNfsFileShares. Also, in favor of EncryptionType, KmsEncrypted is deprecated.
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.27.0](service/synthetics/CHANGELOG.md#v1270-2024-09-12)
  * **Feature**: This release introduces two features. The first is tag replication, which allows for the propagation of canary tags onto Synthetics related resources, such as Lambda functions. The second is a limit increase in canary name length, which has now been increased from 21 to 255 characters.

# Release (2024-09-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.19.0](service/bedrockagent/CHANGELOG.md#v1190-2024-09-11)
  * **Feature**: Amazon Bedrock Knowledge Bases now supports using inference profiles to increase throughput and improve resilience.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.19.0](service/bedrockagentruntime/CHANGELOG.md#v1190-2024-09-11)
  * **Feature**: Amazon Bedrock Knowledge Bases now supports using inference profiles to increase throughput and improve resilience.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.33.0](service/ecr/CHANGELOG.md#v1330-2024-09-11)
  * **Feature**: Added KMS_DSSE to EncryptionType
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.46.0](service/guardduty/CHANGELOG.md#v1460-2024-09-11)
  * **Feature**: Add support for new statistic types in GetFindingsStatistics.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.47.0](service/lexmodelsv2/CHANGELOG.md#v1470-2024-09-11)
  * **Feature**: Support new Polly voice engines in VoiceSettings: long-form and generative
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.58.0](service/medialive/CHANGELOG.md#v1580-2024-09-11)
  * **Feature**: Adds AV1 Codec support, SRT ouputs, and MediaLive Anywhere support.

# Release (2024-09-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.17.7](service/chimesdkvoice/CHANGELOG.md#v1177-2024-09-10)
  * **Documentation**: Documentation-only update that clarifies the ValidateE911Address action of the Amazon Chime SDK Voice APIs.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.15.0](service/pipes/CHANGELOG.md#v1150-2024-09-10)
  * **Feature**: This release adds support for customer managed KMS keys in Amazon EventBridge Pipe
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.52.3](service/securityhub/CHANGELOG.md#v1523-2024-09-10)
  * **Documentation**: Documentation update for Security Hub

# Release (2024-09-09)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.34.9](service/dynamodb/CHANGELOG.md#v1349-2024-09-09)
  * **Documentation**: Doc-only update for DynamoDB. Added information about async behavior for TagResource and UntagResource APIs and updated the description of ResourceInUseException.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.36.0](service/elasticloadbalancingv2/CHANGELOG.md#v1360-2024-09-09)
  * **Feature**: Add paginators for the ELBv2 DescribeListenerCertificates and DescribeRules APIs. Fix broken waiter for the ELBv2 DescribeLoadBalancers API.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.17.0](service/ivsrealtime/CHANGELOG.md#v1170-2024-09-09)
  * **Feature**: IVS Real-Time now offers customers the ability to broadcast to Stages using RTMP(S).
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.36.0](service/kafka/CHANGELOG.md#v1360-2024-09-09)
  * **Feature**: Amazon MSK Replicator can now replicate data to identically named topics between MSK clusters within the same AWS Region or across different AWS Regions.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.157.0](service/sagemaker/CHANGELOG.md#v11570-2024-09-09)
  * **Feature**: Amazon Sagemaker supports orchestrating SageMaker HyperPod clusters with Amazon EKS
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.30.0](service/sagemakerruntime/CHANGELOG.md#v1300-2024-09-09)
  * **Feature**: AWS SageMaker Runtime feature: Add sticky routing to support stateful inference models.

# Release (2024-09-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.1.0](service/qapps/CHANGELOG.md#v110-2024-09-06)
  * **Feature**: Adds UpdateLibraryItemMetadata api to change status of app for admin verification feature and returns isVerified field in any api returning the app or library item.

# Release (2024-09-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.4.0](service/applicationsignals/CHANGELOG.md#v140-2024-09-05)
  * **Feature**: Amazon CloudWatch Application Signals now supports creating Service Level Objectives using a new calculation type. Users can now create SLOs which are configured with request-based SLIs to help meet their specific business requirements.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.31.4](service/codepipeline/CHANGELOG.md#v1314-2024-09-05)
  * **Documentation**: Updates to add recent notes to APIs and to replace example S3 bucket names globally.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.109.0](service/connect/CHANGELOG.md#v11090-2024-09-05)
  * **Feature**: Amazon Connect Custom Vocabulary now supports Catalan (Spain), Danish (Denmark), Dutch (Netherlands), Finnish (Finland), Indonesian (Indonesia), Malay (Malaysia), Norwegian Bokmal (Norway), Polish (Poland), Swedish (Sweden), and Tagalog/Filipino (Philippines).
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.34.0](service/gamelift/CHANGELOG.md#v1340-2024-09-05)
  * **Feature**: Amazon GameLift provides additional events for tracking the fleet creation process.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.29.0](service/kinesisanalyticsv2/CHANGELOG.md#v1290-2024-09-05)
  * **Feature**: Support for Flink 1.20 in Managed Service for Apache Flink
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.156.0](service/sagemaker/CHANGELOG.md#v11560-2024-09-05)
  * **Feature**: Amazon SageMaker now supports idle shutdown of JupyterLab and CodeEditor applications on SageMaker Studio.

# Release (2024-09-04)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.36.0](service/appsync/CHANGELOG.md#v1360-2024-09-04)
  * **Feature**: Adds new logging levels (INFO and DEBUG) for additional log output control
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.18.0](service/bedrockagent/CHANGELOG.md#v1180-2024-09-04)
  * **Feature**: Add support for user metadata inside PromptVariant.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.39.0](service/cloudwatchlogs/CHANGELOG.md#v1390-2024-09-04)
  * **Feature**: Update to support new APIs for delivery of logs from AWS services.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.26.6](service/finspace/CHANGELOG.md#v1266-2024-09-04)
  * **Documentation**: Updates Finspace documentation for smaller instances.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.28.0](service/fis/CHANGELOG.md#v1280-2024-09-04)
  * **Feature**: This release adds safety levers, a new mechanism to stop all running experiments and prevent new experiments from starting.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.47.0](service/s3control/CHANGELOG.md#v1470-2024-09-04)
  * **Feature**: Amazon Simple Storage Service /S3 Access Grants / Features : This release launches new Access Grants API - ListCallerAccessGrants.

# Release (2024-09-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.30.5
  * **Bug Fix**: Change requestPayer behaviour from signedHeader to hoisted query parameter 
  * **Bug Fix**: refactoring of buildQuery to accept a map of hand maintained headers to lowercase because of an S3 limitation
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.108.0](service/connect/CHANGELOG.md#v11080-2024-09-03)
  * **Feature**: Release ReplicaConfiguration as part of DescribeInstance
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.20.0](service/datazone/CHANGELOG.md#v1200-2024-09-03)
  * **Feature**: Add support to let data publisher specify a subset of the data asset that a subscriber will have access to based on the asset filters provided, when accepting a subscription request.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.35.0](service/elasticloadbalancingv2/CHANGELOG.md#v1350-2024-09-03)
  * **Feature**: This release adds support for configuring TCP idle timeout on NLB and GWLB listeners.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.33.0](service/mediaconnect/CHANGELOG.md#v1330-2024-09-03)
  * **Feature**: AWS Elemental MediaConnect introduces thumbnails for Flow source monitoring. Thumbnails provide still image previews of the live content feeding your MediaConnect Flow allowing you to easily verify that your source is operating as expected.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.57.0](service/medialive/CHANGELOG.md#v1570-2024-09-03)
  * **Feature**: Added MinQP as a Rate Control option for H264 and H265 encodes.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.155.0](service/sagemaker/CHANGELOG.md#v11550-2024-09-03)
  * **Feature**: Amazon SageMaker now supports automatic mounting of a user's home folder in the Amazon Elastic File System (EFS) associated with the SageMaker Studio domain to their Studio Spaces to enable users to share data between their own private spaces.
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.3.0](service/timestreaminfluxdb/CHANGELOG.md#v130-2024-09-03)
  * **Feature**: Timestream for InfluxDB now supports compute scaling and deployment type conversion. This release adds the DbInstanceType and DeploymentType parameters to the UpdateDbInstance API.

# Release (2024-08-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.37.0](service/backup/CHANGELOG.md#v1370-2024-08-30)
  * **Feature**: The latest update introduces two new attributes, VaultType and VaultState, to the DescribeBackupVault and ListBackupVaults APIs. The VaultState attribute reflects the current status of the vault, while the VaultType attribute indicates the specific category of the vault.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.38.0](service/cloudwatchlogs/CHANGELOG.md#v1380-2024-08-30)
  * **Feature**: This release introduces a new optional parameter: Entity, in PutLogEvents request
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.19.0](service/datazone/CHANGELOG.md#v1190-2024-08-30)
  * **Feature**: Amazon DataZone now adds new governance capabilities of Domain Units for organization within your Data Domains, and Authorization Policies for tighter controls.
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.28.0](service/redshiftdata/CHANGELOG.md#v1280-2024-08-30)
  * **Feature**: The release include the new Redshift DataAPI feature for session use, customer execute query with --session-keep-alive-seconds parameter and can submit follow-up queries to same sessions with returned`session-id`
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.34.6](service/sqs/CHANGELOG.md#v1346-2024-08-30)
  * **Bug Fix**: Fix issue where SDK could not send a VisibilityTimeout of 0 in a ChangeMessageVisibilityBatchRequestEntry.

# Release (2024-08-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.18.0](service/bedrockagentruntime/CHANGELOG.md#v1180-2024-08-29)
  * **Feature**: Lifting the maximum length on Bedrock KnowledgeBase RetrievalFilter array
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.16.0](service/bedrockruntime/CHANGELOG.md#v1160-2024-08-29)
  * **Feature**: Add support for imported-model in invokeModel and InvokeModelWithResponseStream.
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.37.0](service/personalize/CHANGELOG.md#v1370-2024-08-29)
  * **Feature**: This releases ability to update automatic training scheduler for customer solutions
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.71.0](service/quicksight/CHANGELOG.md#v1710-2024-08-29)
  * **Feature**: Increased Character Limit for Dataset Calculation Field expressions
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.31.0](service/sfn/CHANGELOG.md#v1310-2024-08-29)
  * **Feature**: This release adds support for static analysis to ValidateStateMachineDefinition API, which can now return optional WARNING diagnostics for semantic errors on the definition of an Amazon States Language (ASL) state machine.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.52.0](service/wafv2/CHANGELOG.md#v1520-2024-08-29)
  * **Feature**: The minimum request rate for a rate-based rule is now 10. Before this, it was 100.

# Release (2024-08-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.32.0](service/appconfig/CHANGELOG.md#v1320-2024-08-28)
  * **Feature**: This release adds support for deletion protection, which is a safety guardrail to prevent the unintentional deletion of a recently used AWS AppConfig Configuration Profile or Environment. This also includes a change to increase the maximum length of the Name parameter in UpdateConfigurationProfile.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.18.0](service/datazone/CHANGELOG.md#v1180-2024-08-28)
  * **Feature**: Update regex to include dot character to be consistent with IAM role creation in the authorized principal field for create and update subscription target.
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.26.0](service/devicefarm/CHANGELOG.md#v1260-2024-08-28)
  * **Feature**: This release removed support for Calabash, UI Automation, Built-in Explorer, remote access record, remote access replay, and web performance profile framework in ScheduleRun API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.177.0](service/ec2/CHANGELOG.md#v11770-2024-08-28)
  * **Feature**: Amazon VPC IP Address Manager (IPAM) now allows customers to provision IPv4 CIDR blocks and allocate Elastic IP Addresses directly from IPAM pools with public IPv4 space
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.17.0](service/internetmonitor/CHANGELOG.md#v1170-2024-08-28)
  * **Feature**: Adds new querying types to show overall traffic suggestion information for monitors
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.0.0](service/pcs/CHANGELOG.md#v100-2024-08-28)
  * **Release**: New AWS service client module
  * **Feature**: Introducing AWS Parallel Computing Service (AWS PCS), a new service makes it easy to setup and manage high performance computing (HPC) clusters, and build scientific and engineering models at virtually any scale on AWS.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.61.0](service/s3/CHANGELOG.md#v1610-2024-08-28)
  * **Feature**: Add presignPost for s3 PutObject
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.46.1](service/workspaces/CHANGELOG.md#v1461-2024-08-28)
  * **Documentation**: Documentation-only update that clarifies the StartWorkspaces and StopWorkspaces actions, and a few other minor edits.

# Release (2024-08-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.16.0](service/bedrock/CHANGELOG.md#v1160-2024-08-27)
  * **Feature**: Amazon Bedrock SDK updates for Inference Profile.
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.5.0](service/chatbot/CHANGELOG.md#v150-2024-08-27)
  * **Feature**: Update documentation to be consistent with the API docs
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.24.0](service/omics/CHANGELOG.md#v1240-2024-08-27)
  * **Feature**: Adds data provenance to import jobs from read sets and references
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.43.0](service/polly/CHANGELOG.md#v1430-2024-08-27)
  * **Feature**: Amazon Polly adds 2 new voices: Jitka (cs-CZ) and Sabrina (de-CH).

# Release (2024-08-26)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/credentials`: [v1.17.30](credentials/CHANGELOG.md#v11730-2024-08-26)
  * **Bug Fix**: Save SSO cached token expiry in UTC to ensure cross-SDK compatibility.
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.15.0](feature/dynamodb/attributevalue/CHANGELOG.md#v1150-2024-08-26)
  * **Feature**: Add Encoder option to obey omitempty tag for NULL attribute values.
* `github.com/aws/aws-sdk-go-v2/feature/dynamodbstreams/attributevalue`: [v1.14.0](feature/dynamodbstreams/attributevalue/CHANGELOG.md#v1140-2024-08-26)
  * **Feature**: Add Encoder option to obey omitempty tag for NULL attribute values.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.41.0](service/iotsitewise/CHANGELOG.md#v1410-2024-08-26)
  * **Feature**: AWS IoT SiteWise now supports versioning for asset models. It enables users to retrieve active version of their asset model and perform asset model writes with optimistic lock.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.46.0](service/workspaces/CHANGELOG.md#v1460-2024-08-26)
  * **Feature**: This release adds support for creating and managing directories that use AWS IAM Identity Center as user identity source. Such directories can be used to create non-Active Directory domain joined WorkSpaces Personal.Updated RegisterWorkspaceDirectory and DescribeWorkspaceDirectories APIs.

# Release (2024-08-23)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.27.30](config/CHANGELOG.md#v12730-2024-08-23)
  * **Bug Fix**: Don't fail credentials unit tests if credentials are found on a file
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.17.0](service/bedrockagent/CHANGELOG.md#v1170-2024-08-23)
  * **Feature**: Releasing the support for Action User Confirmation.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.17.0](service/bedrockagentruntime/CHANGELOG.md#v1170-2024-08-23)
  * **Feature**: Releasing the support for Action User Confirmation.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.42.1](service/codebuild/CHANGELOG.md#v1421-2024-08-23)
  * **Documentation**: Added support for the MAC_ARM environment type for CodeBuild fleets.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.31.0](service/organizations/CHANGELOG.md#v1310-2024-08-23)
  * **Feature**: Releasing minor partitional endpoint updates.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.11.0](service/qbusiness/CHANGELOG.md#v1110-2024-08-23)
  * **Feature**: Amazon QBusiness: Enable support for SAML and OIDC federation through AWS IAM Identity Provider integration.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.5.5](service/supplychain/CHANGELOG.md#v155-2024-08-23)
  * **Documentation**: Update API documentation to clarify the event SLA as well as the data model expectations

# Release (2024-08-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.43.5](service/autoscaling/CHANGELOG.md#v1435-2024-08-22)
  * **Documentation**: Amazon EC2 Auto Scaling now provides EBS health check to manage EC2 instance replacement
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.15.0](service/bedrock/CHANGELOG.md#v1150-2024-08-22)
  * **Feature**: Amazon Bedrock Evaluation BatchDeleteEvaluationJob API allows customers to delete evaluation jobs under terminated evaluation job statuses - Stopped, Failed, or Completed. Customers can submit a batch of 25 evaluation jobs to be deleted at once.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.31.0](service/emrcontainers/CHANGELOG.md#v1310-2024-08-22)
  * **Feature**: Correct endpoint for FIPS is configured for US Gov Regions.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.30.0](service/inspector2/CHANGELOG.md#v1300-2024-08-22)
  * **Feature**: Add enums for Agentless scan statuses and EC2 enablement error states
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.70.0](service/quicksight/CHANGELOG.md#v1700-2024-08-22)
  * **Feature**: Explicit query for authors and dashboard viewing sharing for embedded users
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.43.0](service/route53/CHANGELOG.md#v1430-2024-08-22)
  * **Feature**: Amazon Route 53 now supports the Asia Pacific (Malaysia) Region (ap-southeast-5) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

# Release (2024-08-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.176.0](service/ec2/CHANGELOG.md#v11760-2024-08-21)
  * **Feature**: DescribeInstanceStatus now returns health information on EBS volumes attached to Nitro instances
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.95.0](service/glue/CHANGELOG.md#v1950-2024-08-21)
  * **Feature**: Add optional field JobRunQueuingEnabled to CreateJob and UpdateJob APIs.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.58.0](service/lambda/CHANGELOG.md#v1580-2024-08-21)
  * **Feature**: Release FilterCriteria encryption for Lambda EventSourceMapping,  enabling customers to encrypt their filter criteria using a customer-owned KMS key.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.52.0](service/securityhub/CHANGELOG.md#v1520-2024-08-21)
  * **Feature**: Security Hub documentation and definition updates
* `github.com/aws/aws-sdk-go-v2/service/ses`: [v1.26.0](service/ses/CHANGELOG.md#v1260-2024-08-21)
  * **Feature**: Enable email receiving customers to provide SES with access to their S3 buckets via an IAM role for "Deliver to S3 Action"

# Release (2024-08-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.45.1](service/ecs/CHANGELOG.md#v1451-2024-08-20)
  * **Documentation**: Documentation only release to address various tickets
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.14.0](service/opensearchserverless/CHANGELOG.md#v1140-2024-08-20)
  * **Feature**: Added FailureCode and FailureMessage to BatchGetCollectionResponse for BatchGetVPCEResponse for non-Active Collection and VPCE.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.60.0](service/s3/CHANGELOG.md#v1600-2024-08-20)
  * **Feature**: Amazon Simple Storage Service / Features : Add support for conditional writes for PutObject and CompleteMultipartUpload APIs.

# Release (2024-08-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.14.0](service/bedrock/CHANGELOG.md#v1140-2024-08-19)
  * **Feature**: Amazon Bedrock Batch Inference/ Model Invocation is a feature which allows customers to asynchronously run inference on a large set of records/files stored in S3.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.42.0](service/codebuild/CHANGELOG.md#v1420-2024-08-19)
  * **Feature**: AWS CodeBuild now supports creating fleets with macOS platform for running builds.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.3.0](service/deadline/CHANGELOG.md#v130-2024-08-19)
  * **Feature**: This release adds additional search fields and provides sorting by multiple fields.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.57.0](service/lambda/CHANGELOG.md#v1570-2024-08-19)
  * **Feature**: Release Lambda FunctionRecursiveConfig, enabling customers to turn recursive loop detection on or off on individual functions. This release adds two new APIs, GetFunctionRecursionConfig and PutFunctionRecursionConfig.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.16.0](service/ssmsap/CHANGELOG.md#v1160-2024-08-19)
  * **Feature**: Add new attributes to the outputs of GetApplication and GetDatabase APIs.

# Release (2024-08-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.44.0](service/batch/CHANGELOG.md#v1440-2024-08-16)
  * **Feature**: Improvements of integration between AWS Batch and EC2.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.29.0](service/inspector2/CHANGELOG.md#v1290-2024-08-16)
  * **Feature**: Update the correct format of key and values for resource tags
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.69.0](service/quicksight/CHANGELOG.md#v1690-2024-08-16)
  * **Feature**: Amazon QuickSight launches Customer Managed Key (CMK) encryption for Data Source metadata
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.154.0](service/sagemaker/CHANGELOG.md#v11540-2024-08-16)
  * **Feature**: Introduce Endpoint and EndpointConfig Arns in sagemaker:ListPipelineExecutionSteps API response
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.33.0](service/sesv2/CHANGELOG.md#v1330-2024-08-16)
  * **Feature**: Marking use case description field of account details as deprecated.

# Release (2024-08-15)

## General Highlights
* **Dependency Update**: Bump minimum Go version to 1.21.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.37.0](service/docdb/CHANGELOG.md#v1370-2024-08-15)
  * **Feature**: This release adds Global Cluster Failover capability which enables you to change your global cluster's primary AWS region, the region that serves writes, during a regional outage. Performing a failover action preserves your Global Cluster setup.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.45.0](service/ecs/CHANGELOG.md#v1450-2024-08-15)
  * **Feature**: This release introduces a new ContainerDefinition configuration to support the customer-managed keys for ECS container restart feature.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.35.0](service/iam/CHANGELOG.md#v1350-2024-08-15)
  * **Feature**: Make the LastUsedDate field in the GetAccessKeyLastUsed response optional. This may break customers who only call the API for access keys with a valid LastUsedDate. This fixes a deserialization issue for access keys without a LastUsedDate, because the field was marked as required but could be null.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.59.0](service/s3/CHANGELOG.md#v1590-2024-08-15)
  * **Feature**: Amazon Simple Storage Service / Features  : Adds support for pagination in the S3 ListBuckets API.

# Release (2024-08-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.41.0](service/codebuild/CHANGELOG.md#v1410-2024-08-14)
  * **Feature**: AWS CodeBuild now supports using Secrets Manager to store git credentials and using multiple source credentials in a single project.

# Release (2024-08-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.24.0](service/amplify/CHANGELOG.md#v1240-2024-08-13)
  * **Feature**: Add a new field "cacheConfig" that enables users to configure the CDN cache settings for an App
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.38.0](service/appstream/CHANGELOG.md#v1380-2024-08-13)
  * **Feature**: This release includes following new APIs: CreateThemeForStack, DescribeThemeForStack, UpdateThemeForStack, DeleteThemeForStack to support custom branding programmatically.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.27.0](service/fis/CHANGELOG.md#v1270-2024-08-13)
  * **Feature**: This release adds support for additional error information on experiment failure. It adds the error code, location, and account id on relevant failures to the GetExperiment and ListExperiment API responses.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.94.0](service/glue/CHANGELOG.md#v1940-2024-08-13)
  * **Feature**: Add AttributesToGet parameter support for Glue GetTables
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.11.0](service/neptunegraph/CHANGELOG.md#v1110-2024-08-13)
  * **Feature**: Amazon Neptune Analytics provides a new option for customers to load data into a graph using the RDF (Resource Description Framework) NTRIPLES format. When loading NTRIPLES files, use the value `convertToIri` for the `blankNodeHandling` parameter.

# Release (2024-08-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.37.4](service/computeoptimizer/CHANGELOG.md#v1374-2024-08-12)
  * **Documentation**: Doc only update for Compute Optimizer that fixes several customer-reported issues relating to ECS finding classifications
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.175.0](service/ec2/CHANGELOG.md#v11750-2024-08-12)
  * **Feature**: This release adds new capabilities to manage On-Demand Capacity Reservations including the ability to split your reservation, move capacity between reservations, and modify the instance eligibility of your reservation.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.48.0](service/eks/CHANGELOG.md#v1480-2024-08-12)
  * **Feature**: Added support for new AL2023 GPU AMIs to the supported AMITypes.
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.29.4](service/groundstation/CHANGELOG.md#v1294-2024-08-12)
  * **Documentation**: Updating documentation for OEMEphemeris to link to AWS Ground Station User Guide
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.56.0](service/medialive/CHANGELOG.md#v1560-2024-08-12)
  * **Feature**: AWS Elemental MediaLive now supports now supports editing the PID values for a Multiplex.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.153.0](service/sagemaker/CHANGELOG.md#v11530-2024-08-12)
  * **Feature**: Releasing large data support as part of CreateAutoMLJobV2 in SageMaker Autopilot and CreateDomain API for SageMaker Canvas.

# Release (2024-08-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.43.1](service/cognitoidentityprovider/CHANGELOG.md#v1431-2024-08-09)
  * **Documentation**: Fixed a description of AdvancedSecurityAdditionalFlows in Amazon Cognito user pool configuration.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.107.0](service/connect/CHANGELOG.md#v11070-2024-08-09)
  * **Feature**: This release supports adding RoutingCriteria via UpdateContactRoutingData public API.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.52.4](service/ssm/CHANGELOG.md#v1524-2024-08-09)
  * **Documentation**: Systems Manager doc-only updates for August 2024.

# Release (2024-08-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.43.0](service/cognitoidentityprovider/CHANGELOG.md#v1430-2024-08-08)
  * **Feature**: Added support for threat protection for custom authentication in Amazon Cognito user pools.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.174.0](service/ec2/CHANGELOG.md#v11740-2024-08-08)
  * **Feature**: Launch of private IPv6 addressing for VPCs and Subnets. VPC IPAM supports the planning and monitoring of private IPv6 usage.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.93.0](service/glue/CHANGELOG.md#v1930-2024-08-08)
  * **Feature**: This release adds support to retrieve the validation status when creating or updating Glue Data Catalog Views. Also added is support for BasicCatalogTarget partition keys.

# Release (2024-08-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.28.0](service/appintegrations/CHANGELOG.md#v1280-2024-08-07)
  * **Feature**: Updated CreateDataIntegration and CreateDataIntegrationAssociation API to support bulk data export from Amazon Connect Customer Profiles to the customer S3 bucket.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.92.0](service/glue/CHANGELOG.md#v1920-2024-08-07)
  * **Feature**: Introducing AWS Glue Data Quality anomaly detection, a new functionality that uses ML-based solutions to detect data anomalies users have not explicitly defined rules for.

# Release (2024-08-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.16.0](service/bedrockagentruntime/CHANGELOG.md#v1160-2024-08-06)
  * **Feature**: Introduce model invocation output traces for orchestration traces, which contain the model's raw response and usage.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.42.0](service/cognitoidentityprovider/CHANGELOG.md#v1420-2024-08-06)
  * **Feature**: Advanced security feature updates to include password history and log export for Cognito user pools.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.8.0](service/costoptimizationhub/CHANGELOG.md#v180-2024-08-06)
  * **Feature**: This release adds savings percentage support to the ListRecommendationSummaries API.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.45.0](service/workspaces/CHANGELOG.md#v1450-2024-08-06)
  * **Feature**: Added support for BYOL_GRAPHICS_G4DN_WSP IngestionProcess

# Release (2024-08-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.17.0](service/datazone/CHANGELOG.md#v1170-2024-08-05)
  * **Feature**: This releases Data Product feature. Data Products allow grouping data assets into cohesive, self-contained units for ease of publishing for data producers, and ease of finding and accessing for data consumers.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.32.0](service/ecr/CHANGELOG.md#v1320-2024-08-05)
  * **Feature**: Released two new APIs along with documentation updates. The GetAccountSetting API is used to view the current basic scan type version setting for your registry, while the PutAccountSetting API is used to update the basic scan type version for your registry.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.12.0](service/kinesisvideowebrtcstorage/CHANGELOG.md#v1120-2024-08-05)
  * **Feature**: Add JoinStorageSessionAsViewer API
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.27.5](service/pi/CHANGELOG.md#v1275-2024-08-05)
  * **Documentation**: Added a description for the Dimension db.sql.tokenized_id on the DimensionGroup data type page.

# Release (2024-08-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.24.0](service/resiliencehub/CHANGELOG.md#v1240-2024-08-02)
  * **Feature**: Customers are presented with the grouping recommendations and can determine if the recommendations are accurate and apply to their case. This feature simplifies onboarding by organizing resources into appropriate AppComponents.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.58.3](service/s3/CHANGELOG.md#v1583-2024-08-02)
  * **Bug Fix**: Add assurance tests for auth scheme selection logic.

# Release (2024-08-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.13.0](service/bedrock/CHANGELOG.md#v1130-2024-08-01)
  * **Feature**: API and Documentation for Bedrock Model Copy feature. This feature lets you share and copy a custom model from one region to another or one account to another.
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.3.0](service/controlcatalog/CHANGELOG.md#v130-2024-08-01)
  * **Feature**: AWS Control Tower provides two new public APIs controlcatalog:ListControls and controlcatalog:GetControl under controlcatalog service namespace, which enable customers to programmatically retrieve control metadata of available controls.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.16.4](service/controltower/CHANGELOG.md#v1164-2024-08-01)
  * **Documentation**: Updated Control Tower service documentation for controlcatalog control ARN support with existing Control Tower public APIs
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.21.5](service/memorydb/CHANGELOG.md#v1215-2024-08-01)
  * **Documentation**: Doc only update for changes to deletion API.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.82.0](service/rds/CHANGELOG.md#v1820-2024-08-01)
  * **Feature**: This release adds support for specifying optional MinACU parameter in CreateDBShardGroup and ModifyDBShardGroup API. DBShardGroup response will contain MinACU if specified.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.152.0](service/sagemaker/CHANGELOG.md#v11520-2024-08-01)
  * **Feature**: This release adds support for Amazon EMR Serverless applications in SageMaker Studio for running data processing jobs.
* `github.com/aws/aws-sdk-go-v2/service/ssmquicksetup`: [v1.0.0](service/ssmquicksetup/CHANGELOG.md#v100-2024-08-01)
  * **Release**: New AWS service client module
  * **Feature**: This release adds API support for the QuickSetup feature of AWS Systems Manager
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.24.4](service/support/CHANGELOG.md#v1244-2024-08-01)
  * **Documentation**: Doc only updates to CaseDetails

# Release (2024-07-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.37.0](service/appstream/CHANGELOG.md#v1370-2024-07-30)
  * **Feature**: Added support for Red Hat Enterprise Linux 8 on Amazon AppStream 2.0
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.31.0](service/codepipeline/CHANGELOG.md#v1310-2024-07-30)
  * **Feature**: AWS CodePipeline V2 type pipelines now support stage level conditions to enable development teams to safely release changes that meet quality and compliance requirements.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.40.5](service/elasticache/CHANGELOG.md#v1405-2024-07-30)
  * **Documentation**: Doc only update for changes to deletion API.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.46.0](service/lexmodelsv2/CHANGELOG.md#v1460-2024-07-30)
  * **Feature**: This release adds new capabilities to the AMAZON.QnAIntent: Custom prompting, Guardrails integration and ExactResponse support for Bedrock Knowledge Base.
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.14.0](service/rolesanywhere/CHANGELOG.md#v1140-2024-07-30)
  * **Feature**: IAM RolesAnywhere now supports custom role session name on the CreateSession. This release adds the acceptRoleSessionName option to a profile to control whether a role session name will be accepted in a session request with a given profile.
* `github.com/aws/aws-sdk-go-v2/service/tnb`: [v1.11.0](service/tnb/CHANGELOG.md#v1110-2024-07-30)
  * **Feature**: This release adds Network Service Update, through which customers will be able to update their instantiated networks to a new network package. See the documentation for limitations. The release also enhances the Get network operation API to return parameter overrides used during the operation.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.44.3](service/workspaces/CHANGELOG.md#v1443-2024-07-30)
  * **Documentation**: Removing multi-session as it isn't supported for pools

# Release (2024-07-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.40.4](service/elasticache/CHANGELOG.md#v1404-2024-07-29)
  * **Documentation**: Renaming full service name as it appears in developer documentation.
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.21.4](service/memorydb/CHANGELOG.md#v1214-2024-07-29)
  * **Documentation**: Renaming full service name as it appears in developer documentation.

# Release (2024-07-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.31.0](service/applicationautoscaling/CHANGELOG.md#v1310-2024-07-25)
  * **Feature**: Application Auto Scaling is now more responsive to the changes in demand of your SageMaker Inference endpoints. To get started, create or update a Target Tracking policy based on High Resolution CloudWatch metrics.
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.3.0](service/applicationsignals/CHANGELOG.md#v130-2024-07-25)
  * **Feature**: CloudWatch Application Signals now supports application logs correlation with traces and operational health metrics of applications running on EC2 instances. Users can view the most relevant telemetry to troubleshoot application health anomalies such as spikes in latency, errors, and availability.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.15.0](service/bedrockruntime/CHANGELOG.md#v1150-2024-07-25)
  * **Feature**: Provides ServiceUnavailableException error message
* `github.com/aws/aws-sdk-go-v2/service/codecommit`: [v1.25.0](service/codecommit/CHANGELOG.md#v1250-2024-07-25)
  * **Feature**: CreateRepository API now throws OperationNotAllowedException when the account has been restricted from creating a repository.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.16.0](service/datazone/CHANGELOG.md#v1160-2024-07-25)
  * **Feature**: Introduces GetEnvironmentCredentials operation to SDK
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.173.0](service/ec2/CHANGELOG.md#v11730-2024-07-25)
  * **Feature**: EC2 Fleet now supports using custom identifiers to reference Amazon Machine Images (AMI) in launch requests that are configured to choose from a diversified list of instance types.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.31.0](service/ecr/CHANGELOG.md#v1310-2024-07-25)
  * **Feature**: API and documentation updates for Amazon ECR, adding support for creating, updating, describing and deleting ECR Repository Creation Template.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.47.0](service/eks/CHANGELOG.md#v1470-2024-07-25)
  * **Feature**: This release adds support for EKS cluster to manage extended support.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.34.0](service/elasticloadbalancingv2/CHANGELOG.md#v1340-2024-07-25)
  * **Feature**: This release adds support for sharing trust stores across accounts and organizations through integration with AWS Resource Access Manager.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.41.0](service/networkfirewall/CHANGELOG.md#v1410-2024-07-25)
  * **Feature**: You can now log events that are related to TLS inspection, in addition to the existing alert and flow logging.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.42.0](service/outposts/CHANGELOG.md#v1420-2024-07-25)
  * **Feature**: Adding default vCPU information to GetOutpostSupportedInstanceTypes and GetOutpostInstanceTypes responses
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.30.0](service/sfn/CHANGELOG.md#v1300-2024-07-25)
  * **Feature**: This release adds support to customer managed KMS key encryption in AWS Step Functions.

# Release (2024-07-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.17.9](feature/s3/manager/CHANGELOG.md#v1179-2024-07-24)
  * **Documentation**: Clarify region hint and credential usage in HeadBucketRegion.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.16.0](service/cleanrooms/CHANGELOG.md#v1160-2024-07-24)
  * **Feature**: Three enhancements to the AWS Clean Rooms: Disallowed Output Columns, Flexible Result Receivers, SQL as a Seed
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.34.4](service/dynamodb/CHANGELOG.md#v1344-2024-07-24)
  * **Documentation**: DynamoDB doc only update for July
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.40.0](service/iotsitewise/CHANGELOG.md#v1400-2024-07-24)
  * **Feature**: Adds support for creating SiteWise Edge gateways that run on a Siemens Industrial Edge Device.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.15.0](service/mediapackagev2/CHANGELOG.md#v1150-2024-07-24)
  * **Feature**: This release adds support for Irdeto DRM encryption in DASH manifests.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.12.0](service/medicalimaging/CHANGELOG.md#v1120-2024-07-24)
  * **Feature**: CopyImageSet API adds copying selected instances between image sets, and overriding inconsistent metadata with a force parameter. UpdateImageSetMetadata API enables reverting to prior versions; updates to Study, Series, and SOP Instance UIDs; and updates to private elements, with a force parameter.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.12.5](service/pinpointsmsvoicev2/CHANGELOG.md#v1125-2024-07-24)
  * **Documentation**: Update for rebrand to AWS End User Messaging SMS and Voice.

# Release (2024-07-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.35.0](service/appsync/CHANGELOG.md#v1350-2024-07-23)
  * **Feature**: Adding support for paginators in AppSync list APIs
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.15.0](service/cleanrooms/CHANGELOG.md#v1150-2024-07-23)
  * **Feature**: This release adds AWS Entity Resolution integration to associate ID namespaces & ID mapping workflow resources as part of ID namespace association and  ID mapping table  in AWS Clean Rooms. It also introduces a new ID_MAPPING_TABLE analysis rule to manage the protection on ID mapping table.
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.7.0](service/cleanroomsml/CHANGELOG.md#v170-2024-07-23)
  * **Feature**: Adds SQL query as the source of seed audience for audience generation job.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.106.0](service/connect/CHANGELOG.md#v11060-2024-07-23)
  * **Feature**: Added PostContactSummary segment type on ListRealTimeContactAnalysisSegmentsV2 API
* `github.com/aws/aws-sdk-go-v2/service/connectcontactlens`: [v1.24.0](service/connectcontactlens/CHANGELOG.md#v1240-2024-07-23)
  * **Feature**: Added PostContactSummary segment type on ListRealTimeContactAnalysisSegments API
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.15.0](service/datazone/CHANGELOG.md#v1150-2024-07-23)
  * **Feature**: This release removes the deprecated dataProductItem field from Search API output.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.172.0](service/ec2/CHANGELOG.md#v11720-2024-07-23)
  * **Feature**: Switch to new waiter matching implementation, which conveys a slight performance boost and removes the need for the go-jmespath runtime dependency.
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.13.0](service/entityresolution/CHANGELOG.md#v1130-2024-07-23)
  * **Feature**: Support First Party ID Mapping

# Release (2024-07-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.14.0](service/datazone/CHANGELOG.md#v1140-2024-07-22)
  * **Feature**: This release adds 1/ support of register S3 locations of assets in AWS Lake Formation hybrid access mode for DefaultDataLake blueprint. 2/ support of CRUD operations for Asset Filters.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.38.0](service/ivs/CHANGELOG.md#v1380-2024-07-22)
  * **Feature**: Documentation update for IVS Low Latency API Reference.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.21.0](service/redshiftserverless/CHANGELOG.md#v1210-2024-07-22)
  * **Feature**: Adds dualstack support for Redshift Serverless workgroup.

# Release (2024-07-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.35.0](service/acmpca/CHANGELOG.md#v1350-2024-07-18)
  * **Feature**: Fix broken waiters for the acm-pca client.  Waiters broke in version 1.13.144 of the Boto3 SDK.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.105.0](service/connect/CHANGELOG.md#v11050-2024-07-18)
  * **Feature**: Amazon Connect expands search API coverage for additional resources.  Search for hierarchy groups by name, ID, tag, or other criteria (new endpoint). Search for agent statuses by name, ID, tag, or other criteria (new endpoint). Search for users by their assigned proficiencies (enhanced endpoint)
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.171.0](service/ec2/CHANGELOG.md#v11710-2024-07-18)
  * **Feature**: Amazon VPC IP Address Manager (IPAM) now supports Bring-Your-Own-IP (BYOIP) for IP addresses registered with any Internet Registry. This feature uses DNS TXT records to validate ownership of a public IP address range.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.32.0](service/firehose/CHANGELOG.md#v1320-2024-07-18)
  * **Feature**: This release 1) Add configurable buffering hints for Snowflake as destination. 2) Add ReadFromTimestamp for MSK As Source. Firehose will start reading data from MSK Cluster using offset associated with this timestamp. 3) Gated public beta release to add Apache Iceberg tables as destination.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.14.4](service/ivschat/CHANGELOG.md#v1144-2024-07-18)
  * **Documentation**: Documentation update for IVS Chat API Reference.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.55.0](service/medialive/CHANGELOG.md#v1550-2024-07-18)
  * **Feature**: AWS Elemental MediaLive now supports the SRT protocol via the new SRT Caller input type.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.81.5](service/rds/CHANGELOG.md#v1815-2024-07-18)
  * **Documentation**: Updates Amazon RDS documentation to specify an eventual consistency model for DescribePendingMaintenanceActions.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.151.0](service/sagemaker/CHANGELOG.md#v11510-2024-07-18)
  * **Feature**: SageMaker Training supports R5, T3 and R5D instances family. And SageMaker Processing supports G5 and R5D instances family.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.32.4](service/secretsmanager/CHANGELOG.md#v1324-2024-07-18)
  * **Documentation**: Doc only update for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.3.0](service/taxsettings/CHANGELOG.md#v130-2024-07-18)
  * **Feature**: Set default endpoint for aws partition. Requests from all regions in aws partition will be forward to us-east-1 endpoint.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.25.4](service/timestreamquery/CHANGELOG.md#v1254-2024-07-18)
  * **Documentation**: Doc-only update for TimestreamQuery. Added guidance about the accepted valid value for the QueryPricingModel parameter.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.8.4](service/workspacesthinclient/CHANGELOG.md#v184-2024-07-18)
  * **Documentation**: Documentation update for WorkSpaces Thin Client.

# Release (2024-07-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.34.0](service/acmpca/CHANGELOG.md#v1340-2024-07-12)
  * **Feature**: Minor refactoring of C2J model for AWS Private CA
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.12.0](service/arczonalshift/CHANGELOG.md#v1120-2024-07-12)
  * **Feature**: Adds the option to subscribe to get notifications when a zonal autoshift occurs in a region.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.27.0](service/globalaccelerator/CHANGELOG.md#v1270-2024-07-12)
  * **Feature**: This feature adds exceptions to the Customer API to avoid throwing Internal Service errors
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.68.0](service/quicksight/CHANGELOG.md#v1680-2024-07-12)
  * **Feature**: Vega ally control options and Support for Reviewed Answers in Topics

# Release (2024-07-10.2)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.30.3
  * **Dependency Update**: Temporarily re-add jmespath dependency.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.43.0](service/batch/CHANGELOG.md#v1430-2024-07-102)
  * **Feature**: This feature allows AWS Batch Jobs with EKS container orchestration type to be run as Multi-Node Parallel Jobs.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.12.0](service/bedrock/CHANGELOG.md#v1120-2024-07-102)
  * **Feature**: Add support for contextual grounding check for Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.16.0](service/bedrockagent/CHANGELOG.md#v1160-2024-07-102)
  * **Feature**: Introduces new data sources and chunking strategies for Knowledge bases, advanced parsing logic using FMs, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.15.0](service/bedrockagentruntime/CHANGELOG.md#v1150-2024-07-102)
  * **Feature**: Introduces query decomposition, enhanced Agents integration with Knowledge bases, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources for end-to-end solutions.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.14.0](service/bedrockruntime/CHANGELOG.md#v1140-2024-07-102)
  * **Feature**: Add support for contextual grounding check and ApplyGuardrail API for Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.170.0](service/ec2/CHANGELOG.md#v11700-2024-07-102)
  * **Feature**: Add parameters to enable provisioning IPAM BYOIPv4 space at a Local Zone Network Border Group level
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.91.0](service/glue/CHANGELOG.md#v1910-2024-07-102)
  * **Feature**: Add recipe step support for recipe node
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.29.3](service/groundstation/CHANGELOG.md#v1293-2024-07-102)
  * **Documentation**: Documentation update specifying OEM ephemeris units of measurement
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.12.0](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v1120-2024-07-102)
  * **Feature**: Add support for third party subscription providers, starting with RHEL subscriptions through Red Hat Subscription Manager (RHSM). Additionally, add support for tagging subscription provider resources, and detect when an instance has more than one Linux subscription and notify the customer.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.32.0](service/mediaconnect/CHANGELOG.md#v1320-2024-07-102)
  * **Feature**: AWS Elemental MediaConnect introduces the ability to disable outputs. Disabling an output allows you to keep the output attached to the flow, but stop streaming to the output destination. A disabled output does not incur data transfer costs.

# Release (2024-07-10)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.30.2
  * **Dependency Update**: Remove unused go-jmespath dependency from main module.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.42.0](service/batch/CHANGELOG.md#v1420-2024-07-10)
  * **Feature**: This feature allows AWS Batch Jobs with EKS container orchestration type to be run as Multi-Node Parallel Jobs.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.11.0](service/bedrock/CHANGELOG.md#v1110-2024-07-10)
  * **Feature**: Add support for contextual grounding check for Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.15.0](service/bedrockagent/CHANGELOG.md#v1150-2024-07-10)
  * **Feature**: Introduces new data sources and chunking strategies for Knowledge bases, advanced parsing logic using FMs, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.14.0](service/bedrockagentruntime/CHANGELOG.md#v1140-2024-07-10)
  * **Feature**: Introduces query decomposition, enhanced Agents integration with Knowledge bases, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources for end-to-end solutions.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.13.0](service/bedrockruntime/CHANGELOG.md#v1130-2024-07-10)
  * **Feature**: Add support for contextual grounding check and ApplyGuardrail API for Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.169.0](service/ec2/CHANGELOG.md#v11690-2024-07-10)
  * **Feature**: Add parameters to enable provisioning IPAM BYOIPv4 space at a Local Zone Network Border Group level
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.90.0](service/glue/CHANGELOG.md#v1900-2024-07-10)
  * **Feature**: Add recipe step support for recipe node
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.29.2](service/groundstation/CHANGELOG.md#v1292-2024-07-10)
  * **Documentation**: Documentation update specifying OEM ephemeris units of measurement
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.11.0](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v1110-2024-07-10)
  * **Feature**: Add support for third party subscription providers, starting with RHEL subscriptions through Red Hat Subscription Manager (RHSM). Additionally, add support for tagging subscription provider resources, and detect when an instance has more than one Linux subscription and notify the customer.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.31.0](service/mediaconnect/CHANGELOG.md#v1310-2024-07-10)
  * **Feature**: AWS Elemental MediaConnect introduces the ability to disable outputs. Disabling an output allows you to keep the output attached to the flow, but stop streaming to the output destination. A disabled output does not incur data transfer costs.

# Release (2024-07-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.13.0](service/datazone/CHANGELOG.md#v1130-2024-07-09)
  * **Feature**: This release deprecates dataProductItem field from SearchInventoryResultItem, along with some unused DataProduct shapes
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.47.0](service/fsx/CHANGELOG.md#v1470-2024-07-09)
  * **Feature**: Adds support for FSx for NetApp ONTAP 2nd Generation file systems, and FSx for OpenZFS Single AZ HA file systems.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.39.0](service/opensearch/CHANGELOG.md#v1390-2024-07-09)
  * **Feature**: This release adds support for enabling or disabling Natural Language Query Processing feature for Amazon OpenSearch Service domains, and provides visibility into the current state of the setup or tear-down.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.150.0](service/sagemaker/CHANGELOG.md#v11500-2024-07-09)
  * **Feature**: This release 1/ enables optimization jobs that allows customers to perform Ahead-of-time compilation and quantization. 2/ allows customers to control access to Amazon Q integration in SageMaker Studio. 3/ enables AdditionalModelDataSources for CreateModel action.

# Release (2024-07-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.25.0](service/devicefarm/CHANGELOG.md#v1250-2024-07-08)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk`: [v1.26.0](service/elasticbeanstalk/CHANGELOG.md#v1260-2024-07-08)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.0.0](service/qapps/CHANGELOG.md#v100-2024-07-08)
  * **Release**: New AWS service client module
  * **Feature**: This is a general availability (GA) release of Amazon Q Apps, a capability of Amazon Q Business. Q Apps leverages data sources your company has provided to enable users to build, share, and customize apps within your organization.
* `github.com/aws/aws-sdk-go-v2/service/ses`: [v1.25.0](service/ses/CHANGELOG.md#v1250-2024-07-08)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.

# Release (2024-07-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.28.2](service/acm/CHANGELOG.md#v1282-2024-07-05)
  * **Documentation**: Documentation updates, including fixes for xml formatting, broken links, and ListCertificates description.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.12.0](service/paymentcryptographydata/CHANGELOG.md#v1120-2024-07-05)
  * **Feature**: Added further restrictions on logging of potentially sensitive inputs and outputs.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.10.0](service/qbusiness/CHANGELOG.md#v1100-2024-07-05)
  * **Feature**: Add personalization to Q Applications. Customers can enable or disable personalization when creating or updating a Q application with the personalization configuration.

# Release (2024-07-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.30.2](service/applicationautoscaling/CHANGELOG.md#v1302-2024-07-03)
  * **Documentation**: Doc only update for Application Auto Scaling that fixes resource name.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.27.2](service/directconnect/CHANGELOG.md#v1272-2024-07-03)
  * **Documentation**: This update includes documentation for support of new native 400 GBps ports for Direct Connect.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.30.0](service/organizations/CHANGELOG.md#v1300-2024-07-03)
  * **Feature**: Added a new reason under ConstraintViolationException in RegisterDelegatedAdministrator API to prevent registering suspended accounts as delegated administrator of a service.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.43.0](service/rekognition/CHANGELOG.md#v1430-2024-07-03)
  * **Feature**: This release adds support for tagging projects and datasets with the CreateProject and CreateDataset APIs.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.44.0](service/workspaces/CHANGELOG.md#v1440-2024-07-03)
  * **Feature**: Fix create workspace bundle RootStorage/UserStorage to accept non null values

# Release (2024-07-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.168.0](service/ec2/CHANGELOG.md#v11680-2024-07-02)
  * **Feature**: Documentation updates for Elastic Compute Cloud (EC2).
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.58.0](service/s3/CHANGELOG.md#v1580-2024-07-02)
  * **Feature**: Added response overrides to Head Object requests.

# Release (2024-07-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.104.0](service/connect/CHANGELOG.md#v11040-2024-07-01)
  * **Feature**: Authentication profiles are Amazon Connect resources (in gated preview) that allow you to configure authentication settings for users in your contact center. This release adds support for new ListAuthenticationProfiles, DescribeAuthenticationProfile and UpdateAuthenticationProfile APIs.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.46.0](service/eks/CHANGELOG.md#v1460-2024-07-01)
  * **Feature**: Updates EKS managed node groups to support EC2 Capacity Blocks for ML
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.11.0](service/paymentcryptographydata/CHANGELOG.md#v1110-2024-07-01)
  * **Feature**: Adding support for dynamic keys for encrypt, decrypt, re-encrypt and translate pin functions.  With this change, customers can use one-time TR-31 keys directly in dataplane operations without the need to first import them into the service.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.51.2](service/wafv2/CHANGELOG.md#v1512-2024-07-01)
  * **Documentation**: JSON body inspection: Update documentation to clarify that JSON parsing doesn't include full validation.

# Release (2024-06-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.33.0](service/acmpca/CHANGELOG.md#v1330-2024-06-28)
  * **Feature**: Added CCPC_LEVEL_1_OR_HIGHER KeyStorageSecurityStandard and SM2 KeyAlgorithm and SM3WITHSM2 SigningAlgorithm for China regions.
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.25.0](service/cloudhsmv2/CHANGELOG.md#v1250-2024-06-28)
  * **Feature**: Added 3 new APIs to support backup sharing: GetResourcePolicy, PutResourcePolicy, and DeleteResourcePolicy. Added BackupArn to the output of the DescribeBackups API. Added support for BackupArn in the CreateCluster API.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.103.0](service/connect/CHANGELOG.md#v11030-2024-06-28)
  * **Feature**: This release supports showing PreferredAgentRouting step via DescribeContact API.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.42.0](service/emr/CHANGELOG.md#v1420-2024-06-28)
  * **Feature**: This release provides the support for new allocation strategies i.e. CAPACITY_OPTIMIZED_PRIORITIZED for Spot and PRIORITIZED for On-Demand by taking input of priority value for each instance type for instance fleet clusters.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.89.0](service/glue/CHANGELOG.md#v1890-2024-06-28)
  * **Feature**: Added AttributesToGet parameter to Glue GetDatabases, allowing caller to limit output to include only the database name.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.28.0](service/kinesisanalyticsv2/CHANGELOG.md#v1280-2024-06-28)
  * **Feature**: Support for Flink 1.19 in Managed Service for Apache Flink
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.38.0](service/opensearch/CHANGELOG.md#v1380-2024-06-28)
  * **Feature**: This release removes support for enabling or disabling Natural Language Query Processing feature for Amazon OpenSearch Service domains.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.27.1](service/pi/CHANGELOG.md#v1271-2024-06-28)
  * **Documentation**: Noting that the filter db.sql.db_id isn't available for RDS for SQL Server DB instances.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.43.0](service/workspaces/CHANGELOG.md#v1430-2024-06-28)
  * **Feature**: Added support for Red Hat Enterprise Linux 8 on Amazon WorkSpaces Personal.

# Release (2024-06-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.30.0](service/applicationautoscaling/CHANGELOG.md#v1300-2024-06-27)
  * **Feature**: Amazon WorkSpaces customers can now use Application Auto Scaling to automatically scale the number of virtual desktops in a WorkSpaces pool.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.18.0](service/chimesdkmediapipelines/CHANGELOG.md#v1180-2024-06-27)
  * **Feature**: Added Amazon Transcribe multi language identification to Chime SDK call analytics. Enabling customers sending single stream audio to generate call recordings using Chime SDK call analytics
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.38.1](service/cloudfront/CHANGELOG.md#v1381-2024-06-27)
  * **Documentation**: Doc only update for CloudFront that fixes customer-reported issue
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.12.0](service/datazone/CHANGELOG.md#v1120-2024-06-27)
  * **Feature**: This release supports the data lineage feature of business data catalog in Amazon DataZone.
* `github.com/aws/aws-sdk-go-v2/service/mq`: [v1.25.0](service/mq/CHANGELOG.md#v1250-2024-06-27)
  * **Feature**: This release makes the EngineVersion field optional for both broker and configuration and uses the latest available version by default. The AutoMinorVersionUpgrade field is also now optional for broker creation and defaults to 'true'.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.9.0](service/qconnect/CHANGELOG.md#v190-2024-06-27)
  * **Feature**: Adds CreateContentAssociation, ListContentAssociations, GetContentAssociation, and DeleteContentAssociation APIs.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.67.0](service/quicksight/CHANGELOG.md#v1670-2024-06-27)
  * **Feature**: Adding support for Repeating Sections, Nested Filters
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.81.1](service/rds/CHANGELOG.md#v1811-2024-06-27)
  * **Documentation**: Updates Amazon RDS documentation for TAZ export to S3.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.149.0](service/sagemaker/CHANGELOG.md#v11490-2024-06-27)
  * **Feature**: Add capability for Admins to customize Studio experience for the user by showing or hiding Apps and MLTools.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.42.0](service/workspaces/CHANGELOG.md#v1420-2024-06-27)
  * **Feature**: Added support for WorkSpaces Pools.

# Release (2024-06-26)

## General Highlights
* **Feature**: Support list-of-string endpoint parameter.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.16.0](service/controltower/CHANGELOG.md#v1160-2024-06-26)
  * **Feature**: Added ListLandingZoneOperations API.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.45.0](service/eks/CHANGELOG.md#v1450-2024-06-26)
  * **Feature**: Added support for disabling unmanaged addons during cluster creation.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.16.0](service/ivsrealtime/CHANGELOG.md#v1160-2024-06-26)
  * **Feature**: IVS Real-Time now offers customers the ability to upload public keys for customer vended participant tokens.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.27.0](service/kinesisanalyticsv2/CHANGELOG.md#v1270-2024-06-26)
  * **Feature**: This release adds support for new ListApplicationOperations and DescribeApplicationOperation APIs. It adds a new configuration to enable system rollbacks, adds field ApplicationVersionCreateTimestamp for clarity and improves support for pagination for APIs.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.37.0](service/opensearch/CHANGELOG.md#v1370-2024-06-26)
  * **Feature**: This release adds support for enabling or disabling Natural Language Query Processing feature for Amazon OpenSearch Service domains, and provides visibility into the current state of the setup or tear-down.

# Release (2024-06-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.42.0](service/autoscaling/CHANGELOG.md#v1420-2024-06-25)
  * **Feature**: Doc only update for Auto Scaling's TargetTrackingMetricDataQuery
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.166.0](service/ec2/CHANGELOG.md#v11660-2024-06-25)
  * **Feature**: This release is for the launch of the new u7ib-12tb.224xlarge, R8g, c7gn.metal and mac2-m1ultra.metal instance types
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.28.0](service/networkmanager/CHANGELOG.md#v1280-2024-06-25)
  * **Feature**: This is model changes & documentation update for the Asynchronous Error Reporting feature for AWS Cloud WAN. This feature allows customers to view errors that occur while their resources are being provisioned, enabling customers to fix their resources without needing external support.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.7.0](service/workspacesthinclient/CHANGELOG.md#v170-2024-06-25)
  * **Feature**: This release adds the deviceCreationTags field to CreateEnvironment API input, UpdateEnvironment API input and GetEnvironment API output.

# Release (2024-06-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.38.0](service/customerprofiles/CHANGELOG.md#v1380-2024-06-24)
  * **Feature**: This release includes changes to ProfileObjectType APIs, adds functionality top set and get capacity for profile object types.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.8.0](service/qbusiness/CHANGELOG.md#v180-2024-06-24)
  * **Feature**: Allow enable/disable Q Apps when creating/updating a Q application; Return the Q Apps enablement information when getting a Q application.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.20.0](service/workspacesweb/CHANGELOG.md#v1200-2024-06-24)
  * **Feature**: Added ability to enable DeepLinking functionality on a Portal via UserSettings as well as added support for IdentityProvider resource tagging.

# Release (2024-06-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.11.0](service/bedrockruntime/CHANGELOG.md#v1110-2024-06-20)
  * **Feature**: This release adds document support to Converse and ConverseStream APIs
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.29.0](service/codeartifact/CHANGELOG.md#v1290-2024-06-20)
  * **Feature**: Add support for the Cargo package format.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.36.0](service/computeoptimizer/CHANGELOG.md#v1360-2024-06-20)
  * **Feature**: This release enables AWS Compute Optimizer to analyze and generate optimization recommendations for Amazon RDS MySQL and RDS PostgreSQL.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.6.0](service/costoptimizationhub/CHANGELOG.md#v160-2024-06-20)
  * **Feature**: This release enables AWS Cost Optimization Hub to show cost optimization recommendations for Amazon RDS MySQL and RDS PostgreSQL.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.33.2](service/dynamodb/CHANGELOG.md#v1332-2024-06-20)
  * **Documentation**: Doc-only update for DynamoDB. Fixed Important note in 6 Global table APIs - CreateGlobalTable, DescribeGlobalTable, DescribeGlobalTableSettings, ListGlobalTables, UpdateGlobalTable, and UpdateGlobalTableSettings.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.15.0](service/ivsrealtime/CHANGELOG.md#v1150-2024-06-20)
  * **Feature**: IVS Real-Time now offers customers the ability to record individual stage participants to S3.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.147.0](service/sagemaker/CHANGELOG.md#v11470-2024-06-20)
  * **Feature**: Adds support for model references in Hub service, and adds support for cross-account access of Hubs
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.50.2](service/securityhub/CHANGELOG.md#v1502-2024-06-20)
  * **Documentation**: Documentation updates for Security Hub

# Release (2024-06-19)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.30.0
  * **Feature**: Add implicit global region to internal endpoint resolution metadata.
* `github.com/aws/aws-sdk-go-v2/service/artifact`: [v1.3.0](service/artifact/CHANGELOG.md#v130-2024-06-19)
  * **Feature**: This release adds an acceptanceType field to the ReportSummary structure (used in the ListReports API response).
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.43.0](service/athena/CHANGELOG.md#v1430-2024-06-19)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/costandusagereportservice`: [v1.25.0](service/costandusagereportservice/CHANGELOG.md#v1250-2024-06-19)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.26.0](service/directconnect/CHANGELOG.md#v1260-2024-06-19)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/elastictranscoder`: [v1.24.0](service/elastictranscoder/CHANGELOG.md#v1240-2024-06-19)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.36.0](service/opensearch/CHANGELOG.md#v1360-2024-06-19)
  * **Feature**: This release enables customers to use JSON Web Tokens (JWT) for authentication on their Amazon OpenSearch Service domains.

# Release (2024-06-18)

## General Highlights
* **Feature**: Add framework for tracking specific features in user-agent string.
* **Feature**: Track usage of various AWS SDK features in user-agent string.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.10.0](service/bedrockruntime/CHANGELOG.md#v1100-2024-06-18)
  * **Feature**: This release adds support for using Guardrails with the Converse and ConverseStream APIs.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.41.0](service/cloudtrail/CHANGELOG.md#v1410-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.47.0](service/configservice/CHANGELOG.md#v1470-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.44.0](service/eks/CHANGELOG.md#v1440-2024-06-18)
  * **Feature**: This release adds support to surface async fargate customer errors from async path to customer through describe-fargate-profile API response.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.39.0](service/lightsail/CHANGELOG.md#v1390-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.41.0](service/polly/CHANGELOG.md#v1410-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.41.0](service/rekognition/CHANGELOG.md#v1410-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.146.0](service/sagemaker/CHANGELOG.md#v11460-2024-06-18)
  * **Feature**: Launched a new feature in SageMaker to provide managed MLflow Tracking Servers for customers to track ML experiments. This release also adds a new capability of attaching additional storage to SageMaker HyperPod cluster instances.
* `github.com/aws/aws-sdk-go-v2/service/shield`: [v1.26.0](service/shield/CHANGELOG.md#v1260-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.27.0](service/snowball/CHANGELOG.md#v1270-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.

# Release (2024-06-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.28.0
  * **Feature**: Support accountID-based endpoint routing.
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.30.4](service/acmpca/CHANGELOG.md#v1304-2024-06-17)
  * **Documentation**: Doc-only update that adds name constraints as an allowed extension for ImportCertificateAuthorityCertificate.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.39.0](service/batch/CHANGELOG.md#v1390-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.38.0](service/codebuild/CHANGELOG.md#v1380-2024-06-17)
  * **Feature**: AWS CodeBuild now supports global and organization GitHub webhooks
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.39.0](service/cognitoidentityprovider/CHANGELOG.md#v1390-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.25.0](service/directoryservice/CHANGELOG.md#v1250-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.29.0](service/efs/CHANGELOG.md#v1290-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.86.0](service/glue/CHANGELOG.md#v1860-2024-06-17)
  * **Feature**: This release introduces a new feature, Usage profiles. Usage profiles allow the AWS Glue admin to create different profiles for various classes of users within the account, enforcing limits and defaults for jobs and sessions.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.33.1](service/kms/CHANGELOG.md#v1331-2024-06-17)
  * **Documentation**: Updating SDK example for KMS DeriveSharedSecret API.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.55.0](service/mediaconvert/CHANGELOG.md#v1550-2024-06-17)
  * **Feature**: This release includes support for creating I-frame only video segments for DASH trick play.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.30.1](service/secretsmanager/CHANGELOG.md#v1301-2024-06-17)
  * **Documentation**: Doc only update for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/waf`: [v1.21.0](service/waf/CHANGELOG.md#v1210-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.

# Release (2024-06-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.9.0](service/datazone/CHANGELOG.md#v190-2024-06-14)
  * **Feature**: This release introduces a new default service blueprint for custom environment creation.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.164.1](service/ec2/CHANGELOG.md#v11641-2024-06-14)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.39.0](service/macie2/CHANGELOG.md#v1390-2024-06-14)
  * **Feature**: This release adds support for managing the status of automated sensitive data discovery for individual accounts in an organization, and determining whether individual S3 buckets are included in the scope of the analyses.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.54.0](service/mediaconvert/CHANGELOG.md#v1540-2024-06-14)
  * **Feature**: This release adds the ability to search for historical job records within the management console using a search box and/or via the SDK/CLI with partial string matching search on input file name.

# Release (2024-06-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.22.0](service/cloudhsmv2/CHANGELOG.md#v1220-2024-06-13)
  * **Feature**: Added support for hsm type hsm2m.medium. Added supported for creating a cluster in FIPS or NON_FIPS mode.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.85.0](service/glue/CHANGELOG.md#v1850-2024-06-13)
  * **Feature**: This release adds support for configuration of evaluation method for composite rules in Glue Data Quality rulesets.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.40.0](service/iotwireless/CHANGELOG.md#v1400-2024-06-13)
  * **Feature**: Add RoamingDeviceSNR and RoamingDeviceRSSI to Customer Metrics.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.33.0](service/kms/CHANGELOG.md#v1330-2024-06-13)
  * **Feature**: This feature allows customers to use their keys stored in KMS to derive a shared secret which can then be used to establish a secured channel for communication, provide proof of possession, or establish trust with other parties.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.12.0](service/mediapackagev2/CHANGELOG.md#v1120-2024-06-13)
  * **Feature**: This release adds support for CMAF ingest (DASH-IF live media ingest protocol interface 1)

# Release (2024-06-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apptest`: [v1.0.0](service/apptest/CHANGELOG.md#v100-2024-06-12)
  * **Release**: New AWS service client module
  * **Feature**: AWS Mainframe Modernization Application Testing is an AWS Mainframe Modernization service feature that automates functional equivalence testing for mainframe application modernization and migration to AWS, and regression testing.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.164.0](service/ec2/CHANGELOG.md#v11640-2024-06-12)
  * **Feature**: Tagging support for Traffic Mirroring FilterRule resource
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.10.0](service/osis/CHANGELOG.md#v1100-2024-06-12)
  * **Feature**: SDK changes for self-managed vpc endpoint to OpenSearch ingestion pipelines.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.44.7](service/redshift/CHANGELOG.md#v1447-2024-06-12)
  * **Documentation**: Updates to remove DC1 and DS2 node types.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.30.0](service/secretsmanager/CHANGELOG.md#v1300-2024-06-12)
  * **Feature**: Introducing RotationToken parameter for PutSecretValue API
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.14.0](service/securitylake/CHANGELOG.md#v1140-2024-06-12)
  * **Feature**: This release updates request validation regex to account for non-commercial aws partitions.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.30.0](service/sesv2/CHANGELOG.md#v1300-2024-06-12)
  * **Feature**: This release adds support for Amazon EventBridge as an email sending events destination.

# Release (2024-06-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.30.0](service/accessanalyzer/CHANGELOG.md#v1300-2024-06-11)
  * **Feature**: IAM Access Analyzer now provides policy recommendations to help resolve unused permissions for IAM roles and users. Additionally, IAM Access Analyzer now extends its custom policy checks to detect when IAM policies grant public access or access to critical resources ahead of deployments.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.43.0](service/guardduty/CHANGELOG.md#v1430-2024-06-11)
  * **Feature**: Added API support for GuardDuty Malware Protection for S3.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.26.0](service/networkmanager/CHANGELOG.md#v1260-2024-06-11)
  * **Feature**: This is model changes & documentation update for Service Insertion feature for AWS Cloud WAN. This feature allows insertion of AWS/3rd party security services on Cloud WAN. This allows to steer inter/intra segment traffic via security appliances and provide visibility to the route updates.
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorscep`: [v1.0.0](service/pcaconnectorscep/CHANGELOG.md#v100-2024-06-11)
  * **Release**: New AWS service client module
  * **Feature**: Connector for SCEP allows you to use a managed, cloud CA to enroll mobile devices and networking gear. SCEP is a widely-adopted protocol used by mobile device management (MDM) solutions for enrolling mobile devices. With the connector, you can use AWS Private CA with popular MDM solutions.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.145.0](service/sagemaker/CHANGELOG.md#v11450-2024-06-11)
  * **Feature**: Introduced Scope and AuthenticationRequestExtraParams to SageMaker Workforce OIDC configuration; this allows customers to modify these options for their private Workforce IdP integration. Model Registry Cross-account model package groups are discoverable.

# Release (2024-06-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.0.0](service/applicationsignals/CHANGELOG.md#v100-2024-06-10)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for Amazon CloudWatch Application Signals. Amazon CloudWatch Application Signals provides curated application performance monitoring for developers to monitor and troubleshoot application health using pre-built dashboards and Service Level Objectives.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.42.0](service/ecs/CHANGELOG.md#v1420-2024-06-10)
  * **Feature**: This release introduces a new cluster configuration to support the customer-managed keys for ECS managed storage encryption.

# Release (2024-06-07)

## General Highlights
* **Bug Fix**: Add clock skew correction on all service clients
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.33.0](service/auditmanager/CHANGELOG.md#v1330-2024-06-07)
  * **Feature**: New feature: common controls. When creating custom controls, you can now use pre-grouped AWS data sources based on common compliance themes. Also, the awsServices parameter is deprecated because we now manage services in scope for you. If used, the input is ignored and an empty list is returned.
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.28](service/b2bi/CHANGELOG.md#v100-preview28-2024-06-07)
  * **Feature**: Added exceptions to B2Bi List operations and ConflictException to B2Bi StartTransformerJob operation. Also made capabilities field explicitly required when creating a Partnership.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.28.0](service/codepipeline/CHANGELOG.md#v1280-2024-06-07)
  * **Feature**: CodePipeline now supports overriding S3 Source Object Key during StartPipelineExecution, as part of Source Overrides.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.144.0](service/sagemaker/CHANGELOG.md#v11440-2024-06-07)
  * **Feature**: This release introduces a new optional parameter: InferenceAmiVersion, in ProductionVariant.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.15.0](service/verifiedpermissions/CHANGELOG.md#v1150-2024-06-07)
  * **Feature**: This release adds OpenIdConnect (OIDC) configuration support for IdentitySources, allowing for external IDPs to be used in authorization requests.

# Release (2024-06-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.17.0](service/account/CHANGELOG.md#v1170-2024-06-06)
  * **Feature**: This release adds 3 new APIs (AcceptPrimaryEmailUpdate, GetPrimaryEmail, and StartPrimaryEmailUpdate) used to centrally manage the root user email address of member accounts within an AWS organization.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.29.0](service/firehose/CHANGELOG.md#v1290-2024-06-06)
  * **Feature**: Adds integration with Secrets Manager for Redshift, Splunk, HttpEndpoint, and Snowflake destinations
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.44.0](service/fsx/CHANGELOG.md#v1440-2024-06-06)
  * **Feature**: This release adds support to increase metadata performance on FSx for Lustre file systems beyond the default level provisioned when a file system is created. This can be done by specifying MetadataConfiguration during the creation of Persistent_2 file systems or by updating it on demand.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.84.0](service/glue/CHANGELOG.md#v1840-2024-06-06)
  * **Feature**: This release adds support for creating and updating Glue Data Catalog Views.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.39.0](service/iotwireless/CHANGELOG.md#v1390-2024-06-06)
  * **Feature**: Adds support for wireless device to be in Conflict FUOTA Device Status due to a FUOTA Task, so it couldn't be attached to a new one.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.38.0](service/location/CHANGELOG.md#v1380-2024-06-06)
  * **Feature**: Added two new APIs, VerifyDevicePosition and ForecastGeofenceEvents. Added support for putting larger geofences up to 100,000 vertices with Geobuf fields.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.29.10](service/sns/CHANGELOG.md#v12910-2024-06-06)
  * **Documentation**: Doc-only update for SNS. These changes include customer-reported issues and TXC3 updates.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.32.5](service/sqs/CHANGELOG.md#v1325-2024-06-06)
  * **Documentation**: Doc only updates for SQS. These updates include customer-reported issues and TCX3 modifications.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.29.0](service/storagegateway/CHANGELOG.md#v1290-2024-06-06)
  * **Feature**: Adds SoftwareUpdatePreferences to DescribeMaintenanceStartTime and UpdateMaintenanceStartTime, a structure which contains AutomaticUpdatePolicy.

# Release (2024-06-05)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.14.0](feature/dynamodb/attributevalue/CHANGELOG.md#v1140-2024-06-05)
  * **Feature**: Add codec options to use encoding.Text/Binary(Un)Marshaler when present on targets.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.24.0](service/globalaccelerator/CHANGELOG.md#v1240-2024-06-05)
  * **Feature**: This release contains a new optional ip-addresses input field for the update accelerator and update custom routing accelerator apis. This input enables consumers to replace IPv4 addresses on existing accelerators with addresses provided in the input.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.83.0](service/glue/CHANGELOG.md#v1830-2024-06-05)
  * **Feature**: AWS Glue now supports native SaaS connectivity: Salesforce connector available now
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.55.0](service/s3/CHANGELOG.md#v1550-2024-06-05)
  * **Feature**: Added new params copySource and key to copyObject API for supporting S3 Access Grants plugin. These changes will not change any of the existing S3 API functionality.
  * **Bug Fix**: Add S3-specific smithy protocol tests.

# Release (2024-06-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.163.0](service/ec2/CHANGELOG.md#v11630-2024-06-04)
  * **Feature**: U7i instances with up to 32 TiB of DDR5 memory and 896 vCPUs are now available. C7i-flex instances are launched and are lower-priced variants of the Amazon EC2 C7i instances that offer a baseline level of CPU performance with the ability to scale up to the full compute performance 95% of the time.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.12.0](service/pipes/CHANGELOG.md#v1120-2024-06-04)
  * **Feature**: This release adds Timestream for LiveAnalytics as a supported target in EventBridge Pipes
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.143.0](service/sagemaker/CHANGELOG.md#v11430-2024-06-04)
  * **Feature**: Extend DescribeClusterNode response with private DNS hostname and IP address, and placement information about availability zone and availability zone ID.
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.0.0](service/taxsettings/CHANGELOG.md#v100-2024-06-04)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of AWS Tax Settings API

# Release (2024-06-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.27.1
  * **Bug Fix**: Re-enable hoisting of `X-Amz-Expected-Bucket-Owner` in presigning, but in lowercase form, such that it is correctly enforced.
  * **Documentation**: Add deprecation docs to global endpoint resolution interfaces. These APIs were previously deprecated with the introduction of service-specific endpoint resolution (EndpointResolverV2 and BaseEndpoint on service client options).
* `github.com/aws/aws-sdk-go-v2/config`: [v1.27.17](config/CHANGELOG.md#v12717-2024-06-03)
  * **Documentation**: Add deprecation docs to global endpoint resolution interfaces. These APIs were previously deprecated with the introduction of service-specific endpoint resolution (EndpointResolverV2 and BaseEndpoint on service client options).
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.21.10](service/amplify/CHANGELOG.md#v12110-2024-06-03)
  * **Documentation**: This doc-only update identifies fields that are specific to Gen 1 and Gen 2 applications.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.38.0](service/batch/CHANGELOG.md#v1380-2024-06-03)
  * **Feature**: This release adds support for the AWS Batch GetJobQueueSnapshot API operation.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.43.0](service/eks/CHANGELOG.md#v1430-2024-06-03)
  * **Feature**: Adds support for EKS add-ons pod identity associations integration
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.20.0](service/iottwinmaker/CHANGELOG.md#v1200-2024-06-03)
  * **Feature**: Support RESET_VALUE UpdateType for PropertyUpdates to reset property value to default or null

# Release (2024-05-31)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.37.1](service/codebuild/CHANGELOG.md#v1371-2024-05-31)
  * **Documentation**: AWS CodeBuild now supports Self-hosted GitHub Actions runners for Github Enterprise
* `github.com/aws/aws-sdk-go-v2/service/codegurusecurity`: [v1.8.0](service/codegurusecurity/CHANGELOG.md#v180-2024-05-31)
  * **Feature**: This release includes minor model updates and documentation updates.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.38.6](service/elasticache/CHANGELOG.md#v1386-2024-05-31)
  * **Documentation**: Update to attributes of TestFailover and minor revisions.
* `github.com/aws/aws-sdk-go-v2/service/launchwizard`: [v1.4.0](service/launchwizard/CHANGELOG.md#v140-2024-05-31)
  * **Feature**: This release adds support for describing workload deployment specifications, deploying additional workload types, and managing tags for Launch Wizard resources with API operations.

# Release (2024-05-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.26.0](service/acm/CHANGELOG.md#v1260-2024-05-30)
  * **Feature**: add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.12.0](service/bedrockagent/CHANGELOG.md#v1120-2024-05-30)
  * **Feature**: With this release, Knowledge bases for Bedrock adds support for Titan Text Embedding v2.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.9.0](service/bedrockruntime/CHANGELOG.md#v190-2024-05-30)
  * **Feature**: This release adds Converse and ConverseStream APIs to Bedrock Runtime
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.40.0](service/cloudtrail/CHANGELOG.md#v1400-2024-05-30)
  * **Feature**: CloudTrail Lake returns PartitionKeys in the GetEventDataStore API response. Events are grouped into partitions based on these keys for better query performance. For example, the calendarday key groups events by day, while combining the calendarday key with the hour key groups them by day and hour.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.100.0](service/connect/CHANGELOG.md#v11000-2024-05-30)
  * **Feature**: Adding associatedQueueIds as a SearchCriteria and response field to the SearchRoutingProfiles API
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.21.0](service/emrserverless/CHANGELOG.md#v1210-2024-05-30)
  * **Feature**: The release adds support for spark structured streaming.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.79.3](service/rds/CHANGELOG.md#v1793-2024-05-30)
  * **Documentation**: Updates Amazon RDS documentation for Aurora Postgres DBname.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.142.0](service/sagemaker/CHANGELOG.md#v11420-2024-05-30)
  * **Feature**: Adds Model Card information as a new component to Model Package. Autopilot launches algorithm selection for TimeSeries modality to generate AutoML candidates per algorithm.

# Release (2024-05-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.41.0](service/athena/CHANGELOG.md#v1410-2024-05-29)
  * **Feature**: Throwing validation errors on CreateNotebook with Name containing `/`,`:`,`\`
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.37.0](service/codebuild/CHANGELOG.md#v1370-2024-05-29)
  * **Feature**: AWS CodeBuild now supports manually creating GitHub webhooks
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.99.0](service/connect/CHANGELOG.md#v1990-2024-05-29)
  * **Feature**: This release includes changes to DescribeContact API's response by including ConnectedToSystemTimestamp, RoutingCriteria, Customer, Campaign, AnsweringMachineDetectionStatus, CustomerVoiceActivity, QualityMetrics, DisconnectDetails, and SegmentAttributes information from a contact in Amazon Connect.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.82.0](service/glue/CHANGELOG.md#v1820-2024-05-29)
  * **Feature**: Add optional field JobMode to CreateJob and UpdateJob APIs.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.49.0](service/securityhub/CHANGELOG.md#v1490-2024-05-29)
  * **Feature**: Add ROOT type for TargetType model

# Release (2024-05-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.32.6](service/dynamodb/CHANGELOG.md#v1326-2024-05-28)
  * **Documentation**: Doc-only update for DynamoDB. Specified the IAM actions needed to authorize a user to create a table with a resource-based policy.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.162.0](service/ec2/CHANGELOG.md#v11620-2024-05-28)
  * **Feature**: Providing support to accept BgpAsnExtended attribute
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.33.0](service/kafka/CHANGELOG.md#v1330-2024-05-28)
  * **Feature**: Adds ControllerNodeInfo in ListNodes response to support Raft mode for MSK
* `github.com/aws/aws-sdk-go-v2/service/swf`: [v1.23.0](service/swf/CHANGELOG.md#v1230-2024-05-28)
  * **Feature**: This release adds new APIs for deleting activity type and workflow type resources.

# Release (2024-05-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.32.5](service/dynamodb/CHANGELOG.md#v1325-2024-05-24)
  * **Documentation**: Documentation only updates for DynamoDB.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.15.0](service/iotfleetwise/CHANGELOG.md#v1150-2024-05-24)
  * **Feature**: AWS IoT FleetWise now supports listing vehicles with attributes filter, ListVehicles API is updated to support additional attributes filter.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.22.9](service/managedblockchain/CHANGELOG.md#v1229-2024-05-24)
  * **Documentation**: This is a minor documentation update to address the impact of the shut down of the Goerli and Polygon networks.

# Release (2024-05-23)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.20.0](service/emrserverless/CHANGELOG.md#v1200-2024-05-23)
  * **Feature**: This release adds the capability to run interactive workloads using Apache Livy Endpoint.
* `github.com/aws/aws-sdk-go-v2/service/opsworks`: [v1.22.8](service/opsworks/CHANGELOG.md#v1228-2024-05-23)
  * **Documentation**: Documentation-only update for OpsWorks Stacks.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.54.3](service/s3/CHANGELOG.md#v1543-2024-05-23)
  * **Bug Fix**: Prevent parsing failures for nonstandard `Expires` values in responses. If the SDK cannot parse the value set in the response header for this field it will now be returned as `nil`. A new field, `ExpiresString`, has been added that will retain the unparsed value from the response (regardless of whether it came back in a format recognized by the SDK).

# Release (2024-05-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.2.0](service/chatbot/CHANGELOG.md#v120-2024-05-22)
  * **Feature**: This change adds support for tagging Chatbot configurations.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.51.0](service/cloudformation/CHANGELOG.md#v1510-2024-05-22)
  * **Feature**: Added DeletionMode FORCE_DELETE_STACK for deleting a stack that is stuck in DELETE_FAILED state due to resource deletion failure.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.32.0](service/kms/CHANGELOG.md#v1320-2024-05-22)
  * **Feature**: This release includes feature to import customer's asymmetric (RSA, ECC and SM2) and HMAC keys into KMS in China.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.34.0](service/opensearch/CHANGELOG.md#v1340-2024-05-22)
  * **Feature**: This release adds support for enabling or disabling a data source configured as part of Zero-ETL integration with Amazon S3, by setting its status.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.49.0](service/wafv2/CHANGELOG.md#v1490-2024-05-22)
  * **Feature**: You can now use Security Lake to collect web ACL traffic data.

# Release (2024-05-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.81.0](service/glue/CHANGELOG.md#v1810-2024-05-21)
  * **Feature**: Add Maintenance window to CreateJob and UpdateJob APIs and JobRun response. Add a new Job Run State for EXPIRED.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.38.0](service/lightsail/CHANGELOG.md#v1380-2024-05-21)
  * **Feature**: This release adds support for Amazon Lightsail instances to switch between dual-stack or IPv4 only and IPv6-only public IP address types.
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.0.0](service/mailmanager/CHANGELOG.md#v100-2024-05-21)
  * **Release**: New AWS service client module
  * **Feature**: This release includes a new Amazon SES feature called Mail Manager, which is a set of email gateway capabilities designed to help customers strengthen their organization's email infrastructure, simplify email workflow management, and streamline email compliance control.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.25.0](service/pi/CHANGELOG.md#v1250-2024-05-21)
  * **Feature**: Performance Insights added a new input parameter called AuthorizedActions to support the fine-grained access feature. Performance Insights also restricted the acceptable input characters.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.79.1](service/rds/CHANGELOG.md#v1791-2024-05-21)
  * **Documentation**: Updates Amazon RDS documentation for Db2 license through AWS Marketplace.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.28.0](service/storagegateway/CHANGELOG.md#v1280-2024-05-21)
  * **Feature**: Added new SMBSecurityStrategy enum named MandatoryEncryptionNoAes128, new mode enforces encryption and disables AES 128-bit algorithums.

# Release (2024-05-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.11.0](service/bedrockagent/CHANGELOG.md#v1110-2024-05-20)
  * **Feature**: This release adds support for using Guardrails with Bedrock Agents.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.11.0](service/bedrockagentruntime/CHANGELOG.md#v1110-2024-05-20)
  * **Feature**: This release adds support for using Guardrails with Bedrock Agents.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.14.0](service/controltower/CHANGELOG.md#v1140-2024-05-20)
  * **Feature**: Added ListControlOperations API and filtering support for ListEnabledControls API. Updates also includes added metadata for enabled controls and control operations.
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.9.0](service/osis/CHANGELOG.md#v190-2024-05-20)
  * **Feature**: Add support for creating an OpenSearch Ingestion pipeline that is attached to a provided VPC. Add information about the destinations of an OpenSearch Ingestion pipeline to the GetPipeline and ListPipelines APIs.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.79.0](service/rds/CHANGELOG.md#v1790-2024-05-20)
  * **Feature**: This release adds support for EngineLifecycleSupport on DBInstances, DBClusters, and GlobalClusters.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.29.0](service/secretsmanager/CHANGELOG.md#v1290-2024-05-20)
  * **Feature**: add v2 smoke tests and smithy smokeTests trait for SDK testing

# Release (2024-05-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.36.0](service/codebuild/CHANGELOG.md#v1360-2024-05-17)
  * **Feature**: Aws CodeBuild now supports 36 hours build timeout
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.31.0](service/elasticloadbalancingv2/CHANGELOG.md#v1310-2024-05-17)
  * **Feature**: This release adds dualstack-without-public-ipv4 IP address type for ALB.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.33.0](service/lakeformation/CHANGELOG.md#v1330-2024-05-17)
  * **Feature**: Introduces a new API, GetDataLakePrincipal, that returns the identity of the invoking principal
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.48.0](service/transfer/CHANGELOG.md#v1480-2024-05-17)
  * **Feature**: Enable use of CloudFormation traits in Smithy model to improve generated CloudFormation schema from the Smithy API model.

# Release (2024-05-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.27.0
  * **Feature**: Capture user agent in internal metrics.
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.30.0](service/acmpca/CHANGELOG.md#v1300-2024-05-16)
  * **Feature**: This release adds support for waiters to fail on AccessDeniedException when having insufficient permissions
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.98.2](service/connect/CHANGELOG.md#v1982-2024-05-16)
  * **Documentation**: Adding Contact Flow metrics to the GetMetricDataV2 API
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.32.0](service/kafka/CHANGELOG.md#v1320-2024-05-16)
  * **Feature**: AWS MSK support for Broker Removal.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.27.0](service/mwaa/CHANGELOG.md#v1270-2024-05-16)
  * **Feature**: Amazon MWAA now supports Airflow web server auto scaling to automatically handle increased demand from REST APIs, Command Line Interface (CLI), or more Airflow User Interface (UI) users. Customers can specify maximum and minimum web server instances during environment creation and update workflow.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.64.0](service/quicksight/CHANGELOG.md#v1640-2024-05-16)
  * **Feature**: This release adds DescribeKeyRegistration and UpdateKeyRegistration APIs to manage QuickSight Customer Managed Keys (CMK).
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.141.0](service/sagemaker/CHANGELOG.md#v11410-2024-05-16)
  * **Feature**: Introduced WorkerAccessConfiguration to SageMaker Workteam. This allows customers to configure resource access for workers in a workteam.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.28.9](service/secretsmanager/CHANGELOG.md#v1289-2024-05-16)
  * **Documentation**: Documentation updates for AWS Secrets Manager

# Release (2024-05-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.26.2
  * **Bug Fix**: Adjust internal metrics collection for revised authentication workflow.
  * **Bug Fix**: Fix confusing doc header in `aws/signer/v4` package.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.10.0](service/bedrockagentruntime/CHANGELOG.md#v1100-2024-05-15)
  * **Feature**: Updating Bedrock Knowledge Base Metadata & Filters feature with two new filters listContains and stringContains
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.35.0](service/codebuild/CHANGELOG.md#v1350-2024-05-15)
  * **Feature**: CodeBuild Reserved Capacity VPC Support
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.38.0](service/datasync/CHANGELOG.md#v1380-2024-05-15)
  * **Feature**: Task executions now display a CANCELLING status when an execution is in the process of being cancelled.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.22.0](service/grafana/CHANGELOG.md#v1220-2024-05-15)
  * **Feature**: This release adds new ServiceAccount and ServiceAccountToken APIs.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.9.0](service/medicalimaging/CHANGELOG.md#v190-2024-05-15)
  * **Feature**: Added support for importing medical imaging data from Amazon S3 buckets across accounts and regions.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.48.2](service/securityhub/CHANGELOG.md#v1482-2024-05-15)
  * **Documentation**: Documentation-only update for AWS Security Hub

# Release (2024-05-14)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.98.0](service/connect/CHANGELOG.md#v1980-2024-05-14)
  * **Feature**: Amazon Connect provides enhanced search capabilities for flows & flow modules on the Connect admin website and programmatically using APIs. You can search for flows and flow modules by name, description, type, status, and tags, to filter and identify a specific flow in your Connect instances.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.54.0](service/s3/CHANGELOG.md#v1540-2024-05-14)
  * **Feature**: Updated a few x-id in the http uri traits

# Release (2024-05-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.31.0](service/eventbridge/CHANGELOG.md#v1310-2024-05-13)
  * **Feature**: Amazon EventBridge introduces KMS customer-managed key (CMK) encryption support for custom and partner events published on EventBridge Event Bus (including default bus) and UpdateEventBus API.
* `github.com/aws/aws-sdk-go-v2/service/vpclattice`: [v1.8.0](service/vpclattice/CHANGELOG.md#v180-2024-05-13)
  * **Feature**: This release adds TLS Passthrough support. It also increases max number of target group per rule to 10.

# Release (2024-05-10)

## General Highlights
* **Feature**: Drop test dependency on x/net, h2 support is now available in the stdlib.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.161.1](service/ec2/CHANGELOG.md#v11611-2024-05-10)
  * **Bug Fix**: Fix serialization behavior of empty lists.
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.31.0](service/greengrassv2/CHANGELOG.md#v1310-2024-05-10)
  * **Feature**: Mark ComponentVersion in ComponentDeploymentSpecification as required.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.140.0](service/sagemaker/CHANGELOG.md#v11400-2024-05-10)
  * **Feature**: Introduced support for G6 instance types on Sagemaker Notebook Instances and on SageMaker Studio for JupyterLab and CodeEditor applications.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.24.0](service/ssooidc/CHANGELOG.md#v1240-2024-05-10)
  * **Feature**: Updated request parameters for PKCE support.

# Release (2024-05-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.9.0](service/bedrockagentruntime/CHANGELOG.md#v190-2024-05-09)
  * **Feature**: This release adds support to provide guardrail configuration and modify inference parameters that are then used in RetrieveAndGenerate API in Agents for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.30.0](service/pinpoint/CHANGELOG.md#v1300-2024-05-09)
  * **Feature**: This release adds support for specifying email message headers for Email Templates, Campaigns, Journeys and Send Messages.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.28.2](service/route53resolver/CHANGELOG.md#v1282-2024-05-09)
  * **Documentation**: Update the DNS Firewall settings to correct a spelling issue.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.13.0](service/ssmsap/CHANGELOG.md#v1130-2024-05-09)
  * **Feature**: Added support for application-aware start/stop of SAP applications running on EC2 instances, with SSM for SAP
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.14.0](service/verifiedpermissions/CHANGELOG.md#v1140-2024-05-09)
  * **Feature**: Adds policy effect and actions fields to Policy API's.

# Release (2024-05-08)

## General Highlights
* **Bug Fix**: GoDoc improvement
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.38.0](service/cognitoidentityprovider/CHANGELOG.md#v1380-2024-05-08)
  * **Feature**: Add EXTERNAL_PROVIDER enum value to UserStatusType.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.161.0](service/ec2/CHANGELOG.md#v11610-2024-05-08)
  * **Feature**: Adding Precision Hardware Clock (PHC) to public API DescribeInstanceTypes
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.28.0](service/ecr/CHANGELOG.md#v1280-2024-05-08)
  * **Feature**: This release adds pull through cache rules support for GitLab container registry in Amazon ECR.
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.33.2](service/fms/CHANGELOG.md#v1332-2024-05-08)
  * **Documentation**: The policy scope resource tag is always a string value, either a non-empty string or an empty string.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.40.0](service/polly/CHANGELOG.md#v1400-2024-05-08)
  * **Feature**: Add new engine - generative - that builds the most expressive conversational voices.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.32.0](service/sqs/CHANGELOG.md#v1320-2024-05-08)
  * **Feature**: This release adds MessageSystemAttributeNames to ReceiveMessageRequest to replace AttributeNames.

# Release (2024-05-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.22](service/b2bi/CHANGELOG.md#v100-preview22-2024-05-07)
  * **Documentation**: Documentation update to clarify the MappingTemplate definition.
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.23.0](service/budgets/CHANGELOG.md#v1230-2024-05-07)
  * **Feature**: This release adds tag support for budgets and budget actions.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.21.0](service/resiliencehub/CHANGELOG.md#v1210-2024-05-07)
  * **Feature**: AWS Resilience Hub has expanded its drift detection capabilities by introducing a new type of drift detection - application resource drift. This new enhancement detects changes, such as the addition or deletion of resources within the application's input sources.
* `github.com/aws/aws-sdk-go-v2/service/route53profiles`: [v1.0.1](service/route53profiles/CHANGELOG.md#v101-2024-05-07)
  * **Documentation**: Doc only update for Route 53 profiles that fixes some link  issues

# Release (2024-05-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.52.0](service/medialive/CHANGELOG.md#v1520-2024-05-06)
  * **Feature**: AWS Elemental MediaLive now supports configuring how SCTE 35 passthrough triggers segment breaks in HLS and MediaPackage output groups. Previously, messages triggered breaks in all these output groups. The new option is to trigger segment breaks only in groups that have SCTE 35 passthrough enabled.

# Release (2024-05-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.10.0](service/bedrockagent/CHANGELOG.md#v1100-2024-05-03)
  * **Feature**: This release adds support for using Provisioned Throughput with Bedrock Agents.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.97.0](service/connect/CHANGELOG.md#v1970-2024-05-03)
  * **Feature**: This release adds 5 new APIs for managing attachments: StartAttachedFileUpload, CompleteAttachedFileUpload, GetAttachedFile, BatchGetAttachedFileMetadata, DeleteAttachedFile. These APIs can be used to programmatically upload and download attachments to Connect resources, like cases.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.17.0](service/connectcases/CHANGELOG.md#v1170-2024-05-03)
  * **Feature**: This feature supports the release of Files related items
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.37.1](service/datasync/CHANGELOG.md#v1371-2024-05-03)
  * **Documentation**: Updated guidance on using private or self-signed certificate authorities (CAs) with AWS DataSync object storage locations.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.26.0](service/inspector2/CHANGELOG.md#v1260-2024-05-03)
  * **Feature**: This release adds CSV format to GetCisScanReport for Inspector v2
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.139.0](service/sagemaker/CHANGELOG.md#v11390-2024-05-03)
  * **Feature**: Amazon SageMaker Inference now supports m6i, c6i, r6i, m7i, c7i, r7i and g5 instance types for Batch Transform Jobs
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.29.0](service/sesv2/CHANGELOG.md#v1290-2024-05-03)
  * **Feature**: Adds support for specifying replacement headers per BulkEmailEntry in SendBulkEmail in SESv2.

# Release (2024-05-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.32.0](service/dynamodb/CHANGELOG.md#v1320-2024-05-02)
  * **Feature**: This release adds support to specify an optional, maximum OnDemandThroughput for DynamoDB tables and global secondary indexes in the CreateTable or UpdateTable APIs. You can also override the OnDemandThroughput settings by calling the ImportTable, RestoreFromPointInTime, or RestoreFromBackup APIs.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.160.0](service/ec2/CHANGELOG.md#v11600-2024-05-02)
  * **Feature**: This release includes a new API for retrieving the public endorsement key of the EC2 instance's Nitro Trusted Platform Module (NitroTPM).
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.34.0](service/personalize/CHANGELOG.md#v1340-2024-05-02)
  * **Feature**: This releases ability to delete users and their data, including their metadata and interactions data, from a dataset group.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.18.0](service/redshiftserverless/CHANGELOG.md#v1180-2024-05-02)
  * **Feature**: Update Redshift Serverless List Scheduled Actions Output Response to include Namespace Name.

# Release (2024-05-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.9.0](service/bedrockagent/CHANGELOG.md#v190-2024-05-01)
  * **Feature**: This release adds support for using MongoDB Atlas as a vector store when creating a knowledge base.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.159.1](service/ec2/CHANGELOG.md#v11591-2024-05-01)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.23.0](service/personalizeruntime/CHANGELOG.md#v1230-2024-05-01)
  * **Feature**: This release adds support for a Reason attribute for predicted items generated by User-Personalization-v2.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.48.0](service/securityhub/CHANGELOG.md#v1480-2024-05-01)
  * **Feature**: Updated CreateMembers API request with limits.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.28.0](service/sesv2/CHANGELOG.md#v1280-2024-05-01)
  * **Feature**: Fixes ListContacts and ListImportJobs APIs to use POST instead of GET.

# Release (2024-04-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.15.0](service/chimesdkvoice/CHANGELOG.md#v1150-2024-04-30)
  * **Feature**: Due to changes made by the Amazon Alexa service, GetSipMediaApplicationAlexaSkillConfiguration and PutSipMediaApplicationAlexaSkillConfiguration APIs are no longer available for use. For more information, refer to the Alexa Smart Properties page.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.27.0](service/codeartifact/CHANGELOG.md#v1270-2024-04-30)
  * **Feature**: Add support for the Ruby package format.
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.33.0](service/fms/CHANGELOG.md#v1330-2024-04-30)
  * **Feature**: AWS Firewall Manager now supports the network firewall service stream exception policy feature for accounts within your organization.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.21.0](service/omics/CHANGELOG.md#v1210-2024-04-30)
  * **Feature**: Add support for workflow sharing and dynamic run storage
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.33.0](service/opensearch/CHANGELOG.md#v1330-2024-04-30)
  * **Feature**: This release enables customers to create Route53 A and AAAA alias record types to point custom endpoint domain to OpenSearch domain's dualstack search endpoint.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.10.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1100-2024-04-30)
  * **Feature**: Amazon Pinpoint has added two new features Multimedia services (MMS) and protect configurations. Use the three new MMS APIs to send media messages to a mobile phone which includes image, audio, text, or video files. Use the ten new protect configurations APIs to block messages to specific countries.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.6.0](service/qbusiness/CHANGELOG.md#v160-2024-04-30)
  * **Feature**: This is a general availability (GA) release of Amazon Q Business. Q Business enables employees in an enterprise to get comprehensive answers to complex questions and take actions through a unified, intuitive web-based chat experience - using an enterprise's existing content, data, and systems.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.63.0](service/quicksight/CHANGELOG.md#v1630-2024-04-30)
  * **Feature**: New Q embedding supporting Generative Q&A
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.28.0](service/route53resolver/CHANGELOG.md#v1280-2024-04-30)
  * **Feature**: Release of FirewallDomainRedirectionAction parameter on the Route 53 DNS Firewall Rule.  This allows customers to configure a DNS Firewall rule to inspect all the domains in the DNS redirection chain (default) , such as CNAME, ALIAS, DNAME, etc., or just the first domain and trust the rest.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.138.0](service/sagemaker/CHANGELOG.md#v11380-2024-04-30)
  * **Feature**: Amazon SageMaker Training now supports the use of attribute-based access control (ABAC) roles for training job execution roles. Amazon SageMaker Inference now supports G6 instance types.
* `github.com/aws/aws-sdk-go-v2/service/signer`: [v1.22.7](service/signer/CHANGELOG.md#v1227-2024-04-30)
  * **Documentation**: Documentation updates for AWS Signer. Adds cross-account signing constraint and definitions for cross-account actions.

# Release (2024-04-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.16.0](service/connectcases/CHANGELOG.md#v1160-2024-04-29)
  * **Feature**: This feature releases DeleteField, DeletedLayout, and DeleteTemplate API's
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.25.0](service/inspector2/CHANGELOG.md#v1250-2024-04-29)
  * **Feature**: Update Inspector2 to include new Agentless API parameters.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.23.0](service/timestreamquery/CHANGELOG.md#v1230-2024-04-29)
  * **Feature**: This change allows users to update and describe account settings associated with their accounts.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.37.0](service/transcribe/CHANGELOG.md#v1370-2024-04-29)
  * **Feature**: This update provides error messaging for generative call summarization in Transcribe Call Analytics
* `github.com/aws/aws-sdk-go-v2/service/trustedadvisor`: [v1.4.0](service/trustedadvisor/CHANGELOG.md#v140-2024-04-29)
  * **Feature**: This release adds the BatchUpdateRecommendationResourceExclusion API to support batch updates of Recommendation Resource exclusion statuses and introduces a new exclusion status filter to the ListRecommendationResources and ListOrganizationRecommendationResources APIs.

# Release (2024-04-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.27.0](service/codepipeline/CHANGELOG.md#v1270-2024-04-26)
  * **Feature**: Add ability to manually and automatically roll back a pipeline stage to a previously successful execution.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.37.0](service/cognitoidentityprovider/CHANGELOG.md#v1370-2024-04-26)
  * **Feature**: Add LimitExceededException to SignUp errors
* `github.com/aws/aws-sdk-go-v2/service/connectcampaigns`: [v1.11.0](service/connectcampaigns/CHANGELOG.md#v1110-2024-04-26)
  * **Feature**: This release adds support for specifying if Answering Machine should wait for prompt sound.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.21.0](service/marketplaceentitlementservice/CHANGELOG.md#v1210-2024-04-26)
  * **Feature**: Releasing minor endpoint updates.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.11.0](service/oam/CHANGELOG.md#v1110-2024-04-26)
  * **Feature**: This release introduces support for Source Accounts to define which Metrics and Logs to share with the Monitoring Account
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.78.0](service/rds/CHANGELOG.md#v1780-2024-04-26)
  * **Feature**: SupportsLimitlessDatabase field added to describe-db-engine-versions to indicate whether the DB engine version supports Aurora Limitless Database.
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.22.0](service/support/CHANGELOG.md#v1220-2024-04-26)
  * **Feature**: Releasing minor endpoint updates.

# Release (2024-04-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.32.0](service/appsync/CHANGELOG.md#v1320-2024-04-25)
  * **Feature**: UpdateGraphQLAPI documentation update and datasource introspection secret arn update
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.32.0](service/fms/CHANGELOG.md#v1320-2024-04-25)
  * **Feature**: AWS Firewall Manager adds support for network ACL policies to manage Amazon Virtual Private Cloud (VPC) network access control lists (ACLs) for accounts in your organization.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.35.0](service/ivs/CHANGELOG.md#v1350-2024-04-25)
  * **Feature**: Bug Fix: IVS does not support arns with the `svs` prefix
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.13.0](service/ivsrealtime/CHANGELOG.md#v1130-2024-04-25)
  * **Feature**: Bug Fix: IVS Real Time does not support ARNs using the `svs` prefix.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.77.3](service/rds/CHANGELOG.md#v1773-2024-04-25)
  * **Documentation**: Updates Amazon RDS documentation for setting local time zones for RDS for Db2 DB instances.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.27.0](service/sfn/CHANGELOG.md#v1270-2024-04-25)
  * **Feature**: Add new ValidateStateMachineDefinition operation, which performs syntax checking on the definition of a Amazon States Language (ASL) state machine.

# Release (2024-04-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.37.0](service/datasync/CHANGELOG.md#v1370-2024-04-24)
  * **Feature**: This change allows users to disable and enable the schedules associated with their tasks.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.159.0](service/ec2/CHANGELOG.md#v11590-2024-04-24)
  * **Feature**: Launching capability for customers to enable or disable automatic assignment of public IPv4 addresses to their network interface
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.28.0](service/emrcontainers/CHANGELOG.md#v1280-2024-04-24)
  * **Feature**: EMRonEKS Service support for SecurityConfiguration enforcement for Spark Jobs.
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.10.0](service/entityresolution/CHANGELOG.md#v1100-2024-04-24)
  * **Feature**: Support Batch Unique IDs Deletion.
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.31.0](service/gamelift/CHANGELOG.md#v1310-2024-04-24)
  * **Feature**: Amazon GameLift releases container fleets support for public preview. Deploy Linux-based containerized game server software for hosting on Amazon GameLift.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.50.0](service/ssm/CHANGELOG.md#v1500-2024-04-24)
  * **Feature**: Add SSM DescribeInstanceProperties API to public AWS SDK.

# Release (2024-04-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.8.0](service/bedrock/CHANGELOG.md#v180-2024-04-23)
  * **Feature**: This release introduces Model Evaluation and Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.8.0](service/bedrockagent/CHANGELOG.md#v180-2024-04-23)
  * **Feature**: Introducing the ability to create multiple data sources per knowledge base, specify S3 buckets as data sources from external accounts, and exposing levers to define the deletion behavior of the underlying vector store data.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.8.0](service/bedrockagentruntime/CHANGELOG.md#v180-2024-04-23)
  * **Feature**: This release introduces zero-setup file upload support for the RetrieveAndGenerate API. This allows you to chat with your data without setting up a Knowledge Base.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.8.0](service/bedrockruntime/CHANGELOG.md#v180-2024-04-23)
  * **Feature**: This release introduces Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.38.0](service/costexplorer/CHANGELOG.md#v1380-2024-04-23)
  * **Feature**: Added additional metadata that might be applicable to your reservation recommendations.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.158.0](service/ec2/CHANGELOG.md#v11580-2024-04-23)
  * **Feature**: This release introduces EC2 AMI Deregistration Protection, a new AMI property that can be enabled by customers to protect an AMI against an unintended deregistration. This release also enables the AMI owners to view the AMI 'LastLaunchedTime' in DescribeImages API.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.24.5](service/pi/CHANGELOG.md#v1245-2024-04-23)
  * **Documentation**: Clarifies how aggregation works for GetResourceMetrics in the Performance Insights API.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.77.2](service/rds/CHANGELOG.md#v1772-2024-04-23)
  * **Documentation**: Fix the example ARN for ModifyActivityStreamRequest
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.18.0](service/workspacesweb/CHANGELOG.md#v1180-2024-04-23)
  * **Feature**: Added InstanceType and MaxConcurrentSessions parameters on CreatePortal and UpdatePortal Operations as well as the ability to read Customer Managed Key & Additional Encryption Context parameters on supported resources (Portal, BrowserSettings, UserSettings, IPAccessSettings)

# Release (2024-04-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.7.0](service/bedrockagent/CHANGELOG.md#v170-2024-04-22)
  * **Feature**: Releasing the support for simplified configuration and return of control
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.7.0](service/bedrockagentruntime/CHANGELOG.md#v170-2024-04-22)
  * **Feature**: Releasing the support for simplified configuration and return of control
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.10.0](service/paymentcryptography/CHANGELOG.md#v1100-2024-04-22)
  * **Feature**: Adding support to TR-31/TR-34 exports for optional headers, allowing customers to add additional metadata (such as key version and KSN) when exporting keys from the service.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.17.5](service/redshiftserverless/CHANGELOG.md#v1175-2024-04-22)
  * **Documentation**: Updates description of schedule field for scheduled actions.
* `github.com/aws/aws-sdk-go-v2/service/route53profiles`: [v1.0.0](service/route53profiles/CHANGELOG.md#v100-2024-04-22)
  * **Release**: New AWS service client module
  * **Feature**: Route 53 Profiles allows you to apply a central DNS configuration across many VPCs regardless of account.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.137.0](service/sagemaker/CHANGELOG.md#v11370-2024-04-22)
  * **Feature**: This release adds support for Real-Time Collaboration and Shared Space for JupyterLab App on SageMaker Studio.
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.29.6](service/servicediscovery/CHANGELOG.md#v1296-2024-04-22)
  * **Documentation**: This release adds examples to several Cloud Map actions.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.47.0](service/transfer/CHANGELOG.md#v1470-2024-04-22)
  * **Feature**: Adding new API to support remote directory listing using SFTP connector

# Release (2024-04-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.80.0](service/glue/CHANGELOG.md#v1800-2024-04-19)
  * **Feature**: Adding RowFilter in the response for GetUnfilteredTableMetadata API
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.14.0](service/internetmonitor/CHANGELOG.md#v1140-2024-04-19)
  * **Feature**: This update introduces the GetInternetEvent and ListInternetEvents APIs, which provide access to internet events displayed on the Amazon CloudWatch Internet Weather Map.
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.33.0](service/personalize/CHANGELOG.md#v1330-2024-04-19)
  * **Feature**: This releases auto training capability while creating a solution and automatically syncing latest solution versions when creating/updating a campaign

# Release (2024-04-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.26.0](service/drs/CHANGELOG.md#v1260-2024-04-18)
  * **Feature**: Outpost ARN added to Source Server and Recovery Instance
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.19.0](service/emrserverless/CHANGELOG.md#v1190-2024-04-18)
  * **Feature**: This release adds the capability to publish detailed Spark engine metrics to Amazon Managed Service for Prometheus (AMP) for  enhanced monitoring for Spark jobs.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.42.0](service/guardduty/CHANGELOG.md#v1420-2024-04-18)
  * **Feature**: Added IPv6Address fields for local and remote IP addresses
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.62.0](service/quicksight/CHANGELOG.md#v1620-2024-04-18)
  * **Feature**: This release adds support for the Cross Sheet Filter and Control features, and support for warnings in asset imports for any permitted errors encountered during execution
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.11.0](service/rolesanywhere/CHANGELOG.md#v1110-2024-04-18)
  * **Feature**: This release introduces the PutAttributeMapping and DeleteAttributeMapping APIs. IAM Roles Anywhere now provides the capability to define a set of mapping rules, allowing customers to specify which data is extracted from their X.509 end-entity certificates.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.136.0](service/sagemaker/CHANGELOG.md#v11360-2024-04-18)
  * **Feature**: Removed deprecated enum values and updated API documentation.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.39.0](service/workspaces/CHANGELOG.md#v1390-2024-04-18)
  * **Feature**: Adds new APIs for managing and sharing WorkSpaces BYOL configuration across accounts.

# Release (2024-04-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.157.0](service/ec2/CHANGELOG.md#v11570-2024-04-17)
  * **Feature**: Documentation updates for Elastic Compute Cloud (EC2).
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.5.0](service/qbusiness/CHANGELOG.md#v150-2024-04-17)
  * **Feature**: This release adds support for IAM Identity Center (IDC) as the identity gateway for Q Business. It also allows users to provide an explicit intent for Q Business to identify how the Chat request should be handled.

# Release (2024-04-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.6.0](service/bedrockagent/CHANGELOG.md#v160-2024-04-16)
  * **Feature**: For Create Agent API, the agentResourceRoleArn parameter is no longer required.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.18.0](service/emrserverless/CHANGELOG.md#v1180-2024-04-16)
  * **Feature**: This release adds support for shuffle optimized disks that allow larger disk sizes and higher IOPS to efficiently run shuffle heavy workloads.
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.9.0](service/entityresolution/CHANGELOG.md#v190-2024-04-16)
  * **Feature**: Cross Account Resource Support .
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.38.0](service/iotwireless/CHANGELOG.md#v1380-2024-04-16)
  * **Feature**: Add PublicGateways in the GetWirelessStatistics call response, indicating the LoRaWAN public network accessed by the device.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.32.0](service/lakeformation/CHANGELOG.md#v1320-2024-04-16)
  * **Feature**: This release adds Lake Formation managed RAM support for the 4 APIs - "DescribeLakeFormationIdentityCenterConfiguration", "CreateLakeFormationIdentityCenterConfiguration", "DescribeLakeFormationIdentityCenterConfiguration", and "DeleteLakeFormationIdentityCenterConfiguration"
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.13.0](service/m2/CHANGELOG.md#v1130-2024-04-16)
  * **Feature**: Adding new ListBatchJobRestartPoints API and support for restart batch job.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.11.0](service/mediapackagev2/CHANGELOG.md#v1110-2024-04-16)
  * **Feature**: Dash v2 is a MediaPackage V2 feature to support egressing on DASH manifest format.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.39.0](service/outposts/CHANGELOG.md#v1390-2024-04-16)
  * **Feature**: This release adds new APIs to allow customers to configure their Outpost capacity at order-time.
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.30.0](service/wellarchitected/CHANGELOG.md#v1300-2024-04-16)
  * **Feature**: AWS Well-Architected now has a Connector for Jira to allow customers to efficiently track workload risks and improvement efforts and create closed-loop mechanisms.

# Release (2024-04-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.50.0](service/cloudformation/CHANGELOG.md#v1500-2024-04-12)
  * **Feature**: Adding support for the new parameter "IncludePropertyValues" in the CloudFormation DescribeChangeSet API. When this parameter is included, the DescribeChangeSet response will include more detailed information such as before and after values for the resource properties that will change.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.46.5](service/configservice/CHANGELOG.md#v1465-2024-04-12)
  * **Documentation**: Updates documentation for AWS Config
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.79.0](service/glue/CHANGELOG.md#v1790-2024-04-12)
  * **Feature**: Modifying request for GetUnfilteredTableMetadata for view-related fields.
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.24.0](service/healthlake/CHANGELOG.md#v1240-2024-04-12)
  * **Feature**: Added new CREATE_FAILED status for data stores. Added new errorCause to DescribeFHIRDatastore API and ListFHIRDatastores API response for additional insights into data store creation and deletion workflows.
* `github.com/aws/aws-sdk-go-v2/service/iotfleethub`: [v1.20.5](service/iotfleethub/CHANGELOG.md#v1205-2024-04-12)
  * **Documentation**: Documentation updates for AWS IoT Fleet Hub to clarify that Fleet Hub supports organization instance of IAM Identity Center.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.31.0](service/kms/CHANGELOG.md#v1310-2024-04-12)
  * **Feature**: This feature supports the ability to specify a custom rotation period for automatic key rotations, the ability to perform on-demand key rotations, and visibility into your key material rotations.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.38.0](service/mediatailor/CHANGELOG.md#v1380-2024-04-12)
  * **Feature**: Added InsertionMode to PlaybackConfigurations. This setting controls whether players can use stitched or guided ad insertion. The default for players that do not specify an insertion mode is stitched.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.8.1](service/neptunegraph/CHANGELOG.md#v181-2024-04-12)
  * **Documentation**: Update to API documentation to resolve customer reported issues.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.38.0](service/outposts/CHANGELOG.md#v1380-2024-04-12)
  * **Feature**: This release adds EXPEDITORS as a valid shipment carrier.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.44.0](service/redshift/CHANGELOG.md#v1440-2024-04-12)
  * **Feature**: Adds support for Amazon Redshift DescribeClusterSnapshots API to include Snapshot ARN response field.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.46.0](service/transfer/CHANGELOG.md#v1460-2024-04-12)
  * **Feature**: This change releases support for importing self signed certificates to the Transfer Family for sending outbound file transfers over TLS/HTTPS.

# Release (2024-04-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.37.0](service/batch/CHANGELOG.md#v1370-2024-04-11)
  * **Feature**: This release adds the task properties field to attempt details and the name field on EKS container detail.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.36.0](service/cloudfront/CHANGELOG.md#v1360-2024-04-11)
  * **Feature**: CloudFront origin access control extends support to AWS Lambda function URLs and AWS Elemental MediaPackage v2 origins.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.38.0](service/cloudwatch/CHANGELOG.md#v1380-2024-04-11)
  * **Feature**: This release adds support for Metric Characteristics for CloudWatch Anomaly Detection. Anomaly Detector now takes Metric Characteristics object with Periodic Spikes boolean field that tells Anomaly Detection that spikes that repeat at the same time every week are part of the expected pattern.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.34.1](service/codebuild/CHANGELOG.md#v1341-2024-04-11)
  * **Documentation**: Support access tokens for Bitbucket sources
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.32.0](service/iam/CHANGELOG.md#v1320-2024-04-11)
  * **Feature**: For CreateOpenIDConnectProvider API, the ThumbprintList parameter is no longer required.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.51.0](service/medialive/CHANGELOG.md#v1510-2024-04-11)
  * **Feature**: AWS Elemental MediaLive introduces workflow monitor, a new feature that enables the visualization and monitoring of your media workflows. Create signal maps of your existing workflows and monitor them by creating notification and monitoring template groups.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.20.0](service/omics/CHANGELOG.md#v1200-2024-04-11)
  * **Feature**: This release adds support for retrieval of S3 direct access metadata on sequence stores and read sets, and adds support for SHA256up and SHA512up HealthOmics ETags.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.77.1](service/rds/CHANGELOG.md#v1771-2024-04-11)
  * **Documentation**: Updates Amazon RDS documentation for Standard Edition 2 support in RDS Custom for Oracle.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.44.5](service/s3control/CHANGELOG.md#v1445-2024-04-11)
  * **Documentation**: Documentation updates for Amazon S3-control.

# Release (2024-04-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.12.0](service/cleanrooms/CHANGELOG.md#v1120-2024-04-10)
  * **Feature**: AWS Clean Rooms Differential Privacy is now fully available. Differential privacy protects against user-identification attempts.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.96.0](service/connect/CHANGELOG.md#v1960-2024-04-10)
  * **Feature**: This release adds new Submit Auto Evaluation Action for Amazon Connect Rules.
* `github.com/aws/aws-sdk-go-v2/service/networkmonitor`: [v1.3.1](service/networkmonitor/CHANGELOG.md#v131-2024-04-10)
  * **Documentation**: Examples were added to CloudWatch Network Monitor commands.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.6.0](service/qconnect/CHANGELOG.md#v160-2024-04-10)
  * **Feature**: This release adds a new QiC public API updateSession and updates an existing QiC public API createSession
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.40.0](service/rekognition/CHANGELOG.md#v1400-2024-04-10)
  * **Feature**: Added support for ContentType to content moderation detections.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.3.0](service/supplychain/CHANGELOG.md#v130-2024-04-10)
  * **Feature**: This release includes API SendDataIntegrationEvent for AWS Supply Chain
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.5.0](service/workspacesthinclient/CHANGELOG.md#v150-2024-04-10)
  * **Feature**: Adding tags field to SoftwareSet. Removing tags fields from Summary objects. Changing the list of exceptions in tagging APIs. Fixing an issue where the SDK returns empty tags in Get APIs.

# Release (2024-04-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.34.0](service/codebuild/CHANGELOG.md#v1340-2024-04-09)
  * **Feature**: Add new webhook filter types for GitHub webhooks
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.53.0](service/mediaconvert/CHANGELOG.md#v1530-2024-04-09)
  * **Feature**: This release includes support for bringing your own fonts to use for burn-in or DVB-Sub captioning workflows.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.29.0](service/pinpoint/CHANGELOG.md#v1290-2024-04-09)
  * **Feature**: The OrchestrationSendingRoleArn has been added to the email channel and is used to send emails from campaigns or journeys.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.77.0](service/rds/CHANGELOG.md#v1770-2024-04-09)
  * **Feature**: This release adds support for specifying the CA certificate to use for the new db instance when restoring from db snapshot, restoring from s3, restoring to point in time, and creating a db instance read replica.

# Release (2024-04-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.0.0](service/controlcatalog/CHANGELOG.md#v100-2024-04-08)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for AWS Control Catalog, a central catalog for AWS managed controls. This release includes 3 new APIs - ListDomains, ListObjectives, and ListCommonControls - that vend high-level data to categorize controls across the AWS platform.
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.28.0](service/mgn/CHANGELOG.md#v1280-2024-04-08)
  * **Feature**: Added USE_SOURCE as default option to LaunchConfigurationTemplate bootMode parameter.
* `github.com/aws/aws-sdk-go-v2/service/networkmonitor`: [v1.3.0](service/networkmonitor/CHANGELOG.md#v130-2024-04-08)
  * **Feature**: Updated the allowed monitorName length for CloudWatch Network Monitor.

# Release (2024-04-05)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.61.0](service/quicksight/CHANGELOG.md#v1610-2024-04-05)
  * **Feature**: Adding IAMIdentityCenterInstanceArn parameter to CreateAccountSubscription
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.22.0](service/resourcegroups/CHANGELOG.md#v1220-2024-04-05)
  * **Feature**: Added a new QueryErrorCode RESOURCE_TYPE_NOT_SUPPORTED that is returned by the ListGroupResources operation if the group query contains unsupported resource types.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.13.0](service/verifiedpermissions/CHANGELOG.md#v1130-2024-04-05)
  * **Feature**: Adding BatchIsAuthorizedWithToken API which supports multiple authorization requests against a PolicyStore given a bearer token.

# Release (2024-04-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.21](service/b2bi/CHANGELOG.md#v100-preview21-2024-04-04)
  * **Feature**: Adding support for X12 5010 HIPAA EDI version and associated transaction sets.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.11.0](service/cleanrooms/CHANGELOG.md#v1110-2024-04-04)
  * **Feature**: Feature: New schemaStatusDetails field to the existing Schema object that displays a status on Schema API responses to show whether a schema is queryable or not. New BatchGetSchemaAnalysisRule API to retrieve multiple schemaAnalysisRules using a single API call.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.156.0](service/ec2/CHANGELOG.md#v11560-2024-04-04)
  * **Feature**: Amazon EC2 G6 instances powered by NVIDIA L4 Tensor Core GPUs can be used for a wide range of graphics-intensive and machine learning use cases. Gr6 instances also feature NVIDIA L4 GPUs and can be used for graphics workloads with higher memory requirements.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.27.0](service/emrcontainers/CHANGELOG.md#v1270-2024-04-04)
  * **Feature**: This release adds support for integration with EKS AccessEntry APIs to enable automatic Cluster Access for EMR on EKS.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.34.0](service/ivs/CHANGELOG.md#v1340-2024-04-04)
  * **Feature**: API update to include an SRT ingest endpoint and passphrase for all channels.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.12.0](service/verifiedpermissions/CHANGELOG.md#v1120-2024-04-04)
  * **Feature**: Adds GroupConfiguration field to Identity Source API's

# Release (2024-04-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.4.0](service/cleanroomsml/CHANGELOG.md#v140-2024-04-03)
  * **Feature**: The release includes a public SDK for AWS Clean Rooms ML APIs, making them globally available to developers worldwide.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.49.0](service/cloudformation/CHANGELOG.md#v1490-2024-04-03)
  * **Feature**: This release would return a new field - PolicyAction in cloudformation's existed DescribeChangeSetResponse, showing actions we are going to apply on the physical resource (e.g., Delete, Retain) according to the user's template
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.8.0](service/datazone/CHANGELOG.md#v180-2024-04-03)
  * **Feature**: This release supports the feature of dataQuality to enrich asset with dataQualityResult in Amazon DataZone.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.34.0](service/docdb/CHANGELOG.md#v1340-2024-04-03)
  * **Feature**: This release adds Global Cluster Switchover capability which enables you to change your global cluster's primary AWS Region, the region that serves writes, while preserving the replication between all regions in the global cluster.
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.27.0](service/groundstation/CHANGELOG.md#v1270-2024-04-03)
  * **Feature**: This release adds visibilityStartTime and visibilityEndTime to DescribeContact and ListContacts responses.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.54.0](service/lambda/CHANGELOG.md#v1540-2024-04-03)
  * **Feature**: Add Ruby 3.3 (ruby3.3) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.50.0](service/medialive/CHANGELOG.md#v1500-2024-04-03)
  * **Feature**: Cmaf Ingest outputs are now supported in Media Live
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.8.0](service/medicalimaging/CHANGELOG.md#v180-2024-04-03)
  * **Feature**: SearchImageSets API now supports following enhancements - Additional support for searching on UpdatedAt and SeriesInstanceUID - Support for searching existing filters between dates/times - Support for sorting the search result by Ascending/Descending - Additional parameters returned in the response
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.45.0](service/transfer/CHANGELOG.md#v1450-2024-04-03)
  * **Feature**: Add ability to specify Security Policies for SFTP Connectors

# Release (2024-04-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.41.7](service/ecs/CHANGELOG.md#v1417-2024-04-02)
  * **Documentation**: Documentation only update for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.78.0](service/glue/CHANGELOG.md#v1780-2024-04-02)
  * **Feature**: Adding View related fields to responses of read-only Table APIs.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.12.5](service/ivschat/CHANGELOG.md#v1125-2024-04-02)
  * **Documentation**: Doc-only update. Changed "Resources" to "Key Concepts" in docs and updated text.
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.10.0](service/rolesanywhere/CHANGELOG.md#v1100-2024-04-02)
  * **Feature**: This release increases the limit on the roleArns request parameter for the *Profile APIs that support it. This parameter can now take up to 250 role ARNs.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.47.2](service/securityhub/CHANGELOG.md#v1472-2024-04-02)
  * **Documentation**: Documentation updates for AWS Security Hub

# Release (2024-04-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.37.0](service/cloudwatch/CHANGELOG.md#v1370-2024-04-01)
  * **Feature**: This release adds support for CloudWatch Anomaly Detection on cross-account metrics. SingleMetricAnomalyDetector and MetricDataQuery inputs to Anomaly Detection APIs now take an optional AccountId field.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.7.0](service/datazone/CHANGELOG.md#v170-2024-04-01)
  * **Feature**: This release supports the feature of AI recommendations for descriptions to enrich the business data catalog in Amazon DataZone.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.0.0](service/deadline/CHANGELOG.md#v100-2024-04-01)
  * **Release**: New AWS service client module
  * **Feature**: AWS Deadline Cloud is a new fully managed service that helps customers set up, deploy, and scale rendering projects in minutes, so they can improve the efficiency of their rendering pipelines and take on more projects.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.39.5](service/emr/CHANGELOG.md#v1395-2024-04-01)
  * **Documentation**: This release fixes a broken link in the documentation.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.37.0](service/lightsail/CHANGELOG.md#v1370-2024-04-01)
  * **Feature**: This release adds support to upgrade the TLS version of the distribution.

# Release (2024-03-29)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.20](service/b2bi/CHANGELOG.md#v100-preview20-2024-03-29)
  * **Feature**: Supporting new EDI X12 transaction sets for X12 versions 4010, 4030, and 5010.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.33.0](service/codebuild/CHANGELOG.md#v1330-2024-03-29)
  * **Feature**: Add new fleet status code for Reserved Capacity.
* `github.com/aws/aws-sdk-go-v2/service/codeconnections`: [v1.0.0](service/codeconnections/CHANGELOG.md#v100-2024-03-29)
  * **Release**: New AWS service client module
  * **Feature**: Duplicating the CodeStar Connections service into the new, rebranded AWS CodeConnections service.
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.13.0](service/internetmonitor/CHANGELOG.md#v1130-2024-03-29)
  * **Feature**: This release adds support to allow customers to track cross account monitors through ListMonitor, GetMonitor, ListHealthEvents, GetHealthEvent, StartQuery APIs.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.37.0](service/iotwireless/CHANGELOG.md#v1370-2024-03-29)
  * **Feature**: Add support for retrieving key historical and live metrics for LoRaWAN devices and gateways
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.26.0](service/marketplacecatalog/CHANGELOG.md#v1260-2024-03-29)
  * **Feature**: This release enhances the ListEntities API to support ResaleAuthorizationId filter and sort for OfferEntity in the request and the addition of a ResaleAuthorizationId field in the response of OfferSummary.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.8.0](service/neptunegraph/CHANGELOG.md#v180-2024-03-29)
  * **Feature**: Add the new API Start-Import-Task for Amazon Neptune Analytics.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.135.0](service/sagemaker/CHANGELOG.md#v11350-2024-03-29)
  * **Feature**: This release adds support for custom images for the CodeEditor App on SageMaker Studio

# Release (2024-03-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.13.0](service/codecatalyst/CHANGELOG.md#v1130-2024-03-28)
  * **Feature**: This release adds support for understanding pending changes to subscriptions by including two new response parameters for the GetSubscription API for Amazon CodeCatalyst.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.34.0](service/computeoptimizer/CHANGELOG.md#v1340-2024-03-28)
  * **Feature**: This release enables AWS Compute Optimizer to analyze and generate recommendations with a new customization preference, Memory Utilization.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.155.0](service/ec2/CHANGELOG.md#v11550-2024-03-28)
  * **Feature**: Amazon EC2 C7gd, M7gd and R7gd metal instances with up to 3.8 TB of local NVMe-based SSD block-level storage have up to 45% improved real-time NVMe storage performance than comparable Graviton2-based instances.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.42.0](service/eks/CHANGELOG.md#v1420-2024-03-28)
  * **Feature**: Add multiple customer error code to handle customer caused failure when managing EKS node groups
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.41.0](service/guardduty/CHANGELOG.md#v1410-2024-03-28)
  * **Feature**: Add EC2 support for GuardDuty Runtime Monitoring auto management.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.7.0](service/neptunegraph/CHANGELOG.md#v170-2024-03-28)
  * **Feature**: Update ImportTaskCancelled waiter to evaluate task state correctly and minor documentation changes.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.10.0](service/oam/CHANGELOG.md#v1100-2024-03-28)
  * **Feature**: This release adds support for sharing AWS::InternetMonitor::Monitor resources.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.60.0](service/quicksight/CHANGELOG.md#v1600-2024-03-28)
  * **Feature**: Amazon QuickSight: Adds support for setting up VPC Endpoint restrictions for accessing QuickSight Website.

# Release (2024-03-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.36.0](service/batch/CHANGELOG.md#v1360-2024-03-27)
  * **Feature**: This feature allows AWS Batch to support configuration of imagePullSecrets and allowPrivilegeEscalation for jobs running on EKS
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.5.0](service/bedrockagent/CHANGELOG.md#v150-2024-03-27)
  * **Feature**: This changes introduces metadata documents statistics and also updates the documentation for bedrock agent.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.6.0](service/bedrockagentruntime/CHANGELOG.md#v160-2024-03-27)
  * **Feature**: This release introduces filtering support on Retrieve and RetrieveAndGenerate APIs.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.38.0](service/elasticache/CHANGELOG.md#v1380-2024-03-27)
  * **Feature**: Added minimum capacity to  Amazon ElastiCache Serverless. This feature allows customer to ensure minimum capacity even without current load
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.28.5](service/secretsmanager/CHANGELOG.md#v1285-2024-03-27)
  * **Documentation**: Documentation updates for Secrets Manager

# Release (2024-03-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.5.0](service/bedrockagentruntime/CHANGELOG.md#v150-2024-03-26)
  * **Feature**: This release adds support to customize prompts sent through the RetrieveAndGenerate API in Agents for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.37.0](service/costexplorer/CHANGELOG.md#v1370-2024-03-26)
  * **Feature**: Adds support for backfill of cost allocation tags, with new StartCostAllocationTagBackfill and ListCostAllocationTagBackfillHistory API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.154.0](service/ec2/CHANGELOG.md#v11540-2024-03-26)
  * **Feature**: Documentation updates for Elastic Compute Cloud (EC2).
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.41.5](service/ecs/CHANGELOG.md#v1415-2024-03-26)
  * **Documentation**: This is a documentation update for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.24.0](service/finspace/CHANGELOG.md#v1240-2024-03-26)
  * **Feature**: Add new operation delete-kx-cluster-node and add status parameter to list-kx-cluster-node operation.

# Release (2024-03-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.13.12](feature/dynamodb/attributevalue/CHANGELOG.md#v11312-2024-03-25)
  * **Bug Fix**: Removes some duplicated reflection-based calls in the marshaler.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.32.0](service/codebuild/CHANGELOG.md#v1320-2024-03-25)
  * **Feature**: Supporting GitLab and GitLab Self Managed as source types in AWS CodeBuild.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.153.0](service/ec2/CHANGELOG.md#v11530-2024-03-25)
  * **Feature**: Added support for ModifyInstanceMetadataDefaults and GetInstanceMetadataDefaults to set Instance Metadata Service account defaults
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.41.4](service/ecs/CHANGELOG.md#v1414-2024-03-25)
  * **Documentation**: Documentation only update for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.26.0](service/emrcontainers/CHANGELOG.md#v1260-2024-03-25)
  * **Feature**: This release increases the number of supported job template parameters from 20 to 100.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.23.0](service/globalaccelerator/CHANGELOG.md#v1230-2024-03-25)
  * **Feature**: AWS Global Accelerator now supports cross-account sharing for bring your own IP addresses.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.49.0](service/medialive/CHANGELOG.md#v1490-2024-03-25)
  * **Feature**: Exposing TileMedia H265 options
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.134.0](service/sagemaker/CHANGELOG.md#v11340-2024-03-25)
  * **Feature**: Introduced support for the following new instance types on SageMaker Studio for JupyterLab and CodeEditor applications: m6i, m6id, m7i, c6i, c6id, c7i, r6i, r6id, r7i, and p5

# Release (2024-03-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.28.4](service/firehose/CHANGELOG.md#v1284-2024-03-22)
  * **Documentation**: Updates Amazon Firehose documentation for message regarding Enforcing Tags IAM Policy.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.50.0](service/kendra/CHANGELOG.md#v1500-2024-03-22)
  * **Feature**: Documentation update, March 2024. Corrects some docs for Amazon Kendra.
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.28.0](service/pricing/CHANGELOG.md#v1280-2024-03-22)
  * **Feature**: Add ResourceNotFoundException to ListPriceLists and GetPriceListFileUrl APIs
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.9.0](service/rolesanywhere/CHANGELOG.md#v190-2024-03-22)
  * **Feature**: This release relaxes constraints on the durationSeconds request parameter for the *Profile APIs that support it. This parameter can now take on values that go up to 43200.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.47.0](service/securityhub/CHANGELOG.md#v1470-2024-03-22)
  * **Feature**: Added new resource detail object to ASFF, including resource for LastKnownExploitAt

# Release (2024-03-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/ec2/imds`: [v1.16.0](feature/ec2/imds/CHANGELOG.md#v1160-2024-03-21)
  * **Feature**: Add config switch `DisableDefaultTimeout` that allows you to disable the default operation timeout (5 seconds) for IMDS calls.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.26.0](service/codeartifact/CHANGELOG.md#v1260-2024-03-21)
  * **Feature**: This release adds Package groups to CodeArtifact so you can more conveniently configure package origin controls for multiple packages.

# Release (2024-03-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.29.0](service/accessanalyzer/CHANGELOG.md#v1290-2024-03-20)
  * **Feature**: This release adds support for policy validation and external access findings for DynamoDB tables and streams. IAM Access Analyzer helps you author functional and secure resource-based policies and identify cross-account access. Updated service API, documentation, and paginators.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.31.2](service/codebuild/CHANGELOG.md#v1312-2024-03-20)
  * **Documentation**: This release adds support for new webhook events (RELEASED and PRERELEASED) and filter types (TAG_NAME and RELEASE_NAME).
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.95.0](service/connect/CHANGELOG.md#v1950-2024-03-20)
  * **Feature**: This release updates the *InstanceStorageConfig APIs to support a new ResourceType: REAL_TIME_CONTACT_ANALYSIS_CHAT_SEGMENTS. Use this resource type to enable streaming for real-time analysis of chat contacts and to associate a Kinesis stream where real-time analysis chat segments will be published.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.31.0](service/dynamodb/CHANGELOG.md#v1310-2024-03-20)
  * **Feature**: This release introduces 3 new APIs ('GetResourcePolicy', 'PutResourcePolicy' and 'DeleteResourcePolicy') and modifies the existing 'CreateTable' API for the resource-based policy support. It also modifies several APIs to accept a 'TableArn' for the 'TableName' parameter.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.12.0](service/managedblockchainquery/CHANGELOG.md#v1120-2024-03-20)
  * **Feature**: AMB Query: update GetTransaction to include transactionId as input
* `github.com/aws/aws-sdk-go-v2/service/savingsplans`: [v1.19.0](service/savingsplans/CHANGELOG.md#v1190-2024-03-20)
  * **Feature**: Introducing the Savings Plans Return feature enabling customers to return their Savings Plans within 7 days of purchase.

# Release (2024-03-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.35.0](service/cloudwatchlogs/CHANGELOG.md#v1350-2024-03-19)
  * **Feature**: Update LogSamples field in Anomaly model to be a list of LogEvent
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.152.0](service/ec2/CHANGELOG.md#v11520-2024-03-19)
  * **Feature**: This release adds the new DescribeMacHosts API operation for getting information about EC2 Mac Dedicated Hosts. Users can now see the latest macOS versions that their underlying Apple Mac can support without needing to be updated.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.23.0](service/finspace/CHANGELOG.md#v1230-2024-03-19)
  * **Feature**: Adding new attributes readWrite and onDemand to dataview models for Database Maintenance operations.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.11.0](service/managedblockchainquery/CHANGELOG.md#v1110-2024-03-19)
  * **Feature**: Introduces a new API for Amazon Managed Blockchain Query: ListFilteredTransactionEvents.

# Release (2024-03-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.26.0
  * **Feature**: Add no-op rate limiting implementation `ratelimit.None`, which allows disabling of client-side retry quota behavior.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.48.0](service/cloudformation/CHANGELOG.md#v1480-2024-03-18)
  * **Feature**: This release supports for a new API ListStackSetAutoDeploymentTargets, which provider auto-deployment configuration as a describable resource. Customers can now view the specific combinations of regions and OUs that are being auto-deployed.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.30.0](service/kms/CHANGELOG.md#v1300-2024-03-18)
  * **Feature**: Adds the ability to use the default policy name by omitting the policyName parameter in calls to PutKeyPolicy and GetKeyPolicy
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.37.0](service/mediatailor/CHANGELOG.md#v1370-2024-03-18)
  * **Feature**: This release adds support to allow customers to show different content within a channel depending on metadata associated with the viewer.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.76.0](service/rds/CHANGELOG.md#v1760-2024-03-18)
  * **Feature**: This release launches the ModifyIntegration API and support for data filtering for zero-ETL Integrations.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.53.0](service/s3/CHANGELOG.md#v1530-2024-03-18)
  * **Feature**: Fix two issues with response root node names.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.22.4](service/timestreamquery/CHANGELOG.md#v1224-2024-03-18)
  * **Documentation**: Documentation updates, March 2024

# Release (2024-03-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.34.0](service/backup/CHANGELOG.md#v1340-2024-03-15)
  * **Feature**: This release introduces a boolean attribute ManagedByAWSBackupOnly as part of ListRecoveryPointsByResource api to filter the recovery points based on ownership. This attribute can be used to filter out the recovery points protected by AWSBackup.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.31.0](service/codebuild/CHANGELOG.md#v1310-2024-03-15)
  * **Feature**: AWS CodeBuild now supports overflow behavior on Reserved Capacity.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.94.0](service/connect/CHANGELOG.md#v1940-2024-03-15)
  * **Feature**: This release adds Hierarchy based Access Control fields to Security Profile public APIs and adds support for UserAttributeFilter to SearchUsers API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.151.0](service/ec2/CHANGELOG.md#v11510-2024-03-15)
  * **Feature**: Add media accelerator and neuron device information on the describe instance types API.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.25.0](service/kinesisanalyticsv2/CHANGELOG.md#v1250-2024-03-15)
  * **Feature**: Support for Flink 1.18 in Managed Service for Apache Flink
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.52.1](service/s3/CHANGELOG.md#v1521-2024-03-15)
  * **Documentation**: Documentation updates for Amazon S3.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.133.0](service/sagemaker/CHANGELOG.md#v11330-2024-03-15)
  * **Feature**: Adds m6i, m6id, m7i, c6i, c6id, c7i, r6i r6id, r7i, p5 instance type support to Sagemaker Notebook Instances and miscellaneous wording fixes for previous Sagemaker documentation.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.4.0](service/workspacesthinclient/CHANGELOG.md#v140-2024-03-15)
  * **Feature**: Removed unused parameter kmsKeyArn from UpdateDeviceRequest

# Release (2024-03-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.21.3](service/amplify/CHANGELOG.md#v1213-2024-03-14)
  * **Documentation**: Documentation updates for Amplify. Identifies the APIs available only to apps created using Amplify Gen 1.
* `github.com/aws/aws-sdk-go-v2/service/ec2instanceconnect`: [v1.23.0](service/ec2instanceconnect/CHANGELOG.md#v1230-2024-03-14)
  * **Feature**: This release includes a new exception type "SerialConsoleSessionUnsupportedException" for SendSerialConsoleSSHPublicKey API.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.30.3](service/elasticloadbalancingv2/CHANGELOG.md#v1303-2024-03-14)
  * **Documentation**: This release allows you to configure HTTP client keep-alive duration for communication between clients and Application Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.24.0](service/fis/CHANGELOG.md#v1240-2024-03-14)
  * **Feature**: This release adds support for previewing target resources before running a FIS experiment. It also adds resource ARNs for actions, experiments, and experiment templates to API responses.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.75.2](service/rds/CHANGELOG.md#v1752-2024-03-14)
  * **Documentation**: Updates Amazon RDS documentation for EBCDIC collation for RDS for Db2.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.28.3](service/secretsmanager/CHANGELOG.md#v1283-2024-03-14)
  * **Documentation**: Doc only update for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.0.0](service/timestreaminfluxdb/CHANGELOG.md#v100-2024-03-14)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for Amazon Timestream for InfluxDB. Amazon Timestream for InfluxDB is a new time-series database engine that makes it easy for application developers and DevOps teams to run InfluxDB databases on AWS for near real-time time-series applications using open source APIs.

# Release (2024-03-13)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.12.0](service/ivsrealtime/CHANGELOG.md#v1120-2024-03-13)
  * **Feature**: adds support for multiple new composition layout configuration options (grid, pip)
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.24.0](service/kinesisanalyticsv2/CHANGELOG.md#v1240-2024-03-13)
  * **Feature**: Support new RuntimeEnvironmentUpdate parameter within UpdateApplication API allowing callers to change the Flink version upon which their application runs.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.52.0](service/s3/CHANGELOG.md#v1520-2024-03-13)
  * **Feature**: This release makes the default option for S3 on Outposts request signing to use the SigV4A algorithm when using AWS Common Runtime (CRT).

# Release (2024-03-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.47.2](service/cloudformation/CHANGELOG.md#v1472-2024-03-12)
  * **Documentation**: CloudFormation documentation update for March, 2024
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.93.0](service/connect/CHANGELOG.md#v1930-2024-03-12)
  * **Feature**: This release increases MaxResults limit to 500 in request for SearchUsers, SearchQueues and SearchRoutingProfiles APIs of Amazon Connect.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.150.1](service/ec2/CHANGELOG.md#v11501-2024-03-12)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.31.0](service/kafka/CHANGELOG.md#v1310-2024-03-12)
  * **Feature**: Added support for specifying the starting position of topic replication in MSK-Replicator.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.49.3](service/ssm/CHANGELOG.md#v1493-2024-03-12)
  * **Documentation**: March 2024 doc-only updates for Systems Manager.

# Release (2024-03-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.25.0](service/codestarconnections/CHANGELOG.md#v1250-2024-03-11)
  * **Feature**: Added a sync configuration enum to disable publishing of deployment status to source providers (PublishDeploymentStatus). Added a sync configuration enum (TriggerStackUpdateOn) to only trigger changes.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.37.3](service/elasticache/CHANGELOG.md#v1373-2024-03-11)
  * **Documentation**: Revisions to API text that are now to be carried over to SDK text, changing usages of "SFO" in code examples to "us-west-1", and some other typos.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.10.0](service/mediapackagev2/CHANGELOG.md#v1100-2024-03-11)
  * **Feature**: This release enables customers to safely update their MediaPackage v2 channel groups, channels and origin endpoints using entity tags.

# Release (2024-03-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.35.0](service/batch/CHANGELOG.md#v1350-2024-03-08)
  * **Feature**: This release adds JobStateTimeLimitActions setting to the Job Queue API. It allows you to configure an action Batch can take for a blocking job in front of the queue after the defined period of time. The new parameter applies for ECS, EKS, and FARGATE Job Queues.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.4.2](service/bedrockagentruntime/CHANGELOG.md#v142-2024-03-08)
  * **Documentation**: Documentation update for Bedrock Runtime Agent
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.39.0](service/cloudtrail/CHANGELOG.md#v1390-2024-03-08)
  * **Feature**: Added exceptions to CreateTrail, DescribeTrails, and ListImportFailures APIs.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.30.3](service/codebuild/CHANGELOG.md#v1303-2024-03-08)
  * **Documentation**: This release adds support for a new webhook event: PULL_REQUEST_CLOSED.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.36.0](service/cognitoidentityprovider/CHANGELOG.md#v1360-2024-03-08)
  * **Feature**: Add ConcurrentModificationException to SetUserPoolMfaConfig
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.40.0](service/guardduty/CHANGELOG.md#v1400-2024-03-08)
  * **Feature**: Add RDS Provisioned and Serverless Usage types
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.44.0](service/transfer/CHANGELOG.md#v1440-2024-03-08)
  * **Feature**: Added DES_EDE3_CBC to the list of supported encryption algorithms for messages sent with an AS2 connector.

# Release (2024-03-07)

## General Highlights
* **Bug Fix**: Remove dependency on go-cmp.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.25.3
  * **Bug Fix**: Remove dependency on go-cmp.
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.29.0](service/appconfig/CHANGELOG.md#v1290-2024-03-07)
  * **Feature**: AWS AppConfig now supports dynamic parameters, which enhance the functionality of AppConfig Extensions by allowing you to provide parameter values to your Extensions at the time you deploy your configuration.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.150.0](service/ec2/CHANGELOG.md#v11500-2024-03-07)
  * **Feature**: This release adds an optional parameter to RegisterImage and CopyImage APIs to support tagging AMIs at the time of creation.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.21.0](service/grafana/CHANGELOG.md#v1210-2024-03-07)
  * **Feature**: Adds support for the new GrafanaToken as part of the Amazon Managed Grafana Enterprise plugins upgrade to associate your AWS account with a Grafana Labs account.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.53.2](service/lambda/CHANGELOG.md#v1532-2024-03-07)
  * **Documentation**: Documentation updates for AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.8.0](service/paymentcryptographydata/CHANGELOG.md#v180-2024-03-07)
  * **Feature**: AWS Payment Cryptography EMV Decrypt Feature  Release
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.75.1](service/rds/CHANGELOG.md#v1751-2024-03-07)
  * **Documentation**: Updates Amazon RDS documentation for io2 storage for Multi-AZ DB clusters
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.26.2](service/snowball/CHANGELOG.md#v1262-2024-03-07)
  * **Documentation**: Doc-only update for change to EKS-Anywhere ordering.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.48.0](service/wafv2/CHANGELOG.md#v1480-2024-03-07)
  * **Feature**: You can increase the max request body inspection size for some regional resources. The size setting is in the web ACL association config. Also, the AWSManagedRulesBotControlRuleSet EnableMachineLearning setting now takes a Boolean instead of a primitive boolean type, for languages like Java.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.38.2](service/workspaces/CHANGELOG.md#v1382-2024-03-07)
  * **Documentation**: Added note for user decoupling

# Release (2024-03-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.30.3](service/dynamodb/CHANGELOG.md#v1303-2024-03-06)
  * **Documentation**: Doc only updates for DynamoDB documentation
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.33.0](service/imagebuilder/CHANGELOG.md#v1330-2024-03-06)
  * **Feature**: Add PENDING status to Lifecycle Execution resource status. Add StartTime and EndTime to ListLifecycleExecutionResource API response.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.26.2](service/mwaa/CHANGELOG.md#v1262-2024-03-06)
  * **Documentation**: Amazon MWAA adds support for Apache Airflow v2.8.1.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.75.0](service/rds/CHANGELOG.md#v1750-2024-03-06)
  * **Feature**: Updated the input of CreateDBCluster and ModifyDBCluster to support setting CA certificates. Updated the output of DescribeDBCluster to show current CA certificate setting value.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.43.2](service/redshift/CHANGELOG.md#v1432-2024-03-06)
  * **Documentation**: Update for documentation only. Covers port ranges, definition updates for data sharing, and definition updates to cluster-snapshot documentation.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.11.0](service/verifiedpermissions/CHANGELOG.md#v1110-2024-03-06)
  * **Feature**: Deprecating details in favor of configuration for GetIdentitySource and ListIdentitySources APIs.

# Release (2024-03-05)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.23.3](service/apigateway/CHANGELOG.md#v1233-2024-03-05)
  * **Documentation**: Documentation updates for Amazon API Gateway
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.1.2](service/chatbot/CHANGELOG.md#v112-2024-03-05)
  * **Documentation**: Minor update to documentation.
* `github.com/aws/aws-sdk-go-v2/service/internal/presigned-url`: [v1.11.4](service/internal/presigned-url/CHANGELOG.md#v1114-2024-03-05)
  * **Bug Fix**: Restore typo'd API `AddAsIsInternalPresigingMiddleware` as an alias for backwards compatibility.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.27.0](service/organizations/CHANGELOG.md#v1270-2024-03-05)
  * **Feature**: This release contains an endpoint addition
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.27.0](service/sesv2/CHANGELOG.md#v1270-2024-03-05)
  * **Feature**: Adds support for providing custom headers within SendEmail and SendBulkEmail for SESv2.

# Release (2024-03-04)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/cloudfront/sign`: [v1.7.0](feature/cloudfront/sign/CHANGELOG.md#v170-2024-03-04)
  * **Feature**: Add http.SameSite config in CookieOptions.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.47.0](service/cloudformation/CHANGELOG.md#v1470-2024-03-04)
  * **Feature**: Add DetailedStatus field to DescribeStackEvents and DescribeStacks APIs
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.33.2](service/docdb/CHANGELOG.md#v1332-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.149.3](service/ec2/CHANGELOG.md#v11493-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.43.0](service/fsx/CHANGELOG.md#v1430-2024-03-04)
  * **Feature**: Added support for creating FSx for NetApp ONTAP file systems with up to 12 HA pairs, delivering up to 72 GB/s of read throughput and 12 GB/s of write throughput.
* `github.com/aws/aws-sdk-go-v2/service/internal/endpoint-discovery`: [v1.9.3](service/internal/endpoint-discovery/CHANGELOG.md#v193-2024-03-04)
  * **Bug Fix**: Fix misaligned struct member used in atomic operation. This fixes a panic caused by attempting to atomically access a struct member which is not 64-bit aligned when running on 32-bit arch, due to the smaller sync.Map struct.
* `github.com/aws/aws-sdk-go-v2/service/internal/presigned-url`: [v1.11.3](service/internal/presigned-url/CHANGELOG.md#v1113-2024-03-04)
  * **Bug Fix**: Correct a typo in internal AddAsIsPresigningMiddleware API.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.31.2](service/neptune/CHANGELOG.md#v1312-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.26.0](service/organizations/CHANGELOG.md#v1260-2024-03-04)
  * **Feature**: Documentation update for AWS Organizations
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.39.2](service/polly/CHANGELOG.md#v1392-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.74.1](service/rds/CHANGELOG.md#v1741-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.51.2](service/s3/CHANGELOG.md#v1512-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.28.2](service/sts/CHANGELOG.md#v1282-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.

# Release (2024-03-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.28.2](service/accessanalyzer/CHANGELOG.md#v1282-2024-03-01)
  * **Documentation**: Fixed a typo in description field.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.40.2](service/autoscaling/CHANGELOG.md#v1402-2024-03-01)
  * **Documentation**: With this release, Amazon EC2 Auto Scaling groups, EC2 Fleet, and Spot Fleet improve the default price protection behavior of attribute-based instance type selection of Spot Instances, to consistently select from a wide range of instance types.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.149.2](service/ec2/CHANGELOG.md#v11492-2024-03-01)
  * **Documentation**: With this release, Amazon EC2 Auto Scaling groups, EC2 Fleet, and Spot Fleet improve the default price protection behavior of attribute-based instance type selection of Spot Instances, to consistently select from a wide range of instance types.

# Release (2024-02-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.9.0](service/docdbelastic/CHANGELOG.md#v190-2024-02-29)
  * **Feature**: Launched Elastic Clusters Readable Secondaries, Start/Stop, Configurable Shard Instance count, Automatic Backups and Snapshot Copying
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.41.0](service/eks/CHANGELOG.md#v1410-2024-02-29)
  * **Feature**: Added support for new AL2023 AMIs to the supported AMITypes.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.43.0](service/lexmodelsv2/CHANGELOG.md#v1430-2024-02-29)
  * **Feature**: This release makes AMAZON.QnAIntent generally available in Amazon Lex. This generative AI feature leverages large language models available through Amazon Bedrock to automate frequently asked questions (FAQ) experience for end-users.
* `github.com/aws/aws-sdk-go-v2/service/migrationhuborchestrator`: [v1.9.0](service/migrationhuborchestrator/CHANGELOG.md#v190-2024-02-29)
  * **Feature**: Adds new CreateTemplate, UpdateTemplate and DeleteTemplate APIs.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.59.0](service/quicksight/CHANGELOG.md#v1590-2024-02-29)
  * **Feature**: TooltipTarget for Combo chart visuals; ColumnConfiguration limit increase to 2000; Documentation Update
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.132.0](service/sagemaker/CHANGELOG.md#v11320-2024-02-29)
  * **Feature**: Adds support for ModelDataSource in Model Packages to support unzipped models. Adds support to specify SourceUri for models which allows registration of models without mandating a container for hosting. Using SourceUri, customers can decouple the model from hosting information during registration.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.13.0](service/securitylake/CHANGELOG.md#v1130-2024-02-29)
  * **Feature**: Add capability to update the Data Lake's MetaStoreManager Role in order to perform required data lake updates to use Iceberg table format in their data lake or update the role for any other reason.

# Release (2024-02-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.34.0](service/batch/CHANGELOG.md#v1340-2024-02-28)
  * **Feature**: This release adds Batch support for configuration of multicontainer jobs in ECS, Fargate, and EKS. This support is available for all types of jobs, including both array jobs and multi-node parallel jobs.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.4.0](service/bedrockagentruntime/CHANGELOG.md#v140-2024-02-28)
  * **Feature**: This release adds support to override search strategy performed by the Retrieve and RetrieveAndGenerate APIs for Amazon Bedrock Agents
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.36.0](service/costexplorer/CHANGELOG.md#v1360-2024-02-28)
  * **Feature**: This release introduces the new API 'GetApproximateUsageRecords', which retrieves estimated usage records for hourly granularity or resource-level data at daily granularity.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.53.0](service/iot/CHANGELOG.md#v1530-2024-02-28)
  * **Feature**: This release reduces the maximum results returned per query invocation from 500 to 100 for the SearchIndex API. This change has no implications as long as the API is invoked until the nextToken is NULL.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.47.0](service/wafv2/CHANGELOG.md#v1470-2024-02-28)
  * **Feature**: AWS WAF now supports configurable time windows for request aggregation with rate-based rules. Customers can now select time windows of 1 minute, 2 minutes or 10 minutes, in addition to the previously supported 5 minutes.

# Release (2024-02-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.19.0](service/amplifyuibuilder/CHANGELOG.md#v1190-2024-02-27)
  * **Feature**: We have added the ability to tag resources after they are created

# Release (2024-02-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.23.2](service/apigateway/CHANGELOG.md#v1232-2024-02-26)
  * **Documentation**: Documentation updates for Amazon API Gateway.
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.25.0](service/drs/CHANGELOG.md#v1250-2024-02-26)
  * **Feature**: Added volume status to DescribeSourceServer replicated volumes.
* `github.com/aws/aws-sdk-go-v2/service/kafkaconnect`: [v1.17.0](service/kafkaconnect/CHANGELOG.md#v1170-2024-02-26)
  * **Feature**: Adds support for tagging, with new TagResource, UntagResource and ListTagsForResource APIs to manage tags and updates to existing APIs to allow tag on create. This release also adds support for the new DeleteWorkerConfiguration API.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.74.0](service/rds/CHANGELOG.md#v1740-2024-02-26)
  * **Feature**: This release adds support for gp3 data volumes for Multi-AZ DB Clusters.

# Release (2024-02-23)

## General Highlights
* **Bug Fix**: Move all common, SDK-side middleware stack ops into the service client module to prevent cross-module compatibility issues in the future.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.25.2
  * **Bug Fix**: Export all middleware structures such that service client modules can use them directly.
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.31.1](service/appsync/CHANGELOG.md#v1311-2024-02-23)
  * **Documentation**: Documentation only updates for AppSync
* `github.com/aws/aws-sdk-go-v2/service/qldb`: [v1.21.1](service/qldb/CHANGELOG.md#v1211-2024-02-23)
  * **Documentation**: Clarify possible values for KmsKeyArn and EncryptionDescription.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.73.0](service/rds/CHANGELOG.md#v1730-2024-02-23)
  * **Feature**: Add pattern and length based validations for DBShardGroupIdentifier
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.17.1](service/rum/CHANGELOG.md#v1171-2024-02-23)
  * **Documentation**: Doc-only update for new RUM metrics that were added

# Release (2024-02-22)

## General Highlights
* **Feature**: Add middleware stack snapshot tests.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.12.0](service/internetmonitor/CHANGELOG.md#v1120-2024-02-22)
  * **Feature**: This release adds IPv4 prefixes to health events
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.23.0](service/kinesisvideo/CHANGELOG.md#v1230-2024-02-22)
  * **Feature**: Increasing NextToken parameter length restriction for List APIs from 512 to 1024.

# Release (2024-02-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iotevents`: [v1.22.0](service/iotevents/CHANGELOG.md#v1220-2024-02-21)
  * **Feature**: Increase the maximum length of descriptions for Inputs, Detector Models, and Alarm Models
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.25.0](service/lookoutequipment/CHANGELOG.md#v1250-2024-02-21)
  * **Feature**: This release adds a field exposing model quality to read APIs for models. It also adds a model quality field to the API response when creating an inference scheduler.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.47.0](service/medialive/CHANGELOG.md#v1470-2024-02-21)
  * **Feature**: MediaLive now supports the ability to restart pipelines in a running channel.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.48.0](service/ssm/CHANGELOG.md#v1480-2024-02-21)
  * **Feature**: This release adds support for sharing Systems Manager parameters with other AWS accounts.

# Release (2024-02-20)

## General Highlights
* **Bug Fix**: When sourcing values for a service's `EndpointParameters`, the lack of a configured region (i.e. `options.Region == ""`) will now translate to a `nil` value for `EndpointParameters.Region` instead of a pointer to the empty string `""`. This will result in a much more explicit error when calling an operation instead of an obscure hostname lookup failure.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.29.1](service/dynamodb/CHANGELOG.md#v1291-2024-02-20)
  * **Documentation**: Publishing quick fix for doc only update.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.27.0](service/firehose/CHANGELOG.md#v1270-2024-02-20)
  * **Feature**: This release updates a few Firehose related APIs.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.52.0](service/lambda/CHANGELOG.md#v1520-2024-02-20)
  * **Feature**: Add .NET 8 (dotnet8) Runtime support to AWS Lambda.

# Release (2024-02-19)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.20.0](service/amplify/CHANGELOG.md#v1200-2024-02-19)
  * **Feature**: This release contains API changes that enable users to configure their Amplify domains with their own custom SSL/TLS certificate.
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.0.0](service/chatbot/CHANGELOG.md#v100-2024-02-19)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for AWS Chatbot. You can now monitor, operate, and troubleshoot your AWS resources with interactive ChatOps using the AWS SDK.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.45.2](service/configservice/CHANGELOG.md#v1452-2024-02-19)
  * **Documentation**: Documentation updates for the AWS Config CLI
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.32.1](service/ivs/CHANGELOG.md#v1321-2024-02-19)
  * **Documentation**: Changed description for latencyMode in Create/UpdateChannel and Channel/ChannelSummary.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.9.2](service/keyspaces/CHANGELOG.md#v192-2024-02-19)
  * **Documentation**: Documentation updates for Amazon Keyspaces
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.35.0](service/mediatailor/CHANGELOG.md#v1350-2024-02-19)
  * **Feature**: MediaTailor: marking #AdBreak.OffsetMillis as required.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.50.1](service/s3/CHANGELOG.md#v1501-2024-02-19)
  * **Bug Fix**: Prevent potential panic caused by invalid comparison of credentials.

# Release (2024-02-16)

## General Highlights
* **Feature**: Add new ClientOptions field to waiter config which allows you to extend the config for operation calls made by waiters.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.22.1](service/connectparticipant/CHANGELOG.md#v1221-2024-02-16)
  * **Documentation**: Doc only update to GetTranscript API reference guide to inform users about presence of events in the chat transcript.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.38.0](service/emr/CHANGELOG.md#v1380-2024-02-16)
  * **Feature**: adds fine grained control over Unhealthy Node Replacement to Amazon ElasticMapReduce
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.26.0](service/firehose/CHANGELOG.md#v1260-2024-02-16)
  * **Feature**: This release adds support for Data Message Extraction for decompressed CloudWatch logs, and to use a custom file extension or time zone for S3 destinations.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.51.0](service/lambda/CHANGELOG.md#v1510-2024-02-16)
  * **Documentation**: Documentation-only updates for Lambda to clarify a number of existing actions and properties.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.71.0](service/rds/CHANGELOG.md#v1710-2024-02-16)
  * **Documentation**: Doc only update for a valid option in DB parameter group
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.28.0](service/sns/CHANGELOG.md#v1280-2024-02-16)
  * **Feature**: This release marks phone numbers as sensitive inputs.

# Release (2024-02-15)

## General Highlights
* **Bug Fix**: Correct failure to determine the error type in awsJson services that could occur when errors were modeled with a non-string `code` field.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/artifact`: [v1.0.0](service/artifact/CHANGELOG.md#v100-2024-02-15)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for AWS Artifact. AWS Artifact provides on-demand access to compliance and third-party compliance reports. This release includes access to List and Get reports, along with their metadata. This release also includes access to AWS Artifact notifications settings.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.25.0](service/codepipeline/CHANGELOG.md#v1250-2024-02-15)
  * **Feature**: Add ability to override timeout on action level.
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.26.1](service/detective/CHANGELOG.md#v1261-2024-02-15)
  * **Documentation**: Doc only updates for content enhancement
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.38.0](service/guardduty/CHANGELOG.md#v1380-2024-02-15)
  * **Feature**: Marked fields IpAddressV4, PrivateIpAddress, Email as Sensitive.
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.22.0](service/healthlake/CHANGELOG.md#v1220-2024-02-15)
  * **Feature**: This release adds a new response parameter, JobProgressReport, to the DescribeFHIRImportJob and ListFHIRImportJobs API operation. JobProgressReport provides details on the progress of the import job on the server.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.31.0](service/opensearch/CHANGELOG.md#v1310-2024-02-15)
  * **Feature**: Adds additional supported instance types.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.38.0](service/polly/CHANGELOG.md#v1380-2024-02-15)
  * **Feature**: Amazon Polly adds 1 new voice - Burcu (tr-TR)
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.129.0](service/sagemaker/CHANGELOG.md#v11290-2024-02-15)
  * **Feature**: This release adds a new API UpdateClusterSoftware for SageMaker HyperPod. This API allows users to patch HyperPod clusters with latest platform softwares.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.27.1](service/secretsmanager/CHANGELOG.md#v1271-2024-02-15)
  * **Documentation**: Doc only update for Secrets Manager

# Release (2024-02-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.12.0](service/controltower/CHANGELOG.md#v1120-2024-02-14)
  * **Feature**: Adds support for new Baseline and EnabledBaseline APIs for automating multi-account governance.
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.24.0](service/lookoutequipment/CHANGELOG.md#v1240-2024-02-14)
  * **Feature**: This feature allows customers to see pointwise model diagnostics results for their models.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.3.0](service/qbusiness/CHANGELOG.md#v130-2024-02-14)
  * **Feature**: This release adds the metadata-boosting feature, which allows customers to easily fine-tune the underlying ranking of retrieved RAG passages in order to optimize Q&A answer relevance. It also adds new feedback reasons for the PutFeedback API.

# Release (2024-02-13)

## General Highlights
* **Feature**: Bump minimum Go version to 1.20 per our language support policy.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.35.0](service/lightsail/CHANGELOG.md#v1350-2024-02-13)
  * **Feature**: This release adds support to upgrade the major version of a database.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.24.0](service/marketplacecatalog/CHANGELOG.md#v1240-2024-02-13)
  * **Feature**: AWS Marketplace Catalog API now supports setting intent on requests
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.9.0](service/resourceexplorer2/CHANGELOG.md#v190-2024-02-13)
  * **Feature**: Resource Explorer now uses newly supported IPv4 'amazonaws.com' endpoints by default.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.11.0](service/securitylake/CHANGELOG.md#v1110-2024-02-13)
  * **Documentation**: Documentation updates for Security Lake

# Release (2024-02-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.29.0](service/appsync/CHANGELOG.md#v1290-2024-02-12)
  * **Feature**: Adds support for new options on GraphqlAPIs, Resolvers and  Data Sources for emitting Amazon CloudWatch metrics for enhanced monitoring of AppSync APIs.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.33.0](service/cloudwatch/CHANGELOG.md#v1330-2024-02-12)
  * **Feature**: This release enables PutMetricData API request payload compression by default.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.3.0](service/neptunegraph/CHANGELOG.md#v130-2024-02-12)
  * **Feature**: Adding a new option "parameters" for data plane api ExecuteQuery to support running parameterized query via SDK.
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.21.0](service/route53domains/CHANGELOG.md#v1210-2024-02-12)
  * **Feature**: This release adds bill contact support for RegisterDomain, TransferDomain, UpdateDomainContact and GetDomainDetail API.

# Release (2024-02-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.22.2](service/amp/CHANGELOG.md#v1222-2024-02-09)
  * **Documentation**: Overall documentation updates.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.31.0](service/batch/CHANGELOG.md#v1310-2024-02-09)
  * **Feature**: This feature allows Batch to support configuration of repository credentials for jobs running on ECS
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.25.0](service/braket/CHANGELOG.md#v1250-2024-02-09)
  * **Feature**: Creating a job will result in DeviceOfflineException when using an offline device, and DeviceRetiredException when using a retired device.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.2.0](service/costoptimizationhub/CHANGELOG.md#v120-2024-02-09)
  * **Feature**: Adding includeMemberAccounts field to the response of ListEnrollmentStatuses API.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.38.3](service/ecs/CHANGELOG.md#v1383-2024-02-09)
  * **Documentation**: Documentation only update for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.50.0](service/iot/CHANGELOG.md#v1500-2024-02-09)
  * **Feature**: This release allows AWS IoT Core users to enable Online Certificate Status Protocol (OCSP) Stapling for TLS X.509 Server Certificates when creating and updating AWS IoT Domain Configurations with Custom Domain.
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.25.0](service/pricing/CHANGELOG.md#v1250-2024-02-09)
  * **Feature**: Add Throttling Exception to all APIs.

# Release (2024-02-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.23.0](service/codepipeline/CHANGELOG.md#v1230-2024-02-08)
  * **Feature**: Add ability to execute pipelines with new parallel & queued execution modes and add support for triggers with filtering on branches and file paths.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.56.0](service/quicksight/CHANGELOG.md#v1560-2024-02-08)
  * **Feature**: General Interactions for Visuals; Waterfall Chart Color Configuration; Documentation Update
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.36.0](service/workspaces/CHANGELOG.md#v1360-2024-02-08)
  * **Feature**: This release introduces User-Decoupling feature. This feature allows Workspaces Core customers to provision workspaces without providing users. CreateWorkspaces and DescribeWorkspaces APIs will now take a new optional parameter "WorkspaceName".

# Release (2024-02-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.34.0](service/datasync/CHANGELOG.md#v1340-2024-02-07)
  * **Feature**: AWS DataSync now supports manifests for specifying files or objects to transfer.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.39.0](service/lexmodelsv2/CHANGELOG.md#v1390-2024-02-07)
  * **Feature**: This release introduces a new bot replication feature as part of Lex Global Resiliency offering. This feature leverages a new set of APIs that allow customers to create bot replicas and replicate changes to bots across regions.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.40.0](service/redshift/CHANGELOG.md#v1400-2024-02-07)
  * **Feature**: LisRecommendations API to fetch Amazon Redshift Advisor recommendations.

# Release (2024-02-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.28.0](service/appsync/CHANGELOG.md#v1280-2024-02-06)
  * **Feature**: Support for environment variables in AppSync GraphQL APIs
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.32.0](service/cloudwatchlogs/CHANGELOG.md#v1320-2024-02-06)
  * **Feature**: This release adds a new field, logGroupArn, to the response of the logs:DescribeLogGroups action.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.38.2](service/ecs/CHANGELOG.md#v1382-2024-02-06)
  * **Documentation**: This release is a documentation only update to address customer issues.
* `github.com/aws/aws-sdk-go-v2/service/elasticsearchservice`: [v1.26.0](service/elasticsearchservice/CHANGELOG.md#v1260-2024-02-06)
  * **Feature**: This release adds clear visibility to the customers on the changes that they make on the domain.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.29.0](service/opensearch/CHANGELOG.md#v1290-2024-02-06)
  * **Feature**: This release adds clear visibility to the customers on the changes that they make on the domain.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.44.0](service/wafv2/CHANGELOG.md#v1440-2024-02-06)
  * **Feature**: You can now delete an API key that you've created for use with your CAPTCHA JavaScript integration API.

# Release (2024-02-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.75.0](service/glue/CHANGELOG.md#v1750-2024-02-05)
  * **Feature**: Introduce Catalog Encryption Role within Glue Data Catalog Settings. Introduce SASL/PLAIN as an authentication method for Glue Kafka connections
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.35.9](service/workspaces/CHANGELOG.md#v1359-2024-02-05)
  * **Documentation**: Added definitions of various WorkSpace states

# Release (2024-02-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.27.1](service/dynamodb/CHANGELOG.md#v1271-2024-02-02)
  * **Documentation**: Any number of users can execute up to 50 concurrent restores (any type of restore) in a given account.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.127.0](service/sagemaker/CHANGELOG.md#v11270-2024-02-02)
  * **Feature**: Amazon SageMaker Canvas adds GenerativeAiSettings support for CanvasAppSettings.

# Release (2024-02-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.33.0](service/cognitoidentityprovider/CHANGELOG.md#v1330-2024-02-01)
  * **Feature**: Added CreateIdentityProvider and UpdateIdentityProvider details for new SAML IdP features
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.31.0](service/ivs/CHANGELOG.md#v1310-2024-02-01)
  * **Feature**: This release introduces a new resource Playback Restriction Policy which can be used to geo-restrict or domain-restrict channel stream playback when associated with a channel.  New APIs to support this resource were introduced in the form of Create/Delete/Get/Update/List.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.8.0](service/managedblockchainquery/CHANGELOG.md#v180-2024-02-01)
  * **Feature**: This release adds support for transactions that have not reached finality. It also removes support for the status property from the response of the GetTransaction operation. You can use the confirmationStatus and executionStatus properties to determine the status of the transaction.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.50.0](service/mediaconvert/CHANGELOG.md#v1500-2024-02-01)
  * **Feature**: This release includes support for broadcast-mixed audio description tracks.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.2.0](service/neptunegraph/CHANGELOG.md#v120-2024-02-01)
  * **Feature**: Adding new APIs in SDK for Amazon Neptune Analytics. These APIs include operations to execute, cancel, list queries and get the graph summary.

# Release (2024-01-31)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.43.0](service/cloudformation/CHANGELOG.md#v1430-2024-01-31)
  * **Feature**: CloudFormation IaC generator allows you to scan existing resources in your account and select resources to generate a template for a new or existing CloudFormation stack.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.27.0](service/elasticloadbalancingv2/CHANGELOG.md#v1270-2024-01-31)
  * **Feature**: This release enables unhealthy target draining intervals for Network Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.74.0](service/glue/CHANGELOG.md#v1740-2024-01-31)
  * **Feature**: Update page size limits for GetJobRuns and GetTriggers APIs.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.45.0](service/ssm/CHANGELOG.md#v1450-2024-01-31)
  * **Feature**: This release adds an optional Duration parameter to StateManager Associations. This allows customers to specify how long an apply-only-on-cron association execution should run. Once the specified Duration is out all the ongoing cancellable commands or automations are cancelled.

# Release (2024-01-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.4.0](service/datazone/CHANGELOG.md#v140-2024-01-30)
  * **Feature**: Add new skipDeletionCheck to DeleteDomain. Add new skipDeletionCheck to DeleteProject which also automatically deletes dependent objects
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.37.1](service/route53/CHANGELOG.md#v1371-2024-01-30)
  * **Documentation**: Update the SDKs for text changes in the APIs.

# Release (2024-01-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.37.0](service/autoscaling/CHANGELOG.md#v1370-2024-01-29)
  * **Feature**: EC2 Auto Scaling customers who use attribute based instance-type selection can now intuitively define their Spot instances price protection limit as a percentage of the lowest priced On-Demand instance type.
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.29.7](service/comprehend/CHANGELOG.md#v1297-2024-01-29)
  * **Documentation**: Comprehend PII analysis now supports Spanish input documents.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.146.0](service/ec2/CHANGELOG.md#v11460-2024-01-29)
  * **Feature**: EC2 Fleet customers who use attribute based instance-type selection can now intuitively define their Spot instances price protection limit as a percentage of the lowest priced On-Demand instance type.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.24.0](service/mwaa/CHANGELOG.md#v1240-2024-01-29)
  * **Feature**: This release adds MAINTENANCE environment status for Amazon MWAA environments.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.69.0](service/rds/CHANGELOG.md#v1690-2024-01-29)
  * **Feature**: Introduced support for the InsufficientDBInstanceCapacityFault error in the RDS RestoreDBClusterFromSnapshot and RestoreDBClusterToPointInTime API methods. This provides enhanced error handling, ensuring a more robust experience.
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.24.7](service/snowball/CHANGELOG.md#v1247-2024-01-29)
  * **Documentation**: Modified description of createaddress to include direction to add path when providing a JSON file.

# Release (2024-01-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.22.0](service/inspector2/CHANGELOG.md#v1220-2024-01-26)
  * **Feature**: This release adds ECR container image scanning based on their lastRecordedPullTime.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.126.0](service/sagemaker/CHANGELOG.md#v11260-2024-01-26)
  * **Feature**: Amazon SageMaker Automatic Model Tuning now provides an API to programmatically delete tuning jobs.

# Release (2024-01-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.26.0](service/acmpca/CHANGELOG.md#v1260-2024-01-25)
  * **Feature**: AWS Private CA now supports an option to omit the CDP extension from issued certificates, when CRL revocation is enabled.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.34.0](service/lightsail/CHANGELOG.md#v1340-2024-01-25)
  * **Feature**: This release adds support for IPv6-only instance plans.

# Release (2024-01-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.145.0](service/ec2/CHANGELOG.md#v11450-2024-01-24)
  * **Feature**: Introduced a new clientToken request parameter on CreateNetworkAcl and CreateRouteTable APIs. The clientToken parameter allows idempotent operations on the APIs.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.38.1](service/ecs/CHANGELOG.md#v1381-2024-01-24)
  * **Documentation**: Documentation updates for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.35.0](service/outposts/CHANGELOG.md#v1350-2024-01-24)
  * **Feature**: DeviceSerialNumber parameter is now optional in StartConnection API
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.68.0](service/rds/CHANGELOG.md#v1680-2024-01-24)
  * **Feature**: This release adds support for Aurora Limitless Database.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.25.0](service/storagegateway/CHANGELOG.md#v1250-2024-01-24)
  * **Feature**: Add DeprecationDate and SoftwareVersion to response of ListGateways.

# Release (2024-01-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.21.0](service/inspector2/CHANGELOG.md#v1210-2024-01-23)
  * **Feature**: This release adds support for CIS scans on EC2 instances.

# Release (2024-01-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.26.6](config/CHANGELOG.md#v1266-2024-01-22)
  * **Bug Fix**: Remove invalid escaping of shared config values. All values in the shared config file will now be interpreted literally, save for fully-quoted strings which are unwrapped for legacy reasons.
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.7.3](internal/ini/CHANGELOG.md#v173-2024-01-22)
  * **Bug Fix**: Remove invalid escaping of shared config values. All values in the shared config file will now be interpreted literally, save for fully-quoted strings which are unwrapped for legacy reasons.
* `github.com/aws/aws-sdk-go-v2/service/appconfigdata`: [v1.12.0](service/appconfigdata/CHANGELOG.md#v1120-2024-01-22)
  * **Feature**: Fix FIPS Endpoints in aws-us-gov.
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.22.7](service/cloud9/CHANGELOG.md#v1227-2024-01-22)
  * **Documentation**: Doc-only update around removing AL1 from list of available AMIs for Cloud9
* `github.com/aws/aws-sdk-go-v2/service/cloudfrontkeyvaluestore`: [v1.2.0](service/cloudfrontkeyvaluestore/CHANGELOG.md#v120-2024-01-22)
  * **Feature**: This release improves upon the DescribeKeyValueStore API by returning two additional fields, Status of the KeyValueStore and the FailureReason in case of failures during creation of KeyValueStore.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.13.0](service/connectcases/CHANGELOG.md#v1130-2024-01-22)
  * **Feature**: This release adds the ability to view audit history on a case and introduces a new parameter, performedBy, for CreateCase and UpdateCase API's.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.144.1](service/ec2/CHANGELOG.md#v11441-2024-01-22)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.38.0](service/ecs/CHANGELOG.md#v1380-2024-01-22)
  * **Feature**: This release adds support for Transport Layer Security (TLS) and Configurable Timeout to ECS Service Connect. TLS facilitates privacy and data security for inter-service communications, while Configurable Timeout allows customized per-request timeout and idle timeout for Service Connect services.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.23.7](service/organizations/CHANGELOG.md#v1237-2024-01-22)
  * **Documentation**: Doc only update for quota increase change
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.67.0](service/rds/CHANGELOG.md#v1670-2024-01-22)
  * **Feature**: Introduced support for the InsufficientDBInstanceCapacityFault error in the RDS CreateDBCluster API method. This provides enhanced error handling, ensuring a more robust experience when creating database clusters with insufficient instance capacity.

# Release (2024-01-19)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.38.0](service/athena/CHANGELOG.md#v1380-2024-01-19)
  * **Feature**: Introducing new NotebookS3LocationUri parameter to Athena ImportNotebook API. Payload is no longer required and either Payload or NotebookS3LocationUri needs to be provided (not both) for a successful ImportNotebook API call. If both are provided, an InvalidRequestException will be thrown.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.28.0](service/codebuild/CHANGELOG.md#v1280-2024-01-19)
  * **Feature**: Release CodeBuild Reserved Capacity feature
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.27.0](service/dynamodb/CHANGELOG.md#v1270-2024-01-19)
  * **Feature**: This release adds support for including ApproximateCreationDateTimePrecision configurations in EnableKinesisStreamingDestination API, adds the same as an optional field in the response of DescribeKinesisStreamingDestination, and adds support for a new UpdateKinesisStreamingDestination API.

# Release (2024-01-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.11](service/b2bi/CHANGELOG.md#v100-preview11-2024-01-18)
  * **Feature**: Increasing TestMapping inputFileContent file size limit to 5MB and adding file size limit 250KB for TestParsing input file. This release also includes exposing InternalServerException for Tag APIs.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.36.0](service/cloudtrail/CHANGELOG.md#v1360-2024-01-18)
  * **Feature**: This release adds a new API ListInsightsMetricData to retrieve metric data from CloudTrail Insights.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.90.0](service/connect/CHANGELOG.md#v1900-2024-01-18)
  * **Feature**: GetMetricDataV2 now supports 3 groupings
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.22.0](service/drs/CHANGELOG.md#v1220-2024-01-18)
  * **Feature**: Removed invalid and unnecessary default values.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.15.0](service/emrserverless/CHANGELOG.md#v1150-2024-01-18)
  * **Feature**: **BREAKFIX**: Correct nullability of InitialCapacityConfig's WorkerCount field. The type of this value has changed from int64 to *int64. Due to this field being marked required, with an enforced minimum of 1, but a default of 0, the former type would result in automatic failure behavior without caller intervention. Calling code will need to be updated accordingly.
* `github.com/aws/aws-sdk-go-v2/service/evidently`: [v1.17.0](service/evidently/CHANGELOG.md#v1170-2024-01-18)
  * **Feature**: **BREAKFIX**: Correct nullability of GetExperimentResultsInput's Period field. The type of this value has changed from int64 to *int64. Due to the nature of default value serialization, the former type could cause unexpected/incorrect behavior when set to its zero value. Calling code will need to be updated accordingly.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.24.0](service/firehose/CHANGELOG.md#v1240-2024-01-18)
  * **Feature**: Allow support for Snowflake as a Kinesis Data Firehose delivery destination.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.23.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1230-2024-01-18)
  * **Feature**: Increase BatchGetRecord limits from 10 items to 100 items

# Release (2024-01-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.26.9](service/dynamodb/CHANGELOG.md#v1269-2024-01-17)
  * **Documentation**: Updating note for enabling streams for UpdateTable.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.8.0](service/keyspaces/CHANGELOG.md#v180-2024-01-17)
  * **Feature**: This release adds support for Multi-Region Replication with provisioned tables, and Keyspaces auto scaling APIs

# Release (2024-01-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.49.0](service/iot/CHANGELOG.md#v1490-2024-01-16)
  * **Feature**: Revert release of LogTargetTypes
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.12.0](service/iotfleetwise/CHANGELOG.md#v1120-2024-01-16)
  * **Feature**: Updated APIs: SignalNodeType query parameter has been added to ListSignalCatalogNodesRequest and ListVehiclesResponse has been extended with attributes field.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.35.0](service/macie2/CHANGELOG.md#v1350-2024-01-16)
  * **Feature**: This release adds support for analyzing Amazon S3 objects that are encrypted using dual-layer server-side encryption with AWS KMS keys (DSSE-KMS). It also adds support for reporting DSSE-KMS details in statistics and metadata about encryption settings for S3 buckets and objects.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.7.0](service/paymentcryptography/CHANGELOG.md#v170-2024-01-16)
  * **Feature**: Provide an additional option for key exchange using RSA wrap/unwrap in addition to tr-34/tr-31 in ImportKey and ExportKey operations. Added new key usage (type) TR31_M1_ISO_9797_1_MAC_KEY, for use with Generate/VerifyMac dataplane operations  with ISO9797 Algorithm 1 MAC calculations.
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.30.7](service/personalize/CHANGELOG.md#v1307-2024-01-16)
  * **Documentation**: Documentation updates for Amazon Personalize.
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.20.7](service/personalizeruntime/CHANGELOG.md#v1207-2024-01-16)
  * **Documentation**: Documentation updates for Amazon Personalize
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.36.0](service/rekognition/CHANGELOG.md#v1360-2024-01-16)
  * **Feature**: This release adds ContentType and TaxonomyLevel attributes to DetectModerationLabels and GetMediaAnalysisJob API responses.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.44.3](service/securityhub/CHANGELOG.md#v1443-2024-01-16)
  * **Documentation**: Documentation updates for AWS Security Hub

# Release (2024-01-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.125.0](service/sagemaker/CHANGELOG.md#v11250-2024-01-14)
  * **Feature**: This release will have ValidationException thrown if certain invalid app types are provided. The release will also throw ValidationException if more than 10 account ids are provided in VpcOnlyTrustedAccounts.

# Release (2024-01-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.89.0](service/connect/CHANGELOG.md#v1890-2024-01-12)
  * **Feature**: Supervisor Barge for Chat is now supported through the MonitorContact API.
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.21.0](service/connectparticipant/CHANGELOG.md#v1210-2024-01-12)
  * **Feature**: Introduce new Supervisor participant role
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.35.1](service/location/CHANGELOG.md#v1351-2024-01-12)
  * **Documentation**: Location SDK documentation update. Added missing fonts to the MapConfiguration data type. Updated note for the SubMunicipality property in the place data type.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.23.0](service/mwaa/CHANGELOG.md#v1230-2024-01-12)
  * **Feature**: This Amazon MWAA feature release includes new fields in CreateWebLoginToken response model. The new fields IamIdentity and AirflowIdentity will let you match identifications, as the Airflow identity length is currently hashed to 64 characters.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.42.0](service/s3control/CHANGELOG.md#v1420-2024-01-12)
  * **Feature**: S3 On Outposts team adds dualstack endpoints support for S3Control and S3Outposts API calls.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.0.0](service/supplychain/CHANGELOG.md#v100-2024-01-12)
  * **Release**: New AWS service client module
  * **Feature**: This release includes APIs CreateBillOfMaterialsImportJob and GetBillOfMaterialsImportJob.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.40.0](service/transfer/CHANGELOG.md#v1400-2024-01-12)
  * **Feature**: AWS Transfer Family now supports static IP addresses for SFTP & AS2 connectors and for async MDNs on AS2 servers.

# Release (2024-01-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.144.0](service/ec2/CHANGELOG.md#v11440-2024-01-11)
  * **Feature**: This release adds support for adding an ElasticBlockStorage volume configurations in ECS RunTask/StartTask/CreateService/UpdateService APIs. The configuration allows for attaching EBS volumes to ECS Tasks.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.37.0](service/ecs/CHANGELOG.md#v1370-2024-01-11)
  * **Feature**: This release adds support for adding an ElasticBlockStorage volume configurations in ECS RunTask/StartTask/CreateService/UpdateService APIs. The configuration allows for attaching EBS volumes to ECS Tasks.
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.28.0](service/eventbridge/CHANGELOG.md#v1280-2024-01-11)
  * **Feature**: Adding AppSync as an EventBridge Target
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.48.0](service/iot/CHANGELOG.md#v1480-2024-01-11)
  * **Feature**: Add ConflictException to Update APIs of AWS IoT Software Package Catalog
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.11.0](service/iotfleetwise/CHANGELOG.md#v1110-2024-01-11)
  * **Feature**: The following dataTypes have been removed: CUSTOMER_DECODED_INTERFACE in NetworkInterfaceType; CUSTOMER_DECODED_SIGNAL_INFO_IS_NULL in SignalDecoderFailureReason; CUSTOMER_DECODED_SIGNAL_NETWORK_INTERFACE_INFO_IS_NULL in NetworkInterfaceFailureReason; CUSTOMER_DECODED_SIGNAL in SignalDecoderType
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.26.2](service/secretsmanager/CHANGELOG.md#v1262-2024-01-11)
  * **Documentation**: Doc only update for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.35.8](service/workspaces/CHANGELOG.md#v1358-2024-01-11)
  * **Documentation**: Added AWS Workspaces RebootWorkspaces API - Extended Reboot documentation update

# Release (2024-01-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.31.0](service/cloudwatchlogs/CHANGELOG.md#v1310-2024-01-10)
  * **Feature**: Add support for account level subscription filter policies to PutAccountPolicy, DescribeAccountPolicies, and DeleteAccountPolicy APIs. Additionally, PutAccountPolicy has been modified with new optional "selectionCriteria" parameter for resource selection.
* `github.com/aws/aws-sdk-go-v2/service/connectcampaigns`: [v1.8.0](service/connectcampaigns/CHANGELOG.md#v180-2024-01-10)
  * **Feature**: Minor pattern updates for Campaign and Dial Request API fields.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.35.0](service/location/CHANGELOG.md#v1350-2024-01-10)
  * **Feature**: This release adds API support for custom layers for the maps service APIs: CreateMap, UpdateMap, DescribeMap.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.3.0](service/qconnect/CHANGELOG.md#v130-2024-01-10)
  * **Feature**: QueryAssistant and GetRecommendations will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.15.7](service/redshiftserverless/CHANGELOG.md#v1157-2024-01-10)
  * **Documentation**: Updates to ConfigParameter for RSS workgroup, removal of use_fips_ssl
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.37.0](service/route53/CHANGELOG.md#v1370-2024-01-10)
  * **Feature**: Route53 now supports geoproximity routing in AWS regions
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.21.0](service/wisdom/CHANGELOG.md#v1210-2024-01-10)
  * **Feature**: QueryAssistant and GetRecommendations will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.

# Release (2024-01-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.27.0](service/codebuild/CHANGELOG.md#v1270-2024-01-08)
  * **Feature**: Aws CodeBuild now supports new compute type BUILD_GENERAL1_XLARGE
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.143.0](service/ec2/CHANGELOG.md#v11430-2024-01-08)
  * **Feature**: Amazon EC2 R7iz bare metal instances are powered by custom 4th generation Intel Xeon Scalable processors.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.25.0](service/route53resolver/CHANGELOG.md#v1250-2024-01-08)
  * **Feature**: This release adds support for query type configuration on firewall rules that enables customers for granular action (ALLOW, ALERT, BLOCK) by DNS query type.

# Release (2024-01-05)

## General Highlights
* **Feature**: Support smithy sigv4a trait for codegen.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.27.9](service/kms/CHANGELOG.md#v1279-2024-01-05)
  * **Documentation**: Documentation updates for AWS Key Management Service (KMS).
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.15.6](service/redshiftserverless/CHANGELOG.md#v1156-2024-01-05)
  * **Documentation**: use_fips_ssl and require_ssl parameter support for Workgroup, UpdateWorkgroup, and CreateWorkgroup

# Release (2024-01-04)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.24.1
  * **Documentation**: removing incorrect doc string from config
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.44.0](service/configservice/CHANGELOG.md#v1440-2024-01-04)
  * **Feature**: Updated ResourceType enum with new resource types onboarded by AWS Config in November and December 2023.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.30.0](service/docdb/CHANGELOG.md#v1300-2024-01-04)
  * **Feature**: Adding PerformanceInsightsEnabled and PerformanceInsightsKMSKeyId fields to DescribeDBInstances Response.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.36.0](service/ecs/CHANGELOG.md#v1360-2024-01-04)
  * **Feature**: This release adds support for managed instance draining which facilitates graceful termination of Amazon ECS instances.
* `github.com/aws/aws-sdk-go-v2/service/elasticsearchservice`: [v1.25.0](service/elasticsearchservice/CHANGELOG.md#v1250-2024-01-04)
  * **Feature**: This release adds support for new or existing Amazon OpenSearch domains to enable TLS 1.3 or TLS 1.2 with perfect forward secrecy cipher suites for domain endpoints.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.33.0](service/lightsail/CHANGELOG.md#v1330-2024-01-04)
  * **Feature**: This release adds support to set up an HTTPS endpoint on an instance.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.28.0](service/opensearch/CHANGELOG.md#v1280-2024-01-04)
  * **Feature**: This release adds support for new or existing Amazon OpenSearch domains to enable TLS 1.3 or TLS 1.2 with perfect forward secrecy cipher suites for domain endpoints.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.124.0](service/sagemaker/CHANGELOG.md#v11240-2024-01-04)
  * **Feature**: Adding support for provisioned throughput mode for SageMaker Feature Groups
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.26.0](service/servicecatalog/CHANGELOG.md#v1260-2024-01-04)
  * **Feature**: Added Idempotency token support to Service Catalog  AssociateServiceActionWithProvisioningArtifact, DisassociateServiceActionFromProvisioningArtifact, DeleteServiceAction API

# Release (2024-01-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.88.0](service/connect/CHANGELOG.md#v1880-2024-01-03)
  * **Feature**: Amazon Connect, Contact Lens Evaluation API increase evaluation notes max length to 3072.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.49.0](service/mediaconvert/CHANGELOG.md#v1490-2024-01-03)
  * **Feature**: This release includes video engine updates including HEVC improvements, support for ingesting VP9 encoded video in MP4 containers, and support for user-specified 3D LUTs.

# Release (2023-12-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.26.0](service/apprunner/CHANGELOG.md#v1260-2023-12-29)
  * **Feature**: AWS App Runner adds Python 3.11 and Node.js 18 runtimes.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.34.0](service/location/CHANGELOG.md#v1340-2023-12-29)
  * **Feature**: This release introduces a new parameter to bypasses an API key's expiry conditions and delete the key.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.55.0](service/quicksight/CHANGELOG.md#v1550-2023-12-29)
  * **Feature**: Add LinkEntityArn support for different partitions; Add UnsupportedUserEditionException in UpdateDashboardLinks API; Add support for New Reader Experience Topics

# Release (2023-12-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.22.0](service/codestarconnections/CHANGELOG.md#v1220-2023-12-28)
  * **Feature**: New integration with the GitLab self-managed provider type.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia`: [v1.21.0](service/kinesisvideoarchivedmedia/CHANGELOG.md#v1210-2023-12-28)
  * **Feature**: NoDataRetentionException thrown when GetImages requested for a Stream that does not retain data (that is, has a DataRetentionInHours of 0).
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.123.0](service/sagemaker/CHANGELOG.md#v11230-2023-12-28)
  * **Feature**: Amazon SageMaker Studio now supports Docker access from within app container

# Release (2023-12-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.36.0](service/emr/CHANGELOG.md#v1360-2023-12-27)
  * **Feature**: Add support for customers to modify cluster attribute auto-terminate post cluster launch

# Release (2023-12-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.28.6](service/iam/CHANGELOG.md#v1286-2023-12-26)
  * **Documentation**: Documentation updates for AWS Identity and Access Management (IAM).

# Release (2023-12-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.73.0](service/glue/CHANGELOG.md#v1730-2023-12-22)
  * **Feature**: This release adds additional configurations for Query Session Context on the following APIs: GetUnfilteredTableMetadata, GetUnfilteredPartitionMetadata, GetUnfilteredPartitionsMetadata.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.29.0](service/lakeformation/CHANGELOG.md#v1290-2023-12-22)
  * **Feature**: This release adds additional configurations on GetTemporaryGlueTableCredentials for Query Session Context.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.25.0](service/mediaconnect/CHANGELOG.md#v1250-2023-12-22)
  * **Feature**: This release adds the DescribeSourceMetadata API. This API can be used to view the stream information of the flow's source.
* `github.com/aws/aws-sdk-go-v2/service/networkmonitor`: [v1.0.0](service/networkmonitor/CHANGELOG.md#v100-2023-12-22)
  * **Release**: New AWS service client module
  * **Feature**: CloudWatch Network Monitor is a new service within CloudWatch that will help network administrators and operators continuously monitor network performance metrics such as round-trip-time and packet loss between their AWS-hosted applications and their on-premises locations.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.16.6](service/omics/CHANGELOG.md#v1166-2023-12-22)
  * **Documentation**: Provides minor corrections and an updated description of APIs.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.26.0](service/secretsmanager/CHANGELOG.md#v1260-2023-12-22)
  * **Feature**: Update endpoint rules and examples.

# Release (2023-12-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.22.0](service/amp/CHANGELOG.md#v1220-2023-12-21)
  * **Feature**: This release updates Amazon Managed Service for Prometheus APIs to support customer managed KMS keys.
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.23.0](service/appintegrations/CHANGELOG.md#v1230-2023-12-21)
  * **Feature**: The Amazon AppIntegrations service adds DeleteApplication API for deleting applications, and updates APIs to support third party applications reacting to workspace events and make data requests to Amazon Connect for agent and contact events.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.2.0](service/bedrockagent/CHANGELOG.md#v120-2023-12-21)
  * **Feature**: This release introduces Amazon Aurora as a vector store on Knowledge Bases for Amazon Bedrock
* `github.com/aws/aws-sdk-go-v2/service/codecommit`: [v1.20.0](service/codecommit/CHANGELOG.md#v1200-2023-12-21)
  * **Feature**: AWS CodeCommit now supports customer managed keys from AWS Key Management Service. UpdateRepositoryEncryptionKey is added for updating the key configuration. CreateRepository, GetRepository, BatchGetRepositories are updated with new input or output parameters.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.87.0](service/connect/CHANGELOG.md#v1870-2023-12-21)
  * **Feature**: Adds APIs to manage User Proficiencies and Predefined Attributes. Enhances StartOutboundVoiceContact API input. Introduces SearchContacts API. Enhances DescribeContact API. Adds an API to update Routing Attributes in QueuePriority and QueueTimeAdjustmentSeconds.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.44.0](service/medialive/CHANGELOG.md#v1440-2023-12-21)
  * **Feature**: MediaLive now supports the ability to configure the audio that an AWS Elemental Link UHD device produces, when the device is configured as the source for a flow in AWS Elemental MediaConnect.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.1.0](service/neptunegraph/CHANGELOG.md#v110-2023-12-21)
  * **Feature**: Adds Waiters for successful creation and deletion of Graph, Graph Snapshot, Import Task and Private Endpoints for Neptune Analytics
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.66.0](service/rds/CHANGELOG.md#v1660-2023-12-21)
  * **Feature**: This release adds support for using RDS Data API with Aurora PostgreSQL Serverless v2 and provisioned DB clusters.
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.19.0](service/rdsdata/CHANGELOG.md#v1190-2023-12-21)
  * **Feature**: This release adds support for using RDS Data API with Aurora PostgreSQL Serverless v2 and provisioned DB clusters.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.122.0](service/sagemaker/CHANGELOG.md#v11220-2023-12-21)
  * **Feature**: Amazon SageMaker Training now provides model training container access for debugging purposes. Amazon SageMaker Search now provides the ability to use visibility conditions to limit resource access to a single domain or multiple domains.

# Release (2023-12-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.31.0](service/appstream/CHANGELOG.md#v1310-2023-12-20)
  * **Feature**: This release introduces configurable clipboard, allowing admins to specify the maximum length of text that can be copied by the users from their device to the remote session and vice-versa.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.37.0](service/eks/CHANGELOG.md#v1370-2023-12-20)
  * **Feature**: Add support for cluster insights, new EKS capability that surfaces potentially upgrade impacting issues.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.36.0](service/guardduty/CHANGELOG.md#v1360-2023-12-20)
  * **Feature**: This release 1) introduces a new API: GetOrganizationStatistics , and 2) adds a new UsageStatisticType TOP_ACCOUNTS_BY_FEATURE for GetUsageStatistics API
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.7.0](service/managedblockchainquery/CHANGELOG.md#v170-2023-12-20)
  * **Feature**: Adding Confirmation Status and Execution Status to GetTransaction Response.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.33.0](service/mediatailor/CHANGELOG.md#v1330-2023-12-20)
  * **Feature**: Adds the ability to configure time shifting on MediaTailor channels using the TimeShiftConfiguration field
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.36.0](service/route53/CHANGELOG.md#v1360-2023-12-20)
  * **Feature**: Amazon Route 53 now supports the Canada West (Calgary) Region (ca-west-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

# Release (2023-12-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.27.0](service/appsync/CHANGELOG.md#v1270-2023-12-19)
  * **Feature**: This release adds additional configurations on GraphQL APIs for limits on query depth, resolver count, and introspection
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmeetings`: [v1.21.0](service/chimesdkmeetings/CHANGELOG.md#v1210-2023-12-19)
  * **Feature**: Add meeting features to specify a maximum camera resolution, a maximum content sharing resolution, and a maximum number of attendees for a given meeting.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.142.0](service/ec2/CHANGELOG.md#v11420-2023-12-19)
  * **Feature**: Provision BYOIPv4 address ranges and advertise them by specifying the network border groups option in Los Angeles, Phoenix and Dallas AWS Local Zones.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.40.0](service/fsx/CHANGELOG.md#v1400-2023-12-19)
  * **Feature**: Added support for FSx for OpenZFS on-demand data replication across AWS accounts and/or regions.Added the IncludeShared attribute for DescribeSnapshots.Added the CopyStrategy attribute for OpenZFSVolumeConfiguration.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.23.0](service/marketplacecatalog/CHANGELOG.md#v1230-2023-12-19)
  * **Feature**: AWS Marketplace now supports a new API, BatchDescribeEntities, which returns metadata and content for multiple entities.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.65.0](service/rds/CHANGELOG.md#v1650-2023-12-19)
  * **Feature**: RDS - The release adds two new APIs: DescribeDBRecommendations and ModifyDBRecommendation

# Release (2023-12-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.32.0](service/cognitoidentityprovider/CHANGELOG.md#v1320-2023-12-18)
  * **Feature**: Amazon Cognito now supports trigger versions that define the fields in the request sent to pre token generation Lambda triggers.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.36.0](service/eks/CHANGELOG.md#v1360-2023-12-18)
  * **Feature**: Add support for EKS Cluster Access Management.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.54.1](service/quicksight/CHANGELOG.md#v1541-2023-12-18)
  * **Documentation**: A docs-only release to add missing entities to the API reference.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.24.0](service/route53resolver/CHANGELOG.md#v1240-2023-12-18)
  * **Feature**: Add DOH protocols in resolver endpoints.

# Release (2023-12-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.22.5](service/cloud9/CHANGELOG.md#v1225-2023-12-15)
  * **Documentation**: Updated Cloud9 API documentation for AL2023 release
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.86.0](service/connect/CHANGELOG.md#v1860-2023-12-15)
  * **Feature**: Adds relatedContactId field to StartOutboundVoiceContact API input. Introduces PauseContact API and ResumeContact API for Task contacts. Adds pause duration, number of pauses, timestamps for last paused and resumed events to DescribeContact API response. Adds new Rule type and new Rule action.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.27.6](service/kms/CHANGELOG.md#v1276-2023-12-15)
  * **Documentation**: Documentation updates for AWS Key Management Service
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.64.6](service/rds/CHANGELOG.md#v1646-2023-12-15)
  * **Documentation**: Updates Amazon RDS documentation by adding code examples
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.121.0](service/sagemaker/CHANGELOG.md#v11210-2023-12-15)
  * **Feature**: This release 1) introduces a new API: DeleteCompilationJob , and 2) adds InfraCheckConfig for Create/Describe training job API

# Release (2023-12-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.30.0](service/appstream/CHANGELOG.md#v1300-2023-12-14)
  * **Feature**: This release includes support for images of Windows Server 2022 platform.
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.9](service/b2bi/CHANGELOG.md#v100-preview9-2023-12-14)
  * **Documentation**: Documentation updates for AWS B2B Data Interchange
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.14.0](service/billingconductor/CHANGELOG.md#v1140-2023-12-14)
  * **Feature**: Billing Conductor is releasing a new API, GetBillingGroupCostReport, which provides the ability to retrieve/view the Billing Group Cost Report broken down by attributes for a specific billing group.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.85.0](service/connect/CHANGELOG.md#v1850-2023-12-14)
  * **Feature**: This release adds support for more granular billing using tags (key:value pairs)
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.10.6](service/controltower/CHANGELOG.md#v1106-2023-12-14)
  * **Documentation**: Documentation updates for AWS Control Tower.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.23.0](service/firehose/CHANGELOG.md#v1230-2023-12-14)
  * **Feature**: This release, 1) adds configurable buffering hints for the Splunk destination, and 2) reduces the minimum configurable buffering interval for supported destinations
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.28.0](service/gamelift/CHANGELOG.md#v1280-2023-12-14)
  * **Feature**: Amazon GameLift adds the ability to add and update the game properties of active game sessions.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.47.0](service/iot/CHANGELOG.md#v1470-2023-12-14)
  * **Feature**: This release adds the ability to self-manage certificate signing in AWS IoT Core fleet provisioning using the new certificate provider resource.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.0.0](service/neptunegraph/CHANGELOG.md#v100-2023-12-14)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for Amazon Neptune Analytics
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.27.0](service/opensearch/CHANGELOG.md#v1270-2023-12-14)
  * **Feature**: Updating documentation for Amazon OpenSearch Service support for new zero-ETL integration with Amazon S3.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.54.0](service/quicksight/CHANGELOG.md#v1540-2023-12-14)
  * **Feature**: Update Dashboard Links support; SingleAxisOptions support; Scatterplot Query limit support.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.35.6](service/workspaces/CHANGELOG.md#v1356-2023-12-14)
  * **Documentation**: Updated note to ensure customers understand running modes.

# Release (2023-12-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.21.0](service/drs/CHANGELOG.md#v1210-2023-12-13)
  * **Feature**: Adding AgentVersion to SourceServer and RecoveryInstance structures

# Release (2023-12-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.30.0](service/cloudwatchlogs/CHANGELOG.md#v1300-2023-12-12)
  * **Feature**: This release introduces the StartLiveTail API to tail ingested logs in near real time.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.30.0](service/imagebuilder/CHANGELOG.md#v1300-2023-12-12)
  * **Feature**: This release adds the Image Workflows feature to give more flexibility and control over the image building and testing process.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.33.0](service/location/CHANGELOG.md#v1330-2023-12-12)
  * **Feature**: This release 1)  adds sub-municipality field in Places API for searching and getting places information, and 2) allows optimizing route calculation based on expected arrival time.

# Release (2023-12-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.28.0](service/neptune/CHANGELOG.md#v1280-2023-12-11)
  * **Feature**: This release adds a new parameter configuration setting to the Neptune cluster related APIs that can be leveraged to switch between the underlying supported storage modes.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.26.6](service/pinpoint/CHANGELOG.md#v1266-2023-12-11)
  * **Documentation**: This release includes Amazon Pinpoint API documentation updates pertaining to campaign message sending rate limits.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.44.0](service/securityhub/CHANGELOG.md#v1440-2023-12-11)
  * **Feature**: Added new resource detail objects to ASFF, including resources for AwsDynamoDbTable, AwsEc2ClientVpnEndpoint, AwsMskCluster, AwsS3AccessPoint, AwsS3Bucket

# Release (2023-12-08)

## General Highlights
* **Bug Fix**: Reinstate presence of default Retryer in functional options, but still respect max attempts set therein.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.26.1](config/CHANGELOG.md#v1261-2023-12-08)
  * **Bug Fix**: Correct loading of [services *] sections into shared config.
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.7.2](internal/ini/CHANGELOG.md#v172-2023-12-08)
  * **Bug Fix**: Correct loading of [services *] sections into shared config.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.32.0](service/cloudwatch/CHANGELOG.md#v1320-2023-12-08)
  * **Feature**: Adds support for the OpenTelemetry 1.0 output format in CloudWatch Metric Streams.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.141.0](service/ec2/CHANGELOG.md#v11410-2023-12-08)
  * **Feature**: M2 Mac instances are built on Apple M2 Mac mini computers. I4i instances are powered by 3rd generation Intel Xeon Scalable processors. C7i compute optimized, M7i general purpose and R7i memory optimized instances are powered by custom 4th Generation Intel Xeon Scalable processors.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.20.0](service/finspace/CHANGELOG.md#v1200-2023-12-08)
  * **Feature**: Releasing Scaling Group, Dataview, and Volume APIs
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.47.5](service/s3/CHANGELOG.md#v1475-2023-12-08)
  * **Bug Fix**: Add non-vhostable buckets to request path when using legacy V1 endpoint resolver.
  * **Bug Fix**: Improve uniqueness of default S3Express sesssion credentials cache keying to prevent collision in multi-credential scenarios.

# Release (2023-12-07)

## General Highlights
* **Feature**: Support modeled request compression. The only algorithm supported at this time is `gzip`.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.22.0](service/codedeploy/CHANGELOG.md#v1220-2023-12-07)
  * **Feature**: This release adds support for two new CodeDeploy features: 1) zonal deployments for Amazon EC2 in-place deployments, 2) deployments triggered by Auto Scaling group termination lifecycle hook events.

# Release (2023-12-06)

## General Highlights
* **Bug Fix**: Restore pre-refactor auth behavior where all operations could technically be performed anonymously.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.31.0](service/backup/CHANGELOG.md#v1310-2023-12-06)
  * **Feature**: AWS Backup - Features: Add VaultType to the output of DescribeRecoveryPoint, ListRecoveryPointByBackupVault API and add ResourceType to the input of ListRestoreJobs API
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.29.3](service/comprehend/CHANGELOG.md#v1293-2023-12-06)
  * **Documentation**: Documentation updates for Trust and Safety features.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.84.0](service/connect/CHANGELOG.md#v1840-2023-12-06)
  * **Feature**: Releasing Tagging Support for Instance Management APIS
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.140.0](service/ec2/CHANGELOG.md#v11400-2023-12-06)
  * **Feature**: Releasing the new cpuManufacturer attribute within the DescribeInstanceTypes API response which notifies our customers with information on who the Manufacturer is for the processor attached to the instance, for example: Intel.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.6.0](service/paymentcryptography/CHANGELOG.md#v160-2023-12-06)
  * **Feature**: AWS Payment Cryptography IPEK feature release
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.26.3](service/sts/CHANGELOG.md#v1263-2023-12-06)
  * **Bug Fix**: STS `AssumeRoleWithSAML` and `AssumeRoleWithWebIdentity` would incorrectly attempt to use SigV4 authentication.

# Release (2023-12-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.37.0](service/athena/CHANGELOG.md#v1370-2023-12-05)
  * **Feature**: Adding IdentityCenter enabled request for interactive query
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.1.0](service/cleanroomsml/CHANGELOG.md#v110-2023-12-05)
  * **Feature**: Updated service title from cleanroomsml to CleanRoomsML.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.42.1](service/cloudformation/CHANGELOG.md#v1421-2023-12-05)
  * **Documentation**: Documentation update, December 2023
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.139.0](service/ec2/CHANGELOG.md#v11390-2023-12-05)
  * **Feature**: Adds A10G, T4G, and H100 as accelerator name options and Habana as an accelerator manufacturer option for attribute based selection

# Release (2023-12-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.13.0](service/billingconductor/CHANGELOG.md#v1130-2023-12-04)
  * **Feature**: This release adds the ability to specify a linked account of the billing group for the custom line item resource.
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.24.0](service/braket/CHANGELOG.md#v1240-2023-12-04)
  * **Feature**: This release enhances service support to create quantum tasks and hybrid jobs associated with Braket Direct Reservations.
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.22.0](service/cloud9/CHANGELOG.md#v1220-2023-12-04)
  * **Feature**: This release adds the requirement to include the imageId parameter in the CreateEnvironmentEC2 API call.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.42.0](service/cloudformation/CHANGELOG.md#v1420-2023-12-04)
  * **Feature**: Including UPDATE_* states as a success status for CreateStack waiter.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.19.0](service/finspace/CHANGELOG.md#v1190-2023-12-04)
  * **Feature**: Release General Purpose type clusters
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.43.0](service/medialive/CHANGELOG.md#v1430-2023-12-04)
  * **Feature**: Adds support for custom color correction on channels using 3D LUT files.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.24.3](service/servicecatalogappregistry/CHANGELOG.md#v1243-2023-12-04)
  * **Documentation**: Documentation-only updates for Dawn

# Release (2023-12-01)

## General Highlights
* **Bug Fix**: Correct wrapping of errors in authentication workflow.
* **Bug Fix**: Correctly recognize cache-wrapped instances of AnonymousCredentials at client construction.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.2.0](service/qconnect/CHANGELOG.md#v120-2023-12-01)
  * **Feature**: This release adds the PutFeedback API and allows providing feedback against the specified assistant for the specified target.
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.14.0](service/rbin/CHANGELOG.md#v1140-2023-12-01)
  * **Feature**: Added resource identifier in the output and updated error handling.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.8.0](service/verifiedpermissions/CHANGELOG.md#v180-2023-12-01)
  * **Feature**: Adds description field to PolicyStore API's and namespaces field to GetSchema.

# Release (2023-11-30.2)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.7.0](service/arczonalshift/CHANGELOG.md#v170-2023-11-302)
  * **Feature**: This release adds a new capability, zonal autoshift. You can configure zonal autoshift so that AWS shifts traffic for a resource away from an Availability Zone, on your behalf, when AWS determines that there is an issue that could potentially affect customers in the Availability Zone.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.26.2](service/dynamodb/CHANGELOG.md#v1262-2023-11-302)
  * **Bug Fix**: Respect caller region overrides in endpoint discovery.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.72.0](service/glue/CHANGELOG.md#v1720-2023-11-302)
  * **Feature**: Adds observation and analyzer support to the GetDataQualityResult and BatchGetDataQualityResult APIs.
* `github.com/aws/aws-sdk-go-v2/service/internal/endpoint-discovery`: [v1.8.8](service/internal/endpoint-discovery/CHANGELOG.md#v188-2023-11-302)
  * **Bug Fix**: Respect caller region overrides in endpoint discovery.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.120.0](service/sagemaker/CHANGELOG.md#v11200-2023-11-302)
  * **Feature**: This release adds support for 1/ Code Editor, based on Code-OSS, Visual Studio Code Open Source, a new fully managed IDE option in SageMaker Studio  2/ JupyterLab, a new fully managed JupyterLab IDE experience in SageMaker Studio
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.20.2](service/timestreamquery/CHANGELOG.md#v1202-2023-11-302)
  * **Bug Fix**: Respect caller region overrides in endpoint discovery.
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.23.2](service/timestreamwrite/CHANGELOG.md#v1232-2023-11-302)
  * **Bug Fix**: Respect caller region overrides in endpoint discovery.

# Release (2023-11-30)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/marketplaceagreement`: [v1.0.0](service/marketplaceagreement/CHANGELOG.md#v100-2023-11-30)
  * **Release**: New AWS service client module
  * **Feature**: The AWS Marketplace Agreement Service provides an API interface that helps AWS Marketplace sellers manage their agreements, including listing, filtering, and viewing details about their agreements.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.22.0](service/marketplacecatalog/CHANGELOG.md#v1220-2023-11-30)
  * **Feature**: This release enhances the ListEntities API to support new entity type-specific strongly typed filters in the request and entity type-specific strongly typed summaries in the response.
* `github.com/aws/aws-sdk-go-v2/service/marketplacedeployment`: [v1.0.0](service/marketplacedeployment/CHANGELOG.md#v100-2023-11-30)
  * **Release**: New AWS service client module
  * **Feature**: AWS Marketplace Deployment is a new service that provides essential features that facilitate the deployment of software, data, and services procured through AWS Marketplace.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.15.0](service/redshiftserverless/CHANGELOG.md#v1150-2023-11-30)
  * **Feature**: This release adds the following support for Amazon Redshift Serverless: 1) cross-account cross-VPCs, 2) copying snapshots across Regions, 3) scheduling snapshot creation, and 4) restoring tables from a recovery point.

# Release (2023-11-29)

## General Highlights
* **Feature**: Expose Options() accessor on service clients.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.25.0](service/applicationautoscaling/CHANGELOG.md#v1250-2023-11-29)
  * **Feature**: Amazon SageMaker customers can now use Application Auto Scaling to automatically scale the number of Inference Component copies across an endpoint to meet the varying demand of their workloads.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.8.0](service/cleanrooms/CHANGELOG.md#v180-2023-11-29)
  * **Feature**: AWS Clean Rooms now provides differential privacy to protect against user-identification attempts and machine learning modeling to allow two parties to identify similar users in their data.
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.0.0](service/cleanroomsml/CHANGELOG.md#v100-2023-11-29)
  * **Release**: New AWS service client module
  * **Feature**: Public Preview SDK release of AWS Clean Rooms ML APIs
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.26.0](service/opensearch/CHANGELOG.md#v1260-2023-11-29)
  * **Feature**: Launching Amazon OpenSearch Service support for new zero-ETL integration with Amazon S3. Customers can now manage their direct query data sources to Amazon S3 programatically
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.9.0](service/opensearchserverless/CHANGELOG.md#v190-2023-11-29)
  * **Feature**: Amazon OpenSearch Serverless collections support an additional attribute called standby-replicas. This allows to specify whether a collection should have redundancy enabled.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.119.0](service/sagemaker/CHANGELOG.md#v11190-2023-11-29)
  * **Feature**: This release adds following support 1/ Improved SDK tooling for model deployment. 2/ New Inference Component based features to lower inference costs and latency 3/ SageMaker HyperPod management. 4/ Additional parameters for FM Fine Tuning in Autopilot
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.25.0](service/sagemakerruntime/CHANGELOG.md#v1250-2023-11-29)
  * **Feature**: This release adds InferenceComponentName to InvokeEndpoint and InvokeEndpointWithResponseStream APIs to get inferences from the deployed InferenceComponents.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.26.0](service/sts/CHANGELOG.md#v1260-2023-11-29)
  * **Documentation**: Documentation updates for AWS Security Token Service.

# Release (2023-11-28.3)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.25.8](config/CHANGELOG.md#v1258-2023-11-283)
  * **Bug Fix**: Correct resolution of S3Express auth disable toggle.

# Release (2023-11-28.2)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.15.0](feature/s3/manager/CHANGELOG.md#v1150-2023-11-282)
  * **Feature**: Add S3Express support.
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.25.0](service/accessanalyzer/CHANGELOG.md#v1250-2023-11-282)
  * **Feature**: This release adds support for external access findings for S3 directory buckets to help you easily identify cross-account access. Updated service API, documentation, and paginators.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.4.0](service/bedrock/CHANGELOG.md#v140-2023-11-282)
  * **Feature**: This release adds support for customization types, model life cycle status and minor versions/aliases for model identifiers.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.0.0](service/bedrockagent/CHANGELOG.md#v100-2023-11-282)
  * **Release**: New AWS service client module
  * **Feature**: This release introduces Agents for Amazon Bedrock
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.0.0](service/bedrockagentruntime/CHANGELOG.md#v100-2023-11-282)
  * **Release**: New AWS service client module
  * **Feature**: This release introduces Agents for Amazon Bedrock Runtime
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.4.0](service/bedrockruntime/CHANGELOG.md#v140-2023-11-282)
  * **Feature**: This release adds support for minor versions/aliases for invoke model identifier.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.82.0](service/connect/CHANGELOG.md#v1820-2023-11-282)
  * **Feature**: Added support for following capabilities: Amazon Connect's in-app, web, and video calling. Two-way SMS integrations. Contact Lens real-time chat analytics feature. Amazon Connect Analytics Datalake capability. Capability to configure real time chat rules.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.33.0](service/customerprofiles/CHANGELOG.md#v1330-2023-11-282)
  * **Feature**: This release introduces DetectProfileObjectType API to auto generate object type mapping.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.0.0](service/qbusiness/CHANGELOG.md#v100-2023-11-282)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Q - a generative AI powered application that your employees can use to ask questions and get answers from knowledge spread across disparate content repositories, summarize reports, write articles, take actions, and much more - all within their company's connected content repositories.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.0.0](service/qconnect/CHANGELOG.md#v100-2023-11-282)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Q in Connect, an LLM-enhanced evolution of Amazon Connect Wisdom. This release adds generative AI support to Amazon Q Connect QueryAssistant and GetRecommendations APIs.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.46.0](service/s3/CHANGELOG.md#v1460-2023-11-282)
  * **Feature**: Add S3Express support.
  * **Feature**: Adds support for S3 Express One Zone.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.40.0](service/s3control/CHANGELOG.md#v1400-2023-11-282)
  * **Feature**: Adds support for S3 Express One Zone, and InvocationSchemaVersion 2.0 for S3 Batch Operations.

# Release (2023-11-28)

## General Highlights
* **Bug Fix**: Respect setting RetryMaxAttempts in functional options at client construction.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.33.0](service/elasticache/CHANGELOG.md#v1330-2023-11-28)
  * **Feature**: Launching Amazon ElastiCache Serverless that enables you to create a cache in under a minute without any capacity management. ElastiCache Serverless monitors the cache's memory, CPU, and network usage and scales both vertically and horizontally to support your application's requirements.

# Release (2023-11-27.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.25.0](service/appsync/CHANGELOG.md#v1250-2023-11-272)
  * **Feature**: This update enables introspection of Aurora cluster databases using the RDS Data API
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview](service/b2bi/CHANGELOG.md#v100-preview-2023-11-272)
  * **Feature**: This is the initial SDK release for AWS B2B Data Interchange.
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.29.0](service/backup/CHANGELOG.md#v1290-2023-11-272)
  * **Feature**: AWS Backup now supports restore testing, a new feature that allows customers to automate restore testing and validating their backups. Additionally, this release adds support for EBS Snapshots Archive tier.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.9.0](service/controltower/CHANGELOG.md#v190-2023-11-272)
  * **Feature**: This release adds the following support: 1. The EnableControl API can configure controls that are configurable.  2. The GetEnabledControl API shows the configured parameters on an enabled control. 3. The new UpdateEnabledControl API can change parameters on an enabled control.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.25.0](service/efs/CHANGELOG.md#v1250-2023-11-272)
  * **Feature**: Adding support for EFS Replication to existing file system.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.20.0](service/fis/CHANGELOG.md#v1200-2023-11-272)
  * **Feature**: AWS FIS adds support for multi-account experiments & empty target resolution. This release also introduces the CreateTargetAccountConfiguration API that allows experiments across multiple AWS accounts, and the ListExperimentResolvedTargets API to list target details.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.70.0](service/glue/CHANGELOG.md#v1700-2023-11-272)
  * **Feature**: add observations support to DQ CodeGen config model + update document for connectiontypes supported by ConnectorData entities
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.63.3](service/rds/CHANGELOG.md#v1633-2023-11-272)
  * **Documentation**: Updates Amazon RDS documentation for support for RDS for Db2.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.42.0](service/securityhub/CHANGELOG.md#v1420-2023-11-272)
  * **Feature**: Adds and updates APIs to support central configuration. This feature allows the Security Hub delegated administrator to configure Security Hub for their entire AWS Org across multiple regions from a home Region. With this release, findings also include account name and application metadata.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.33.0](service/transcribe/CHANGELOG.md#v1330-2023-11-272)
  * **Feature**: This release adds support for AWS HealthScribe APIs within Amazon Transcribe

# Release (2023-11-27)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.24.0](service/accessanalyzer/CHANGELOG.md#v1240-2023-11-27)
  * **Feature**: IAM Access Analyzer now continuously monitors IAM roles and users in your AWS account or organization to generate findings for unused access. Additionally, IAM Access Analyzer now provides custom policy checks to validate that IAM policies adhere to your security standards ahead of deployments.
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.20.0](service/amp/CHANGELOG.md#v1200-2023-11-27)
  * **Feature**: This release adds support for the Amazon Managed Service for Prometheus collector, a fully managed, agentless Prometheus metrics scraping capability.
* `github.com/aws/aws-sdk-go-v2/service/bcmdataexports`: [v1.0.0](service/bcmdataexports/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: Users can create, read, update, delete Exports of billing and cost management data.  Users can get details of Export Executions and details of Tables for exporting.  Tagging support is provided for Exports
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.34.0](service/cloudtrail/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: CloudTrail Lake now supports federating event data stores. giving users the ability to run queries against their event data using Amazon Athena.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.28.0](service/cloudwatchlogs/CHANGELOG.md#v1280-2023-11-27)
  * **Feature**: Added APIs to Create, Update, Get, List and Delete LogAnomalyDetectors and List and Update Anomalies in Detector. Added LogGroupClass attribute for LogGroups to classify loggroup as Standard loggroup with all capabilities or InfrequentAccess loggroup with limited capabilities.
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.20.0](service/codestarconnections/CHANGELOG.md#v1200-2023-11-27)
  * **Feature**: This release adds support for the CloudFormation Git sync feature. Git sync enables updating a CloudFormation stack from a template stored in a Git repository.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.30.0](service/computeoptimizer/CHANGELOG.md#v1300-2023-11-27)
  * **Feature**: This release enables AWS Compute Optimizer to analyze and generate recommendations with customization and discounts preferences.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.42.0](service/configservice/CHANGELOG.md#v1420-2023-11-27)
  * **Feature**: Support Periodic Recording for Configuration Recorder
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.8.0](service/controltower/CHANGELOG.md#v180-2023-11-27)
  * **Feature**: Add APIs to create and manage a landing zone.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.0.0](service/costoptimizationhub/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: This release launches Cost Optimization Hub, a new AWS Billing and Cost Management feature that helps you consolidate and prioritize cost optimization recommendations across your AWS Organizations member accounts and AWS Regions, so that you can get the most out of your AWS spend.
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.24.0](service/detective/CHANGELOG.md#v1240-2023-11-27)
  * **Feature**: Added new APIs in Detective to support resource investigations
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.34.0](service/ecs/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: Adds a new 'type' property to the Setting structure. Adds a new AccountSetting - guardDutyActivate for ECS.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.24.0](service/efs/CHANGELOG.md#v1240-2023-11-27)
  * **Feature**: Adding support for EFS Archive lifecycle configuration.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.34.0](service/eks/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: This release adds support for EKS Pod Identity feature. EKS Pod Identity makes it easy for customers to obtain IAM permissions for the applications running in their EKS clusters.
* `github.com/aws/aws-sdk-go-v2/service/eksauth`: [v1.0.0](service/eksauth/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for EKS Pod Identity feature. EKS Pod Identity makes it easy for customers to obtain IAM permissions for their applications running in the EKS clusters.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.25.0](service/elasticloadbalancingv2/CHANGELOG.md#v1250-2023-11-27)
  * **Feature**: This release enables both mutual authentication (mTLS), and Automatic Target Weights (ATW) for Application Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/freetier`: [v1.0.0](service/freetier/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for the AWS Free Tier GetFreeTierUsage API
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.38.0](service/fsx/CHANGELOG.md#v1380-2023-11-27)
  * **Feature**: Added support for FSx for ONTAP scale-out file systems and FlexGroup volumes. Added the HAPairs field and ThroughputCapacityPerHAPair for filesystem. Added AggregateConfiguration (containing Aggregates and ConstituentsPerAggregate) and SizeInBytes for volume.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.34.0](service/guardduty/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: Add support for Runtime Monitoring for ECS and ECS-EC2.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.9.0](service/iotfleetwise/CHANGELOG.md#v190-2023-11-27)
  * **Feature**: AWS IoT FleetWise introduces new APIs for vision system data, such as data collected from cameras, radars, and lidars. You can now model and decode complex data types.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.27.0](service/lakeformation/CHANGELOG.md#v1270-2023-11-27)
  * **Feature**: This release adds four new APIs "DescribeLakeFormationIdentityCenterConfiguration", "CreateLakeFormationIdentityCenterConfiguration", "DescribeLakeFormationIdentityCenterConfiguration", and "DeleteLakeFormationIdentityCenterConfiguration", and also updates the corresponding documentation.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.37.0](service/lexmodelsv2/CHANGELOG.md#v1370-2023-11-27)
  * **Feature**: This release introduces new generative AI features in AWS Lex: Assisted Slot Resolution, Descriptive Bot Building, and Sample Utterance Generation. These features leverage large language models available through Amazon Bedrock to improve the bot builder and customer experiences.
* `github.com/aws/aws-sdk-go-v2/service/lexruntimev2`: [v1.22.0](service/lexruntimev2/CHANGELOG.md#v1220-2023-11-27)
  * **Feature**: This release introduces support for interpretationSource in the runtime service response.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.19.0](service/managedblockchain/CHANGELOG.md#v1190-2023-11-27)
  * **Feature**: Add optional NetworkType property to Accessor APIs
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.29.0](service/personalize/CHANGELOG.md#v1290-2023-11-27)
  * **Feature**: Enables metadata in recommendations, recommendations with themes, and next best action recommendations
* `github.com/aws/aws-sdk-go-v2/service/personalizeevents`: [v1.18.0](service/personalizeevents/CHANGELOG.md#v1180-2023-11-27)
  * **Feature**: This release enables PutActions and PutActionInteractions
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.19.0](service/personalizeruntime/CHANGELOG.md#v1190-2023-11-27)
  * **Feature**: Enables metadata in recommendations and next best action recommendations
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.52.0](service/quicksight/CHANGELOG.md#v1520-2023-11-27)
  * **Feature**: This release launches new APIs for trusted identity propagation setup and supports creating datasources using trusted identity propagation as authentication method for QuickSight accounts configured with IAM Identity Center.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.38.0](service/redshift/CHANGELOG.md#v1380-2023-11-27)
  * **Feature**: This release adds support for multi-data warehouse writes through data sharing.
* `github.com/aws/aws-sdk-go-v2/service/repostspace`: [v1.0.0](service/repostspace/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of AWS re:Post Private
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.45.0](service/s3/CHANGELOG.md#v1450-2023-11-27)
  * **Feature**: Adding new params - Key and Prefix, to S3 API operations for supporting S3 Access Grants. Note - These updates will not change any of the existing S3 API functionality.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.39.0](service/s3control/CHANGELOG.md#v1390-2023-11-27)
  * **Feature**: Introduce Amazon S3 Access Grants, a new S3 access control feature that maps identities in directories such as Active Directory, or AWS Identity and Access Management (IAM) Principals, to datasets in S3.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.24.0](service/secretsmanager/CHANGELOG.md#v1240-2023-11-27)
  * **Feature**: AWS Secrets Manager has released the BatchGetSecretValue API, which allows customers to fetch up to 20 Secrets with a single request using a list of secret names or filters.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.41.0](service/securityhub/CHANGELOG.md#v1410-2023-11-27)
  * **Feature**: Adds and updates APIs to support customizable security controls. This feature allows Security Hub customers to provide custom parameters for security controls. With this release, findings for controls that support custom parameters will include the parameters used to generate the findings.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.23.0](service/sfn/CHANGELOG.md#v1230-2023-11-27)
  * **Feature**: Adds new TestState operation which accepts the definition of a single state and executes it. You can test a state without creating a state machine or updating an existing state machine.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.32.0](service/transcribe/CHANGELOG.md#v1320-2023-11-27)
  * **Feature**: This release adds support for transcriptions from audio sources in 64 new languages and introduces generative call summarization in Transcribe Call Analytics (Post call)
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.34.0](service/workspaces/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: The release introduces Multi-Region Resilience one-way data replication that allows you to replicate data from your primary WorkSpace to a standby WorkSpace in another AWS Region. DescribeWorkspaces now returns the status of data replication.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.0.0](service/workspacesthinclient/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of Amazon WorkSpaces Thin Client

# Release (2023-11-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.23.0](service/kinesis/CHANGELOG.md#v1230-2023-11-22)
  * **Feature**: This release adds support for resource based policies on streams and consumers.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.38.0](service/s3control/CHANGELOG.md#v1380-2023-11-22)
  * **Feature**: **BREAK FIX**: Convert S3Control PublicAccessBlock field types to nilable. See #2384, #2162.
  * **Feature**: Amazon S3 Batch Operations now manages buckets or prefixes in a single step.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.118.0](service/sagemaker/CHANGELOG.md#v11180-2023-11-22)
  * **Feature**: This feature adds the end user license agreement status as a model access configuration parameter.

# Release (2023-11-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/credentials`: [v1.16.4](credentials/CHANGELOG.md#v1164-2023-11-21)
  * **Bug Fix**: Don't expect error responses to have a JSON payload in the endpointcreds provider.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.31.0](service/cloudfront/CHANGELOG.md#v1310-2023-11-21)
  * **Feature**: This release adds support for CloudFront KeyValueStore, a globally managed key value datastore associated with CloudFront Functions.
* `github.com/aws/aws-sdk-go-v2/service/cloudfrontkeyvaluestore`: [v1.0.0](service/cloudfrontkeyvaluestore/CHANGELOG.md#v100-2023-11-21)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for CloudFront KeyValueStore, a globally managed key value datastore associated with CloudFront Functions.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.137.1](service/ec2/CHANGELOG.md#v11371-2023-11-21)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/inspectorscan`: [v1.0.0](service/inspectorscan/CHANGELOG.md#v100-2023-11-21)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for the new Amazon Inspector Scan API. The new Inspector Scan API can synchronously scan SBOMs adhering to the CycloneDX v1.5 format.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.33.0](service/iotsitewise/CHANGELOG.md#v1330-2023-11-21)
  * **Feature**: Adds 1/ user-defined unique identifier for asset and model metadata, 2/ asset model components, and 3/ query API for asset metadata and telemetry data. Supports 4/ multi variate anomaly detection using Amazon Lookout for Equipment, 5/ warm storage tier, and 6/ buffered ingestion of time series data.
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.16.0](service/iottwinmaker/CHANGELOG.md#v1160-2023-11-21)
  * **Feature**: This release adds following support. 1. New APIs for metadata bulk operations. 2. Modify the component type API to support composite component types - nesting component types within one another. 3. New list APIs for components and properties. 4. Support the larger scope digital twin modeling.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.44.0](service/s3/CHANGELOG.md#v1440-2023-11-21)
  * **Feature**: Add support for automatic date based partitioning in S3 Server Access Logs.
  * **Bug Fix**: Don't send MaxKeys/MaxUploads=0 when unspecified in ListObjectVersions and ListMultipartUploads paginators.

# Release (2023-11-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.23.1
  * **Bug Fix**: Mark v4.SignHTTPRequestMiddleware as deprecated, this middleware is no longer used by the SDK.
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.19.0](service/codestarconnections/CHANGELOG.md#v1190-2023-11-20)
  * **Feature**: This release updates a few CodeStar Connections related APIs.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.28.0](service/docdb/CHANGELOG.md#v1280-2023-11-20)
  * **Feature**: Amazon DocumentDB updates for new cluster storage configuration: Amazon DocumentDB I/O-Optimized.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.137.0](service/ec2/CHANGELOG.md#v11370-2023-11-20)
  * **Feature**: This release adds support for Security group referencing over Transit gateways, enabling you to simplify Security group management and control of instance-to-instance traffic across VPCs that are connected by Transit gateway.

# Release (2023-11-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.14.0](feature/s3/manager/CHANGELOG.md#v1140-2023-11-17)
  * **Feature**: **BREAKING CHANGE** Correct nullability of a large number of S3 structure fields. See https://github.com/aws/aws-sdk-go-v2/issues/2162.
* `github.com/aws/aws-sdk-go-v2/service/appmesh`: [v1.22.0](service/appmesh/CHANGELOG.md#v1220-2023-11-17)
  * **Feature**: Change the default value of these fields from 0 to null: MaxConnections, MaxPendingRequests, MaxRequests, HealthCheckThreshold, PortNumber, and HealthCheckPolicy -> port. Users are not expected to perceive the change, except that badRequestException is thrown when required fields missing configured.
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.35.0](service/athena/CHANGELOG.md#v1350-2023-11-17)
  * **Feature**: Adding SerivicePreProcessing time metric
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.20.3](service/cloud9/CHANGELOG.md#v1203-2023-11-17)
  * **Documentation**: A minor doc only update related to changing the date of an API change.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.40.0](service/cloudformation/CHANGELOG.md#v1400-2023-11-17)
  * **Feature**: This release adds a new flag ImportExistingResources to CreateChangeSet. Specify this parameter on a CREATE- or UPDATE-type change set to import existing resources with custom names instead of recreating them.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.21.0](service/codepipeline/CHANGELOG.md#v1210-2023-11-17)
  * **Feature**: CodePipeline now supports overriding source revisions to achieve manual re-deploy of a past revision
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.18.0](service/codestarconnections/CHANGELOG.md#v1180-2023-11-17)
  * **Feature**: This release adds support for the CloudFormation Git sync feature. Git sync enables updating a CloudFormation stack from a template stored in a Git repository.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.81.0](service/connect/CHANGELOG.md#v1810-2023-11-17)
  * **Feature**: This release adds WISDOM_QUICK_RESPONSES as new IntegrationType of Connect IntegrationAssociation resource and bug fixes.
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.21.1](service/dlm/CHANGELOG.md#v1211-2023-11-17)
  * **Documentation**: Added support for SAP HANA in Amazon Data Lifecycle Manager EBS snapshot lifecycle policies with pre and post scripts.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.136.0](service/ec2/CHANGELOG.md#v11360-2023-11-17)
  * **Feature**: This release adds new features for Amazon VPC IP Address Manager (IPAM) Allowing a choice between Free and Advanced Tiers, viewing public IP address insights across regions and in Amazon Cloudwatch, use IPAM to plan your subnet IPs within a VPC and bring your own autonomous system number to IPAM.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.23.0](service/ecr/CHANGELOG.md#v1230-2023-11-17)
  * **Feature**: Documentation and operational updates for Amazon ECR, adding support for pull through cache rules for upstream registries that require authentication.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.34.0](service/emr/CHANGELOG.md#v1340-2023-11-17)
  * **Feature**: Launch support for IAM Identity Center Trusted Identity Propagation and workspace storage encryption using AWS KMS in EMR Studio
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.25.0](service/eventbridge/CHANGELOG.md#v1250-2023-11-17)
  * **Feature**: Introduces a new rule state ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS for matching with Get, List and Describe AWS API call events from CloudTrail.
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.9.0](service/internetmonitor/CHANGELOG.md#v190-2023-11-17)
  * **Feature**: Adds new querying capabilities for running data queries on a monitor
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.29.0](service/ivs/CHANGELOG.md#v1290-2023-11-17)
  * **Feature**: type & defaulting refinement to various range properties
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.9.0](service/ivschat/CHANGELOG.md#v190-2023-11-17)
  * **Feature**: type & defaulting refinement to various range properties
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.20.3](service/kinesisvideo/CHANGELOG.md#v1203-2023-11-17)
  * **Documentation**: Docs only build to bring up-to-date with public docs.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.31.0](service/location/CHANGELOG.md#v1310-2023-11-17)
  * **Feature**: Remove default value and allow nullable for request parameters having minimum value larger than zero.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.41.0](service/medialive/CHANGELOG.md#v1410-2023-11-17)
  * **Feature**: MediaLive has now added support for per-output static image overlay.
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.24.0](service/mgn/CHANGELOG.md#v1240-2023-11-17)
  * **Feature**: Removed invalid and unnecessary default values.
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.5.0](service/osis/CHANGELOG.md#v150-2023-11-17)
  * **Feature**: Add support for enabling a persistent buffer when creating or updating an OpenSearch Ingestion pipeline. Add tags to Pipeline and PipelineSummary response models.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.8.0](service/pipes/CHANGELOG.md#v180-2023-11-17)
  * **Feature**: TargetParameters now properly supports BatchJobParameters.ArrayProperties.Size and BatchJobParameters.RetryStrategy.Attempts being optional, and EcsTaskParameters.Overrides.EphemeralStorage.SizeInGiB now properly required when setting EphemeralStorage
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.63.0](service/rds/CHANGELOG.md#v1630-2023-11-17)
  * **Feature**: This release adds support for option groups and replica enhancements to Amazon RDS Custom.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.37.0](service/redshift/CHANGELOG.md#v1370-2023-11-17)
  * **Feature**: Updated SDK for Amazon Redshift, which you can use to configure a connection with IAM Identity Center to manage access to databases. With these, you can create a connection through a managed application. You can also change a managed application, delete it, or get information about an existing one.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.13.0](service/redshiftserverless/CHANGELOG.md#v1130-2023-11-17)
  * **Feature**: Updated SDK for Amazon Redshift Serverless, which provides the ability to configure a connection with IAM Identity Center to manage user and group access to databases.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.43.0](service/s3/CHANGELOG.md#v1430-2023-11-17)
  * **Feature**: **BREAKING CHANGE** Correct nullability of a large number of S3 structure fields. See https://github.com/aws/aws-sdk-go-v2/issues/2162.
  * **Feature**: Removes all default 0 values for numbers and false values for booleans
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.22.0](service/ssoadmin/CHANGELOG.md#v1220-2023-11-17)
  * **Feature**: Improves support for configuring RefreshToken and TokenExchange grants on applications.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.20.0](service/ssooidc/CHANGELOG.md#v1200-2023-11-17)
  * **Feature**: Adding support for `sso-oauth:CreateTokenWithIAM`.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.25.3](service/sts/CHANGELOG.md#v1253-2023-11-17)
  * **Documentation**: API updates for the AWS Security Token Service
* `github.com/aws/aws-sdk-go-v2/service/trustedadvisor`: [v1.0.0](service/trustedadvisor/CHANGELOG.md#v100-2023-11-17)
  * **Release**: New AWS service client module
  * **Feature**: AWS Trusted Advisor introduces new APIs to enable you to programmatically access Trusted Advisor best practice checks, recommendations, and prioritized recommendations. Trusted Advisor APIs enable you to integrate Trusted Advisor with your operational tools to automate your workloads.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.6.0](service/verifiedpermissions/CHANGELOG.md#v160-2023-11-17)
  * **Feature**: Adding BatchIsAuthorized API which supports multiple authorization requests against a PolicyStore
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.19.0](service/wisdom/CHANGELOG.md#v1190-2023-11-17)
  * **Feature**: This release adds QuickResponse as a new Wisdom resource and Wisdom APIs for import, create, read, search, update and delete QuickResponse resources.

# Release (2023-11-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.7.1](internal/ini/CHANGELOG.md#v171-2023-11-16)
  * **Bug Fix**: Fix recognition of trailing comments in shared config properties. # or ; separators that aren't preceded by whitespace at the end of a property value should be considered part of it.
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.9.0](service/codecatalyst/CHANGELOG.md#v190-2023-11-16)
  * **Feature**: This release includes updates to the Dev Environment APIs to include an optional vpcConnectionName parameter that supports using Dev Environments with Amazon VPC.
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.21.0](service/dlm/CHANGELOG.md#v1210-2023-11-16)
  * **Feature**: This release adds support for Amazon Data Lifecycle Manager default policies for EBS snapshots and EBS-backed AMIs.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.135.0](service/ec2/CHANGELOG.md#v11350-2023-11-16)
  * **Feature**: Enable use of tenant-specific PublicSigningKeyUrl from device trust providers and onboard jumpcloud as a new device trust provider.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.37.0](service/fsx/CHANGELOG.md#v1370-2023-11-16)
  * **Feature**: Enables customers to update their PerUnitStorageThroughput on their Lustre file systems.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.69.0](service/glue/CHANGELOG.md#v1690-2023-11-16)
  * **Feature**: Introduces new column statistics APIs to support statistics generation for tables within the Glue Data Catalog.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.28.0](service/imagebuilder/CHANGELOG.md#v1280-2023-11-16)
  * **Feature**: This release adds the Image Lifecycle Management feature to automate the process of deprecating, disabling and deleting outdated images and their associated resources.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.45.0](service/iot/CHANGELOG.md#v1450-2023-11-16)
  * **Feature**: GA release the ability to index and search devices based on their GeoLocation data. With GeoQueries you can narrow your search to retrieve devices located in the desired geographic boundary.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.8.0](service/ivsrealtime/CHANGELOG.md#v180-2023-11-16)
  * **Feature**: This release introduces server side composition and recording for stages.
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.27.0](service/kafka/CHANGELOG.md#v1270-2023-11-16)
  * **Feature**: Added a new API response field which determines if there is an action required from the customer regarding their cluster.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.48.0](service/lambda/CHANGELOG.md#v1480-2023-11-16)
  * **Feature**: Adds support for logging configuration in Lambda Functions. Customers will have more control how their function logs are captured and to which cloud watch log group they are delivered also.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.33.0](service/macie2/CHANGELOG.md#v1330-2023-11-16)
  * **Feature**: This release adds support for configuring Macie to assume an IAM role when retrieving sample occurrences of sensitive data reported by findings.
* `github.com/aws/aws-sdk-go-v2/service/mediapackage`: [v1.27.0](service/mediapackage/CHANGELOG.md#v1270-2023-11-16)
  * **Feature**: DRM_TOP_LEVEL_COMPACT allows placing content protection elements at the MPD level and referenced at the AdaptationSet level
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.6.0](service/pinpointsmsvoicev2/CHANGELOG.md#v160-2023-11-16)
  * **Feature**: Amazon Pinpoint now offers additional operations as part of version 2 of the SMS and voice APIs. This release includes 26 new APIs to create and manage phone number registrations, add verified destination numbers, and request sender IDs.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.35.0](service/polly/CHANGELOG.md#v1350-2023-11-16)
  * **Feature**: Add new engine - long-form - dedicated for longer content, such as news articles, training materials, or marketing videos.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.51.0](service/quicksight/CHANGELOG.md#v1510-2023-11-16)
  * **Feature**: Custom permission support for QuickSight roles; Three new datasources STARBURST, TRINO, BIGQUERY; Lenient mode changes the default behavior to allow for exporting and importing with certain UI allowed errors, Support for permissions and tags export and import.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.117.0](service/sagemaker/CHANGELOG.md#v11170-2023-11-16)
  * **Feature**: Amazon SageMaker Studio now supports Trainium instance types - trn1.2xlarge, trn1.32xlarge, trn1n.32xlarge.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.43.0](service/ssm/CHANGELOG.md#v1430-2023-11-16)
  * **Feature**: This release introduces the ability to filter automation execution steps which have parent steps. In addition, runbook variable information is returned by GetAutomationExecution and parent step information is returned by the DescribeAutomationStepExecutions API.
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.26.0](service/ssmincidents/CHANGELOG.md#v1260-2023-11-16)
  * **Feature**: Introduces new APIs ListIncidentFindings and BatchGetIncidentFindings to use findings related to an incident.
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.21.0](service/ssoadmin/CHANGELOG.md#v1210-2023-11-16)
  * **Feature**: Instances bound to a single AWS account, API operations for managing instances and applications, and assignments to applications are now supported. Trusted identity propagation is also supported, with new API operations for managing trusted token issuers and application grants and scopes.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.38.0](service/transfer/CHANGELOG.md#v1380-2023-11-16)
  * **Feature**: Introduced S3StorageOptions for servers to enable directory listing optimizations and added Type fields to logical directory mappings.

# Release (2023-11-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.23.0
  * **Feature**: **BREAKING CHANGE**: DisableHTTPS middleware has changed steps from Serialize to Finalize. Middleware that indexes off of this field will need to be updated accordingly.
  * **Feature**: **BREAKING CHANGE**: Request body checksum middlewares (flex checksums, SHA256, etc.) have changed steps from Build to Finalize. Middleware that indexes off of this field will need to be updated accordingly.
  * **Feature**: **BREAKING CHANGE**: V2 endpoint resolution middleware has changed steps from Serialize to Finalize. Middleware that indexes off of this field will need to be updated accordingly.
  * **Feature**: Add client config helpers for overriding SigV4 signing name and region.
  * **Feature**: Refactored endpoint resolution middleware into a single implementation per-service, reducing generated code footprint.
  * **Feature**: Support smithy-modeled identity and auth resolution. Service clients can now be configured to override or use additional authentication schemes.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.35.0](service/autoscaling/CHANGELOG.md#v1350-2023-11-15)
  * **Feature**: This release introduces Instance Maintenance Policy, a new EC2 Auto Scaling capability that allows customers to define whether instances are launched before or after existing instances are terminated during instance replacement operations.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.33.0](service/cloudtrail/CHANGELOG.md#v1330-2023-11-15)
  * **Feature**: The Lake Repricing feature lets customers configure a BillingMode for an event data store. The BillingMode determines the cost for ingesting and storing events and the default and maximum retention period for the event data store.
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.8.0](service/codecatalyst/CHANGELOG.md#v180-2023-11-15)
  * **Feature**: This release adds functionality for retrieving information about workflows and workflow runs and starting workflow runs in Amazon CodeCatalyst.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.134.0](service/ec2/CHANGELOG.md#v11340-2023-11-15)
  * **Feature**: AWS EBS now supports Snapshot Lock, giving users the ability to lock an EBS Snapshot to prohibit deletion of the snapshot. This release introduces the LockSnapshot, UnlockSnapshot & DescribeLockedSnapshots APIs to manage lock configuration for snapshots. The release also includes the dl2q_24xlarge.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.17.0](service/finspace/CHANGELOG.md#v1170-2023-11-15)
  * **Feature**: Adding deprecated trait on Dataset Browser Environment APIs
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.21.0](service/finspacedata/CHANGELOG.md#v1210-2023-11-15)
  * **Feature**: Adding deprecated trait to APIs in this name space.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.47.0](service/lambda/CHANGELOG.md#v1470-2023-11-15)
  * **Feature**: Add Java 21 (java21) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.21.0](service/mwaa/CHANGELOG.md#v1210-2023-11-15)
  * **Feature**: This Amazon MWAA release adds support for customer-managed VPC endpoints. This lets you choose whether to create, and manage your environment's VPC endpoints, or to have Amazon MWAA create, and manage them for you.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.62.4](service/rds/CHANGELOG.md#v1624-2023-11-15)
  * **Documentation**: Updates Amazon RDS documentation for support for upgrading RDS for MySQL snapshots from version 5.7 to version 8.0.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.36.0](service/redshift/CHANGELOG.md#v1360-2023-11-15)
  * **Feature**: The custom domain name SDK for Amazon Redshift provisioned clusters is updated with additional required parameters for modify and delete operations. Additionally, users can provide domain names with longer top-level domains.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.37.0](service/s3control/CHANGELOG.md#v1370-2023-11-15)
  * **Feature**: Add 5 APIs to create, update, get, list, delete S3 Storage Lens group(eg. CreateStorageLensGroup), 3 APIs for tagging(TagResource,UntagResource,ListTagsForResource), and update to StorageLensConfiguration to allow metrics to be aggregated on Storage Lens groups.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.9.0](service/ssmsap/CHANGELOG.md#v190-2023-11-15)
  * **Feature**: Update the default value of MaxResult to 50.

# Release (2023-11-14)

## General Highlights
* **Feature**: Add support for dynamic auth token from file and EKS container host in absolute/relative URIs in the HTTP credential provider.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.28.0](service/backup/CHANGELOG.md#v1280-2023-11-14)
  * **Feature**: AWS Backup - Features: Provide Job Summary for your backup activity.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.7.0](service/cleanrooms/CHANGELOG.md#v170-2023-11-14)
  * **Feature**: This feature provides the ability for the collaboration creator to configure either the member who can run queries or a different member in the collaboration to be billed for query compute costs.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.80.0](service/connect/CHANGELOG.md#v1800-2023-11-14)
  * **Feature**: Introducing SegmentAttributes parameter for StartChatContact API
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.68.0](service/glue/CHANGELOG.md#v1680-2023-11-14)
  * **Feature**: Introduces new storage optimization APIs to support automatic compaction of Apache Iceberg tables.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.44.0](service/iot/CHANGELOG.md#v1440-2023-11-14)
  * **Feature**: This release introduces new attributes in API CreateSecurityProfile, UpdateSecurityProfile and DescribeSecurityProfile to support management of Metrics Export for AWS IoT Device Defender Detect.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.46.0](service/lambda/CHANGELOG.md#v1460-2023-11-14)
  * **Feature**: Add Python 3.12 (python3.12) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.31.0](service/mediatailor/CHANGELOG.md#v1310-2023-11-14)
  * **Feature**: Removed unnecessary default values.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.7.0](service/pipes/CHANGELOG.md#v170-2023-11-14)
  * **Feature**: Added support (via new LogConfiguration field in CreatePipe and UpdatePipe APIs) for logging to Amazon CloudWatch Logs, Amazon Simple Storage Service (Amazon S3), and Amazon Kinesis Data Firehose
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.7.0](service/resourceexplorer2/CHANGELOG.md#v170-2023-11-14)
  * **Feature**: Resource Explorer supports multi-account search. You can now use Resource Explorer to search and discover resources across AWS accounts within your organization or organizational unit.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.116.0](service/sagemaker/CHANGELOG.md#v11160-2023-11-14)
  * **Feature**: This release makes Model Registry Inference Specification fields as not required.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.22.0](service/sfn/CHANGELOG.md#v1220-2023-11-14)
  * **Feature**: This release adds support to redrive executions in AWS Step Functions with a new RedriveExecution operation.
* `github.com/aws/aws-sdk-go-v2/service/signer`: [v1.18.2](service/signer/CHANGELOG.md#v1182-2023-11-14)
  * **Documentation**: Documentation updates for AWS Signer

# Release (2023-11-13)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.24.0](config/CHANGELOG.md#v1240-2023-11-13)
  * **Feature**: Replace the legacy config parser with a modern, less-strict implementation. Parsing failures within a section will now simply ignore the invalid line rather than silently drop the entire section.
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.7.0](internal/ini/CHANGELOG.md#v170-2023-11-13)
  * **Feature**: Replace the legacy config parser with a modern, less-strict implementation. Parsing failures within a section will now simply ignore the invalid line rather than silently drop the entire section.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.34.0](service/databasemigrationservice/CHANGELOG.md#v1340-2023-11-13)
  * **Feature**: Added new Db2 LUW Target endpoint with related endpoint settings. New executeTimeout endpoint setting for mysql endpoint. New ReplicationDeprovisionTime field for serverless describe-replications.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.25.0](service/dataexchange/CHANGELOG.md#v1250-2023-11-13)
  * **Feature**: Removed Required trait for DataSet.OriginDetails.ProductId.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.133.0](service/ec2/CHANGELOG.md#v11330-2023-11-13)
  * **Feature**: Adds the new EC2 DescribeInstanceTopology API, which you can use to retrieve the network topology of your running instances on select platform types to determine their relative proximity to each other.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.33.0](service/ecs/CHANGELOG.md#v1330-2023-11-13)
  * **Feature**: Adds a Client Token parameter to the ECS RunTask API. The Client Token parameter allows for idempotent RunTask requests.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.33.0](service/emr/CHANGELOG.md#v1330-2023-11-13)
  * **Feature**: Updated GetClusterSessionCredentials API  to allow Amazon SageMaker Studio to connect to EMR on EC2 clusters to support IdentityCenter/PEZ integration.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.23.0](service/servicecatalogappregistry/CHANGELOG.md#v1230-2023-11-13)
  * **Feature**: When the customer associates a resource collection to their application with this new feature, then a new application tag will be applied to all supported resources that are part of that collection. This allows customers to more easily find the application that is associated with those resources.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.14.0](service/transcribestreaming/CHANGELOG.md#v1140-2023-11-13)
  * **Feature**: This release enables customers to call the AWS Transcribe streaming service with the capability of identifying multiple languages in the stream.

# Release (2023-11-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.7.0](service/controltower/CHANGELOG.md#v170-2023-11-10)
  * **Feature**: AWS Control Tower supports tagging for enabled controls. This release introduces TagResource, UntagResource and ListTagsForResource APIs to manage tags in existing enabled controls. It updates EnabledControl API to tag resources at creation time.
* `github.com/aws/aws-sdk-go-v2/service/costandusagereportservice`: [v1.20.0](service/costandusagereportservice/CHANGELOG.md#v1200-2023-11-10)
  * **Feature**: This release adds support for tagging and customers can now tag report definitions. Additionally, ReportStatus is now added to report definition to show when the last delivered time stamp and if it succeeded or not.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.132.0](service/ec2/CHANGELOG.md#v11320-2023-11-10)
  * **Feature**: EC2 adds API updates to enable ENA Express at instance launch time.
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.28.2](service/fms/CHANGELOG.md#v1282-2023-11-10)
  * **Documentation**: Adds optimizeUnassociatedWebACL flag to ManagedServiceData, updates third-party firewall examples, and other minor documentation updates.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.17.0](service/marketplaceentitlementservice/CHANGELOG.md#v1170-2023-11-10)
  * **Feature**: Add paginators to GetEntitlements.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.47.0](service/mediaconvert/CHANGELOG.md#v1470-2023-11-10)
  * **Feature**: This release includes the ability to specify any input source as the primary input for corresponding follow modes, and allows users to specify fit and fill behaviors without resizing content.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.62.3](service/rds/CHANGELOG.md#v1623-2023-11-10)
  * **Documentation**: Updates Amazon RDS documentation for zero-ETL integrations.

# Release (2023-11-09.2)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.23.0](config/CHANGELOG.md#v1230-2023-11-092)
  * **Feature**: BREAKFIX: In order to support subproperty parsing, invalid property definitions must not be ignored
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.6.0](internal/ini/CHANGELOG.md#v160-2023-11-092)
  * **Feature**: BREAKFIX: In order to support subproperty parsing, invalid property definitions must not be ignored
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.39.0](service/cloudformation/CHANGELOG.md#v1390-2023-11-092)
  * **Feature**: Added new ConcurrencyMode feature for AWS CloudFormation StackSets for faster deployments to target accounts.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.32.0](service/cloudtrail/CHANGELOG.md#v1320-2023-11-092)
  * **Feature**: The Insights in Lake feature lets customers enable CloudTrail Insights on a source CloudTrail Lake event data store and create a destination event data store to collect Insights events based on unusual management event activity in the source event data store.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.27.0](service/cloudwatchlogs/CHANGELOG.md#v1270-2023-11-092)
  * **Feature**: Update to support new APIs for delivery of logs from AWS services.
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.28.0](service/comprehend/CHANGELOG.md#v1280-2023-11-092)
  * **Feature**: This release adds support for toxicity detection and prompt safety classification.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.79.0](service/connect/CHANGELOG.md#v1790-2023-11-092)
  * **Feature**: This release adds the ability to integrate customer lambda functions with Connect attachments for scanning and updates the ListIntegrationAssociations API to support filtering on IntegrationArn.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.131.0](service/ec2/CHANGELOG.md#v11310-2023-11-092)
  * **Feature**: AWS EBS now supports Block Public Access for EBS Snapshots. This release introduces the EnableSnapshotBlockPublicAccess, DisableSnapshotBlockPublicAccess and GetSnapshotBlockPublicAccessState APIs to manage account-level public access settings for EBS Snapshots in an AWS Region.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.33.0](service/eks/CHANGELOG.md#v1330-2023-11-092)
  * **Feature**: Adding EKS Anywhere subscription related operations.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.45.0](service/lambda/CHANGELOG.md#v1450-2023-11-092)
  * **Feature**: Add Custom runtime on Amazon Linux 2023 (provided.al2023) support to AWS Lambda.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.15.0](service/omics/CHANGELOG.md#v1150-2023-11-092)
  * **Feature**: Support UBAM filetype for Omics Storage and make referenceArn optional

# Release (2023-11-09)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.22.2
  * **Bug Fix**: added x-amz-expected-bucket-owner to the list of headers we should sign
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.28.0](service/sqs/CHANGELOG.md#v1280-2023-11-09)
  * **Feature**: This release enables customers to call SQS using AWS JSON-1.0 protocol and bug fix.

# Release (2023-11-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.78.0](service/connect/CHANGELOG.md#v1780-2023-11-08)
  * **Feature**: This release clarifies in our public documentation that InstanceId is a requirement for SearchUsers API requests.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.11.0](service/connectcases/CHANGELOG.md#v1110-2023-11-08)
  * **Feature**: This release adds the ability to add/view comment authors through CreateRelatedItem and SearchRelatedItems API. For more information see https://docs.aws.amazon.com/cases/latest/APIReference/Welcome.html
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.33.0](service/guardduty/CHANGELOG.md#v1330-2023-11-08)
  * **Feature**: Added API support for new GuardDuty EKS Audit Log finding types.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.44.0](service/lambda/CHANGELOG.md#v1440-2023-11-08)
  * **Feature**: Add Node 20 (nodejs20.x) support to AWS Lambda.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.36.0](service/lexmodelsv2/CHANGELOG.md#v1360-2023-11-08)
  * **Feature**: AWS Lex now supports selective log capture in conversation logs. When you enable this option within the conversation log settings, only the utterances that trigger intents and slots specified in session attributes will be logged.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.14.0](service/omics/CHANGELOG.md#v1140-2023-11-08)
  * **Feature**: Adding Run UUID and Run Output URI: GetRun and StartRun API response has two new fields "uuid" and "runOutputUri".
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.62.1](service/rds/CHANGELOG.md#v1621-2023-11-08)
  * **Documentation**: This Amazon RDS release adds support for patching the OS of an RDS Custom for Oracle DB instance. You can now upgrade the database or operating system using the modify-db-instance command.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.12.0](service/redshiftserverless/CHANGELOG.md#v1120-2023-11-08)
  * **Feature**: Added a new parameter in the workgroup that helps you control your cost for compute resources. This feature provides a ceiling for RPUs that Amazon Redshift Serverless can scale up to. When automatic compute scaling is required, having a higher value for MaxRPU can enhance query throughput.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.17.0](service/resiliencehub/CHANGELOG.md#v1170-2023-11-08)
  * **Feature**: AWS Resilience Hub enhances Resiliency Score, providing actionable recommendations to improve application resilience. Amazon Elastic Kubernetes Service (EKS) operational recommendations have been added to help improve the resilience posture of your applications.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.27.0](service/sqs/CHANGELOG.md#v1270-2023-11-08)
  * **Feature**: This release enables customers to call SQS using AWS JSON-1.0 protocol.

# Release (2023-11-07)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.5.1](internal/ini/CHANGELOG.md#v151-2023-11-07)
  * **Bug Fix**: Fix subproperty performance regression
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.20.0](service/dlm/CHANGELOG.md#v1200-2023-11-07)
  * **Feature**: Added support for pre and post scripts in Amazon Data Lifecycle Manager EBS snapshot lifecycle policies.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.62.0](service/rds/CHANGELOG.md#v1620-2023-11-07)
  * **Feature**: This Amazon RDS release adds support for the multi-tenant configuration. In this configuration, an RDS DB instance can contain multiple tenant databases. In RDS for Oracle, a tenant database is a pluggable database (PDB).

# Release (2023-11-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.25.0](service/codebuild/CHANGELOG.md#v1250-2023-11-06)
  * **Feature**: AWS CodeBuild now supports AWS Lambda compute.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.77.0](service/connect/CHANGELOG.md#v1770-2023-11-06)
  * **Feature**: Added new API that allows Amazon Connect Outbound Campaigns to create contacts in Amazon Connect when ingesting your dial requests.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.32.0](service/costexplorer/CHANGELOG.md#v1320-2023-11-06)
  * **Feature**: This release extends the GetReservationPurchaseRecommendation API to support recommendations for Amazon MemoryDB reservations.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.27.0](service/docdb/CHANGELOG.md#v1270-2023-11-06)
  * **Feature**: Update the input of CreateDBInstance and ModifyDBInstance to support setting CA Certificates. Update the output of DescribeDBInstance and DescribeDBEngineVersions to show current and supported CA certificates.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.27.0](service/iam/CHANGELOG.md#v1270-2023-11-06)
  * **Feature**: Add partitional endpoint for iso-e.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.20.0](service/mwaa/CHANGELOG.md#v1200-2023-11-06)
  * **Feature**: This release adds support for Apache Airflow version 2.7.2. This version release includes support for deferrable operators and triggers.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.34.0](service/polly/CHANGELOG.md#v1340-2023-11-06)
  * **Feature**: Amazon Polly adds new US English voices - Danielle and Gregory. Danielle and Gregory are available as Neural voices only.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.34.0](service/route53/CHANGELOG.md#v1340-2023-11-06)
  * **Feature**: Add partitional endpoints for iso-e and iso-f.

# Release (2023-11-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.41.0](service/configservice/CHANGELOG.md#v1410-2023-11-03)
  * **Feature**: Updated ResourceType enum with new resource types onboarded by AWS Config in October 2023.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.76.0](service/connect/CHANGELOG.md#v1760-2023-11-03)
  * **Feature**: Amazon Connect Chat introduces Create Persistent Contact Association API, allowing customers to choose when to resume previous conversations from previous chats, eliminating the need to repeat themselves and allowing agents to provide personalized service with access to entire conversation history.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.33.0](service/iotwireless/CHANGELOG.md#v1330-2023-11-03)
  * **Feature**: Added LoRaWAN version 1.0.4 support
* `github.com/aws/aws-sdk-go-v2/service/launchwizard`: [v1.0.0](service/launchwizard/CHANGELOG.md#v100-2023-11-03)
  * **Release**: New AWS service client module
  * **Feature**: AWS Launch Wizard is a service that helps reduce the time it takes to deploy applications to the cloud while providing a guided deployment experience.

# Release (2023-11-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.22.0](config/CHANGELOG.md#v1220-2023-11-02)
  * **Feature**: Add env and shared config settings for disabling IMDSv1 fallback.
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.24.0](service/apprunner/CHANGELOG.md#v1240-2023-11-02)
  * **Feature**: AWS App Runner now supports using dual-stack address type for the public endpoint of your incoming traffic.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.75.0](service/connect/CHANGELOG.md#v1750-2023-11-02)
  * **Feature**: GetMetricDataV2 API: Update to include new metrics PERCENT_NON_TALK_TIME, PERCENT_TALK_TIME, PERCENT_TALK_TIME_AGENT, PERCENT_TALK_TIME_CUSTOMER
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.26.0](service/gamelift/CHANGELOG.md#v1260-2023-11-02)
  * **Feature**: Amazon GameLift adds support for shared credentials, which allows applications that are deployed on managed EC2 fleets to interact with other AWS resources.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.67.0](service/glue/CHANGELOG.md#v1670-2023-11-02)
  * **Feature**: This release introduces Google BigQuery Source and Target in AWS Glue CodeGenConfigurationNode.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.35.0](service/networkfirewall/CHANGELOG.md#v1350-2023-11-02)
  * **Feature**: This release introduces the stateless rule analyzer, which enables you to analyze your stateless rules for asymmetric routing.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.50.0](service/quicksight/CHANGELOG.md#v1500-2023-11-02)
  * **Feature**: This release introduces Float Decimal Type as SubType in QuickSight SPICE datasets and Custom week start and Custom timezone options in Analysis and Dashboard

# Release (2023-11-01)

## General Highlights
* **Feature**: Adds support for configured endpoints via environment variables and the AWS shared configuration file.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.74.0](service/connect/CHANGELOG.md#v1740-2023-11-01)
  * **Feature**: Adds the BatchGetFlowAssociation API which returns flow associations (flow-resource) corresponding to the list of resourceArns supplied in the request. This release also adds IsDefault, LastModifiedRegion and LastModifiedTime fields to the responses of several Describe and List APIs.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.19.0](service/globalaccelerator/CHANGELOG.md#v1190-2023-11-01)
  * **Feature**: Global Accelerator now support accelerators with cross account endpoints.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.61.0](service/rds/CHANGELOG.md#v1610-2023-11-01)
  * **Feature**: This release adds support for customized networking resources to Amazon RDS Custom.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.35.0](service/redshift/CHANGELOG.md#v1350-2023-11-01)
  * **Feature**: Added support for Multi-AZ deployments for Provisioned RA3 clusters that provide 99.99% SLA availability.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.115.0](service/sagemaker/CHANGELOG.md#v11150-2023-11-01)
  * **Feature**: Support for batch transform input in Model dashboard

# Release (2023-10-31)

## General Highlights
* **Feature**: **BREAKING CHANGE**: Bump minimum go version to 1.19 per the revised [go version support policy](https://aws.amazon.com/blogs/developer/aws-sdk-for-go-aligns-with-go-release-policy-on-supported-runtimes/).
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.16.0](service/amplify/CHANGELOG.md#v1160-2023-10-31)
  * **Feature**: Add backend field to CreateBranch and UpdateBranch requests. Add pagination support for ListApps, ListDomainAssociations, ListBranches, and ListJobs
* `github.com/aws/aws-sdk-go-v2/service/applicationinsights`: [v1.20.0](service/applicationinsights/CHANGELOG.md#v1200-2023-10-31)
  * **Feature**: Automate attaching managed policies
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.129.0](service/ec2/CHANGELOG.md#v11290-2023-10-31)
  * **Feature**: Capacity Blocks for ML are a new EC2 purchasing option for reserving GPU instances on a future date to support short duration machine learning (ML) workloads. Capacity Blocks automatically place instances close together inside Amazon EC2 UltraClusters for low-latency, high-throughput networking.
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.8.0](service/m2/CHANGELOG.md#v180-2023-10-31)
  * **Feature**: Added name filter ability for ListDataSets API, added ForceUpdate for Updating environment and BatchJob submission using S3BatchJobIdentifier
* `github.com/aws/aws-sdk-go-v2/service/neptunedata`: [v1.1.0](service/neptunedata/CHANGELOG.md#v110-2023-10-31)
  * **Feature**: Minor change to not retry CancelledByUserException
* `github.com/aws/aws-sdk-go-v2/service/translate`: [v1.20.0](service/translate/CHANGELOG.md#v1200-2023-10-31)
  * **Feature**: Added support for Brevity translation settings feature.

# Release (2023-10-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.72.0](service/connect/CHANGELOG.md#v1720-2023-10-30)
  * **Feature**: This release adds InstanceId field for phone number APIs.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.22.0](service/dataexchange/CHANGELOG.md#v1220-2023-10-30)
  * **Feature**: We added a new API action: SendDataSetNotification.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.30.0](service/datasync/CHANGELOG.md#v1300-2023-10-30)
  * **Feature**: Platform version changes to support AL1 deprecation initiative.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.14.0](service/finspace/CHANGELOG.md#v1140-2023-10-30)
  * **Feature**: Introducing new API UpdateKxClusterCodeConfiguration, introducing new cache types for clusters and introducing new deployment modes for updating clusters.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.4.0](service/mediapackagev2/CHANGELOG.md#v140-2023-10-30)
  * **Feature**: This feature allows customers to create a combination of manifest filtering, startover and time delay configuration that applies to all egress requests by default.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.59.0](service/rds/CHANGELOG.md#v1590-2023-10-30)
  * **Feature**: This release launches the CreateIntegration, DeleteIntegration, and DescribeIntegrations APIs to manage zero-ETL Integrations.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.9.0](service/redshiftserverless/CHANGELOG.md#v190-2023-10-30)
  * **Feature**: Added support for custom domain names for Amazon Redshift Serverless workgroups. This feature enables customers to create a custom domain name and use ACM to generate fully secure connections to it.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.14.0](service/resiliencehub/CHANGELOG.md#v1140-2023-10-30)
  * **Feature**: Introduced the ability to filter applications by their last assessment date and time and have included metrics for the application's estimated workload Recovery Time Objective (RTO) and estimated workload Recovery Point Objective (RPO).
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.19.0](service/s3outposts/CHANGELOG.md#v1190-2023-10-30)
  * **Feature**: Updated ListOutpostsWithS3 API response to include S3OutpostArn for use with AWS RAM.
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.16.1](service/wisdom/CHANGELOG.md#v1161-2023-10-30)
  * **Documentation**: This release added necessary API documents on creating a Wisdom knowledge base to integrate with S3.

# Release (2023-10-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.30.0](service/emr/CHANGELOG.md#v1300-2023-10-27)
  * **Feature**: Updated CreateCluster API request and DescribeCluster API responses to include EbsRootVolumeIops, and EbsRootVolumeThroughput attributes that specify the user configured root volume IOPS and throughput for Amazon EBS root device volume. This feature will be available from Amazon EMR releases 6.15.0
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.24.0](service/neptune/CHANGELOG.md#v1240-2023-10-27)
  * **Feature**: Update TdeCredentialPassword type to SensitiveString
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.23.1](service/pinpoint/CHANGELOG.md#v1231-2023-10-27)
  * **Documentation**: Updated documentation to describe the case insensitivity for EndpointIds.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.33.0](service/redshift/CHANGELOG.md#v1330-2023-10-27)
  * **Feature**: added support to create a dual stack cluster
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.40.1](service/wafv2/CHANGELOG.md#v1401-2023-10-27)
  * **Documentation**: Updates the descriptions for the calls that manage web ACL associations, to provide information for customer-managed IAM policies.

# Release (2023-10-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.26.0](service/appstream/CHANGELOG.md#v1260-2023-10-26)
  * **Feature**: This release introduces multi-session fleets, allowing customers to provision more than one user session on a single fleet instance.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.128.0](service/ec2/CHANGELOG.md#v11280-2023-10-26)
  * **Feature**: Launching GetSecurityGroupsForVpc API. This API gets security groups that can be associated by the AWS account making the request with network interfaces in the specified VPC.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.32.0](service/networkfirewall/CHANGELOG.md#v1320-2023-10-26)
  * **Feature**: Network Firewall now supports inspection of outbound SSL/TLS traffic.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.23.0](service/opensearch/CHANGELOG.md#v1230-2023-10-26)
  * **Feature**: You can specify ipv4 or dualstack IPAddressType for cluster endpoints. If you specify IPAddressType as dualstack, the new endpoint will be visible under the 'EndpointV2' parameter and will support IPv4 and IPv6 requests. Whereas, the 'Endpoint' will continue to serve IPv4 requests.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.32.0](service/redshift/CHANGELOG.md#v1320-2023-10-26)
  * **Feature**: Add Redshift APIs GetResourcePolicy, DeleteResourcePolicy, PutResourcePolicy and DescribeInboundIntegrations for the new Amazon Redshift Zero-ETL integration feature, which can be used to control data ingress into Redshift namespace, and view inbound integrations.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.113.0](service/sagemaker/CHANGELOG.md#v11130-2023-10-26)
  * **Feature**: Amazon Sagemaker Autopilot now supports Text Generation jobs.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.23.0](service/sns/CHANGELOG.md#v1230-2023-10-26)
  * **Feature**: Message Archiving and Replay is now supported in Amazon SNS for FIFO topics.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.6.0](service/ssmsap/CHANGELOG.md#v160-2023-10-26)
  * **Feature**: AWS Systems Manager for SAP added support for registration and discovery of SAP ABAP applications
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.35.0](service/transfer/CHANGELOG.md#v1350-2023-10-26)
  * **Feature**: No API changes from previous release. This release migrated the model to Smithy keeping all features unchanged.

# Release (2023-10-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.8.0](service/connectcases/CHANGELOG.md#v180-2023-10-25)
  * **Feature**: Increase maximum length of CommentBody to 3000, and increase maximum length of StringValue to 1500
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.20.0](service/groundstation/CHANGELOG.md#v1200-2023-10-25)
  * **Feature**: This release will allow KMS alias names to be used when creating Mission Profiles
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.24.0](service/iam/CHANGELOG.md#v1240-2023-10-25)
  * **Feature**: Updates to GetAccessKeyLastUsed action to replace NoSuchEntity error with AccessDeniedException error.

# Release (2023-10-24)

## General Highlights
* **Feature**: **BREAKFIX**: Correct nullability and default value representation of various input fields across a large number of services. Calling code that references one or more of the affected fields will need to update usage accordingly. See [2162](https://github.com/aws/aws-sdk-go-v2/issues/2162).
* **Feature**: **BREAKFIX**: Correct nullability representation of APIGateway-based services.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.18.0](service/codepipeline/CHANGELOG.md#v1180-2023-10-24)
  * **Feature**: Add ability to trigger pipelines from git tags, define variables at pipeline level and new pipeline type V2.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.127.0](service/ec2/CHANGELOG.md#v11270-2023-10-24)
  * **Feature**: This release updates the documentation for InstanceInterruptionBehavior and HibernationOptionsRequest to more accurately describe the behavior of these two parameters when using Spot hibernation.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.30.0](service/eks/CHANGELOG.md#v1300-2023-10-24)
  * **Feature**: Added support for Cluster Subnet and Security Group mutability.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.23.0](service/iam/CHANGELOG.md#v1230-2023-10-24)
  * **Feature**: Add the partitional endpoint for IAM in iso-f.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubconfig`: [v1.16.0](service/migrationhubconfig/CHANGELOG.md#v1160-2023-10-24)
  * **Feature**: This release introduces DeleteHomeRegionControl API that customers can use to delete the Migration Hub Home Region configuration
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.12.0](service/migrationhubstrategy/CHANGELOG.md#v1120-2023-10-24)
  * **Feature**: This release introduces multi-data-source feature in Migration Hub Strategy Recommendations. This feature now supports vCenter as a data source to fetch inventory in addition to ADS and Import from file workflow that is currently supported with MHSR collector.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.6.0](service/opensearchserverless/CHANGELOG.md#v160-2023-10-24)
  * **Feature**: This release includes the following new APIs: CreateLifecyclePolicy, UpdateLifecyclePolicy, BatchGetLifecyclePolicy, DeleteLifecyclePolicy, ListLifecyclePolicies and BatchGetEffectiveLifecyclePolicy to support the data lifecycle management feature.

# Release (2023-10-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/marketplacecommerceanalytics`: [v1.15.0](service/marketplacecommerceanalytics/CHANGELOG.md#v1150-2023-10-23)
  * **Feature**: The StartSupportDataExport operation has been deprecated as part of the Product Support Connection deprecation. As of December 2022, Product Support Connection is no longer supported.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.20.0](service/networkmanager/CHANGELOG.md#v1200-2023-10-23)
  * **Feature**: This release adds API support for Tunnel-less Connect (NoEncap Protocol) for AWS Cloud WAN
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.8.0](service/redshiftserverless/CHANGELOG.md#v180-2023-10-23)
  * **Feature**: This release adds support for customers to see the patch version and workgroup version in Amazon Redshift Serverless.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.32.0](service/rekognition/CHANGELOG.md#v1320-2023-10-23)
  * **Feature**: Amazon Rekognition introduces StartMediaAnalysisJob, GetMediaAnalysisJob, and ListMediaAnalysisJobs operations to run a bulk analysis of images with a Detect Moderation model.

# Release (2023-10-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.22.0](service/appconfig/CHANGELOG.md#v1220-2023-10-20)
  * **Feature**: Update KmsKeyIdentifier constraints to support AWS KMS multi-Region keys.
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.19.0](service/appintegrations/CHANGELOG.md#v1190-2023-10-20)
  * **Feature**: Updated ScheduleConfig to be an optional input to CreateDataIntegration to support event driven downloading of files from sources such as Amazon s3 using Amazon Connect AppIntegrations.
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.19.0](service/applicationdiscoveryservice/CHANGELOG.md#v1190-2023-10-20)
  * **Feature**: This release introduces three new APIs: StartBatchDeleteConfigurationTask, DescribeBatchDeleteConfigurationTask, and BatchDeleteAgents.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.70.0](service/connect/CHANGELOG.md#v1700-2023-10-20)
  * **Feature**: This release adds support for updating phone number metadata, such as phone number description.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.2.3](service/medicalimaging/CHANGELOG.md#v123-2023-10-20)
  * **Documentation**: Updates on documentation links
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.39.0](service/ssm/CHANGELOG.md#v1390-2023-10-20)
  * **Feature**: This release introduces a new API: DeleteOpsItem. This allows deletion of an OpsItem.

# Release (2023-10-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.126.0](service/ec2/CHANGELOG.md#v11260-2023-10-19)
  * **Feature**: Amazon EC2 C7a instances, powered by 4th generation AMD EPYC processors, are ideal for high performance, compute-intensive workloads such as high performance computing. Amazon EC2 R7i instances are next-generation memory optimized and powered by custom 4th Generation Intel Xeon Scalable processors.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.3.0](service/managedblockchainquery/CHANGELOG.md#v130-2023-10-19)
  * **Feature**: This release adds support for Ethereum Sepolia network
* `github.com/aws/aws-sdk-go-v2/service/neptunedata`: [v1.0.4](service/neptunedata/CHANGELOG.md#v104-2023-10-19)
  * **Documentation**: Doc changes to add IAM action mappings for the data actions.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.11.0](service/omics/CHANGELOG.md#v1110-2023-10-19)
  * **Feature**: This change enables customers to retrieve failure reasons with detailed status messages for their failed runs
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.21.0](service/opensearch/CHANGELOG.md#v1210-2023-10-19)
  * **Feature**: Added Cluster Administrative options for node restart, opensearch process restart and opensearch dashboard restart for Multi-AZ without standby domains
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.46.0](service/quicksight/CHANGELOG.md#v1460-2023-10-19)
  * **Feature**: This release adds the following: 1) Trino and Starburst Database Connectors 2) Custom total for tables and pivot tables 3) Enable restricted folders 4) Add rolling dates for time equality filters 5) Refine DataPathValue and introduce DataPathType 6) Add SeriesType to ReferenceLineDataConfiguration
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.21.6](service/secretsmanager/CHANGELOG.md#v1216-2023-10-19)
  * **Documentation**: Documentation updates for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.22.0](service/servicecatalog/CHANGELOG.md#v1220-2023-10-19)
  * **Feature**: Introduce support for EXTERNAL product and provisioning artifact type in CreateProduct and CreateProvisioningArtifact APIs.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.3.0](service/verifiedpermissions/CHANGELOG.md#v130-2023-10-19)
  * **Feature**: Improving Amazon Verified Permissions Create experience
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.31.3](service/workspaces/CHANGELOG.md#v1313-2023-10-19)
  * **Documentation**: Documentation updates for WorkSpaces

# Release (2023-10-18)

## General Highlights
* **Feature**: Add handwritten paginators that were present in some services in the v1 SDK.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.18.11](service/cloud9/CHANGELOG.md#v11811-2023-10-18)
  * **Documentation**: Update to imageId parameter behavior and dates updated.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.23.0](service/dynamodb/CHANGELOG.md#v1230-2023-10-18)
  * **Documentation**: Updating descriptions for several APIs.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.44.0](service/kendra/CHANGELOG.md#v1440-2023-10-18)
  * **Feature**: Changes for a new feature in Amazon Kendra's Query API to Collapse/Expand query results
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.57.0](service/rds/CHANGELOG.md#v1570-2023-10-18)
  * **Feature**: This release adds support for upgrading the storage file system configuration on the DB instance using a blue/green deployment or a read replica.
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.16.0](service/wisdom/CHANGELOG.md#v1160-2023-10-18)
  * **Feature**: This release adds an max limit of 25 recommendation ids for NotifyRecommendationsReceived API.

# Release (2023-10-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.18.0](service/applicationdiscoveryservice/CHANGELOG.md#v1180-2023-10-17)
  * **Feature**: This release introduces three new APIs: StartBatchDeleteConfigurationTask, DescribeBatchDeleteConfigurationTask, and BatchDeleteAgents.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.17.0](service/codepipeline/CHANGELOG.md#v1170-2023-10-17)
  * **Feature**: Add retryMode ALL_ACTIONS to RetryStageExecution API that retries a failed stage starting from first action in the stage
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.30.4](service/ecs/CHANGELOG.md#v1304-2023-10-17)
  * **Documentation**: Documentation only updates to address Amazon ECS tickets.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.29.0](service/guardduty/CHANGELOG.md#v1290-2023-10-17)
  * **Feature**: Add domainWithSuffix finding field to dnsRequestAction
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.23.0](service/kafka/CHANGELOG.md#v1230-2023-10-17)
  * **Feature**: AWS Managed Streaming for Kafka is launching MSK Replicator, a new feature that enables customers to reliably replicate data across Amazon MSK clusters in same or different AWS regions. You can now use SDK to create, list, describe, delete, update, and manage tags of MSK Replicators.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycluster`: [v1.14.0](service/route53recoverycluster/CHANGELOG.md#v1140-2023-10-17)
  * **Feature**: Adds Owner field to ListRoutingControls API.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.14.0](service/route53recoverycontrolconfig/CHANGELOG.md#v1140-2023-10-17)
  * **Feature**: Adds permissions for GetResourcePolicy to support returning details about AWS Resource Access Manager resource policies for shared resources.

# Release (2023-10-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.19.0](config/CHANGELOG.md#v1190-2023-10-16)
  * **Feature**: Modify logic of retrieving user agent appID from env config
* `github.com/aws/aws-sdk-go-v2/feature/cloudfront/sign`: [v1.4.0](feature/cloudfront/sign/CHANGELOG.md#v140-2023-10-16)
  * **Feature**: Add support for loading PKCS8-formatted private keys.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.35.0](service/cloudformation/CHANGELOG.md#v1350-2023-10-16)
  * **Feature**: SDK and documentation updates for UpdateReplacePolicy
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.17.0](service/drs/CHANGELOG.md#v1170-2023-10-16)
  * **Feature**: Updated exsiting API to allow AWS Elastic Disaster Recovery support of launching recovery into existing EC2 instances.
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.3.0](service/entityresolution/CHANGELOG.md#v130-2023-10-16)
  * **Feature**: This launch expands our matching techniques to include provider-based matching to help customer match, link, and enhance records with minimal data movement. With data service providers, we have removed the need for customers to build bespoke integrations,.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.2.0](service/managedblockchainquery/CHANGELOG.md#v120-2023-10-16)
  * **Feature**: This release introduces two new APIs: GetAssetContract and ListAssetContracts. This release also adds support for Bitcoin Testnet.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.3.0](service/mediapackagev2/CHANGELOG.md#v130-2023-10-16)
  * **Feature**: This release allows customers to manage MediaPackage v2 resource using CloudFormation.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.20.0](service/opensearch/CHANGELOG.md#v1200-2023-10-16)
  * **Feature**: This release allows customers to list and associate optional plugin packages with compatible Amazon OpenSearch Service clusters for enhanced functionality.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.30.0](service/redshift/CHANGELOG.md#v1300-2023-10-16)
  * **Feature**: Added support for managing credentials of provisioned cluster admin using AWS Secrets Manager.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.7.0](service/redshiftserverless/CHANGELOG.md#v170-2023-10-16)
  * **Feature**: Added support for managing credentials of serverless namespace admin using AWS Secrets Manager.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.21.0](service/sesv2/CHANGELOG.md#v1210-2023-10-16)
  * **Feature**: This release provides enhanced visibility into your SES identity verification status. This will offer you more actionable insights, enabling you to promptly address any verification-related issues.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.34.2](service/transfer/CHANGELOG.md#v1342-2023-10-16)
  * **Documentation**: Documentation updates for AWS Transfer Family
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.19.0](service/xray/CHANGELOG.md#v1190-2023-10-16)
  * **Feature**: This releases enhances GetTraceSummaries API to support new TimeRangeType Service to query trace summaries by segment end time.

# Release (2023-10-12)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.21.2
  * **Bug Fix**: Improve recognition of retryable DNS errors.
* `github.com/aws/aws-sdk-go-v2/config`: [v1.18.45](config/CHANGELOG.md#v11845-2023-10-12)
  * **Bug Fix**: Fail to load config if an explicitly provided profile doesn't exist.
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.27.0](service/auditmanager/CHANGELOG.md#v1270-2023-10-12)
  * **Feature**: This release introduces a new limit to the awsAccounts parameter. When you create or update an assessment, there is now a limit of 200 AWS accounts that can be specified in the assessment scope.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.31.0](service/autoscaling/CHANGELOG.md#v1310-2023-10-12)
  * **Feature**: Update the NotificationMetadata field to only allow visible ascii characters. Add paginators to DescribeInstanceRefreshes, DescribeLoadBalancers, and DescribeLoadBalancerTargetGroups
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.37.0](service/configservice/CHANGELOG.md#v1370-2023-10-12)
  * **Feature**: Add enums for resource types supported by Config
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.4.0](service/controltower/CHANGELOG.md#v140-2023-10-12)
  * **Feature**: Added new EnabledControl resource details to ListEnabledControls API and added new GetEnabledControl API.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.29.0](service/customerprofiles/CHANGELOG.md#v1290-2023-10-12)
  * **Feature**: Adds sensitive trait to various shapes in Customer Profiles Calculated Attribute API model.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.125.0](service/ec2/CHANGELOG.md#v11250-2023-10-12)
  * **Feature**: This release adds Ubuntu Pro as a supported platform for On-Demand Capacity Reservations and adds support for setting an Amazon Machine Image (AMI) to disabled state. Disabling the AMI makes it private if it was previously shared, and prevents new EC2 instance launches from it.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.21.6](service/elasticloadbalancingv2/CHANGELOG.md#v1216-2023-10-12)
  * **Documentation**: This release enables routing policies with Availability Zone affinity for Network Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.63.0](service/glue/CHANGELOG.md#v1630-2023-10-12)
  * **Feature**: Extending version control support to GitLab and Bitbucket from AWSGlue
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.17.0](service/inspector2/CHANGELOG.md#v1170-2023-10-12)
  * **Feature**: Add MacOs ec2 platform support
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.5.0](service/ivsrealtime/CHANGELOG.md#v150-2023-10-12)
  * **Feature**: Update GetParticipant to return additional metadata.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.40.0](service/lambda/CHANGELOG.md#v1400-2023-10-12)
  * **Feature**: Adds support for Lambda functions to access Dual-Stack subnets over IPv6, via an opt-in flag in CreateFunction and UpdateFunctionConfiguration APIs
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.28.0](service/location/CHANGELOG.md#v1280-2023-10-12)
  * **Feature**: This release adds endpoint updates for all AWS Location resource operations.
* `github.com/aws/aws-sdk-go-v2/service/machinelearning`: [v1.18.0](service/machinelearning/CHANGELOG.md#v1180-2023-10-12)
  * **Feature**: This release marks Password field as sensitive
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.21.9](service/pricing/CHANGELOG.md#v1219-2023-10-12)
  * **Documentation**: Documentation updates for Price List
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.56.0](service/rds/CHANGELOG.md#v1560-2023-10-12)
  * **Feature**: This release adds support for adding a dedicated log volume to open-source RDS instances.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.31.0](service/rekognition/CHANGELOG.md#v1310-2023-10-12)
  * **Feature**: Amazon Rekognition introduces support for Custom Moderation. This allows the enhancement of accuracy for detect moderation labels operations by creating custom adapters tuned on customer data.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.111.0](service/sagemaker/CHANGELOG.md#v11110-2023-10-12)
  * **Feature**: Amazon SageMaker Canvas adds KendraSettings and DirectDeploySettings support for CanvasAppSettings
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.25.0](service/textract/CHANGELOG.md#v1250-2023-10-12)
  * **Feature**: This release adds 9 new APIs for adapter and adapter version management, 3 new APIs for tagging, and updates AnalyzeDocument and StartDocumentAnalysis API parameters for using adapters.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.29.0](service/transcribe/CHANGELOG.md#v1290-2023-10-12)
  * **Feature**: This release is to enable m4a format to customers
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.31.2](service/workspaces/CHANGELOG.md#v1312-2023-10-12)
  * **Documentation**: Updated the CreateWorkspaces action documentation to clarify that the PCoIP protocol is only available for Windows bundles.

# Release (2023-10-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.124.0](service/ec2/CHANGELOG.md#v11240-2023-10-06)
  * **Feature**: Documentation updates for Elastic Compute Cloud (EC2).
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.33.0](service/fsx/CHANGELOG.md#v1330-2023-10-06)
  * **Feature**: After performing steps to repair the Active Directory configuration of a file system, use this action to initiate the process of attempting to recover to the file system.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.18.0](service/marketplacecatalog/CHANGELOG.md#v1180-2023-10-06)
  * **Feature**: This release adds support for Document type as an alternative for stringified JSON for StartChangeSet, DescribeChangeSet and DescribeEntity APIs
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.45.0](service/quicksight/CHANGELOG.md#v1450-2023-10-06)
  * **Feature**: NullOption in FilterListConfiguration; Dataset schema/table max length increased; Support total placement for pivot table visual; Lenient mode relaxes the validation to create resources with definition; Data sources can be added to folders; Redshift data sources support IAM Role-based authentication
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.34.0](service/transfer/CHANGELOG.md#v1340-2023-10-06)
  * **Feature**: This release updates the max character limit of PreAuthenticationLoginBanner and PostAuthenticationLoginBanner to 4096 characters

# Release (2023-10-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.10.0](service/omics/CHANGELOG.md#v1100-2023-10-05)
  * **Feature**: Add Etag Support for Omics Storage in ListReadSets and GetReadSetMetadata API
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.55.1](service/rds/CHANGELOG.md#v1551-2023-10-05)
  * **Documentation**: Updates Amazon RDS documentation for corrections and minor improvements.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.30.0](service/route53/CHANGELOG.md#v1300-2023-10-05)
  * **Feature**: Add hostedzonetype filter to ListHostedZones API.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.37.0](service/securityhub/CHANGELOG.md#v1370-2023-10-05)
  * **Feature**: Added new resource detail objects to ASFF, including resources for AwsEventsEventbus, AwsEventsEndpoint, AwsDmsEndpoint, AwsDmsReplicationTask, AwsDmsReplicationInstance, AwsRoute53HostedZone, and AwsMskCluster
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.21.0](service/storagegateway/CHANGELOG.md#v1210-2023-10-05)
  * **Feature**: Add SoftwareVersion to response of DescribeGatewayInformation.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.31.0](service/workspaces/CHANGELOG.md#v1310-2023-10-05)
  * **Feature**: This release introduces Manage applications. This feature allows users to manage their WorkSpaces applications by associating or disassociating their WorkSpaces with applications. The DescribeWorkspaces API will now additionally return OperatingSystemName in its responses.

# Release (2023-10-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.21.0](service/appconfig/CHANGELOG.md#v1210-2023-10-04)
  * **Feature**: AWS AppConfig introduces KMS customer-managed key (CMK) encryption support for data saved to AppConfig's hosted configuration store.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.0.0](service/datazone/CHANGELOG.md#v100-2023-10-04)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of Amazon DataZone
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.28.0](service/mediatailor/CHANGELOG.md#v1280-2023-10-04)
  * **Feature**: Updates DescribeVodSource to include a list of ad break opportunities in the response
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.21.0](service/mgn/CHANGELOG.md#v1210-2023-10-04)
  * **Feature**: This release includes the following new APIs: ListConnectors, CreateConnector,  UpdateConnector, DeleteConnector and UpdateSourceServer to support the source action framework feature.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.110.0](service/sagemaker/CHANGELOG.md#v11100-2023-10-04)
  * **Feature**: Adding support for AdditionalS3DataSource, a data source used for training or inference that is in addition to the input dataset or model data.

# Release (2023-10-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.69.0](service/connect/CHANGELOG.md#v1690-2023-10-03)
  * **Feature**: GetMetricDataV2 API: Update to include new metrics CONTACTS_RESOLVED_IN_X , AVG_HOLD_TIME_ALL_CONTACTS , AVG_RESOLUTION_TIME , ABANDONMENT_RATE , AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS with added features: Interval Period, TimeZone, Negate MetricFilters, Extended date time range.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.27.0](service/location/CHANGELOG.md#v1270-2023-10-03)
  * **Feature**: Amazon Location Service adds support for bounding polygon queries. Additionally, the GeofenceCount field has been added to the DescribeGeofenceCollection API response.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.43.0](service/mediaconvert/CHANGELOG.md#v1430-2023-10-03)
  * **Feature**: This release adds the ability to replace video frames without modifying the audio essence.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.4.0](service/oam/CHANGELOG.md#v140-2023-10-03)
  * **Feature**: This release adds support for sharing AWS::ApplicationInsights::Application resources.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.109.0](service/sagemaker/CHANGELOG.md#v11090-2023-10-03)
  * **Feature**: This release allows users to run Selective Execution in SageMaker Pipelines without SourcePipelineExecutionArn if selected steps do not have any dependent steps.
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.23.0](service/wellarchitected/CHANGELOG.md#v1230-2023-10-03)
  * **Feature**: AWS Well-Architected now supports Review Templates that allows you to create templates with pre-filled answers for Well-Architected and Custom Lens best practices.

# Release (2023-10-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.1.0](service/bedrock/CHANGELOG.md#v110-2023-10-02)
  * **Feature**: Provisioned throughput feature with Amazon and third-party base models, and update validators for model identifier and taggable resource ARNs.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.1.0](service/bedrockruntime/CHANGELOG.md#v110-2023-10-02)
  * **Feature**: Add model timeout exception for InvokeModelWithResponseStream API and update validator for invoke model identifier.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.123.0](service/ec2/CHANGELOG.md#v11230-2023-10-02)
  * **Feature**: Introducing Amazon EC2 R7iz instances with 3.9 GHz sustained all-core turbo frequency and deliver up to 20% better performance than previous generation z1d instances.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.16.6](service/managedblockchain/CHANGELOG.md#v1166-2023-10-02)
  * **Documentation**: Remove Rinkeby as option from Ethereum APIs
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.55.0](service/rds/CHANGELOG.md#v1550-2023-10-02)
  * **Feature**: Adds DefaultCertificateForNewLaunches field in the DescribeCertificates API response.
* `github.com/aws/aws-sdk-go-v2/service/sso`: [v1.15.0](service/sso/CHANGELOG.md#v1150-2023-10-02)
  * **Feature**: Fix FIPS Endpoints in aws-us-gov.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.23.0](service/sts/CHANGELOG.md#v1230-2023-10-02)
  * **Feature**: STS API updates for assumeRole
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.33.9](service/transfer/CHANGELOG.md#v1339-2023-10-02)
  * **Documentation**: Documentation updates for AWS Transfer Family

# Release (2023-09-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.0.0](service/bedrock/CHANGELOG.md#v100-2023-09-28)
  * **Release**: New AWS service client module
  * **Feature**: Model Invocation logging added to enable or disable logs in customer account. Model listing and description support added. Provisioned Throughput feature added. Custom model support added for creating custom models. Also includes list, and delete functions for custom model.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.0.0](service/bedrockruntime/CHANGELOG.md#v100-2023-09-28)
  * **Release**: New AWS service client module
  * **Feature**: Run Inference: Added support to run the inference on models.  Includes set of APIs for running inference in streaming and non-streaming mode.
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.17.0](service/budgets/CHANGELOG.md#v1170-2023-09-28)
  * **Feature**: Update DescribeBudgets and DescribeBudgetNotificationsForAccount MaxResults limit to 1000.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.122.0](service/ec2/CHANGELOG.md#v11220-2023-09-28)
  * **Feature**: Adds support for Customer Managed Key encryption for Amazon Verified Access resources
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.6.0](service/iotfleetwise/CHANGELOG.md#v160-2023-09-28)
  * **Feature**: AWS IoT FleetWise now supports encryption through a customer managed AWS KMS key. The PutEncryptionConfiguration and GetEncryptionConfiguration APIs were added.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.108.0](service/sagemaker/CHANGELOG.md#v11080-2023-09-28)
  * **Feature**: Online store feature groups supports Standard and InMemory tier storage types for low latency storage for real-time data retrieval. The InMemory tier supports collection types List, Set, and Vector.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.18.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1180-2023-09-28)
  * **Feature**: Feature Store supports read/write of records with collection type features.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.39.1](service/wafv2/CHANGELOG.md#v1391-2023-09-28)
  * **Documentation**: Correct and improve the documentation for the FieldToMatch option JA3 fingerprint.

# Release (2023-09-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.27.0](service/cognitoidentityprovider/CHANGELOG.md#v1270-2023-09-27)
  * **Feature**: The UserPoolType Status field is no longer used.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.19.0](service/firehose/CHANGELOG.md#v1190-2023-09-27)
  * **Feature**: Features : Adding support for new data ingestion source to Kinesis Firehose - AWS Managed Services Kafka.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.40.0](service/iot/CHANGELOG.md#v1400-2023-09-27)
  * **Feature**: Added support for IoT Rules Engine Kafka Action Headers
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.24.0](service/textract/CHANGELOG.md#v1240-2023-09-27)
  * **Feature**: This release adds new feature - Layout to Analyze Document API which can automatically extract layout elements such as titles, paragraphs, headers, section headers, lists, page numbers, footers, table areas, key-value areas and figure areas and order the elements as a human would read.

# Release (2023-09-26)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.18.0](service/appintegrations/CHANGELOG.md#v1180-2023-09-26)
  * **Feature**: The Amazon AppIntegrations service adds a set of APIs (in preview) to manage third party applications to be used in Amazon Connect agent workspace.
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.21.0](service/apprunner/CHANGELOG.md#v1210-2023-09-26)
  * **Feature**: This release allows an App Runner customer to specify a custom source directory to run the build & start command. This change allows App Runner to support monorepo based repositories
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.18.1](service/codedeploy/CHANGELOG.md#v1181-2023-09-26)
  * **Documentation**: CodeDeploy now supports In-place and Blue/Green EC2 deployments with multiple Classic Load Balancers and multiple Target Groups.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.68.0](service/connect/CHANGELOG.md#v1680-2023-09-26)
  * **Feature**: This release updates a set of Amazon Connect APIs that provides the ability to integrate third party applications in the Amazon Connect agent workspace.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.22.0](service/dynamodb/CHANGELOG.md#v1220-2023-09-26)
  * **Feature**: Amazon DynamoDB now supports Incremental Export as an enhancement to the existing Export Table
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.121.0](service/ec2/CHANGELOG.md#v11210-2023-09-26)
  * **Feature**: The release includes AWS verified access to support FIPs compliance in North America regions
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.24.0](service/lakeformation/CHANGELOG.md#v1240-2023-09-26)
  * **Feature**: This release adds three new API support "CreateLakeFormationOptIn", "DeleteLakeFormationOptIn" and "ListLakeFormationOptIns", and also updates the corresponding documentation.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.22.6](service/pinpoint/CHANGELOG.md#v1226-2023-09-26)
  * **Documentation**: Update documentation for RemoveAttributes to more accurately reflect its behavior when attributes are deleted.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.40.0](service/s3/CHANGELOG.md#v1400-2023-09-26)
  * **Feature**: This release adds a new field COMPLETED to the ReplicationStatus Enum. You can now use this field to validate the replication status of S3 objects using the AWS SDK.

# Release (2023-09-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.13.0](service/amplifyuibuilder/CHANGELOG.md#v1130-2023-09-25)
  * **Feature**: Support for generating code that is compatible with future versions of amplify project dependencies.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.9.0](service/chimesdkmediapipelines/CHANGELOG.md#v190-2023-09-25)
  * **Feature**: Adds support for sending WebRTC audio to Amazon Kineses Video Streams.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.11.0](service/emrserverless/CHANGELOG.md#v1110-2023-09-25)
  * **Feature**: This release adds support for application-wide default job configurations.
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.17.0](service/finspacedata/CHANGELOG.md#v1170-2023-09-25)
  * **Feature**: Adding sensitive trait to attributes. Change max SessionDuration from 720 to 60. Correct "ApiAccess" attribute to "apiAccess" to maintain consistency between APIs.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.44.0](service/quicksight/CHANGELOG.md#v1440-2023-09-25)
  * **Feature**: Added ability to tag users upon creation.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.38.0](service/ssm/CHANGELOG.md#v1380-2023-09-25)
  * **Feature**: This release updates the enum values for ResourceType in SSM DescribeInstanceInformation input and ConnectionStatus in GetConnectionStatus output.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.39.0](service/wafv2/CHANGELOG.md#v1390-2023-09-25)
  * **Feature**: You can now perform an exact match against the web request's JA3 fingerprint.

# Release (2023-09-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.18.42](config/CHANGELOG.md#v11842-2023-09-22)
  * **Bug Fix**: Fixed a bug where merging `max_attempts` or `duration_seconds` fields across shared config files with invalid values would silently default them to 0.
  * **Bug Fix**: Move type assertion of config values out of the parsing stage, which resolves an issue where the contents of a profile would silently be dropped with certain numeric formats.
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.3.43](internal/ini/CHANGELOG.md#v1343-2023-09-22)
  * **Bug Fix**: Fixed a bug where merging `max_attempts` or `duration_seconds` fields across shared config files with invalid values would silently default them to 0.
  * **Bug Fix**: Move type assertion of config values out of the parsing stage, which resolves an issue where the contents of a profile would silently be dropped with certain numeric formats.
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.20.0](service/braket/CHANGELOG.md#v1200-2023-09-22)
  * **Feature**: This release adds support to view the device queue depth (the number of queued quantum tasks and hybrid jobs on a device) and queue position for a quantum task and hybrid job.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchevents`: [v1.18.0](service/cloudwatchevents/CHANGELOG.md#v1180-2023-09-22)
  * **Feature**: Adds sensitive trait to various shapes in Jetstream Connections API model.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.31.0](service/databasemigrationservice/CHANGELOG.md#v1310-2023-09-22)
  * **Feature**: new vendors for DMS CSF: MongoDB, MariaDB, DocumentDb and Redshift
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.120.0](service/ec2/CHANGELOG.md#v11200-2023-09-22)
  * **Feature**: EC2 M2 Pro Mac instances are powered by Apple M2 Pro Mac Mini computers featuring 12 core CPU, 19 core GPU, 32 GiB of memory, and 16 core Apple Neural Engine and uniquely enabled by the AWS Nitro System through high-speed Thunderbolt connections.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.21.7](service/efs/CHANGELOG.md#v1217-2023-09-22)
  * **Documentation**: Documentation updates for Elastic File System
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.28.0](service/guardduty/CHANGELOG.md#v1280-2023-09-22)
  * **Feature**: Add `EKS_CLUSTER_NAME` to filter and sort key.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.42.0](service/mediaconvert/CHANGELOG.md#v1420-2023-09-22)
  * **Feature**: This release supports the creation of of audio-only tracks in CMAF output groups.

# Release (2023-09-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.20.0](service/appconfig/CHANGELOG.md#v1200-2023-09-20)
  * **Feature**: Enabling boto3 paginators for list APIs and adding documentation around ServiceQuotaExceededException errors
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.20.0](service/apprunner/CHANGELOG.md#v1200-2023-09-20)
  * **Feature**: This release adds improvements for managing App Runner auto scaling configuration resources. New APIs: UpdateDefaultAutoScalingConfiguration and ListServicesForAutoScalingConfiguration. Updated API: DeleteAutoScalingConfiguration.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.24.0](service/cloudwatchlogs/CHANGELOG.md#v1240-2023-09-20)
  * **Feature**: Add ClientToken to QueryDefinition CFN Handler in CWL
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.20.0](service/codeartifact/CHANGELOG.md#v1200-2023-09-20)
  * **Feature**: Add support for the Swift package format.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.18.4](service/kinesisvideo/CHANGELOG.md#v1184-2023-09-20)
  * **Documentation**: Updated DescribeMediaStorageConfiguration, StartEdgeConfigurationUpdate, ImageGenerationConfiguration$SamplingInterval, and UpdateMediaStorageConfiguration to match AWS Docs.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.39.0](service/s3/CHANGELOG.md#v1390-2023-09-20)
  * **Feature**: Fix an issue where the SDK can fail to unmarshall response due to NumberFormatException
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.24.0](service/servicediscovery/CHANGELOG.md#v1240-2023-09-20)
  * **Feature**: Adds a new DiscoverInstancesRevision API and also adds InstanceRevision field to the DiscoverInstances API response.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.17.0](service/ssooidc/CHANGELOG.md#v1170-2023-09-20)
  * **Feature**: Update FIPS endpoints in aws-us-gov.

# Release (2023-09-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.119.0](service/ec2/CHANGELOG.md#v11190-2023-09-19)
  * **Feature**: This release adds support for C7i, and R7a instance types.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.30.0](service/outposts/CHANGELOG.md#v1300-2023-09-19)
  * **Feature**: This release adds the InstanceFamilies field to the ListAssets response.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.107.0](service/sagemaker/CHANGELOG.md#v11070-2023-09-19)
  * **Feature**: This release adds support for one-time model monitoring schedules that are executed immediately without delay, explicit data analysis windows for model monitoring schedules and exclude features attributes to remove features from model monitor analysis.

# Release (2023-09-18)

## General Highlights
* **Feature**: Adds several endpoint ruleset changes across all models: smaller rulesets, removed non-unique regional endpoints, fixes FIPS and DualStack endpoints, and make region not required in SDK::Endpoint. Additional breakfix to cognito-sync field.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.21.0](service/accessanalyzer/CHANGELOG.md#v1210-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.19.0](service/acm/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.15.0](service/amplify/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/apigatewaymanagementapi`: [v1.13.0](service/apigatewaymanagementapi/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.19.0](service/appconfig/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appconfigdata`: [v1.8.0](service/appconfigdata/CHANGELOG.md#v180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appfabric`: [v1.2.0](service/appfabric/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.17.0](service/appintegrations/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/applicationcostprofiler`: [v1.12.0](service/applicationcostprofiler/CHANGELOG.md#v1120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appmesh`: [v1.19.0](service/appmesh/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.3.0](service/arczonalshift/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/autoscalingplans`: [v1.15.0](service/autoscalingplans/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/backupgateway`: [v1.11.0](service/backupgateway/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/backupstorage`: [v1.3.0](service/backupstorage/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.19.0](service/braket/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.9.0](service/chimesdkvoice/CHANGELOG.md#v190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/clouddirectory`: [v1.15.0](service/clouddirectory/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.16.0](service/cloudhsmv2/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cloudsearch`: [v1.16.0](service/cloudsearch/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cloudsearchdomain`: [v1.14.0](service/cloudsearchdomain/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cloudtraildata`: [v1.2.0](service/cloudtraildata/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.22.0](service/codebuild/CHANGELOG.md#v1220-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.18.0](service/codedeploy/CHANGELOG.md#v1180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codeguruprofiler`: [v1.15.0](service/codeguruprofiler/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codegurureviewer`: [v1.19.0](service/codegurureviewer/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codegurusecurity`: [v1.2.0](service/codegurusecurity/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codestar`: [v1.15.0](service/codestar/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codestarnotifications`: [v1.16.0](service/codestarnotifications/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentity`: [v1.17.0](service/cognitoidentity/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cognitosync`: [v1.14.0](service/cognitosync/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.7.0](service/connectcases/CHANGELOG.md#v170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/connectcontactlens`: [v1.15.0](service/connectcontactlens/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.3.0](service/controltower/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/databrew`: [v1.23.0](service/databrew/CHANGELOG.md#v1230-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.21.0](service/dataexchange/CHANGELOG.md#v1210-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/datapipeline`: [v1.16.0](service/datapipeline/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/dax`: [v1.14.0](service/dax/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.17.0](service/devicefarm/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.3.0](service/docdbelastic/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ec2instanceconnect`: [v1.17.0](service/ec2instanceconnect/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.18.0](service/ecrpublic/CHANGELOG.md#v1180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk`: [v1.17.0](service/elasticbeanstalk/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancing`: [v1.17.0](service/elasticloadbalancing/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/elastictranscoder`: [v1.16.0](service/elastictranscoder/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/evidently`: [v1.13.0](service/evidently/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.16.0](service/finspacedata/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.16.0](service/fis/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/forecast`: [v1.27.0](service/forecast/CHANGELOG.md#v1270-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/forecastquery`: [v1.15.0](service/forecastquery/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/gamesparks`: [v1.4.0](service/gamesparks/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/glacier`: [v1.16.0](service/glacier/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/greengrass`: [v1.17.0](service/greengrass/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.24.0](service/greengrassv2/CHANGELOG.md#v1240-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/honeycode`: [v1.15.0](service/honeycode/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/inspector`: [v1.15.0](service/inspector/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iot1clickdevicesservice`: [v1.13.0](service/iot1clickdevicesservice/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iot1clickprojects`: [v1.14.0](service/iot1clickprojects/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotanalytics`: [v1.16.0](service/iotanalytics/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotevents`: [v1.17.0](service/iotevents/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ioteventsdata`: [v1.15.0](service/ioteventsdata/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotfleethub`: [v1.15.0](service/iotfleethub/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotjobsdataplane`: [v1.14.0](service/iotjobsdataplane/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotroborunner`: [v1.3.0](service/iotroborunner/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotsecuretunneling`: [v1.17.0](service/iotsecuretunneling/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotthingsgraph`: [v1.16.0](service/iotthingsgraph/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.6.0](service/ivschat/CHANGELOG.md#v160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kendraranking`: [v1.2.0](service/kendraranking/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.19.0](service/kinesis/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalytics`: [v1.16.0](service/kinesisanalytics/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia`: [v1.17.0](service/kinesisvideoarchivedmedia/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideomedia`: [v1.13.0](service/kinesisvideomedia/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideosignaling`: [v1.13.0](service/kinesisvideosignaling/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.4.0](service/kinesisvideowebrtcstorage/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelbuildingservice`: [v1.19.0](service/lexmodelbuildingservice/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lexruntimeservice`: [v1.15.0](service/lexruntimeservice/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lexruntimev2`: [v1.19.0](service/lexruntimev2/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/licensemanager`: [v1.20.0](service/licensemanager/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.3.0](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.4.0](service/licensemanagerusersubscriptions/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lookoutmetrics`: [v1.21.0](service/lookoutmetrics/CHANGELOG.md#v1210-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lookoutvision`: [v1.17.0](service/lookoutvision/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/machinelearning`: [v1.17.0](service/machinelearning/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/macie`: [v1.17.0](service/macie/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.29.7](service/macie2/CHANGELOG.md#v1297-2023-09-18)
  * **Documentation**: This release changes the default managedDataIdentifierSelector setting for new classification jobs to RECOMMENDED. By default, new classification jobs now use the recommended set of managed data identifiers.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecommerceanalytics`: [v1.14.0](service/marketplacecommerceanalytics/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.14.0](service/marketplaceentitlementservice/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/marketplacemetering`: [v1.16.0](service/marketplacemetering/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.2.0](service/mediapackagev2/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagevod`: [v1.24.0](service/mediapackagevod/CHANGELOG.md#v1240-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mediastore`: [v1.15.0](service/mediastore/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mediastoredata`: [v1.15.0](service/mediastoredata/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.2.0](service/medicalimaging/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/migrationhub`: [v1.15.0](service/migrationhub/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubconfig`: [v1.15.0](service/migrationhubconfig/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/migrationhuborchestrator`: [v1.3.0](service/migrationhuborchestrator/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.11.0](service/migrationhubstrategy/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mobile`: [v1.14.0](service/mobile/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mturk`: [v1.16.0](service/mturk/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.22.0](service/neptune/CHANGELOG.md#v1220-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.19.0](service/networkmanager/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/nimble`: [v1.18.0](service/nimble/CHANGELOG.md#v1180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.3.0](service/oam/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.5.0](service/opensearchserverless/CHANGELOG.md#v150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/opsworks`: [v1.16.0](service/opsworks/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/opsworkscm`: [v1.17.0](service/opsworkscm/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.2.0](service/osis/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/panorama`: [v1.13.0](service/panorama/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.2.0](service/paymentcryptography/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/personalizeevents`: [v1.15.0](service/personalizeevents/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.15.0](service/personalizeruntime/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/pinpointemail`: [v1.14.0](service/pinpointemail/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoice`: [v1.13.0](service/pinpointsmsvoice/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.3.0](service/pinpointsmsvoicev2/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.4.0](service/pipes/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/qldbsession`: [v1.16.0](service/qldbsession/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.10.0](service/rbin/CHANGELOG.md#v1100-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.15.0](service/rdsdata/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.6.0](service/redshiftserverless/CHANGELOG.md#v160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.4.0](service/resourceexplorer2/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.16.0](service/resourcegroups/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/resourcegroupstaggingapi`: [v1.16.0](service/resourcegroupstaggingapi/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/robomaker`: [v1.20.0](service/robomaker/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycluster`: [v1.13.0](service/route53recoverycluster/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.13.0](service/route53recoverycontrolconfig/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/route53recoveryreadiness`: [v1.11.0](service/route53recoveryreadiness/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.20.0](service/route53resolver/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.12.0](service/rum/CHANGELOG.md#v1120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.18.0](service/s3outposts/CHANGELOG.md#v1180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sagemakera2iruntime`: [v1.17.0](service/sagemakera2iruntime/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sagemakeredge`: [v1.15.0](service/sagemakeredge/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial`: [v1.5.0](service/sagemakergeospatial/CHANGELOG.md#v150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sagemakermetrics`: [v1.2.0](service/sagemakermetrics/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/scheduler`: [v1.3.0](service/scheduler/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/schemas`: [v1.17.0](service/schemas/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/serverlessapplicationrepository`: [v1.14.0](service/serverlessapplicationrepository/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.19.0](service/servicecatalogappregistry/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.23.0](service/servicediscovery/CHANGELOG.md#v1230-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/shield`: [v1.20.0](service/shield/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sms`: [v1.15.0](service/sms/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/snowdevicemanagement`: [v1.11.0](service/snowdevicemanagement/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.22.0](service/sns/CHANGELOG.md#v1220-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ssmcontacts`: [v1.17.0](service/ssmcontacts/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.23.0](service/ssmincidents/CHANGELOG.md#v1230-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.5.0](service/ssmsap/CHANGELOG.md#v150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sso`: [v1.14.0](service/sso/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.16.0](service/ssooidc/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.20.0](service/storagegateway/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.22.0](service/sts/CHANGELOG.md#v1220-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/supportapp`: [v1.4.0](service/supportapp/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.19.0](service/synthetics/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.23.0](service/textract/CHANGELOG.md#v1230-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.17.0](service/timestreamquery/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.19.0](service/timestreamwrite/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/tnb`: [v1.3.0](service/tnb/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.11.0](service/transcribestreaming/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/voiceid`: [v1.15.0](service/voiceid/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/waf`: [v1.14.0](service/waf/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/wafregional`: [v1.15.0](service/wafregional/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/workdocs`: [v1.16.0](service/workdocs/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/worklink`: [v1.15.0](service/worklink/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/workmail`: [v1.20.0](service/workmail/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
  * **Feature**: This release includes four new APIs UpdateUser, UpdateGroup, ListGroupsForEntity and DescribeEntity, along with RemoteUsers and some enhancements to existing APIs.
* `github.com/aws/aws-sdk-go-v2/service/workmailmessageflow`: [v1.14.0](service/workmailmessageflow/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.

# Release (2023-09-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.24.0](service/appstream/CHANGELOG.md#v1240-2023-09-15)
  * **Feature**: This release introduces app block builder, allowing customers to provision a resource to package applications into an app block
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.67.0](service/connect/CHANGELOG.md#v1670-2023-09-15)
  * **Feature**: New rule type (OnMetricDataUpdate) has been added
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.29.1](service/datasync/CHANGELOG.md#v1291-2023-09-15)
  * **Documentation**: Documentation-only updates for AWS DataSync.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.106.0](service/sagemaker/CHANGELOG.md#v11060-2023-09-15)
  * **Feature**: This release introduces Skip Model Validation for Model Packages

# Release (2023-09-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.23.0](service/appstream/CHANGELOG.md#v1230-2023-09-14)
  * **Feature**: This release introduces multi-session fleets, allowing customers to provision more than one user session on a single fleet instance.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.34.6](service/cloudformation/CHANGELOG.md#v1346-2023-09-14)
  * **Documentation**: Documentation updates for AWS CloudFormation
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.2.0](service/entityresolution/CHANGELOG.md#v120-2023-09-14)
  * **Feature**: Changed "ResolutionTechniques" and "MappedInputFields" in workflow and schema mapping operations to be required fields.
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.19.0](service/lookoutequipment/CHANGELOG.md#v1190-2023-09-14)
  * **Feature**: This release adds APIs for the new scheduled retraining feature.

# Release (2023-09-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.18.8](service/cloud9/CHANGELOG.md#v1188-2023-09-13)
  * **Documentation**: Update to include information on Ubuntu 18 deprecation.
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.16.0](service/drs/CHANGELOG.md#v1160-2023-09-13)
  * **Feature**: Updated existing APIs and added new ones to support using AWS Elastic Disaster Recovery post-launch actions. Added support for new regions.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.18.0](service/firehose/CHANGELOG.md#v1180-2023-09-13)
  * **Feature**: DocumentIdOptions has been added for the Amazon OpenSearch destination.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.27.0](service/guardduty/CHANGELOG.md#v1270-2023-09-13)
  * **Feature**: Add `managementType` field to ListCoverage API response.
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.6.0](service/internetmonitor/CHANGELOG.md#v160-2023-09-13)
  * **Feature**: This release updates the Amazon CloudWatch Internet Monitor API domain name.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.4.4](service/ivsrealtime/CHANGELOG.md#v144-2023-09-13)
  * **Documentation**: Doc only update that changes description for ParticipantToken.
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.5.1](service/simspaceweaver/CHANGELOG.md#v151-2023-09-13)
  * **Documentation**: Edited the introductory text for the API reference.
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.18.0](service/xray/CHANGELOG.md#v1180-2023-09-13)
  * **Feature**: Add StartTime field in GetTraceSummaries API response for each TraceSummary.

# Release (2023-09-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.118.0](service/ec2/CHANGELOG.md#v11180-2023-09-12)
  * **Feature**: This release adds support for restricting public sharing of AMIs through AMI Block Public Access
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.22.0](service/eventbridge/CHANGELOG.md#v1220-2023-09-12)
  * **Feature**: Adds sensitive trait to various shapes in Jetstream Connections API model.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.43.0](service/kendra/CHANGELOG.md#v1430-2023-09-12)
  * **Feature**: Amazon Kendra now supports confidence score buckets for retrieved passage results using the Retrieve API.

# Release (2023-09-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.20.0](service/ecr/CHANGELOG.md#v1200-2023-09-11)
  * **Feature**: This release will have ValidationException be thrown from ECR LifecyclePolicy APIs 