/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	storagev1alpha1 "k8s.io/api/storage/v1alpha1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// VolumeAttributesClassLister helps list VolumeAttributesClasses.
// All objects returned here must be treated as read-only.
type VolumeAttributesClassLister interface {
	// List lists all VolumeAttributesClasses in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*storagev1alpha1.VolumeAttributesClass, err error)
	// Get retrieves the VolumeAttributesClass from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*storagev1alpha1.VolumeAttributesClass, error)
	VolumeAttributesClassListerExpansion
}

// volumeAttributesClassLister implements the VolumeAttributesClassLister interface.
type volumeAttributesClassLister struct {
	listers.ResourceIndexer[*storagev1alpha1.VolumeAttributesClass]
}

// NewVolumeAttributesClassLister returns a new VolumeAttributesClassLister.
func NewVolumeAttributesClassLister(indexer cache.Indexer) VolumeAttributesClassLister {
	return &volumeAttributesClassLister{listers.New[*storagev1alpha1.VolumeAttributesClass](indexer, storagev1alpha1.Resource("volumeattributesclass"))}
}
