// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/paymentgateway/issuerswitch/v1/transactions.proto

package issuerswitch

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	date "google.golang.org/genproto/googleapis/type/date"
	money "google.golang.org/genproto/googleapis/type/money"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the current state of the transaction.
type TransactionInfo_State int32

const (
	// Unspecified state.
	TransactionInfo_STATE_UNSPECIFIED TransactionInfo_State = 0
	// The transaction has successfully completed.
	TransactionInfo_SUCCEEDED TransactionInfo_State = 1
	// The transaction has failed.
	TransactionInfo_FAILED TransactionInfo_State = 2
	// The transaction has timed out.
	TransactionInfo_TIMED_OUT TransactionInfo_State = 3
)

// Enum value maps for TransactionInfo_State.
var (
	TransactionInfo_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "TIMED_OUT",
	}
	TransactionInfo_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
		"TIMED_OUT":         3,
	}
)

func (x TransactionInfo_State) Enum() *TransactionInfo_State {
	p := new(TransactionInfo_State)
	*p = x
	return p
}

func (x TransactionInfo_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionInfo_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[0].Descriptor()
}

func (TransactionInfo_State) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[0]
}

func (x TransactionInfo_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionInfo_State.Descriptor instead.
func (TransactionInfo_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{0, 0}
}

// The sub-type of a transaction. This value is used only for certain API type
// and transaction type combinations.
type TransactionInfo_TransactionSubType int32

const (
	// Unspecified transaction sub-type.
	TransactionInfo_TRANSACTION_SUB_TYPE_UNSPECIFIED TransactionInfo_TransactionSubType = 0
	// Collect sub type. This is used in a `SETTLE_PAYMENT` API type
	// transaction, with transaction type as either `CREDIT` or `DEBIT` when the
	// payment was initiated by a collect request.
	TransactionInfo_COLLECT TransactionInfo_TransactionSubType = 1
	// Debit sub type. This is used in a `SETTLE_PAYMENT` API type transaction,
	// with transaction type as `REVERSAL` when the original payment was a
	// debit request.
	TransactionInfo_DEBIT TransactionInfo_TransactionSubType = 2
	// Pay sub type. This is used in a `SETTLE_PAYMENT` API type transaction,
	// with transaction type as either `CREDIT` or `DEBIT` when the payment was
	// initiated by a pay request.
	TransactionInfo_PAY TransactionInfo_TransactionSubType = 3
	// Beneficiary subtype. This is used in a `COMPLAINT` API type transaction,
	// when the complaint / dispute request is initiated / received by the
	// beneficiary bank.
	TransactionInfo_BENEFICIARY TransactionInfo_TransactionSubType = 4
	// Remitter subtype. This is used in a `COMPLAINT` API type transaction,
	// when the complaint / dispute request is initiated / received by the
	// remitter bank.
	TransactionInfo_REMITTER TransactionInfo_TransactionSubType = 5
)

// Enum value maps for TransactionInfo_TransactionSubType.
var (
	TransactionInfo_TransactionSubType_name = map[int32]string{
		0: "TRANSACTION_SUB_TYPE_UNSPECIFIED",
		1: "COLLECT",
		2: "DEBIT",
		3: "PAY",
		4: "BENEFICIARY",
		5: "REMITTER",
	}
	TransactionInfo_TransactionSubType_value = map[string]int32{
		"TRANSACTION_SUB_TYPE_UNSPECIFIED": 0,
		"COLLECT":                          1,
		"DEBIT":                            2,
		"PAY":                              3,
		"BENEFICIARY":                      4,
		"REMITTER":                         5,
	}
)

func (x TransactionInfo_TransactionSubType) Enum() *TransactionInfo_TransactionSubType {
	p := new(TransactionInfo_TransactionSubType)
	*p = x
	return p
}

func (x TransactionInfo_TransactionSubType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionInfo_TransactionSubType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[1].Descriptor()
}

func (TransactionInfo_TransactionSubType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[1]
}

func (x TransactionInfo_TransactionSubType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionInfo_TransactionSubType.Descriptor instead.
func (TransactionInfo_TransactionSubType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{0, 1}
}

// An enum of the possible rule names.
type FinancialTransaction_PaymentRule_PaymentRuleName int32

const (
	// Rule name unspecified.
	FinancialTransaction_PaymentRule_PAYMENT_RULE_NAME_UNSPECIFIED FinancialTransaction_PaymentRule_PaymentRuleName = 0
	// The `expire after` rule.
	FinancialTransaction_PaymentRule_EXPIRE_AFTER FinancialTransaction_PaymentRule_PaymentRuleName = 1
	// The `min amount` rule.
	FinancialTransaction_PaymentRule_MIN_AMOUNT FinancialTransaction_PaymentRule_PaymentRuleName = 2
)

// Enum value maps for FinancialTransaction_PaymentRule_PaymentRuleName.
var (
	FinancialTransaction_PaymentRule_PaymentRuleName_name = map[int32]string{
		0: "PAYMENT_RULE_NAME_UNSPECIFIED",
		1: "EXPIRE_AFTER",
		2: "MIN_AMOUNT",
	}
	FinancialTransaction_PaymentRule_PaymentRuleName_value = map[string]int32{
		"PAYMENT_RULE_NAME_UNSPECIFIED": 0,
		"EXPIRE_AFTER":                  1,
		"MIN_AMOUNT":                    2,
	}
)

func (x FinancialTransaction_PaymentRule_PaymentRuleName) Enum() *FinancialTransaction_PaymentRule_PaymentRuleName {
	p := new(FinancialTransaction_PaymentRule_PaymentRuleName)
	*p = x
	return p
}

func (x FinancialTransaction_PaymentRule_PaymentRuleName) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FinancialTransaction_PaymentRule_PaymentRuleName) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[2].Descriptor()
}

func (FinancialTransaction_PaymentRule_PaymentRuleName) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[2]
}

func (x FinancialTransaction_PaymentRule_PaymentRuleName) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FinancialTransaction_PaymentRule_PaymentRuleName.Descriptor instead.
func (FinancialTransaction_PaymentRule_PaymentRuleName) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{2, 0, 0}
}

// RecurrencePatternType specifies the recurrence pattern type of the mandate.
type MandateTransaction_RecurrencePatternType int32

const (
	// Unspecified recurrence pattern.
	MandateTransaction_RECURRENCE_PATTERN_TYPE_UNSPECIFIED MandateTransaction_RecurrencePatternType = 0
	// As presented recurrence pattern.
	MandateTransaction_AS_PRESENTED MandateTransaction_RecurrencePatternType = 1
	// Bi monthly recurrence pattern.
	MandateTransaction_BIMONTHLY MandateTransaction_RecurrencePatternType = 2
	// Daily recurrence pattern.
	MandateTransaction_DAILY MandateTransaction_RecurrencePatternType = 3
	// Bi weekly recurrence pattern.
	MandateTransaction_FORTNIGHTLY MandateTransaction_RecurrencePatternType = 4
	// Half yearly recurrence pattern.
	MandateTransaction_HALF_YEARLY MandateTransaction_RecurrencePatternType = 5
	// Monthly recurrence pattern.
	MandateTransaction_MONTHLY MandateTransaction_RecurrencePatternType = 6
	// One time recurrence pattern.
	MandateTransaction_ONE_TIME MandateTransaction_RecurrencePatternType = 7
	// Quarterly recurrence pattern.
	MandateTransaction_QUARTERLY MandateTransaction_RecurrencePatternType = 8
	// Weekly recurrence pattern.
	MandateTransaction_WEEKLY MandateTransaction_RecurrencePatternType = 9
	// Yearly recurrence pattern.
	MandateTransaction_YEARLY MandateTransaction_RecurrencePatternType = 10
)

// Enum value maps for MandateTransaction_RecurrencePatternType.
var (
	MandateTransaction_RecurrencePatternType_name = map[int32]string{
		0:  "RECURRENCE_PATTERN_TYPE_UNSPECIFIED",
		1:  "AS_PRESENTED",
		2:  "BIMONTHLY",
		3:  "DAILY",
		4:  "FORTNIGHTLY",
		5:  "HALF_YEARLY",
		6:  "MONTHLY",
		7:  "ONE_TIME",
		8:  "QUARTERLY",
		9:  "WEEKLY",
		10: "YEARLY",
	}
	MandateTransaction_RecurrencePatternType_value = map[string]int32{
		"RECURRENCE_PATTERN_TYPE_UNSPECIFIED": 0,
		"AS_PRESENTED":                        1,
		"BIMONTHLY":                           2,
		"DAILY":                               3,
		"FORTNIGHTLY":                         4,
		"HALF_YEARLY":                         5,
		"MONTHLY":                             6,
		"ONE_TIME":                            7,
		"QUARTERLY":                           8,
		"WEEKLY":                              9,
		"YEARLY":                              10,
	}
)

func (x MandateTransaction_RecurrencePatternType) Enum() *MandateTransaction_RecurrencePatternType {
	p := new(MandateTransaction_RecurrencePatternType)
	*p = x
	return p
}

func (x MandateTransaction_RecurrencePatternType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MandateTransaction_RecurrencePatternType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[3].Descriptor()
}

func (MandateTransaction_RecurrencePatternType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[3]
}

func (x MandateTransaction_RecurrencePatternType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MandateTransaction_RecurrencePatternType.Descriptor instead.
func (MandateTransaction_RecurrencePatternType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{3, 0}
}

// RecurrenceRuleType specifies the recurrence rule type of mandate.
type MandateTransaction_RecurrenceRuleType int32

const (
	// Unspecified recurrence rule type.
	MandateTransaction_RECURRENCE_RULE_TYPE_UNSPECIFIED MandateTransaction_RecurrenceRuleType = 0
	// After recurrence rule type.
	MandateTransaction_AFTER MandateTransaction_RecurrenceRuleType = 1
	// Before recurrence rule type.
	MandateTransaction_BEFORE MandateTransaction_RecurrenceRuleType = 2
	// On recurrence rule type.
	MandateTransaction_ON MandateTransaction_RecurrenceRuleType = 3
)

// Enum value maps for MandateTransaction_RecurrenceRuleType.
var (
	MandateTransaction_RecurrenceRuleType_name = map[int32]string{
		0: "RECURRENCE_RULE_TYPE_UNSPECIFIED",
		1: "AFTER",
		2: "BEFORE",
		3: "ON",
	}
	MandateTransaction_RecurrenceRuleType_value = map[string]int32{
		"RECURRENCE_RULE_TYPE_UNSPECIFIED": 0,
		"AFTER":                            1,
		"BEFORE":                           2,
		"ON":                               3,
	}
)

func (x MandateTransaction_RecurrenceRuleType) Enum() *MandateTransaction_RecurrenceRuleType {
	p := new(MandateTransaction_RecurrenceRuleType)
	*p = x
	return p
}

func (x MandateTransaction_RecurrenceRuleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MandateTransaction_RecurrenceRuleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[4].Descriptor()
}

func (MandateTransaction_RecurrenceRuleType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[4]
}

func (x MandateTransaction_RecurrenceRuleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MandateTransaction_RecurrenceRuleType.Descriptor instead.
func (MandateTransaction_RecurrenceRuleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{3, 1}
}

// AmountRuleType specifies the type of rule associated with the mandate
// amount.
type MandateTransaction_AmountRuleType int32

const (
	// Unspecified amount rule.
	MandateTransaction_AMOUNT_RULE_TYPE_UNSPECIFIED MandateTransaction_AmountRuleType = 0
	// Exact amount rule. Amount specified is the exact amount for which
	// mandate could be granted.
	MandateTransaction_EXACT MandateTransaction_AmountRuleType = 1
	// Max amount rule. Amount specified is the maximum amount for which
	// mandate could be granted.
	MandateTransaction_MAX MandateTransaction_AmountRuleType = 2
)

// Enum value maps for MandateTransaction_AmountRuleType.
var (
	MandateTransaction_AmountRuleType_name = map[int32]string{
		0: "AMOUNT_RULE_TYPE_UNSPECIFIED",
		1: "EXACT",
		2: "MAX",
	}
	MandateTransaction_AmountRuleType_value = map[string]int32{
		"AMOUNT_RULE_TYPE_UNSPECIFIED": 0,
		"EXACT":                        1,
		"MAX":                          2,
	}
)

func (x MandateTransaction_AmountRuleType) Enum() *MandateTransaction_AmountRuleType {
	p := new(MandateTransaction_AmountRuleType)
	*p = x
	return p
}

func (x MandateTransaction_AmountRuleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MandateTransaction_AmountRuleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[5].Descriptor()
}

func (MandateTransaction_AmountRuleType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes[5]
}

func (x MandateTransaction_AmountRuleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MandateTransaction_AmountRuleType.Descriptor instead.
func (MandateTransaction_AmountRuleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{3, 2}
}

// Information about a transaction processed by the issuer switch.
// The fields in this type are common across both financial and metadata
// transactions.
type TransactionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. An identifier that is mandatorily present in every transaction
	// processed via UPI. This maps to UPI's transaction ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The API type of the transaction.
	ApiType ApiType `protobuf:"varint,2,opt,name=api_type,json=apiType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.ApiType" json:"api_type,omitempty"`
	// Output only. The transaction type.
	TransactionType TransactionType `protobuf:"varint,3,opt,name=transaction_type,json=transactionType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionType" json:"transaction_type,omitempty"`
	// Output only. The transaction sub-type.
	TransactionSubType TransactionInfo_TransactionSubType `protobuf:"varint,4,opt,name=transaction_sub_type,json=transactionSubType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo_TransactionSubType" json:"transaction_sub_type,omitempty"`
	// Output only. The transaction's state.
	State TransactionInfo_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo_State" json:"state,omitempty"`
	// Metadata about the API transaction.
	Metadata *TransactionInfo_TransactionMetadata `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Output only. Any error details for the current API transaction, if the state
	// is `FAILED`.
	ErrorDetails *TransactionInfo_TransactionErrorDetails `protobuf:"bytes,7,opt,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty"`
	// Output only. Information about the bank adapter invocation from the issuer
	// switch for processing this API transaction.
	BankAdapterInfo *TransactionInfo_BankAdapterInfo `protobuf:"bytes,8,opt,name=bank_adapter_info,json=bankAdapterInfo,proto3" json:"bank_adapter_info,omitempty"`
	// Risk information as provided by the payments orchestrator.
	RiskInfo []*TransactionInfo_TransactionRiskInfo `protobuf:"bytes,9,rep,name=risk_info,json=riskInfo,proto3" json:"risk_info,omitempty"`
}

func (x *TransactionInfo) Reset() {
	*x = TransactionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionInfo) ProtoMessage() {}

func (x *TransactionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionInfo.ProtoReflect.Descriptor instead.
func (*TransactionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{0}
}

func (x *TransactionInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *TransactionInfo) GetApiType() ApiType {
	if x != nil {
		return x.ApiType
	}
	return ApiType_API_TYPE_UNSPECIFIED
}

func (x *TransactionInfo) GetTransactionType() TransactionType {
	if x != nil {
		return x.TransactionType
	}
	return TransactionType_TRANSACTION_TYPE_UNSPECIFIED
}

func (x *TransactionInfo) GetTransactionSubType() TransactionInfo_TransactionSubType {
	if x != nil {
		return x.TransactionSubType
	}
	return TransactionInfo_TRANSACTION_SUB_TYPE_UNSPECIFIED
}

func (x *TransactionInfo) GetState() TransactionInfo_State {
	if x != nil {
		return x.State
	}
	return TransactionInfo_STATE_UNSPECIFIED
}

func (x *TransactionInfo) GetMetadata() *TransactionInfo_TransactionMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *TransactionInfo) GetErrorDetails() *TransactionInfo_TransactionErrorDetails {
	if x != nil {
		return x.ErrorDetails
	}
	return nil
}

func (x *TransactionInfo) GetBankAdapterInfo() *TransactionInfo_BankAdapterInfo {
	if x != nil {
		return x.BankAdapterInfo
	}
	return nil
}

func (x *TransactionInfo) GetRiskInfo() []*TransactionInfo_TransactionRiskInfo {
	if x != nil {
		return x.RiskInfo
	}
	return nil
}

// A metadata API transaction processed by the issuer switch. This
// includes UPI APIs such as List Accounts, Balance Enquiry, etc.
type MetadataTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the metadata transaction. This uniquely identifies the
	// transaction. Format of name is
	// projects/{project_id}/metadataTransaction/{metadata_transaction_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Information about the transaction.
	Info *TransactionInfo `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// Output only. The initiator of the metadata transaction.
	Initiator *Participant `protobuf:"bytes,3,opt,name=initiator,proto3" json:"initiator,omitempty"`
}

func (x *MetadataTransaction) Reset() {
	*x = MetadataTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataTransaction) ProtoMessage() {}

func (x *MetadataTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataTransaction.ProtoReflect.Descriptor instead.
func (*MetadataTransaction) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{1}
}

func (x *MetadataTransaction) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetadataTransaction) GetInfo() *TransactionInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *MetadataTransaction) GetInitiator() *Participant {
	if x != nil {
		return x.Initiator
	}
	return nil
}

// A financial API transaction processed by the issuer switch. In UPI, this maps
// to the Pay API.
type FinancialTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the financial transaction. This uniquely identifies the
	// transaction. Format of name is
	// projects/{project_id}/financialTransactions/{financial_transaction_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Information about the transaction.
	Info *TransactionInfo `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// Output only. A 12 digit numeric code associated with the request. It could
	// contain leading 0s. In UPI, this is also known as as the customer reference
	// or the UPI transaction ID.
	RetrievalReferenceNumber string `protobuf:"bytes,3,opt,name=retrieval_reference_number,json=retrievalReferenceNumber,proto3" json:"retrieval_reference_number,omitempty"`
	// Output only. The payer in the transaction.
	Payer *SettlementParticipant `protobuf:"bytes,4,opt,name=payer,proto3" json:"payer,omitempty"`
	// Output only. The payee in the transaction.
	Payee *SettlementParticipant `protobuf:"bytes,5,opt,name=payee,proto3" json:"payee,omitempty"`
	// Output only. The amount for payment settlement in the transaction.
	Amount *money.Money `protobuf:"bytes,6,opt,name=amount,proto3" json:"amount,omitempty"`
	// A list of rules specified by the payments orchestrator for this API
	// transaction.
	PaymentRules []*FinancialTransaction_PaymentRule `protobuf:"bytes,7,rep,name=payment_rules,json=paymentRules,proto3" json:"payment_rules,omitempty"`
}

func (x *FinancialTransaction) Reset() {
	*x = FinancialTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinancialTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinancialTransaction) ProtoMessage() {}

func (x *FinancialTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinancialTransaction.ProtoReflect.Descriptor instead.
func (*FinancialTransaction) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{2}
}

func (x *FinancialTransaction) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FinancialTransaction) GetInfo() *TransactionInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *FinancialTransaction) GetRetrievalReferenceNumber() string {
	if x != nil {
		return x.RetrievalReferenceNumber
	}
	return ""
}

func (x *FinancialTransaction) GetPayer() *SettlementParticipant {
	if x != nil {
		return x.Payer
	}
	return nil
}

func (x *FinancialTransaction) GetPayee() *SettlementParticipant {
	if x != nil {
		return x.Payee
	}
	return nil
}

func (x *FinancialTransaction) GetAmount() *money.Money {
	if x != nil {
		return x.Amount
	}
	return nil
}

func (x *FinancialTransaction) GetPaymentRules() []*FinancialTransaction_PaymentRule {
	if x != nil {
		return x.PaymentRules
	}
	return nil
}

// A mandate processed by the issuer switch. In UPI, this maps to the Mandate
// API.
type MandateTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the mandate transaction. This uniquely identifies the
	// transaction. Format of name is
	// projects/{project_id}/mandateTransactions/{mandate_transaction_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Information about the transaction.
	TransactionInfo *TransactionInfo `protobuf:"bytes,2,opt,name=transaction_info,json=transactionInfo,proto3" json:"transaction_info,omitempty"`
	// Output only. This maps to Unique Mandate Number (UMN) in UPI specification.
	UniqueMandateNumber string `protobuf:"bytes,3,opt,name=unique_mandate_number,json=uniqueMandateNumber,proto3" json:"unique_mandate_number,omitempty"`
	// Output only. The virtual payment address (VPA) of the payer.
	PayerVpa string `protobuf:"bytes,4,opt,name=payer_vpa,json=payerVpa,proto3" json:"payer_vpa,omitempty"`
	// Output only. The virtual payment address (VPA) of the payee.
	PayeeVpa string `protobuf:"bytes,5,opt,name=payee_vpa,json=payeeVpa,proto3" json:"payee_vpa,omitempty"`
	// Output only. A unique identifier for merchant.
	PayeeMerchantId string `protobuf:"bytes,6,opt,name=payee_merchant_id,json=payeeMerchantId,proto3" json:"payee_merchant_id,omitempty"`
	// Output only. The mobile number of the payer consisting of total twelve
	// digits where first two digits of country code (for eg. 91 for India) and
	// then ten digits mobile number. For eg. 911234567890
	PayerMobileNumber string `protobuf:"bytes,7,opt,name=payer_mobile_number,json=payerMobileNumber,proto3" json:"payer_mobile_number,omitempty"`
	// Output only. The mobile number of the payer consisting of total twelve
	// digits where first two digits of country code (for eg. 91 for India) and
	// then ten digits mobile number. For eg. 911234567890
	PayeeMobileNumber string `protobuf:"bytes,8,opt,name=payee_mobile_number,json=payeeMobileNumber,proto3" json:"payee_mobile_number,omitempty"`
	// Output only. The type of recurrence pattern of the mandate.
	RecurrencePattern MandateTransaction_RecurrencePatternType `protobuf:"varint,9,opt,name=recurrence_pattern,json=recurrencePattern,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction_RecurrencePatternType" json:"recurrence_pattern,omitempty"`
	// Output only. The type of recurrence rule of the mandate.
	RecurrenceRuleType MandateTransaction_RecurrenceRuleType `protobuf:"varint,10,opt,name=recurrence_rule_type,json=recurrenceRuleType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction_RecurrenceRuleType" json:"recurrence_rule_type,omitempty"`
	// Output only. The recurrence rule value of the mandate. This is a value from
	// 1 to 31.
	RecurrenceRuleValue int32 `protobuf:"varint,11,opt,name=recurrence_rule_value,json=recurrenceRuleValue,proto3" json:"recurrence_rule_value,omitempty"`
	// Output only. The start date of the mandate.
	StartDate *date.Date `protobuf:"bytes,12,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Output only. The end date of the mandate.
	EndDate *date.Date `protobuf:"bytes,13,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Output only. If true, this specifies mandate can be revoked.
	Revokable bool `protobuf:"varint,14,opt,name=revokable,proto3" json:"revokable,omitempty"`
	// Output only. The amount of the mandate.
	Amount float64 `protobuf:"fixed64,15,opt,name=amount,proto3" json:"amount,omitempty"`
	// Output only. The amount rule type of the mandate.
	AmountRule MandateTransaction_AmountRuleType `protobuf:"varint,16,opt,name=amount_rule,json=amountRule,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction_AmountRuleType" json:"amount_rule,omitempty"`
	// Output only. The Block funds reference generated by the bank, this will be
	// available only when Recurrence is ONETIME.
	ApprovalReference string `protobuf:"bytes,17,opt,name=approval_reference,json=approvalReference,proto3" json:"approval_reference,omitempty"`
	// Output only. If true, this specifies the mandate transaction requested
	// funds to be blocked.
	BlockFunds bool `protobuf:"varint,18,opt,name=block_funds,json=blockFunds,proto3" json:"block_funds,omitempty"`
}

func (x *MandateTransaction) Reset() {
	*x = MandateTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MandateTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MandateTransaction) ProtoMessage() {}

func (x *MandateTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MandateTransaction.ProtoReflect.Descriptor instead.
func (*MandateTransaction) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{3}
}

func (x *MandateTransaction) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MandateTransaction) GetTransactionInfo() *TransactionInfo {
	if x != nil {
		return x.TransactionInfo
	}
	return nil
}

func (x *MandateTransaction) GetUniqueMandateNumber() string {
	if x != nil {
		return x.UniqueMandateNumber
	}
	return ""
}

func (x *MandateTransaction) GetPayerVpa() string {
	if x != nil {
		return x.PayerVpa
	}
	return ""
}

func (x *MandateTransaction) GetPayeeVpa() string {
	if x != nil {
		return x.PayeeVpa
	}
	return ""
}

func (x *MandateTransaction) GetPayeeMerchantId() string {
	if x != nil {
		return x.PayeeMerchantId
	}
	return ""
}

func (x *MandateTransaction) GetPayerMobileNumber() string {
	if x != nil {
		return x.PayerMobileNumber
	}
	return ""
}

func (x *MandateTransaction) GetPayeeMobileNumber() string {
	if x != nil {
		return x.PayeeMobileNumber
	}
	return ""
}

func (x *MandateTransaction) GetRecurrencePattern() MandateTransaction_RecurrencePatternType {
	if x != nil {
		return x.RecurrencePattern
	}
	return MandateTransaction_RECURRENCE_PATTERN_TYPE_UNSPECIFIED
}

func (x *MandateTransaction) GetRecurrenceRuleType() MandateTransaction_RecurrenceRuleType {
	if x != nil {
		return x.RecurrenceRuleType
	}
	return MandateTransaction_RECURRENCE_RULE_TYPE_UNSPECIFIED
}

func (x *MandateTransaction) GetRecurrenceRuleValue() int32 {
	if x != nil {
		return x.RecurrenceRuleValue
	}
	return 0
}

func (x *MandateTransaction) GetStartDate() *date.Date {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *MandateTransaction) GetEndDate() *date.Date {
	if x != nil {
		return x.EndDate
	}
	return nil
}

func (x *MandateTransaction) GetRevokable() bool {
	if x != nil {
		return x.Revokable
	}
	return false
}

func (x *MandateTransaction) GetAmount() float64 {
	if x != nil {
		return x.Amount
	}
	return 0
}

func (x *MandateTransaction) GetAmountRule() MandateTransaction_AmountRuleType {
	if x != nil {
		return x.AmountRule
	}
	return MandateTransaction_AMOUNT_RULE_TYPE_UNSPECIFIED
}

func (x *MandateTransaction) GetApprovalReference() string {
	if x != nil {
		return x.ApprovalReference
	}
	return ""
}

func (x *MandateTransaction) GetBlockFunds() bool {
	if x != nil {
		return x.BlockFunds
	}
	return false
}

// A complaint API transaction processed by the issuer switch. In
// UPI, this maps to the Complaint API.
type ComplaintTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the complaint transaction. This uniquely identifies the
	// transaction. Format of name is
	// projects/{project_id}/complaintTransactions/{complaint_transaction_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Information about the transaction.
	Info *TransactionInfo `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// Information about the complaint transaction. It can be one of Complaint or
	// Dispute.
	//
	// Types that are assignable to Case:
	//
	//	*ComplaintTransaction_Complaint
	//	*ComplaintTransaction_Dispute
	Case isComplaintTransaction_Case `protobuf_oneof:"case"`
}

func (x *ComplaintTransaction) Reset() {
	*x = ComplaintTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComplaintTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComplaintTransaction) ProtoMessage() {}

func (x *ComplaintTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComplaintTransaction.ProtoReflect.Descriptor instead.
func (*ComplaintTransaction) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{4}
}

func (x *ComplaintTransaction) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ComplaintTransaction) GetInfo() *TransactionInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (m *ComplaintTransaction) GetCase() isComplaintTransaction_Case {
	if m != nil {
		return m.Case
	}
	return nil
}

func (x *ComplaintTransaction) GetComplaint() *Complaint {
	if x, ok := x.GetCase().(*ComplaintTransaction_Complaint); ok {
		return x.Complaint
	}
	return nil
}

func (x *ComplaintTransaction) GetDispute() *Dispute {
	if x, ok := x.GetCase().(*ComplaintTransaction_Dispute); ok {
		return x.Dispute
	}
	return nil
}

type isComplaintTransaction_Case interface {
	isComplaintTransaction_Case()
}

type ComplaintTransaction_Complaint struct {
	// Output only. Information about the complaint transaction when it is of
	// type complaint.
	Complaint *Complaint `protobuf:"bytes,3,opt,name=complaint,proto3,oneof"`
}

type ComplaintTransaction_Dispute struct {
	// Output only. Information about the complaint transaction when it is of
	// type dispute.
	Dispute *Dispute `protobuf:"bytes,4,opt,name=dispute,proto3,oneof"`
}

func (*ComplaintTransaction_Complaint) isComplaintTransaction_Case() {}

func (*ComplaintTransaction_Dispute) isComplaintTransaction_Case() {}

// Request for the `ListMetadataTransactions` method. Callers can request for
// transactions to be filtered by the given filter criteria and specified
// pagination parameters.
type ListMetadataTransactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource. The format is `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of transactions to return. The service may return fewer
	// than this value. If unspecified or if the specified value is less than 1,
	// at most 50 transactions will be returned. The maximum value is 1000; values
	// above 1000 will be coerced to 1000. While paginating, you can specify a new
	// page size parameter for each page of transactions to be listed.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListMetadataTransactions` call.
	// Specify this parameter to retrieve the next page of transactions.
	//
	// When paginating, you must specify only the `page_token` parameter. The
	// filter that was specified in the initial call to the
	// `ListMetadataTransactions` method that returned the page token will be
	// reused for all further calls where the page token parameter is specified.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of metadata transactions.
	//
	// A filter expression consists of a field name, a comparison
	// operator, and a value for filtering. The value must be a string, a
	// number, or a boolean. The comparison operator must be one of: `<`, `>` or
	// `=`. Filters are not case sensitive.
	//
	// The following fields in the `MetadataTransaction` are eligible for
	// filtering:
	//
	//   - `apiType` - The API type of the metadata transaction. Must be one of
	//     [ApiType][google.cloud.paymentgateway.issuerswitch.v1.ApiType] values.
	//     Allowed comparison operators: `=`.
	//   - `transactionType` - The transaction type of the metadata transaction.
	//     Must be one of
	//     [TransactionType][google.cloud.paymentgateway.issuerswitch.v1.TransactionType]
	//     values. Allowed comparison operators: `=`.
	//   - `transactionID` - The UPI transaction ID of the metadata transaction.
	//     Allowed comparison operators: `=`.
	//   - `originVPA` - The VPA of the originator of a metadata transaction.
	//     Allowed comparison operators: `=`.
	//   - `createTime` - The time at which the transaction was created
	//     (received) by the issuer switch. The value should be in
	//     the format `YYYY-MM-DDTHH:MM:SSZ`. Allowed comparison operators: `>`,
	//     `<`.
	//   - `state` - The state of the transaction. Must be one of
	//     [TransactionInfo.State][google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.State]
	//     values. Allowed comparison operators: `=`.
	//   - `errorCode` - Use this filter to list financial transactions which
	//     have failed a particular error code. Allowed comparison operators:
	//     `=`.
	//   - `bankAdapterRequestID` - Request ID used when invoking the Bank
	//     Adapter API for fulfilling a transaction request. Allowed comparison
	//     operators: `=`.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. Expressions are combined with AND logic. No other logical
	// operators are supported.
	//
	// Here are a few examples:
	//
	//   - `apiType = LIST_ACCOUNTS` -  - The API type is _LIST_ACCOUNTS_.
	//   - `state = SUCCEEDED` - The transaction's state is _SUCCEEDED_.
	//   - `(apiType = LIST_ACCOUNTS) AND (create_time <
	//     \"2021-08-15T14:50:00Z\")` - The API type is _LIST_ACCOUNTS_ and
	//     the transaction was received before _2021-08-15 14:50:00 UTC_.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListMetadataTransactionsRequest) Reset() {
	*x = ListMetadataTransactionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMetadataTransactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataTransactionsRequest) ProtoMessage() {}

func (x *ListMetadataTransactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataTransactionsRequest.ProtoReflect.Descriptor instead.
func (*ListMetadataTransactionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{5}
}

func (x *ListMetadataTransactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMetadataTransactionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMetadataTransactionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMetadataTransactionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Request for the `ListFinancialTransactions` method. Callers can request for
// transactions to be filtered by the given filter criteria and specified
// pagination parameters.
type ListFinancialTransactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource. The format is `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of transactions to return. The service may return fewer
	// than this value. If unspecified or if the specified value is less than 1,
	// at most 50 transactions will be returned. The maximum value is 1000; values
	// above 1000 will be coerced to 1000. While paginating, you can specify a new
	// page size parameter for each page of transactions to be listed.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListFinancialTransactions` call.
	// Specify this parameter to retrieve the next page of transactions.
	//
	// When paginating, you must specify only the `page_token` parameter. The
	// filter that was specified in the initial call to the
	// `ListFinancialTransactions` method that returned the page token will be
	// reused for all further calls where the page token parameter is specified.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of financial transactions.
	//
	// A filter expression consists of a field name, a comparison operator, and
	// a value for filtering. The value must be a string, a number, or a
	// boolean. The comparison operator must be one of: `<`, `>`, or `=`.
	// Filters are not case sensitive.
	//
	// The following fields in the `FinancialTransaction` are eligible for
	// filtering:
	//
	//   - `transactionType` - The transaction type of the financial
	//     transaction. Must be one of
	//     [TransactionType][google.cloud.paymentgateway.issuerswitch.v1.TransactionType]
	//     values. For financial transactions, only valid transaction types are
	//     `TRANSACTION_TYPE_CREDIT`, `TRANSACTION_TYPE_DEBIT` and
	//     `TRANSACTION_TYPE_REVERSAL`. Allowed comparison operators: `=`.
	//   - `transactionID` - The UPI transaction ID of the financial
	//     transaction. Allowed comparison operators: `=`.
	//   - `RRN` - The retrieval reference number of the transaction. Allowed
	//     comparison operators: `=`.
	//   - `payerVPA` - The VPA of the payer in a financial transaction. Allowed
	//     comparison operators: `=`.
	//   - `payeeVPA` - The VPA of the payee in a financial transaction. Allowed
	//     comparison operators: `=`.
	//   - `payerMobileNumber` - The mobile number of the payer in a financial
	//     transaction. Allowed comparison operators: `=`.
	//   - `payeeMobileNumber` - The mobile number of the payee in a financial
	//     transaction. Allowed comparison operators: `=`.
	//   - `payeeMerchantId` - The merchant id of the payee in a financial
	//     transaction. Allowed comparison operators: `=`.
	//   - `createTime` - The time at which the transaction was created
	//     (received) by the issuer switch. The value should be in
	//     the format `YYYY-MM-DDTHH:MM:SSZ`. Allowed comparison operators: `>`,
	//     `<`.
	//   - `state` - The state of the transaction. Must be one of
	//     [TransactionInfo.State][google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.State]
	//     values. Allowed comparison operators: `=`.
	//   - `errorCode` - Use this filter to list financial transactions which
	//     have failed a particular error code. Allowed comparison operators: `=`.
	//   - `bankAdapterRequestID` - Request ID used when invoking the Bank
	//     Adapter API for fulfilling a transaction request. Allowed comparison
	//     operators: `=`.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. Expressions are combined with AND logic. No other logical
	// operators are supported.
	//
	// Here are a few examples:
	//
	//   - `transactionType = CREDIT` - The transaction type is _CREDIT_.
	//   - `state = SUCCEEDED` - The transaction's state is _SUCCEEDED_.
	//   - `payerVpa = example@okbank` - The VPA of the payer is the string
	//     _example@okbank_.
	//   - `(transactionType = DEBIT) AND (createTime < "2021-08-15T14:50:00Z")`
	//   - The transaction type is _DEBIT_ and the transaction was received
	//     before _2021-08-15 14:50:00 UTC_.
	//   - `createTime > "2021-08-15T14:50:00Z" AND createTime <
	//     "2021-08-16T14:50:00Z"` - The transaction was received between
	//     _2021-08-15 14:50:00 UTC_ and _2021-08-16 14:50:00 UTC_.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListFinancialTransactionsRequest) Reset() {
	*x = ListFinancialTransactionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFinancialTransactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFinancialTransactionsRequest) ProtoMessage() {}

func (x *ListFinancialTransactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFinancialTransactionsRequest.ProtoReflect.Descriptor instead.
func (*ListFinancialTransactionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{6}
}

func (x *ListFinancialTransactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFinancialTransactionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFinancialTransactionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFinancialTransactionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Request for the `ListMandateTransactions` method. Callers can request for
// transactions to be filtered by the given filter criteria and specified
// pagination parameters.
type ListMandateTransactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource. The format is `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of transactions to return. The service may return fewer
	// than this value. If unspecified or if the specified value is less than 1,
	// at most 50 transactions will be returned. The maximum value is 1000; values
	// above 1000 will be coerced to 1000. While paginating, you can specify a new
	// page size parameter for each page of transactions to be listed.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListMandateTransactions` call.
	// Specify this parameter to retrieve the next page of transactions.
	//
	// When paginating, you must specify only the `page_token` parameter. The
	// filter that was specified in the initial call to the
	// `ListMandateTransactions` method that returned the page token will be
	// reused for all further calls where the page token parameter is specified.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of mandate transactions.
	//
	// A filter expression consists of a field name, a comparison operator, and
	// a value for filtering. The value must be a string, a number, or a
	// boolean. The comparison operator must be one of: `<`, `>`, or `=`.
	// Filters are not case sensitive.
	//
	// The following fields in the `Mandate` are eligible for
	// filtering:
	//
	//   - `uniqueMandateNumber` - UPI Unique Mandate Number (UMN). Allowed
	//     comparison operators: `=`.
	//   - `transactionID` - The transaction ID of the mandate transaction.
	//     Allowed comparison operators: `=`.
	//   - `transactionType` - The transaction type of the mandate
	//     transaction. Must be one of
	//     [TransactionType][google.cloud.paymentgateway.issuerswitch.v1.TransactionType]
	//     values. For mandate transactions, only valid transaction types are
	//     `TRANSACTION_TYPE_CREATE`, `TRANSACTION_TYPE_REVOKE` and
	//     `TRANSACTION_TYPE_UPDATE`. Allowed comparison operators: `=`.
	//   - `payerVPA` - The VPA of the payer in a mandate transaction. Allowed
	//     comparison operators: `=`.
	//   - `payeeVPA` - The VPA of the payee in a mandate transaction. Allowed
	//     comparison operators: `=`.
	//   - `payeeMerchantID` - The merchant ID of the payee in a mandate
	//     transaction. Allowed comparison operators: `=`.
	//   - `payerMobileNumber` - The mobile number of the payer in a mandate
	//     transaction. Allowed comparison operators: `=`.
	//   - `payeeMobileNumber` - The mobile number of the payee in a mandate
	//     transaction. Allowed comparison operators: `=`.
	//   - `createTime` - The time at which the transaction was created
	//     (received) by the issuer switch. The value should be in
	//     the format `YYYY-MM-DDTHH:MM:SSZ`. Allowed comparison
	//     operators: `>`, `<`.
	//   - `state` - The state of the transaction. Must be one of
	//     [TransactionInfo.State][google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.State]
	//     values. Allowed comparison operators: `=`.
	//   - `recurrencePattern` - The recurrence pattern of the mandate. Must be
	//     one of
	//     [MandateTransaction.RecurrencePatternType][google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.RecurrencePatternType]
	//     values. Allowed comparison operators: `=`.
	//   - `startDate` - The start date of the mandate. The value should be in
	//     the format `YYYY-MM-DD`. Allowed comparison operators: `<` and `>`.
	//   - `endDate` - The end date of the mandate. The value should be in
	//     the format `YYYY-MM-DD`. Allowed comparison operators: `<` and `>`.
	//   - `errorCode` - Use this filter to list mandate transactions which
	//     have failed a particular error code. Allowed comparison
	//     operators: `=`.
	//   - `bankAdapterRequestID` - Request ID used when invoking the Bank
	//     Adapter API for fulfilling a transaction request. Allowed comparison
	//     operators: `=`.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. Expressions are combined with AND logic. No other logical
	// operators are supported.
	//
	// Here are a few examples:
	//   - `recurrencePattern = MONTHLY` - The recurrence pattern type is
	//     monthly.
	//   - `state = SUCCEEDED` - The transaction's state is _SUCCEEDED_.
	//   - `payerVPA = example@okbank` - The VPA of the payer is the string
	//     _example@okbank_.
	//   - `(payerVPA = example@okbank) AND (createTime <
	//     "2021-08-15T14:50:00Z")`
	//   - The payer VPA example@okbank and the transaction was received
	//     before _2021-08-15 14:50:00 UTC_.
	//   - `createTime > "2021-08-15T14:50:00Z" AND createTime <
	//     "2021-08-16T14:50:00Z"` - The transaction was received between
	//     _2021-08-15 14:50:00 UTC_ and _2021-08-16 14:50:00 UTC_.
	//   - `startDate > "2021-08-15" AND startDate < "2021-08-17"` - The start
	//     date for mandate is between _2021-08-15_ and _2021-08-17_.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListMandateTransactionsRequest) Reset() {
	*x = ListMandateTransactionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMandateTransactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMandateTransactionsRequest) ProtoMessage() {}

func (x *ListMandateTransactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMandateTransactionsRequest.ProtoReflect.Descriptor instead.
func (*ListMandateTransactionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{7}
}

func (x *ListMandateTransactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMandateTransactionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMandateTransactionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMandateTransactionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Request for the `ListComplaintTransactions` method. Callers can request for
// transactions to be filtered by the given filter criteria and specified
// pagination parameters.
type ListComplaintTransactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource. The format is `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of transactions to return. The service may return fewer
	// than this value. If unspecified or if the specified value is less than 1,
	// at most 50 transactions will be returned. The maximum value is 1000; values
	// above 1000 will be coerced to 1000. While paginating, you can specify a new
	// page size parameter for each page of transactions to be listed.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListComplaintTransactions` call.
	// Specify this parameter to retrieve the next page of transactions.
	//
	// When paginating, you must specify only the `page_token` parameter. The
	// filter that was specified in the initial call to the
	// `ListComplaintTransactions` method that returned the page token will be
	// reused for all further calls where the page token parameter is specified.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the list of complaint transactions.
	//
	// A filter expression consists of a field name, a comparison operator, and
	// a value for filtering. The value must be a string, a number, or a
	// boolean. The comparison operator must be one of: `<`, `>`, or `=`.
	// Filters are not case sensitive.
	//
	// The following fields in the `Complaint` are eligible for
	// filtering:
	//
	//   - `transactionID` - The transaction ID of the complaint transaction.
	//     Allowed comparison operators: `=`.
	//   - `transactionType` - The transaction type of the complaint
	//     transaction. Must be one of
	//     [TransactionType][google.cloud.paymentgateway.issuerswitch.v1.TransactionType]
	//     values. For complaint transactions, only valid transaction types are
	//     `TRANSACTION_TYPE_CHECK_STATUS`, `TRANSACTION_TYPE_COMPLAINT`,
	//     `TRANSACTION_TYPE_REVERSAL`, `TRANSACTION_TYPE_DISPUTE`,
	//     `TRANSACTION_TYPE_REFUND` or `TRANSACTION_TYPE_STATUS_UPDATE`. Allowed
	//     comparison operators: `=`.
	//   - `originalRRN` - The retrieval reference number of the original
	//     transaction for which complaint / dispute was raised / resolved. Allowed
	//     comparison operators: `=`.
	//   - `createTime` - The time at which the transaction was created
	//     (received) by the issuer switch. The value should be in
	//     the format `YYYY-MM-DDTHH:MM:SSZ`. Allowed comparison
	//     operators: `>`, `<`.
	//   - `state` - The state of the transaction. Must be one of
	//     [TransactionInfo.State][google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.State]
	//     values. Allowed comparison operators: `=`.
	//   - `errorCode` - Use this filter to list complaint transactions which
	//     have failed a particular error code. Allowed comparison
	//     operators: `=`.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. Expressions are combined with AND logic. No other logical
	// operators are supported.
	//
	// Here are a few examples:
	//
	//   - `state = SUCCEEDED` - The transaction's state is _SUCCEEDED_.
	//   - (createTime < "2021-08-15T14:50:00Z")`
	//   - The transaction was received before _2021-08-15 14:50:00 UTC_.
	//   - `createTime > "2021-08-15T14:50:00Z" AND createTime <
	//     "2021-08-16T14:50:00Z"` - The transaction was received between
	//     _2021-08-15 14:50:00 UTC_ and _2021-08-16 14:50:00 UTC_.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListComplaintTransactionsRequest) Reset() {
	*x = ListComplaintTransactionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListComplaintTransactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListComplaintTransactionsRequest) ProtoMessage() {}

func (x *ListComplaintTransactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListComplaintTransactionsRequest.ProtoReflect.Descriptor instead.
func (*ListComplaintTransactionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{8}
}

func (x *ListComplaintTransactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListComplaintTransactionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListComplaintTransactionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListComplaintTransactionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response for the `ListMetadataTransactions` method.
type ListMetadataTransactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of non financial metadata transactions satisfying the filtered
	// request.
	MetadataTransactions []*MetadataTransaction `protobuf:"bytes,1,rep,name=metadata_transactions,json=metadataTransactions,proto3" json:"metadata_transactions,omitempty"`
	// Pass this token in the ListMetadataTransactionsRequest to continue to list
	// results. If all results have been returned, this field is an empty string
	// or not present in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMetadataTransactionsResponse) Reset() {
	*x = ListMetadataTransactionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMetadataTransactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataTransactionsResponse) ProtoMessage() {}

func (x *ListMetadataTransactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataTransactionsResponse.ProtoReflect.Descriptor instead.
func (*ListMetadataTransactionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{9}
}

func (x *ListMetadataTransactionsResponse) GetMetadataTransactions() []*MetadataTransaction {
	if x != nil {
		return x.MetadataTransactions
	}
	return nil
}

func (x *ListMetadataTransactionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Response for the `ListFinancialTransactions` method.
type ListFinancialTransactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of financial transactions satisfying the filtered request.
	FinancialTransactions []*FinancialTransaction `protobuf:"bytes,1,rep,name=financial_transactions,json=financialTransactions,proto3" json:"financial_transactions,omitempty"`
	// Pass this token in the ListFinancialTransactionsRequest to continue to list
	// results. If all results have been returned, this field is an empty string
	// or not present in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFinancialTransactionsResponse) Reset() {
	*x = ListFinancialTransactionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFinancialTransactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFinancialTransactionsResponse) ProtoMessage() {}

func (x *ListFinancialTransactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFinancialTransactionsResponse.ProtoReflect.Descriptor instead.
func (*ListFinancialTransactionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{10}
}

func (x *ListFinancialTransactionsResponse) GetFinancialTransactions() []*FinancialTransaction {
	if x != nil {
		return x.FinancialTransactions
	}
	return nil
}

func (x *ListFinancialTransactionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Response for the `ListMandateTransactionsResponse` method.
type ListMandateTransactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of mandate transactions satisfying the filtered request.
	MandateTransactions []*MandateTransaction `protobuf:"bytes,1,rep,name=mandate_transactions,json=mandateTransactions,proto3" json:"mandate_transactions,omitempty"`
	// Pass this token in the ListMandateTransactionsRequest to continue to list
	// results. If all results have been returned, this field is an empty string
	// or not present in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMandateTransactionsResponse) Reset() {
	*x = ListMandateTransactionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMandateTransactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMandateTransactionsResponse) ProtoMessage() {}

func (x *ListMandateTransactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMandateTransactionsResponse.ProtoReflect.Descriptor instead.
func (*ListMandateTransactionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{11}
}

func (x *ListMandateTransactionsResponse) GetMandateTransactions() []*MandateTransaction {
	if x != nil {
		return x.MandateTransactions
	}
	return nil
}

func (x *ListMandateTransactionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Response for the `ListComplaintTransactionsResponse` method.
type ListComplaintTransactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of complaint transactions satisfying the filtered request.
	ComplaintTransactions []*ComplaintTransaction `protobuf:"bytes,1,rep,name=complaint_transactions,json=complaintTransactions,proto3" json:"complaint_transactions,omitempty"`
	// Pass this token in the ListComplaintTransactionsRequest to continue to list
	// results. If all results have been returned, this field is an empty string
	// or not present in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListComplaintTransactionsResponse) Reset() {
	*x = ListComplaintTransactionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListComplaintTransactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListComplaintTransactionsResponse) ProtoMessage() {}

func (x *ListComplaintTransactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListComplaintTransactionsResponse.ProtoReflect.Descriptor instead.
func (*ListComplaintTransactionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{12}
}

func (x *ListComplaintTransactionsResponse) GetComplaintTransactions() []*ComplaintTransaction {
	if x != nil {
		return x.ComplaintTransactions
	}
	return nil
}

func (x *ListComplaintTransactionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the `ExportFinancialTransactions` method.
type ExportFinancialTransactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the transactions. The format is
	// `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Transaction type for the financial transaction API. The possible values for
	// transaction type are
	//
	// * TRANSACTION_TYPE_CREDIT
	// * TRANSACTION_TYPE_DEBIT
	// * TRANSACTION_TYPE_REVERSAL
	//
	// If no transaction type is specified, records of all the above transaction
	// types will be exported.
	TransactionType TransactionType `protobuf:"varint,2,opt,name=transaction_type,json=transactionType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionType" json:"transaction_type,omitempty"`
	// The start time for the query.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time for the query.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ExportFinancialTransactionsRequest) Reset() {
	*x = ExportFinancialTransactionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportFinancialTransactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportFinancialTransactionsRequest) ProtoMessage() {}

func (x *ExportFinancialTransactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportFinancialTransactionsRequest.ProtoReflect.Descriptor instead.
func (*ExportFinancialTransactionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{13}
}

func (x *ExportFinancialTransactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportFinancialTransactionsRequest) GetTransactionType() TransactionType {
	if x != nil {
		return x.TransactionType
	}
	return TransactionType_TRANSACTION_TYPE_UNSPECIFIED
}

func (x *ExportFinancialTransactionsRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ExportFinancialTransactionsRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Request for the `ExportMetadataTransactions` method.
type ExportMetadataTransactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the transactions. The format is
	// `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// API type of the metadata transaction API. The possible values for API type
	// are
	//
	// * BALANCE
	// * CHECK_STATUS
	// * HEART_BEAT
	// * INITIATE_REGISTRATION
	// * LIST_ACCOUNTS
	// * UPDATE_CREDENTIALS
	// * VALIDATE_REGISTRATION
	//
	// If no API type is specified, records of all the above API types will be
	// exported.
	ApiType ApiType `protobuf:"varint,2,opt,name=api_type,json=apiType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.ApiType" json:"api_type,omitempty"`
	// The start time for the query.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time for the query.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ExportMetadataTransactionsRequest) Reset() {
	*x = ExportMetadataTransactionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMetadataTransactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMetadataTransactionsRequest) ProtoMessage() {}

func (x *ExportMetadataTransactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMetadataTransactionsRequest.ProtoReflect.Descriptor instead.
func (*ExportMetadataTransactionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{14}
}

func (x *ExportMetadataTransactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportMetadataTransactionsRequest) GetApiType() ApiType {
	if x != nil {
		return x.ApiType
	}
	return ApiType_API_TYPE_UNSPECIFIED
}

func (x *ExportMetadataTransactionsRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ExportMetadataTransactionsRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Request for the `ExportMandateTransactions` method.
type ExportMandateTransactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the transactions. The format is
	// `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Transaction type for the mandate transaction API.  The possible values for
	// transaction type are
	//
	// * TRANSACTION_TYPE_CREATE
	// * TRANSACTION_TYPE_REVOKE
	// * TRANSACTION_TYPE_UPDATE
	//
	// If no transaction type is specified, records of all the above transaction
	// types will be exported.
	TransactionType TransactionType `protobuf:"varint,2,opt,name=transaction_type,json=transactionType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionType" json:"transaction_type,omitempty"`
	// The start time for the query.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time for the query.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ExportMandateTransactionsRequest) Reset() {
	*x = ExportMandateTransactionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMandateTransactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMandateTransactionsRequest) ProtoMessage() {}

func (x *ExportMandateTransactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMandateTransactionsRequest.ProtoReflect.Descriptor instead.
func (*ExportMandateTransactionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{15}
}

func (x *ExportMandateTransactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportMandateTransactionsRequest) GetTransactionType() TransactionType {
	if x != nil {
		return x.TransactionType
	}
	return TransactionType_TRANSACTION_TYPE_UNSPECIFIED
}

func (x *ExportMandateTransactionsRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ExportMandateTransactionsRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Request for the `ExportComplaintTransactions` method.
type ExportComplaintTransactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the transactions. The format is
	// `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Transaction type for the complaint transaction API. The possible values for
	// transaction type are
	//
	// * TRANSACTION_TYPE_CHECK_STATUS
	// * TRANSACTION_TYPE_COMPLAINT
	// * TRANSACTION_TYPE_DISPUTE
	// * TRANSACTION_TYPE_REFUND
	// * TRANSACTION_TYPE_REVERSAL
	// * TRANSACTION_TYPE_STATUS_UPDATE
	//
	// If no transaction type is specified, records of all the above transaction
	// types will be exported.
	TransactionType TransactionType `protobuf:"varint,2,opt,name=transaction_type,json=transactionType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.TransactionType" json:"transaction_type,omitempty"`
	// The start time for the query.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time for the query.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ExportComplaintTransactionsRequest) Reset() {
	*x = ExportComplaintTransactionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportComplaintTransactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportComplaintTransactionsRequest) ProtoMessage() {}

func (x *ExportComplaintTransactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportComplaintTransactionsRequest.ProtoReflect.Descriptor instead.
func (*ExportComplaintTransactionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{16}
}

func (x *ExportComplaintTransactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportComplaintTransactionsRequest) GetTransactionType() TransactionType {
	if x != nil {
		return x.TransactionType
	}
	return TransactionType_TRANSACTION_TYPE_UNSPECIFIED
}

func (x *ExportComplaintTransactionsRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ExportComplaintTransactionsRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Response for the `ExportFinancialTransactions` method.
type ExportFinancialTransactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI of the exported file.
	TargetUri string `protobuf:"bytes,1,opt,name=target_uri,json=targetUri,proto3" json:"target_uri,omitempty"`
}

func (x *ExportFinancialTransactionsResponse) Reset() {
	*x = ExportFinancialTransactionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportFinancialTransactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportFinancialTransactionsResponse) ProtoMessage() {}

func (x *ExportFinancialTransactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportFinancialTransactionsResponse.ProtoReflect.Descriptor instead.
func (*ExportFinancialTransactionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{17}
}

func (x *ExportFinancialTransactionsResponse) GetTargetUri() string {
	if x != nil {
		return x.TargetUri
	}
	return ""
}

// Response for the `ExportMetadataTransactions` method.
type ExportMetadataTransactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI of the exported file.
	TargetUri string `protobuf:"bytes,1,opt,name=target_uri,json=targetUri,proto3" json:"target_uri,omitempty"`
}

func (x *ExportMetadataTransactionsResponse) Reset() {
	*x = ExportMetadataTransactionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMetadataTransactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMetadataTransactionsResponse) ProtoMessage() {}

func (x *ExportMetadataTransactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMetadataTransactionsResponse.ProtoReflect.Descriptor instead.
func (*ExportMetadataTransactionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{18}
}

func (x *ExportMetadataTransactionsResponse) GetTargetUri() string {
	if x != nil {
		return x.TargetUri
	}
	return ""
}

// Response for the `ExportMandateTransactions` method.
type ExportMandateTransactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI of the exported file.
	TargetUri string `protobuf:"bytes,1,opt,name=target_uri,json=targetUri,proto3" json:"target_uri,omitempty"`
}

func (x *ExportMandateTransactionsResponse) Reset() {
	*x = ExportMandateTransactionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMandateTransactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMandateTransactionsResponse) ProtoMessage() {}

func (x *ExportMandateTransactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMandateTransactionsResponse.ProtoReflect.Descriptor instead.
func (*ExportMandateTransactionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{19}
}

func (x *ExportMandateTransactionsResponse) GetTargetUri() string {
	if x != nil {
		return x.TargetUri
	}
	return ""
}

// Response for the `ExportComplaintTransactions` method.
type ExportComplaintTransactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI of the exported file.
	TargetUri string `protobuf:"bytes,1,opt,name=target_uri,json=targetUri,proto3" json:"target_uri,omitempty"`
}

func (x *ExportComplaintTransactionsResponse) Reset() {
	*x = ExportComplaintTransactionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportComplaintTransactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportComplaintTransactionsResponse) ProtoMessage() {}

func (x *ExportComplaintTransactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportComplaintTransactionsResponse.ProtoReflect.Descriptor instead.
func (*ExportComplaintTransactionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{20}
}

func (x *ExportComplaintTransactionsResponse) GetTargetUri() string {
	if x != nil {
		return x.TargetUri
	}
	return ""
}

// Metadata for ExportFinancialTransactions.
type ExportFinancialTransactionsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *ExportFinancialTransactionsMetadata) Reset() {
	*x = ExportFinancialTransactionsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportFinancialTransactionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportFinancialTransactionsMetadata) ProtoMessage() {}

func (x *ExportFinancialTransactionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportFinancialTransactionsMetadata.ProtoReflect.Descriptor instead.
func (*ExportFinancialTransactionsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{21}
}

func (x *ExportFinancialTransactionsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata for ExportMandateTransactions.
type ExportMandateTransactionsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *ExportMandateTransactionsMetadata) Reset() {
	*x = ExportMandateTransactionsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMandateTransactionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMandateTransactionsMetadata) ProtoMessage() {}

func (x *ExportMandateTransactionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMandateTransactionsMetadata.ProtoReflect.Descriptor instead.
func (*ExportMandateTransactionsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{22}
}

func (x *ExportMandateTransactionsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata for ExportMetadataTransactions.
type ExportMetadataTransactionsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *ExportMetadataTransactionsMetadata) Reset() {
	*x = ExportMetadataTransactionsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMetadataTransactionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMetadataTransactionsMetadata) ProtoMessage() {}

func (x *ExportMetadataTransactionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMetadataTransactionsMetadata.ProtoReflect.Descriptor instead.
func (*ExportMetadataTransactionsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{23}
}

func (x *ExportMetadataTransactionsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata for ExportComplaintTransactions.
type ExportComplaintTransactionsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *ExportComplaintTransactionsMetadata) Reset() {
	*x = ExportComplaintTransactionsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportComplaintTransactionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportComplaintTransactionsMetadata) ProtoMessage() {}

func (x *ExportComplaintTransactionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportComplaintTransactionsMetadata.ProtoReflect.Descriptor instead.
func (*ExportComplaintTransactionsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{24}
}

func (x *ExportComplaintTransactionsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Common metadata about an API transaction.
type TransactionInfo_TransactionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which the transaction resource was created by
	// the issuer switch.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the transaction resource was last updated
	// by the issuer switch.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. A reference id for the API transaction.
	ReferenceId string `protobuf:"bytes,3,opt,name=reference_id,json=referenceId,proto3" json:"reference_id,omitempty"`
	// Output only. A reference URI to this API transaction.
	ReferenceUri string `protobuf:"bytes,4,opt,name=reference_uri,json=referenceUri,proto3" json:"reference_uri,omitempty"`
	// Output only. A descriptive note about this API transaction.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *TransactionInfo_TransactionMetadata) Reset() {
	*x = TransactionInfo_TransactionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionInfo_TransactionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionInfo_TransactionMetadata) ProtoMessage() {}

func (x *TransactionInfo_TransactionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionInfo_TransactionMetadata.ProtoReflect.Descriptor instead.
func (*TransactionInfo_TransactionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{0, 0}
}

func (x *TransactionInfo_TransactionMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TransactionInfo_TransactionMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TransactionInfo_TransactionMetadata) GetReferenceId() string {
	if x != nil {
		return x.ReferenceId
	}
	return ""
}

func (x *TransactionInfo_TransactionMetadata) GetReferenceUri() string {
	if x != nil {
		return x.ReferenceUri
	}
	return ""
}

func (x *TransactionInfo_TransactionMetadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// All details about any error in the processing of an API transaction.
type TransactionInfo_TransactionErrorDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Error code of the failed transaction.
	ErrorCode string `protobuf:"bytes,1,opt,name=error_code,json=errorCode,proto3" json:"error_code,omitempty"`
	// Output only. Error description for the failed transaction.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Output only. Error code as per the UPI specification. The issuer switch
	// maps the ErrorCode to an appropriate error code that complies with the
	// UPI specification.
	UpiErrorCode string `protobuf:"bytes,3,opt,name=upi_error_code,json=upiErrorCode,proto3" json:"upi_error_code,omitempty"`
}

func (x *TransactionInfo_TransactionErrorDetails) Reset() {
	*x = TransactionInfo_TransactionErrorDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionInfo_TransactionErrorDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionInfo_TransactionErrorDetails) ProtoMessage() {}

func (x *TransactionInfo_TransactionErrorDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionInfo_TransactionErrorDetails.ProtoReflect.Descriptor instead.
func (*TransactionInfo_TransactionErrorDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{0, 1}
}

func (x *TransactionInfo_TransactionErrorDetails) GetErrorCode() string {
	if x != nil {
		return x.ErrorCode
	}
	return ""
}

func (x *TransactionInfo_TransactionErrorDetails) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *TransactionInfo_TransactionErrorDetails) GetUpiErrorCode() string {
	if x != nil {
		return x.UpiErrorCode
	}
	return ""
}

// Information about a bank adapter invocation triggered as part of the
// processing of an API transaction.
type TransactionInfo_BankAdapterInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of Request IDs (colon separated) used when
	// invoking the Bank Adapter APIs for fulfilling a transaction request.
	RequestIds string `protobuf:"bytes,1,opt,name=request_ids,json=requestIds,proto3" json:"request_ids,omitempty"`
	// Output only. Response metadata included by the bank adapter in its
	// response to an API invocation from the issuer switch.
	ResponseMetadata *TransactionInfo_BankAdapterInfo_ResponseMetadata `protobuf:"bytes,2,opt,name=response_metadata,json=responseMetadata,proto3" json:"response_metadata,omitempty"`
}

func (x *TransactionInfo_BankAdapterInfo) Reset() {
	*x = TransactionInfo_BankAdapterInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionInfo_BankAdapterInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionInfo_BankAdapterInfo) ProtoMessage() {}

func (x *TransactionInfo_BankAdapterInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionInfo_BankAdapterInfo.ProtoReflect.Descriptor instead.
func (*TransactionInfo_BankAdapterInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{0, 2}
}

func (x *TransactionInfo_BankAdapterInfo) GetRequestIds() string {
	if x != nil {
		return x.RequestIds
	}
	return ""
}

func (x *TransactionInfo_BankAdapterInfo) GetResponseMetadata() *TransactionInfo_BankAdapterInfo_ResponseMetadata {
	if x != nil {
		return x.ResponseMetadata
	}
	return nil
}

// Information about the transaction's risk evaluation as provided by the
// payments orchestrator.
type TransactionInfo_TransactionRiskInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entity providing the risk score. This could either be the payment service
	// provider or the payment orchestrator (UPI, etc).
	Provider string `protobuf:"bytes,1,opt,name=provider,proto3" json:"provider,omitempty"`
	// Type of risk. Examples include `TXNRISK`.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Numeric value of risk evaluation ranging from 0 (No Risk) to 100 (Maximum
	// Risk).
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *TransactionInfo_TransactionRiskInfo) Reset() {
	*x = TransactionInfo_TransactionRiskInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionInfo_TransactionRiskInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionInfo_TransactionRiskInfo) ProtoMessage() {}

func (x *TransactionInfo_TransactionRiskInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionInfo_TransactionRiskInfo.ProtoReflect.Descriptor instead.
func (*TransactionInfo_TransactionRiskInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{0, 3}
}

func (x *TransactionInfo_TransactionRiskInfo) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *TransactionInfo_TransactionRiskInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *TransactionInfo_TransactionRiskInfo) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Metadata about a response that the bank adapter includes in its response
// to the issuer switch.
type TransactionInfo_BankAdapterInfo_ResponseMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A map of name-value pairs.
	Values map[string]string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TransactionInfo_BankAdapterInfo_ResponseMetadata) Reset() {
	*x = TransactionInfo_BankAdapterInfo_ResponseMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionInfo_BankAdapterInfo_ResponseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionInfo_BankAdapterInfo_ResponseMetadata) ProtoMessage() {}

func (x *TransactionInfo_BankAdapterInfo_ResponseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionInfo_BankAdapterInfo_ResponseMetadata.ProtoReflect.Descriptor instead.
func (*TransactionInfo_BankAdapterInfo_ResponseMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *TransactionInfo_BankAdapterInfo_ResponseMetadata) GetValues() map[string]string {
	if x != nil {
		return x.Values
	}
	return nil
}

// A payment rule as provided by the payments orchestrator.
type FinancialTransaction_PaymentRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rule's name.
	PaymentRule FinancialTransaction_PaymentRule_PaymentRuleName `protobuf:"varint,1,opt,name=payment_rule,json=paymentRule,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction_PaymentRule_PaymentRuleName" json:"payment_rule,omitempty"`
	// The rule's value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *FinancialTransaction_PaymentRule) Reset() {
	*x = FinancialTransaction_PaymentRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinancialTransaction_PaymentRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinancialTransaction_PaymentRule) ProtoMessage() {}

func (x *FinancialTransaction_PaymentRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinancialTransaction_PaymentRule.ProtoReflect.Descriptor instead.
func (*FinancialTransaction_PaymentRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP(), []int{2, 0}
}

func (x *FinancialTransaction_PaymentRule) GetPaymentRule() FinancialTransaction_PaymentRule_PaymentRuleName {
	if x != nil {
		return x.PaymentRule
	}
	return FinancialTransaction_PaymentRule_PAYMENT_RULE_NAME_UNSPECIFIED
}

func (x *FinancialTransaction_PaymentRule) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto protoreflect.FileDescriptor

var file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9b, 0x10, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x13, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x54, 0x0a, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x69, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61,
	0x70, 0x69, 0x54, 0x79, 0x70, 0x65, 0x12, 0x6c, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x86, 0x01, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5d, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x6c, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7e, 0x0a, 0x0d, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x7d, 0x0a, 0x11, 0x62, 0x61,
	0x6e, 0x6b, 0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x2e, 0x42, 0x61, 0x6e, 0x6b, 0x41, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x49,
	0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x62, 0x61, 0x6e, 0x6b, 0x41, 0x64,
	0x61, 0x70, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x6d, 0x0a, 0x09, 0x72, 0x69, 0x73,
	0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x69, 0x73, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08,
	0x72, 0x69, 0x73, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x92, 0x02, 0x0a, 0x13, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x92, 0x01,
	0x0a, 0x17, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x29, 0x0a, 0x0e, 0x75, 0x70, 0x69, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x75, 0x70, 0x69, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f,
	0x64, 0x65, 0x1a, 0x9d, 0x03, 0x0a, 0x0f, 0x42, 0x61, 0x6e, 0x6b, 0x41, 0x64, 0x61, 0x70, 0x74,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x73, 0x12, 0x8f, 0x01, 0x0a,
	0x11, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x42, 0x61, 0x6e, 0x6b, 0x41, 0x64, 0x61, 0x70, 0x74,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0xd1,
	0x01, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x81, 0x01, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x42, 0x61, 0x6e, 0x6b, 0x41, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x5b, 0x0a, 0x13, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x69, 0x73, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x48, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x49,
	0x4d, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x03, 0x22, 0x7a, 0x0a, 0x12, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x24, 0x0a, 0x20, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53,
	0x55, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x42, 0x49, 0x54, 0x10, 0x02, 0x12, 0x07, 0x0a,
	0x03, 0x50, 0x41, 0x59, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x45, 0x4e, 0x45, 0x46, 0x49,
	0x43, 0x49, 0x41, 0x52, 0x59, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4d, 0x49, 0x54,
	0x54, 0x45, 0x52, 0x10, 0x05, 0x22, 0xc5, 0x02, 0x0a, 0x13, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x50, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04, 0x69,
	0x6e, 0x66, 0x6f, 0x12, 0x5b, 0x0a, 0x09, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x6f, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x6f, 0x72,
	0x3a, 0x6b, 0xea, 0x41, 0x68, 0x0a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0x92, 0x07,
	0x0a, 0x14, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x04, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x41, 0x0a, 0x1a,
	0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x5d, 0x0a, 0x05, 0x70, 0x61, 0x79, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x70, 0x61, 0x79, 0x65, 0x72, 0x12, 0x5d,
	0x0a, 0x05, 0x70, 0x61, 0x79, 0x65, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x70, 0x61, 0x79, 0x65, 0x65, 0x12, 0x2f, 0x0a,
	0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x72,
	0x0a, 0x0d, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x0c, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x1a, 0xfe, 0x01, 0x0a, 0x0b, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x75,
	0x6c, 0x65, 0x12, 0x80, 0x01, 0x0a, 0x0c, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72,
	0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77,
	0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61,
	0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x75, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x0b, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x56, 0x0a, 0x0f, 0x50,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x1d, 0x50, 0x41, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x4e,
	0x41, 0x4d, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x5f, 0x41, 0x46, 0x54, 0x45,
	0x52, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x49, 0x4e, 0x5f, 0x41, 0x4d, 0x4f, 0x55, 0x4e,
	0x54, 0x10, 0x02, 0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x30, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x22, 0xd5, 0x0c, 0x0a, 0x12, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x67, 0x0a,
	0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x37, 0x0a, 0x15, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x5f, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x79, 0x65, 0x72, 0x5f, 0x76, 0x70, 0x61, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x61, 0x79, 0x65, 0x72, 0x56, 0x70,
	0x61, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x79, 0x65, 0x65, 0x5f, 0x76, 0x70, 0x61, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x61, 0x79, 0x65, 0x65,
	0x56, 0x70, 0x61, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x61, 0x79, 0x65, 0x65, 0x5f, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x61, 0x79, 0x65, 0x65, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x61, 0x79, 0x65, 0x72, 0x5f, 0x6d, 0x6f,
	0x62, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x70, 0x61, 0x79, 0x65, 0x72, 0x4d, 0x6f, 0x62,
	0x69, 0x6c, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x61, 0x79,
	0x65, 0x65, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x70, 0x61, 0x79,
	0x65, 0x65, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x89,
	0x01, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x89, 0x01, 0x0a, 0x14, 0x72,
	0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77,
	0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x12, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x37, 0x0a, 0x15, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x72, 0x65, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x35, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x31, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x72, 0x65, 0x76,
	0x6f, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x06,
	0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x74, 0x0a, 0x0b, 0x61, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x12,
	0x32, 0x0a, 0x12, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x11, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x66, 0x75, 0x6e,
	0x64, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x46, 0x75, 0x6e, 0x64, 0x73, 0x22, 0xd0, 0x01, 0x0a, 0x15, 0x52, 0x65,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x45, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43,
	0x45, 0x5f, 0x50, 0x41, 0x54, 0x54, 0x45, 0x52, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x41, 0x53, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x42, 0x49, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x09, 0x0a,
	0x05, 0x44, 0x41, 0x49, 0x4c, 0x59, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x46, 0x4f, 0x52, 0x54,
	0x4e, 0x49, 0x47, 0x48, 0x54, 0x4c, 0x59, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x41, 0x4c,
	0x46, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x4c, 0x59, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f,
	0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x4e, 0x45, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x51, 0x55, 0x41, 0x52, 0x54, 0x45, 0x52,
	0x4c, 0x59, 0x10, 0x08, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x45, 0x45, 0x4b, 0x4c, 0x59, 0x10, 0x09,
	0x12, 0x0a, 0x0a, 0x06, 0x59, 0x45, 0x41, 0x52, 0x4c, 0x59, 0x10, 0x0a, 0x22, 0x59, 0x0a, 0x12,
	0x52, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x52, 0x45, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x45,
	0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x46, 0x54, 0x45,
	0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x45, 0x46, 0x4f, 0x52, 0x45, 0x10, 0x02, 0x12,
	0x06, 0x0a, 0x02, 0x4f, 0x4e, 0x10, 0x03, 0x22, 0x46, 0x0a, 0x0e, 0x41, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x4d, 0x4f,
	0x55, 0x4e, 0x54, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x58, 0x41, 0x43, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x41, 0x58, 0x10, 0x02, 0x3a,
	0x69, 0xea, 0x41, 0x66, 0x0a, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xa7, 0x03, 0x0a, 0x14, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x5b, 0x0a, 0x09, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x09, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x55, 0x0a, 0x07, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x07, 0x64, 0x69, 0x73, 0x70, 0x75, 0x74, 0x65, 0x3a, 0x6d, 0xea,
	0x41, 0x6a, 0x0a, 0x30, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69,
	0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x06, 0x0a, 0x04,
	0x63, 0x61, 0x73, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31,
	0x12, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xc8, 0x01,
	0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61,
	0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xc4, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x30, 0x12, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22,
	0xc8, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61,
	0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xc1, 0x01, 0x0a, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x75, 0x0a, 0x15, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x14, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc5,
	0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x78, 0x0a, 0x16, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61,
	0x6c, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbd, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x72, 0x0a, 0x14, 0x6d, 0x61,
	0x6e, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6d, 0x61, 0x6e, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc5, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x78, 0x0a, 0x16,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x15, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9c,
	0x02, 0x0a, 0x22, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x67, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x83, 0x02,
	0x0a, 0x21, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x4f, 0x0a, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x69, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x61, 0x70, 0x69, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x9a, 0x02, 0x0a, 0x20, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61,
	0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x67, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x9c, 0x02, 0x0a, 0x22, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x67, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x44, 0x0a, 0x23, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x55, 0x72, 0x69, 0x22, 0x43, 0x0a, 0x22, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x55, 0x72, 0x69, 0x22, 0x42, 0x0a, 0x21, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x55, 0x72, 0x69, 0x22, 0x44,
	0x0a, 0x23, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x55, 0x72, 0x69, 0x22, 0x67, 0x0a, 0x23, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x69,
	0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x65, 0x0a,
	0x21, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x22, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x67, 0x0a, 0x23,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x32, 0xc0, 0x11, 0x0a, 0x18, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0xf6, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xfa, 0x01, 0x0a, 0x19,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77,
	0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x61,
	0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x61, 0x6e,
	0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f,
	0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63,
	0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf2, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xfa, 0x01,
	0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x9c, 0x02, 0x0a, 0x1b, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x39, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e,
	0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x4a, 0x0a,
	0x23, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x61,
	0x6e, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x97, 0x02, 0x0a, 0x1a, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38,
	0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x48, 0x0a, 0x22, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x22, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x92, 0x02, 0x0a, 0x19, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61,
	0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x86, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xca,
	0x41, 0x46, 0x0a, 0x21, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x6e,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x9c, 0x02, 0x0a, 0x1b, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x4a, 0x0a, 0x23, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x23, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x61,
	0x69, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x4f, 0xca, 0x41, 0x1b, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xad, 0x02, 0x0a, 0x2f, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x57, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x3b, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0xaa, 0x02, 0x2b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x3a, 0x3a, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77,
	0x69, 0x74, 0x63, 0x68, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescOnce sync.Once
	file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescData = file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDesc
)

func file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescGZIP() []byte {
	file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescOnce.Do(func() {
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescData)
	})
	return file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDescData
}

var file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes = make([]protoimpl.MessageInfo, 32)
var file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_goTypes = []interface{}{
	(TransactionInfo_State)(0),                               // 0: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.State
	(TransactionInfo_TransactionSubType)(0),                  // 1: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionSubType
	(FinancialTransaction_PaymentRule_PaymentRuleName)(0),    // 2: google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.PaymentRule.PaymentRuleName
	(MandateTransaction_RecurrencePatternType)(0),            // 3: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.RecurrencePatternType
	(MandateTransaction_RecurrenceRuleType)(0),               // 4: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.RecurrenceRuleType
	(MandateTransaction_AmountRuleType)(0),                   // 5: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.AmountRuleType
	(*TransactionInfo)(nil),                                  // 6: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo
	(*MetadataTransaction)(nil),                              // 7: google.cloud.paymentgateway.issuerswitch.v1.MetadataTransaction
	(*FinancialTransaction)(nil),                             // 8: google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction
	(*MandateTransaction)(nil),                               // 9: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction
	(*ComplaintTransaction)(nil),                             // 10: google.cloud.paymentgateway.issuerswitch.v1.ComplaintTransaction
	(*ListMetadataTransactionsRequest)(nil),                  // 11: google.cloud.paymentgateway.issuerswitch.v1.ListMetadataTransactionsRequest
	(*ListFinancialTransactionsRequest)(nil),                 // 12: google.cloud.paymentgateway.issuerswitch.v1.ListFinancialTransactionsRequest
	(*ListMandateTransactionsRequest)(nil),                   // 13: google.cloud.paymentgateway.issuerswitch.v1.ListMandateTransactionsRequest
	(*ListComplaintTransactionsRequest)(nil),                 // 14: google.cloud.paymentgateway.issuerswitch.v1.ListComplaintTransactionsRequest
	(*ListMetadataTransactionsResponse)(nil),                 // 15: google.cloud.paymentgateway.issuerswitch.v1.ListMetadataTransactionsResponse
	(*ListFinancialTransactionsResponse)(nil),                // 16: google.cloud.paymentgateway.issuerswitch.v1.ListFinancialTransactionsResponse
	(*ListMandateTransactionsResponse)(nil),                  // 17: google.cloud.paymentgateway.issuerswitch.v1.ListMandateTransactionsResponse
	(*ListComplaintTransactionsResponse)(nil),                // 18: google.cloud.paymentgateway.issuerswitch.v1.ListComplaintTransactionsResponse
	(*ExportFinancialTransactionsRequest)(nil),               // 19: google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsRequest
	(*ExportMetadataTransactionsRequest)(nil),                // 20: google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsRequest
	(*ExportMandateTransactionsRequest)(nil),                 // 21: google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsRequest
	(*ExportComplaintTransactionsRequest)(nil),               // 22: google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsRequest
	(*ExportFinancialTransactionsResponse)(nil),              // 23: google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsResponse
	(*ExportMetadataTransactionsResponse)(nil),               // 24: google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsResponse
	(*ExportMandateTransactionsResponse)(nil),                // 25: google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsResponse
	(*ExportComplaintTransactionsResponse)(nil),              // 26: google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsResponse
	(*ExportFinancialTransactionsMetadata)(nil),              // 27: google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsMetadata
	(*ExportMandateTransactionsMetadata)(nil),                // 28: google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsMetadata
	(*ExportMetadataTransactionsMetadata)(nil),               // 29: google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsMetadata
	(*ExportComplaintTransactionsMetadata)(nil),              // 30: google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsMetadata
	(*TransactionInfo_TransactionMetadata)(nil),              // 31: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionMetadata
	(*TransactionInfo_TransactionErrorDetails)(nil),          // 32: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionErrorDetails
	(*TransactionInfo_BankAdapterInfo)(nil),                  // 33: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.BankAdapterInfo
	(*TransactionInfo_TransactionRiskInfo)(nil),              // 34: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionRiskInfo
	(*TransactionInfo_BankAdapterInfo_ResponseMetadata)(nil), // 35: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.BankAdapterInfo.ResponseMetadata
	nil,                                      // 36: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.BankAdapterInfo.ResponseMetadata.ValuesEntry
	(*FinancialTransaction_PaymentRule)(nil), // 37: google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.PaymentRule
	(ApiType)(0),                             // 38: google.cloud.paymentgateway.issuerswitch.v1.ApiType
	(TransactionType)(0),                     // 39: google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	(*Participant)(nil),                      // 40: google.cloud.paymentgateway.issuerswitch.v1.Participant
	(*SettlementParticipant)(nil),            // 41: google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant
	(*money.Money)(nil),                      // 42: google.type.Money
	(*date.Date)(nil),                        // 43: google.type.Date
	(*Complaint)(nil),                        // 44: google.cloud.paymentgateway.issuerswitch.v1.Complaint
	(*Dispute)(nil),                          // 45: google.cloud.paymentgateway.issuerswitch.v1.Dispute
	(*timestamppb.Timestamp)(nil),            // 46: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),            // 47: google.longrunning.Operation
}
var file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_depIdxs = []int32{
	38, // 0: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.api_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ApiType
	39, // 1: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.transaction_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	1,  // 2: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.transaction_sub_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionSubType
	0,  // 3: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.state:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.State
	31, // 4: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.metadata:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionMetadata
	32, // 5: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.error_details:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionErrorDetails
	33, // 6: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.bank_adapter_info:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.BankAdapterInfo
	34, // 7: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.risk_info:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionRiskInfo
	6,  // 8: google.cloud.paymentgateway.issuerswitch.v1.MetadataTransaction.info:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo
	40, // 9: google.cloud.paymentgateway.issuerswitch.v1.MetadataTransaction.initiator:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Participant
	6,  // 10: google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.info:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo
	41, // 11: google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.payer:type_name -> google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant
	41, // 12: google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.payee:type_name -> google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant
	42, // 13: google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.amount:type_name -> google.type.Money
	37, // 14: google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.payment_rules:type_name -> google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.PaymentRule
	6,  // 15: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.transaction_info:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo
	3,  // 16: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.recurrence_pattern:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.RecurrencePatternType
	4,  // 17: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.recurrence_rule_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.RecurrenceRuleType
	43, // 18: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.start_date:type_name -> google.type.Date
	43, // 19: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.end_date:type_name -> google.type.Date
	5,  // 20: google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.amount_rule:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.AmountRuleType
	6,  // 21: google.cloud.paymentgateway.issuerswitch.v1.ComplaintTransaction.info:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo
	44, // 22: google.cloud.paymentgateway.issuerswitch.v1.ComplaintTransaction.complaint:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Complaint
	45, // 23: google.cloud.paymentgateway.issuerswitch.v1.ComplaintTransaction.dispute:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Dispute
	7,  // 24: google.cloud.paymentgateway.issuerswitch.v1.ListMetadataTransactionsResponse.metadata_transactions:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MetadataTransaction
	8,  // 25: google.cloud.paymentgateway.issuerswitch.v1.ListFinancialTransactionsResponse.financial_transactions:type_name -> google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction
	9,  // 26: google.cloud.paymentgateway.issuerswitch.v1.ListMandateTransactionsResponse.mandate_transactions:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction
	10, // 27: google.cloud.paymentgateway.issuerswitch.v1.ListComplaintTransactionsResponse.complaint_transactions:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ComplaintTransaction
	39, // 28: google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsRequest.transaction_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	46, // 29: google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsRequest.start_time:type_name -> google.protobuf.Timestamp
	46, // 30: google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsRequest.end_time:type_name -> google.protobuf.Timestamp
	38, // 31: google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsRequest.api_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.ApiType
	46, // 32: google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsRequest.start_time:type_name -> google.protobuf.Timestamp
	46, // 33: google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsRequest.end_time:type_name -> google.protobuf.Timestamp
	39, // 34: google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsRequest.transaction_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	46, // 35: google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsRequest.start_time:type_name -> google.protobuf.Timestamp
	46, // 36: google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsRequest.end_time:type_name -> google.protobuf.Timestamp
	39, // 37: google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsRequest.transaction_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	46, // 38: google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsRequest.start_time:type_name -> google.protobuf.Timestamp
	46, // 39: google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsRequest.end_time:type_name -> google.protobuf.Timestamp
	46, // 40: google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsMetadata.create_time:type_name -> google.protobuf.Timestamp
	46, // 41: google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsMetadata.create_time:type_name -> google.protobuf.Timestamp
	46, // 42: google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsMetadata.create_time:type_name -> google.protobuf.Timestamp
	46, // 43: google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsMetadata.create_time:type_name -> google.protobuf.Timestamp
	46, // 44: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionMetadata.create_time:type_name -> google.protobuf.Timestamp
	46, // 45: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.TransactionMetadata.update_time:type_name -> google.protobuf.Timestamp
	35, // 46: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.BankAdapterInfo.response_metadata:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.BankAdapterInfo.ResponseMetadata
	36, // 47: google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.BankAdapterInfo.ResponseMetadata.values:type_name -> google.cloud.paymentgateway.issuerswitch.v1.TransactionInfo.BankAdapterInfo.ResponseMetadata.ValuesEntry
	2,  // 48: google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.PaymentRule.payment_rule:type_name -> google.cloud.paymentgateway.issuerswitch.v1.FinancialTransaction.PaymentRule.PaymentRuleName
	11, // 49: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ListMetadataTransactions:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ListMetadataTransactionsRequest
	12, // 50: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ListFinancialTransactions:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ListFinancialTransactionsRequest
	13, // 51: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ListMandateTransactions:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ListMandateTransactionsRequest
	14, // 52: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ListComplaintTransactions:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ListComplaintTransactionsRequest
	19, // 53: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ExportFinancialTransactions:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsRequest
	20, // 54: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ExportMetadataTransactions:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsRequest
	21, // 55: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ExportMandateTransactions:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsRequest
	22, // 56: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ExportComplaintTransactions:input_type -> google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsRequest
	15, // 57: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ListMetadataTransactions:output_type -> google.cloud.paymentgateway.issuerswitch.v1.ListMetadataTransactionsResponse
	16, // 58: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ListFinancialTransactions:output_type -> google.cloud.paymentgateway.issuerswitch.v1.ListFinancialTransactionsResponse
	17, // 59: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ListMandateTransactions:output_type -> google.cloud.paymentgateway.issuerswitch.v1.ListMandateTransactionsResponse
	18, // 60: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ListComplaintTransactions:output_type -> google.cloud.paymentgateway.issuerswitch.v1.ListComplaintTransactionsResponse
	47, // 61: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ExportFinancialTransactions:output_type -> google.longrunning.Operation
	47, // 62: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ExportMetadataTransactions:output_type -> google.longrunning.Operation
	47, // 63: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ExportMandateTransactions:output_type -> google.longrunning.Operation
	47, // 64: google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions.ExportComplaintTransactions:output_type -> google.longrunning.Operation
	57, // [57:65] is the sub-list for method output_type
	49, // [49:57] is the sub-list for method input_type
	49, // [49:49] is the sub-list for extension type_name
	49, // [49:49] is the sub-list for extension extendee
	0,  // [0:49] is the sub-list for field type_name
}

func init() { file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_init() }
func file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_init() {
	if File_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto != nil {
		return
	}
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_init()
	file_google_cloud_paymentgateway_issuerswitch_v1_resolutions_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinancialTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MandateTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComplaintTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMetadataTransactionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFinancialTransactionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMandateTransactionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListComplaintTransactionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMetadataTransactionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFinancialTransactionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMandateTransactionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListComplaintTransactionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportFinancialTransactionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMetadataTransactionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMandateTransactionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportComplaintTransactionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportFinancialTransactionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMetadataTransactionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMandateTransactionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportComplaintTransactionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportFinancialTransactionsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMandateTransactionsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMetadataTransactionsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportComplaintTransactionsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionInfo_TransactionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionInfo_TransactionErrorDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionInfo_BankAdapterInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionInfo_TransactionRiskInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionInfo_BankAdapterInfo_ResponseMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinancialTransaction_PaymentRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ComplaintTransaction_Complaint)(nil),
		(*ComplaintTransaction_Dispute)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   32,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_goTypes,
		DependencyIndexes: file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_depIdxs,
		EnumInfos:         file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_enumTypes,
		MessageInfos:      file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_msgTypes,
	}.Build()
	File_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto = out.File
	file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_rawDesc = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_goTypes = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_transactions_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IssuerSwitchTransactionsClient is the client API for IssuerSwitchTransactions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IssuerSwitchTransactionsClient interface {
	// List metadata transactions that satisfy the specified filter criteria.
	ListMetadataTransactions(ctx context.Context, in *ListMetadataTransactionsRequest, opts ...grpc.CallOption) (*ListMetadataTransactionsResponse, error)
	// List financial transactions that satisfy specified filter criteria.
	ListFinancialTransactions(ctx context.Context, in *ListFinancialTransactionsRequest, opts ...grpc.CallOption) (*ListFinancialTransactionsResponse, error)
	// List mandate transactions that satisfy specified filter criteria.
	ListMandateTransactions(ctx context.Context, in *ListMandateTransactionsRequest, opts ...grpc.CallOption) (*ListMandateTransactionsResponse, error)
	// List complaint transactions that satisfy specified filter criteria.
	ListComplaintTransactions(ctx context.Context, in *ListComplaintTransactionsRequest, opts ...grpc.CallOption) (*ListComplaintTransactionsResponse, error)
	// Export financial transactions received within the specified time range as a
	// file into a configured target location. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`:
	// [ExportFinancialTransactionsMetadata][google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsMetadata]
	// - `response`:
	// [ExportFinancialTransactionsResponse][google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsResponse]
	//
	// The exported file will be in the standard CSV format where each row in the
	// file represents a transaction. The file has the following fields in order:
	//
	// 1. `TransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - UPI transaction ID.
	//
	// 1. `TransactionType`
	//   - **Min Length** - 22 characters
	//   - **Max Length** - 25 characters
	//   - **Description** - Type of the transaction. This will be one of
	//     `TRANSACTION_TYPE_CREDIT`, `TRANSACTION_TYPE_DEBIT` or
	//     `TRANSACTION_TYPE_REVERSAL`.
	//
	// 1. `TransactionSubType`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 7 characters
	//   - **Description** - Subtype of the transaction. This will be one of
	//     `COLLECT`, or `PAY`.
	//
	// 1. `CreationTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when the issuer
	//     switch created the transaction resource for processing the transaction.
	//     The format will be as per RFC-3339. Example : 2022-11-22T23:00:05Z
	//
	// 1. `State`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - State of the transaction. This will be one of
	//     `FAILED`, `SUCCEEDED`, or `TIMED_OUT`.
	//
	// 1. `RRN`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Retrieval reference number associated with the
	//     transaction.
	//
	// 1. `PayerVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the payer.
	//
	// 1. `PayerMobileNumber`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Mobile number of the payer.
	//
	// 1. `PayerIFSC`
	//   - **Min Length** - 11 characters
	//   - **Max Length** - 11 characters
	//   - **Description** - IFSC of the payer's bank account.
	//
	// 1. `PayerAccountNumber`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 30 characters
	//   - **Description** - Payer's bank account number.
	//
	// 1. `PayerAccountType`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 7 characters
	//   - **Description** - Payer's bank account type. This will be one of
	//     `SAVINGS`, `DEFAULT`, `CURRENT`, `NRE`, `NRO`, `PPIWALLET`,
	//     `BANKWALLET`, `CREDIT`, `SOD`, or `UOD`.
	//
	// 1. `PayeeVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the payee.
	//
	// 1. `PayeeMobileNumber`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Payee's mobile number.
	//
	// 1. `PayeeIFSC`
	//   - **Min Length** - 11 characters
	//   - **Max Length** - 11 characters
	//   - **Description** - IFSC of the payee's bank account.
	//
	// 1. `PayeeAccountNumber`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 30 characters
	//   - **Description** - Payee's bank account number.
	//
	// 1. `PayeeAccountType`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 10 characters
	//   - **Description** - Payee's bank account type. This will be one of
	//     `SAVINGS`, `DEFAULT`, `CURRENT`, `NRE`, `NRO`, `PPIWALLET`,
	//     `BANKWALLET`, `CREDIT`, `SOD`, or `UOD`.
	//
	// 1. `PayeeMerchantID`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Payee's merchant ID, only if the payee is a
	//     merchant.
	//
	// 1. `PayeeMerchantName`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Payee's merchant name, only if the payee is a
	//     merchant.
	//
	// 1. `PayeeMCC`
	//   - **Min Length** - 4 characters
	//   - **Max Length** - 4 characters
	//   - **Description** - Payee's Merchant Category Code (MCC), only if the
	//     payee is a merchant.
	//
	// 1. `Currency`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Currency of the amount involved in the transaction.
	//     The currency codes are defined in ISO 4217.
	//
	// 1. `Amount`
	//   - **Description** - Amount involved in the transaction.
	//
	// 1. `BankAdapterRequestIDs`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2,000 characters
	//   - **Description** - List of Request IDs (colon separated) used when
	//     invoking the Bank Adapter APIs for fulfilling a transaction request.
	//
	// 1. `ErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Error code of a failed transaction.
	//
	// 1. `ErrorMessage`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 10,000 characters
	//   - **Description** - Error description for a failed transaction.
	//
	// 1. `UPIErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Error code as per the UPI specification. The issuer
	//     switch maps the ErrorCode to an appropriate error code that complies
	//     with the UPI specification.
	//
	// 1. `PayerDeviceInfoTypeAppName`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Payment application name on the payer's device.
	//
	// 1. `PayerDeviceInfoTypeCapability`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Capability of the payer's device.
	//
	// 1. `PayerDeviceInfoTypeGeoCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 15 characters
	//   - **Description** - Geo code of the payer's device. This will include
	//     floating point values for latitude and longitude (separated by colon).
	//
	// 1. `PayerDeviceInfoTypeID`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - Device ID of the payer's device.
	//
	// 1. `PayerDeviceInfoTypeIP`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 39 characters
	//   - **Description** - IP address of the payer's device.
	//
	// 1. `PayerDeviceInfoTypeLocation`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 40 characters
	//   - **Description** - Coarse location of the payer's device.
	//
	// 1. `PayerDeviceInfoTypeOS`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Operating system on the payer's device.
	//
	// 1. `PayerDeviceInfoTypeTelecomProvider`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Telecom provider for the payer's device.
	//
	// 1. `PayerDeviceInfoTypeDeviceType`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - Type of the payer's device. This will be one of
	//     'MOB', 'INET', 'USDC/USDB', 'POS'.
	//
	// 1. `PayeeDeviceInfoTypeAppName`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Payment application name on the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeCapability`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Capability of the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeGeoCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 15 characters
	//   - **Description** - Geo code of the payee's device. This will include
	//     floating point values for latitude and longitude (separated by colon).
	//
	// 1. `PayeeDeviceInfoTypeID`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - Device ID of the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeIP`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 39 characters
	//   - **Description** - IP address of the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeLocation`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 40 characters
	//   - **Description** - Coarse location of the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeOS`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Operating system on the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeTelecomProvider`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Telecom provider for the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeDeviceType`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - Type of the payee's device. This will be one of
	//     'MOB', 'INET', 'USDC/USDB', 'POS'.
	ExportFinancialTransactions(ctx context.Context, in *ExportFinancialTransactionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Export metadata transactions received within the specified time range as a
	// file into a configured target location. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`:
	// [ExportMetadataTransactionsMetadata][google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsMetadata]
	// - `response`:
	// [ExportMetadataTransactionsResponse][google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsResponse]
	//
	// The exported file will be in the standard CSV format where each row in the
	// file represents a transaction. The file has the following fields in order:
	//
	// 1. `TransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - UPI transaction ID.
	//
	// 1. `APIType`
	//   - **Description** - The transaction's API type. The value will be of
	//     the [ApiType][google.cloud.paymentgateway.issuerswitch.v1.ApiType]
	//     enum.
	//
	// 1. `TransactionType`
	//   - **Description** - Type of the transaction. The value will be of the
	//     [TransactionType][google.cloud.paymentgateway.issuerswitch.v1.TransactionType]
	//     enum.
	//
	// 1. `CreationTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when the issuer
	//     switch created the transaction resource for processing the transaction.
	//     The format will be as per RFC-3339. Example : 2022-11-22T23:00:05Z
	//
	// 1. `State`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - State of the transaction. This will be one of
	//     `FAILED`, `SUCCEEDED`, or `TIMED_OUT`.
	//
	// 1. `OriginVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the originator of
	//     the transaction.
	//
	// 1. `BankAdapterRequestIDs`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2,000 characters
	//   - **Description** - List of Request IDs (colon separated) used when
	//     invoking the Bank Adapter APIs for fulfilling a transaction request.
	//
	// 1. `ErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Error code of the failed transaction.
	//
	// 1. `ErrorMessage`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 10,000 characters
	//   - **Description** - Error description for the failed transaction.
	//
	// 1. `UPIErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Error code as per the UPI specification. The issuer
	//     switch maps the ErrorCode to an appropriate error code that complies
	//     with the UPI specification.
	ExportMetadataTransactions(ctx context.Context, in *ExportMetadataTransactionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Export mandate transactions received within the specified time range as a
	// file into a configured target location. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`:
	// [ExportMandateTransactionsMetadata][google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsMetadata]
	// - `response`:
	// [ExportMandateTransactionsResponse][google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsResponse]
	//
	// The exported file will be in the standard CSV format where each row in the
	// file represents a transaction. The file has the following fields in order:
	//
	// 1. `TransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - UPI transaction ID.
	//
	// 1. `UniqueMandateNumber`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 70 characters
	//   - **Description** - UPI Unique Mandate Number.
	//
	// 1. `TransactionType`
	//   - **Min Length** - 23 characters
	//   - **Max Length** - 23 characters
	//   - **Description** - Type of the transaction. This will be one of
	//     `TRANSACTION_TYPE_CREATE`, `TRANSACTION_TYPE_REVOKE`,
	//     `TRANSACTION_TYPE_UPDATE`, `TRANSACTION_TYPE_PAUSE` or
	//     `TRANSACTION_TYPE_UNPAUSE`.
	//
	// 1. `CreationTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when the issuer
	//     switch created the transaction resource for processing the transaction.
	//     The format will be as per RFC-3339. Example : 2022-11-22T23:00:05Z
	//
	// 1. `State`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - State of the transaction. This will be one of
	//     `FAILED`, `SUCCEEDED`, or `TIMED_OUT`.
	//
	// 1. `PayerVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the payer.
	//
	// 1. `PayerMobileNumber`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Mobile number of the payer.
	//
	// 1. `PayeeVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the payee.
	//
	// 1. `PayeeMobileNumber`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Mobile number of the payee.
	//
	// 1. `PayeeMerchantID`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 30 characters
	//   - **Description** - Payee's merchant ID, only if the payee is a
	//     merchant
	//
	// 1. `Amount`
	//   - **Description** - Amount specified in the mandate.
	//
	// 1. `RecurrencePattern`
	//   - **Description** - Reccurence pattern of the mandate. The value will
	//     be of the
	//     [MandateTransaction.RecurrencePatternType][google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.RecurrencePatternType]
	//     enum.
	//
	// 1. `RecurrenceRuleType`
	//   - **Description** - Reccurrence rule type of the mandate. The value
	//     will be of the
	//     [MandateTransaction.RecurrenceRuleType][google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.RecurrenceRuleType]
	//     enum.
	//
	// 1. `RecurrenceRuleValue`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2 characters
	//   - **Description** - Recurrence rule value of the mandate. This will be
	//     an integer between 1 and 31.
	//
	// 1. `Revokeable`
	//   - **Min Length** - 4 characters
	//   - **Max Length** - 5 characters
	//   - **Description** - Boolean value specifying if the mandate is
	//     revokable.
	//
	// 1. `StartDate`
	//   - **Min Length** - 10 characters
	//   - **Max Length** - 10 characters
	//   - **Description** - The start date of the mandate in `YYYY-MM-DD`
	//     format.
	//
	// 1. `EndDate`
	//   - **Min Length** - 10 characters
	//   - **Max Length** - 10 characters
	//   - **Description** - The end date of the mandate in `YYYY-MM-DD` format.
	//
	// 1. `AmountRuleType`
	//   - **Description** - The amount rule of the mandate. The value will be
	//     of the
	//     [MandateTransaction.AmountRuleType][google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.AmountRuleType]
	//     enum.
	//
	// 1. `ApprovalReference`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - The block funds reference generated by the bank, if
	//     funds have been blocked for the mandate. This column will have a value
	//     only when the RecurrencePattern is ONETIME.
	//
	// 1. `BlockFunds`
	//   - **Min Length** - 4 characters
	//   - **Max Length** - 5 characters
	//   - **Description** - Boolean value specifying if the mandate transaction
	//     requested to block funds.
	//
	// 1. `LastUpdateTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when was the last
	//     modification made to the mandate. The format will be as per RFC-3339.
	//     Example : 2022-11-22T23:00:05Z
	//
	// 1. `BankAdapterRequestIDs`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2,000 characters
	//   - **Description** - List of Request IDs (colon separated) used when
	//     invoking the Bank Adapter APIs for fulfilling a transaction request.
	//
	// 1. `ErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Error code of the failed transaction.
	//
	// 1. `ErrorMessage`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 10,000 characters
	//   - **Description** - Error description for the failed transaction.
	//
	// 1. `UPIErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Error code as per the UPI specification. The issuer
	//     switch maps the ErrorCode to an appropriate error code that complies
	//     with the UPI specification.
	ExportMandateTransactions(ctx context.Context, in *ExportMandateTransactionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Export complaint transactions received within the specified time range as a
	// file into a configured target location. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`:
	// [ExportComplaintTransactionsMetadata][google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsMetadata]
	// - `response`:
	// [ExportComplaintTransactionsResponse][google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsResponse]
	//
	// The exported file will be in the standard CSV format where each row in the
	// file represents a transaction. The file has the following fields in order:
	//
	// 1. `TransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - UPI transaction ID.
	//
	// 1. `TransactionType`
	//   - **Min Length** - 23 characters
	//   - **Max Length** - 30 characters
	//   - **Description** - Type of the transaction. This will be one of
	//     `TRANSACTION_TYPE_CHECK_STATUS`, `TRANSACTION_TYPE_COMPLAINT`,
	//     `TRANSACTION_TYPE_REVERSAL`, `TRANSACTION_TYPE_DISPUTE`,
	//     `TRANSACTION_TYPE_REFUND`, or `TRANSACTION_TYPE_STATUS_UPDATE`.
	//
	// 1. `CreationTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when the issuer
	//     switch created the transaction resource for processing the transaction.
	//     The format will be as per RFC-3339. Example : 2022-11-22T23:00:05Z
	//
	// 1: `State`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - State of the transaction. This will be one of
	//     `FAILED`, `SUCCEEDED`, or `TIMED_OUT`.
	//
	// 1. `OriginalRRN`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Retrieval reference number of the original payment
	//     transaction.
	//
	// 1. `BankType`
	//   - **Min Length** - 8 characters
	//   - **Max Length** - 11 characters
	//   - **Description** - The subtype of the transaction based on the bank
	//     involved. This will be one of `BENEFICIARY`, or `REMITTER`.
	//
	// 1. `OriginalTransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - Transaction ID of the original unresolved
	//     transaction.
	//
	// 1. `RaiseComplaintAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the type of action to raise the
	//     complaint.
	//
	// 1. `RaiseComplaintAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the reason of action to raise the
	//     complaint.
	//
	// 1. `ResolveComplaintAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the type of action to resolve the
	//     complaint.
	//
	// 1. `ResolveComplaintAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the reason of action to resolve the
	//     complaint.
	//
	// 1. `RaiseDisputeAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the type of action to raise the dispute.
	//
	// 1. `RaiseDisputeAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the reason of action to raise the
	//     dispute.
	//
	// 1. `ResolveDisputeAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the type of action to resolve the
	//     dispute.
	//
	// 1. `ResolveDisputeAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the reason of action to resolve the
	//     dispute.
	//
	// 1. `Amount`
	//   - **Description** - Amount to be resolved.
	//
	// 1. `CurrentCycle`
	//   - **Min Length** - 4 characters
	//   - **Max Length** - 5 characters
	//   - **Description** - Boolean value specifying if the complaint / dispute
	//     belongs to current settlement cycle or not.
	//
	// 1. `CRN`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Defines the Complaint Reference number.
	//
	// 1. `AdjTime`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the time when the resolution was done.
	//
	// 1. `RespAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the response category type.
	//
	// 1. `RespAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the response reason used.
	//
	// 1. `AdjRemarks`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the additional remarks for the complaint
	//     / dispute.
	//
	// 1. `BankAdapterRequestIDs`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2,000 characters
	//   - **Description** - List of Request IDs (colon separated) used when
	//     invoking the Bank Adapter APIs for fulfilling a transaction request.
	//
	// 1. `ErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Error code of the failed transaction.
	//
	// 1. `ErrorMessage`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 10,000 characters
	//   - **Description** - Error description for the failed transaction.
	//
	// 1. `UPIErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Error code as per the UPI specification. The issuer
	//     switch service maps the ErrorCode to an appropriate error code that
	//     complies with the UPI specification.
	ExportComplaintTransactions(ctx context.Context, in *ExportComplaintTransactionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type issuerSwitchTransactionsClient struct {
	cc grpc.ClientConnInterface
}

func NewIssuerSwitchTransactionsClient(cc grpc.ClientConnInterface) IssuerSwitchTransactionsClient {
	return &issuerSwitchTransactionsClient{cc}
}

func (c *issuerSwitchTransactionsClient) ListMetadataTransactions(ctx context.Context, in *ListMetadataTransactionsRequest, opts ...grpc.CallOption) (*ListMetadataTransactionsResponse, error) {
	out := new(ListMetadataTransactionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ListMetadataTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchTransactionsClient) ListFinancialTransactions(ctx context.Context, in *ListFinancialTransactionsRequest, opts ...grpc.CallOption) (*ListFinancialTransactionsResponse, error) {
	out := new(ListFinancialTransactionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ListFinancialTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchTransactionsClient) ListMandateTransactions(ctx context.Context, in *ListMandateTransactionsRequest, opts ...grpc.CallOption) (*ListMandateTransactionsResponse, error) {
	out := new(ListMandateTransactionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ListMandateTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchTransactionsClient) ListComplaintTransactions(ctx context.Context, in *ListComplaintTransactionsRequest, opts ...grpc.CallOption) (*ListComplaintTransactionsResponse, error) {
	out := new(ListComplaintTransactionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ListComplaintTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchTransactionsClient) ExportFinancialTransactions(ctx context.Context, in *ExportFinancialTransactionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ExportFinancialTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchTransactionsClient) ExportMetadataTransactions(ctx context.Context, in *ExportMetadataTransactionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ExportMetadataTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchTransactionsClient) ExportMandateTransactions(ctx context.Context, in *ExportMandateTransactionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ExportMandateTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *issuerSwitchTransactionsClient) ExportComplaintTransactions(ctx context.Context, in *ExportComplaintTransactionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ExportComplaintTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IssuerSwitchTransactionsServer is the server API for IssuerSwitchTransactions service.
type IssuerSwitchTransactionsServer interface {
	// List metadata transactions that satisfy the specified filter criteria.
	ListMetadataTransactions(context.Context, *ListMetadataTransactionsRequest) (*ListMetadataTransactionsResponse, error)
	// List financial transactions that satisfy specified filter criteria.
	ListFinancialTransactions(context.Context, *ListFinancialTransactionsRequest) (*ListFinancialTransactionsResponse, error)
	// List mandate transactions that satisfy specified filter criteria.
	ListMandateTransactions(context.Context, *ListMandateTransactionsRequest) (*ListMandateTransactionsResponse, error)
	// List complaint transactions that satisfy specified filter criteria.
	ListComplaintTransactions(context.Context, *ListComplaintTransactionsRequest) (*ListComplaintTransactionsResponse, error)
	// Export financial transactions received within the specified time range as a
	// file into a configured target location. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`:
	// [ExportFinancialTransactionsMetadata][google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsMetadata]
	// - `response`:
	// [ExportFinancialTransactionsResponse][google.cloud.paymentgateway.issuerswitch.v1.ExportFinancialTransactionsResponse]
	//
	// The exported file will be in the standard CSV format where each row in the
	// file represents a transaction. The file has the following fields in order:
	//
	// 1. `TransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - UPI transaction ID.
	//
	// 1. `TransactionType`
	//   - **Min Length** - 22 characters
	//   - **Max Length** - 25 characters
	//   - **Description** - Type of the transaction. This will be one of
	//     `TRANSACTION_TYPE_CREDIT`, `TRANSACTION_TYPE_DEBIT` or
	//     `TRANSACTION_TYPE_REVERSAL`.
	//
	// 1. `TransactionSubType`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 7 characters
	//   - **Description** - Subtype of the transaction. This will be one of
	//     `COLLECT`, or `PAY`.
	//
	// 1. `CreationTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when the issuer
	//     switch created the transaction resource for processing the transaction.
	//     The format will be as per RFC-3339. Example : 2022-11-22T23:00:05Z
	//
	// 1. `State`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - State of the transaction. This will be one of
	//     `FAILED`, `SUCCEEDED`, or `TIMED_OUT`.
	//
	// 1. `RRN`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Retrieval reference number associated with the
	//     transaction.
	//
	// 1. `PayerVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the payer.
	//
	// 1. `PayerMobileNumber`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Mobile number of the payer.
	//
	// 1. `PayerIFSC`
	//   - **Min Length** - 11 characters
	//   - **Max Length** - 11 characters
	//   - **Description** - IFSC of the payer's bank account.
	//
	// 1. `PayerAccountNumber`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 30 characters
	//   - **Description** - Payer's bank account number.
	//
	// 1. `PayerAccountType`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 7 characters
	//   - **Description** - Payer's bank account type. This will be one of
	//     `SAVINGS`, `DEFAULT`, `CURRENT`, `NRE`, `NRO`, `PPIWALLET`,
	//     `BANKWALLET`, `CREDIT`, `SOD`, or `UOD`.
	//
	// 1. `PayeeVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the payee.
	//
	// 1. `PayeeMobileNumber`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Payee's mobile number.
	//
	// 1. `PayeeIFSC`
	//   - **Min Length** - 11 characters
	//   - **Max Length** - 11 characters
	//   - **Description** - IFSC of the payee's bank account.
	//
	// 1. `PayeeAccountNumber`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 30 characters
	//   - **Description** - Payee's bank account number.
	//
	// 1. `PayeeAccountType`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 10 characters
	//   - **Description** - Payee's bank account type. This will be one of
	//     `SAVINGS`, `DEFAULT`, `CURRENT`, `NRE`, `NRO`, `PPIWALLET`,
	//     `BANKWALLET`, `CREDIT`, `SOD`, or `UOD`.
	//
	// 1. `PayeeMerchantID`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Payee's merchant ID, only if the payee is a
	//     merchant.
	//
	// 1. `PayeeMerchantName`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Payee's merchant name, only if the payee is a
	//     merchant.
	//
	// 1. `PayeeMCC`
	//   - **Min Length** - 4 characters
	//   - **Max Length** - 4 characters
	//   - **Description** - Payee's Merchant Category Code (MCC), only if the
	//     payee is a merchant.
	//
	// 1. `Currency`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Currency of the amount involved in the transaction.
	//     The currency codes are defined in ISO 4217.
	//
	// 1. `Amount`
	//   - **Description** - Amount involved in the transaction.
	//
	// 1. `BankAdapterRequestIDs`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2,000 characters
	//   - **Description** - List of Request IDs (colon separated) used when
	//     invoking the Bank Adapter APIs for fulfilling a transaction request.
	//
	// 1. `ErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Error code of a failed transaction.
	//
	// 1. `ErrorMessage`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 10,000 characters
	//   - **Description** - Error description for a failed transaction.
	//
	// 1. `UPIErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Error code as per the UPI specification. The issuer
	//     switch maps the ErrorCode to an appropriate error code that complies
	//     with the UPI specification.
	//
	// 1. `PayerDeviceInfoTypeAppName`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Payment application name on the payer's device.
	//
	// 1. `PayerDeviceInfoTypeCapability`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Capability of the payer's device.
	//
	// 1. `PayerDeviceInfoTypeGeoCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 15 characters
	//   - **Description** - Geo code of the payer's device. This will include
	//     floating point values for latitude and longitude (separated by colon).
	//
	// 1. `PayerDeviceInfoTypeID`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - Device ID of the payer's device.
	//
	// 1. `PayerDeviceInfoTypeIP`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 39 characters
	//   - **Description** - IP address of the payer's device.
	//
	// 1. `PayerDeviceInfoTypeLocation`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 40 characters
	//   - **Description** - Coarse location of the payer's device.
	//
	// 1. `PayerDeviceInfoTypeOS`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Operating system on the payer's device.
	//
	// 1. `PayerDeviceInfoTypeTelecomProvider`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Telecom provider for the payer's device.
	//
	// 1. `PayerDeviceInfoTypeDeviceType`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - Type of the payer's device. This will be one of
	//     'MOB', 'INET', 'USDC/USDB', 'POS'.
	//
	// 1. `PayeeDeviceInfoTypeAppName`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Payment application name on the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeCapability`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Capability of the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeGeoCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 15 characters
	//   - **Description** - Geo code of the payee's device. This will include
	//     floating point values for latitude and longitude (separated by colon).
	//
	// 1. `PayeeDeviceInfoTypeID`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - Device ID of the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeIP`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 39 characters
	//   - **Description** - IP address of the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeLocation`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 40 characters
	//   - **Description** - Coarse location of the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeOS`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Operating system on the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeTelecomProvider`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 99 characters
	//   - **Description** - Telecom provider for the payee's device.
	//
	// 1. `PayeeDeviceInfoTypeDeviceType`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - Type of the payee's device. This will be one of
	//     'MOB', 'INET', 'USDC/USDB', 'POS'.
	ExportFinancialTransactions(context.Context, *ExportFinancialTransactionsRequest) (*longrunning.Operation, error)
	// Export metadata transactions received within the specified time range as a
	// file into a configured target location. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`:
	// [ExportMetadataTransactionsMetadata][google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsMetadata]
	// - `response`:
	// [ExportMetadataTransactionsResponse][google.cloud.paymentgateway.issuerswitch.v1.ExportMetadataTransactionsResponse]
	//
	// The exported file will be in the standard CSV format where each row in the
	// file represents a transaction. The file has the following fields in order:
	//
	// 1. `TransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - UPI transaction ID.
	//
	// 1. `APIType`
	//   - **Description** - The transaction's API type. The value will be of
	//     the [ApiType][google.cloud.paymentgateway.issuerswitch.v1.ApiType]
	//     enum.
	//
	// 1. `TransactionType`
	//   - **Description** - Type of the transaction. The value will be of the
	//     [TransactionType][google.cloud.paymentgateway.issuerswitch.v1.TransactionType]
	//     enum.
	//
	// 1. `CreationTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when the issuer
	//     switch created the transaction resource for processing the transaction.
	//     The format will be as per RFC-3339. Example : 2022-11-22T23:00:05Z
	//
	// 1. `State`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - State of the transaction. This will be one of
	//     `FAILED`, `SUCCEEDED`, or `TIMED_OUT`.
	//
	// 1. `OriginVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the originator of
	//     the transaction.
	//
	// 1. `BankAdapterRequestIDs`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2,000 characters
	//   - **Description** - List of Request IDs (colon separated) used when
	//     invoking the Bank Adapter APIs for fulfilling a transaction request.
	//
	// 1. `ErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Error code of the failed transaction.
	//
	// 1. `ErrorMessage`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 10,000 characters
	//   - **Description** - Error description for the failed transaction.
	//
	// 1. `UPIErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Error code as per the UPI specification. The issuer
	//     switch maps the ErrorCode to an appropriate error code that complies
	//     with the UPI specification.
	ExportMetadataTransactions(context.Context, *ExportMetadataTransactionsRequest) (*longrunning.Operation, error)
	// Export mandate transactions received within the specified time range as a
	// file into a configured target location. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`:
	// [ExportMandateTransactionsMetadata][google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsMetadata]
	// - `response`:
	// [ExportMandateTransactionsResponse][google.cloud.paymentgateway.issuerswitch.v1.ExportMandateTransactionsResponse]
	//
	// The exported file will be in the standard CSV format where each row in the
	// file represents a transaction. The file has the following fields in order:
	//
	// 1. `TransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - UPI transaction ID.
	//
	// 1. `UniqueMandateNumber`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 70 characters
	//   - **Description** - UPI Unique Mandate Number.
	//
	// 1. `TransactionType`
	//   - **Min Length** - 23 characters
	//   - **Max Length** - 23 characters
	//   - **Description** - Type of the transaction. This will be one of
	//     `TRANSACTION_TYPE_CREATE`, `TRANSACTION_TYPE_REVOKE`,
	//     `TRANSACTION_TYPE_UPDATE`, `TRANSACTION_TYPE_PAUSE` or
	//     `TRANSACTION_TYPE_UNPAUSE`.
	//
	// 1. `CreationTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when the issuer
	//     switch created the transaction resource for processing the transaction.
	//     The format will be as per RFC-3339. Example : 2022-11-22T23:00:05Z
	//
	// 1. `State`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - State of the transaction. This will be one of
	//     `FAILED`, `SUCCEEDED`, or `TIMED_OUT`.
	//
	// 1. `PayerVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the payer.
	//
	// 1. `PayerMobileNumber`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Mobile number of the payer.
	//
	// 1. `PayeeVPA`
	//   - **Min Length** - 3 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Virtual Payment Address (VPA) of the payee.
	//
	// 1. `PayeeMobileNumber`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Mobile number of the payee.
	//
	// 1. `PayeeMerchantID`
	//   - **Min Length** - 1 characters
	//   - **Max Length** - 30 characters
	//   - **Description** - Payee's merchant ID, only if the payee is a
	//     merchant
	//
	// 1. `Amount`
	//   - **Description** - Amount specified in the mandate.
	//
	// 1. `RecurrencePattern`
	//   - **Description** - Reccurence pattern of the mandate. The value will
	//     be of the
	//     [MandateTransaction.RecurrencePatternType][google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.RecurrencePatternType]
	//     enum.
	//
	// 1. `RecurrenceRuleType`
	//   - **Description** - Reccurrence rule type of the mandate. The value
	//     will be of the
	//     [MandateTransaction.RecurrenceRuleType][google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.RecurrenceRuleType]
	//     enum.
	//
	// 1. `RecurrenceRuleValue`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2 characters
	//   - **Description** - Recurrence rule value of the mandate. This will be
	//     an integer between 1 and 31.
	//
	// 1. `Revokeable`
	//   - **Min Length** - 4 characters
	//   - **Max Length** - 5 characters
	//   - **Description** - Boolean value specifying if the mandate is
	//     revokable.
	//
	// 1. `StartDate`
	//   - **Min Length** - 10 characters
	//   - **Max Length** - 10 characters
	//   - **Description** - The start date of the mandate in `YYYY-MM-DD`
	//     format.
	//
	// 1. `EndDate`
	//   - **Min Length** - 10 characters
	//   - **Max Length** - 10 characters
	//   - **Description** - The end date of the mandate in `YYYY-MM-DD` format.
	//
	// 1. `AmountRuleType`
	//   - **Description** - The amount rule of the mandate. The value will be
	//     of the
	//     [MandateTransaction.AmountRuleType][google.cloud.paymentgateway.issuerswitch.v1.MandateTransaction.AmountRuleType]
	//     enum.
	//
	// 1. `ApprovalReference`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - The block funds reference generated by the bank, if
	//     funds have been blocked for the mandate. This column will have a value
	//     only when the RecurrencePattern is ONETIME.
	//
	// 1. `BlockFunds`
	//   - **Min Length** - 4 characters
	//   - **Max Length** - 5 characters
	//   - **Description** - Boolean value specifying if the mandate transaction
	//     requested to block funds.
	//
	// 1. `LastUpdateTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when was the last
	//     modification made to the mandate. The format will be as per RFC-3339.
	//     Example : 2022-11-22T23:00:05Z
	//
	// 1. `BankAdapterRequestIDs`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2,000 characters
	//   - **Description** - List of Request IDs (colon separated) used when
	//     invoking the Bank Adapter APIs for fulfilling a transaction request.
	//
	// 1. `ErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Error code of the failed transaction.
	//
	// 1. `ErrorMessage`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 10,000 characters
	//   - **Description** - Error description for the failed transaction.
	//
	// 1. `UPIErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Error code as per the UPI specification. The issuer
	//     switch maps the ErrorCode to an appropriate error code that complies
	//     with the UPI specification.
	ExportMandateTransactions(context.Context, *ExportMandateTransactionsRequest) (*longrunning.Operation, error)
	// Export complaint transactions received within the specified time range as a
	// file into a configured target location. The returned `Operation` type has
	// the following method-specific fields:
	//
	// - `metadata`:
	// [ExportComplaintTransactionsMetadata][google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsMetadata]
	// - `response`:
	// [ExportComplaintTransactionsResponse][google.cloud.paymentgateway.issuerswitch.v1.ExportComplaintTransactionsResponse]
	//
	// The exported file will be in the standard CSV format where each row in the
	// file represents a transaction. The file has the following fields in order:
	//
	// 1. `TransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - UPI transaction ID.
	//
	// 1. `TransactionType`
	//   - **Min Length** - 23 characters
	//   - **Max Length** - 30 characters
	//   - **Description** - Type of the transaction. This will be one of
	//     `TRANSACTION_TYPE_CHECK_STATUS`, `TRANSACTION_TYPE_COMPLAINT`,
	//     `TRANSACTION_TYPE_REVERSAL`, `TRANSACTION_TYPE_DISPUTE`,
	//     `TRANSACTION_TYPE_REFUND`, or `TRANSACTION_TYPE_STATUS_UPDATE`.
	//
	// 1. `CreationTime`
	//   - **Min Length** - 20 characters
	//   - **Max Length** - 20 characters
	//   - **Description** - Timestamp (in UTC) indicating when the issuer
	//     switch created the transaction resource for processing the transaction.
	//     The format will be as per RFC-3339. Example : 2022-11-22T23:00:05Z
	//
	// 1: `State`
	//   - **Min Length** - 6 characters
	//   - **Max Length** - 9 characters
	//   - **Description** - State of the transaction. This will be one of
	//     `FAILED`, `SUCCEEDED`, or `TIMED_OUT`.
	//
	// 1. `OriginalRRN`
	//   - **Min Length** - 12 characters
	//   - **Max Length** - 12 characters
	//   - **Description** - Retrieval reference number of the original payment
	//     transaction.
	//
	// 1. `BankType`
	//   - **Min Length** - 8 characters
	//   - **Max Length** - 11 characters
	//   - **Description** - The subtype of the transaction based on the bank
	//     involved. This will be one of `BENEFICIARY`, or `REMITTER`.
	//
	// 1. `OriginalTransactionID`
	//   - **Min Length** - 35 characters
	//   - **Max Length** - 35 characters
	//   - **Description** - Transaction ID of the original unresolved
	//     transaction.
	//
	// 1. `RaiseComplaintAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the type of action to raise the
	//     complaint.
	//
	// 1. `RaiseComplaintAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the reason of action to raise the
	//     complaint.
	//
	// 1. `ResolveComplaintAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the type of action to resolve the
	//     complaint.
	//
	// 1. `ResolveComplaintAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the reason of action to resolve the
	//     complaint.
	//
	// 1. `RaiseDisputeAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the type of action to raise the dispute.
	//
	// 1. `RaiseDisputeAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the reason of action to raise the
	//     dispute.
	//
	// 1. `ResolveDisputeAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the type of action to resolve the
	//     dispute.
	//
	// 1. `ResolveDisputeAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the reason of action to resolve the
	//     dispute.
	//
	// 1. `Amount`
	//   - **Description** - Amount to be resolved.
	//
	// 1. `CurrentCycle`
	//   - **Min Length** - 4 characters
	//   - **Max Length** - 5 characters
	//   - **Description** - Boolean value specifying if the complaint / dispute
	//     belongs to current settlement cycle or not.
	//
	// 1. `CRN`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Defines the Complaint Reference number.
	//
	// 1. `AdjTime`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the time when the resolution was done.
	//
	// 1. `RespAdjFlag`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the response category type.
	//
	// 1. `RespAdjCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the response reason used.
	//
	// 1. `AdjRemarks`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Indicates the additional remarks for the complaint
	//     / dispute.
	//
	// 1. `BankAdapterRequestIDs`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 2,000 characters
	//   - **Description** - List of Request IDs (colon separated) used when
	//     invoking the Bank Adapter APIs for fulfilling a transaction request.
	//
	// 1. `ErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 255 characters
	//   - **Description** - Error code of the failed transaction.
	//
	// 1. `ErrorMessage`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 10,000 characters
	//   - **Description** - Error description for the failed transaction.
	//
	// 1. `UPIErrorCode`
	//   - **Min Length** - 0 characters
	//   - **Max Length** - 3 characters
	//   - **Description** - Error code as per the UPI specification. The issuer
	//     switch service maps the ErrorCode to an appropriate error code that
	//     complies with the UPI specification.
	ExportComplaintTransactions(context.Context, *ExportComplaintTransactionsRequest) (*longrunning.Operation, error)
}

// UnimplementedIssuerSwitchTransactionsServer can be embedded to have forward compatible implementations.
type UnimplementedIssuerSwitchTransactionsServer struct {
}

func (*UnimplementedIssuerSwitchTransactionsServer) ListMetadataTransactions(context.Context, *ListMetadataTransactionsRequest) (*ListMetadataTransactionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetadataTransactions not implemented")
}
func (*UnimplementedIssuerSwitchTransactionsServer) ListFinancialTransactions(context.Context, *ListFinancialTransactionsRequest) (*ListFinancialTransactionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFinancialTransactions not implemented")
}
func (*UnimplementedIssuerSwitchTransactionsServer) ListMandateTransactions(context.Context, *ListMandateTransactionsRequest) (*ListMandateTransactionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMandateTransactions not implemented")
}
func (*UnimplementedIssuerSwitchTransactionsServer) ListComplaintTransactions(context.Context, *ListComplaintTransactionsRequest) (*ListComplaintTransactionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListComplaintTransactions not implemented")
}
func (*UnimplementedIssuerSwitchTransactionsServer) ExportFinancialTransactions(context.Context, *ExportFinancialTransactionsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportFinancialTransactions not implemented")
}
func (*UnimplementedIssuerSwitchTransactionsServer) ExportMetadataTransactions(context.Context, *ExportMetadataTransactionsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportMetadataTransactions not implemented")
}
func (*UnimplementedIssuerSwitchTransactionsServer) ExportMandateTransactions(context.Context, *ExportMandateTransactionsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportMandateTransactions not implemented")
}
func (*UnimplementedIssuerSwitchTransactionsServer) ExportComplaintTransactions(context.Context, *ExportComplaintTransactionsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportComplaintTransactions not implemented")
}

func RegisterIssuerSwitchTransactionsServer(s *grpc.Server, srv IssuerSwitchTransactionsServer) {
	s.RegisterService(&_IssuerSwitchTransactions_serviceDesc, srv)
}

func _IssuerSwitchTransactions_ListMetadataTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetadataTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchTransactionsServer).ListMetadataTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ListMetadataTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchTransactionsServer).ListMetadataTransactions(ctx, req.(*ListMetadataTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchTransactions_ListFinancialTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFinancialTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchTransactionsServer).ListFinancialTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ListFinancialTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchTransactionsServer).ListFinancialTransactions(ctx, req.(*ListFinancialTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchTransactions_ListMandateTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMandateTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchTransactionsServer).ListMandateTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ListMandateTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchTransactionsServer).ListMandateTransactions(ctx, req.(*ListMandateTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchTransactions_ListComplaintTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListComplaintTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchTransactionsServer).ListComplaintTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ListComplaintTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchTransactionsServer).ListComplaintTransactions(ctx, req.(*ListComplaintTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchTransactions_ExportFinancialTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportFinancialTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchTransactionsServer).ExportFinancialTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ExportFinancialTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchTransactionsServer).ExportFinancialTransactions(ctx, req.(*ExportFinancialTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchTransactions_ExportMetadataTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportMetadataTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchTransactionsServer).ExportMetadataTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ExportMetadataTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchTransactionsServer).ExportMetadataTransactions(ctx, req.(*ExportMetadataTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchTransactions_ExportMandateTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportMandateTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchTransactionsServer).ExportMandateTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ExportMandateTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchTransactionsServer).ExportMandateTransactions(ctx, req.(*ExportMandateTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IssuerSwitchTransactions_ExportComplaintTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportComplaintTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IssuerSwitchTransactionsServer).ExportComplaintTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions/ExportComplaintTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IssuerSwitchTransactionsServer).ExportComplaintTransactions(ctx, req.(*ExportComplaintTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IssuerSwitchTransactions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.paymentgateway.issuerswitch.v1.IssuerSwitchTransactions",
	HandlerType: (*IssuerSwitchTransactionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMetadataTransactions",
			Handler:    _IssuerSwitchTransactions_ListMetadataTransactions_Handler,
		},
		{
			MethodName: "ListFinancialTransactions",
			Handler:    _IssuerSwitchTransactions_ListFinancialTransactions_Handler,
		},
		{
			MethodName: "ListMandateTransactions",
			Handler:    _IssuerSwitchTransactions_ListMandateTransactions_Handler,
		},
		{
			MethodName: "ListComplaintTransactions",
			Handler:    _IssuerSwitchTransactions_ListComplaintTransactions_Handler,
		},
		{
			MethodName: "ExportFinancialTransactions",
			Handler:    _IssuerSwitchTransactions_ExportFinancialTransactions_Handler,
		},
		{
			MethodName: "ExportMetadataTransactions",
			Handler:    _IssuerSwitchTransactions_ExportMetadataTransactions_Handler,
		},
		{
			MethodName: "ExportMandateTransactions",
			Handler:    _IssuerSwitchTransactions_ExportMandateTransactions_Handler,
		},
		{
			MethodName: "ExportComplaintTransactions",
			Handler:    _IssuerSwitchTransactions_ExportComplaintTransactions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/paymentgateway/issuerswitch/v1/transactions.proto",
}
