// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/home/enterprise/sdm/v1/smart_device_management_service.proto

package sdm

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for SmartDeviceManagementService.GetDevice
type GetDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the device requested. For example:
	// "enterprises/XYZ/devices/123"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeviceRequest) Reset() {
	*x = GetDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceRequest) ProtoMessage() {}

func (x *GetDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceRequest) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetDeviceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for SmartDeviceManagementService.ListDevices
type ListDevicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent enterprise to list devices under. E.g. "enterprises/XYZ".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional requested page size. Server may return fewer devices than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional token of the page to retrieve.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional filter to list devices.
	//
	// Filters can be done on:
	// Device custom name (substring match):
	// 'customName=wing'
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListDevicesRequest) Reset() {
	*x = ListDevicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDevicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDevicesRequest) ProtoMessage() {}

func (x *ListDevicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDevicesRequest.ProtoReflect.Descriptor instead.
func (*ListDevicesRequest) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListDevicesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDevicesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDevicesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDevicesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for SmartDeviceManagementService.ListDevices
type ListDevicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of devices.
	Devices []*Device `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	// The pagination token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDevicesResponse) Reset() {
	*x = ListDevicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDevicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDevicesResponse) ProtoMessage() {}

func (x *ListDevicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDevicesResponse.ProtoReflect.Descriptor instead.
func (*ListDevicesResponse) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListDevicesResponse) GetDevices() []*Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *ListDevicesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for SmartDeviceManagementService.ExecuteDeviceCommand
type ExecuteDeviceCommandRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the device requested. For example:
	// "enterprises/XYZ/devices/123"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The command name to execute, represented by the fully qualified protobuf
	// message name.
	Command string `protobuf:"bytes,2,opt,name=command,proto3" json:"command,omitempty"`
	// The command message to execute, represented as a Struct.
	Params *structpb.Struct `protobuf:"bytes,3,opt,name=params,proto3" json:"params,omitempty"`
}

func (x *ExecuteDeviceCommandRequest) Reset() {
	*x = ExecuteDeviceCommandRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteDeviceCommandRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteDeviceCommandRequest) ProtoMessage() {}

func (x *ExecuteDeviceCommandRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteDeviceCommandRequest.ProtoReflect.Descriptor instead.
func (*ExecuteDeviceCommandRequest) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{3}
}

func (x *ExecuteDeviceCommandRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecuteDeviceCommandRequest) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *ExecuteDeviceCommandRequest) GetParams() *structpb.Struct {
	if x != nil {
		return x.Params
	}
	return nil
}

// Response message for SmartDeviceManagementService.ExecuteDeviceCommand
type ExecuteDeviceCommandResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results of executing the command.
	Results *structpb.Struct `protobuf:"bytes,1,opt,name=results,proto3" json:"results,omitempty"`
}

func (x *ExecuteDeviceCommandResponse) Reset() {
	*x = ExecuteDeviceCommandResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteDeviceCommandResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteDeviceCommandResponse) ProtoMessage() {}

func (x *ExecuteDeviceCommandResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteDeviceCommandResponse.ProtoReflect.Descriptor instead.
func (*ExecuteDeviceCommandResponse) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{4}
}

func (x *ExecuteDeviceCommandResponse) GetResults() *structpb.Struct {
	if x != nil {
		return x.Results
	}
	return nil
}

// Request message for SmartDeviceManagementService.GetStructure
type GetStructureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the structure requested. For example:
	// "enterprises/XYZ/structures/ABC".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetStructureRequest) Reset() {
	*x = GetStructureRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStructureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStructureRequest) ProtoMessage() {}

func (x *GetStructureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStructureRequest.ProtoReflect.Descriptor instead.
func (*GetStructureRequest) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetStructureRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for SmartDeviceManagementService.ListStructures
type ListStructuresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent enterprise to list structures under. E.g. "enterprises/XYZ".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer structures than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The token of the page to retrieve.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional filter to list structures.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListStructuresRequest) Reset() {
	*x = ListStructuresRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListStructuresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStructuresRequest) ProtoMessage() {}

func (x *ListStructuresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStructuresRequest.ProtoReflect.Descriptor instead.
func (*ListStructuresRequest) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListStructuresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListStructuresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListStructuresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListStructuresRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for SmartDeviceManagementService.ListStructures
type ListStructuresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of structures.
	Structures []*Structure `protobuf:"bytes,1,rep,name=structures,proto3" json:"structures,omitempty"`
	// The pagination token to retrieve the next page of results.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListStructuresResponse) Reset() {
	*x = ListStructuresResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListStructuresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStructuresResponse) ProtoMessage() {}

func (x *ListStructuresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStructuresResponse.ProtoReflect.Descriptor instead.
func (*ListStructuresResponse) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListStructuresResponse) GetStructures() []*Structure {
	if x != nil {
		return x.Structures
	}
	return nil
}

func (x *ListStructuresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for SmartDeviceManagementService.GetRoom
type GetRoomRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the room requested. For example:
	// "enterprises/XYZ/structures/ABC/rooms/123".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRoomRequest) Reset() {
	*x = GetRoomRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRoomRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRoomRequest) ProtoMessage() {}

func (x *GetRoomRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRoomRequest.ProtoReflect.Descriptor instead.
func (*GetRoomRequest) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetRoomRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for SmartDeviceManagementService.ListRooms
type ListRoomsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent resource name of the rooms requested. For example:
	// "enterprises/XYZ/structures/ABC".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer rooms than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The token of the page to retrieve.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRoomsRequest) Reset() {
	*x = ListRoomsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRoomsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRoomsRequest) ProtoMessage() {}

func (x *ListRoomsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRoomsRequest.ProtoReflect.Descriptor instead.
func (*ListRoomsRequest) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListRoomsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRoomsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRoomsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for SmartDeviceManagementService.ListRooms
type ListRoomsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of rooms.
	Rooms []*Room `protobuf:"bytes,1,rep,name=rooms,proto3" json:"rooms,omitempty"`
	// The pagination token to retrieve the next page of results.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRoomsResponse) Reset() {
	*x = ListRoomsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRoomsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRoomsResponse) ProtoMessage() {}

func (x *ListRoomsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRoomsResponse.ProtoReflect.Descriptor instead.
func (*ListRoomsResponse) Descriptor() ([]byte, []int) {
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListRoomsResponse) GetRooms() []*Room {
	if x != nil {
		return x.Rooms
	}
	return nil
}

func (x *ListRoomsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_home_enterprise_sdm_v1_smart_device_management_service_proto protoreflect.FileDescriptor

var file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2f, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2f, 0x73, 0x64, 0x6d, 0x2f, 0x76, 0x31, 0x2f,
	0x73, 0x6d, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f,
	0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x73, 0x64,
	0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x68, 0x6f, 0x6d, 0x65, 0x2f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2f,
	0x73, 0x64, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x68, 0x6f, 0x6d, 0x65,
	0x2f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2f, 0x73, 0x64, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x26, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x7e, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a,
	0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7c, 0x0a, 0x1b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x12, 0x2f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x22, 0x51, 0x0a, 0x1c, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x29, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0a, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x24, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6f, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x76, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x6d, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x05, 0x72, 0x6f, 0x6f, 0x6d,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x05, 0x72, 0x6f,
	0x6f, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x86, 0x0a, 0x0a, 0x1c,
	0x53, 0x6d, 0x61, 0x72, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8f, 0x01, 0x0a,
	0x09, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa0,
	0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x12, 0xcd, 0x01, 0x0a, 0x14, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x3a, 0x01,
	0x2a, 0x12, 0x9b, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65,
	0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x22, 0x2d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xac, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65,
	0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x2d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x94,
	0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6f, 0x6d, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x6f,
	0x6f, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x22, 0x35,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6f,
	0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa5, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f,
	0x6f, 0x6d, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d,
	0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x6d, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f,
	0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x73, 0x64,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x6d, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6f, 0x6d, 0x73, 0x1a, 0x55, 0xca,
	0x41, 0x24, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2b, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x64, 0x6d, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x42, 0xb2, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x73, 0x64, 0x6d, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x68, 0x6f, 0x6d, 0x65, 0x2f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2f, 0x73, 0x64, 0x6d, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x64, 0x6d, 0xa2, 0x02,
	0x08, 0x47, 0x48, 0x45, 0x4e, 0x54, 0x53, 0x44, 0x4d, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x48, 0x6f, 0x6d, 0x65, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x53, 0x64, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x48, 0x6f, 0x6d, 0x65, 0x5c, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x5c, 0x53, 0x64, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescOnce sync.Once
	file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescData = file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDesc
)

func file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescGZIP() []byte {
	file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescOnce.Do(func() {
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescData)
	})
	return file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDescData
}

var file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_goTypes = []interface{}{
	(*GetDeviceRequest)(nil),             // 0: google.home.enterprise.sdm.v1.GetDeviceRequest
	(*ListDevicesRequest)(nil),           // 1: google.home.enterprise.sdm.v1.ListDevicesRequest
	(*ListDevicesResponse)(nil),          // 2: google.home.enterprise.sdm.v1.ListDevicesResponse
	(*ExecuteDeviceCommandRequest)(nil),  // 3: google.home.enterprise.sdm.v1.ExecuteDeviceCommandRequest
	(*ExecuteDeviceCommandResponse)(nil), // 4: google.home.enterprise.sdm.v1.ExecuteDeviceCommandResponse
	(*GetStructureRequest)(nil),          // 5: google.home.enterprise.sdm.v1.GetStructureRequest
	(*ListStructuresRequest)(nil),        // 6: google.home.enterprise.sdm.v1.ListStructuresRequest
	(*ListStructuresResponse)(nil),       // 7: google.home.enterprise.sdm.v1.ListStructuresResponse
	(*GetRoomRequest)(nil),               // 8: google.home.enterprise.sdm.v1.GetRoomRequest
	(*ListRoomsRequest)(nil),             // 9: google.home.enterprise.sdm.v1.ListRoomsRequest
	(*ListRoomsResponse)(nil),            // 10: google.home.enterprise.sdm.v1.ListRoomsResponse
	(*Device)(nil),                       // 11: google.home.enterprise.sdm.v1.Device
	(*structpb.Struct)(nil),              // 12: google.protobuf.Struct
	(*Structure)(nil),                    // 13: google.home.enterprise.sdm.v1.Structure
	(*Room)(nil),                         // 14: google.home.enterprise.sdm.v1.Room
}
var file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_depIdxs = []int32{
	11, // 0: google.home.enterprise.sdm.v1.ListDevicesResponse.devices:type_name -> google.home.enterprise.sdm.v1.Device
	12, // 1: google.home.enterprise.sdm.v1.ExecuteDeviceCommandRequest.params:type_name -> google.protobuf.Struct
	12, // 2: google.home.enterprise.sdm.v1.ExecuteDeviceCommandResponse.results:type_name -> google.protobuf.Struct
	13, // 3: google.home.enterprise.sdm.v1.ListStructuresResponse.structures:type_name -> google.home.enterprise.sdm.v1.Structure
	14, // 4: google.home.enterprise.sdm.v1.ListRoomsResponse.rooms:type_name -> google.home.enterprise.sdm.v1.Room
	0,  // 5: google.home.enterprise.sdm.v1.SmartDeviceManagementService.GetDevice:input_type -> google.home.enterprise.sdm.v1.GetDeviceRequest
	1,  // 6: google.home.enterprise.sdm.v1.SmartDeviceManagementService.ListDevices:input_type -> google.home.enterprise.sdm.v1.ListDevicesRequest
	3,  // 7: google.home.enterprise.sdm.v1.SmartDeviceManagementService.ExecuteDeviceCommand:input_type -> google.home.enterprise.sdm.v1.ExecuteDeviceCommandRequest
	5,  // 8: google.home.enterprise.sdm.v1.SmartDeviceManagementService.GetStructure:input_type -> google.home.enterprise.sdm.v1.GetStructureRequest
	6,  // 9: google.home.enterprise.sdm.v1.SmartDeviceManagementService.ListStructures:input_type -> google.home.enterprise.sdm.v1.ListStructuresRequest
	8,  // 10: google.home.enterprise.sdm.v1.SmartDeviceManagementService.GetRoom:input_type -> google.home.enterprise.sdm.v1.GetRoomRequest
	9,  // 11: google.home.enterprise.sdm.v1.SmartDeviceManagementService.ListRooms:input_type -> google.home.enterprise.sdm.v1.ListRoomsRequest
	11, // 12: google.home.enterprise.sdm.v1.SmartDeviceManagementService.GetDevice:output_type -> google.home.enterprise.sdm.v1.Device
	2,  // 13: google.home.enterprise.sdm.v1.SmartDeviceManagementService.ListDevices:output_type -> google.home.enterprise.sdm.v1.ListDevicesResponse
	4,  // 14: google.home.enterprise.sdm.v1.SmartDeviceManagementService.ExecuteDeviceCommand:output_type -> google.home.enterprise.sdm.v1.ExecuteDeviceCommandResponse
	13, // 15: google.home.enterprise.sdm.v1.SmartDeviceManagementService.GetStructure:output_type -> google.home.enterprise.sdm.v1.Structure
	7,  // 16: google.home.enterprise.sdm.v1.SmartDeviceManagementService.ListStructures:output_type -> google.home.enterprise.sdm.v1.ListStructuresResponse
	14, // 17: google.home.enterprise.sdm.v1.SmartDeviceManagementService.GetRoom:output_type -> google.home.enterprise.sdm.v1.Room
	10, // 18: google.home.enterprise.sdm.v1.SmartDeviceManagementService.ListRooms:output_type -> google.home.enterprise.sdm.v1.ListRoomsResponse
	12, // [12:19] is the sub-list for method output_type
	5,  // [5:12] is the sub-list for method input_type
	5,  // [5:5] is the sub-list for extension type_name
	5,  // [5:5] is the sub-list for extension extendee
	0,  // [0:5] is the sub-list for field type_name
}

func init() { file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_init() }
func file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_init() {
	if File_google_home_enterprise_sdm_v1_smart_device_management_service_proto != nil {
		return
	}
	file_google_home_enterprise_sdm_v1_device_proto_init()
	file_google_home_enterprise_sdm_v1_site_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDevicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDevicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteDeviceCommandRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteDeviceCommandResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStructureRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListStructuresRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListStructuresResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRoomRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRoomsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRoomsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_goTypes,
		DependencyIndexes: file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_depIdxs,
		MessageInfos:      file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_msgTypes,
	}.Build()
	File_google_home_enterprise_sdm_v1_smart_device_management_service_proto = out.File
	file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_rawDesc = nil
	file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_goTypes = nil
	file_google_home_enterprise_sdm_v1_smart_device_management_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SmartDeviceManagementServiceClient is the client API for SmartDeviceManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SmartDeviceManagementServiceClient interface {
	// Gets a device managed by the enterprise.
	GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Lists devices managed by the enterprise.
	ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error)
	// Executes a command to device managed by the enterprise.
	ExecuteDeviceCommand(ctx context.Context, in *ExecuteDeviceCommandRequest, opts ...grpc.CallOption) (*ExecuteDeviceCommandResponse, error)
	// Gets a structure managed by the enterprise.
	GetStructure(ctx context.Context, in *GetStructureRequest, opts ...grpc.CallOption) (*Structure, error)
	// Lists structures managed by the enterprise.
	ListStructures(ctx context.Context, in *ListStructuresRequest, opts ...grpc.CallOption) (*ListStructuresResponse, error)
	// Gets a room managed by the enterprise.
	GetRoom(ctx context.Context, in *GetRoomRequest, opts ...grpc.CallOption) (*Room, error)
	// Lists rooms managed by the enterprise.
	ListRooms(ctx context.Context, in *ListRoomsRequest, opts ...grpc.CallOption) (*ListRoomsResponse, error)
}

type smartDeviceManagementServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSmartDeviceManagementServiceClient(cc grpc.ClientConnInterface) SmartDeviceManagementServiceClient {
	return &smartDeviceManagementServiceClient{cc}
}

func (c *smartDeviceManagementServiceClient) GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/GetDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *smartDeviceManagementServiceClient) ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error) {
	out := new(ListDevicesResponse)
	err := c.cc.Invoke(ctx, "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/ListDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *smartDeviceManagementServiceClient) ExecuteDeviceCommand(ctx context.Context, in *ExecuteDeviceCommandRequest, opts ...grpc.CallOption) (*ExecuteDeviceCommandResponse, error) {
	out := new(ExecuteDeviceCommandResponse)
	err := c.cc.Invoke(ctx, "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/ExecuteDeviceCommand", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *smartDeviceManagementServiceClient) GetStructure(ctx context.Context, in *GetStructureRequest, opts ...grpc.CallOption) (*Structure, error) {
	out := new(Structure)
	err := c.cc.Invoke(ctx, "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/GetStructure", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *smartDeviceManagementServiceClient) ListStructures(ctx context.Context, in *ListStructuresRequest, opts ...grpc.CallOption) (*ListStructuresResponse, error) {
	out := new(ListStructuresResponse)
	err := c.cc.Invoke(ctx, "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/ListStructures", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *smartDeviceManagementServiceClient) GetRoom(ctx context.Context, in *GetRoomRequest, opts ...grpc.CallOption) (*Room, error) {
	out := new(Room)
	err := c.cc.Invoke(ctx, "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/GetRoom", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *smartDeviceManagementServiceClient) ListRooms(ctx context.Context, in *ListRoomsRequest, opts ...grpc.CallOption) (*ListRoomsResponse, error) {
	out := new(ListRoomsResponse)
	err := c.cc.Invoke(ctx, "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/ListRooms", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SmartDeviceManagementServiceServer is the server API for SmartDeviceManagementService service.
type SmartDeviceManagementServiceServer interface {
	// Gets a device managed by the enterprise.
	GetDevice(context.Context, *GetDeviceRequest) (*Device, error)
	// Lists devices managed by the enterprise.
	ListDevices(context.Context, *ListDevicesRequest) (*ListDevicesResponse, error)
	// Executes a command to device managed by the enterprise.
	ExecuteDeviceCommand(context.Context, *ExecuteDeviceCommandRequest) (*ExecuteDeviceCommandResponse, error)
	// Gets a structure managed by the enterprise.
	GetStructure(context.Context, *GetStructureRequest) (*Structure, error)
	// Lists structures managed by the enterprise.
	ListStructures(context.Context, *ListStructuresRequest) (*ListStructuresResponse, error)
	// Gets a room managed by the enterprise.
	GetRoom(context.Context, *GetRoomRequest) (*Room, error)
	// Lists rooms managed by the enterprise.
	ListRooms(context.Context, *ListRoomsRequest) (*ListRoomsResponse, error)
}

// UnimplementedSmartDeviceManagementServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSmartDeviceManagementServiceServer struct {
}

func (*UnimplementedSmartDeviceManagementServiceServer) GetDevice(context.Context, *GetDeviceRequest) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDevice not implemented")
}
func (*UnimplementedSmartDeviceManagementServiceServer) ListDevices(context.Context, *ListDevicesRequest) (*ListDevicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDevices not implemented")
}
func (*UnimplementedSmartDeviceManagementServiceServer) ExecuteDeviceCommand(context.Context, *ExecuteDeviceCommandRequest) (*ExecuteDeviceCommandResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteDeviceCommand not implemented")
}
func (*UnimplementedSmartDeviceManagementServiceServer) GetStructure(context.Context, *GetStructureRequest) (*Structure, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStructure not implemented")
}
func (*UnimplementedSmartDeviceManagementServiceServer) ListStructures(context.Context, *ListStructuresRequest) (*ListStructuresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListStructures not implemented")
}
func (*UnimplementedSmartDeviceManagementServiceServer) GetRoom(context.Context, *GetRoomRequest) (*Room, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRoom not implemented")
}
func (*UnimplementedSmartDeviceManagementServiceServer) ListRooms(context.Context, *ListRoomsRequest) (*ListRoomsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRooms not implemented")
}

func RegisterSmartDeviceManagementServiceServer(s *grpc.Server, srv SmartDeviceManagementServiceServer) {
	s.RegisterService(&_SmartDeviceManagementService_serviceDesc, srv)
}

func _SmartDeviceManagementService_GetDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SmartDeviceManagementServiceServer).GetDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/GetDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SmartDeviceManagementServiceServer).GetDevice(ctx, req.(*GetDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SmartDeviceManagementService_ListDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SmartDeviceManagementServiceServer).ListDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/ListDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SmartDeviceManagementServiceServer).ListDevices(ctx, req.(*ListDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SmartDeviceManagementService_ExecuteDeviceCommand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteDeviceCommandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SmartDeviceManagementServiceServer).ExecuteDeviceCommand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/ExecuteDeviceCommand",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SmartDeviceManagementServiceServer).ExecuteDeviceCommand(ctx, req.(*ExecuteDeviceCommandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SmartDeviceManagementService_GetStructure_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStructureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SmartDeviceManagementServiceServer).GetStructure(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/GetStructure",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SmartDeviceManagementServiceServer).GetStructure(ctx, req.(*GetStructureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SmartDeviceManagementService_ListStructures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStructuresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SmartDeviceManagementServiceServer).ListStructures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/ListStructures",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SmartDeviceManagementServiceServer).ListStructures(ctx, req.(*ListStructuresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SmartDeviceManagementService_GetRoom_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRoomRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SmartDeviceManagementServiceServer).GetRoom(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/GetRoom",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SmartDeviceManagementServiceServer).GetRoom(ctx, req.(*GetRoomRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SmartDeviceManagementService_ListRooms_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRoomsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SmartDeviceManagementServiceServer).ListRooms(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.enterprise.sdm.v1.SmartDeviceManagementService/ListRooms",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SmartDeviceManagementServiceServer).ListRooms(ctx, req.(*ListRoomsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SmartDeviceManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.home.enterprise.sdm.v1.SmartDeviceManagementService",
	HandlerType: (*SmartDeviceManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDevice",
			Handler:    _SmartDeviceManagementService_GetDevice_Handler,
		},
		{
			MethodName: "ListDevices",
			Handler:    _SmartDeviceManagementService_ListDevices_Handler,
		},
		{
			MethodName: "ExecuteDeviceCommand",
			Handler:    _SmartDeviceManagementService_ExecuteDeviceCommand_Handler,
		},
		{
			MethodName: "GetStructure",
			Handler:    _SmartDeviceManagementService_GetStructure_Handler,
		},
		{
			MethodName: "ListStructures",
			Handler:    _SmartDeviceManagementService_ListStructures_Handler,
		},
		{
			MethodName: "GetRoom",
			Handler:    _SmartDeviceManagementService_GetRoom_Handler,
		},
		{
			MethodName: "ListRooms",
			Handler:    _SmartDeviceManagementService_ListRooms_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/home/enterprise/sdm/v1/smart_device_management_service.proto",
}
