// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/iam/v3/policy_bindings_service.proto

package iampb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for CreatePolicyBinding method.
type CreatePolicyBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this policy binding will be created.
	// The binding parent is the closest Resource Manager resource (project,
	// folder or organization) to the binding target.
	//
	// Format:
	//
	// * `projects/{project_id}/locations/{location}`
	// * `projects/{project_number}/locations/{location}`
	// * `folders/{folder_id}/locations/{location}`
	// * `organizations/{organization_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the policy binding, which will become the final
	// component of the policy binding's resource name.
	//
	// This value must start with a lowercase letter followed by up to 62
	// lowercase letters, numbers, hyphens, or dots. Pattern,
	// /[a-z][a-z0-9-\.]{2,62}/.
	PolicyBindingId string `protobuf:"bytes,2,opt,name=policy_binding_id,json=policyBindingId,proto3" json:"policy_binding_id,omitempty"`
	// Required. The policy binding to create.
	PolicyBinding *PolicyBinding `protobuf:"bytes,3,opt,name=policy_binding,json=policyBinding,proto3" json:"policy_binding,omitempty"`
	// Optional. If set, validate the request and preview the creation, but do not
	// actually post it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreatePolicyBindingRequest) Reset() {
	*x = CreatePolicyBindingRequest{}
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePolicyBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePolicyBindingRequest) ProtoMessage() {}

func (x *CreatePolicyBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePolicyBindingRequest.ProtoReflect.Descriptor instead.
func (*CreatePolicyBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_policy_bindings_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreatePolicyBindingRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePolicyBindingRequest) GetPolicyBindingId() string {
	if x != nil {
		return x.PolicyBindingId
	}
	return ""
}

func (x *CreatePolicyBindingRequest) GetPolicyBinding() *PolicyBinding {
	if x != nil {
		return x.PolicyBinding
	}
	return nil
}

func (x *CreatePolicyBindingRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for GetPolicyBinding method.
type GetPolicyBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the policy binding to retrieve.
	//
	// Format:
	//
	// * `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
	// * `projects/{project_number}/locations/{location}/policyBindings/{policy_binding_id}`
	// * `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
	// * `organizations/{organization_id}/locations/{location}/policyBindings/{policy_binding_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPolicyBindingRequest) Reset() {
	*x = GetPolicyBindingRequest{}
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPolicyBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPolicyBindingRequest) ProtoMessage() {}

func (x *GetPolicyBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPolicyBindingRequest.ProtoReflect.Descriptor instead.
func (*GetPolicyBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_policy_bindings_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetPolicyBindingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdatePolicyBinding method.
type UpdatePolicyBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The policy binding to update.
	//
	// The policy binding's `name` field is used to identify the policy binding to
	// update.
	PolicyBinding *PolicyBinding `protobuf:"bytes,1,opt,name=policy_binding,json=policyBinding,proto3" json:"policy_binding,omitempty"`
	// Optional. If set, validate the request and preview the update, but do not
	// actually post it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. The list of fields to update
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePolicyBindingRequest) Reset() {
	*x = UpdatePolicyBindingRequest{}
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePolicyBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePolicyBindingRequest) ProtoMessage() {}

func (x *UpdatePolicyBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePolicyBindingRequest.ProtoReflect.Descriptor instead.
func (*UpdatePolicyBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_policy_bindings_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdatePolicyBindingRequest) GetPolicyBinding() *PolicyBinding {
	if x != nil {
		return x.PolicyBinding
	}
	return nil
}

func (x *UpdatePolicyBindingRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdatePolicyBindingRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeletePolicyBinding method.
type DeletePolicyBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the policy binding to delete.
	//
	// Format:
	//
	// * `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
	// * `projects/{project_number}/locations/{location}/policyBindings/{policy_binding_id}`
	// * `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
	// * `organizations/{organization_id}/locations/{location}/policyBindings/{policy_binding_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The etag of the policy binding.
	// If this is provided, it must match the server's etag.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. If set, validate the request and preview the deletion, but do not
	// actually post it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeletePolicyBindingRequest) Reset() {
	*x = DeletePolicyBindingRequest{}
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePolicyBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePolicyBindingRequest) ProtoMessage() {}

func (x *DeletePolicyBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePolicyBindingRequest.ProtoReflect.Descriptor instead.
func (*DeletePolicyBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_policy_bindings_service_proto_rawDescGZIP(), []int{3}
}

func (x *DeletePolicyBindingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePolicyBindingRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeletePolicyBindingRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for ListPolicyBindings method.
type ListPolicyBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource, which owns the collection of policy
	// bindings.
	//
	// Format:
	//
	// * `projects/{project_id}/locations/{location}`
	// * `projects/{project_number}/locations/{location}`
	// * `folders/{folder_id}/locations/{location}`
	// * `organizations/{organization_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of policy bindings to return. The service may
	// return fewer than this value.
	//
	// If unspecified, at most 50 policy bindings will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListPolicyBindings` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListPolicyBindings` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An expression for filtering the results of the request. Filter
	// rules are case insensitive. Some eligible fields for filtering are:
	//
	// + `target`
	// + `policy`
	//
	// Some examples of filter queries:
	//
	// * `target:ex*`: The binding target's name starts with "ex".
	// * `target:example`: The binding target's name is `example`.
	// * `policy:example`: The binding policy's name is `example`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPolicyBindingsRequest) Reset() {
	*x = ListPolicyBindingsRequest{}
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPolicyBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPolicyBindingsRequest) ProtoMessage() {}

func (x *ListPolicyBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPolicyBindingsRequest.ProtoReflect.Descriptor instead.
func (*ListPolicyBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_policy_bindings_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListPolicyBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPolicyBindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPolicyBindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPolicyBindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ListPolicyBindings method.
type ListPolicyBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The policy bindings from the specified parent.
	PolicyBindings []*PolicyBinding `protobuf:"bytes,1,rep,name=policy_bindings,json=policyBindings,proto3" json:"policy_bindings,omitempty"`
	// Optional. A token, which can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPolicyBindingsResponse) Reset() {
	*x = ListPolicyBindingsResponse{}
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPolicyBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPolicyBindingsResponse) ProtoMessage() {}

func (x *ListPolicyBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPolicyBindingsResponse.ProtoReflect.Descriptor instead.
func (*ListPolicyBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_policy_bindings_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListPolicyBindingsResponse) GetPolicyBindings() []*PolicyBinding {
	if x != nil {
		return x.PolicyBindings
	}
	return nil
}

func (x *ListPolicyBindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for SearchTargetPolicyBindings method.
type SearchTargetPolicyBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The target resource, which is bound to the policy in the binding.
	//
	// Format:
	//
	// * `//iam.googleapis.com/locations/global/workforcePools/POOL_ID`
	// * `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPools/POOL_ID`
	// * `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
	// * `//cloudresourcemanager.googleapis.com/projects/{project_number}`
	// * `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
	// * `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
	Target string `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// Optional. The maximum number of policy bindings to return. The service may
	// return fewer than this value.
	//
	// If unspecified, at most 50 policy bindings will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// `SearchTargetPolicyBindingsRequest` call. Provide this to retrieve the
	// subsequent page.
	//
	// When paginating, all other parameters provided to
	// `SearchTargetPolicyBindingsRequest` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Required. The parent resource where this search will be performed. This
	// should be the nearest Resource Manager resource (project, folder, or
	// organization) to the target.
	//
	// Format:
	//
	// * `projects/{project_id}/locations/{location}`
	// * `projects/{project_number}/locations/{location}`
	// * `folders/{folder_id}/locations/{location}`
	// * `organizations/{organization_id}/locations/{location}`
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *SearchTargetPolicyBindingsRequest) Reset() {
	*x = SearchTargetPolicyBindingsRequest{}
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTargetPolicyBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTargetPolicyBindingsRequest) ProtoMessage() {}

func (x *SearchTargetPolicyBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTargetPolicyBindingsRequest.ProtoReflect.Descriptor instead.
func (*SearchTargetPolicyBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_policy_bindings_service_proto_rawDescGZIP(), []int{6}
}

func (x *SearchTargetPolicyBindingsRequest) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *SearchTargetPolicyBindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchTargetPolicyBindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchTargetPolicyBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response message for SearchTargetPolicyBindings method.
type SearchTargetPolicyBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The policy bindings bound to the specified target.
	PolicyBindings []*PolicyBinding `protobuf:"bytes,1,rep,name=policy_bindings,json=policyBindings,proto3" json:"policy_bindings,omitempty"`
	// Optional. A token, which can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchTargetPolicyBindingsResponse) Reset() {
	*x = SearchTargetPolicyBindingsResponse{}
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTargetPolicyBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTargetPolicyBindingsResponse) ProtoMessage() {}

func (x *SearchTargetPolicyBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_policy_bindings_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTargetPolicyBindingsResponse.ProtoReflect.Descriptor instead.
func (*SearchTargetPolicyBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_policy_bindings_service_proto_rawDescGZIP(), []int{7}
}

func (x *SearchTargetPolicyBindingsResponse) GetPolicyBindings() []*PolicyBinding {
	if x != nil {
		return x.PolicyBindings
	}
	return nil
}

func (x *SearchTargetPolicyBindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_iam_v3_policy_bindings_service_proto protoreflect.FileDescriptor

var file_google_iam_v3_policy_bindings_service_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x33, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x69, 0x61, 0x6d, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x83, 0x02, 0x0a, 0x1a, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x12, 0x20, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x0e, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22,
	0x57, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd2, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0d, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9d, 0x01,
	0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xc0, 0x01,
	0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x22, 0x12, 0x20, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x22, 0x90, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x45, 0x0a, 0x0f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xc8, 0x01, 0x0a, 0x21, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x40, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x98,
	0x01, 0x0a, 0x22, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0e, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2b, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xa0, 0x11, 0x0a, 0x0e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x8c, 0x03, 0x0a,
	0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaa,
	0x02, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2c, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd4, 0x01, 0x3a, 0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5a, 0x43, 0x3a, 0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x31, 0x2f, 0x76, 0x33, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x49, 0x3a, 0x0e,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x37,
	0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x32, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x8d, 0x02, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xb2, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa4, 0x01, 0x5a, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x33, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x39, 0x12, 0x37,
	0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x32, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xac, 0x03, 0x0a, 0x13,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xca, 0x02,
	0xca, 0x41, 0x22, 0x0a, 0x0d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x81, 0x02, 0x3a, 0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5a, 0x52, 0x3a, 0x0e, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32, 0x40, 0x2f, 0x76, 0x33,
	0x2f, 0x7b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x58, 0x3a,
	0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32,
	0x46, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x41, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc1, 0x02, 0x0a, 0x13, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdf, 0x01, 0xca,
	0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa4, 0x01, 0x5a, 0x33, 0x2a, 0x31, 0x2f, 0x76,
	0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a,
	0x39, 0x2a, 0x37, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x32, 0x2f, 0x76, 0x33, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa0,
	0x02, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb4, 0x01, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa4, 0x01, 0x5a, 0x33, 0x12,
	0x31, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x5a, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x32, 0x2f,
	0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x90, 0x03, 0x0a, 0x1a, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x33, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8c, 0x02, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf5, 0x01, 0x5a,
	0x4e, 0x12, 0x4c, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5a,
	0x54, 0x12, 0x52, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4d, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x1a, 0x46, 0xca, 0x41, 0x12, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xb4, 0x02, 0xea,
	0x41, 0x5c, 0x0a, 0x27, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41,
	0x4a, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x11, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x42, 0x1a,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x69, 0x61, 0x6d, 0x70,
	0x62, 0x3b, 0x69, 0x61, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x49, 0x61, 0x6d, 0x2e, 0x56, 0x33, 0xca, 0x02, 0x13,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x49, 0x61, 0x6d,
	0x5c, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_iam_v3_policy_bindings_service_proto_rawDescOnce sync.Once
	file_google_iam_v3_policy_bindings_service_proto_rawDescData = file_google_iam_v3_policy_bindings_service_proto_rawDesc
)

func file_google_iam_v3_policy_bindings_service_proto_rawDescGZIP() []byte {
	file_google_iam_v3_policy_bindings_service_proto_rawDescOnce.Do(func() {
		file_google_iam_v3_policy_bindings_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_iam_v3_policy_bindings_service_proto_rawDescData)
	})
	return file_google_iam_v3_policy_bindings_service_proto_rawDescData
}

var file_google_iam_v3_policy_bindings_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_iam_v3_policy_bindings_service_proto_goTypes = []any{
	(*CreatePolicyBindingRequest)(nil),         // 0: google.iam.v3.CreatePolicyBindingRequest
	(*GetPolicyBindingRequest)(nil),            // 1: google.iam.v3.GetPolicyBindingRequest
	(*UpdatePolicyBindingRequest)(nil),         // 2: google.iam.v3.UpdatePolicyBindingRequest
	(*DeletePolicyBindingRequest)(nil),         // 3: google.iam.v3.DeletePolicyBindingRequest
	(*ListPolicyBindingsRequest)(nil),          // 4: google.iam.v3.ListPolicyBindingsRequest
	(*ListPolicyBindingsResponse)(nil),         // 5: google.iam.v3.ListPolicyBindingsResponse
	(*SearchTargetPolicyBindingsRequest)(nil),  // 6: google.iam.v3.SearchTargetPolicyBindingsRequest
	(*SearchTargetPolicyBindingsResponse)(nil), // 7: google.iam.v3.SearchTargetPolicyBindingsResponse
	(*PolicyBinding)(nil),                      // 8: google.iam.v3.PolicyBinding
	(*fieldmaskpb.FieldMask)(nil),              // 9: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),            // 10: google.longrunning.Operation
}
var file_google_iam_v3_policy_bindings_service_proto_depIdxs = []int32{
	8,  // 0: google.iam.v3.CreatePolicyBindingRequest.policy_binding:type_name -> google.iam.v3.PolicyBinding
	8,  // 1: google.iam.v3.UpdatePolicyBindingRequest.policy_binding:type_name -> google.iam.v3.PolicyBinding
	9,  // 2: google.iam.v3.UpdatePolicyBindingRequest.update_mask:type_name -> google.protobuf.FieldMask
	8,  // 3: google.iam.v3.ListPolicyBindingsResponse.policy_bindings:type_name -> google.iam.v3.PolicyBinding
	8,  // 4: google.iam.v3.SearchTargetPolicyBindingsResponse.policy_bindings:type_name -> google.iam.v3.PolicyBinding
	0,  // 5: google.iam.v3.PolicyBindings.CreatePolicyBinding:input_type -> google.iam.v3.CreatePolicyBindingRequest
	1,  // 6: google.iam.v3.PolicyBindings.GetPolicyBinding:input_type -> google.iam.v3.GetPolicyBindingRequest
	2,  // 7: google.iam.v3.PolicyBindings.UpdatePolicyBinding:input_type -> google.iam.v3.UpdatePolicyBindingRequest
	3,  // 8: google.iam.v3.PolicyBindings.DeletePolicyBinding:input_type -> google.iam.v3.DeletePolicyBindingRequest
	4,  // 9: google.iam.v3.PolicyBindings.ListPolicyBindings:input_type -> google.iam.v3.ListPolicyBindingsRequest
	6,  // 10: google.iam.v3.PolicyBindings.SearchTargetPolicyBindings:input_type -> google.iam.v3.SearchTargetPolicyBindingsRequest
	10, // 11: google.iam.v3.PolicyBindings.CreatePolicyBinding:output_type -> google.longrunning.Operation
	8,  // 12: google.iam.v3.PolicyBindings.GetPolicyBinding:output_type -> google.iam.v3.PolicyBinding
	10, // 13: google.iam.v3.PolicyBindings.UpdatePolicyBinding:output_type -> google.longrunning.Operation
	10, // 14: google.iam.v3.PolicyBindings.DeletePolicyBinding:output_type -> google.longrunning.Operation
	5,  // 15: google.iam.v3.PolicyBindings.ListPolicyBindings:output_type -> google.iam.v3.ListPolicyBindingsResponse
	7,  // 16: google.iam.v3.PolicyBindings.SearchTargetPolicyBindings:output_type -> google.iam.v3.SearchTargetPolicyBindingsResponse
	11, // [11:17] is the sub-list for method output_type
	5,  // [5:11] is the sub-list for method input_type
	5,  // [5:5] is the sub-list for extension type_name
	5,  // [5:5] is the sub-list for extension extendee
	0,  // [0:5] is the sub-list for field type_name
}

func init() { file_google_iam_v3_policy_bindings_service_proto_init() }
func file_google_iam_v3_policy_bindings_service_proto_init() {
	if File_google_iam_v3_policy_bindings_service_proto != nil {
		return
	}
	file_google_iam_v3_operation_metadata_proto_init()
	file_google_iam_v3_policy_binding_resources_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_iam_v3_policy_bindings_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_iam_v3_policy_bindings_service_proto_goTypes,
		DependencyIndexes: file_google_iam_v3_policy_bindings_service_proto_depIdxs,
		MessageInfos:      file_google_iam_v3_policy_bindings_service_proto_msgTypes,
	}.Build()
	File_google_iam_v3_policy_bindings_service_proto = out.File
	file_google_iam_v3_policy_bindings_service_proto_rawDesc = nil
	file_google_iam_v3_policy_bindings_service_proto_goTypes = nil
	file_google_iam_v3_policy_bindings_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PolicyBindingsClient is the client API for PolicyBindings service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PolicyBindingsClient interface {
	// Creates a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on both the policy and target.
	// Once the binding is created, the policy is applied to the target.
	CreatePolicyBinding(ctx context.Context, in *CreatePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a policy binding.
	GetPolicyBinding(ctx context.Context, in *GetPolicyBindingRequest, opts ...grpc.CallOption) (*PolicyBinding, error)
	// Updates a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on the policy and target in the
	// binding to update, and the IAM permission to remove the existing policy
	// from the binding. Target is immutable and cannot be updated. Once the
	// binding is updated, the new policy is applied to the target.
	UpdatePolicyBinding(ctx context.Context, in *UpdatePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on both the policy and target.
	// Once the binding is deleted, the policy no longer applies to the target.
	DeletePolicyBinding(ctx context.Context, in *DeletePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists policy bindings.
	ListPolicyBindings(ctx context.Context, in *ListPolicyBindingsRequest, opts ...grpc.CallOption) (*ListPolicyBindingsResponse, error)
	// Search policy bindings by target. Returns all policy binding objects bound
	// directly to target.
	SearchTargetPolicyBindings(ctx context.Context, in *SearchTargetPolicyBindingsRequest, opts ...grpc.CallOption) (*SearchTargetPolicyBindingsResponse, error)
}

type policyBindingsClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyBindingsClient(cc grpc.ClientConnInterface) PolicyBindingsClient {
	return &policyBindingsClient{cc}
}

func (c *policyBindingsClient) CreatePolicyBinding(ctx context.Context, in *CreatePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PolicyBindings/CreatePolicyBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) GetPolicyBinding(ctx context.Context, in *GetPolicyBindingRequest, opts ...grpc.CallOption) (*PolicyBinding, error) {
	out := new(PolicyBinding)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PolicyBindings/GetPolicyBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) UpdatePolicyBinding(ctx context.Context, in *UpdatePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PolicyBindings/UpdatePolicyBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) DeletePolicyBinding(ctx context.Context, in *DeletePolicyBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PolicyBindings/DeletePolicyBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) ListPolicyBindings(ctx context.Context, in *ListPolicyBindingsRequest, opts ...grpc.CallOption) (*ListPolicyBindingsResponse, error) {
	out := new(ListPolicyBindingsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PolicyBindings/ListPolicyBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBindingsClient) SearchTargetPolicyBindings(ctx context.Context, in *SearchTargetPolicyBindingsRequest, opts ...grpc.CallOption) (*SearchTargetPolicyBindingsResponse, error) {
	out := new(SearchTargetPolicyBindingsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PolicyBindings/SearchTargetPolicyBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyBindingsServer is the server API for PolicyBindings service.
type PolicyBindingsServer interface {
	// Creates a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on both the policy and target.
	// Once the binding is created, the policy is applied to the target.
	CreatePolicyBinding(context.Context, *CreatePolicyBindingRequest) (*longrunningpb.Operation, error)
	// Gets a policy binding.
	GetPolicyBinding(context.Context, *GetPolicyBindingRequest) (*PolicyBinding, error)
	// Updates a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on the policy and target in the
	// binding to update, and the IAM permission to remove the existing policy
	// from the binding. Target is immutable and cannot be updated. Once the
	// binding is updated, the new policy is applied to the target.
	UpdatePolicyBinding(context.Context, *UpdatePolicyBindingRequest) (*longrunningpb.Operation, error)
	// Deletes a policy binding and returns a long-running operation.
	// Callers will need the IAM permissions on both the policy and target.
	// Once the binding is deleted, the policy no longer applies to the target.
	DeletePolicyBinding(context.Context, *DeletePolicyBindingRequest) (*longrunningpb.Operation, error)
	// Lists policy bindings.
	ListPolicyBindings(context.Context, *ListPolicyBindingsRequest) (*ListPolicyBindingsResponse, error)
	// Search policy bindings by target. Returns all policy binding objects bound
	// directly to target.
	SearchTargetPolicyBindings(context.Context, *SearchTargetPolicyBindingsRequest) (*SearchTargetPolicyBindingsResponse, error)
}

// UnimplementedPolicyBindingsServer can be embedded to have forward compatible implementations.
type UnimplementedPolicyBindingsServer struct {
}

func (*UnimplementedPolicyBindingsServer) CreatePolicyBinding(context.Context, *CreatePolicyBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePolicyBinding not implemented")
}
func (*UnimplementedPolicyBindingsServer) GetPolicyBinding(context.Context, *GetPolicyBindingRequest) (*PolicyBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicyBinding not implemented")
}
func (*UnimplementedPolicyBindingsServer) UpdatePolicyBinding(context.Context, *UpdatePolicyBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePolicyBinding not implemented")
}
func (*UnimplementedPolicyBindingsServer) DeletePolicyBinding(context.Context, *DeletePolicyBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePolicyBinding not implemented")
}
func (*UnimplementedPolicyBindingsServer) ListPolicyBindings(context.Context, *ListPolicyBindingsRequest) (*ListPolicyBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPolicyBindings not implemented")
}
func (*UnimplementedPolicyBindingsServer) SearchTargetPolicyBindings(context.Context, *SearchTargetPolicyBindingsRequest) (*SearchTargetPolicyBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchTargetPolicyBindings not implemented")
}

func RegisterPolicyBindingsServer(s *grpc.Server, srv PolicyBindingsServer) {
	s.RegisterService(&_PolicyBindings_serviceDesc, srv)
}

func _PolicyBindings_CreatePolicyBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePolicyBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).CreatePolicyBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PolicyBindings/CreatePolicyBinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).CreatePolicyBinding(ctx, req.(*CreatePolicyBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_GetPolicyBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).GetPolicyBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PolicyBindings/GetPolicyBinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).GetPolicyBinding(ctx, req.(*GetPolicyBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_UpdatePolicyBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).UpdatePolicyBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PolicyBindings/UpdatePolicyBinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).UpdatePolicyBinding(ctx, req.(*UpdatePolicyBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_DeletePolicyBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePolicyBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).DeletePolicyBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PolicyBindings/DeletePolicyBinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).DeletePolicyBinding(ctx, req.(*DeletePolicyBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_ListPolicyBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPolicyBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).ListPolicyBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PolicyBindings/ListPolicyBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).ListPolicyBindings(ctx, req.(*ListPolicyBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBindings_SearchTargetPolicyBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchTargetPolicyBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBindingsServer).SearchTargetPolicyBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PolicyBindings/SearchTargetPolicyBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBindingsServer).SearchTargetPolicyBindings(ctx, req.(*SearchTargetPolicyBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PolicyBindings_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.v3.PolicyBindings",
	HandlerType: (*PolicyBindingsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePolicyBinding",
			Handler:    _PolicyBindings_CreatePolicyBinding_Handler,
		},
		{
			MethodName: "GetPolicyBinding",
			Handler:    _PolicyBindings_GetPolicyBinding_Handler,
		},
		{
			MethodName: "UpdatePolicyBinding",
			Handler:    _PolicyBindings_UpdatePolicyBinding_Handler,
		},
		{
			MethodName: "DeletePolicyBinding",
			Handler:    _PolicyBindings_DeletePolicyBinding_Handler,
		},
		{
			MethodName: "ListPolicyBindings",
			Handler:    _PolicyBindings_ListPolicyBindings_Handler,
		},
		{
			MethodName: "SearchTargetPolicyBindings",
			Handler:    _PolicyBindings_SearchTargetPolicyBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/iam/v3/policy_bindings_service.proto",
}
