// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package run provides access to the Cloud Run Admin API.
//
// For product documentation, see: https://cloud.google.com/run/
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/run/v1alpha1"
//	...
//	ctx := context.Background()
//	runService, err := run.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	runService, err := run.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	runService, err := run.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package run // import "google.golang.org/api/run/v1alpha1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "run:v1alpha1"
const apiName = "run"
const apiVersion = "v1alpha1"
const basePath = "https://run.googleapis.com/"
const mtlsBasePath = "https://run.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Namespaces = NewNamespacesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Namespaces *NamespacesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewNamespacesService(s *Service) *NamespacesService {
	rs := &NamespacesService{s: s}
	rs.Jobs = NewNamespacesJobsService(s)
	return rs
}

type NamespacesService struct {
	s *Service

	Jobs *NamespacesJobsService
}

func NewNamespacesJobsService(s *Service) *NamespacesJobsService {
	rs := &NamespacesJobsService{s: s}
	return rs
}

type NamespacesJobsService struct {
	s *Service
}

// ConfigMapEnvSource: Not supported by Cloud Run ConfigMapEnvSource
// selects a ConfigMap to populate the environment variables with. The
// contents of the target ConfigMap's Data field will represent the
// key-value pairs as environment variables.
type ConfigMapEnvSource struct {
	// LocalObjectReference: This field should not be used directly as it is
	// meant to be inlined directly into the message. Use the "name" field
	// instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`

	// Name: The ConfigMap to select from.
	Name string `json:"name,omitempty"`

	// Optional: (Optional) Specify whether the ConfigMap must be defined
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LocalObjectReference") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocalObjectReference") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ConfigMapEnvSource) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigMapEnvSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConfigMapKeySelector: Not supported by Cloud Run Selects a key from a
// ConfigMap.
type ConfigMapKeySelector struct {
	// Key: The key to select.
	Key string `json:"key,omitempty"`

	// LocalObjectReference: This field should not be used directly as it is
	// meant to be inlined directly into the message. Use the "name" field
	// instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`

	// Name: The ConfigMap to select from.
	Name string `json:"name,omitempty"`

	// Optional: (Optional) Specify whether the ConfigMap or its key must be
	// defined
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConfigMapKeySelector) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigMapKeySelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConfigMapVolumeSource: Not supported by Cloud Run Adapts a ConfigMap
// into a volume. The contents of the target ConfigMap's Data field will
// be presented in a volume as files using the keys in the Data field as
// the file names, unless the items element is populated with specific
// mappings of keys to paths.
type ConfigMapVolumeSource struct {
	// DefaultMode: (Optional) Integer representation of mode bits to use on
	// created files by default. Must be a value between 01 and 0777
	// (octal). If 0 or not set, it will default to 0644. Directories within
	// the path are not affected by this setting. Notes * Internally, a
	// umask of 0222 will be applied to any non-zero value. * This is an
	// integer representation of the mode bits. So, the octal integer value
	// should look exactly as the chmod numeric notation with a leading
	// zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or
	// 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416
	// (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or
	// 493 (base-10). * This might be in conflict with other options that
	// affect the file mode, like fsGroup, and the result can be other mode
	// bits set.
	DefaultMode int64 `json:"defaultMode,omitempty"`

	// Items: (Optional) If unspecified, each key-value pair in the Data
	// field of the referenced Secret will be projected into the volume as a
	// file whose name is the key and content is the value. If specified,
	// the listed keys will be projected into the specified paths, and
	// unlisted keys will not be present. If a key is specified that is not
	// present in the Secret, the volume setup will error unless it is
	// marked optional.
	Items []*KeyToPath `json:"items,omitempty"`

	// Name: Name of the config.
	Name string `json:"name,omitempty"`

	// Optional: (Optional) Specify whether the Secret or its keys must be
	// defined.
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultMode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultMode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConfigMapVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigMapVolumeSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Container: A single application container. This specifies both the
// container to run, the command to run in the container and the
// arguments to supply to it. Note that additional arguments may be
// supplied by the system to the container at runtime.
type Container struct {
	// Args: (Optional) Arguments to the entrypoint. The docker image's CMD
	// is used if this is not provided. Variable references $(VAR_NAME) are
	// expanded using the container's environment. If a variable cannot be
	// resolved, the reference in the input string will be unchanged. The
	// $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
	// Escaped references will never be expanded, regardless of whether the
	// variable exists or not. More info:
	// https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	Args []string `json:"args,omitempty"`

	Command []string `json:"command,omitempty"`

	// Env: (Optional) List of environment variables to set in the
	// container.
	Env []*EnvVar `json:"env,omitempty"`

	// EnvFrom: (Optional) List of sources to populate environment variables
	// in the container. The keys defined within a source must be a
	// C_IDENTIFIER. All invalid keys will be reported as an event when the
	// container is starting. When a key exists in multiple sources, the
	// value associated with the last source will take precedence. Values
	// defined by an Env with a duplicate key will take precedence. Cannot
	// be updated.
	EnvFrom []*EnvFromSource `json:"envFrom,omitempty"`

	// Image: Only supports containers from Google Container Registry or
	// Artifact Registry URL of the Container image. More info:
	// https://kubernetes.io/docs/concepts/containers/images
	Image string `json:"image,omitempty"`

	// ImagePullPolicy: (Optional) Image pull policy. One of Always, Never,
	// IfNotPresent. Defaults to Always if :latest tag is specified, or
	// IfNotPresent otherwise. More info:
	// https://kubernetes.io/docs/concepts/containers/images#updating-images
	ImagePullPolicy string `json:"imagePullPolicy,omitempty"`

	// LivenessProbe: (Optional) Periodic probe of container liveness.
	// Container will be restarted if the probe fails. More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	LivenessProbe *Probe `json:"livenessProbe,omitempty"`

	// Name: (Optional) Name of the container specified as a DNS_LABEL.
	// Currently unused in Cloud Run. More info:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-label-names
	Name string `json:"name,omitempty"`

	// Ports: (Optional) List of ports to expose from the container. Only a
	// single port can be specified. The specified ports must be listening
	// on all interfaces (0.0.0.0) within the container to be accessible. If
	// omitted, a port number will be chosen and passed to the container
	// through the PORT environment variable for the container to listen on.
	Ports []*ContainerPort `json:"ports,omitempty"`

	// ReadinessProbe: (Optional) Periodic probe of container service
	// readiness. Container will be removed from service endpoints if the
	// probe fails. More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	ReadinessProbe *Probe `json:"readinessProbe,omitempty"`

	// Resources: (Optional) Compute Resources required by this container.
	// More info:
	// https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
	Resources *ResourceRequirements `json:"resources,omitempty"`

	// SecurityContext: (Optional) Security options the pod should run with.
	// More info:
	// https://kubernetes.io/docs/concepts/policy/security-context/ More
	// info:
	// https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
	SecurityContext *SecurityContext `json:"securityContext,omitempty"`

	// StartupProbe: (Optional) Startup probe of application within the
	// container. All other probes are disabled if a startup probe is
	// provided, until it succeeds. Container will not be added to service
	// endpoints if the probe fails. More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	StartupProbe *Probe `json:"startupProbe,omitempty"`

	// TerminationMessagePath: (Optional) Path at which the file to which
	// the container's termination message will be written is mounted into
	// the container's filesystem. Message written is intended to be brief
	// final status, such as an assertion failure message. Will be truncated
	// by the node if greater than 4096 bytes. The total message length
	// across all containers will be limited to 12kb. Defaults to
	// /dev/termination-log.
	TerminationMessagePath string `json:"terminationMessagePath,omitempty"`

	// TerminationMessagePolicy: (Optional) Indicate how the termination
	// message should be populated. File will use the contents of
	// terminationMessagePath to populate the container status message on
	// both success and failure. FallbackToLogsOnError will use the last
	// chunk of container log output if the termination message file is
	// empty and the container exited with an error. The log output is
	// limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to
	// File. Cannot be updated.
	TerminationMessagePolicy string `json:"terminationMessagePolicy,omitempty"`

	// VolumeMounts: (Optional) Volume to mount into the container's
	// filesystem. Only supports SecretVolumeSources. Pod volumes to mount
	// into the container's filesystem.
	VolumeMounts []*VolumeMount `json:"volumeMounts,omitempty"`

	// WorkingDir: (Optional) Container's working directory. If not
	// specified, the container runtime's default will be used, which might
	// be configured in the container image.
	WorkingDir string `json:"workingDir,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Container) MarshalJSON() ([]byte, error) {
	type NoMethod Container
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContainerPort: ContainerPort represents a network port in a single
// container.
type ContainerPort struct {
	// ContainerPort: (Optional) Port number the container listens on. This
	// must be a valid port number, 0 < x < 65536.
	ContainerPort int64 `json:"containerPort,omitempty"`

	// Name: (Optional) If specified, used to specify which protocol to use.
	// Allowed values are "http1" and "h2c".
	Name string `json:"name,omitempty"`

	// Protocol: (Optional) Protocol for port. Must be "TCP". Defaults to
	// "TCP".
	Protocol string `json:"protocol,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainerPort") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainerPort") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContainerPort) MarshalJSON() ([]byte, error) {
	type NoMethod ContainerPort
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// EnvFromSource: Not supported by Cloud Run EnvFromSource represents
// the source of a set of ConfigMaps
type EnvFromSource struct {
	// ConfigMapRef: (Optional) The ConfigMap to select from
	ConfigMapRef *ConfigMapEnvSource `json:"configMapRef,omitempty"`

	// Prefix: (Optional) An optional identifier to prepend to each key in
	// the ConfigMap. Must be a C_IDENTIFIER.
	Prefix string `json:"prefix,omitempty"`

	// SecretRef: (Optional) The Secret to select from
	SecretRef *SecretEnvSource `json:"secretRef,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfigMapRef") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigMapRef") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnvFromSource) MarshalJSON() ([]byte, error) {
	type NoMethod EnvFromSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnvVar: EnvVar represents an environment variable present in a
// Container.
type EnvVar struct {
	// Name: Name of the environment variable. Must be a C_IDENTIFIER.
	Name string `json:"name,omitempty"`

	// Value: (Optional) Variable references $(VAR_NAME) are expanded using
	// the previous defined environment variables in the container and any
	// route environment variables. If a variable cannot be resolved, the
	// reference in the input string will be unchanged. The $(VAR_NAME)
	// syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
	// references will never be expanded, regardless of whether the variable
	// exists or not. Defaults to "".
	Value string `json:"value,omitempty"`

	// ValueFrom: (Optional) Source for the environment variable's value.
	// Only supports secret_key_ref. Source for the environment variable's
	// value. Cannot be used if value is not empty.
	ValueFrom *EnvVarSource `json:"valueFrom,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnvVar) MarshalJSON() ([]byte, error) {
	type NoMethod EnvVar
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnvVarSource: EnvVarSource represents a source for the value of an
// EnvVar.
type EnvVarSource struct {
	// ConfigMapKeyRef: (Optional) Not supported by Cloud Run Selects a key
	// of a ConfigMap.
	ConfigMapKeyRef *ConfigMapKeySelector `json:"configMapKeyRef,omitempty"`

	// SecretKeyRef: (Optional) Selects a key (version) of a secret in
	// Secret Manager.
	SecretKeyRef *SecretKeySelector `json:"secretKeyRef,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfigMapKeyRef") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigMapKeyRef") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EnvVarSource) MarshalJSON() ([]byte, error) {
	type NoMethod EnvVarSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExecAction: Not supported by Cloud Run ExecAction describes a "run in
// container" action.
type ExecAction struct {
	// Command: (Optional) Command is the command line to execute inside the
	// container, the working directory for the command is root ('/') in the
	// container's filesystem. The command is simply exec'd, it is not run
	// inside a shell, so traditional shell instructions ('|', etc) won't
	// work. To use a shell, you need to explicitly call out to that shell.
	// Exit status of 0 is treated as live/healthy and non-zero is
	// unhealthy.
	Command []string `json:"command,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Command") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Command") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExecAction) MarshalJSON() ([]byte, error) {
	type NoMethod ExecAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GRPCAction: Not supported by Cloud Run GRPCAction describes an action
// involving a GRPC port.
type GRPCAction struct {
	// Port: Port number of the gRPC service. Number must be in the range 1
	// to 65535.
	Port int64 `json:"port,omitempty"`

	// Service: Service is the name of the service to place in the gRPC
	// HealthCheckRequest (see
	// https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If
	// this is not specified, the default behavior is defined by gRPC.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Port") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Port") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GRPCAction) MarshalJSON() ([]byte, error) {
	type NoMethod GRPCAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HTTPGetAction: Not supported by Cloud Run HTTPGetAction describes an
// action based on HTTP Get requests.
type HTTPGetAction struct {
	// Host: (Optional) Host name to connect to, defaults to the pod IP. You
	// probably want to set "Host" in httpHeaders instead.
	Host string `json:"host,omitempty"`

	// HttpHeaders: (Optional) Custom headers to set in the request. HTTP
	// allows repeated headers.
	HttpHeaders []*HTTPHeader `json:"httpHeaders,omitempty"`

	// Path: (Optional) Path to access on the HTTP server.
	Path string `json:"path,omitempty"`

	// Scheme: (Optional) Scheme to use for connecting to the host. Defaults
	// to HTTP.
	Scheme string `json:"scheme,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTPGetAction) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPGetAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HTTPHeader: Not supported by Cloud Run HTTPHeader describes a custom
// header to be used in HTTP probes
type HTTPHeader struct {
	// Name: The header field name
	Name string `json:"name,omitempty"`

	// Value: The header field value
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTPHeader) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceAttemptResult: Result of an instance attempt.
type InstanceAttemptResult struct {
	// ExitCode: Optional. The exit code of this attempt. This may be unset
	// if the container was unable to exit cleanly with a code due to some
	// other failure. See status field for possible failure details.
	ExitCode int64 `json:"exitCode,omitempty"`

	// Status: Optional. The status of this attempt. If the status code is
	// OK, then the attempt succeeded.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExitCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExitCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceAttemptResult) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceAttemptResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceSpec: InstanceSpec is a description of an instance.
type InstanceSpec struct {
	// ActiveDeadlineSeconds: Optional. Optional duration in seconds the
	// instance may be active relative to StartTime before the system will
	// actively try to mark it failed and kill associated containers. If set
	// to zero, the system will never attempt to kill an instance based on
	// time. Otherwise, value must be a positive integer. +optional
	ActiveDeadlineSeconds int64 `json:"activeDeadlineSeconds,omitempty,string"`

	// Containers: Optional. List of containers belonging to the instance.
	// We disallow a number of fields on this Container. Only a single
	// container may be provided.
	Containers []*Container `json:"containers,omitempty"`

	// RestartPolicy: Optional. Restart policy for all containers within the
	// instance. Allowed values are: - OnFailure: Instances will always be
	// restarted on failure if the backoffLimit has not been reached. -
	// Never: Instances are never restarted and all failures are permanent.
	// Cannot be used if backoffLimit is set. +optional
	RestartPolicy string `json:"restartPolicy,omitempty"`

	// ServiceAccountName: Optional. Email address of the IAM service
	// account associated with the instance of a Job. The service account
	// represents the identity of the running instance, and determines what
	// permissions the instance has. If not provided, the instance will use
	// the project's default service account. +optional
	ServiceAccountName string `json:"serviceAccountName,omitempty"`

	// TerminationGracePeriodSeconds: Optional. Optional duration in seconds
	// the instance needs to terminate gracefully. Value must be
	// non-negative integer. The value zero indicates delete immediately.
	// The grace period is the duration in seconds after the processes
	// running in the instance are sent a termination signal and the time
	// when the processes are forcibly halted with a kill signal. Set this
	// value longer than the expected cleanup time for your process.
	// +optional
	TerminationGracePeriodSeconds int64 `json:"terminationGracePeriodSeconds,omitempty,string"`

	// Volumes: Optional. List of volumes that can be mounted by containers
	// belonging to the instance. More info:
	// https://kubernetes.io/docs/concepts/storage/volumes +optional
	Volumes []*Volume `json:"volumes,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ActiveDeadlineSeconds") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActiveDeadlineSeconds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceSpec) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceStatus: Instance represents the status of an instance of a
// Job.
type InstanceStatus struct {
	// CompletionTime: Optional. Represents time when the instance was
	// completed. It is not guaranteed to be set in happens-before order
	// across separate operations. It is represented in RFC3339 form and is
	// in UTC. +optional
	CompletionTime string `json:"completionTime,omitempty"`

	// Failed: Optional. The number of times this instance exited with code
	// > 0; +optional
	Failed int64 `json:"failed,omitempty"`

	// Index: Required. Index of the instance, unique per Job, and beginning
	// at 0.
	Index int64 `json:"index,omitempty"`

	// LastAttemptResult: Optional. Result of the last attempt of this
	// instance. +optional
	LastAttemptResult *InstanceAttemptResult `json:"lastAttemptResult,omitempty"`

	// LastExitCode: Optional. Last exit code seen for this instance.
	// +optional
	LastExitCode int64 `json:"lastExitCode,omitempty"`

	// Restarted: Optional. The number of times this instance was restarted.
	// Instances are restarted according the restartPolicy configured in the
	// Job template. +optional
	Restarted int64 `json:"restarted,omitempty"`

	// StartTime: Optional. Represents time when the instance was created by
	// the job controller. It is not guaranteed to be set in happens-before
	// order across separate operations. It is represented in RFC3339 form
	// and is in UTC. +optional
	StartTime string `json:"startTime,omitempty"`

	// Succeeded: Optional. The number of times this instance exited with
	// code == 0. +optional
	Succeeded int64 `json:"succeeded,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompletionTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompletionTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceTemplateSpec: InstanceTemplateSpec describes the data an
// instance should have when created from a template.
type InstanceTemplateSpec struct {
	// Spec: Optional. Specification of the desired behavior of the
	// instance. More info:
	// https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
	// +optional
	Spec *InstanceSpec `json:"spec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Spec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Spec") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceTemplateSpec) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceTemplateSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Job: Job represents the configuration of a single job. A job an
// immutable resource that references a container image which is run to
// completion.
type Job struct {
	// ApiVersion: Optional. APIVersion defines the versioned schema of this
	// representation of an object. Servers should convert recognized
	// schemas to the latest internal value, and may reject unrecognized
	// values. More info:
	// https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
	// +optional
	ApiVersion string `json:"apiVersion,omitempty"`

	// Kind: Optional. Kind is a string value representing the REST resource
	// this object represents. Servers may infer this from the endpoint the
	// client submits requests to. Cannot be updated. In CamelCase. More
	// info:
	// https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	// +optional
	Kind string `json:"kind,omitempty"`

	// Metadata: Optional. Standard object's metadata. More info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *ObjectMeta `json:"metadata,omitempty"`

	// Spec: Optional. Specification of the desired behavior of a job. More
	// info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *JobSpec `json:"spec,omitempty"`

	// Status: Optional. Current status of a job. More info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status *JobStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Job) MarshalJSON() ([]byte, error) {
	type NoMethod Job
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JobCondition: JobCondition defines a readiness condition for a
// Revision.
type JobCondition struct {
	// LastTransitionTime: Optional. Last time the condition transitioned
	// from one status to another.
	LastTransitionTime string `json:"lastTransitionTime,omitempty"`

	// Message: Optional. Human readable message indicating details about
	// the current status.
	Message string `json:"message,omitempty"`

	// Reason: Optional. One-word CamelCase reason for the condition's last
	// transition.
	Reason string `json:"reason,omitempty"`

	// Severity: Optional. How to interpret failures of this condition, one
	// of Error, Warning, Info
	Severity string `json:"severity,omitempty"`

	// Status: Required. Status of the condition, one of True, False,
	// Unknown.
	Status string `json:"status,omitempty"`

	// Type: Required. Type is used to communicate the status of the
	// reconciliation process. See also:
	// https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
	// Types include: * "Completed": True when the Job has successfully
	// completed. * "Started": True when the Job has successfully started
	// running. * "ResourcesAvailable": True when underlying resources have
	// been provisioned.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LastTransitionTime")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LastTransitionTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *JobCondition) MarshalJSON() ([]byte, error) {
	type NoMethod JobCondition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JobSpec: JobSpec describes how the job execution will look like.
type JobSpec struct {
	// ActiveDeadlineSeconds: Optional. Not supported. Specifies the
	// duration in seconds relative to the startTime that the job may be
	// active before the system tries to terminate it. If set to zero, the
	// system will never attempt to terminate the job based on time.
	// Otherwise, the value must be positive integer. +optional
	ActiveDeadlineSeconds int64 `json:"activeDeadlineSeconds,omitempty,string"`

	// BackoffLimit: Optional. Specifies the number of retries per instance,
	// before marking this job failed. If set to zero, instances will never
	// retry on failure. +optional
	BackoffLimit int64 `json:"backoffLimit,omitempty"`

	// Completions: Optional. Specifies the desired number of successfully
	// finished instances the job should be run with. Setting to 1 means
	// that parallelism is limited to 1 and the success of that instance
	// signals the success of the job. More info:
	// https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
	// +optional
	Completions int64 `json:"completions,omitempty"`

	// Parallelism: Optional. Specifies the maximum desired number of
	// instances the job should run at any given time. Must be <=
	// completions. The actual number of instances running in steady state
	// will be less than this number when ((.spec.completions -
	// .status.successful) < .spec.parallelism), i.e. when the work left to
	// do is less than max parallelism. More info:
	// https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
	// +optional
	Parallelism int64 `json:"parallelism,omitempty"`

	// Template: Optional. Describes the instance that will be created when
	// executing a job.
	Template *InstanceTemplateSpec `json:"template,omitempty"`

	// TtlSecondsAfterFinished: Optional. Not supported.
	// ttlSecondsAfterFinished limits the lifetime of a Job that has
	// finished execution (either Complete or Failed). If this field is set,
	// ttlSecondsAfterFinished after the Job finishes, it is eligible to be
	// automatically deleted. When the Job is being deleted, its lifecycle
	// guarantees (e.g. finalizers) will be honored. If this field is set to
	// zero, the Job won't be automatically deleted. +optional
	TtlSecondsAfterFinished int64 `json:"ttlSecondsAfterFinished,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ActiveDeadlineSeconds") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActiveDeadlineSeconds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *JobSpec) MarshalJSON() ([]byte, error) {
	type NoMethod JobSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JobStatus: JobStatus represents the current state of a Job.
type JobStatus struct {
	// Active: Optional. The number of actively running instances. +optional
	Active int64 `json:"active,omitempty"`

	// CompletionTime: Optional. Represents time when the job was completed.
	// It is not guaranteed to be set in happens-before order across
	// separate operations. It is represented in RFC3339 form and is in UTC.
	// +optional
	CompletionTime string `json:"completionTime,omitempty"`

	// Conditions: Optional. The latest available observations of a job's
	// current state. More info:
	// https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
	// +optional
	Conditions []*JobCondition `json:"conditions,omitempty"`

	// Failed: Optional. The number of instances which reached phase Failed.
	// +optional
	Failed int64 `json:"failed,omitempty"`

	// ImageDigest: Optional. ImageDigest holds the resolved digest for the
	// image specified within .Spec.Template.Spec.Container.Image. The
	// digest is resolved during the creation of the Job. This field holds
	// the digest value regardless of whether a tag or digest was originally
	// specified in the Container object.
	ImageDigest string `json:"imageDigest,omitempty"`

	// Instances: Optional. Status of completed, failed, and running
	// instances. +optional
	Instances []*InstanceStatus `json:"instances,omitempty"`

	// ObservedGeneration: Optional. The 'generation' of the job that was
	// last processed by the controller.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`

	// StartTime: Optional. Represents time when the job was acknowledged by
	// the job controller. It is not guaranteed to be set in happens-before
	// order across separate operations. It is represented in RFC3339 form
	// and is in UTC. +optional
	StartTime string `json:"startTime,omitempty"`

	// Succeeded: Optional. The number of instances which reached phase
	// Succeeded. +optional
	Succeeded int64 `json:"succeeded,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Active") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *JobStatus) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// KeyToPath: Maps a string key to a path within a volume.
type KeyToPath struct {
	// Key: The Cloud Secret Manager secret version. Can be 'latest' for the
	// latest value or an integer for a specific version. The key to
	// project.
	Key string `json:"key,omitempty"`

	// Mode: (Optional) Mode bits to use on this file, must be a value
	// between 01 and 0777 (octal). If 0 or not set, the Volume's default
	// mode will be used. Notes * Internally, a umask of 0222 will be
	// applied to any non-zero value. * This is an integer representation of
	// the mode bits. So, the octal integer value should look exactly as the
	// chmod numeric notation with a leading zero. Some examples: for chmod
	// 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640
	// (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755
	// (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might
	// be in conflict with other options that affect the file mode, like
	// fsGroup, and the result can be other mode bits set.
	Mode int64 `json:"mode,omitempty"`

	// Path: The relative path of the file to map the key to. May not be an
	// absolute path. May not contain the path element '..'. May not start
	// with the string '..'.
	Path string `json:"path,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *KeyToPath) MarshalJSON() ([]byte, error) {
	type NoMethod KeyToPath
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListJobsResponse: ListJobsResponse is a list of Jobs resources.
type ListJobsResponse struct {
	// ApiVersion: The API version for this call such as
	// "run.googleapis.com/v1alpha1".
	ApiVersion string `json:"apiVersion,omitempty"`

	// Items: List of Jobs.
	Items []*Job `json:"items,omitempty"`

	// Kind: The kind of this resource, in this case "JobsList".
	Kind string `json:"kind,omitempty"`

	// Metadata: Metadata associated with this jobs list.
	Metadata *ListMeta `json:"metadata,omitempty"`

	// NextPageToken: This field is equivalent to the metadata.continue
	// field and is provided as a convenience for compatibility with
	// https://google.aip.dev/158. The value is opaque and may be used to
	// issue another request to the endpoint that served this list to
	// retrieve the next set of available objects. Continuing a list may not
	// be possible if the server configuration has changed or more than a
	// few minutes have passed. The metadata.resourceVersion field returned
	// when using this field will be identical to the value in the first
	// response.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListMeta: ListMeta describes metadata that synthetic resources must
// have, including lists and various status objects. A resource may have
// only one of {ObjectMeta, ListMeta}.
type ListMeta struct {
	// Continue: continue may be set if the user set a limit on the number
	// of items returned, and indicates that the server has more data
	// available. The value is opaque and may be used to issue another
	// request to the endpoint that served this list to retrieve the next
	// set of available objects. Continuing a list may not be possible if
	// the server configuration has changed or more than a few minutes have
	// passed. The resourceVersion field returned when using this continue
	// value will be identical to the value in the first response.
	Continue string `json:"continue,omitempty"`

	// ResourceVersion: String that identifies the server's internal version
	// of this object that can be used by clients to determine when objects
	// have changed. Value must be treated as opaque by clients and passed
	// unmodified back to the server. Populated by the system. Read-only.
	// More info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
	// +optional
	ResourceVersion string `json:"resourceVersion,omitempty"`

	// SelfLink: SelfLink is a URL representing this object. Populated by
	// the system. Read-only. +optional
	SelfLink string `json:"selfLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Continue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Continue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListMeta) MarshalJSON() ([]byte, error) {
	type NoMethod ListMeta
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LocalObjectReference: Not supported by Cloud Run LocalObjectReference
// contains enough information to let you locate the referenced object
// inside the same namespace.
type LocalObjectReference struct {
	// Name: (Optional) Name of the referent. More info:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocalObjectReference) MarshalJSON() ([]byte, error) {
	type NoMethod LocalObjectReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ObjectMeta: k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta is
// metadata that all persisted resources must have, which includes all
// objects users must create.
type ObjectMeta struct {
	// Annotations: (Optional) Annotations is an unstructured key value map
	// stored with a resource that may be set by external tools to store and
	// retrieve arbitrary metadata. They are not queryable and should be
	// preserved when modifying objects. More info:
	// https://kubernetes.io/docs/user-guide/annotations
	Annotations map[string]string `json:"annotations,omitempty"`

	// ClusterName: (Optional) Not supported by Cloud Run The name of the
	// cluster which the object belongs to. This is used to distinguish
	// resources with same name and namespace in different clusters. This
	// field is not set anywhere right now and apiserver is going to ignore
	// it if set in create or update request.
	ClusterName string `json:"clusterName,omitempty"`

	// CreationTimestamp: (Optional) CreationTimestamp is a timestamp
	// representing the server time when this object was created. It is not
	// guaranteed to be set in happens-before order across separate
	// operations. Clients may not set this value. It is represented in
	// RFC3339 form and is in UTC. Populated by the system. Read-only. Null
	// for lists. More info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// DeletionGracePeriodSeconds: (Optional) Not supported by Cloud Run
	// Number of seconds allowed for this object to gracefully terminate
	// before it will be removed from the system. Only set when
	// deletionTimestamp is also set. May only be shortened. Read-only.
	DeletionGracePeriodSeconds int64 `json:"deletionGracePeriodSeconds,omitempty"`

	// DeletionTimestamp: (Optional) Not supported by Cloud Run
	// DeletionTimestamp is RFC 3339 date and time at which this resource
	// will be deleted. This field is set by the server when a graceful
	// deletion is requested by the user, and is not directly settable by a
	// client. The resource is expected to be deleted (no longer visible
	// from resource lists, and not reachable by name) after the time in
	// this field, once the finalizers list is empty. As long as the
	// finalizers list contains items, deletion is blocked. Once the
	// deletionTimestamp is set, this value may not be unset or be set
	// further into the future, although it may be shortened or the resource
	// may be deleted prior to this time. For example, a user may request
	// that a pod is deleted in 30 seconds. The Kubelet will react by
	// sending a graceful termination signal to the containers in the pod.
	// After that 30 seconds, the Kubelet will send a hard termination
	// signal (SIGKILL) to the container and after cleanup, remove the pod
	// from the API. In the presence of network partitions, this object may
	// still exist after this timestamp, until an administrator or automated
	// process can determine the resource is fully terminated. If not set,
	// graceful deletion of the object has not been requested. Populated by
	// the system when a graceful deletion is requested. Read-only. More
	// info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	DeletionTimestamp string `json:"deletionTimestamp,omitempty"`

	// Finalizers: (Optional) Not supported by Cloud Run Must be empty
	// before the object is deleted from the registry. Each entry is an
	// identifier for the responsible component that will remove the entry
	// from the list. If the deletionTimestamp of the object is non-nil,
	// entries in this list can only be removed. +patchStrategy=merge
	Finalizers []string `json:"finalizers,omitempty"`

	// GenerateName: (Optional) Not supported by Cloud Run GenerateName is
	// an optional prefix, used by the server, to generate a unique name
	// ONLY IF the Name field has not been provided. If this field is used,
	// the name returned to the client will be different than the name
	// passed. This value will also be combined with a unique suffix. The
	// provided value has the same validation rules as the Name field, and
	// may be truncated by the length of the suffix required to make the
	// value unique on the server. If this field is specified and the
	// generated name exists, the server will NOT return a 409 - instead, it
	// will either return 201 Created or 500 with Reason ServerTimeout
	// indicating a unique name could not be found in the time allotted, and
	// the client should retry (optionally after the time indicated in the
	// Retry-After header). Applied only if Name is not specified. More
	// info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency
	// string generateName = 2;
	GenerateName string `json:"generateName,omitempty"`

	// Generation: (Optional) A sequence number representing a specific
	// generation of the desired state. Populated by the system. Read-only.
	Generation int64 `json:"generation,omitempty"`

	// Labels: (Optional) Map of string keys and values that can be used to
	// organize and categorize (scope and select) objects. May match
	// selectors of replication controllers and routes. More info:
	// https://kubernetes.io/docs/user-guide/labels
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Name must be unique within a namespace, within a Cloud Run
	// region. Is required when creating resources, although some resources
	// may allow a client to request the generation of an appropriate name
	// automatically. Name is primarily intended for creation idempotence
	// and configuration definition. Cannot be updated. More info:
	// https://kubernetes.io/docs/user-guide/identifiers#names +optional
	Name string `json:"name,omitempty"`

	// Namespace: Namespace defines the space within each name must be
	// unique, within a Cloud Run region. In Cloud Run the namespace must be
	// equal to either the project ID or project number.
	Namespace string `json:"namespace,omitempty"`

	// OwnerReferences: (Optional) Not supported by Cloud Run List of
	// objects that own this object. If ALL objects in the list have been
	// deleted, this object will be garbage collected.
	OwnerReferences []*OwnerReference `json:"ownerReferences,omitempty"`

	// ResourceVersion: Optional. An opaque value that represents the
	// internal version of this object that can be used by clients to
	// determine when objects have changed. May be used for optimistic
	// concurrency, change detection, and the watch operation on a resource
	// or set of resources. Clients must treat these values as opaque and
	// passed unmodified back to the server or omit the value to disable
	// conflict-detection. They may only be valid for a particular resource
	// or set of resources. Populated by the system. Read-only. Value must
	// be treated as opaque by clients or omitted. More info:
	// https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
	ResourceVersion string `json:"resourceVersion,omitempty"`

	// SelfLink: (Optional) SelfLink is a URL representing this object.
	// Populated by the system. Read-only. string selfLink = 4;
	SelfLink string `json:"selfLink,omitempty"`

	// Uid: (Optional) UID is the unique in time and space value for this
	// object. It is typically generated by the server on successful
	// creation of a resource and is not allowed to change on PUT
	// operations. Populated by the system. Read-only. More info:
	// https://kubernetes.io/docs/user-guide/identifiers#uids
	Uid string `json:"uid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ObjectMeta) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectMeta
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OwnerReference: OwnerReference contains enough information to let you
// identify an owning object. Currently, an owning object must be in the
// same namespace, so there is no namespace field.
type OwnerReference struct {
	// ApiVersion: API version of the referent.
	ApiVersion string `json:"apiVersion,omitempty"`

	// BlockOwnerDeletion: If true, AND if the owner has the
	// "foregroundDeletion" finalizer, then the owner cannot be deleted from
	// the key-value store until this reference is removed. Defaults to
	// false. To set this field, a user needs "delete" permission of the
	// owner, otherwise 422 (Unprocessable Entity) will be returned.
	// +optional
	BlockOwnerDeletion bool `json:"blockOwnerDeletion,omitempty"`

	// Controller: If true, this reference points to the managing
	// controller. +optional
	Controller bool `json:"controller,omitempty"`

	// Kind: Kind of the referent. More info:
	// https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	Kind string `json:"kind,omitempty"`

	// Name: Name of the referent. More info:
	// https://kubernetes.io/docs/user-guide/identifiers#names
	Name string `json:"name,omitempty"`

	// Uid: UID of the referent. More info:
	// https://kubernetes.io/docs/user-guide/identifiers#uids
	Uid string `json:"uid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OwnerReference) MarshalJSON() ([]byte, error) {
	type NoMethod OwnerReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Probe: Not supported by Cloud Run Probe describes a health check to
// be performed against a container to determine whether it is alive or
// ready to receive traffic.
type Probe struct {
	// Exec: (Optional) Not supported by Cloud Run One and only one of the
	// following should be specified. Exec specifies the action to take. A
	// field inlined from the Handler message.
	Exec *ExecAction `json:"exec,omitempty"`

	// FailureThreshold: (Optional) Minimum consecutive failures for the
	// probe to be considered failed after having succeeded. Defaults to 3.
	// Minimum value is 1.
	FailureThreshold int64 `json:"failureThreshold,omitempty"`

	// Grpc: (Optional) GRPCAction specifies an action involving a GRPC
	// port. A field inlined from the Handler message.
	Grpc *GRPCAction `json:"grpc,omitempty"`

	// HttpGet: (Optional) HTTPGet specifies the http request to perform. A
	// field inlined from the Handler message.
	HttpGet *HTTPGetAction `json:"httpGet,omitempty"`

	// InitialDelaySeconds: (Optional) Number of seconds after the container
	// has started before the probe is initiated. Defaults to 0 seconds.
	// Minimum value is 0. Maximum value for liveness probe is 3600. Maximum
	// value for startup probe is 240. More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	InitialDelaySeconds int64 `json:"initialDelaySeconds,omitempty"`

	// PeriodSeconds: (Optional) How often (in seconds) to perform the
	// probe. Default to 10 seconds. Minimum value is 1. Maximum value for
	// liveness probe is 3600. Maximum value for startup probe is 240. Must
	// be greater or equal than timeout_seconds.
	PeriodSeconds int64 `json:"periodSeconds,omitempty"`

	// SuccessThreshold: (Optional) Minimum consecutive successes for the
	// probe to be considered successful after having failed. Must be 1 if
	// set.
	SuccessThreshold int64 `json:"successThreshold,omitempty"`

	// TcpSocket: (Optional) TCPSocket specifies an action involving a TCP
	// port. TCP hooks not yet supported A field inlined from the Handler
	// message.
	TcpSocket *TCPSocketAction `json:"tcpSocket,omitempty"`

	// TimeoutSeconds: (Optional) Number of seconds after which the probe
	// times out. Defaults to 1 second. Minimum value is 1. Maximum value is
	// 3600. Must be smaller than period_seconds. More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	TimeoutSeconds int64 `json:"timeoutSeconds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Exec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Exec") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Probe) MarshalJSON() ([]byte, error) {
	type NoMethod Probe
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResourceRequirements: ResourceRequirements describes the compute
// resource requirements.
type ResourceRequirements struct {
	// Limits: (Optional) Only memory and CPU are supported. Limits
	// describes the maximum amount of compute resources allowed. The values
	// of the map is string form of the 'quantity' k8s type:
	// https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
	Limits map[string]string `json:"limits,omitempty"`

	// Requests: (Optional) Only memory and CPU are supported. Requests
	// describes the minimum amount of compute resources required. If
	// Requests is omitted for a container, it defaults to Limits if that is
	// explicitly specified, otherwise to an implementation-defined value.
	// The values of the map is string form of the 'quantity' k8s type:
	// https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
	Requests map[string]string `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Limits") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Limits") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResourceRequirements) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceRequirements
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecretEnvSource: Not supported by Cloud Run SecretEnvSource selects a
// Secret to populate the environment variables with. The contents of
// the target Secret's Data field will represent the key-value pairs as
// environment variables.
type SecretEnvSource struct {
	// LocalObjectReference: This field should not be used directly as it is
	// meant to be inlined directly into the message. Use the "name" field
	// instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`

	// Name: The Secret to select from.
	Name string `json:"name,omitempty"`

	// Optional: (Optional) Specify whether the Secret must be defined
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LocalObjectReference") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocalObjectReference") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SecretEnvSource) MarshalJSON() ([]byte, error) {
	type NoMethod SecretEnvSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecretKeySelector: SecretKeySelector selects a key of a Secret.
type SecretKeySelector struct {
	// Key: A Cloud Secret Manager secret version. Must be 'latest' for the
	// latest version or an integer for a specific version. The key of the
	// secret to select from. Must be a valid secret key.
	Key string `json:"key,omitempty"`

	// LocalObjectReference: This field should not be used directly as it is
	// meant to be inlined directly into the message. Use the "name" field
	// instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`

	// Name: The name of the secret in Cloud Secret Manager. By default, the
	// secret is assumed to be in the same project. If the secret is in
	// another project, you must define an alias. An alias definition has
	// the form: :projects//secrets/. If multiple alias definitions are
	// needed, they must be separated by commas. The alias definitions must
	// be set on the run.googleapis.com/secrets annotation. The name of the
	// secret in the pod's namespace to select from.
	Name string `json:"name,omitempty"`

	// Optional: (Optional) Specify whether the Secret or its key must be
	// defined
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecretKeySelector) MarshalJSON() ([]byte, error) {
	type NoMethod SecretKeySelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecretVolumeSource: The secret's value will be presented as the
// content of a file whose name is defined in the item path. If no items
// are defined, the name of the file is the secret_name. The contents of
// the target Secret's Data field will be presented in a volume as files
// using the keys in the Data field as the file names.
type SecretVolumeSource struct {
	// DefaultMode: Integer representation of mode bits to use on created
	// files by default. Must be a value between 01 and 0777 (octal). If 0
	// or not set, it will default to 0444. Directories within the path are
	// not affected by this setting. Notes * Internally, a umask of 0222
	// will be applied to any non-zero value. * This is an integer
	// representation of the mode bits. So, the octal integer value should
	// look exactly as the chmod numeric notation with a leading zero. Some
	// examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511
	// (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416
	// (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or
	// 493 (base-10). * This might be in conflict with other options that
	// affect the file mode, like fsGroup, and the result can be other mode
	// bits set.
	DefaultMode int64 `json:"defaultMode,omitempty"`

	// Items: (Optional) If unspecified, the volume will expose a file whose
	// name is the secret_name. If specified, the key will be used as the
	// version to fetch from Cloud Secret Manager and the path will be the
	// name of the file exposed in the volume. When items are defined, they
	// must specify a key and a path. If unspecified, each key-value pair in
	// the Data field of the referenced Secret will be projected into the
	// volume as a file whose name is the key and content is the value. If
	// specified, the listed keys will be projected into the specified
	// paths, and unlisted keys will not be present. If a key is specified
	// that is not present in the Secret, the volume setup will error unless
	// it is marked optional.
	Items []*KeyToPath `json:"items,omitempty"`

	// Optional: (Optional) Specify whether the Secret or its keys must be
	// defined.
	Optional bool `json:"optional,omitempty"`

	// SecretName: The name of the secret in Cloud Secret Manager. By
	// default, the secret is assumed to be in the same project. If the
	// secret is in another project, you must define an alias. An alias
	// definition has the form: :projects//secrets/. If multiple alias
	// definitions are needed, they must be separated by commas. The alias
	// definitions must be set on the run.googleapis.com/secrets annotation.
	// Name of the secret in the container's namespace to use.
	SecretName string `json:"secretName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultMode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultMode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecretVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod SecretVolumeSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecurityContext: Not supported by Cloud Run SecurityContext holds
// security configuration that will be applied to a container. Some
// fields are present in both SecurityContext and PodSecurityContext.
// When both are set, the values in SecurityContext take precedence.
type SecurityContext struct {
	// RunAsUser: (Optional) The UID to run the entrypoint of the container
	// process. Defaults to user specified in image metadata if unspecified.
	// May also be set in PodSecurityContext. If set in both SecurityContext
	// and PodSecurityContext, the value specified in SecurityContext takes
	// precedence.
	RunAsUser int64 `json:"runAsUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RunAsUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RunAsUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecurityContext) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TCPSocketAction: Not supported by Cloud Run TCPSocketAction describes
// an action based on opening a socket
type TCPSocketAction struct {
	// Host: (Optional) Optional: Host name to connect to, defaults to the
	// pod IP.
	Host string `json:"host,omitempty"`

	// Port: Number or name of the port to access on the container. Number
	// must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. This
	// field is currently limited to integer types only because of proto's
	// inability to properly support the IntOrString golang type.
	Port int64 `json:"port,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TCPSocketAction) MarshalJSON() ([]byte, error) {
	type NoMethod TCPSocketAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Volume: Volume represents a named volume in a container.
type Volume struct {
	ConfigMap *ConfigMapVolumeSource `json:"configMap,omitempty"`

	// Name: Volume's name. In Cloud Run Fully Managed, the name 'cloudsql'
	// is reserved.
	Name string `json:"name,omitempty"`

	Secret *SecretVolumeSource `json:"secret,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfigMap") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigMap") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Volume) MarshalJSON() ([]byte, error) {
	type NoMethod Volume
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VolumeMount: VolumeMount describes a mounting of a Volume within a
// container.
type VolumeMount struct {
	// MountPath: Path within the container at which the volume should be
	// mounted. Must not contain ':'.
	MountPath string `json:"mountPath,omitempty"`

	// Name: The name of the volume. There must be a corresponding Volume
	// with the same name.
	Name string `json:"name,omitempty"`

	// ReadOnly: (Optional) Only true is accepted. Defaults to true.
	ReadOnly bool `json:"readOnly,omitempty"`

	// SubPath: (Optional) Path within the volume from which the container's
	// volume should be mounted. Defaults to "" (volume's root).
	SubPath string `json:"subPath,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MountPath") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MountPath") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VolumeMount) MarshalJSON() ([]byte, error) {
	type NoMethod VolumeMount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "run.namespaces.jobs.create":

type NamespacesJobsCreateCall struct {
	s          *Service
	parent     string
	job        *Job
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a job.
//
//   - parent: The namespace in which the job should be created. Replace
//     {namespace_id} with the project ID or number.
func (r *NamespacesJobsService) Create(parent string, job *Job) *NamespacesJobsCreateCall {
	c := &NamespacesJobsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.job = job
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *NamespacesJobsCreateCall) Fields(s ...googleapi.Field) *NamespacesJobsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *NamespacesJobsCreateCall) Context(ctx context.Context) *NamespacesJobsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *NamespacesJobsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.job)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1alpha1/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.create" call.
// Exactly one of *Job or error will be non-nil. Any non-2xx status code
// is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesJobsCreateCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a job.",
	//   "flatPath": "apis/run.googleapis.com/v1alpha1/namespaces/{namespacesId}/jobs",
	//   "httpMethod": "POST",
	//   "id": "run.namespaces.jobs.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The namespace in which the job should be created. Replace {namespace_id} with the project ID or number.",
	//       "location": "path",
	//       "pattern": "^namespaces/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "apis/run.googleapis.com/v1alpha1/{+parent}/jobs",
	//   "request": {
	//     "$ref": "Job"
	//   },
	//   "response": {
	//     "$ref": "Job"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "run.namespaces.jobs.delete":

type NamespacesJobsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a job.
//
//   - name: The name of the job to delete. For Cloud Run (fully managed),
//     replace {namespace_id} with the project ID or number.
func (r *NamespacesJobsService) Delete(name string) *NamespacesJobsDeleteCall {
	c := &NamespacesJobsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Cloud Run
// currently ignores this parameter.
func (c *NamespacesJobsDeleteCall) ApiVersion(apiVersion string) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// Kind sets the optional parameter "kind": Cloud Run currently ignores
// this parameter.
func (c *NamespacesJobsDeleteCall) Kind(kind string) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy":
// Specifies the propagation policy of delete. Cloud Run currently
// ignores this setting, and deletes in the background. Please see
// kubernetes.io/docs/concepts/workloads/controllers/garbage-collection/
// for more information.
func (c *NamespacesJobsDeleteCall) PropagationPolicy(propagationPolicy string) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *NamespacesJobsDeleteCall) Fields(s ...googleapi.Field) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *NamespacesJobsDeleteCall) Context(ctx context.Context) *NamespacesJobsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *NamespacesJobsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *NamespacesJobsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Delete a job.",
	//   "flatPath": "apis/run.googleapis.com/v1alpha1/namespaces/{namespacesId}/jobs/{jobsId}",
	//   "httpMethod": "DELETE",
	//   "id": "run.namespaces.jobs.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "apiVersion": {
	//       "description": "Optional. Cloud Run currently ignores this parameter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "kind": {
	//       "description": "Optional. Cloud Run currently ignores this parameter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The name of the job to delete. For Cloud Run (fully managed), replace {namespace_id} with the project ID or number.",
	//       "location": "path",
	//       "pattern": "^namespaces/[^/]+/jobs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "propagationPolicy": {
	//       "description": "Optional. Specifies the propagation policy of delete. Cloud Run currently ignores this setting, and deletes in the background. Please see kubernetes.io/docs/concepts/workloads/controllers/garbage-collection/ for more information.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "apis/run.googleapis.com/v1alpha1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "run.namespaces.jobs.get":

type NamespacesJobsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a job.
//
//   - name: The name of the job to retrieve. For Cloud Run (fully
//     managed), replace {namespace_id} with the project ID or number.
func (r *NamespacesJobsService) Get(name string) *NamespacesJobsGetCall {
	c := &NamespacesJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *NamespacesJobsGetCall) Fields(s ...googleapi.Field) *NamespacesJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *NamespacesJobsGetCall) IfNoneMatch(entityTag string) *NamespacesJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *NamespacesJobsGetCall) Context(ctx context.Context) *NamespacesJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *NamespacesJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.get" call.
// Exactly one of *Job or error will be non-nil. Any non-2xx status code
// is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesJobsGetCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get information about a job.",
	//   "flatPath": "apis/run.googleapis.com/v1alpha1/namespaces/{namespacesId}/jobs/{jobsId}",
	//   "httpMethod": "GET",
	//   "id": "run.namespaces.jobs.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the job to retrieve. For Cloud Run (fully managed), replace {namespace_id} with the project ID or number.",
	//       "location": "path",
	//       "pattern": "^namespaces/[^/]+/jobs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "apis/run.googleapis.com/v1alpha1/{+name}",
	//   "response": {
	//     "$ref": "Job"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "run.namespaces.jobs.list":

type NamespacesJobsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List jobs.
//
//   - parent: The namespace from which the jobs should be listed. Replace
//     {namespace_id} with the project ID or number.
func (r *NamespacesJobsService) List(parent string) *NamespacesJobsListCall {
	c := &NamespacesJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Optional encoded
// string to continue paging.
func (c *NamespacesJobsListCall) Continue(continue_ string) *NamespacesJobsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Allows to
// filter resources based on a specific value for a field name. Send
// this in a query string format. i.e. 'metadata.name%3Dlorem'. Not
// currently used by Cloud Run.
func (c *NamespacesJobsListCall) FieldSelector(fieldSelector string) *NamespacesJobsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter
// "includeUninitialized": Not currently used by Cloud Run.
func (c *NamespacesJobsListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesJobsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to
// filter resources based on a label. Supported operations are =, !=,
// exists, in, and notIn.
func (c *NamespacesJobsListCall) LabelSelector(labelSelector string) *NamespacesJobsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of
// records that should be returned.
func (c *NamespacesJobsListCall) Limit(limit int64) *NamespacesJobsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": The
// baseline resource version from which the list or watch operation
// should start. Not currently used by Cloud Run.
func (c *NamespacesJobsListCall) ResourceVersion(resourceVersion string) *NamespacesJobsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Flag that indicates that
// the client expects to watch this resource as well. Not currently used
// by Cloud Run.
func (c *NamespacesJobsListCall) Watch(watch bool) *NamespacesJobsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *NamespacesJobsListCall) Fields(s ...googleapi.Field) *NamespacesJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *NamespacesJobsListCall) IfNoneMatch(entityTag string) *NamespacesJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *NamespacesJobsListCall) Context(ctx context.Context) *NamespacesJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *NamespacesJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1alpha1/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.list" call.
// Exactly one of *ListJobsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListJobsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *NamespacesJobsListCall) Do(opts ...googleapi.CallOption) (*ListJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List jobs.",
	//   "flatPath": "apis/run.googleapis.com/v1alpha1/namespaces/{namespacesId}/jobs",
	//   "httpMethod": "GET",
	//   "id": "run.namespaces.jobs.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "continue": {
	//       "description": "Optional. Optional encoded string to continue paging.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "fieldSelector": {
	//       "description": "Optional. Allows to filter resources based on a specific value for a field name. Send this in a query string format. i.e. 'metadata.name%3Dlorem'. Not currently used by Cloud Run.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "includeUninitialized": {
	//       "description": "Optional. Not currently used by Cloud Run.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "labelSelector": {
	//       "description": "Optional. Allows to filter resources based on a label. Supported operations are =, !=, exists, in, and notIn.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "limit": {
	//       "description": "Optional. The maximum number of records that should be returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "parent": {
	//       "description": "Required. The namespace from which the jobs should be listed. Replace {namespace_id} with the project ID or number.",
	//       "location": "path",
	//       "pattern": "^namespaces/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "resourceVersion": {
	//       "description": "Optional. The baseline resource version from which the list or watch operation should start. Not currently used by Cloud Run.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "watch": {
	//       "description": "Optional. Flag that indicates that the client expects to watch this resource as well. Not currently used by Cloud Run.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "apis/run.googleapis.com/v1alpha1/{+parent}/jobs",
	//   "response": {
	//     "$ref": "ListJobsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
