/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.actions;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.actions.AbstractResultSetViewerAction;

public class BinaryFormatAction
extends AbstractResultSetViewerAction {
    private final String prefValue;
    private final DBDAttributeBinding attribute;

    public BinaryFormatAction(ResultSetViewer resultSetViewer, DBDBinaryFormatter formatter, DBDAttributeBinding attr) {
        super(resultSetViewer, formatter.getTitle(), 8);
        this.prefValue = formatter.getTitle();
        this.attribute = attr;
    }

    public boolean isChecked() {
        return this.getResultSetViewer().getPreferenceStore().getString("resultset.binary.representation").equalsIgnoreCase(this.prefValue);
    }

    public void run() {
        DBPDataSource dataSource = this.getResultSetViewer().getDataContainer().getDataSource();
        if (dataSource == null) {
            return;
        }
        DBPPreferenceStore preferenceStore = this.getActionPreferenceStore();
        String prefId = "resultset.binary.representation";
        preferenceStore.setValue(prefId, this.prefValue.toLowerCase());
        this.getTransformSettings().setCustomTransformer(prefId);
        dataSource.getContainer().persistConfiguration();
        this.getResultSetViewer().refreshData(null);
    }

    @NotNull
    DBVTransformSettings getTransformSettings() {
        DBVTransformSettings settings = DBVUtils.getTransformSettings((DBDAttributeBinding)this.attribute, (boolean)true);
        if (settings == null) {
            throw new IllegalStateException("Can't get/create transformer settings for '" + this.attribute.getFullyQualifiedName(DBPEvaluationContext.UI) + "'");
        }
        return settings;
    }

    DBPPreferenceStore getActionPreferenceStore() {
        return this.getResultSetViewer().getPreferenceStore();
    }
}

