/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	scheme "kubevirt.io/client-go/containerizeddataimporter/scheme"
	corev1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// DataImportCronsGetter has a method to return a DataImportCronInterface.
// A group's client should implement this interface.
type DataImportCronsGetter interface {
	DataImportCrons(namespace string) DataImportCronInterface
}

// DataImportCronInterface has methods to work with DataImportCron resources.
type DataImportCronInterface interface {
	Create(ctx context.Context, dataImportCron *corev1beta1.DataImportCron, opts v1.CreateOptions) (*corev1beta1.DataImportCron, error)
	Update(ctx context.Context, dataImportCron *corev1beta1.DataImportCron, opts v1.UpdateOptions) (*corev1beta1.DataImportCron, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, dataImportCron *corev1beta1.DataImportCron, opts v1.UpdateOptions) (*corev1beta1.DataImportCron, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*corev1beta1.DataImportCron, error)
	List(ctx context.Context, opts v1.ListOptions) (*corev1beta1.DataImportCronList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *corev1beta1.DataImportCron, err error)
	DataImportCronExpansion
}

// dataImportCrons implements DataImportCronInterface
type dataImportCrons struct {
	*gentype.ClientWithList[*corev1beta1.DataImportCron, *corev1beta1.DataImportCronList]
}

// newDataImportCrons returns a DataImportCrons
func newDataImportCrons(c *CdiV1beta1Client, namespace string) *dataImportCrons {
	return &dataImportCrons{
		gentype.NewClientWithList[*corev1beta1.DataImportCron, *corev1beta1.DataImportCronList](
			"dataimportcrons",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *corev1beta1.DataImportCron { return &corev1beta1.DataImportCron{} },
			func() *corev1beta1.DataImportCronList { return &corev1beta1.DataImportCronList{} },
		),
	}
}
