/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	snapshotv1beta1 "kubevirt.io/api/snapshot/v1beta1"
	scheme "kubevirt.io/client-go/kubevirt/scheme"
)

// VirtualMachineRestoresGetter has a method to return a VirtualMachineRestoreInterface.
// A group's client should implement this interface.
type VirtualMachineRestoresGetter interface {
	VirtualMachineRestores(namespace string) VirtualMachineRestoreInterface
}

// VirtualMachineRestoreInterface has methods to work with VirtualMachineRestore resources.
type VirtualMachineRestoreInterface interface {
	Create(ctx context.Context, virtualMachineRestore *snapshotv1beta1.VirtualMachineRestore, opts v1.CreateOptions) (*snapshotv1beta1.VirtualMachineRestore, error)
	Update(ctx context.Context, virtualMachineRestore *snapshotv1beta1.VirtualMachineRestore, opts v1.UpdateOptions) (*snapshotv1beta1.VirtualMachineRestore, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, virtualMachineRestore *snapshotv1beta1.VirtualMachineRestore, opts v1.UpdateOptions) (*snapshotv1beta1.VirtualMachineRestore, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*snapshotv1beta1.VirtualMachineRestore, error)
	List(ctx context.Context, opts v1.ListOptions) (*snapshotv1beta1.VirtualMachineRestoreList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *snapshotv1beta1.VirtualMachineRestore, err error)
	VirtualMachineRestoreExpansion
}

// virtualMachineRestores implements VirtualMachineRestoreInterface
type virtualMachineRestores struct {
	*gentype.ClientWithList[*snapshotv1beta1.VirtualMachineRestore, *snapshotv1beta1.VirtualMachineRestoreList]
}

// newVirtualMachineRestores returns a VirtualMachineRestores
func newVirtualMachineRestores(c *SnapshotV1beta1Client, namespace string) *virtualMachineRestores {
	return &virtualMachineRestores{
		gentype.NewClientWithList[*snapshotv1beta1.VirtualMachineRestore, *snapshotv1beta1.VirtualMachineRestoreList](
			"virtualmachinerestores",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *snapshotv1beta1.VirtualMachineRestore { return &snapshotv1beta1.VirtualMachineRestore{} },
			func() *snapshotv1beta1.VirtualMachineRestoreList { return &snapshotv1beta1.VirtualMachineRestoreList{} },
		),
	}
}
