/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xevent;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.xevent.MessageEventNotificationListener;
import org.jivesoftware.smackx.xevent.MessageEventRequestListener;
import org.jivesoftware.smackx.xevent.packet.MessageEvent;
import org.jxmpp.jid.Jid;

public final class MessageEventManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(MessageEventManager.class.getName());
    private static final Map<XMPPConnection, MessageEventManager> INSTANCES = new WeakHashMap<XMPPConnection, MessageEventManager>();
    private static final StanzaFilter PACKET_FILTER = new AndFilter(new StanzaExtensionFilter(new MessageEvent()), new NotFilter(MessageTypeFilter.ERROR));
    private final List<MessageEventNotificationListener> messageEventNotificationListeners = new CopyOnWriteArrayList<MessageEventNotificationListener>();
    private final List<MessageEventRequestListener> messageEventRequestListeners = new CopyOnWriteArrayList<MessageEventRequestListener>();

    public static synchronized MessageEventManager getInstanceFor(XMPPConnection connection) {
        MessageEventManager messageEventManager = INSTANCES.get(connection);
        if (messageEventManager == null) {
            messageEventManager = new MessageEventManager(connection);
            INSTANCES.put(connection, messageEventManager);
        }
        return messageEventManager;
    }

    private MessageEventManager(XMPPConnection connection) {
        super(connection);
        connection.addAsyncStanzaListener(new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Message message = (Message)packet;
                MessageEvent messageEvent = (MessageEvent)message.getExtensionElement("x", "jabber:x:event");
                if (messageEvent.isMessageEventRequest()) {
                    for (String eventType : messageEvent.getEventTypes()) {
                        MessageEventManager.this.fireMessageEventRequestListeners(message.getFrom(), message.getStanzaId(), eventType.concat("NotificationRequested"));
                    }
                } else {
                    for (String eventType : messageEvent.getEventTypes()) {
                        MessageEventManager.this.fireMessageEventNotificationListeners(message.getFrom(), messageEvent.getStanzaId(), eventType.concat("Notification"));
                    }
                }
            }
        }, PACKET_FILTER);
    }

    public static void addNotificationsRequests(Message message, boolean offline, boolean delivered, boolean displayed, boolean composing) {
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setOffline(offline);
        messageEvent.setDelivered(delivered);
        messageEvent.setDisplayed(displayed);
        messageEvent.setComposing(composing);
        message.addExtension(messageEvent);
    }

    public void addMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        this.messageEventRequestListeners.add(messageEventRequestListener);
    }

    public void removeMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        this.messageEventRequestListeners.remove(messageEventRequestListener);
    }

    public void addMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        this.messageEventNotificationListeners.add(messageEventNotificationListener);
    }

    public void removeMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        this.messageEventNotificationListeners.remove(messageEventNotificationListener);
    }

    private void fireMessageEventRequestListeners(Jid from, String packetID, String methodName) {
        try {
            Method method = MessageEventRequestListener.class.getDeclaredMethod(methodName, Jid.class, String.class, MessageEventManager.class);
            for (MessageEventRequestListener listener : this.messageEventRequestListeners) {
                method.invoke((Object)listener, from, packetID, this);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while invoking MessageEventRequestListener's  " + methodName, e);
        }
    }

    private void fireMessageEventNotificationListeners(Jid from, String packetID, String methodName) {
        try {
            Method method = MessageEventNotificationListener.class.getDeclaredMethod(methodName, Jid.class, String.class);
            for (MessageEventNotificationListener listener : this.messageEventNotificationListeners) {
                method.invoke((Object)listener, from, packetID);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while invoking MessageEventNotificationListener's " + methodName, e);
        }
    }

    public void sendDeliveredNotification(Jid to, String packetID) throws SmackException.NotConnectedException, InterruptedException {
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDelivered(true);
        messageEvent.setStanzaId(packetID);
        XMPPConnection connection = this.connection();
        Message msg = ((MessageBuilder)((MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to(to)).addExtension(messageEvent)).build();
        connection.sendStanza(msg);
    }

    public void sendDisplayedNotification(Jid to, String packetID) throws SmackException.NotConnectedException, InterruptedException {
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDisplayed(true);
        messageEvent.setStanzaId(packetID);
        XMPPConnection connection = this.connection();
        Message msg = ((MessageBuilder)((MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to(to)).addExtension(messageEvent)).build();
        connection.sendStanza(msg);
    }

    public void sendComposingNotification(Jid to, String packetID) throws SmackException.NotConnectedException, InterruptedException {
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setComposing(true);
        messageEvent.setStanzaId(packetID);
        XMPPConnection connection = this.connection();
        Message msg = ((MessageBuilder)((MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to(to)).addExtension(messageEvent)).build();
        connection.sendStanza(msg);
    }

    public void sendCancelledNotification(Jid to, String packetID) throws SmackException.NotConnectedException, InterruptedException {
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setCancelled(true);
        messageEvent.setStanzaId(packetID);
        XMPPConnection connection = this.connection();
        Message msg = ((MessageBuilder)((MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to(to)).addExtension(messageEvent)).build();
        this.connection().sendStanza(msg);
    }
}

