/*
 * Decompiled with CFR 0.152.
 */
package os.shaded_org_apache_tools_zip;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import os.shaded_org_apache_tools_zip.GeneralPurposeBit;
import os.shaded_org_apache_tools_zip.Zip64ExtendedInformationExtraField;
import os.shaded_org_apache_tools_zip.ZipEightByteInteger;
import os.shaded_org_apache_tools_zip.ZipEncoding;
import os.shaded_org_apache_tools_zip.ZipEncodingHelper;
import os.shaded_org_apache_tools_zip.ZipEntry;
import os.shaded_org_apache_tools_zip.ZipLong;
import os.shaded_org_apache_tools_zip.ZipOutputStream;
import os.shaded_org_apache_tools_zip.ZipShort;
import os.shaded_org_apache_tools_zip.ZipUtil;

public class ZipFile
implements Closeable {
    private static final int HASH_SIZE = 509;
    static final int NIBLET_MASK = 15;
    static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private final List<ZipEntry> entries = new LinkedList<ZipEntry>();
    private final Map<String, LinkedList<ZipEntry>> nameMap = new HashMap<String, LinkedList<ZipEntry>>(509);
    private final String encoding;
    private final ZipEncoding zipEncoding;
    private final String archiveName;
    private final RandomAccessFile archive;
    private final boolean useUnicodeExtraFields;
    private volatile boolean closed;
    private final byte[] DWORD_BUF = new byte[8];
    private final byte[] WORD_BUF = new byte[4];
    private final byte[] CFH_BUF = new byte[42];
    private final byte[] SHORT_BUF = new byte[2];
    private static final int CFH_LEN = 42;
    private static final long CFH_SIG = ZipLong.getValue(ZipOutputStream.CFH_SIG);
    private static final int MIN_EOCD_SIZE = 22;
    private static final int MAX_EOCD_SIZE = 65557;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final int ZIP64_EOCDL_LENGTH = 20;
    private static final int ZIP64_EOCDL_LOCATOR_OFFSET = 8;
    private static final int ZIP64_EOCD_CFD_LOCATOR_OFFSET = 48;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;
    private final Comparator<ZipEntry> OFFSET_COMPARATOR = (zipEntry, zipEntry2) -> {
        Entry entry;
        if (zipEntry == zipEntry2) {
            return 0;
        }
        Entry entry2 = zipEntry instanceof Entry ? (Entry)zipEntry : null;
        Entry entry3 = entry = zipEntry2 instanceof Entry ? (Entry)zipEntry2 : null;
        if (entry2 == null) {
            return 1;
        }
        if (entry == null) {
            return -1;
        }
        long l = entry2.getOffsetEntry().headerOffset - entry.getOffsetEntry().headerOffset;
        return l == 0L ? 0 : (l < 0L ? -1 : 1);
    };

    public ZipFile(File file) throws IOException {
        this(file, null);
    }

    public ZipFile(String string2) throws IOException {
        this(new File(string2), null);
    }

    public ZipFile(String string2, String string3) throws IOException {
        this(new File(string2), string3, true);
    }

    public ZipFile(File file, String string2) throws IOException {
        this(file, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile(File file, String string2, boolean bl) throws IOException {
        this.archiveName = file.getAbsolutePath();
        this.encoding = string2;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string2);
        this.useUnicodeExtraFields = bl;
        this.archive = new RandomAccessFile(file, "r");
        boolean bl2 = false;
        try {
            Map<ZipEntry, NameAndComment> map = this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData(map);
            bl2 = true;
            boolean bl3 = this.closed = !bl2;
        }
        catch (Throwable throwable) {
            boolean bl4 = this.closed = !bl2;
            if (!bl2) {
                try {
                    this.archive.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        if (!bl2) {
            try {
                this.archive.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.archive.close();
    }

    public static void closeQuietly(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Enumeration<ZipEntry> getEntries() {
        return Collections.enumeration(this.entries);
    }

    public Enumeration<ZipEntry> getEntriesInPhysicalOrder() {
        return this.entries.stream().sorted(this.OFFSET_COMPARATOR).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::enumeration));
    }

    public ZipEntry getEntry(String string2) {
        LinkedList<ZipEntry> linkedList = this.nameMap.get(string2);
        return linkedList != null ? linkedList.getFirst() : null;
    }

    public Iterable<ZipEntry> getEntries(String string2) {
        List<ZipEntry> list2 = (List<ZipEntry>)this.nameMap.get(string2);
        return list2 != null ? list2 : Collections.emptyList();
    }

    public Iterable<ZipEntry> getEntriesInPhysicalOrder(String string2) {
        if (this.nameMap.containsKey(string2)) {
            return this.nameMap.get(string2).stream().sorted(this.OFFSET_COMPARATOR).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean canReadEntryData(ZipEntry zipEntry) {
        return ZipUtil.canHandleEntryData(zipEntry);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException, ZipException {
        if (!(zipEntry instanceof Entry)) {
            return null;
        }
        OffsetEntry offsetEntry = ((Entry)zipEntry).getOffsetEntry();
        ZipUtil.checkRequestedFeatures(zipEntry);
        long l = offsetEntry.dataOffset;
        BoundedInputStream boundedInputStream = new BoundedInputStream(l, zipEntry.getCompressedSize());
        switch (zipEntry.getMethod()) {
            case 0: {
                return boundedInputStream;
            }
            case 8: {
                boundedInputStream.addDummy();
                final Inflater inflater = new Inflater(true);
                return new InflaterInputStream(boundedInputStream, inflater){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        inflater.end();
                    }
                };
            }
        }
        throw new ZipException("Found unsupported compression method " + zipEntry.getMethod());
    }

    public String getName() {
        return this.archiveName;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                System.err.printf("Cleaning up unclosed %s for archive %s%n", this.getClass().getSimpleName(), this.archiveName);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private Map<ZipEntry, NameAndComment> populateFromCentralDirectory() throws IOException {
        HashMap<ZipEntry, NameAndComment> hashMap = new HashMap<ZipEntry, NameAndComment>();
        this.positionAtCentralDirectory();
        this.archive.readFully(this.WORD_BUF);
        long l = ZipLong.getValue(this.WORD_BUF);
        if (l != CFH_SIG && this.startsWithLocalFileHeader()) {
            throw new IOException("central directory is empty, can't expand corrupt archive.");
        }
        while (l == CFH_SIG) {
            this.readCentralDirectoryEntry(hashMap);
            this.archive.readFully(this.WORD_BUF);
            l = ZipLong.getValue(this.WORD_BUF);
        }
        return hashMap;
    }

    private void readCentralDirectoryEntry(Map<ZipEntry, NameAndComment> map) throws IOException {
        this.archive.readFully(this.CFH_BUF);
        int n = 0;
        OffsetEntry offsetEntry = new OffsetEntry();
        Entry entry = new Entry(offsetEntry);
        int n2 = ZipShort.getValue(this.CFH_BUF, n);
        n += 2;
        entry.setPlatform(n2 >> 8 & 0xF);
        GeneralPurposeBit generalPurposeBit = GeneralPurposeBit.parse(this.CFH_BUF, n += 2);
        boolean bl = generalPurposeBit.usesUTF8ForNames();
        ZipEncoding zipEncoding = bl ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        entry.setGeneralPurposeBit(generalPurposeBit);
        entry.setMethod(ZipShort.getValue(this.CFH_BUF, n += 2));
        long l = ZipUtil.dosToJavaTime(ZipLong.getValue(this.CFH_BUF, n += 2));
        entry.setTime(l);
        entry.setCrc(ZipLong.getValue(this.CFH_BUF, n += 4));
        entry.setCompressedSize(ZipLong.getValue(this.CFH_BUF, n += 4));
        entry.setSize(ZipLong.getValue(this.CFH_BUF, n += 4));
        int n3 = ZipShort.getValue(this.CFH_BUF, n += 4);
        int n4 = ZipShort.getValue(this.CFH_BUF, n += 2);
        int n5 = ZipShort.getValue(this.CFH_BUF, n += 2);
        int n6 = ZipShort.getValue(this.CFH_BUF, n += 2);
        entry.setInternalAttributes(ZipShort.getValue(this.CFH_BUF, n += 2));
        entry.setExternalAttributes(ZipLong.getValue(this.CFH_BUF, n += 2));
        n += 4;
        if (this.archive.length() - this.archive.getFilePointer() < (long)n3) {
            throw new EOFException();
        }
        byte[] byArray = new byte[n3];
        this.archive.readFully(byArray);
        entry.setName(zipEncoding.decode(byArray), byArray);
        offsetEntry.headerOffset = ZipLong.getValue(this.CFH_BUF, n);
        this.entries.add(entry);
        if (this.archive.length() - this.archive.getFilePointer() < (long)n4) {
            throw new EOFException();
        }
        byte[] byArray2 = new byte[n4];
        this.archive.readFully(byArray2);
        entry.setCentralDirectoryExtra(byArray2);
        this.setSizesAndOffsetFromZip64Extra(entry, offsetEntry, n6);
        if (this.archive.length() - this.archive.getFilePointer() < (long)n5) {
            throw new EOFException();
        }
        byte[] byArray3 = new byte[n5];
        this.archive.readFully(byArray3);
        entry.setComment(zipEncoding.decode(byArray3));
        if (!bl && this.useUnicodeExtraFields) {
            map.put(entry, new NameAndComment(byArray, byArray3));
        }
    }

    private void setSizesAndOffsetFromZip64Extra(ZipEntry zipEntry, OffsetEntry offsetEntry, int n) throws IOException {
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)zipEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        if (zip64ExtendedInformationExtraField != null) {
            boolean bl = zipEntry.getSize() == 0xFFFFFFFFL;
            boolean bl2 = zipEntry.getCompressedSize() == 0xFFFFFFFFL;
            boolean bl3 = offsetEntry.headerOffset == 0xFFFFFFFFL;
            zip64ExtendedInformationExtraField.reparseCentralDirectoryData(bl, bl2, bl3, n == 65535);
            if (bl) {
                zipEntry.setSize(zip64ExtendedInformationExtraField.getSize().getLongValue());
            } else if (bl2) {
                zip64ExtendedInformationExtraField.setSize(new ZipEightByteInteger(zipEntry.getSize()));
            }
            if (bl2) {
                zipEntry.setCompressedSize(zip64ExtendedInformationExtraField.getCompressedSize().getLongValue());
            } else if (bl) {
                zip64ExtendedInformationExtraField.setCompressedSize(new ZipEightByteInteger(zipEntry.getCompressedSize()));
            }
            if (bl3) {
                offsetEntry.headerOffset = zip64ExtendedInformationExtraField.getRelativeHeaderOffset().getLongValue();
            }
        }
    }

    private void positionAtCentralDirectory() throws IOException {
        boolean bl;
        this.positionAtEndOfCentralDirectoryRecord();
        boolean bl2 = false;
        boolean bl3 = bl = this.archive.getFilePointer() > 20L;
        if (bl) {
            this.archive.seek(this.archive.getFilePointer() - 20L);
            this.archive.readFully(this.WORD_BUF);
            bl2 = Arrays.equals(ZipOutputStream.ZIP64_EOCD_LOC_SIG, this.WORD_BUF);
        }
        if (!bl2) {
            if (bl) {
                this.skipBytes(16);
            }
            this.positionAtCentralDirectory32();
        } else {
            this.positionAtCentralDirectory64();
        }
    }

    private void positionAtCentralDirectory64() throws IOException {
        this.skipBytes(4);
        this.archive.readFully(this.DWORD_BUF);
        this.archive.seek(ZipEightByteInteger.getLongValue(this.DWORD_BUF));
        this.archive.readFully(this.WORD_BUF);
        if (!Arrays.equals(this.WORD_BUF, ZipOutputStream.ZIP64_EOCD_SIG)) {
            throw new ZipException("archive's ZIP64 end of central directory locator is corrupt.");
        }
        this.skipBytes(44);
        this.archive.readFully(this.DWORD_BUF);
        this.archive.seek(ZipEightByteInteger.getLongValue(this.DWORD_BUF));
    }

    private void positionAtCentralDirectory32() throws IOException {
        this.skipBytes(16);
        this.archive.readFully(this.WORD_BUF);
        this.archive.seek(ZipLong.getValue(this.WORD_BUF));
    }

    private void positionAtEndOfCentralDirectoryRecord() throws IOException {
        boolean bl = this.tryToLocateSignature(22L, 65557L, ZipOutputStream.EOCD_SIG);
        if (!bl) {
            throw new ZipException("archive is not a ZIP archive");
        }
    }

    private boolean tryToLocateSignature(long l, long l2, byte[] byArray) throws IOException {
        long l3;
        boolean bl = false;
        long l4 = Math.max(0L, this.archive.length() - l2);
        if (l3 >= 0L) {
            for (l3 = this.archive.length() - l; l3 >= l4; --l3) {
                this.archive.seek(l3);
                int n = this.archive.read();
                if (n == -1) break;
                if (n != byArray[0] || (n = this.archive.read()) != byArray[1] || (n = this.archive.read()) != byArray[2] || (n = this.archive.read()) != byArray[3]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.archive.seek(l3);
        }
        return bl;
    }

    private void skipBytes(int n) throws IOException {
        int n2;
        for (int i = 0; i < n; i += n2) {
            n2 = this.archive.skipBytes(n - i);
            if (n2 > 0) continue;
            throw new EOFException();
        }
    }

    private void resolveLocalFileHeaderData(Map<ZipEntry, NameAndComment> map) throws IOException {
        for (ZipEntry zipEntry : this.entries) {
            Object object;
            Serializable serializable;
            int n;
            Entry entry = (Entry)zipEntry;
            OffsetEntry offsetEntry = entry.getOffsetEntry();
            long l = offsetEntry.headerOffset;
            this.archive.seek(l + 26L);
            this.archive.readFully(this.SHORT_BUF);
            int n2 = ZipShort.getValue(this.SHORT_BUF);
            this.archive.readFully(this.SHORT_BUF);
            int n3 = ZipShort.getValue(this.SHORT_BUF);
            for (int i = n2; i > 0; i -= n) {
                n = this.archive.skipBytes(i);
                if (n > 0) continue;
                throw new IOException("failed to skip file name in local file header");
            }
            if (this.archive.length() - this.archive.getFilePointer() < (long)n3) {
                throw new EOFException();
            }
            byte[] byArray = new byte[n3];
            this.archive.readFully(byArray);
            try {
                entry.setExtra(byArray);
            }
            catch (RuntimeException runtimeException) {
                serializable = new ZipException("Invalid extra data in entry " + entry.getName());
                ((Throwable)serializable).initCause(runtimeException);
                throw serializable;
            }
            offsetEntry.dataOffset = l + 26L + 2L + 2L + (long)n2 + (long)n3;
            if (map.containsKey(entry)) {
                object = map.get(entry);
                ZipUtil.setNameAndCommentFromExtraFields(entry, ((NameAndComment)object).name, ((NameAndComment)object).comment);
            }
            object = entry.getName();
            serializable = this.nameMap.computeIfAbsent((String)object, string2 -> new LinkedList());
            ((LinkedList)serializable).addLast(entry);
        }
    }

    private boolean startsWithLocalFileHeader() throws IOException {
        this.archive.seek(0L);
        this.archive.readFully(this.WORD_BUF);
        return Arrays.equals(this.WORD_BUF, ZipOutputStream.LFH_SIG);
    }

    private static class Entry
    extends ZipEntry {
        private final OffsetEntry offsetEntry;

        Entry(OffsetEntry offsetEntry) {
            this.offsetEntry = offsetEntry;
        }

        OffsetEntry getOffsetEntry() {
            return this.offsetEntry;
        }

        @Override
        public int hashCode() {
            return 3 * super.hashCode() + (int)(this.offsetEntry.headerOffset % Integer.MAX_VALUE);
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                Entry entry = (Entry)object;
                return this.offsetEntry.headerOffset == entry.offsetEntry.headerOffset && this.offsetEntry.dataOffset == entry.offsetEntry.dataOffset;
            }
            return false;
        }
    }

    private static final class NameAndComment {
        private final byte[] name;
        private final byte[] comment;

        private NameAndComment(byte[] byArray, byte[] byArray2) {
            this.name = byArray;
            this.comment = byArray2;
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;

        BoundedInputStream(long l, long l2) {
            this.remaining = l2;
            this.loc = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc++);
                return ZipFile.this.archive.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    byArray[n] = 0;
                    return 1;
                }
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if ((long)n2 > this.remaining) {
                n2 = (int)this.remaining;
            }
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc);
                n3 = ZipFile.this.archive.read(byArray, n, n2);
            }
            if (n3 > 0) {
                this.loc += (long)n3;
                this.remaining -= (long)n3;
            }
            return n3;
        }

        void addDummy() {
            this.addDummyByte = true;
        }
    }

    private static final class OffsetEntry {
        private long headerOffset = -1L;
        private long dataOffset = -1L;

        private OffsetEntry() {
        }
    }
}

