/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.modbus.BitArray;
import org.openhab.core.io.transport.modbus.ModbusReadRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusRegisterArray;

@NonNullByDefault
public class AsyncModbusReadResult {
    private final ModbusReadRequestBlueprint request;
    private final Optional<BitArray> bits;
    private final Optional<ModbusRegisterArray> registers;

    public AsyncModbusReadResult(ModbusReadRequestBlueprint request, ModbusRegisterArray registers) {
        Objects.requireNonNull(request, "Request must not be null!");
        Objects.requireNonNull(registers, "Registers must not be null!");
        this.request = request;
        this.registers = Optional.of(registers);
        this.bits = Optional.empty();
    }

    public AsyncModbusReadResult(ModbusReadRequestBlueprint request, BitArray bits) {
        Objects.requireNonNull(request, "Request must not be null!");
        Objects.requireNonNull(bits, "Bits must not be null!");
        this.request = request;
        this.registers = Optional.empty();
        this.bits = Optional.of(bits);
    }

    public ModbusReadRequestBlueprint getRequest() {
        return this.request;
    }

    public Optional<BitArray> getBits() {
        return this.bits;
    }

    public Optional<ModbusRegisterArray> getRegisters() {
        return this.registers;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AsyncModbusReadResult(");
        builder.append("request = ");
        builder.append(this.request);
        this.bits.ifPresent(bits -> {
            builder.append(", bits = ");
            builder.append(bits);
        });
        this.registers.ifPresent(registers -> {
            builder.append(", registers = ");
            builder.append(registers);
        });
        builder.append(")");
        return builder.toString();
    }
}

