/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;

public abstract class AbstractSearchResult<OBJECT_TYPE>
implements ISearchResult {
    private ISearchQuery searchQuery;
    private List<OBJECT_TYPE> objects = new ArrayList<OBJECT_TYPE>();
    private final List<ISearchResultListener> listeners = new ArrayList<ISearchResultListener>();

    public AbstractSearchResult(ISearchQuery searchQuery) {
        this.searchQuery = searchQuery;
    }

    public void addListener(ISearchResultListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ISearchResultListener l) {
        this.listeners.remove(l);
    }

    public String getLabel() {
        return this.searchQuery.getLabel();
    }

    public String getTooltip() {
        return this.searchQuery.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.searchQuery;
    }

    public List<OBJECT_TYPE> getObjects() {
        return this.objects;
    }

    public void addObjects(List<OBJECT_TYPE> objects) {
        this.objects.addAll(objects);
        this.fireChange(new DatabaseSearchResultEvent(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(SearchResultEvent e) {
        ISearchResultListener[] iSearchResultListenerArray = this.listeners;
        synchronized (this.listeners) {
            ISearchResultListener[] copiedListeners = this.listeners.toArray(new ISearchResultListener[this.listeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (ISearchResultListener listener : copiedListeners) {
                listener.searchResultChanged(e);
            }
            return;
        }
    }

    public class DatabaseSearchResultEvent
    extends SearchResultEvent {
        private final List<OBJECT_TYPE> objects;

        public DatabaseSearchResultEvent(List<OBJECT_TYPE> objects) {
            super((ISearchResult)AbstractSearchResult.this);
            this.objects = objects;
        }

        public List<OBJECT_TYPE> getObjects() {
            return this.objects;
        }
    }

    public static class DatabaseSearchFinishEvent
    extends SearchResultEvent {
        private final int totalObjects;

        public DatabaseSearchFinishEvent(ISearchResult searchResult, int totalObjects) {
            super(searchResult);
            this.totalObjects = totalObjects;
        }

        public int getTotalObjects() {
            return this.totalObjects;
        }
    }
}

