/* See notes in this header.  */
#include "taint-CVE-2020-13143.h"

struct configfs_attribute {
	/* [...snip...] */
	ssize_t (*store)(struct config_item *, const char *, size_t) /* { dg-message "\\(1\\) field 'store' of 'struct configfs_attribute' is marked with '__attribute__\\(\\(tainted_args\\)\\)'" } */
		__attribute__((tainted_args)); /* (this is added).  */
};

/* Highly simplified version.  */

static ssize_t gadget_dev_desc_UDC_store(struct config_item *item,
		const char *page, size_t len)
{
	/* TODO: ought to have state_change_event talking about where the tainted value comes from.  */

	char *name;
	/* [...snip...] */

	name = kstrdup(page, GFP_KERNEL);
	if (!name)
		return -ENOMEM;
	if (name[len - 1] == '\n') /* { dg-warning "use of attacker-controlled value 'len \[^\n\r\]+' as offset without upper-bounds checking" } */
		name[len - 1] = '\0';  /* { dg-warning "use of attacker-controlled value 'len \[^\n\r\]+' as offset without upper-bounds checking" } */
	/* [...snip...] */
	return 0;
}

CONFIGFS_ATTR(gadget_dev_desc_, UDC); /* { dg-message "\\(2\\) function 'gadget_dev_desc_UDC_store' used as initializer for field 'store' marked with '__attribute__\\(\\(tainted_args\\)\\)'" } */
