/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_el extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Μέση ώρα Γκρίνουιτς",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Χειμερινή ώρα Άκρε",
               "",
               "Θερινή ώρα Άκρε",
               "",
               "Ώρα Άκρε",
               "",
            };
        final String[] Apia = new String[] {
               "Χειμερινή ώρα Απία",
               "",
               "Θερινή ώρα Απία",
               "",
               "Ώρα Απία",
               "",
            };
        final String[] Cook = new String[] {
               "Χειμερινή ώρα Νήσων Κουκ",
               "",
               "Θερινή ώρα Νήσων Κουκ",
               "",
               "Ώρα Νήσων Κουκ",
               "",
            };
        final String[] Cuba = new String[] {
               "Χειμερινή ώρα Κούβας",
               "CST",
               "Θερινή ώρα Κούβας",
               "CDT",
               "Ώρα Κούβας",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Χειμερινή ώρα Φίτζι",
               "",
               "Θερινή ώρα Φίτζι",
               "",
               "Ώρα Φίτζι",
               "",
            };
        final String[] Gulf = new String[] {
               "Ώρα Κόλπου",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Χειμερινή ώρα Χοβντ",
               "",
               "Θερινή ώρα Χοβντ",
               "",
               "Ώρα Χοβντ",
               "",
            };
        final String[] Iran = new String[] {
               "Χειμερινή ώρα Ιράν",
               "",
               "Θερινή ώρα Ιράν",
               "",
               "Ώρα Ιράν",
               "",
            };
        final String[] Niue = new String[] {
               "Ώρα Νιούε",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Χειμερινή ώρα Ομσκ",
               "",
               "Θερινή ώρα Ομσκ",
               "",
               "Ώρα Ομσκ",
               "",
            };
        final String[] Peru = new String[] {
               "Χειμερινή ώρα Περού",
               "",
               "Θερινή ώρα Περού",
               "",
               "Ώρα Περού",
               "",
            };
        final String[] Truk = new String[] {
               "Ώρα Τσουκ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ώρα Νήσου Γουέικ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Χειμερινή ώρα Χιλής",
               "",
               "Θερινή ώρα Χιλής",
               "",
               "Ώρα Χιλής",
               "",
            };
        final String[] China = new String[] {
               "Χειμερινή ώρα Κίνας",
               "CST",
               "Θερινή ώρα Κίνας",
               "CDT",
               "Ώρα Κίνας",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Ώρα Νήσων Κόκος",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Ώρα Ντέιβις",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ώρα Ινδίας",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Χειμερινή ώρα Ιαπωνίας",
               "JST",
               "Θερινή ώρα Ιαπωνίας",
               "JDT",
               "Ώρα Ιαπωνίας",
               "JT",
            };
        final String[] Korea = new String[] {
               "Χειμερινή ώρα Κορέας",
               "KST",
               "Θερινή ώρα Κορέας",
               "KST",
               "Ώρα Κορέας",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Ώρα Ναούρου",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Ώρα Νεπάλ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Ώρα Παλάου",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Χειμερινή ώρα Σαμόα",
               "SST",
               "Θερινή ώρα Σαμόα",
               "SST",
               "Ώρα Σαμόα",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Ώρα Σίοβα",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Χειμερινή ώρα Τόνγκα",
               "",
               "Θερινή ώρα Τόνγκα",
               "",
               "Ώρα Τόνγκα",
               "",
            };
        final String[] Yukon = new String[] {
               "Ώρα Γιούκον",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Χειμερινή ώρα Αλάσκας",
               "AKST",
               "Θερινή ώρα Αλάσκας",
               "AKDT",
               "Ώρα Αλάσκας",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Χειμερινή ώρα Αμαζονίου",
               "",
               "Θερινή ώρα Αμαζονίου",
               "",
               "Ώρα Αμαζονίου",
               "",
            };
        final String[] Azores = new String[] {
               "Χειμερινή ώρα Αζορών",
               "",
               "Θερινή ώρα Αζορών",
               "",
               "Ώρα Αζορών",
               "",
            };
        final String[] Bhutan = new String[] {
               "Ώρα Μπουτάν",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Ώρα Μπρουνέι Νταρουσαλάμ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Χειμερινή ώρα Νήσου Πάσχα",
               "",
               "Θερινή ώρα Νήσου Πάσχα",
               "",
               "Ώρα Νήσου Πάσχα",
               "",
            };
        final String[] Guyana = new String[] {
               "Ώρα Γουιάνας",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Χειμερινή ώρα Χαβάης-Αλεούτιων Νήσων",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Χειμερινή ώρα Ισραήλ",
               "IST",
               "Θερινή ώρα Ισραήλ",
               "IDT",
               "Ώρα Ισραήλ",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Ώρα Κόσραϊ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Ώρα Μόσον",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Χειμερινή ώρα Μόσχας",
               "MSK",
               "Θερινή ώρα Μόσχας",
               "MSK",
               "Ώρα Μόσχας",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ώρα Πονάπε",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Χειμερινή ώρα Σάμαρας",
               "",
               "Θερινή ώρα Σαμάρας",
               "",
               "Ώρα Σάμαρας",
               "",
            };
        final String[] Tahiti = new String[] {
               "Ώρα Ταϊτής",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Χειμερινή ώρα Ταϊπέι",
               "CST",
               "Θερινή ώρα Ταϊπέι",
               "CDT",
               "Ώρα Ταϊπέι",
               "CT",
            };
        final String[] Turkey = new String[] {
               "Χειμερινή ώρα Τουρκίας",
               "",
               "Θερινή ώρα Τουρκίας",
               "",
               "Ώρα Τουρκίας",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Ώρα Τουβαλού",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Ώρα Βόστοκ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ώρα Ουάλις και Φουτούνα",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Αραβική χειμερινή ώρα",
               "",
               "Αραβική θερινή ώρα",
               "",
               "Αραβική ώρα",
               "",
            };
        final String[] Armenia = new String[] {
               "Χειμερινή ώρα Αρμενίας",
               "",
               "Θερινή ώρα Αρμενίας",
               "",
               "Ώρα Αρμενίας",
               "",
            };
        final String[] Bolivia = new String[] {
               "Ώρα Βολιβίας",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Χειμερινή ώρα Τσάταμ",
               "",
               "Θερινή ώρα Τσάταμ",
               "",
               "Ώρα Τσάταμ",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Συντονισμένη Παγκόσμια Ώρα",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ώρα Ισημερινού",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Ώρα Γκάμπιερ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Χειμερινή ώρα Γεωργίας",
               "",
               "Θερινή ώρα Γεωργίας",
               "",
               "Ώρα Γεωργίας",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Χειμερινή ώρα Ιρκούτσκ",
               "",
               "Θερινή ώρα Ιρκούτσκ",
               "",
               "Ώρα Ιρκούτσκ",
               "",
            };
        final String[] Magadan = new String[] {
               "Χειμερινή ώρα Μαγκαντάν",
               "",
               "Θερινή ώρα Μαγκαντάν",
               "",
               "Ώρα Μαγκαντάν",
               "",
            };
        final String[] Myanmar = new String[] {
               "Ώρα Μιανμάρ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Χειμερινή ώρα Νήσου Νόρφολκ",
               "",
               "Θερινή ώρα Νήσου Νόρφολκ",
               "",
               "Ώρα Νήσου Νόρφολκ",
               "",
            };
        final String[] Noronha = new String[] {
               "Χειμερινή ώρα Φερνάρντο ντε Νορόνια",
               "",
               "Θερινή ώρα Φερνάρντο ντε Νορόνια",
               "",
               "Ώρα Φερνάρντο ντε Νορόνια",
               "",
            };
        final String[] Reunion = new String[] {
               "Ώρα Ρεϊνιόν",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ώρα Ρόθερα",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Ώρα Νήσων Σολομώντος",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Ώρα Τοκελάου",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Χειμερινή ώρα Ουρουγουάης",
               "",
               "Θερινή ώρα Ουρουγουάης",
               "",
               "Ώρα Ουρουγουάης",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Χειμερινή ώρα Βανουάτου",
               "",
               "Θερινή ώρα Βανουάτου",
               "",
               "Ώρα Βανουάτου",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Χειμερινή ώρα Γιακούτσκ",
               "",
               "Θερινή ώρα Γιακούτσκ",
               "",
               "Ώρα Γιακούτσκ",
               "",
            };
        final String[] Atlantic = new String[] {
               "Χειμερινή ώρα Ατλαντικού",
               "AST",
               "Θερινή ώρα Ατλαντικού",
               "AST",
               "Ώρα Ατλαντικού",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Χειμερινή ώρα Μπραζίλιας",
               "",
               "Θερινή ώρα Μπραζίλιας",
               "",
               "Ώρα Μπραζίλιας",
               "",
            };
        final String[] Chamorro = new String[] {
               "Ώρα Τσαμόρο",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Χειμερινή ώρα Κολομβίας",
               "",
               "Θερινή ώρα Κολομβίας",
               "",
               "Ώρα Κολομβίας",
               "",
            };
        final String[] Falkland = new String[] {
               "Χειμερινή ώρα Νήσων Φόκλαντ",
               "",
               "Θερινή ώρα Νήσων Φόκλαντ",
               "",
               "Ώρα Νήσων Φόκλαντ",
               "",
            };
        final String[] Malaysia = new String[] {
               "Ώρα Μαλαισίας",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Ώρα Μαλδίβων",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Χειμερινή ώρα Ουλάν Μπατόρ",
               "",
               "Θερινή ώρα Ουλάν Μπατόρ",
               "",
               "Ώρα Ουλάν Μπατόρ",
               "",
            };
        final String[] Pakistan = new String[] {
               "Χειμερινή ώρα Πακιστάν",
               "PKT",
               "Θερινή ώρα Πακιστάν",
               "PKST",
               "Ώρα Πακιστάν",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Χειμερινή ώρα Παραγουάης",
               "",
               "Θερινή ώρα Παραγουάης",
               "",
               "Ώρα Παραγουάης",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Ώρα Πίτκερν",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Ώρα Σουρινάμ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Χειμερινή ώρα Αργεντινής",
               "",
               "Θερινή ώρα Αργεντινής",
               "",
               "Ώρα Αργεντινής",
               "",
            };
        final String[] Christmas = new String[] {
               "Ώρα Νήσου Χριστουγέννων",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Ώρα Γκαλάπαγκος",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Χειμερινή ώρα Χονγκ Κονγκ",
               "HKT",
               "Θερινή ώρα Χονγκ Κονγκ",
               "HKST",
               "Ώρα Χονγκ Κονγκ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ώρα Ινδοκίνας",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Χειμερινή ώρα Πετροπαβλόβσκ-Καμτσάτσκι",
               "",
               "Θερινή ώρα Πετροπαβλόβσκ-Καμτσάτσκι",
               "",
               "Ώρα Καμτσάτκα",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ώρα Κιργιστάν",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Χειμερινή ώρα Λορντ Χάου",
               "",
               "Θερινή ώρα Λορντ Χάου",
               "",
               "Ώρα Λορντ Χάου",
               "",
            };
        final String[] Marquesas = new String[] {
               "Ώρα Μαρκέζας",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Χειμερινή ώρα Μαυρίκιου",
               "",
               "Θερινή ώρα Μαυρίκιου",
               "",
               "Ώρα Μαυρίκιου",
               "",
            };
        final String[] Singapore = new String[] {
               "Ώρα Σιγκαπούρης",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Ώρα Βενεζουέλας",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Χειμερινή ώρα Αζερμπαϊτζάν",
               "",
               "Θερινή ώρα Αζερμπαϊτζάν",
               "",
               "Ώρα Αζερμπαϊτζάν",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Χειμερινή ώρα Μπανγκλαντές",
               "",
               "Θερινή ώρα Μπανγκλαντές",
               "",
               "Ώρα Μπανγκλαντές",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Χειμερινή ώρα Πράσινου Ακρωτηρίου",
               "",
               "Θερινή ώρα Πράσινου Ακρωτηρίου",
               "",
               "Ώρα Πράσινου Ακρωτηρίου",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ώρα Ανατολικού Τιμόρ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Ώρα Καζακστάν",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Ώρα Σεϋχελλών",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ώρα Τατζικιστάν",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Χειμερινή ώρα Ουζμπεκιστάν",
               "",
               "Θερινή ώρα Ουζμπεκιστάν",
               "",
               "Ώρα Ουζμπεκιστάν",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Ώρα Αφγανιστάν",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Χειμερινή ώρα Κρασνογιάρσκ",
               "",
               "Θερινή ώρα Κρασνογιάρσκ",
               "",
               "Ώρα Κρασνογιάρσκ",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Χειμερινή ώρα Νέας Ζηλανδίας",
               "NZST",
               "Θερινή ώρα Νέας Ζηλανδίας",
               "NZDT",
               "Ώρα Νέας Ζηλανδίας",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Χειμερινή ώρα Φιλιππινών",
               "PST",
               "Θερινή ώρα Φιλιππινών",
               "PDT",
               "Ώρα Φιλιππινών",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Χειμερινή ώρα Βλαδιβοστόκ",
               "",
               "Θερινή ώρα Βλαδιβοστόκ",
               "",
               "Ώρα Βλαδιβοστόκ",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ώρα Ινδικού Ωκεανού",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ώρα Νήσων Λάιν",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Χειμερινή ώρα Νέας Γης",
               "NST",
               "Θερινή ώρα Νέας Γης",
               "NDT",
               "Ώρα Νέας Γης",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Χειμερινή ώρα Τουρκμενιστάν",
               "",
               "Θερινή ώρα Τουρκμενιστάν",
               "",
               "Ώρα Τουρκμενιστάν",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ώρα Γαλλικής Γουιάνας",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Χειμερινή ώρα Νέας Καληδονίας",
               "",
               "Θερινή ώρα Νέας Καληδονίας",
               "",
               "Ώρα Νέας Καληδονίας",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ώρα Νότιας Γεωργίας",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Χειμερινή ώρα Αικατερινούπολης",
               "",
               "Θερινή ώρα Αικατερινούπολης",
               "",
               "Ώρα Αικατερινούπολης",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Ώρα Κεντρικής Αφρικής",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ώρα Ανατολικής Αφρικής",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Ώρα Δυτικής Αφρικής",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Ώρα Ντιμόν ντ’ Ουρβίλ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Χειμερινή ώρα Κεντρικής Ευρώπης",
               "CET",
               "Θερινή ώρα Κεντρικής Ευρώπης",
               "CEST",
               "Ώρα Κεντρικής Ευρώπης",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Χειμερινή ώρα Ανατολικής Ευρώπης",
               "EET",
               "Θερινή ώρα Ανατολικής Ευρώπης",
               "EEST",
               "Ώρα Ανατολικής Ευρώπης",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Χειμερινή ώρα Δυτικής Ευρώπης",
               "WET",
               "Θερινή ώρα Δυτικής Ευρώπης",
               "WEST",
               "Ώρα Δυτικής Ευρώπης",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Χειμερινή ώρα Ειρηνικού Μεξικού",
               "MST",
               "Θερινή ώρα Ειρηνικού Μεξικού",
               "MDT",
               "Ώρα Ειρηνικού Μεξικού",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Χειμερινή ώρα Νότιας Αφρικής",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Κεντρική χειμερινή ώρα Βόρειας Αμερικής",
               "CST",
               "Κεντρική θερινή ώρα Βόρειας Αμερικής",
               "CDT",
               "Κεντρική ώρα Βόρειας Αμερικής",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ανατολική χειμερινή ώρα Βόρειας Αμερικής",
               "EST",
               "Ανατολική θερινή ώρα Βόρειας Αμερικής",
               "EST",
               "Ανατολική ώρα Βόρειας Αμερικής",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Χειμερινή ώρα Ειρηνικού",
               "PST",
               "Θερινή ώρα Ειρηνικού",
               "PDT",
               "Ώρα Ειρηνικού",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Ώρα Γαλλικού Νότου και Ανταρκτικής",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ώρα Νήσων Γκίλμπερτ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Χειμερινή ώρα Χαβάης-Αλεούτιων Νήσων",
               "HST",
               "Θερινή ώρα Χαβάης-Αλεούτιων Νήσων",
               "HDT",
               "Ώρα Χαβάης-Αλεούτιων Νήσων",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ώρα Νήσων Φοίνιξ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Χειμερινή ώρα Σεν Πιερ και Μικελόν",
               "",
               "Θερινή ώρα Σεν Πιερ και Μικελόν",
               "",
               "Ώρα Σεν Πιερ και Μικελόν",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ορεινή χειμερινή ώρα Βόρειας Αμερικής",
               "MST",
               "Ορεινή θερινή ώρα Βόρειας Αμερικής",
               "MST",
               "Ορεινή ώρα Βόρειας Αμερικής",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Ώρα Νήσων Μάρσαλ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ώρα Παπούας Νέας Γουινέας",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Χειμερινή ώρα Κεντρικής Αυστραλίας",
               "ACST",
               "Θερινή ώρα Κεντρικής Αυστραλίας",
               "ACDT",
               "Ώρα Κεντρικής Αυστραλίας",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Χειμερινή ώρα Ανατολικής Αυστραλίας",
               "AEST",
               "Θερινή ώρα Ανατολικής Αυστραλίας",
               "AEDT",
               "Ώρα Ανατολικής Αυστραλίας",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Χειμερινή ώρα Δυτικής Αυστραλίας",
               "AWST",
               "Θερινή ώρα Δυτικής Αυστραλίας",
               "AWDT",
               "Ώρα Δυτικής Αυστραλίας",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ώρα Κεντρικής Ινδονησίας",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ώρα Ανατολικής Ινδονησίας",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ώρα Δυτικής Ινδονησίας",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Χειμερινή ώρα Κεντροδυτικής Αυστραλίας",
               "",
               "Θερινή ώρα Κεντροδυτικής Αυστραλίας",
               "",
               "Ώρα Κεντροδυτικής Αυστραλίας",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Μέση ώρα Γκρίνουιτς",
                    "GMT",
                    "Θερινή ώρα Βρετανίας",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Συντονισμένη Παγκόσμια Ώρα",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Μέση ώρα Γκρίνουιτς",
                    "GMT",
                    "Χειμερινή ώρα Ιρλανδίας",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Συντονισμένη Παγκόσμια Ώρα",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Συντονισμένη Παγκόσμια Ώρα",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Μέση ώρα Γκρίνουιτς",
                    "GMT",
                    "Θερινή ώρα Βρετανίας",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Συντονισμένη Παγκόσμια Ώρα",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Συντονισμένη Παγκόσμια Ώρα",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Συντονισμένη Παγκόσμια Ώρα",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Μέση ώρα Γκρίνουιτς",
                    "GMT",
                    "Χειμερινή ώρα Ιρλανδίας",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Μέση ώρα Γκρίνουιτς",
                    "GMT",
                    "Θερινή ώρα Βρετανίας",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Μέση ώρα Γκρίνουιτς",
                    "GMT",
                    "Θερινή ώρα Βρετανίας",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Μέση ώρα Γκρίνουιτς",
                    "GMT",
                    "Θερινή ώρα Βρετανίας",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Μέση ώρα Γκρίνουιτς",
                    "GMT",
                    "Θερινή ώρα Βρετανίας",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Μέση ώρα Γκρίνουιτς",
                    "GMT",
                    "Θερινή ώρα Βρετανίας",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Άντεν" },
            { "timezone.excity.Asia/Baku", "Μπακού" },
            { "timezone.excity.Asia/Dili", "Ντίλι" },
            { "timezone.excity.Asia/Gaza", "Γάζα" },
            { "timezone.excity.Asia/Hovd", "Χοβντ" },
            { "timezone.excity.Asia/Omsk", "Ομσκ" },
            { "timezone.excity.Asia/Oral", "Οράλ" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Αμμάν" },
            { "timezone.excity.Asia/Aqtau", "Ακτάου" },
            { "timezone.excity.Asia/Chita", "Τσιτά" },
            { "timezone.excity.Asia/Dhaka", "Ντάκα" },
            { "timezone.excity.Asia/Dubai", "Ντουμπάι" },
            { "timezone.excity.Asia/Kabul", "Καμπούλ" },
            { "timezone.excity.Asia/Macau", "Μακάο" },
            { "timezone.excity.Asia/Qatar", "Κατάρ" },
            { "timezone.excity.Asia/Seoul", "Σεούλ" },
            { "timezone.excity.Asia/Tokyo", "Τόκιο" },
            { "timezone.excity.Asia/Tomsk", "Τομσκ" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Τζούμπα" },
            { "timezone.excity.Africa/Lome", "Λομέ" },
            { "timezone.excity.Asia/Almaty", "Αλμάτι" },
            { "timezone.excity.Asia/Anadyr", "Αναντίρ" },
            { "timezone.excity.Asia/Aqtobe", "Ακτόμπε" },
            { "timezone.excity.Asia/Atyrau", "Ατιράου" },
            { "timezone.excity.Asia/Beirut", "Βυρητός" },
            { "timezone.excity.Asia/Brunei", "Μπρουνέι" },
            { "timezone.excity.Asia/Hebron", "Χεβρώνα" },
            { "timezone.excity.Asia/Kuwait", "Κουβέιτ" },
            { "timezone.excity.Asia/Manila", "Μανίλα" },
            { "timezone.excity.Asia/Muscat", "Μασκάτ" },
            { "timezone.excity.Asia/Riyadh", "Ριάντ" },
            { "timezone.excity.Asia/Saigon", "Πόλη Χο Τσι Μινχ" },
            { "timezone.excity.Asia/Taipei", "Ταϊπέι" },
            { "timezone.excity.Asia/Tehran", "Τεχεράνη" },
            { "timezone.excity.Asia/Urumqi", "Ουρούμτσι" },
            { "timezone.excity.Etc/Unknown", "Άγνωστη πόλη" },
            { "timezone.excity.Europe/Kiev", "Κίεβο" },
            { "timezone.excity.Europe/Oslo", "Όσλο" },
            { "timezone.excity.Europe/Riga", "Ρίγα" },
            { "timezone.excity.Europe/Rome", "Ρώμη" },
            { "timezone.excity.Indian/Mahe", "Μάχε" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Άκρα" },
            { "timezone.excity.Africa/Cairo", "Κάιρο" },
            { "timezone.excity.Africa/Ceuta", "Θέουτα" },
            { "timezone.excity.Africa/Dakar", "Ντακάρ" },
            { "timezone.excity.Africa/Lagos", "Λάγκος" },
            { "timezone.excity.Africa/Tunis", "Τύνιδα" },
            { "timezone.excity.America/Adak", "Άντακ" },
            { "timezone.excity.America/Lima", "Λίμα" },
            { "timezone.excity.America/Nome", "Νόμε" },
            { "timezone.excity.Asia/Baghdad", "Βαγδάτη" },
            { "timezone.excity.Asia/Bahrain", "Μπαχρέιν" },
            { "timezone.excity.Asia/Bangkok", "Μπανγκόκ" },
            { "timezone.excity.Asia/Barnaul", "Μπαρναούλ" },
            { "timezone.excity.Asia/Bishkek", "Μπισκέκ" },
            { "timezone.excity.Asia/Colombo", "Κολόμπο" },
            { "timezone.excity.Asia/Irkutsk", "Ιρκούτσκ" },
            { "timezone.excity.Asia/Jakarta", "Τζακάρτα" },
            { "timezone.excity.Asia/Karachi", "Καράτσι" },
            { "timezone.excity.Asia/Kuching", "Κουτσίνγκ" },
            { "timezone.excity.Asia/Magadan", "Μαγκαντάν" },
            { "timezone.excity.Asia/Nicosia", "Λευκωσία" },
            { "timezone.excity.Asia/Rangoon", "Ρανγκούν" },
            { "timezone.excity.Asia/Tbilisi", "Τιφλίδα" },
            { "timezone.excity.Asia/Thimphu", "Θίμφου" },
            { "timezone.excity.Asia/Yakutsk", "Γιακούτσκ" },
            { "timezone.excity.Asia/Yerevan", "Ερεβάν" },
            { "timezone.excity.Europe/Kirov", "Κίροφ" },
            { "timezone.excity.Europe/Malta", "Μάλτα" },
            { "timezone.excity.Europe/Minsk", "Μινσκ" },
            { "timezone.excity.Europe/Paris", "Παρίσι" },
            { "timezone.excity.Europe/Sofia", "Σόφια" },
            { "timezone.excity.Europe/Vaduz", "Βαντούζ" },
            { "timezone.excity.Indian/Cocos", "Κόκος" },
            { "timezone.excity.Pacific/Apia", "Απία" },
            { "timezone.excity.Pacific/Fiji", "Φίτζι" },
            { "timezone.excity.Pacific/Guam", "Γκουάμ" },
            { "timezone.excity.Pacific/Niue", "Νιούε" },
            { "timezone.excity.Pacific/Truk", "Τσουκ" },
            { "timezone.excity.Pacific/Wake", "Γουέικ" },
            { "timezone.excity.Africa/Asmera", "Ασμάρα" },
            { "timezone.excity.Africa/Bamako", "Μπαμάκο" },
            { "timezone.excity.Africa/Bangui", "Μπανγκί" },
            { "timezone.excity.Africa/Banjul", "Μπανζούλ" },
            { "timezone.excity.Africa/Bissau", "Μπισάου" },
            { "timezone.excity.Africa/Douala", "Ντουάλα" },
            { "timezone.excity.Africa/Harare", "Χαράρε" },
            { "timezone.excity.Africa/Kigali", "Κιγκάλι" },
            { "timezone.excity.Africa/Luanda", "Λουάντα" },
            { "timezone.excity.Africa/Lusaka", "Λουζάκα" },
            { "timezone.excity.Africa/Malabo", "Μαλάμπο" },
            { "timezone.excity.Africa/Maputo", "Μαπούτο" },
            { "timezone.excity.Africa/Maseru", "Μασέρου" },
            { "timezone.excity.Africa/Niamey", "Νιαμέι" },
            { "timezone.excity.America/Aruba", "Αρούμπα" },
            { "timezone.excity.America/Bahia", "Μπαΐα" },
            { "timezone.excity.America/Belem", "Μπελέμ" },
            { "timezone.excity.America/Boise", "Μπόιζι" },
            { "timezone.excity.America/Jujuy", "Χουχούι" },
            { "timezone.excity.America/Sitka", "Σίτκα" },
            { "timezone.excity.America/Thule", "Θούλη" },
            { "timezone.excity.Asia/Ashgabat", "Ασχαμπάτ" },
            { "timezone.excity.Asia/Calcutta", "Καλκούτα" },
            { "timezone.excity.Asia/Damascus", "Δαμασκός" },
            { "timezone.excity.Asia/Dushanbe", "Ντουσάνμπε" },
            { "timezone.excity.Asia/Jayapura", "Τζαγιαπούρα" },
            { "timezone.excity.Asia/Katmandu", "Κατμαντού" },
            { "timezone.excity.Asia/Khandyga", "Χαντίγκα" },
            { "timezone.excity.Asia/Makassar", "Μακασάρ" },
            { "timezone.excity.Asia/Qostanay", "Κοστανάι" },
            { "timezone.excity.Asia/Sakhalin", "Σαχαλίνη" },
            { "timezone.excity.Asia/Shanghai", "Σανγκάη" },
            { "timezone.excity.Asia/Tashkent", "Τασκένδη" },
            { "timezone.excity.Asia/Ust-Nera", "Ουστ-Νερά" },
            { "timezone.excity.Europe/Athens", "Αθήνα" },
            { "timezone.excity.Europe/Berlin", "Βερολίνο" },
            { "timezone.excity.Europe/Dublin", "Δουβλίνο" },
            { "timezone.excity.Europe/Jersey", "Τζέρσεϊ" },
            { "timezone.excity.Europe/Lisbon", "Λισαβόνα" },
            { "timezone.excity.Europe/London", "Λονδίνο" },
            { "timezone.excity.Europe/Madrid", "Μαδρίτη" },
            { "timezone.excity.Europe/Monaco", "Μονακό" },
            { "timezone.excity.Europe/Moscow", "Μόσχα" },
            { "timezone.excity.Europe/Prague", "Πράγα" },
            { "timezone.excity.Europe/Samara", "Σαμάρα" },
            { "timezone.excity.Europe/Skopje", "Σκόπια" },
            { "timezone.excity.Europe/Tirane", "Τίρανα" },
            { "timezone.excity.Europe/Vienna", "Βιέννη" },
            { "timezone.excity.Europe/Warsaw", "Βαρσοβία" },
            { "timezone.excity.Europe/Zagreb", "Ζάγκρεμπ" },
            { "timezone.excity.Europe/Zurich", "Ζυρίχη" },
            { "timezone.excity.Indian/Chagos", "Τσάγκος" },
            { "timezone.excity.Indian/Comoro", "Κομόρο" },
            { "timezone.excity.Pacific/Efate", "Εφάτε" },
            { "timezone.excity.Pacific/Nauru", "Ναούρου" },
            { "timezone.excity.Pacific/Palau", "Παλάου" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Αμπιτζάν" },
            { "timezone.excity.Africa/Algiers", "Αλγέρι" },
            { "timezone.excity.Africa/Conakry", "Κόνακρι" },
            { "timezone.excity.Africa/Kampala", "Καμπάλα" },
            { "timezone.excity.Africa/Mbabane", "Μπαμπάνε" },
            { "timezone.excity.Africa/Nairobi", "Ναϊρόμπι" },
            { "timezone.excity.Africa/Tripoli", "Τρίπολη" },
            { "timezone.excity.America/Belize", "Μπελίζ" },
            { "timezone.excity.America/Bogota", "Μπογκοτά" },
            { "timezone.excity.America/Cancun", "Κανκούν" },
            { "timezone.excity.America/Cayman", "Κέιμαν" },
            { "timezone.excity.America/Cuiaba", "Κουιαμπά" },
            { "timezone.excity.America/Dawson", "Ντόσον" },
            { "timezone.excity.America/Denver", "Ντένβερ" },
            { "timezone.excity.America/Guyana", "Γουιάνα" },
            { "timezone.excity.America/Havana", "Αβάνα" },
            { "timezone.excity.America/Inuvik", "Ινούβικ" },
            { "timezone.excity.America/Juneau", "Τζούνο" },
            { "timezone.excity.America/La_Paz", "Λα Παζ" },
            { "timezone.excity.America/Maceio", "Μασεϊό" },
            { "timezone.excity.America/Manaus", "Μανάους" },
            { "timezone.excity.America/Merida", "Μέριδα" },
            { "timezone.excity.America/Nassau", "Νασάου" },
            { "timezone.excity.America/Panama", "Παναμάς" },
            { "timezone.excity.America/Recife", "Ρεσίφε" },
            { "timezone.excity.America/Regina", "Ρετζάινα" },
            { "timezone.excity.Asia/Famagusta", "Αμμόχωστος" },
            { "timezone.excity.Asia/Hong_Kong", "Χονγκ Κονγκ" },
            { "timezone.excity.Asia/Jerusalem", "Ιερουσαλήμ" },
            { "timezone.excity.Asia/Kamchatka", "Καμτσάτκα" },
            { "timezone.excity.Asia/Pontianak", "Πόντιανακ" },
            { "timezone.excity.Asia/Pyongyang", "Πιονγκγιάνγκ" },
            { "timezone.excity.Asia/Qyzylorda", "Κιζιλορντά" },
            { "timezone.excity.Asia/Samarkand", "Σαμαρκάνδη" },
            { "timezone.excity.Asia/Singapore", "Σιγκαπούρη" },
            { "timezone.excity.Asia/Vientiane", "Βιεντιάν" },
            { "timezone.excity.Europe/Andorra", "Ανδόρα" },
            { "timezone.excity.Europe/Saratov", "Σαράτοφ" },
            { "timezone.excity.Europe/Tallinn", "Ταλίν" },
            { "timezone.excity.Europe/Vatican", "Βατικανό" },
            { "timezone.excity.Europe/Vilnius", "Βίλνιους" },
            { "timezone.excity.Indian/Mayotte", "Μαγιότ" },
            { "timezone.excity.Indian/Reunion", "Ρεϊνιόν" },
            { "timezone.excity.Pacific/Easter", "Νήσος Πάσχα" },
            { "timezone.excity.Pacific/Kosrae", "Κόσραϊ" },
            { "timezone.excity.Pacific/Majuro", "Ματζούρο" },
            { "timezone.excity.Pacific/Midway", "Μίντγουεϊ" },
            { "timezone.excity.Pacific/Noumea", "Νουμέα" },
            { "timezone.excity.Pacific/Ponape", "Πονάπε" },
            { "timezone.excity.Pacific/Saipan", "Σαϊπάν" },
            { "timezone.excity.Pacific/Tahiti", "Ταϊτή" },
            { "timezone.excity.Pacific/Tarawa", "Ταράουα" },
            { "timezone.excity.Pacific/Wallis", "Γουάλις" },
            { "timezone.excity.Africa/Blantyre", "Μπλαντάιρ" },
            { "timezone.excity.Africa/Djibouti", "Τζιμπουτί" },
            { "timezone.excity.Africa/El_Aaiun", "Ελ Αγιούν" },
            { "timezone.excity.Africa/Freetown", "Φρίταουν" },
            { "timezone.excity.Africa/Gaborone", "Γκαμπορόνε" },
            { "timezone.excity.Africa/Khartoum", "Χαρτούμ" },
            { "timezone.excity.Africa/Kinshasa", "Κινσάσα" },
            { "timezone.excity.Africa/Monrovia", "Μονρόβια" },
            { "timezone.excity.Africa/Ndjamena", "Ντζαμένα" },
            { "timezone.excity.Africa/Sao_Tome", "Σάο Τομέ" },
            { "timezone.excity.Africa/Windhoek", "Βίντχουκ" },
            { "timezone.excity.America/Antigua", "Αντίγκουα" },
            { "timezone.excity.America/Caracas", "Καράκας" },
            { "timezone.excity.America/Cayenne", "Καγιέν" },
            { "timezone.excity.America/Chicago", "Σικάγο" },
            { "timezone.excity.America/Cordoba", "Κόρδοβα" },
            { "timezone.excity.America/Creston", "Κρέστον" },
            { "timezone.excity.America/Curacao", "Κουρασάο" },
            { "timezone.excity.America/Detroit", "Ντιτρόιτ" },
            { "timezone.excity.America/Godthab", "Νουούκ" },
            { "timezone.excity.America/Grenada", "Γρενάδα" },
            { "timezone.excity.America/Halifax", "Χάλιφαξ" },
            { "timezone.excity.America/Iqaluit", "Ικαλούιτ" },
            { "timezone.excity.America/Jamaica", "Τζαμάικα" },
            { "timezone.excity.America/Managua", "Μανάγκουα" },
            { "timezone.excity.America/Marigot", "Μαριγκό" },
            { "timezone.excity.America/Mendoza", "Μεντόζα" },
            { "timezone.excity.America/Moncton", "Μόνκτον" },
            { "timezone.excity.America/Noronha", "Νορόνια" },
            { "timezone.excity.America/Ojinaga", "Οχινάγκα" },
            { "timezone.excity.America/Phoenix", "Φοίνιξ" },
            { "timezone.excity.America/Tijuana", "Τιχουάνα" },
            { "timezone.excity.America/Toronto", "Τορόντο" },
            { "timezone.excity.America/Tortola", "Τορτόλα" },
            { "timezone.excity.America/Yakutat", "Γιάκουτατ" },
            { "timezone.excity.Asia/Phnom_Penh", "Πνομ Πενχ" },
            { "timezone.excity.Atlantic/Azores", "Αζόρες" },
            { "timezone.excity.Atlantic/Canary", "Κανάρια" },
            { "timezone.excity.Atlantic/Faeroe", "Φερόες" },
            { "timezone.excity.Australia/Eucla", "Γιούκλα" },
            { "timezone.excity.Australia/Perth", "Περθ" },
            { "timezone.excity.Europe/Belgrade", "Βελιγράδι" },
            { "timezone.excity.Europe/Brussels", "Βρυξέλλες" },
            { "timezone.excity.Europe/Budapest", "Βουδαπέστη" },
            { "timezone.excity.Europe/Busingen", "Μπίσινγκεν" },
            { "timezone.excity.Europe/Chisinau", "Κισινάου" },
            { "timezone.excity.Europe/Guernsey", "Γκέρνζι" },
            { "timezone.excity.Europe/Helsinki", "Ελσίνκι" },
            { "timezone.excity.Europe/Istanbul", "Κωνσταντινούπολη" },
            { "timezone.excity.Europe/Sarajevo", "Σαράγεβο" },
            { "timezone.excity.Indian/Maldives", "Μαλδίβες" },
            { "timezone.excity.Pacific/Chatham", "Τσάταμ" },
            { "timezone.excity.Pacific/Fakaofo", "Φακαόφο" },
            { "timezone.excity.Pacific/Gambier", "Γκάμπιερ" },
            { "timezone.excity.Pacific/Norfolk", "Νόρφολκ" },
            { "timezone.excity.Africa/Bujumbura", "Μπουζουμπούρα" },
            { "timezone.excity.Africa/Mogadishu", "Μογκαντίσου" },
            { "timezone.excity.America/Anguilla", "Ανγκουίλα" },
            { "timezone.excity.America/Asuncion", "Ασουνσιόν" },
            { "timezone.excity.America/Barbados", "Μπαρμπέιντος" },
            { "timezone.excity.America/Dominica", "Ντομίνικα" },
            { "timezone.excity.America/Edmonton", "Έντμοντον" },
            { "timezone.excity.America/Eirunepe", "Εϊρουνεπέ" },
            { "timezone.excity.America/Mazatlan", "Μαζατλάν" },
            { "timezone.excity.America/Miquelon", "Μικελόν" },
            { "timezone.excity.America/New_York", "Νέα Υόρκη" },
            { "timezone.excity.America/Resolute", "Ρέζολουτ" },
            { "timezone.excity.America/Santarem", "Σανταρέμ" },
            { "timezone.excity.America/Santiago", "Σαντιάγκο" },
            { "timezone.excity.America/St_Johns", "Σεν Τζονς" },
            { "timezone.excity.America/St_Kitts", "Σεν Κιτς" },
            { "timezone.excity.America/St_Lucia", "Αγία Λουκία" },
            { "timezone.excity.America/Winnipeg", "Γουίνιπεγκ" },
            { "timezone.excity.Antarctica/Casey", "Κάσεϊ" },
            { "timezone.excity.Antarctica/Davis", "Ντέιβις" },
            { "timezone.excity.Antarctica/Syowa", "Σίοβα" },
            { "timezone.excity.Antarctica/Troll", "Τρολ" },
            { "timezone.excity.Asia/Krasnoyarsk", "Κρασνογιάρσκ" },
            { "timezone.excity.Asia/Novosibirsk", "Νοβοσιμπίρσκ" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ουλάν Μπατόρ" },
            { "timezone.excity.Asia/Vladivostok", "Βλαδιβοστόκ" },
            { "timezone.excity.Atlantic/Bermuda", "Βερμούδες" },
            { "timezone.excity.Atlantic/Madeira", "Μαδέρα" },
            { "timezone.excity.Atlantic/Stanley", "Στάνλεϊ" },
            { "timezone.excity.Australia/Darwin", "Ντάργουιν" },
            { "timezone.excity.Australia/Hobart", "Χόμπαρτ" },
            { "timezone.excity.Australia/Sydney", "Σίδνεϊ" },
            { "timezone.excity.Europe/Amsterdam", "Άμστερνταμ" },
            { "timezone.excity.Europe/Astrakhan", "Αστραχάν" },
            { "timezone.excity.Europe/Bucharest", "Βουκουρέστι" },
            { "timezone.excity.Europe/Gibraltar", "Γιβραλτάρ" },
            { "timezone.excity.Europe/Ljubljana", "Λιουμπλιάνα" },
            { "timezone.excity.Europe/Mariehamn", "Μάριεχαμν" },
            { "timezone.excity.Europe/Podgorica", "Ποντγκόριτσα" },
            { "timezone.excity.Europe/Stockholm", "Στοκχόλμη" },
            { "timezone.excity.Europe/Ulyanovsk", "Ουλιάνοφσκ" },
            { "timezone.excity.Europe/Volgograd", "Βόλγκοκραντ" },
            { "timezone.excity.Indian/Christmas", "Νήσος Χριστουγέννων" },
            { "timezone.excity.Indian/Kerguelen", "Κεργκελέν" },
            { "timezone.excity.Indian/Mauritius", "Μαυρίκιος" },
            { "timezone.excity.Pacific/Auckland", "Όκλαντ" },
            { "timezone.excity.Pacific/Funafuti", "Φουναφούτι" },
            { "timezone.excity.Pacific/Honolulu", "Χονολουλού" },
            { "timezone.excity.Pacific/Pitcairn", "Πίτκερν" },
            { "timezone.excity.Africa/Casablanca", "Καζαμπλάνκα" },
            { "timezone.excity.Africa/Libreville", "Λιμπρεβίλ" },
            { "timezone.excity.Africa/Lubumbashi", "Λουμπουμπάσι" },
            { "timezone.excity.Africa/Nouakchott", "Νουακσότ" },
            { "timezone.excity.Africa/Porto-Novo", "Πόρτο-Νόβο" },
            { "timezone.excity.America/Anchorage", "Άνκορατζ" },
            { "timezone.excity.America/Araguaina", "Αραγκουάινα" },
            { "timezone.excity.America/Boa_Vista", "Μπόα Βίστα" },
            { "timezone.excity.America/Catamarca", "Καταμάρκα" },
            { "timezone.excity.America/Chihuahua", "Τσιουάουα" },
            { "timezone.excity.America/Coyhaique", "Κοϊάικε" },
            { "timezone.excity.America/Fortaleza", "Φορταλέζα" },
            { "timezone.excity.America/Glace_Bay", "Γκλέις Μπέι" },
            { "timezone.excity.America/Goose_Bay", "Γκους Μπέι" },
            { "timezone.excity.America/Guatemala", "Γουατεμάλα" },
            { "timezone.excity.America/Guayaquil", "Γκουαγιακίλ" },
            { "timezone.excity.America/Matamoros", "Ματαμόρος" },
            { "timezone.excity.America/Menominee", "Μενομίνε" },
            { "timezone.excity.America/Monterrey", "Μοντερέι" },
            { "timezone.excity.America/Sao_Paulo", "Σάο Πάολο" },
            { "timezone.excity.America/St_Thomas", "Άγιος Θωμάς" },
            { "timezone.excity.America/Vancouver", "Βανκούβερ" },
            { "timezone.excity.Antarctica/Mawson", "Μόσον" },
            { "timezone.excity.Antarctica/Palmer", "Πάλμερ" },
            { "timezone.excity.Antarctica/Vostok", "Βόστοκ" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Κουάλα Λουμπούρ" },
            { "timezone.excity.Asia/Novokuznetsk", "Νοβοκουζνέτσκ" },
            { "timezone.excity.Europe/Bratislava", "Μπρατισλάβα" },
            { "timezone.excity.Europe/Copenhagen", "Κοπεγχάγη" },
            { "timezone.excity.Europe/Luxembourg", "Λουξεμβούργο" },
            { "timezone.excity.Europe/San_Marino", "Άγιος Μαρίνος" },
            { "timezone.excity.Europe/Simferopol", "Συμφερόπολη" },
            { "timezone.excity.Pacific/Enderbury", "Καντών" },
            { "timezone.excity.Pacific/Galapagos", "Γκαλάπαγκος" },
            { "timezone.excity.Pacific/Kwajalein", "Κουατζαλέιν" },
            { "timezone.excity.Pacific/Marquesas", "Μαρκέζας" },
            { "timezone.excity.Pacific/Pago_Pago", "Πάγκο Πάγκο" },
            { "timezone.excity.Pacific/Rarotonga", "Ραροτόνγκα" },
            { "timezone.excity.Pacific/Tongatapu", "Τονγκατάπου" },
            { "timezone.excity.Africa/Addis_Ababa", "Αντίς Αμπέμπα" },
            { "timezone.excity.Africa/Brazzaville", "Μπραζαβίλ" },
            { "timezone.excity.Africa/Ouagadougou", "Ουαγκαντούγκου" },
            { "timezone.excity.America/Costa_Rica", "Κόστα Ρίκα" },
            { "timezone.excity.America/Grand_Turk", "Γκραντ Τουρκ" },
            { "timezone.excity.America/Guadeloupe", "Γουαδελούπη" },
            { "timezone.excity.America/Hermosillo", "Ερμοσίγιο" },
            { "timezone.excity.America/Kralendijk", "Κράλεντικ" },
            { "timezone.excity.America/Louisville", "Λούιβιλ" },
            { "timezone.excity.America/Martinique", "Μαρτινίκα" },
            { "timezone.excity.America/Metlakatla", "Μετλακάτλα" },
            { "timezone.excity.America/Montevideo", "Μοντεβιδέο" },
            { "timezone.excity.America/Montserrat", "Μονσεράτ" },
            { "timezone.excity.America/Paramaribo", "Παραμαρίμπο" },
            { "timezone.excity.America/Rio_Branco", "Ρίο Μπράνκο" },
            { "timezone.excity.America/St_Vincent", "Άγιος Βικέντιος" },
            { "timezone.excity.America/Whitehorse", "Γουάιτχορς" },
            { "timezone.excity.Antarctica/McMurdo", "Μακμέρντο" },
            { "timezone.excity.Antarctica/Rothera", "Ρόθερα" },
            { "timezone.excity.Asia/Srednekolymsk", "Σρεντνεκολίμσκ" },
            { "timezone.excity.Asia/Yekaterinburg", "Αικατερινούπολη" },
            { "timezone.excity.Atlantic/Reykjavik", "Ρέυκιαβικ" },
            { "timezone.excity.Atlantic/St_Helena", "Αγ. Ελένη" },
            { "timezone.excity.Australia/Adelaide", "Αδελαΐδα" },
            { "timezone.excity.Australia/Brisbane", "Μπρισμπέιν" },
            { "timezone.excity.Australia/Lindeman", "Λίντεμαν" },
            { "timezone.excity.Europe/Isle_of_Man", "Νήσος του Μαν" },
            { "timezone.excity.Europe/Kaliningrad", "Καλίνινγκραντ" },
            { "timezone.excity.Pacific/Kiritimati", "Κιριτιμάτι" },
            { "timezone.excity.Africa/Johannesburg", "Γιοχάνεσμπουργκ" },
            { "timezone.excity.America/El_Salvador", "Ελ Σαλβαδόρ" },
            { "timezone.excity.America/Fort_Nelson", "Φορτ Νέλσον" },
            { "timezone.excity.America/Los_Angeles", "Λος Άντζελες" },
            { "timezone.excity.America/Mexico_City", "Πόλη του Μεξικού" },
            { "timezone.excity.America/Porto_Velho", "Πόρτο Βέλιο" },
            { "timezone.excity.America/Puerto_Rico", "Πουέρτο Ρίκο" },
            { "timezone.excity.America/Tegucigalpa", "Τεγκουσιγκάλπα" },
            { "timezone.excity.Arctic/Longyearbyen", "Λόνγκιεαρμπιεν" },
            { "timezone.excity.Atlantic/Cape_Verde", "Πράσινο Ακρωτήριο" },
            { "timezone.excity.Australia/Lord_Howe", "Λορντ Χάου" },
            { "timezone.excity.Australia/Melbourne", "Μελβούρνη" },
            { "timezone.excity.Indian/Antananarivo", "Ανταναναρίβο" },
            { "timezone.excity.Pacific/Guadalcanal", "Γκουανταλκανάλ" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Νταρ ες Σαλάμ" },
            { "timezone.excity.America/Blanc-Sablon", "Μπλαν Σαμπλόν" },
            { "timezone.excity.America/Buenos_Aires", "Μπουένος Άιρες" },
            { "timezone.excity.America/Campo_Grande", "Κάμπο Γκράντε" },
            { "timezone.excity.America/Danmarkshavn", "Ντανμαρκσάβν" },
            { "timezone.excity.America/Dawson_Creek", "Ντόσον Κρικ" },
            { "timezone.excity.America/Indiana/Knox", "Νοξ, Ιντιάνα" },
            { "timezone.excity.America/Indianapolis", "Ιντιανάπολις" },
            { "timezone.excity.America/Punta_Arenas", "Πούντα Αρένας" },
            { "timezone.excity.America/Rankin_Inlet", "Ράνκιν Ίνλετ" },
            { "timezone.excity.America/Scoresbysund", "Σκορεσμπίσουντ" },
            { "timezone.excity.Antarctica/Macquarie", "Μακουάρι" },
            { "timezone.excity.Pacific/Bougainville", "Μπουγκενβίλ" },
            { "timezone.excity.Pacific/Port_Moresby", "Πορτ Μόρεσμπι" },
            { "timezone.excity.America/Cambridge_Bay", "Κέμπριτζ Μπέι" },
            { "timezone.excity.America/Ciudad_Juarez", "Σιουδάδ Χουάρες" },
            { "timezone.excity.America/Coral_Harbour", "Ατικόκαν" },
            { "timezone.excity.America/Indiana/Vevay", "Βιβέι, Ιντιάνα" },
            { "timezone.excity.America/Port_of_Spain", "Πορτ οφ Σπέιν" },
            { "timezone.excity.America/Santo_Domingo", "Άγιος Δομίνικος" },
            { "timezone.excity.America/St_Barthelemy", "Άγιος Βαρθολομαίος" },
            { "timezone.excity.America/Swift_Current", "Σουίφτ Κάρεντ" },
            { "timezone.excity.Australia/Broken_Hill", "Μπρόκεν Χιλ" },
            { "timezone.excity.America/Bahia_Banderas", "Μπαΐα ντε Μπαντέρας" },
            { "timezone.excity.America/Port-au-Prince", "Πορτ-ο-Πρενς" },
            { "timezone.excity.Atlantic/South_Georgia", "Νότια Γεωργία" },
            { "timezone.excity.America/Argentina/Salta", "Σάλτα" },
            { "timezone.excity.America/Indiana/Marengo", "Μαρένγκο, Ιντιάνα" },
            { "timezone.excity.America/Indiana/Winamac", "Γουίναμακ, Ιντιάνα" },
            { "timezone.excity.America/Argentina/Tucuman", "Τουκουμάν" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ουσουάια" },
            { "timezone.excity.America/Indiana/Tell_City", "Τελ Σίτι, Ιντιάνα" },
            { "timezone.excity.America/Indiana/Vincennes", "Βανσέν, Ιντιάνα" },
            { "timezone.excity.Antarctica/DumontDUrville", "Ντιμόν ντ’ Ουρβίλ" },
            { "timezone.excity.America/Argentina/La_Rioja", "Λα Ριόχα" },
            { "timezone.excity.America/Argentina/San_Juan", "Σαν Χουάν" },
            { "timezone.excity.America/Argentina/San_Luis", "Σαν Λούις" },
            { "timezone.excity.America/Indiana/Petersburg", "Πίτερσμπεργκ, Ιντιάνα" },
            { "timezone.excity.America/Kentucky/Monticello", "Μοντιτσέλο, Κεντάκι" },
            { "timezone.excity.America/North_Dakota/Beulah", "Μπέουλα, Βόρεια Ντακότα" },
            { "timezone.excity.America/North_Dakota/Center", "Σέντερ, Βόρεια Ντακότα" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Ρίο Γκαγιέγκος" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Νιου Σέιλεμ, Βόρεια Ντακότα" },
        };
        return data;
    }
}
