# MySQL, MariaDB and Percona References

This document provides a curated list of official documentations, specialized blogs, and expert resources for MySQL, MariaDB, and Percona Server.

## 🏛️ Official Documentations by Theme

### 🚀 Optimization & Performance Tuning
- **MySQL**: [Optimization Chapter](https://dev.mysql.com/doc/refman/8.4/en/optimization.html) (SQL, Data, I/O, Memory)
- **MariaDB**: [Optimization and Tuning KB](https://mariadb.com/kb/en/optimization-and-tuning/)
- **Percona**: [MySQL Performance Optimization Basics](https://www.percona.com/blog/mysql-performance-optimization-basics-2024/)
- **Percona**: [PMM (Monitoring & Management) Documentation](https://www.percona.com/doc/percona-monitoring-and-management/latest/index.html)

### 🛡️ Security & Access Control
- **MySQL**: [Security Chapter](https://dev.mysql.com/doc/refman/8.4/en/security.html) (Access Control, SSL/TLS)
- **MariaDB**: [User and Server Security KB](https://mariadb.com/kb/en/user-server-security/)
- **Percona**: [Security Best Practices for MySQL](https://www.percona.com/blog/mysql-security-best-practices-2024/)
- **MySQL**: [Password Validation Plugin](https://dev.mysql.com/doc/refman/8.4/en/password-validation.html)

### ⚙️ Administration & Configuration
- **MySQL**: [Server Administration](https://dev.mysql.com/doc/refman/8.4/en/admin-scripts.html)
- **MariaDB**: [Server System Variables](https://mariadb.com/kb/en/server-system-variables/)
- **Percona**: [Percona Server Configuration](https://www.percona.com/doc/percona-server/latest/configuration.html)
- **MySQL**: [Status Variables](https://dev.mysql.com/doc/refman/8.4/en/server-status-variables.html)

### 💾 Backup, Restore & Disaster Recovery
- **MySQL**: [Backup and Recovery Guide](https://dev.mysql.com/doc/refman/8.4/en/backup-and-recovery.html)
- **MariaDB**: [Backup and Restore KB](https://mariadb.com/kb/en/backup-and-restore-overview/)
- **Percona**: [Percona XtraBackup Documentation](https://www.percona.com/doc/percona-xtrabackup/latest/index.html)
- **MySQL**: [MySQL Enterprise Backup (MEB)](https://dev.mysql.com/doc/mysql-enterprise-backup/en/)

### ⛓️ High Availability, Replication & Clustering
- **MySQL**: [Replication Guide](https://dev.mysql.com/doc/refman/8.4/en/replication.html) (Asynchronous, Semi-sync, GTID)
- **MySQL**: [InnoDB Cluster / Group Replication](https://dev.mysql.com/doc/refman/8.4/en/mysql-innodb-cluster-introduction.html)
- **MariaDB**: [Replication KB](https://mariadb.com/kb/en/replication/)
- **MariaDB**: [Galera Cluster Documentation](https://mariadb.com/kb/en/galera-cluster/)
- **Percona**: [Percona XtraDB Cluster (PXC)](https://www.percona.com/doc/percona-xtradb-cluster/8.0/index.html)

### 🏗️ Storage Engines & Architecture
- **MySQL**: [Alternative Storage Engines](https://dev.mysql.com/doc/refman/8.4/en/storage-engines.html)
- **MariaDB**: [Storage Engines KB](https://mariadb.com/kb/en/storage-engines/)
- **Percona**: [XtraDB (Enhanced InnoDB)](https://www.percona.com/doc/percona-server/8.0/innodb/xtradb.html)
- **Percona**: [MyRocks Documentation](https://www.percona.com/doc/percona-server/8.0/myrocks/index.html)

## 🏎️ Product Blogs & Engineering

- [MySQL Server Blog](https://dev.mysql.com/blog/) - News from the MySQL Team (Oracle)
- [MariaDB Foundation Blog](https://mariadb.org/blog/) - Development updates and foundation news
- [Percona Database Performance Blog](https://www.percona.com/blog/) - Deep dives into performance and troubleshooting

## � Deep Dive Subsections (Expert Articles)

### InnoDB Internals
- [InnoDB Flushing Mechanisms](https://www.percona.com/blog/2020/01/22/innodb-flushing-in-mysql-8-0-explained/)
- [Dynamic Redo Log Capacity](https://lefred.be/content/mysql-8-0-30-dynamic-innodb-redo-log-capacity/)
- [Primary Key Optimization](https://lefred.be/content/mysql-innodb-primary-keys/)

### Advanced Clusters
- [Galera Advanced Tuning](https://galeracluster.com/library/training/tutorials/galera-tuning.html)
- [MySQL Shell AdminAPI](https://dev.mysql.com/doc/mysql-shell/8.4/en/admin-api.html)
- [MySQL Router Bootstrapping](https://dev.mysql.com/doc/mysql-router/8.4/en/mysql-router-deploying-bootstrapping.html)

## 👨‍� Community Experts

- [lefred.be](https://lefred.be/) - Frédéric Descamps (MySQL Performance)
- [jfg-mysql.blogspot.com](http://jfg-mysql.blogspot.com/) - Jean-François Gagné (MySQL Internals)
- [dasini.net](https://dasini.net/blog/) - Olivier Dasini (MySQL Expert Diary)
