package automation

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ObjectDataTypesClient is the automation Client
type ObjectDataTypesClient struct {
	BaseClient
}

// NewObjectDataTypesClient creates an instance of the ObjectDataTypesClient client.
func NewObjectDataTypesClient(subscriptionID string) ObjectDataTypesClient {
	return NewObjectDataTypesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewObjectDataTypesClientWithBaseURI creates an instance of the ObjectDataTypesClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewObjectDataTypesClientWithBaseURI(baseURI string, subscriptionID string) ObjectDataTypesClient {
	return ObjectDataTypesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListFieldsByModuleAndType retrieve a list of fields of a given type identified by module name.
// Parameters:
// resourceGroupName - name of an Azure Resource group.
// automationAccountName - the name of the automation account.
// moduleName - the name of module.
// typeName - the name of type.
func (client ObjectDataTypesClient) ListFieldsByModuleAndType(ctx context.Context, resourceGroupName string, automationAccountName string, moduleName string, typeName string) (result TypeFieldListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ObjectDataTypesClient.ListFieldsByModuleAndType")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("automation.ObjectDataTypesClient", "ListFieldsByModuleAndType", err.Error())
	}

	req, err := client.ListFieldsByModuleAndTypePreparer(ctx, resourceGroupName, automationAccountName, moduleName, typeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.ObjectDataTypesClient", "ListFieldsByModuleAndType", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFieldsByModuleAndTypeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "automation.ObjectDataTypesClient", "ListFieldsByModuleAndType", resp, "Failure sending request")
		return
	}

	result, err = client.ListFieldsByModuleAndTypeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.ObjectDataTypesClient", "ListFieldsByModuleAndType", resp, "Failure responding to request")
		return
	}

	return
}

// ListFieldsByModuleAndTypePreparer prepares the ListFieldsByModuleAndType request.
func (client ObjectDataTypesClient) ListFieldsByModuleAndTypePreparer(ctx context.Context, resourceGroupName string, automationAccountName string, moduleName string, typeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"automationAccountName": autorest.Encode("path", automationAccountName),
		"moduleName":            autorest.Encode("path", moduleName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
		"typeName":              autorest.Encode("path", typeName),
	}

	const APIVersion = "2015-10-31"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}/objectDataTypes/{typeName}/fields", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListFieldsByModuleAndTypeSender sends the ListFieldsByModuleAndType request. The method will close the
// http.Response Body if it receives an error.
func (client ObjectDataTypesClient) ListFieldsByModuleAndTypeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListFieldsByModuleAndTypeResponder handles the response to the ListFieldsByModuleAndType request. The method always
// closes the http.Response Body.
func (client ObjectDataTypesClient) ListFieldsByModuleAndTypeResponder(resp *http.Response) (result TypeFieldListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListFieldsByType retrieve a list of fields of a given type across all accessible modules.
// Parameters:
// resourceGroupName - name of an Azure Resource group.
// automationAccountName - the name of the automation account.
// typeName - the name of type.
func (client ObjectDataTypesClient) ListFieldsByType(ctx context.Context, resourceGroupName string, automationAccountName string, typeName string) (result TypeFieldListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ObjectDataTypesClient.ListFieldsByType")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("automation.ObjectDataTypesClient", "ListFieldsByType", err.Error())
	}

	req, err := client.ListFieldsByTypePreparer(ctx, resourceGroupName, automationAccountName, typeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.ObjectDataTypesClient", "ListFieldsByType", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFieldsByTypeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "automation.ObjectDataTypesClient", "ListFieldsByType", resp, "Failure sending request")
		return
	}

	result, err = client.ListFieldsByTypeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.ObjectDataTypesClient", "ListFieldsByType", resp, "Failure responding to request")
		return
	}

	return
}

// ListFieldsByTypePreparer prepares the ListFieldsByType request.
func (client ObjectDataTypesClient) ListFieldsByTypePreparer(ctx context.Context, resourceGroupName string, automationAccountName string, typeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"automationAccountName": autorest.Encode("path", automationAccountName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
		"typeName":              autorest.Encode("path", typeName),
	}

	const APIVersion = "2015-10-31"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/objectDataTypes/{typeName}/fields", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListFieldsByTypeSender sends the ListFieldsByType request. The method will close the
// http.Response Body if it receives an error.
func (client ObjectDataTypesClient) ListFieldsByTypeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListFieldsByTypeResponder handles the response to the ListFieldsByType request. The method always
// closes the http.Response Body.
func (client ObjectDataTypesClient) ListFieldsByTypeResponder(resp *http.Response) (result TypeFieldListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
