package appmallsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TaobaoFilmGetShowComments invokes the appmallsservice.TaobaoFilmGetShowComments API synchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetshowcomments.html
func (client *Client) TaobaoFilmGetShowComments(request *TaobaoFilmGetShowCommentsRequest) (response *TaobaoFilmGetShowCommentsResponse, err error) {
	response = CreateTaobaoFilmGetShowCommentsResponse()
	err = client.DoAction(request, response)
	return
}

// TaobaoFilmGetShowCommentsWithChan invokes the appmallsservice.TaobaoFilmGetShowComments API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetshowcomments.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetShowCommentsWithChan(request *TaobaoFilmGetShowCommentsRequest) (<-chan *TaobaoFilmGetShowCommentsResponse, <-chan error) {
	responseChan := make(chan *TaobaoFilmGetShowCommentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TaobaoFilmGetShowComments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TaobaoFilmGetShowCommentsWithCallback invokes the appmallsservice.TaobaoFilmGetShowComments API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetshowcomments.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetShowCommentsWithCallback(request *TaobaoFilmGetShowCommentsRequest, callback func(response *TaobaoFilmGetShowCommentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TaobaoFilmGetShowCommentsResponse
		var err error
		defer close(result)
		response, err = client.TaobaoFilmGetShowComments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TaobaoFilmGetShowCommentsRequest is the request struct for api TaobaoFilmGetShowComments
type TaobaoFilmGetShowCommentsRequest struct {
	*requests.RpcRequest
	ShowId     requests.Integer `position:"Query" name:"ShowId"`
	PageIndex  requests.Integer `position:"Query" name:"PageIndex"`
	ParamsJson string           `position:"Query" name:"ParamsJson"`
}

// TaobaoFilmGetShowCommentsResponse is the response struct for api TaobaoFilmGetShowComments
type TaobaoFilmGetShowCommentsResponse struct {
	*responses.BaseResponse
	ErrorCode   string            `json:"ErrorCode" xml:"ErrorCode"`
	Msg         string            `json:"Msg" xml:"Msg"`
	SubCode     string            `json:"SubCode" xml:"SubCode"`
	SubMsg      string            `json:"SubMsg" xml:"SubMsg"`
	Count       int64             `json:"Count" xml:"Count"`
	LogsId      string            `json:"LogsId" xml:"LogsId"`
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	CommentList []CommentListItem `json:"CommentList" xml:"CommentList"`
}

// CreateTaobaoFilmGetShowCommentsRequest creates a request to invoke TaobaoFilmGetShowComments API
func CreateTaobaoFilmGetShowCommentsRequest() (request *TaobaoFilmGetShowCommentsRequest) {
	request = &TaobaoFilmGetShowCommentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AppMallsService", "2018-02-24", "TaobaoFilmGetShowComments", "", "")
	return
}

// CreateTaobaoFilmGetShowCommentsResponse creates a response to parse from TaobaoFilmGetShowComments response
func CreateTaobaoFilmGetShowCommentsResponse() (response *TaobaoFilmGetShowCommentsResponse) {
	response = &TaobaoFilmGetShowCommentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
